<?php
/**
* 
* @author muhongwei
* @copyright			(C) 2009-2011 DirCMS
* @lastmodify			2012-02-10 14:53
*/

// ȫ滻
function safehtml($str,$rtype=4)
{
	$str=stripslashes($str);
	switch($rtype)
	{
		case '0': //  htmlspecialchars() ֱ滻
			$str=htmlspecialchars($str);
			break;
		case '1': //  htmlspecialchars() 滻ȥհַ
			$str=htmlspecialchars($str);
			$str=preg_replace('/[\s\v]{1,}/','',$str);
			break;
		case '2': //  htmlspecialchars() 滻ȥпհַ
			$str=htmlspecialchars($str);
			$str=preg_replace('/[\s\v]/','',$str);
			break;
		case '3': //  strip_tags() 滻ȥпհַ
			$str=strip_tags($str);
			$str=preg_replace('/[\s\v]/','',$str);
			break;
		default: // ȥ iframe,link,meta ȿXSSĴ
			$str=preg_replace('/[\s\v]/',' ',$str);
			$str=preg_replace('/script/i','',$str);
			$str=preg_replace('/<[\/]?(link|ifra|fra|meta)[^>]*>/i','',$str);
			break;
	}
	return addslashes($str);
}

function batsafehtml($str,$rtype=4)
{
	if(is_string($str))return safehtml($str,$rtype);
	foreach($str as $key => $value)
	{
		$str[$key]=batsafehtml($value,$rtype);
	}
	return $str;
}

// ĿIDȡĿ
function catname($catid)
{
	$r=cache_read('cat'.intval($catid).'.cache.php',DIRCMS_ROOT.'data/cache_category/');
	return $r?$r['catname']:'δ֪Ŀ';
}

// ĿIDȡĿURL
function caturl($catid)
{
	global $DIRCMS;
	$r=cache_read('cat'.intval($catid).'.cache.php',DIRCMS_ROOT.'data/cache_category/');
	return $r?$r['url']:$DIRCMS['site_url'];
}

// 
function more($catid=0,$menu='',$style="")
{
	global $baselang;
	$style=$style?' class="'.$style.'" ':'';
	$menu=trim($menu);
	$r=cache_read('cat'.intval($catid).'.cache.php',DIRCMS_ROOT.'data/cache_category/');
	if(!$r || !$catid)return $baselang['undefined'];
	else{
		return '<a href="'.$r['url'].'" title="'.$r['catname'].'" '.$style.' target="_blank">'.($menu?$menu:$baselang['more']).'</a>';
	}
}

// ȡļչ 
function get_fileext($file)
{
	return strtolower(substr(strrchr($file,'.'),1));
}

// жǷΪͼƬжϺ׺
function is_image($file)
{
	return in_array(get_fileext($file),array('gif','jpg','jpeg','png','bmp'));
}

// жǷΪƵжϺ׺
function is_vedio($file)
{
	return in_array(get_fileext($file),array('swf','flv'));
}

// һıתͼƬʾ
function strtojpg($str,$width='100',$height='24')
{
	global $DIRCMS;
	$str=trim($str);
	if($str)
	{
		return '<img align="top" width="'.intval($width).'" height="'.intval($height).'" src="'.$DIRCMS['site_url'].'api/imcode/authcode.php?str='.urlencode(base64_encode($str)).'" />';
	}
	else
	{
		return $str;
	}
}

// жԶļǷ
function file_exists_url($url)
{
	if(substr($url,0,7)!='http://' && substr($url,0,6)!='ftp://')
	{
		return file_exists(DIRCMS_ROOT.$url);
	}

	if(extension_loaded('curl'))
	{
		$curl = curl_init($url); 
		curl_setopt($curl, CURLOPT_NOBODY, true); 
		curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'GET');
		$result = curl_exec($curl); 
		$feedback = false; 

		if ($result !== false)  
		{ 
			$statusCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);   
			if ($statusCode == 200) 
			{ 
				$feedback = true;    
			} 
		} 
		curl_close($curl); 
		return $feedback; 
	}
	else
	{
		$feedback=@get_headers($url);
		return stripos($feedback[0], '200') ? true : false;
	}
}

//ȡһıڵͼƬַ
function get_images($str)
{
	preg_match_all('/<img(.+?)src=[\'\"]?([^\'\"]+)[\'\"]?/i',stripslashes($str),$matches,PREG_PATTERN_ORDER);
	$r=array();
	$t=$matches[2];

	foreach($t as $_t)
	{
		if(is_image($_t))$r[]=$_t;
	}
	return $r;
}

// ָͼƬͼ,ԶͼƬػ 2011-7-6  mime ͷļ
function createthumb($img,$thumb=1,$thumb_width=100,$thumb_height=100,$ctype=1)
{
	global $DIRCMS;
	if(!in_array(get_fileext($img),array('jpg','gif','png','bmp','jpeg')))return $DIRCMS['site_url'].'images/nopic.gif';
	if(strtolower(substr($img,0,7))=='http://')
	{	
		if(!file_exists_url($img))return $DIRCMS['site_url'].'images/nopic.gif';
		$filename=basename($img);
		$randname=substr(md5($img),8,16).'.'.get_fileext($img);

		if(!file_exists('upload/image/'.$randname))
		{
			$file=@file_get_contents($img,true);
			if($file)
			{
				$fp=@fopen(DIRCMS_ROOT.'upload/image/'.$randname,'a');
				@fwrite($fp,$file);
				@fclose($fp);
			}
		}
		if(is_array(@getimagesize(DIRCMS_ROOT.'upload/image/'.$randname)))
		{
			$img='upload/image/'.$randname;
		}
		else
		{
			@unlink(DIRCMS_ROOT.'upload/image/'.$randname);
			return $DIRCMS['site_url'].'images/nopic.gif';
		}
	}
	if(!file_exists($img))return $DIRCMS['site_url'].'images/nopic.gif';
	if(!extension_loaded('gd') || !function_exists('imagecreate'))return $img;

	/*
		Ƿͼ
	*/
	if($thumb)
	{
		$info=imageinfo($img);
		$thumb_w=intval($thumb_width)?intval($thumb_width):THUMB_WIDTH;
		$thumb_h=intval($thumb_width)?intval($thumb_width):THUMB_HEIGHT;
		
		if($ctype==1) // ձͼ
		{
			$scale=min(1,min($thumb_width/$info['width'],$thumb_height/$info['height'])); //
			$thumb_width=intval($info['width']*$scale);
			$thumb_height=intval($info['height']*$scale);
		}
		else // չ̶ͼ
		{
			$thumb_width=intval($thumb_width);
			$thumb_height=intval($thumb_height);
		}
		$createfunc='imagecreatefrom'.($info['type']=='jpg'?'jpeg':$info['type']);
		$im=$createfunc($img);
		$thumb_im=$info['type']!='gif' && function_exists('imagecreatetruecolor')?imagecreatetruecolor($thumb_width,$thumb_height):imagecreate($thumb_width,$thumb_height);
		imagecopyresampled($thumb_im,$im,0,0,0,0,$thumb_width,$thumb_height,$info['width'],$info['height']);
		if($info['type']=='gif' || $info['type']=='png')
		{
			$bgcolor=imagecolorallocate($thumb_im,0,255,0);
			imagecolortransparent($thumb_im,$bgcolor);
		}
		$imagefunc='image'.($info['type']=='jpg'?'jpeg':$info['type']);
		$thumbname='thumb_'.$info['name'].'_'.$thumb_width.'x'.$thumb_height.'.'.$info['type'];
		$imagefunc($thumb_im,$info['path'].$thumbname);
		imagedestroy($im);
		imagedestroy($thumb_im);
		return $info['path'].$thumbname;
	}
	else
	{
		return $img;
	}
}

// ȡͼƬϢ
function imageinfo($img)
{
	$imginfo=$info=array();
	$t=basename($img);
	$t=explode('.',$t);
	$info['name']=$t[0];
	$info['size']=filesize($img);
	$imginfo=getimagesize($img);
	$info['width']=$imginfo[0];
	$info['height']=$imginfo[1];
	$info['width_height']=$imginfo[3];
	$info['mime']=$imginfo['mime'];
	unset($imginfo);
	$imginfo=pathinfo($img);
	$info['path']=$imginfo['dirname'].'/'; 
	$info['type']=strtolower($imginfo['extension']); //ͼƬչ'.'
	unset($imginfo);
	return $info;
}

// 滻ͼƬaltǩ 
function add_alt($str,$alt='')
{
	return addslashes(preg_replace('/<img(.+)(alt=[\'\"]?[^\'\"]*[\'\"]?)/i','<img\\1alt="'.$alt.'"',stripslashes($str)));
}

function txt_urlencode($t,$str)
{
	return $t."\"".urlencode($str)."\"";
}

function txt_urldecode($t,$str)
{
	return $t."\"".urldecode($str)."\"";
}

function txt_urlencode2($t,$str)
{
	return $t.urlencode($str).'</a>';
}

function txt_urldecode2($t,$str)
{
	return $t.urldecode($str).'</a>';
}

// ǰҳַ
function getcururl()
{
	$cur='';
	if(isset($_SERVER['REQUEST_URI']))$cur=$_SERVER['REQUEST_URI'];
	else if(isset($_SERVER['PHP_SELF']) && isset($_SERVER['argv']))$cur=$_SERVER['PHP_SELF'].'?'.$_SERVER['argv'][0];
	else $cur=$_SERVER['PHP_SELF'].'?'.$_SERVER['QUERY_STRING'];
	return strip_tags($cur);
}

// ǰһҳַ
function getpreurl()
{
	return isset($_SERVER['HTTP_REFERER']) && $_SERVER['HTTP_REFERER'] ? mysql_real_escape_string(strip_tags($_SERVER['HTTP_REFERER'])):'';
}

function dircms_stripslashes($str)
{
	if(!is_array($str))return stripslashes($str);
	foreach($str as $key => $value)
	{
		$str[$key]=dircms_stripslashes($value);
	}
	return $str;
}

function dircms_addslashes($str)
{
	if(!is_array($str))return addslashes($str);
	foreach($str as $key=>$value)
	{
		$str[$key]=dircms_addslashes($value);
	}
	return $str;
}

function dircms_htmlspecialchars($str)
{
	if(!is_array($str))return htmlspecialchars($str);
	foreach($str as $key=>$value)
	{
		$str[$key]=dircms_htmlspecialchars($value);
	}
	return $str;
}


// ǿ str_split() (ʺ)
function strsplit($str,$split_length=1,$charcode='GBK')
{
	$split_length=intval($split_length)>0?intval($split_length):1;

	if(strtoupper($charcode)=='GBK')
	{
		$str=iconv("GBK", "UTF-8", $str);
		preg_match_all('/.{'.$split_length.'}|[^\x00]{1,'.$split_length.'}$/us', $str, $ar);
		if($ar[0])foreach($ar[0] as $key => $value)
		{
			$ar[0][$key]=iconv("UTF-8", "GBK//IGNORE", $value);
		}
	}
	else
	{
		preg_match_all('/.{'.$split_length.'}|[^\x00]{1,'.$split_length.'}$/us', $str, $ar);
	}
	return $ar[0];
}

// ַȡ(GBK)
function sub_string($string, $length, $dot='')
{
	$string=trim($string);
	$strlen = strlen($string);
	if($strlen <= $length) return $string;
	$string = str_replace(array('&nbsp;', '&amp;', '&quot;', '&#039;', '&ldquo;', '&rdquo;', '&mdash;', '&lt;', '&gt;', '&middot;', '&hellip;'), array(' ', '&', '"', "'", '', '', '', '<', '>', '', ''), $string);
	$strcut = '';
	$dotlen = strlen($dot);
	$maxi = $length - $dotlen - 1;
	for($i = 0; $i < $maxi; $i++)
	{
		$strcut .= ord($string[$i]) > 127 ? $string[$i].$string[++$i] : $string[$i];
	}
	$strcut = str_replace(array('&', '"', "'", '<', '>'), array('&amp;', '&quot;', '&#039;', '&lt;', '&gt;'), $strcut);
	return $strcut.$dot;
}

// ȡIPַ
function getIp()
{
	$ip='δ֪IP';

	if(!empty($_SERVER['HTTP_CLIENT_IP']))
	{
		return is_ip($_SERVER['HTTP_CLIENT_IP'])?$_SERVER['HTTP_CLIENT_IP']:$ip;
	}
	elseif(!empty($_SERVER['HTTP_X_FORWARDED_FOR']))
	{
		return is_ip($_SERVER['HTTP_X_FORWARDED_FOR'])?$_SERVER['HTTP_X_FORWARDED_FOR']:$ip;
	}
	else
	{
		return is_ip($_SERVER['REMOTE_ADDR'])?$_SERVER['REMOTE_ADDR']:$ip;
	}
}

function is_ip($str)
{
	$ip = explode('.',$str);
	for($i=0;$i<count($ip);$i++)
	{  
		if($ip[$i]>255)
		{  
			return false;  
		}  
	}  
	return preg_match('/^[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}$/',$str);  
}

/*
	Ip
*/
function hideip($ip,$key=4)
{
	if(!is_ip($ip) || $key>4)return 'Unkonwn';
	$ip=explode(".",$ip);
	$ip[$key-1]='*';
	return implode(".",$ip);
}

// ؽ
function get_cache_counts($sql,$ttl=0)
{
	global $db,$T;
	$id = md5($sql);
	$ttl=intval($ttl)?intval($ttl):CACHE_COUNT_TTL;

	if(!isset($T['count'][$id]))
	{
		if($ttl)
		{
			$r=$db->fetch_one("SELECT `count`,`updatetime` FROM `".DB_PRE."counts` WHERE `id`='$id'");
			if(!$r||$r['updatetime']<TIME-$ttl)
			{
				$r=$db->fetch_one($sql);
				$T['count'][$id] = $r['count'];
				$db->query("REPLACE INTO `".DB_PRE."counts`(`id`, `count`, `updatetime`) VALUES('$id', '".$r['count']."', '".TIME."')",true);
			}
		}
		else
		{
			$r=$db->get_one($sql);
		}
		$T['count'][$id]=$r['count'];
	}
	return $T['count'][$id];
}

// Ŀҳ
function listpage($catid,$listsize=5,$page=0)
{
	global $baselang;
	$catid=intval($catid);
	$page=intval($page)>0?intval($page):1;

	$data=array();
	if($catid)
	{
		$catinfo=getcatinfo($catid);
		$r=cache_read('cat-listsize'.$catid.'.cache.php',DIRCMS_ROOT.'data/cache_template/');
		$row=$r && intval($r[$catid])?intval($r[$catid]):$catinfo['listnum'];

		$listurlrule=(isset($catinfo['listurlrule']) && $catinfo['listurlrule']) ?$catinfo['listurlrule']:'{catdir}list_{page}'.HTMLEXT;
		$listurlrule=str_replace('{tid}',$catid,$listurlrule);
		$listurlrule=str_replace('{sitedir}',SITEDIR.'/',$listurlrule);
		$listurlrule=str_replace('{catdir}',$catinfo['catdir'],$listurlrule);
		$listurlrule=str_replace('\\','/',$listurlrule);
		$listurlrule=str_replace('//','/',$listurlrule);

		$totalcount=get_cache_counts("SELECT COUNT(*) AS count FROM `".DB_PRE."content` WHERE `".DB_PRE."content`.`catid` IN (".implode(',',get_childrencatid($catid)).")"); 
		if(!$totalcount)
		{
			$data['totalcount']=0;
			$data['pageno']=1;
			$data['page']=1;
			$data['index']='';
			$data['pagelist']='';
			$data['next']='';
			$data['end']='';
		}
		else
		{
			$pageno=ceil($totalcount/$row);
			$page=max(1,min($page,$pageno));
			$data['totalcount']=$totalcount;
			$data['pageno']=$pageno;
			$data['page']=$page;
			$data['index']=$page==1?'':'<a href="'.$catinfo['url'].'">'.$baselang['firstpage'].'</a>';

			$pagearray=range(1,$pageno);
			$pagearray=array_slice($pagearray,max(0,($page/$listsize < 1?0:floor($page/$listsize)*$listsize)-1) ,$listsize);
			$querystring=array();

			if($catinfo['catishtml']==0) //̬
			{
				if($page==1)
				{
					$data['pre']='';
				}
				else
				{
					$data['pre']='<a href="'.$catinfo['url'].'&page='.max(1,$page-1).'">'.$baselang['prepage'].'</a>';
				}

				if($page==$pageno)
				{
					$data['next']='';
				}
				else
				{
					$data['next']='<a href="'.$catinfo['url'].'&page='.min($pageno,$page+1).'">'.$baselang['nextpage'].'</a>';
				}

				if($pageno>1)
				{
					foreach($pagearray as $_page)
					{
						if($page==$_page)
						{
							$querystring[]=$_page;
						}
						else
						{
							$querystring[]='<a href="'.$catinfo['url'].'&page='.max($_page,1).'">'.max($_page,1).'</a>';
						}
					}
				}
				$data['pagelist']=implode(' ',$querystring);
				$data['end']=$page==$pageno?'':'<a href="'.$catinfo['url'].'&page='.$pageno.'">'.$baselang['endpage'].'</a>';
			}
			else //̬α̬
			{
				if($page==1)
				{
					$data['pre']='';
				}
				else
				{
					$data['pre']='<a href="'.str_replace('{page}',max(1,$page-1),$listurlrule).'">'.$baselang['prepage'].'</a>';
				}
				
				if($pageno>1)
				{
					foreach($pagearray as $_page)
					{
						if($page==$_page)
						{
							$querystring[]=$_page;
						}
						else
						{
							$querystring[]='<a href="'.str_replace('{page}',max($_page,1),$listurlrule).'">'.max($_page,1).'</a>';
						}
					}
				}

				$data['pagelist']=implode(' ',$querystring);

				if($page==$pageno)
				{
					$data['next']='';
				}
				else
				{
					$data['next']='<a href="'.str_replace('{page}',min($pageno,$page+1),$listurlrule).'">'.$baselang['nextpage'].'</a>';
				}

				$data['end']=$page==$pageno?'':'<a href="'.str_replace('{page}',$pageno,$listurlrule).'">'.$baselang['endpage'].'</a>';
			}
		}
	}
	return $data;
}

// ҳ
function getpages($number,$page,$pagesize,$ishtml=0,$align='right',$catid=0)
{
	global $DIRCMS,$baselang;
	$rand=mt_rand(100,999);
	$pagenum=max(1,ceil($number/$pagesize));
	$prepage=max(($page-1),1);
	$nextpage=max(1,min(($page+1),$pagenum));

	if(!$ishtml) // ̬
	{
		
		$cururl=preg_replace('/([&\?]?)(page=[0-9]+)([&\?]?)/i','\\1',getcururl());
		$strlen=strlen($cururl)-1;
		$flag=(boolean)(substr(strrchr($cururl,'/'),1));
		if(substr($cururl,-1,1)=='&')
		{
			$cururl=$flag?substr($cururl,0,$strlen).'&page=':substr($cururl,0,$strlen).'?page=';
		}
		elseif(substr($cururl,-1,1)=='?')
		{
			$cururl=substr($cururl,0,$strlen).'?page=';
		}
		else{
			if(strpos($cururl,'?')===false && strpos($cururl,'&')===false)$flag=false;
			$cururl=$flag?$cururl.'&page=':$cururl.'?page=';
		}
		$pselect='<select name="pageto" id="pagetoselect'.$rand.'" onchange="window.location.href=\''.$cururl.'\'+document.getElementById(\'pagetoselect'.$rand.'\').value">';
		for($i=1;$i<=intval($pagenum);$i++)
		{
			$pselect.='<option value="'.$i.'">'.$baselang['start'].$i.$baselang['page'].'</option>';
		}
		$pselect.='</select><script language="javascript">{document.getElementById(\'pagetoselect'.$rand.'\').value='.$page.'}</script>';
		return '<div align="'.$align.'">&nbsp;'.$baselang['total'].'<b>'.$number.'</b> &nbsp;
						<a href="'.$cururl.'1">'.$baselang['firstpage'].'</a>&nbsp;<a href="'.$cururl.$prepage.'">'.$baselang['prepage'].'</a>&nbsp;
						<a href="'.$cururl.$nextpage.'">'.$baselang['nextpage'].'</a>&nbsp;
						<a href="'.$cururl.$pagenum.'">'.$baselang['endpage'].'</a>&nbsp;'.$baselang['totalpage'].'<b><font color="#ff0000">'.$page.'</font>/'.$pagenum.'</b> '.$pselect.'</div>';	
	}
}

function set_cookie($var,$value='',$time=0)
{
	$time = $time > 0 ? $time : ($value == '' ? TIME - 3600 : 0);
	$secure=$_SERVER['SERVER_PORT']=='443'?true:false;
	$var = COOKIE_PRE.$var;
	$_COOKIE[$var] = $value;
	if(is_array($value))
	{
		foreach($value as $k=>$v)
		{
			setcookie($var.'['.$k.']',$v,$time,COOKIE_PATH,COOKIE_DOMAIN,$secure);
		}
	}
	else
	{
		setcookie($var,$value,$time,COOKIE_PATH,COOKIE_DOMAIN,$secure);
	}
}

function dircms_auth($str,$operation='ENCODE',$key='')
{
	$key=$key?$key:AUTH_KEY;
	$str=$operation == 'ENCODE'?$str:base64_decode($str);
	$len=strlen($key);
	$code='';
	for($i=0; $i<strlen($str); $i++){
		$k=$i%$len;
		$code.=$str[$i]^$key[$k];
	}
	$code=$operation=='DECODE'?$code:base64_encode($code);
	return $code;
}

function get_cookie($var)
{
	$var = COOKIE_PRE.$var;
	return isset($_COOKIE[$var])?$_COOKIE[$var]:false;
}

function getpos($catid=0,$separator='')
{
	global $DIRCMS;
	$r=cache_read('cat'.$catid.'.cache.php',DIRCMS_ROOT.'data/cache_category/');
	$url=' <a href="'.$r['url'].'" title="'.$r['catname'].'">'.$r['catname'].'</a> ';
	if(!$r || !$r['parentid']) 
	{
		return $url;
	}
	else
	{
		return getpos($r['parentid'],$separator).$separator.$url;
	}
}

// ȡǰλ
function get_pos($catid=0,$separator='')
{
	global $DIRCMS,$baselang;
	$catid=intval($catid);
	if(!$catid)return ' <a href="'.$DIRCMS['site_url'].'" title="'.$DIRCMS['site_name'].'">'.$baselang['index'].'</a> ';
	$separator=htmlspecialchars($separator);
	$separator=$separator?$separator:SEPARATOR;
	$pos=getpos($catid,$separator);	
	return ' <a href="'.$DIRCMS['site_url'].'" title="'.$DIRCMS['site_name'].'">'.$baselang['index'].'</a> '.$separator.' '.$pos;
}

// ȡ 
function cache_read($cachename,$path='')
{
	$cachename=str_replace('/','',$cachename);
	$cachename=str_replace('\\','',$cachename);
	$path=empty($path)?CACHE_PATH:$path;
	$cachefile=$path.$cachename;
	if(!file_exists($cachefile))return false;
	return @include $cachefile;
}

// д뻺
function cache_write($cachename,$array=array(),$path='')
{
	if(!is_array($array))return false;
	$path=empty($path)?CACHE_PATH:$path;
	$cachefile=$path.$cachename;
	
	$array="<?php\n//".date('Y-m-d H:i:s',time())."\nreturn ".var_export($array,true).";\n?>";
	$strlen=file_put_contents($cachefile,$array);

	@chmod($cachefile,0777);
	return $strlen;
}

// ɾ
function cache_delete($cachename,$path='')
{
	$path=empty($path)?CACHE_PATH:$path;
	if($cachename=='*') // лļļ
	{
		rmdirs($path);
	}
	else if($cachename=='*.*') // лļ
	{
		 rmfiles($path);
	}
	else // ָļ
	{
		$cachefile=$path.$cachename;
		return @unlink($cachefile);
	}
}

// ɾļµļ
function rmfiles($path)
{
	if(!file_exists($path))return true;
	$path = get_path($path);
	$list = glob($path.'*.*');
	foreach($list as $v)
	{
		@unlink($v);
	}
	return true;
}

//ݹ鴴ļ
function makedir($dirname) 
{	
	@chdir(DIRCMS_ROOT);
	if(file_exists($dirname) || !$dirname)return true;
	$dirname=strtolower(preg_replace('/[^0-9a-zA-Z_\-\/]/i','',str_replace('\\','/',$dirname)));
	$dirname=explode('/',$dirname);
	$dir_name='./';
	foreach($dirname as $childdir)
	{
		$dir_name.=$childdir.'/';
		if(!file_exists($dir_name) && !empty($childdir))
		{
			@mkdir($dir_name);
			@chmod($dir_name,0777);
		}
	}
	return true;
}

// ݹɾļļ
function rmdirs($path)
{
	$path=str_replace('\\','/',$path);
	$path=str_replace('//','/',$path);

	if(!file_exists($path))return true;

	/*
		򵥰ȫ   ļº rm.lock ɾļ Լļ
	*/

	if(is_dir($path))
	{
		if(file_exists(str_replace('//','/',$path.'/rm.lock')))return false;
	}

	else
	{
		if(file_exists(dirname($path).'/rm.lock'))return false;
	}

	if(is_dir($path))
	{
		$path = get_path($path);
		$list = glob($path.'*');
		foreach($list as $v)
		{
			is_dir($v) ? rmdirs($v) : @unlink($v);
		}
		return rmdir($path);
	}
	else
	{
		return unlink($path);
	}
}

// ʽĿ¼·
function get_path($path)
{
	$path = str_replace('\\', '/', $path);
	if(substr($path,-1) != '/') $path = $path.'/';
	return $path;
}

// html
function create_html($file)
{
	global $DIRCMS,$LANG;
	$data=ob_get_contents();
	ob_clean();
	$path=dirname($file);
	if(substr($path,0,strlen(DIRCMS_ROOT))==DIRCMS_ROOT)
	{
		$path=substr($path,strlen(DIRCMS_ROOT));
	}
	/*
		makedir($path);
	*/
	$strlen=file_put_contents($file,$data);
	@chmod($file,0777);
	return $strlen;
}

// ģ庯
function template($tlpname,$mod='dc',$folder='',$isprompt=false)
{
	/*
		ֻгģܱԤ!
	*/
	if(!$isprompt)
	{
		$project=get_cookie('project');
		$project=isset($project) && preg_match('/^[a-z0-9_]{1,80}$/i',$project) && $mod=='dc' && file_exists(TPL_ROOT.$project)?$project:TPL_NAME;	
	}
	else
	{
		$project='prompt';
	}
	$mod=trim($mod)=='dc'?'':trim($mod).'/';
	$folder=trim($folder)?trim($folder).'/':'';

	require_once (DIRCMS_ROOT.'include/template.func.php');
	$compliedfile=TPL_CACHEPATH.$project.'/'.$mod.$folder.$tlpname.'.tlp.php';
	if(!file_exists(TPL_CACHEPATH.$project.'/'.$mod))@mkdir(TPL_CACHEPATH.$project.'/'.$mod,0777);
	if(!file_exists(TPL_CACHEPATH.$project.'/'.$mod.$folder))@mkdir(TPL_CACHEPATH.$project.'/'.$mod.$folder,0777);

	if(!file_exists(TPL_ROOT.$project.'/'.$mod.$folder.$tlpname.'.html'))
	{
		exit('ģ巽µģļ'.TPL_ROOT.$project.'/'.$mod.$folder.$tlpname.'.html'.',޷Ԥ!');
	}

	if(!file_exists($compliedfile) || @filemtime(TPL_ROOT.$project.'/'.$mod.$folder.$tlpname.'.html') > @filemtime($compliedfile))
	{
		template_complie($tlpname,$project,$mod,$folder);
	}
	return $compliedfile;
}

// ַתΪ
function string2array($str)
{
	if(disablefunc('eval'))exit('eval,޷ʹñϵͳ!');
	if($str=='') return array();
	if(is_array($str))return $str; // 2011-09-13  Ļֱӷ
	@eval("\$array = $str;");
	return $array;
}

// ļ
function cache_config($cachename='common.cache.php',$array=array(),$path='')
{
	if(!is_array($array))return false;
	$path=empty($path)?DIRCMS_ROOT.'data/':$path;
	$cachefile=$path.$cachename;
	$array="<?php\n\$DIRCMS=".var_export($array,true).";\n?>";
	$strlen=file_put_contents($cachefile,$array);
	@chmod($cachefile,0777);
	return $strlen;
}

// 麯Ƿڰȫԭ
function disablefunc($func)
{
	return in_array($func,array_map('trim',explode(',',ini_get('disable_functions'))));
}

// ϵͳʾ
function fatal_error($msg,$errno='')
{
	$msg=DEBUG?strip_tags($msg,'<br><p><a>'):'ϵͳԱ˴Ϣ!';
	global $DIRCMS;
	include template('prompt_syserror','','',true);
	exit();
}

// תʾ 
function showmsg($msg='',$url='',$timeout=1000)
{
	global $DIRCMS;
	if(!$url)$url='javascript:history.back();';
	include template('prompt_back','','',true);
	exit('<script>setTimeout("redirect(\''.$url.'\');",'.$timeout.');</script>');
}

// 404 ʾ
function show404($msg='',$url='',$timeout=10000)
{
	global $DIRCMS;
	header('HTTP/1.1 404 Not Found');
	header("status: 404 Not Found");
	if(!$url)
	{
		$url=$DIRCMS['site_url'];
	}
	$expire=$timeout/1000;
	include template('prompt_404','','',true);
	exit('<script>setTimeout("redirect(\''.$url.'\');",'.$timeout.');</script>');
}

// 治תʾ 
function showmsg_nourl($msg='')
{
	global $DIRCMS;
	$url='javascript:history.back();';
	include template('prompt_noback','','',true);
	exit();
}

// ȥհַ[\r\n\t\s]
function trim_str($str)
{
	return preg_replace('/[\r\n\t\s]+/','',$str);
}

// [˫md5]
function PWD($pwd)
{
	return md5(md5(PASSWORD_KEY).PASSWORD_KEY.md5(trim($pwd)));
}

// ӵַȡ
function getRootDomain($url)
{
	$ohurl=$ohip=array();
	$url = $url."/"; 
	preg_match("/((\w*):\/\/)?\w*\.?([\w|-]*\.(com.cn|net.cn|gov.cn|org.cn|com|net|cn|org|asia|tel|mobi|me|tv|biz|cc|name|info))\//i", $url, $ohurl); 

	if(!isset($ohurl[3]) || $ohurl[3] == '')
	{ 
		preg_match("/((\d+\.){3}\d+)\//", $url, $ohip); 
		return isset($ohip[1])?$ohip[1]:'';
	} 
	return $ohurl[3]; 
}

// ȡͼ汾 2012-01-25 IE9.0
function explorer_version()
{
	global $baselang;
	if(strpos($_SERVER["HTTP_USER_AGENT"],"MSIE 10.0"))  
	{
		return "Internet Explorer 10.0";
	}
	else if(strpos($_SERVER["HTTP_USER_AGENT"],"MSIE 9.0"))  
	{
		return "Internet Explorer 9.0";
	}
	else if(strpos($_SERVER["HTTP_USER_AGENT"],"MSIE 8.0"))  
	{
		return "Internet Explorer 8.0";
	}
	else if(strpos($_SERVER["HTTP_USER_AGENT"],"MSIE 7.0"))
	{
		return "Internet Explorer 7.0";
	}
	else if(strpos($_SERVER["HTTP_USER_AGENT"],"MSIE 6.0"))
	{
		return "Internet Explorer 6.0";
	}
	else if(strpos($_SERVER["HTTP_USER_AGENT"],"Firefox/4"))
	{
		return "Firefox 4";	
	}
	else if(strpos($_SERVER["HTTP_USER_AGENT"],"Firefox/3"))
	{
		return "Firefox 3";
	}
	else if(strpos($_SERVER["HTTP_USER_AGENT"],"Firefox/2"))
	{
		return "Firefox 2";
	}
	else if(strpos($_SERVER["HTTP_USER_AGENT"],"Chrome"))
	{
		return "Google Chrome";
	}
	else if(strpos($_SERVER["HTTP_USER_AGENT"],"Safari"))
	{
		return  "Safari";
	}
	else if(strpos($_SERVER["HTTP_USER_AGENT"],"Opera"))
	{
		return "Opera";
	}
	else
	{
		return $baselang['unkonwnbrowser'];
	}
}

//ʹüȽϼĲ
function n_array_diff($a1,$a2)
{
	if(function_exists('array_diff_key'))return array_diff_key($a1,$a2);
	else
	{
		$a1=array_flip($a1);
		$a2=array_flip($a2);
		return array_flip(array_diff($a1,$a2));
	}
}

// ȡһӽڵID $flag=true ʱ ֻյӽID 򷵻еӽID
function get_childrenid($db,$table,$parentid,$flag=false)
{
	$parentid=intval($parentid);
	$result=array();
	$r=$db->fetch_all("SELECT `$table`.`id` FROM `$table` WHERE `$table`.`parentid`=$parentid");
	if($r)
	{
		foreach($r as $_r)
		{
			if($flag)
			{
				if(!$db->fetch_one("SELECT `$table`.`id` FROM `$table` WHERE `$table`.`parentid`=".intval($_r['id'])))
				{
					$result[]=intval($_r['id']);
				}
			}
			else
			{
				$result[]=intval($_r['id']);
			}
			$result=get_childrenid($db,$table,$_r['id'],$flag);
		}
	}
	$result[]=$parentid;
	return array_unique($result);
}

// ȡ˵öֵ
function get_selectmenu($js='area',$enumid=0)
{
	global $baselang;
	$r=cache_read('stepselect_enum'.$js.'.cache.php',DIRCMS_ROOT.'data/c/');
	return $r && isset($r[$enumid])?$r[$enumid]:'';
}

// ˵
function js_selectmenu($js='area',$table='areaid', $name='info', $default='0') 
{
	global $baselang;
	$table=preg_replace('/[^a-z0-9_]+/i','',$table);
	if(!file_exists(DIRCMS_ROOT.'data/cache_stepselect/'.$js.'.js'))return '';
	$result='<input type="hidden" value="'.$default.'" id="'.$table.'" name="'.$table.'" /><input type="hidden" value="'.$default.'" id="'.$name.'_id_'.$table.'" name="'.$name.'['.$table.']" /><select id="'.$table.'_top_select" name="'.$table.'_top_select" onchange="get_'.$js.'self_select(\''.$name.'\',\''.$table.'\',this.value)"></select><select id="'.$table.'_self_select" name="'.$table.'_self_select" onchange="get_'.$js.'son_select(\''.$name.'\',\''.$table.'\',this.value)"></select><select id="'.$table.'_son_select" onchange="get_'.$js.'_value(\''.$name.'\',\''.$table.'\',this.value)" name="'.$table.'_son_select"></select><script language="javascript">var stepselect="'.$table.'";</script> <a href="javascript:void(0);" onclick="javascript:reset_'.$js.'selectnemu();">'.$baselang['reset'].'</a>
<script language="javascript" src="'.SITE_URL.'data/cache_stepselect/'.$js.'.js"></script>';
	
	$enums=cache_read('stepselect_enum'.$js.'.cache.php',DIRCMS_ROOT.'data/c/');

	if($default && array_key_exists($default,$enums))
	{
		$result.='<script language="javascript">document.getElementById("'.$table.'_top_select").options[0]=new Option("'.$enums[$default].'",'.$default.'); document.getElementById("'.$table.'_top_select").disabled="disabled";document.getElementById("'.$table.'_top_select").value='.$default.';</script>';
	}

	return $result;
}


/*
	ȡ˵Ϣ
*/
function selectmenuinfo($type='area',$parentid=0,$isall=false,$row="0")
{
	include_once dirname(__FILE__).'/admin/stepselect.class.php';
	$stepselect= new stepselect();
	return $stepselect->enuminfo($type,$parentid,$isall,$row);
}

function selectmenusearch($type='area',$parentid=0)
{
	$result=array();
	$parentid=intval($parentid);

	if(!$parentid)
	{
		$result=cache_read('stepselect_enum'.$type.'.cache.php',DIRCMS_ROOT.'data/c/');
		foreach($result as $key =>$val)
		{
			$r=cache_read('stepselect_enum'.$type.$key.'.cache.php',DIRCMS_ROOT.'data/c/');
			if($r['parentid']==0)
			{
				unset($result[$key]);
			}
		}
	}
	else
	{
		$r=selectmenuinfo($type,$parentid);

		if(!$r)
		{
			$r=cache_read('stepselect_enum'.$type.$parentid.'.cache.php',DIRCMS_ROOT.'data/c/');
			$r=selectmenuinfo($type,$r['parentid']);
		}
		foreach($r as $_r)
		{
			$result[$_r['id']]=$_r['name'];
		}
	}
	return $result;
}

function getparentid($catid)
{
	$r=getcatinfo($catid);
	return $r?$r['parentid']:0;
}

// ȡĿϢ 
function getcatinfo($catid)
{
	if(!cat_exists($catid))
	{
		return false;
	}
	$r1=cache_read('cat'.intval($catid).'.cache.php',DIRCMS_ROOT.'data/cache_category/');
	$r1['expand']=$r1['expand']?string2array($r1['expand']):array();
	if($r1['expand'])foreach($r1['expand'] as $key => $value)
	{
		$r1['_'.$key]=htmlspecialchars($value);
	}
	$r2=cache_read('cat_setting'.intval($catid).'.cache.php',DIRCMS_ROOT.'data/cache_category/');
	return array_merge($r1,$r2);
}

// ȡĿ 
function getcatsetting($catid)
{
	return cache_read('cat_setting'.intval($catid).'.cache.php',DIRCMS_ROOT.'data/cache_category/');
}

//жǷĿ
function isfinalcatid($catid)
{
	$r=cache_read('finalcatid.cache.php',DIRCMS_ROOT.'data/cache_category/');
	return in_array(intval($catid),$r);
}

// жĿǷĿ
function ishaschildren($catid)
{
	return cache_read('cat_parent'.intval($catid).'.cache.php',DIRCMS_ROOT.'data/cache_category/');
}

// жĿIDǷ
function cat_exists($catid=0)
{
	return intval($catid) && cache_read('cat'.intval($catid).'.cache.php',DIRCMS_ROOT.'data/cache_category/');
}

// жģIDǷ
function model_exists($modelid=0)
{
	return intval($modelid) && cache_read('model'.intval($modelid).'.cache.php',DIRCMS_ROOT.'data/c/');
}

/**
	ȡĿID
*/
function getchildrencatid($catid)
{
	$t_catid[]=$catid;
	$r=cache_read('cat_parent'.$catid.'.cache.php',DIRCMS_ROOT.'data/cache_category/');
	if($r)foreach($r as $_r)
	{
		$t_catid[]=getchildrencatid($_r['id']);
	};
	return implode(',',$t_catid);
}

// ݵǰĿIDȡĿ,һ
function get_childrencatid($catid)
{
	return explode(',',getchildrencatid($catid));
}

/*
	ûģǵĺ
*/
function getCatid($catid)
{
	$catid=intval($catid);
	if(isfinalcatid($catid))return 'catid='.intval($catid);
	else
	{
		$r=cache_read('finalcatid.cache.php',DIRCMS_ROOT.'data/cache_category/');
		$t_catid[]=implode(',',get_childrencatid($catid));
		$catid=array_unique(explode(',',implode(',',$t_catid)));
		$catid=array_intersect($r,$catid);
		$catid=$catid?$catid:array(0);
		sort($catid);
		return 'catid IN('.implode(',',$catid).')';
	}
}
//bbcode

function bbcode($content)
{
	if(empty($content))return '';
	$content=htmlspecialchars($content);
	return preg_replace('/face:([0-9a-z_]+)\)/i','<img src="'.SITE_URL.'images/face/\\1.gif" border="0" />',$content);
}

//ִв

function do_hook($tag,$args='')
{
	$result='';
	$plugin=DIRCMS_ROOT.PLUGINS.'/'.$tag.'/'.$tag.'.php';
	if(file_exists($plugin))
	{
		$result=call_user_func($tag,$args);
	}
	return $result;
}

/*
	ȡŹؼ
*/
function hotkeywords($type='hot',$num=10,$pre='',$next='&nbsp;')
{
	global $db,$DIRCMS;
	$result='';

	$r= $db->fetch_all("SELECT * FROM `".DB_PRE."keywords` ORDER BY `".DB_PRE."keywords`.`".($type=='hot'?'counts':'weight')."` DESC LIMIT 0,$num");
	
	if($r)
	{
		foreach($r as $_r)
		{
			$result.=$pre.'<a href="'.$DIRCMS['site_url'].'search/index.php?modelid=all&k='.urlencode($_r['keywords']).'" target="_blank">'.$_r['keywords'].'</a>'.$next;
		}
	}
	return $result;
}

/*
	ȡָȹؼ
*/
function get_randstr($len=10)
{
	$str='';
	for($i=0;$i<$len;$i++)
	{
		$str.=mt_rand(0,9);
	}
	return $str;
}

/*
	б
*/
function facelist($pre='&nbsp;',$next='&nbsp;',$textid='c_content')
{
	$str='';
	$files=glob(DIRCMS_ROOT.'images/face/*.gif');
	if($files)foreach($files as $file)
	{
		if(file_exists($file))
		{
			$str.=$pre.'<img style="cursor:pointer" src="'.SITE_URL.'images/face/'.basename($file).'" onclick="document.getElementById(\''.$textid.'\').value=document.getElementById(\''.$textid.'\').value+\'face:'.basename($file,'.gif').')\'" />'.$next;
		}
	}
	return $str;
}

/*
	ģԶֶ
*/
function searchfields($catid,$modelid=0)
{
	global $areaid;
	$areaid=intval($areaid);

	$str='';
	$tstr='';
	$modelid=intval($modelid);
	if(!$modelid)
	{
		$catinfo=getcatinfo(intval($catid));
		$modelid=$catinfo['modelid'];
	}

	if($modelid)
	{
		$_G=array('modelid','catid');
		$r=cache_read('model'.$modelid.'_fields.cache.php',DIRCMS_ROOT.'data/c/');
		if($r)
		{
			foreach($r as $_r)
			{
				if($_r['form']=='select' || $_r['form']=='radio'  || $_r['form']=='checkbox' || substr($_r['form'],0,11)=='selectmenu_')
				{
					$_G[]=$_r['enname'];
				}
			}

			$m=0;
			foreach($r as $_r)
			{
				$options=array();

				if($_r['form']=='select' || $_r['form']=='radio'  || $_r['form']=='checkbox' || substr($_r['form'],0,11)=='selectmenu_')
				{
					$fileds=cache_read('model_fields'.$_r['id'].'.cache.php',DIRCMS_ROOT.'data/c/');
					if(substr($_r['form'],0,11)!='selectmenu_')
					{
						$options=explode("\r\n",$fileds['options']);
					}
					else
					{
						//$js=cache_read('stepselect_enum'.substr($_r['form'],11).'.cache.php',DIRCMS_ROOT.'data/c/');
						$js=selectmenusearch(substr($_r['form'],11),$areaid);
						foreach($js as $key => $value)
						{
							$options[]=$key.'|'.$value;
						}
					}

					if($options)
					{
						$tstr='';
						$str.=($m?'<br />':'').'<span>'.$_r['name'].'</span>';
						foreach($options as $i => $option)
						{
							if($option)
							{
								$querystring=array();
								$v=explode('|',$option);
								if($_GET)
								{
									if(!isset($_GET['modelid']))$_GET['modelid']=$modelid;
									if(!isset($_GET['catid']))$_GET['catid']=$catid;
									if(!isset($_GET['page']))$_GET['page']=1;
									foreach($_GET as $key => $val)
									{
										if(in_array($key,$_G) && $key!=$fileds['enname'])
										{
											$querystring[]=$key.'='.urlencode($val);
										}
									}
								}
								else
								{
									if($modelid)
									{
										$querystring[]='modelid='.intval($modelid);
									}
								}
								if($i==0)
								{
									$tstr.='<a href="search/index.php?'.implode('&',$querystring).'&'.$fileds['enname'].'=">'.(!isset($_GET[$fileds['enname']]) || empty($_GET[$fileds['enname']])?'<font class="redbg">':'').''.(!isset($_GET[$fileds['enname']]) || empty($_GET[$fileds['enname']])?'</font>':'').'</a>&nbsp;&nbsp;';
								}

								$tstr.='<a href="search/index.php?'.implode('&',$querystring).'&'.$fileds['enname'].'='.urlencode($v[0]).'">'.(isset($_GET[$fileds['enname']]) && $_GET[$fileds['enname']]==$v[0]?'<font class="redbg">':'').$v[1].(isset($_GET[$fileds['enname']]) && $_GET[$fileds['enname']]==$v[0]?'</font>':'').'</a>&nbsp;&nbsp;';
							}
						}
						$str.=$tstr;
						$m++;
					}
				}
			}
		}
	}
	return $str;
}

/*
	ֶ, ͼ, 
*/
function morefield($mores,$limit="4") // ֶε 
{
	$result=$r=$t=array();
	if(!$mores)return $t;
	$t=explode("`",$mores);
	$i=1;
	if($t)foreach($t as $k => $_t)
	{
		if($_t && $i<=intval($limit))
		{
			$r=explode("|",$_t);
			$result[$k]['name']=$r[0];
			$result[$k]['url']=$r[1];
			$i++;
		}
	}
	return $result;
}

/*
	ִԶ庯
*/
function dc_call_user_func($function,$parameter,$extra='')
{
	$para=array();
	$parameter=preg_replace('/\"\s+\"/i','""',$parameter);
	$parameter=explode(" ",$parameter);

	if($parameter)
	{
		foreach($parameter as $val)
		{
			preg_match('/([0-9a-z_]+)\s*=\s*([^\s]+)/i',$val,$matches);
			$para[$matches[1]]=filterpara($matches[2]);
		}
	}

	if($extra)
	{
		preg_match('/([0-9a-z_]+)\s*=\"([^\"]+)\"/i',$extra,$matches);
		$para[$matches[1]]=filterpara($matches[2]);
	}
	return call_user_func($function,$para);
}

/*
	˲
*/
function filterpara($para)
{
	return str_replace(array('\'','"'),'',stripslashes($para));
}

function is_email($email)
{
	if(!$email)return false;
	if(strlen(trim_str($email))>80)return false;
	return preg_match('/^\w+@\w+\.[0-9a-z\._\-]+$/i',trim_str($email));
}

function is_url($url)
{
	if(strlen(trim_str($url))>200)return false;
	return preg_match('/^http:\/\/\w+?.{4,200}$/i',trim_str($url));
}

function is_phone_fax($phone)
{
	if(strlen(trim_str($phone))>80)return false;
	return preg_match('/^[0-9\-\(\)]{3,50}$/i',trim_str($phone));
}

function is_postcode($postcode)
{
	if(strlen(trim_str($postcode))>10)return false;
	return preg_match('/^[0-9\-]{4,10}$/i',trim_str($postcode));
}

function dircms_md5($str)
{
	return substr(md5($str),8,16);
}

function pageinfo($id)
{
	global $db;
	$r=$db->fetch_one("SELECT * FROM ".DB_PRE."page WHERE id=".intval($id));
	return $r['content'];
}

function ip2area($ip) 
{
	if(!preg_match("/^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/", $ip)) 
	{
		return 'Unknown';
	}

	$fd = @fopen(DIRCMS_ROOT.'include/dict/ipdata.dat', 'rb');
	
	if(!$fd)
	{
		return 'Unknown';
	}

	$ip = explode('.', $ip);
	$ipNum = $ip[0] * 16777216 + $ip[1] * 65536 + $ip[2] * 256 + $ip[3];

	$DataBegin = fread($fd, 4);
	$DataEnd = fread($fd, 4);
	$ipbegin = implode('', unpack('L', $DataBegin));
	if($ipbegin < 0) $ipbegin += pow(2, 32);
	$ipend = implode('', unpack('L', $DataEnd));
	if($ipend < 0) $ipend += pow(2, 32);
	$ipAllNum = ($ipend - $ipbegin) / 7 + 1;

	$BeginNum = 0;
	$EndNum = $ipAllNum;

	while($ip1num > $ipNum || $ip2num < $ipNum) 
	{
		$Middle= intval(($EndNum + $BeginNum) / 2);

		fseek($fd, $ipbegin + 7 * $Middle);
		$ipData1 = fread($fd, 4);
		if(strlen($ipData1) < 4)
		{
			fclose($fd);
			return 'System Error';
		}
		$ip1num = implode('', unpack('L', $ipData1));
		if($ip1num < 0) $ip1num += pow(2, 32);

		if($ip1num > $ipNum) 
		{
			$EndNum = $Middle;
			continue;
		}

		$DataSeek = fread($fd, 3);
		if(strlen($DataSeek) < 3) 
		{
			fclose($fd);
			return 'System Error';
		}
		$DataSeek = implode('', unpack('L', $DataSeek.chr(0)));
		fseek($fd, $DataSeek);
		$ipData2 = fread($fd, 4);
		if(strlen($ipData2) < 4) 
		{
			fclose($fd);
			return 'System Error';
		}
		$ip2num = implode('', unpack('L', $ipData2));
		if($ip2num < 0) $ip2num += pow(2, 32);

		if($ip2num < $ipNum) 
		{
			if($Middle == $BeginNum) 
			{
				fclose($fd);
				return 'Unknown';
			}
			$BeginNum = $Middle;
		}
	}

	$ipFlag = fread($fd, 1);
	if($ipFlag == chr(1)) 
	{
		$ipSeek = fread($fd, 3);
		if(strlen($ipSeek) < 3) 
		{
			fclose($fd);
			return 'System Error';
		}
		$ipSeek = implode('', unpack('L', $ipSeek.chr(0)));
		fseek($fd, $ipSeek);
		$ipFlag = fread($fd, 1);
	}

	if($ipFlag == chr(2)) 
	{
		$AddrSeek = fread($fd, 3);
		if(strlen($AddrSeek) < 3) 
		{
			fclose($fd);
			return 'System Error';
		}
		$ipFlag = fread($fd, 1);
		if($ipFlag == chr(2)) 
		{
			$AddrSeek2 = fread($fd, 3);
			if(strlen($AddrSeek2) < 3) 
			{
				fclose($fd);
				return 'System Error';
			}
			$AddrSeek2 = implode('', unpack('L', $AddrSeek2.chr(0)));
			fseek($fd, $AddrSeek2);
		} 
		else 
		{
			fseek($fd, -1, SEEK_CUR);
		}

		while(($char = fread($fd, 1)) != chr(0))
			$ipAddr2 .= $char;

		$AddrSeek = implode('', unpack('L', $AddrSeek.chr(0)));
		fseek($fd, $AddrSeek);

		while(($char = fread($fd, 1)) != chr(0))
			$ipAddr1 .= $char;
	} 
	else 
	{
		fseek($fd, -1, SEEK_CUR);
		while(($char = fread($fd, 1)) != chr(0))
			$ipAddr1 .= $char;

		$ipFlag = fread($fd, 1);
		if($ipFlag == chr(2)) 
		{
			$AddrSeek2 = fread($fd, 3);
			if(strlen($AddrSeek2) < 3) 
			{
					fclose($fd);
					return 'System Error';
			}
			$AddrSeek2 = implode('', unpack('L', $AddrSeek2.chr(0)));
			fseek($fd, $AddrSeek2);
		} 
		else 
		{
			fseek($fd, -1, SEEK_CUR);
		}
		while(($char = fread($fd, 1)) != chr(0))
			$ipAddr2 .= $char;
	}
	fclose($fd);

	if(preg_match('/http/i', $ipAddr2)) 
	{
		$ipAddr2 = '';
	}
	$ipaddr = "$ipAddr1 $ipAddr2";
	$ipaddr = preg_replace('/CZ88\.NET/is', '', $ipaddr);
	$ipaddr = preg_replace('/^\s*/is', '', $ipaddr);
	$ipaddr = preg_replace('/\s*$/is', '', $ipaddr);
	if(preg_match('/http/i', $ipaddr) || $ipaddr == '') 
	{
		$ipaddr = 'Unknown';
	}

	return iconv('GBK','GBK//IGNORE',$ipaddr);
}

function deletebutton($contentid)
{
	global $DIRCMS;
	return '<link href="'.SITE_URL.'images/css/dialog.css" rel="stylesheet" type="text/css" /><script language="javascript" type="text/javascript" src="images/js/dialog.js"></script>
<script language="javascript" type="text/javascript" src="images/js/prompt.js"></script><a href="javascript:void(0);" onclick="javascript:openDialog(\'ɾϢ\',\''.SITE_URL.'api/check/delete.php?contentid='.intval($contentid).'\',325,70);">ɾ</a> ';
}

function loadmap($map,$width="550",$height="450",$api="myMap")
{
	include_once DIRCMS_ROOT.'api/map/map_api_'.MAPAPI.'.php';
	return loadmap_api($map,$width,$height,$api);
}
?>