<?php 
if(strstr($_SERVER['REQUEST_URI'],'themes.php') && (!isset($_REQUEST['template']) && $_REQUEST['template']=='') && (!isset($_GET['page']) && $_GET['page']=='')){
	if(get_option('ptthemes_auto_install')=='No' || get_option('ptthemes_auto_install')==''){
		if(is_plugin_active('woocommerce/woocommerce.php') || is_plugin_active('jigoshop/jigoshop.php')){	
			if( false == get_option( 'hide_ajax_notification' ) ) {
				add_action("admin_head", "autoinstall_admin_header"); // please comment this line if you wish to DEACTIVE SAMPLE DATA INSERT.
			}
		} else{
			if(file_exists(WP_PLUGIN_DIR.'/woocommerce/woocommerce.php') || file_exists(WP_PLUGIN_DIR.'/jigoshop/jigoshop.php')){
				add_action("admin_head", "activate_woo_plugin"); // please comment this line if you wish to DEACTIVE SAMPLE DATA INSERT.
			}else{
				add_action("admin_head", "download_woo_plugin"); // please comment this line if you wish to DEACTIVE SAMPLE DATA INSERT.
			}
		}
	}
}
	
function autoinstall_admin_header(){
	global $wpdb;
	update_option("ptthemes_alt_stylesheet",'1-default');
	$post_counts = $wpdb->get_var("select count(post_id) from $wpdb->postmeta where (meta_key='pt_dummy_content' || meta_key='tl_dummy_content') and meta_value=1");
	if($post_counts>0){
		$dummy_data_msg = 'Sample data has been <b>populated</b> on your site. Wish to delete sample data?  <a class="button_delete" href="'.get_option('home').'/wp-admin/themes.php?dummy=del">Yes Delete Please!</a>';
	}else{
		$dummy_data_msg = 'Would you like to <b>auto populate</b> sample data on your site?  <a class="button_insert" href="'.get_option('home').'/wp-admin/themes.php?dummy_insert=1">Yes, insert please</a>';
	}
	
	if(isset($_REQUEST['dummy_insert']) && $_REQUEST['dummy_insert']){
		require_once (TEMPLATE_FUNCTION_FOLDER_PATH.'auto_install/auto_install_data.php');
		$dummy_data_msg = 'Dummy data successfully <b>populated</b> on your site. Click <a href="'.get_option('home').'/wp-admin/themes.php">here</a> to continue.';
	}
	if(isset($_REQUEST['dummy']) && $_REQUEST['dummy']=='del'){
		coolcart_delete_dummy_data();
		$dummy_data_msg = 'All Dummy data has been <b>removed</b> from your database successfully! Click <a href="'.get_option('home').'/wp-admin/themes.php">here</a> to continue.';
	}
	define('THEME_ACTIVE_MESSAGE','<div id="ajax-notification" class="updated welcome-panel templatic_autoinstall"><p> '.$dummy_data_msg.'</p><span id="ajax-notification-nonce" class="hidden">' . wp_create_nonce( 'ajax-notification-nonce' ) . '</span><a href="javascript:;" id="dismiss-ajax-notification" class="welcome-panel-close" style="float:right">Dismiss</a></div>');
	echo THEME_ACTIVE_MESSAGE;
}
			
function coolcart_delete_dummy_data(){
	global $wpdb;
	delete_option('sidebars_widgets'); //delete widgets
	$productArray = array();
	$pids_sql = "select p.ID from $wpdb->posts p join $wpdb->postmeta pm on pm.post_id=p.ID where (meta_key='pt_dummy_content' || meta_key='tl_dummy_content' || meta_key='auto_install') and (meta_value=1 || meta_value='auto_install')";
	$pids_info = $wpdb->get_results($pids_sql);
	foreach($pids_info as $pids_info_obj)
	{
		wp_delete_post($pids_info_obj->ID,true);
	}
}
function download_woo_plugin(){
?>	
	<div class="error">
		<p>
			<?php _e('Please download and activate <a href="http://www.woothemes.com/woocommerce/" style="color:#21759B">WooCommerce plugin</a> or <a href="http://jigoshop.com/"  style="color:#21759B">Jigoshop plugin</a> to set up theme with dummy data.&nbsp;&nbsp;&nbsp;',"templatic");?>
		</p>
	</div>
<?php 
}
function activate_woo_plugin(){
	$url = home_url().'/wp-admin/plugins.php';
?>	
	<div class="error">
		<p>
			<?php _e('Please <a href="'.$url.'" style="color:#21759B">activate</a> WooCommerce or Jigoshop plugin</a> to set up theme with dummy data.&nbsp;&nbsp;&nbsp;',"templatic");?>
		</p>
	</div>
<?php 
}



/* Setting For dismiss auto install notification message from themes.php START */
register_activation_hook( __FILE__, 'activate'  );
register_deactivation_hook( __FILE__, 'deactivate'  );
add_action( 'admin_enqueue_scripts', 'register_admin_scripts'  );
add_action( 'wp_ajax_hide_admin_notification', 'hide_admin_notification' );
function activate() {
	add_option( 'hide_ajax_notification', false );
}
function deactivate() {
	delete_option( 'hide_ajax_notification' );
}
function register_admin_scripts() {
	wp_register_script( 'ajax-notification-admin', get_stylesheet_directory_uri().'/js/admin_notification.js'  );
	wp_enqueue_script( 'ajax-notification-admin' );
}
function hide_admin_notification() {
	if( wp_verify_nonce( $_REQUEST['nonce'], 'ajax-notification-nonce' ) ) {
		if( update_option( 'hide_ajax_notification', true ) ) {
			die( '1' );
		} else {
			die( '0' );
		}
	}
}
/* Setting For dismiss auto install notification message from themes.php END */?>