<?php
/**
 * Header Template
 *
 * The header template is generally used on every page of your site. Nearly all other templates call it 
 * somewhere near the top of the file. It is used mostly as an opening wrapper, which is closed with the 
 * footer.php file. It also executes key functions needed by the theme, child themes, and plugins. 
 *
 * @package Catalog
 * @subpackage Template
 */
?>

<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="<?php bloginfo( 'html_type' ); ?>; charset=<?php bloginfo( 'charset' ); ?>" />
	<meta name="viewport" content="width=device-width, initial-scale=1.0"/>
	<title><?php hybrid_document_title(); ?></title>
	<link rel="stylesheet" href="<?php echo get_stylesheet_uri(); ?>" type="text/css" media="all" />
	<link rel="profile" href="http://gmpg.org/xfn/11" />
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
	<?php wp_head(); // wp_head ?>
	<?php /*<script type="text/javascript" src="<?php echo get_stylesheet_directory_uri(); ?>/js/jquery.flexslider-min.js"></script>*/?>
	<link rel="stylesheet" href="<?php echo get_stylesheet_directory_uri(); ?>/css/flexslider.css" type="text/css" media="screen" />
</head>

<body class="<?php hybrid_body_class(); ?>">
	<?php do_atomic( 'open_body' ); // supreme_open_body ?>
	<div class="header_bg">
		<?php 
			$theme_name = get_current_theme();
			$nav_menu = get_option('theme_mods_'.strtolower($theme_name));
			get_template_part( 'menu', 'primary' ); // Loads the menu-primary.php template. 
			
		?>
        <div class="clearfix"></div>
    </div>
    <div class="header_bg_down nav_container">
	<?php 
		do_atomic( 'after_menu_primary' ); // supreme_before_header 
		do_atomic( 'before_header' ); // supreme_before_header 
	?>
	<div id="header">
		<?php do_atomic( 'open_header' ); // supreme_open_header ?>
		<div class="header-wrap">
			<div id="branding">
				<?php if ( hybrid_get_setting( 'supreme_logo_url' ) ) : ?>	
						<h1 id="site-title">
							<a href="<?php echo home_url(); ?>/" title="<?php echo bloginfo( 'name' ); ?>" rel="Home">
								<img class="logo" src="<?php echo hybrid_get_setting( 'supreme_logo_url' ); ?>" alt="<?php echo bloginfo( 'name' ); ?>" />
							</a>
						</h1>
						
				<?php else : 
						hybrid_site_title();
					  endif;

					  if ( !hybrid_get_setting( 'supreme_site_description' ) )  : // If hide description setting is un-checked, display the site description. 
						hybrid_site_description(); 
					  endif;
				?>
				</div><!-- #branding -->
                <?php 
					if(function_exists('dynamic_sidebar')){
						dynamic_sidebar('header_advertisement');
						dynamic_sidebar('header_right');
					}
				?>
			</div><!-- .wrap -->
			<?php do_atomic( 'close_header' ); // supreme_close_header ?>
		</div><!-- #header -->
	<?php do_atomic( 'after_header' ); // supreme_after_header 
			if ( current_theme_supports( 'theme-layouts' ) ) {
				$supreme_layout = theme_layouts_get_layout();
				
				if ( $supreme_layout == 'layout-default' || $supreme_layout == 'layout-1c' || $supreme_layout == 'layout-2c-l' || $supreme_layout == 'layout-2c-r' || $supreme_layout == 'layout-3c-c' || $supreme_layout == 'layout-3c-l' || $supreme_layout == 'layout-3c-r' ) {
					?>
					<div class='wrap'>
				<?php	$theme_name = get_current_theme();
					$nav_menu = get_option('theme_mods_'.strtolower($theme_name));
					if($nav_menu['nav_menu_locations']['secondary'] != 0){
						get_template_part( 'menu', 'secondary' ); // Loads the menu-secondary.php template.
					}elseif(is_active_sidebar('mega_menu')){
						if(function_exists('dynamic_sidebar')){
							dynamic_sidebar('mega_menu');
							
						}	
					}?>
					</div>
				<?php	
				}
			}?>
        <div class="clearfix"></div>
	</div>
	<?php if(is_home()){?>		
			<div class="slider_content">
	<?php		dynamic_sidebar('home-page-slider-widget');?>
			</div>
	<?php } ?>
	
	<div id="container"><div class="container-wrap">
	
		<?php get_sidebar( 'after-header' ); // Loads the sidebar-after-header.php template.
			  get_sidebar( 'after-header-2c' ); // Loads the sidebar-after-header-2c.php template.
			  get_sidebar( 'after-header-3c' ); // Loads the sidebar-after-header-3c.php template.
			  get_sidebar( 'after-header-4c' ); // Loads the sidebar-after-header-4c.php template.
			  get_sidebar( 'after-header-5c' ); // Loads the sidebar-after-header-5c.php template.
			  do_atomic( 'before_main' ); // supreme_before_main ?>
	
		<div id="main">

			<div class="wrap">

			<?php do_atomic( 'open_main' ); // supreme_open_main ?>