<?php
/**
 * Secondary Menu Template
 *
 * Displays the Secondary Menu if it has active menu items.
 *
 * @package Catalog
 * @subpackage Template
 */

if ( has_nav_menu( 'secondary' ) ) : ?>

	<?php do_atomic( 'before_menu_secondary' ); // supreme_before_menu_secondary ?>

	<div id="menu-secondary" class="menu-container">

		<div class="wrap">

			<div id="menu-secondary-title">
				<?php _e( 'Menu', 'supreme' ); ?>
			</div><!-- #menu-secondary-title -->

			<?php do_atomic( 'open_menu_secondary' ); // supreme_open_menu_secondary ?>

			<div class="nav_bg">
				<?php wp_nav_menu( array( 'theme_location' => 'secondary', 'container_class' => 'menu', 'menu_class' => '', 'menu_id' => 'menu-secondary-items', 'fallback_cb' => '' ) ); ?>
				<div class="clearfix"></div>
            </div>

			<?php 
				do_atomic( 'close_menu_secondary' ); // supreme_close_menu_secondary 
				if(function_exists('dynamic_sidebar')){
					dynamic_sidebar('header_search');	
				} 
			?>
		</div>
		
	</div><!-- #menu-secondary .menu-container -->

	<?php do_atomic( 'after_menu_secondary' ); // supreme_after_menu_secondary ?>

<?php else :
		if(function_exists('dynamic_sidebar')){
			dynamic_sidebar('mega_menu');	
		}
endif; ?>