<?php

include("includes/theme_options.php");

if (function_exists('register_sidebar'))

{

    register_sidebar(array(

		'name'			=> '小工具',

        'before_widget'	=> '',

        'after_widget'	=> '',

        'before_title'	=> '<h3>',

        'after_title'	=> '</h3>',

    	'after_widget' => '',

    ));

}

{

    register_sidebar(array(

		'name'			=> '小工具上',

        'before_widget'	=> '',

        'after_widget'	=> '',

        'before_title'	=> '<h3>',

        'after_title'	=> '</h3>',

    	'after_widget' => '',

    ));

}

{

    register_sidebar(array(

		'name'			=> '小工具中',

        'before_widget'	=> '',

        'after_widget'	=> '',

        'before_title'	=> '<h3>',

        'after_title'	=> '</h3>',

    	'after_widget' => '',

    ));

}

{

    register_sidebar(array(

		'name'			=> '小工具下',

        'before_widget'	=> '',

        'after_widget'	=> '',

        'before_title'	=> '<h3>',

        'after_title'	=> '</h3>',

    	'after_widget' => '',

    ));

}



if ( function_exists('register_nav_menus') ) {

    register_nav_menus(array(

        'primary' => '导航菜单'

    ));

}



// 获得特色图像

function get_post_img($width="100",$height="100",$sizeTag=2) {   

    global $post, $posts;   

    $first_img = '';   

       

    $output = preg_match_all('/<img.+src=[\'"]([^\'"]+)[\'"].*>/i', $post->post_content, $matches);

      

    $first_img = '<img src="'. $matches[1][0] .'" width="'.$width.'" height="'.$height.'" alt="'.$post->post_title .'"/>';  

      

    if(empty($matches[1][0])){

        if($sizeTag == 2)

        {

            $first_img = '<img src="'. get_bloginfo('template_url') .'/images/random/small/tb'.rand(1,20).'.jpg" alt="'.$post->post_title .'" width="'.$width.'" height="'.$height.'"/>';   

        }

        else

        {

             $first_img = '<img src="'. get_bloginfo('template_url') .'/images/random/big/big'.rand(1,10).'.jpg" alt="'.$post->post_title .'" width="'.$width.'" height="'.$height.'"/>';

        }  

    }   

       

    return $first_img;   

}  



// 获得热评文章

function simple_get_most_viewed($posts_num=10, $days=90){

    global $wpdb;

    $sql = "SELECT ID , post_title , comment_count

            FROM $wpdb->posts

           WHERE post_type = 'post' AND TO_DAYS(now()) - TO_DAYS(post_date) < $days

		   AND ($wpdb->posts.`post_status` = 'publish' OR $wpdb->posts.`post_status` = 'inherit')

           ORDER BY comment_count DESC LIMIT 0 , $posts_num ";

    $posts = $wpdb->get_results($sql);

    $output = "";

    foreach ($posts as $post){

        $output .= "\n<li><a href= \"".get_permalink($post->ID)."\" target=\"_blank\" rel=\"bookmark\" title=\"".$post->post_title." (".$post->comment_count."条评论)\" >". cut_str($post->post_title,36)."</a></li>";

    }

    echo $output;

}

//标题文字截断

function cut_str($src_str,$cut_length)

{

    $return_str='';

    $i=0;

    $n=0;

    $str_length=strlen($src_str);

    while (($n<$cut_length) && ($i<=$str_length))

    {

        $tmp_str=substr($src_str,$i,1);

        $ascnum=ord($tmp_str);

        if ($ascnum>=224)

        {

            $return_str=$return_str.substr($src_str,$i,3);

            $i=$i+3;

            $n=$n+2;

        }

        elseif ($ascnum>=192)

        {

            $return_str=$return_str.substr($src_str,$i,2);

            $i=$i+2;

            $n=$n+2;

        }

        elseif ($ascnum>=65 && $ascnum<=90)

        {

            $return_str=$return_str.substr($src_str,$i,1);

            $i=$i+1;

            $n=$n+2;

        }

        else 

        {

            $return_str=$return_str.substr($src_str,$i,1);

            $i=$i+1;

            $n=$n+1;

        }

    }

    if ($i<$str_length)

    {

        $return_str = $return_str . '...';

    }

    if (get_post_status() == 'private')

    {

        $return_str = $return_str . '（private）';

    }

    return $return_str;

}



//分页

function pagination($query_string){

global $posts_per_page, $paged;

$my_query = new WP_Query($query_string ."&posts_per_page=-1");

$total_posts = $my_query->post_count;

if(empty($paged))$paged = 1;

$prev = $paged - 1;							

$next = $paged + 1;	

$range = 3; // 修改数字,可以显示更多的分页链接

$showitems = ($range * 2)+1;

$pages = ceil($total_posts/$posts_per_page);

if(1 != $pages){

	echo "<div class='pagination'>";

	echo ($paged > 2 && $paged+$range+1 > $pages && $showitems < $pages)? "<a href='".get_pagenum_link(1)."' class='fir_las'>首</a>":"";

	echo ($paged > 1 && $showitems < $pages)? "<a href='".get_pagenum_link($prev)."' class='page_previous'>上</a>":"";		

	for ($i=1; $i <= $pages; $i++){

	if (1 != $pages &&( !($i >= $paged+$range+1 || $i <= $paged-$range-1) || $pages <= $showitems )){

	echo ($paged == $i)? "<span class='current'>".$i."</span>":"<a href='".get_pagenum_link($i)."' class='inactive' >".$i."</a>"; 

	}

	}

	echo ($paged < $pages && $showitems < $pages) ? "<a href='".get_pagenum_link($next)."' class='page_next'>下</a>" :"";

	echo ($paged < $pages-1 &&  $paged+$range-1 < $pages && $showitems < $pages) ? "<a href='".get_pagenum_link($pages)."' class='fir_las'>末</a>":"";

	echo "</div>\n";

	}

}



//日志归档

	class hacklog_archives

{

	function GetPosts() 

	{

		global  $wpdb;

		if ( $posts = wp_cache_get( 'posts', 'ihacklog-clean-archives' ) )

			return $posts;

		$query="SELECT DISTINCT ID,post_date,post_date_gmt,comment_count,comment_status,post_password FROM $wpdb->posts WHERE post_type='post' AND post_status = 'publish' AND comment_status = 'open'";

		$rawposts =$wpdb->get_results( $query, OBJECT );

		foreach( $rawposts as $key => $post ) {

			$posts[ mysql2date( 'Y.m', $post->post_date ) ][] = $post;

			$rawposts[$key] = null; 

		}

		$rawposts = null;

		wp_cache_set( 'posts', $posts, 'ihacklog-clean-archives' );;

		return $posts;

	}

	function PostList( $atts = array() ) 

	{

		global $wp_locale;

		global $hacklog_clean_archives_config;

		$atts = shortcode_atts(array(

			'usejs'        => $hacklog_clean_archives_config['usejs'],

			'monthorder'   => $hacklog_clean_archives_config['monthorder'],

			'postorder'    => $hacklog_clean_archives_config['postorder'],

			'postcount'    => '1',

			'commentcount' => '1',

		), $atts);

		$atts=array_merge(array('usejs'=>1,'monthorder'   =>'new','postorder'    =>'new'),$atts);

		$posts = $this->GetPosts();

		( 'new' == $atts['monthorder'] ) ? krsort( $posts ) : ksort( $posts );

		foreach( $posts as $key => $month ) {

			$sorter = array();

			foreach ( $month as $post )

				$sorter[] = $post->post_date_gmt;

			$sortorder = ( 'new' == $atts['postorder'] ) ? SORT_DESC : SORT_ASC;

			array_multisort( $sorter, $sortorder, $month );

			$posts[$key] = $month;

			unset($month);

		}

		$html = '<div class="car-container';

		if ( 1 == $atts['usejs'] ) $html .= ' car-collapse';

		$html .= '">'. "\n";

		if ( 1 == $atts['usejs'] ) $html .= '<a href="#" class="car-toggler">展开所有月份'."</a>\n\n";

		$html .= '<ul class="car-list">' . "\n";

		$firstmonth = TRUE;

		foreach( $posts as $yearmonth => $posts ) {

			list( $year, $month ) = explode( '.', $yearmonth );

			$firstpost = TRUE;

			foreach( $posts as $post ) {

				if ( TRUE == $firstpost ) {

                    $spchar = $firstmonth ? '<span class="car-toggle-icon car-minus">-</span>' : '<span class="car-toggle-icon car-plus">+</span>';

					$html .= '	<li><span class="car-yearmonth" style="cursor:pointer;">'.$spchar.' ' . sprintf( __('%1$s %2$d'), $wp_locale->get_month($month), $year );

					if ( '0' != $atts['postcount'] ) 

					{

						$html .= ' <span title="文章数量">(共' . count($posts) . '篇文章)</span>';

					}

                    if ($firstmonth == FALSE) {

					$html .= "</span>\n		<ul class='car-monthlisting' style='display:none;'>\n";

                    } else {

                    $html .= "</span>\n		<ul class='car-monthlisting'>\n";

                    }

					$firstpost = FALSE;

                     $firstmonth = FALSE;

				}

				$html .= '			<li>' .  mysql2date( 'd', $post->post_date ) . '日: <a target="_blank" href="' . get_permalink( $post->ID ) . '">' . get_the_title( $post->ID ) . '</a>';

				if ( '0' != $atts['commentcount'] && ( 0 != $post->comment_count || 'closed' != $post->comment_status ) && empty($post->post_password) )

					$html .= ' <span title="评论数量">(' . $post->comment_count . '条评论)</span>';

				$html .= "</li>\n";

			}

			$html .= "		</ul>\n	</li>\n";

		}

		$html .= "</ul>\n</div>\n";

		return $html;

	}

	function PostCount() 

	{

		$num_posts = wp_count_posts( 'post' );

		return number_format_i18n( $num_posts->publish );

	}

}

if(!empty($post->post_content))

{

	$all_config=explode(';',$post->post_content);

	foreach($all_config as $item)

	{

		$temp=explode('=',$item);

		$hacklog_clean_archives_config[trim($temp[0])]=htmlspecialchars(strip_tags(trim($temp[1])));

	}

}

else

{

	$hacklog_clean_archives_config=array('usejs'=>1,'monthorder'   =>'new','postorder'    =>'new');	

}

$hacklog_archives=new hacklog_archives();



//密码保护提示

function password_hint( $c ){

global $post, $user_ID, $user_identity;

if ( empty($post->post_password) )

return $c;

if ( isset($_COOKIE['wp-postpass_'.COOKIEHASH]) && stripslashes($_COOKIE['wp-postpass_'.COOKIEHASH]) == $post->post_password )

return $c;

if($hint = get_post_meta($post->ID, 'password_hint', true)){

$url = get_option('siteurl').'/wp-pass.php';

if($hint)

$hint = '密码提示：'.$hint;

else

$hint = "请输入您的密码";

if($user_ID)

$hint .= sprintf('欢迎进入，您的密码是：', $user_identity, $post->post_password);

$out = <<<END

<form method="post" action="$url">

<p>这篇文章是受保护的文章，请输入密码继续阅读：</p>

<div>

<label>$hint<br/>

<input type="password" name="post_password"/></label>

<input type="submit" value="输入密码" name="Submit"/>

</div>

</form>

END;

return $out;

}else{

return $c;

}

}

add_filter('the_content', 'password_hint');



//支持外链缩略图

if ( function_exists('add_theme_support') )

 add_theme_support('post-thumbnails');

add_image_size('large', 320, 213, true);

add_image_size('medium', 165, 110,true);

 function catch_first_image() {

  global $post, $posts;

  $first_img = '';

  ob_start();

  ob_end_clean();

  $output = preg_match_all('/<img.+src=[\'"]([^\'"]+)[\'"].*>/i', $post->post_content, $matches);

  $first_img = $matches [1] [0];

  if(empty($first_img)){

		$random = mt_rand(1, 20);

		echo get_bloginfo ( 'stylesheet_directory' );

		echo '/images/random/tb'.$random.'.jpg';

  }

  return $first_img;

 }





//自定义头像

add_filter( 'avatar_defaults', 'fb_addgravatar' );

function fb_addgravatar( $avatar_defaults ) {

$myavatar = get_bloginfo('template_directory') . '/images/Pic/Pic'.rand(1,2).'.png';

  $avatar_defaults[$myavatar] = '自定义头像';

  return $avatar_defaults;

}



//屏蔽评论的HTML代码

function comment_code_filter($incoming_comment) {

    $incoming_comment = htmlspecialchars($incoming_comment,ENT_QUOTES);

    return $incoming_comment;

}

add_filter('comment_text','comment_code_filter');

add_filter('comment_text_rss','comment_code_filter');



// 评论回复/头像缓存

function metro_comment($comment, $args, $depth) {

   $GLOBALS['comment'] = $comment;

global $commentcount,$wpdb, $post;

     if(!$commentcount) { //初始化楼层计数器

          $comments = $wpdb->get_results("SELECT * FROM $wpdb->comments WHERE comment_post_ID = $post->ID AND comment_type = '' AND comment_approved = '1' AND !comment_parent");

          $cnt = count($comments);//获取主评论总数量

          $page = get_query_var('cpage');//获取当前评论列表页码

          $cpp=get_option('comments_per_page');//获取每页评论显示数量

         if (ceil($cnt / $cpp) == 1 || ($page > 1 && $page  == ceil($cnt / $cpp))) {

             $commentcount = $cnt + 1;//如果评论只有1页或者是最后一页，初始值为主评论总数

         } else {

             $commentcount = $cpp * $page + 1;

         }

     }

?>

<li <?php comment_class(); ?> id="comment-<?php comment_ID() ?>">

   <div id="div-comment-<?php comment_ID() ?>" class="comment-body">

      <?php $add_below = 'div-comment'; ?>

		<div class="comment-author vcard"><?php if (get_option('swt_type') == 'Display') { ?>

			<?php

				$p = 'avatar/';

				$f = md5(strtolower($comment->comment_author_email));

				$a = $p . $f .'.jpg';

				$e = ABSPATH . $a;

				if (!is_file($e)){ //当头像不存在就更新

				$d = get_bloginfo('wpurl'). '/avatar/default.jpg';

				$s = '40'; //头像大小 自行根据自己模板设置

				$r = get_option('avatar_rating');

				$g = 'http://www.gravatar.com/avatar/'.$f.'.jpg?s='.$s.'&d='.$d.'&r='.$r;

                $avatarContent = file_get_contents($g);

                file_put_contents($e, $avatarContent);

				if ( filesize($e) == 0 ){ copy($d, $e); }

				};

			?>

			<img src='<?php bloginfo('wpurl'); ?>/<?php echo $a ?>' alt='' class='avatar' />

                <?php { echo ''; } ?>

			<?php } else { include(TEMPLATEPATH . '/comment_gravatar.php'); } ?>

					<div class="floor"><?php

 if(!$parent_id = $comment->comment_parent){

   switch ($commentcount){

     case 2 :echo "沙发";--$commentcount;break;

     case 3 :echo "板凳";--$commentcount;break;

     case 4 :echo "地板";--$commentcount;break;

     default:printf('%1$s楼', --$commentcount);

   }

 }

 ?>

         </div><?php comment_author_link() ?>:<?php edit_comment_link('编辑','&nbsp;&nbsp;',''); ?></div>

		<?php if ( $comment->comment_approved == '0' ) : ?>

			<span style="color:#C00; font-style:inherit">您的评论正在等待审核中...</span>

			<br />			

		<?php endif; ?>

		<?php comment_text() ?>

        

		<div class="clear"></div><span class="datetime"><?php comment_date('Y-m-d') ?> <?php comment_time() ?> </span> <span class="reply"><?php comment_reply_link(array_merge( $args, array('reply_text' => '回复', 'add_below' =>$add_below, 'depth' => $depth, 'max_depth' => $args['max_depth']))); ?></span>

<span class="reply"><?php   

if ( is_user_logged_in() ) {   

$url = get_bloginfo('url');   

echo '<a id="delete-'. $comment->comment_ID .'" href="' . wp_nonce_url("$url/wp-admin/comment.php?action=deletecomment&p=" . $comment->comment_post_ID . '&c=' . $comment->comment_ID, 'delete-comment_' . $comment->comment_ID) . '"" >删除</a>';   

}   

?></span>  

  </div>

<?php

}

function metro_end_comment() {

		echo '</li>';

}



//登陆显示头像

function metro_get_avatar($email, $size = 48){

return get_avatar($email, $size);

}

//彩色标签云

function colorCloud($text) {

$text = preg_replace_callback('|<a (.+?)>|i', 'colorCloudCallback', $text);

return $text;

}

function colorCloudCallback($matches) {

$text = $matches[1];

//$color = dechex(rand(0,16777215));

$colors=array('ffb900','f74e1e','00a4ef','7fba00');

$color=$colors[dechex(rand(0,3))];

$pattern = '/style=(\'|\")(.*)(\'|\")/i';

$text = preg_replace($pattern, "style=\"color:#{$color};$2;\"", $text);

return "<a $text>";

}

add_filter('wp_tag_cloud', 'colorCloud', 1);



//文章彩色标签

function getColorTags() {

$colors=array('ffb900','f74e1e','00a4ef','7fba00');



$posttags = get_the_tags();

if ($posttags) {

    $tagoutput = "";

  foreach($posttags as $tag) {

    $tag_link = get_tag_link($tag->term_id);

    $color=$colors[dechex(rand(0,3))];

    $tagoutput .= '<a class="colortags" style="background-color:#'.$color.'" href="'.$tag_link.'" alt="' . $tag->name . '" title="' . $tag->name . '" rel="tag">' . $tag->name . '</a>  ';

  }

  $tagoutput = substr($tagoutput,0,strlen($tagoutput)-2);

  echo $tagoutput;

}

}



//自动生成版权时间

function comicpress_copyright() {

    global $wpdb;

    $copyright_dates = $wpdb->get_results("

    SELECT

    YEAR(min(post_date_gmt)) AS firstdate,

    YEAR(max(post_date_gmt)) AS lastdate

    FROM

    $wpdb->posts

    WHERE

    post_status = 'publish'

    ");

    $output = '';

    if($copyright_dates) {

    $copyright = "&copy; " . $copyright_dates[0]->firstdate;

    if($copyright_dates[0]->firstdate != $copyright_dates[0]->lastdate) {

    $copyright .= '-' . $copyright_dates[0]->lastdate;

    }

    $output = $copyright;

    }

    return $output;

    }



/** RSS Feed copyright */

function feed_copyright() {

        if(is_single() or is_feed()) {

        $custom_fields = get_post_custom_keys($post_id，，FALSE);

        $blogName= get_bloginfo('name');

        if (!in_array ('copyright', $custom_fields)) 

	{

        $content.= '<div class="feed-tip">';

        $content.= '<div>版权信息：<a rel="bookmark" title="'.get_the_title().'" alt="'.get_the_title().'" href="'.get_permalink().'" target="_blank">《'.mb_strimwidth(get_the_title(), 0, 60, '...').'》</a>由&nbsp;<a title="'.$blogName.'" href="'.get_bloginfo("url").'" alt="'.$blogName.'" target="_blank">'.$blogName.'</a>&nbsp;原创</div>';

        $content.='<div>本文链接：<a rel="bookmark" title="'.get_the_title().'" href="'.get_permalink().'" alt="'.get_the_title().'" target="_blank">'.mb_strimwidth(get_permalink(), 0, 60, '...').'</a></div>';

        $content.= '<div></font>转载请注明转自&nbsp;<a title="'.$blogName.'" href=" '.get_bloginfo("url").'" alt="'.$blogName.'" target="_blank">'.$blogName.'</a></div>';

        $content.= '<div>如果喜欢：<a title="'.$blogName.' | '.get_bloginfo("description").'" href="'.get_bloginfo("rss2_url").'" target="_blank">点此订阅本站</a></div>';

        $content.= '</div>';   



	}

        else{

        $custom = get_post_custom($post_id，，FALSE);

        $custom_value = $custom['copyright'];

        $custom_url=$custom['copyrighturl'] ;

        $content.= '<div class="feed-tip">';

        $content.= '<div>版权信息：<a rel="bookmark" title="'.get_the_title().'" alt="'.get_the_title().'" href="'.get_permalink().'" target="_blank">《'.mb_strimwidth(get_the_title(), 0, 60, '...').'》</a>由<a title="'.$blogName.'" href="'.get_bloginfo("url").'" alt="'.$blogName.'" target="_blank">'.$blogName.'</a>原创</div>';

$content.='<div>本文链接：<a rel="bookmark" title="'.get_the_title().'" href="'.get_permalink().'" alt="'.get_the_title().'" target="_blank">'.mb_strimwidth(get_permalink(), 0, 60, '...').'</a></div>';

                $content.= '<div><a rel="bookmark" title="'.get_the_title().'" href="'.get_permalink().'" target="_blank">'.wp_get_shortlink().'</a>转载请注明转自<a title="'.$blogName.'" href=" '.get_bloginfo("url").'" alt="'.$blogName.'" target="_blank">'.$blogName.'</a></div>';

        $content.= '<div>如果喜欢：<a title="'.$blogName.' | '.get_bloginfo("description").'" href="'.get_bloginfo("rss2_url").'" target="_blank">点此订阅本站</a></div>';

          $content.= '</div>';  }  

        }

        return $content;

}



//add_filter ('the_content', 'feed_copyright');







function single_fenye(){

     if(is_single() or is_feed()) {

         $args1=array(

	'before'=>'<div class="fenye">',

	'after'=>'</div>',

	'next_or_number'=>'next',

	'nextpagelink'=>'下一页',

	'previouspagelink'=>'上一页'

);



 $args2=array(

	'before'=>'<div class="singlePages">',

	'after'=>'</div>',

	'next_or_number'=>'number',

	'link_before'=>'<span>', 

    'link_after'=>'</span>'

);



    $fenye.=wp_link_pages($args1).wp_link_pages($args2);

     }

    return $fenye;

}



//设置个人资料相关选项

function my_profile( $contactmethods ) {

	$contactmethods['weibo_sina'] = '新浪微博';   //增加

	$contactmethods['weibo_tx'] = '腾讯微博';

      $contactmethods['renren'] = '人人';

       $contactmethods['qq'] = 'QQ空间';

	unset($contactmethods['aim']);   //删除

	unset($contactmethods['yim']);

	unset($contactmethods['jabber']);

	return $contactmethods;

}

add_filter('user_contactmethods','my_profile');



//评论邮件通知

function comment_mail_notify($comment_id) {

  $admin_email = get_bloginfo ('admin_email'); // $admin_email 可改為你指定的 e-mail.

  $comment = get_comment($comment_id);

  $comment_author_email = trim($comment->comment_author_email);

  $parent_id = $comment->comment_parent ? $comment->comment_parent : '';

  $to = $parent_id ? trim(get_comment($parent_id)->comment_author_email) : '';

  $spam_confirmed = $comment->comment_approved;

  if (($parent_id != '') && ($spam_confirmed != 'spam') && ($to != $admin_email) && ($comment_author_email == $admin_email)) {

    $wp_email = 'no-reply@' . preg_replace('#^www\.#', '', strtolower($_SERVER['SERVER_NAME'])); // e-mail 發出點, no-reply 可改為可用的 e-mail.

    $subject = '您在 [' . get_option("blogname") . '] 的评论有新的回复';

    $message = '

    <div style="background-color:#eef2fa; border:1px solid #d8e3e8; color:#111; padding:0 15px; -moz-border-radius:5px; -webkit-border-radius:5px; -khtml-border-radius:5px; border-radius:5px;">

      <p>' . trim(get_comment($parent_id)->comment_author) . ', 您好!</p>

      <p>您曾在 [' . get_option("blogname") . '] 的文章 《' . get_the_title($comment->comment_post_ID) . '》 上发表评论:<br />'

       . nl2br(get_comment($parent_id)->comment_content) . '</p>

      <p>' . trim($comment->comment_author) . ' 给您的回复如下:<br />'

       . nl2br($comment->comment_content) . '<br /></p>

      <p>您可以点击 <a href="' . htmlspecialchars(get_comment_link($parent_id)) . '">查看回复的完整內容</a></p>

      <p>欢迎再次光临 <a href="' . get_option('home') . '">' . get_option('blogname') . '</a></p>

      <p>(此郵件由系統自動發出, 請勿回覆.)</p>

    </div>';

	$message = convert_smilies($message);

    $from = "From: \"" . get_option('blogname') . "\" <$wp_email>";

    $headers = "$from\nContent-Type: text/html; charset=" . get_option('blog_charset') . "\n";

    wp_mail( $to, $subject, $message, $headers );

    //echo 'mail to ', $to, '<br/> ' , $subject, $message; // for testing

  }

}

add_action('comment_post', 'comment_mail_notify');



$share_share_auto = 1;

$share_share_type = 'l';



add_action('wp_head','social_share_head');

function social_share_head(){

	global $share_share_type;

?>



<script type="text/javascript">

function social_share(post_id,share){

	if(typeof(_gap)!='undefined'){

		alert('111');

		_gaq.push(["_trackSocial",share, "Share",post_id]);

	}

	window.open('<?php bloginfo('wpurl');?>?share='+share+','+post_id,share,"width=600,height=400,left=150,top=100,scrollbar=no,resize=no");

}

</script>

<?php

}

function social_share(){

	if(is_single()){

		global $post;

		$share_array = array("sina"=>"新浪微博","qzone"=>"QQ空间","yunbiji"=>"云笔记","qq"=>"腾讯微博","renren"=>"人人网","douban"=>"豆瓣","kaixin001"=>"开心网");

?>

<?php single_fenye();?>

<div id="social-share">

	<p>分享到：</p>

	<div class="social-share-left"></div>

	<div class="social-share-center">

	<?php foreach($share_array as $share_key => $share_value){?>

		<a class="<?php echo $share_key;?>-share" rel="nofollow" href="javascript:social_share('<?php echo $post->ID; ?>','<?php echo $share_key;?>')">

			<span class="share-icon-wrapper">

				<span class="share-icon"></span>

			</span>

			<span class="share-shadow-wrapper">

				<span class="share-shadow"></span>

			</span>

		</a>

<?php } ?>

	</div>

	<div class="social-share-right">

</div>

<div class="clear"></div>

</div>

<?php 

	}

}

if($share_share_auto){

	add_filter('the_content','social_share_content');

	function social_share_content($text){

		ob_start();

		social_share();

		$social_share = ob_get_contents();

		ob_end_clean();

		return $text.$social_share;

	}

}

?>

<?php

if(!function_exists('get_post_excerpt')){

	function get_post_excerpt($post){

		$post_excerpt = strip_tags($post->post_excerpt); 

		if(!$post_excerpt){

			$post_excerpt = mb_substr(strip_tags($post->post_content),0,100);

		}

		$post_excerpt = trim(strip_tags($post_excerpt));

		$post_excerpt = str_replace('"', '', $post_excerpt);	

		$post_excerpt = str_replace("\r\n", ' ', $post_excerpt);

		$post_excerpt = str_replace("\n", ' ', $post_excerpt);

		return $post_excerpt;

	}

}

if(!function_exists('get_post_first_image')){

	function get_post_first_image($post_content){

		preg_match_all('|<img.*?src=[\'"](.*?)[\'"].*?>|i', $post_content, $matches);			

		return $matches[1][0];

	}

}

add_action('init', 'social_share_redirect', 5);

function social_share_redirect(){

	$share = $_GET['share'];

	if(!$share){

		return;

	}

	

	$share = explode(",", $share);

	$post_id = $share[1];

	$share = $share[0];	

	

	$post = get_post($post_id);

	

	$post_link = get_permalink($post_id).'?utm_campaign=Share&utm_medium=share&utm_source='.$share;

	$post_title = $post->post_title;

	$post_excerpt =  get_post_excerpt($post).' '.$post_link;

	$pic = get_post_first_image($post->post_content);





	

switch($share){

		case "sina":

			$link = 'http://www.jiathis.com/send/?webid=tsina&url=='.urlencode($post_link).'&title='.

urlencode('【'.$post_title.'】'.$post_excerpt) .'&source=&sourceUrl=&content=utf-8&pic='.urlencode($pic);

			break;

		case "yunbiji":

			$link = 'http://www.jiathis.com/send/?webid=xiaoyou&url='.urlencode($post_link).'&title='.urlencode($post_title) .'&content='.urlencode($post_excerpt);

			break;

		case "qq":

			$link = 'http://www.jiathis.com/send/?webid=tqq&url='.urlencode($post_link).'&title='.urlencode($post_title) .'&site=&pic='.urlencode($pic);

			break;

		case "douban":

			$link = 'http://www.jiathis.com/send/?webid=douban&url='.urlencode($post_link).'&title='.urlencode($post_title).'&sel=&v=1';

			break;

		case "kaixin001":

			$link ='http://www.jiathis.com/send/?webid=kaixin001&url='.urlencode($post_link).'&title='.urlencode($post_title).'&content='.$post_excerpt;

			break;

		case "renren":

			$link ='http://www.jiathis.com/send/?webid=renren&url='.urlencode($post_link).'&title='.urlencode($post_title);

			break;

		case "qzone":

			$link = "http://www.jiathis.com/send/?webid=qzone&url=".urlencode($post_link);

			break;

		default:

			break;

	}

    Header( "HTTP/1.1 301 Moved Permanently" );

	Header( "Location: $link" );

	exit;

}

//全部设置结束  

function mul_excerpt ($excerpt) {

  $myexcerpt = substr($excerpt,0,255);

  return utf8_trim($myexcerpt) . '... ';

}

function show_cats (){

	foreach((get_the_category()) as $category) {	

		echo $category->cat_name.'/';

	} 

}





$new_meta_boxes =

array(

    "businesses" => array(

        "name" => "businesses",

        "std" => "",

        "title" => "商家:"),

	"businesses_link" => array(

        "name" => "businesses_link",

        "std" => "http://",

        "title" => "商家网站:(别忘了加http://)"),

    "link" => array(

        "name" => "link",

        "std" => "",

        "title" => "商品网址:"),

    "price" => array(

        "name" => "price",

        "std" => "",

        "title" => "折扣价:"),

     "oldprice" => array(

        "name" => "oldprice",

        "std" => "",

        "title" => "原价:")

);

function new_meta_boxes() {

    global $post, $new_meta_boxes;



    foreach($new_meta_boxes as $meta_box) {

        $meta_box_value = get_post_meta($post->ID, $meta_box['name'], true);



        if($meta_box_value == "")

            $meta_box_value = $meta_box['std'];



        echo'<input type="hidden" name="'.$meta_box['name'].'_noncename" id="'.$meta_box['name'].'_noncename" value="'.wp_create_nonce( plugin_basename(__FILE__) ).'" />';



        // 自定义字段标题

        echo'<h4>'.$meta_box['title'].'</h4>';



        // 自定义字段输入框

        echo '<textarea rows="3" name="'.$meta_box['name'].'">'.$meta_box_value.'</textarea><br />';

    }

}

function create_meta_box() {

    global $theme_name;



    if ( function_exists('add_meta_box') ) {

        add_meta_box( 'new-meta-boxes', '商品信息', 'new_meta_boxes', 'post', 'normal', 'high' );

    }

}



function save_postdata( $post_id ) {

    global $post, $new_meta_boxes;



    foreach($new_meta_boxes as $meta_box) {

        if ( !wp_verify_nonce( $_POST[$meta_box['name'].'_noncename'], plugin_basename(__FILE__) ))  {

            return $post_id;

        }



        if ( 'page' == $_POST['post_type'] ) {

            if ( !current_user_can( 'edit_page', $post_id ))

                return $post_id;

        }

        else {

            if ( !current_user_can( 'edit_post', $post_id ))

                return $post_id;

        }



        $data = $_POST[$meta_box['name']];



        if(get_post_meta($post_id, $meta_box['name']) == "")

            add_post_meta($post_id, $meta_box['name'], $data, true);

        elseif($data != get_post_meta($post_id, $meta_box['name'], true))

            update_post_meta($post_id, $meta_box['name'], $data);

        elseif($data == "")

            delete_post_meta($post_id, $meta_box['name'], get_post_meta($post_id, $meta_box['name'], true));

    }



}



add_action('admin_menu', 'create_meta_box');

add_action('save_post', 'save_postdata');

// 开启链接模块

add_filter( 'pre_option_link_manager_enabled', '__return_true' );

// 附件自动重命名

function new_filename($filename) {

    $info = pathinfo($filename);

    $ext = empty($info['extension']) ? '' : '.' . $info['extension'];

    $name = basename($filename, $ext);

    return substr(md5($name), 0, 15) . $ext;

}

 // RSS feed加入缩略图

add_filter('sanitize_file_name', 'new_filename', 10);



function diw_post_thumbnail_feeds($content) {

	global $post;

	if(has_post_thumbnail($post->ID)) {

		$content = '<div>' . get_the_post_thumbnail($post->ID) . '</div>' . $content;

	}

	return $content;

}

add_filter('the_excerpt_rss', 'diw_post_thumbnail_feeds');

add_filter('the_content_feed', 'diw_post_thumbnail_feeds');



?>