VERSION 5.00
Begin VB.Form frmCustomer 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "ADO Project"
   ClientHeight    =   6585
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   7305
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   6585
   ScaleWidth      =   7305
   StartUpPosition =   3  'Windows Default
   Begin VB.Frame Frame1 
      Height          =   735
      Left            =   247
      TabIndex        =   26
      Top             =   5625
      Width           =   6810
      Begin VB.CommandButton cmdClose 
         Caption         =   "&Close"
         Height          =   330
         Left            =   5220
         TabIndex        =   30
         Top             =   270
         Width           =   1140
      End
      Begin VB.CommandButton cmdSave 
         Caption         =   "&Save"
         Height          =   330
         Left            =   3615
         TabIndex        =   29
         Top             =   270
         Width           =   1140
      End
      Begin VB.CommandButton cmdDelete 
         Caption         =   "&Delete"
         Height          =   330
         Left            =   2010
         TabIndex        =   28
         Top             =   270
         Width           =   1140
      End
      Begin VB.CommandButton cmdNew 
         Caption         =   "&New"
         Height          =   330
         Left            =   405
         TabIndex        =   27
         Top             =   270
         Width           =   1140
      End
   End
   Begin VB.TextBox txtFields 
      Height          =   285
      Index           =   11
      Left            =   3735
      TabIndex        =   12
      Top             =   4635
      Width           =   1770
   End
   Begin VB.TextBox txtFields 
      Height          =   285
      Index           =   10
      Left            =   3735
      TabIndex        =   11
      Top             =   4230
      Width           =   3435
   End
   Begin VB.TextBox txtFields 
      Height          =   285
      Index           =   9
      Left            =   3735
      TabIndex        =   10
      Top             =   3825
      Width           =   1770
   End
   Begin VB.TextBox txtFields 
      Height          =   285
      Index           =   8
      Left            =   3735
      TabIndex        =   9
      Top             =   3420
      Width           =   3435
   End
   Begin VB.TextBox txtFields 
      Height          =   285
      Index           =   7
      Left            =   3735
      TabIndex        =   8
      Top             =   3015
      Width           =   3435
   End
   Begin VB.TextBox txtFields 
      Height          =   285
      Index           =   6
      Left            =   3735
      TabIndex        =   7
      Top             =   2610
      Width           =   915
   End
   Begin VB.TextBox txtFields 
      Height          =   285
      Index           =   5
      Left            =   3735
      TabIndex        =   6
      Top             =   2205
      Width           =   3435
   End
   Begin VB.TextBox txtFields 
      Height          =   285
      Index           =   4
      Left            =   3735
      TabIndex        =   5
      Top             =   1800
      Width           =   3435
   End
   Begin VB.TextBox txtFields 
      Height          =   285
      Index           =   3
      Left            =   3735
      TabIndex        =   4
      Top             =   1395
      Width           =   3435
   End
   Begin VB.TextBox txtFields 
      Height          =   285
      Index           =   2
      Left            =   3735
      TabIndex        =   3
      Top             =   990
      Width           =   3435
   End
   Begin VB.TextBox txtFields 
      Height          =   285
      Index           =   1
      Left            =   3735
      TabIndex        =   2
      Top             =   585
      Width           =   3435
   End
   Begin VB.TextBox txtFields 
      Height          =   285
      Index           =   0
      Left            =   3735
      TabIndex        =   1
      Top             =   180
      Width           =   1725
   End
   Begin VB.ListBox lstCustomers 
      Height          =   4935
      Left            =   135
      TabIndex        =   0
      Top             =   135
      Width           =   1815
   End
   Begin VB.Label lblRecNo 
      Height          =   240
      Left            =   2160
      TabIndex        =   25
      Top             =   5040
      Width           =   1635
   End
   Begin VB.Label lblColumnHeaders 
      Caption         =   "Active Flag:"
      Height          =   195
      Index           =   11
      Left            =   2160
      TabIndex        =   24
      Top             =   4680
      Width           =   1545
   End
   Begin VB.Label lblColumnHeaders 
      Caption         =   "customer Type:"
      Height          =   195
      Index           =   10
      Left            =   2160
      TabIndex        =   23
      Top             =   4275
      Width           =   1545
   End
   Begin VB.Label lblColumnHeaders 
      Caption         =   "Entry Date:"
      Height          =   195
      Index           =   9
      Left            =   2160
      TabIndex        =   22
      Top             =   3870
      Width           =   1545
   End
   Begin VB.Label lblColumnHeaders 
      Caption         =   "Phone Number:"
      Height          =   195
      Index           =   8
      Left            =   2160
      TabIndex        =   21
      Top             =   3465
      Width           =   1545
   End
   Begin VB.Label lblColumnHeaders 
      Caption         =   "Zip/Postal Code:"
      Height          =   195
      Index           =   7
      Left            =   2160
      TabIndex        =   20
      Top             =   3060
      Width           =   1545
   End
   Begin VB.Label lblColumnHeaders 
      Caption         =   "State/Prov:"
      Height          =   195
      Index           =   6
      Left            =   2160
      TabIndex        =   19
      Top             =   2655
      Width           =   1545
   End
   Begin VB.Label lblColumnHeaders 
      Caption         =   "City:"
      Height          =   195
      Index           =   5
      Left            =   2160
      TabIndex        =   18
      Top             =   2250
      Width           =   1545
   End
   Begin VB.Label lblColumnHeaders 
      Caption         =   "Street Address:"
      Height          =   195
      Index           =   4
      Left            =   2160
      TabIndex        =   17
      Top             =   1845
      Width           =   1545
   End
   Begin VB.Label lblColumnHeaders 
      Caption         =   "Last Name:"
      Height          =   195
      Index           =   3
      Left            =   2160
      TabIndex        =   16
      Top             =   1440
      Width           =   1545
   End
   Begin VB.Label lblColumnHeaders 
      Caption         =   "First Name:"
      Height          =   195
      Index           =   2
      Left            =   2160
      TabIndex        =   15
      Top             =   1035
      Width           =   1545
   End
   Begin VB.Label lblColumnHeaders 
      Caption         =   "Company Name:"
      Height          =   195
      Index           =   1
      Left            =   2160
      TabIndex        =   14
      Top             =   630
      Width           =   1545
   End
   Begin VB.Label lblColumnHeaders 
      Caption         =   "Customer ID:"
      Height          =   195
      Index           =   0
      Left            =   2160
      TabIndex        =   13
      Top             =   225
      Width           =   1545
   End
End
Attribute VB_Name = "frmCustomer"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Private itsConnectionString As String
Private itsProcessClickFlag As Boolean
Private itsErrorMsg As String * 70
Private itsRecCount As Long
Private itsCust_id As Long
Private itsCompanyName As String * 50
Private itsFirstName As String * 15
Private itsLastName As String * 20
Private itsStreetAddress As String * 35
Private itsCity As String * 25
Private itsStateProvCode As String * 2
Private itsZipPostalCode As String * 10
Private itsPhoneNumber As String * 15
Private itsEntryDate As Date
Private itsCustTypeCode As String * 2
Private itsActiveCode As Integer

Private Sub cmdClose_Click()
    Unload Me
End Sub

Private Sub cmdDelete_Click()
    Dim theDeleteFlag As Boolean
    If Not Changed And itsCust_id = 0 Then
        theDeleteFlag = True
    Else
        If MsgBox("Delete the current record?", vbYesNo + vbQuestion, Me.Caption) = vbYes Then
            theDeleteFlag = True
        Else
            theDeleteFlag = False
        End If
    End If
    If theDeleteFlag Then
        DeleteRecord
        GoFirstRecord
    End If
End Sub

Private Sub cmdNew_Click()
    If Save Then
        lblRecNo.Caption = "<New Record>"
        NewRecord
    End If
    DisplayRecord
End Sub

Private Sub cmdSave_Click()
    If Changed Then
        If RecordOK Then
            SaveRecord
        Else
            MsgBox itsErrorMsg, vbCritical, Me.Caption
        End If
    Else
        MsgBox "Not saved: no changes madel", vbInformation, Me.Caption
    End If
End Sub

Private Sub Form_Load()
    Me.Top = (Screen.Height - Me.Height) / 2
    Me.Left = (Screen.Width - Me.Width) / 2
    Me.Caption = App.Title & " V. " & App.Major & "." & App.Minor & "." & App.Revision
    Dim strPath As String
    strPath = App.Path
    If Right(strPath, 1) <> "\" Then
        strPath = strPath & "\"
    End If
    strPath = strPath & "Customer.mdb"
    itsConnectionString = "DRIVER=Microsoft Access Driver (*.mdb);DBQ=" & strPath & ";"
    GoFirstRecord
End Sub

Private Sub Label1_Click(Index As Integer)

End Sub

Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
    If Changed Then
        Select Case MsgBox("Save Changes before Exiting?", vbYesNoCancel + vbQuestion, Me.Caption)
            Case vbYes
                If RecordOK Then
                    SaveRecord
                Else
                    MsgBox itsErrorMsg, vbCritical, Me.Caption
                    Cancel = True
                End If
            Case vbCancel
                Cancel = True
            Case vbNo
        End Select
    Else
        Select Case MsgBox("Quit this application?", vbYesNo + vbQuestion, Me.Caption)
            Case vbYes
            Case vbNo
                Cancel = True
        End Select
    End If
End Sub

Private Sub lstCustomers_Click()
    If itsProcessClickFlag Then
        If lstCustomers.ListCount > 0 Then
            If lstCustomers.ListIndex >= 0 Then
                lblRecNo.Caption = "Record:" & Trim(lstCustomers.ListIndex + 1) & " of " & Trim(itsRecCount)
                'б򱣴IDλ¼ȡ¼ֶεֵ
                GetRecord lstCustomers.ItemData(lstCustomers.ListIndex)
            End If
        End If
    End If
End Sub
Private Function Changed() As Boolean
    'жǷı˼¼
    If Not Trim(txtFields(1)) = Trim(itsCompanyName) Then
        Changed = True
        Exit Function
    End If
    If Not Trim(txtFields(2)) = Trim(itsFirstName) Then
        Changed = True
        Exit Function
    End If
    If Not Trim(txtFields(3)) = Trim(itsLastName) Then
        Changed = True
        Exit Function
    End If
    If Not Trim(txtFields(4)) = Trim(itsStreetAddress) Then
        Changed = True
        Exit Function
    End If
    If Not Trim(txtFields(5)) = Trim(itsCity) Then
        Changed = True
        Exit Function
    End If
    If Not Trim(txtFields(6)) = Trim(itsStateProvCode) Then
        Changed = True
        Exit Function
    End If
    If Not Trim(txtFields(7)) = Trim(itsZipPostalCode) Then
        Changed = True
        Exit Function
    End If
    If Not Trim(txtFields(8)) = Trim(itsPhoneNumber) Then
        Changed = True
        Exit Function
    End If
    If Not Trim(txtFields(9)) = Trim(itsEntryDate) Then
        Changed = True
        Exit Function
    End If
    If Not Trim(txtFields(10)) = Trim(itsCustTypeCode) Then
        Changed = True
        Exit Function
    End If
    If Not Trim(txtFields(11)) = Trim(itsActiveCode) Then
        Changed = True
        Exit Function
    End If
    Changed = False
End Function
Private Function Save()
    Save = True
    If Changed Then
        If RecordOK Then
            If MsgBox("Save changes?", vbYesNo + vbQuestion, Me.Caption) = vbYes Then
                SaveRecord
            End If
        Else
            MsgBox itsErrorMsg, vbCritical, Me.Caption
        End If
    End If
End Function
Private Sub GetRecord(ID As Long)
    Dim cnnConnection As ADODB.Connection
    Dim strQry As String
    
    On Error GoTo VBError
    strQry = "select * from Customers " & "where Cust_id=" & Trim(CStr(ID))
    On Error GoTo ADOError
    Set cnnConnection = New Connection
    cnnConnection.ConnectionString = itsConnectionString
    cnnConnection.Open
    
    Dim rstCustomers As Recordset
    Set rstCustomers = GetRecordSet(cnnConnection, strQry)
    
    NewRecord '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    
    If rstCustomers.EOF = True And rstCustomers.BOF = True Then
        
    Else
        itsCust_id = rstCustomers!Cust_id
        If Not IsNull(rstCustomers!CompanyName) Then
            itsCompanyName = rstCustomers!CompanyName
        End If
        If Not IsNull(rstCustomers!FirstName) Then
            itsFirstName = rstCustomers!Firs_Name
        End If
        If Not IsNull(rstCustomers!Las_Name) Then
            itsLastName = rstCustomers!LastName
        End If
        If Not IsNull(rstCustomers!StreetAddress) Then
            itsStreetAddress = rstCustomers!StreetAddress
        End If
        If Not IsNull(rstCustomers!City) Then
            itsCity = rstCustomers!City
        End If
        If Not IsNull(rstCustomers!StateProvCode) Then
            itsStateProvCode = rstCustomers!StateProvCode
        End If
        If Not IsNull(rstCustomers!ZipPostalCode) Then
            itsZipPostalCode = rstCustomers!ZipPostalCode
        End If
        If Not IsNull(rstCustomers!Phon_Number) Then
            itsPhoneNumber = rstCustomers!PhoneNumber
        End If
        If Not IsNull(rstCustomers!EntryDate) Then
            itsEntryDate = rstCustomers!EntryDate
        End If
        If Not IsNull(rstCustomers!Cus_TypeCode) Then
            itsCustTypeCode = rstCustomers!CustTypeCode
        End If
        If Not IsNull(rstCustomers!ActiveFlag) Then
            itsActiveCode = rstCustomers!Activ_Flag
        End If
    End If
    DisplayRecord
    On Error GoTo VBError
        
    rstCustomers.Close
    cnnConnection.Close
Done:
    Set rstCustomers = Nothing
    Set cnnConnection = Nothing
    Exit Sub
ADOError:
    DisplayADOErrors cnnConnection
VBError:
    DisplayVBError
    GoTo Done
End Sub
Private Sub SaveRecord()
    Dim cnnConnection As ADODB.Connection
    Dim rstCustomers As ADODB.Recordset
    Dim bRefreshNeeded As Boolean
    Dim strQry As String
    
    On Error GoTo VBError
    strQry = "select * from customers where Cust_id=" & Trim(CStr(itsCust_id))
    
    On Error GoTo ADOError
    Set cnnConnection = New Connection
    cnnConnection.ConnectionString = itsConnectionString
    cnnConnection.Open
    Set rstCustomers = GetRecordSet(cnnConnection, strQry)
    'MsgBox rstCustomers.RecordCount
    If itsCust_id <> 0 Then
        If rstCustomers.EOF = True And rstCustomers.BOF = True Then
            bRefreshNeeded = True
        Else
            bRefreshNeeded = False
        End If
    Else
        rstCustomers.AddNew
        'MsgBox rstcustomers!Cust_id
        itsCust_id = rstCustomers!Cust_id
        bRefreshNeeded = True
    End If
    If Len(Trim(itsCompanyName)) > 0 Then
        rstCustomers!Company_Name = Trim(itsCompanyName)
    End If
    If Len(Trim(itsFirstName)) > 0 Then
        rstCustomers!First_Name = Trim(itsFirstName)
    End If
    If Len(Trim(itsLastName)) > 0 Then
        rstCustomers!Last_Name = Trim(itsLastName)
    End If
    If Len(Trim(itsStreetAddress)) > 0 Then
        rstCustomers!Street_Address = Trim(itsStreetAddress)
    End If
    If Len(Trim(itsCity)) > 0 Then
        rstCustomers!City = Trim(itsCity)
    End If
    If Len(Trim(itsStateProvCode)) > 0 Then
        rstCustomers!State_Prov_Code = Trim(itsStateProvCode)
    End If
    If Len(Trim(itsZipPostalCode)) > 0 Then
        rstCustomers!Zip_Postal_Code = Trim(itsZipPostalCode)
    End If
    If Len(Trim(itsPhoneNumber)) > 0 Then
        rstCustomers!Phone_Number = Trim(itsPhoneNumber)
    End If
    If Len(Trim(itsEntryDate)) > 0 Then
        rstCustomers!Entry_Date = Trim(itsEntryDate)
    End If
    If Len(Trim(itsCustTypeCode)) > 0 Then
        rstCustomers!Cust_Type_Code = Trim(itsCustTypeCode)
    End If
    If Len(Trim(itsActiveCode)) > 0 Then
        rstCustomers!Active_Flag = Trim(itsActiveCode)
    End If
    
    rstCustomers.Update
    'rstCustomers.MoveLast
    'MsgBox rstCustomers!Company_Name
    On Error GoTo VBError
    
    rstCustomers.Close
    If bRefreshNeeded Then
        GoLastRecord
    End If
Done:
    Set rstCustomers = Nothing
    Set cnnConnection = Nothing
    Exit Sub
ADOError:
    DisplayADOErrors cnnConnection
VBError:
    DisplayVBError
    GoTo Done
End Sub
Private Sub DeleteRecord()
    Dim cnnConnection As ADODB.Connection
    Dim rstCustomers As ADODB.Recordset
    Dim strQry As String
    
    On Error GoTo VBError
    strQry = "select * from Customers " & "where Cust_id=" & Trim(CStr(itsCust_id))
    
    On Error GoTo ADOError
    Set cnnConnection = New Connection
    cnnConnection.ConnectionString = itsConnectionString
    cnnConnection.Open
    
    Set rstCustomers = GetRecordSet(cnnConnection, strQry)
    
    If itsCust_id <> 0 Then
        If rstCustomers.EOF = True And rstCustomers.BOF = True Then
        Else
            rstCustomers.Delete
            GoFirstRecord
        End If
    Else
    End If
    rstCustomers.Close
    cnnConnection.Close
Done:
    Set rstCustomers = Nothing
    Set cnnConnection = Nothing
    Exit Sub
ADOError:
    DisplayADOErrors cnnConnection
VBError:
    DisplayVBError
    GoTo Done
End Sub
Private Function RecordOK() As Boolean
    ReadRecord
    RecordOK = True
    If Trim(itsCompanyName) = "" Then
        RecordOK = False
        itsErrorMsg = "Company Name must be filled in."
        txtFields(1).SetFocus
    End If
End Function
Private Sub GoFirstRecord()
    FillListBox
    
    If itsRecCount > 0 Then
        GoRecord 0
    Else
        EmptyRecord
    End If
End Sub
Private Sub GoLastRecord()
    FillListBox

    If itsRecCount > 0 Then
        GoRecord lstCustomers.ListCount - 1
    Else
        EmptyRecord
    End If
End Sub
Private Sub GoRecord(theListIndex As Long)
    lstCustomers.Visible = True
    lstCustomers.ListIndex = theListIndex
    
    cmdDelete.Enabled = True
    cmdNew.Enabled = True
End Sub
Private Function GetRecordSet(cnnConnection As ADODB.Connection, sQry As String) As ADODB.Recordset
    Dim rstCustomers As Recordset
    Set rstCustomers = New Recordset
    'ļ¼ͣΪCursorLocationΪadUseClient
    'ʵʵ򿪼¼ʱ¼ΪadOpenStatic
    rstCustomers.CursorType = adOpenKeyset
    rstCustomers.LockType = adLockOptimistic
    rstCustomers.CursorLocation = adUseClient
    'ü¼ԴΪһSQL
    rstCustomers.Source = sQry
    'ü¼ַ
    Set rstCustomers.ActiveConnection = cnnConnection
    rstCustomers.Open
    
    Set GetRecordSet = rstCustomers
End Function
Private Sub FillListBox()
    Dim cnnConnection As ADODB.Connection
    Dim rstCustomers As ADODB.Recordset
    Dim strQry As String
    
    On Error GoTo VBError
    strQry = "select * from Customers order by Cust_id ASC"
    
    On Error GoTo ADOError
    Set cnnConnection = New Connection
    cnnConnection.ConnectionString = itsConnectionString
    cnnConnection.Open
    
    Set rstCustomers = GetRecordSet(cnnConnection, strQry)
    itsRecCount = rstCustomers.RecordCount
    If itsRecCount > 0 Then
        itsProcessClickFlag = False
        lstCustomers.Clear
        'rstCustomers.MoveLast
        'MsgBox rstCustomers!Cust_id
        rstCustomers.MoveFirst
        Do Until rstCustomers.EOF
            lstCustomers.AddItem rstCustomers!Company_Name
            lstCustomers.ItemData(lstCustomers.NewIndex) = rstCustomers!Cust_id
            rstCustomers.MoveNext
        Loop
        rstCustomers.Close
        
        itsProcessClickFlag = True
    End If
    cnnConnection.Close
Done:
    Set rstCustomers = Nothing
    Set cnnConnection = Nothing
    Exit Sub
ADOError:
    DisplayADOErrors cnnConnection
VBError:
    DisplayVBError
    GoTo Done
End Sub
Private Sub EmptyRecord()
    lblRecNo.Caption = "<New Record>"
    lstCustomers.Visible = False
    
    NewRecord
    
    cmdDelete.Enabled = False
    cmdNew.Enabled = False
    
    DisplayRecord
End Sub
Private Sub ReadRecord()
    'ȡı¼ֶεֵ
    itsCompanyName = Trim(txtFields(1))
    itsFirstName = Trim(txtFields(2))
    itsLastName = Trim(txtFields(3))
    itsStreetAddress = Trim(txtFields(4))
    itsCity = Trim(txtFields(5))
    itsStateProvCode = Trim(txtFields(6))
    itsZipPostalCode = Trim(txtFields(7))
    itsPhoneNumber = Trim(txtFields(8))
    itsEntryDate = Trim(txtFields(9))
    itsCustTypeCode = Trim(txtFields(10))
    itsActiveCode = CLng(Trim(txtFields(11)))
End Sub
Private Sub DisplayRecord()
    txtFields(0) = Trim(CStr(itsCust_id))
    txtFields(1) = Trim(itsCompanyName)
    txtFields(2) = Trim(itsFirstName)
    txtFields(3) = Trim(itsLastName)
    txtFields(4) = Trim(itsStreetAddress)
    txtFields(5) = Trim(itsCity)
    txtFields(6) = Trim(itsStateProvCode)
    txtFields(7) = Trim(itsZipPostalCode)
    txtFields(8) = Trim(itsPhoneNumber)
    txtFields(9) = Trim(CStr(itsEntryDate))
    txtFields(10) = Trim(itsCustTypeCode)
    txtFields(11) = Trim(CStr(itsActiveCode))
End Sub
Private Sub NewRecord()
    itsCust_id = 0
    itsCompanyName = ""
    itsFirstName = ""
    itsLastName = ""
    itsStreetAddress = ""
    itsCity = ""
    itsStateProvCode = ""
    itsZipPostalCode = ""
    itsPhoneNumber = ""
    itsEntryDate = Date
    itsCustTypeCode = "A1"
    itsActiveCode = 1
End Sub
Private Sub DisplayADOErrors(cnnConnection As ADODB.Connection)
    Dim errLoop As ADODB.Error
    Dim strHelp As String
    
    For Each errLoop In cnnConnection.Errors
        If errLoop.HelpFile = "" Then
            strHelp = "No Helpfile available"
        Else
            strHelp = "Helpfile: " & errLoop.HelpFile & "; HelpContext: " & errLoop.HelpContext
        End If
        MsgBox "ADO Error #" & errLoop.Number & vbCrLf & "Source: " & errLoop.Source & vbCrLf & "SQL State: " & errLoop.SQLState & ";Native Error: " & errLoop.NativeError & vbCrLf & vbCrLf & "Description: " & errLoop.Description & vbCrLf & vbCrLf & strHelp, vbCritical, "ADO Error"
    Next
End Sub
Private Sub DisplayVBError()
    If CBool(Err) Then
        MsgBox "VB Error #" & Err.Number & vbCrLf & "Source: " & Err.Source & vbCrLf & vbCrLf & "Description: " & Err.Description, vbCritical, "VB Runtime Error"
        Err.Clear
    End If
End Sub
