
#ifndef IEFFECT_H
#define IEFFECT_H

#ifndef _WINDEF_
#include <WinDef.h>
#endif

////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
struct AnimationParam
{
	// ID
	WPARAM				effectKey;
	// ͼƬԴ
	HBITMAP				hBitmap;
	// ͼƬDC
	HDC					hdc;
	// ͼƬߴ
	SIZE				bmpSize;
	// ͼƬڴַ
	BYTE*				pBmpData;
	// 
	DWORD				animationEffect;
	// ֡ʱ
	DWORD				animationFrequency;
	// ˳
	BOOL				bShow;
};

class _declspec(novtable) IUIEffectCallBack
{
public:
	// ÿһ  ʼʱص
	virtual void OnUiEffectBegin(WPARAM effectKey, DWORD animaType) = 0;
	// ÿһ  ʱص
	virtual void OnUiEffectEnd(WPARAM effectKey, DWORD animaType) = 0;
	// ÿһ ֡ ʱص
	virtual void OnUiEffectDraw() = 0;
};


class _declspec(novtable) IUIEffect
{
public:
	// һ
	virtual BOOL AppendAnimation(AnimationParam &aParam) = 0;
	// ɾһ
	virtual BOOL DependAnimation(WPARAM effectKey) = 0;
	// ɾж
	virtual BOOL ClearAllAnimation() = 0;
	// ִжframeSpin
	virtual BOOL Animation(IUIEffectCallBack *iDrawEffect,DWORD frameSpin) = 0;

};

// 
// öʵ
IUIEffect* GetAnimation(void);
// ɾGetAnimationõĶʵ
BOOL ReleaseAnimation(IUIEffect* &pUIEffect);
// ֵ֧Ķͣ\0Ϊָ
// ַе˳Ƕֵ1...N
DWORD GetSurportAnimationType(const char* &strType);

typedef IUIEffect* (*GETANIMATION)();
typedef BOOL (*RELEASEANIMATION)(IUIEffect* &);
typedef DWORD (*GETSURPORTANIMATIONTYPE)(const char* &);

////////////////////////////////////////////////////////////////////////////////////////////////////////////////

class _declspec(novtable) IImageProcess
{
public:
	// alpha 
	virtual BOOL AlphaBlend(BYTE *desData, int desStride, int desLeft, int desTop, int desWidth, int desHeight, BYTE *srcData, int srcStride, int srcLeft, int srcTop, int srcWidth, int srcHeight, BYTE sourceAlpha = 255, int interpolationMode = 0) = 0;
	// ͼƬ
	virtual BOOL ImageScale(BYTE *DataDes, int desWidth, int desHeight, BYTE *DataSrc, int srcStride, int srcLeft, int srcTop, int srcWidth, int srcHeight, int interpolationMode = 0) = 0;
};

// 
// ͼʵ
IImageProcess* GetImageProcess(void);
// ɾGetImageProcessõͼʵ
BOOL ReleaseImageProcess(IImageProcess* &pProcess);

typedef IImageProcess* (*GETIMAGEPORCESS)();
typedef BOOL (*RELEASEIMAGEPROCESS)(IImageProcess* &);

////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
