/*
	Apache License
	Version 2.0, January 2004
	http://www.apache.org/licenses/
	
	TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION
	
	1. Definitions.
	
	"License" shall mean the terms and conditions for use, reproduction, and
	distribution as defined by Sections 1 through 9 of this document.
	
	"Licensor" shall mean the copyright owner or entity authorized by the copyright
	owner that is granting the License.
	
	"Legal Entity" shall mean the union of the acting entity and all other entities
	that control, are controlled by, or are under common control with that entity.
	For the purposes of this definition, "control" means (i) the power, direct or
	indirect, to cause the direction or management of such entity, whether by
	contract or otherwise, or (ii) ownership of fifty percent (50%) or more of the
	outstanding shares, or (iii) beneficial ownership of such entity.
	
	"You" (or "Your") shall mean an individual or Legal Entity exercising
	permissions granted by this License.
	
	"Source" form shall mean the preferred form for making modifications, including
	but not limited to software source code, documentation source, and configuration
	files.
	
	"Object" form shall mean any form resulting from mechanical transformation or
	translation of a Source form, including but not limited to compiled object code,
	generated documentation, and conversions to other media types.
	
	"Work" shall mean the work of authorship, whether in Source or Object form, made
	available under the License, as indicated by a copyright notice that is included
	in or attached to the work (an example is provided in the Appendix below).
	
	"Derivative Works" shall mean any work, whether in Source or Object form, that
	is based on (or derived from) the Work and for which the editorial revisions,
	annotations, elaborations, or other modifications represent, as a whole, an
	original work of authorship. For the purposes of this License, Derivative Works
	shall not include works that remain separable from, or merely link (or bind by
	name) to the interfaces of, the Work and Derivative Works thereof.
	
	"Contribution" shall mean any work of authorship, including the original version
	of the Work and any modifications or additions to that Work or Derivative Works
	thereof, that is intentionally submitted to Licensor for inclusion in the Work
	by the copyright owner or by an individual or Legal Entity authorized to submit
	on behalf of the copyright owner. For the purposes of this definition,
	"submitted" means any form of electronic, verbal, or written communication sent
	to the Licensor or its representatives, including but not limited to
	communication on electronic mailing lists, source code control systems, and
	issue tracking systems that are managed by, or on behalf of, the Licensor for
	the purpose of discussing and improving the Work, but excluding communication
	that is conspicuously marked or otherwise designated in writing by the copyright
	owner as "Not a Contribution."
	
	"Contributor" shall mean Licensor and any individual or Legal Entity on behalf
	of whom a Contribution has been received by Licensor and subsequently
	incorporated within the Work.
	
	2. Grant of Copyright License.
	
	Subject to the terms and conditions of this License, each Contributor hereby
	grants to You a perpetual, worldwide, non-exclusive, no-charge, royalty-free,
	irrevocable copyright license to reproduce, prepare Derivative Works of,
	publicly display, publicly perform, sublicense, and distribute the Work and such
	Derivative Works in Source or Object form.
	
	3. Grant of Patent License.
	
	Subject to the terms and conditions of this License, each Contributor hereby
	grants to You a perpetual, worldwide, non-exclusive, no-charge, royalty-free,
	irrevocable (except as stated in this section) patent license to make, have
	made, use, offer to sell, sell, import, and otherwise transfer the Work, where
	such license applies only to those patent claims licensable by such Contributor
	that are necessarily infringed by their Contribution(s) alone or by combination
	of their Contribution(s) with the Work to which such Contribution(s) was
	submitted. If You institute patent litigation against any entity (including a
	cross-claim or counterclaim in a lawsuit) alleging that the Work or a
	Contribution incorporated within the Work constitutes direct or contributory
	patent infringement, then any patent licenses granted to You under this License
	for that Work shall terminate as of the date such litigation is filed.
	
	4. Redistribution.
	
	You may reproduce and distribute copies of the Work or Derivative Works thereof
	in any medium, with or without modifications, and in Source or Object form,
	provided that You meet the following conditions:
	
	You must give any other recipients of the Work or Derivative Works a copy of
	this License; and
	You must cause any modified files to carry prominent notices stating that You
	changed the files; and
	You must retain, in the Source form of any Derivative Works that You distribute,
	all copyright, patent, trademark, and attribution notices from the Source form
	of the Work, excluding those notices that do not pertain to any part of the
	Derivative Works; and
	If the Work includes a "NOTICE" text file as part of its distribution, then any
	Derivative Works that You distribute must include a readable copy of the
	attribution notices contained within such NOTICE file, excluding those notices
	that do not pertain to any part of the Derivative Works, in at least one of the
	following places: within a NOTICE text file distributed as part of the
	Derivative Works; within the Source form or documentation, if provided along
	with the Derivative Works; or, within a display generated by the Derivative
	Works, if and wherever such third-party notices normally appear. The contents of
	the NOTICE file are for informational purposes only and do not modify the
	License. You may add Your own attribution notices within Derivative Works that
	You distribute, alongside or as an addendum to the NOTICE text from the Work,
	provided that such additional attribution notices cannot be construed as
	modifying the License.
	You may add Your own copyright statement to Your modifications and may provide
	additional or different license terms and conditions for use, reproduction, or
	distribution of Your modifications, or for any such Derivative Works as a whole,
	provided Your use, reproduction, and distribution of the Work otherwise complies
	with the conditions stated in this License.
	
	5. Submission of Contributions.
	
	Unless You explicitly state otherwise, any Contribution intentionally submitted
	for inclusion in the Work by You to the Licensor shall be under the terms and
	conditions of this License, without any additional terms or conditions.
	Notwithstanding the above, nothing herein shall supersede or modify the terms of
	any separate license agreement you may have executed with Licensor regarding
	such Contributions.
	
	6. Trademarks.
	
	This License does not grant permission to use the trade names, trademarks,
	service marks, or product names of the Licensor, except as required for
	reasonable and customary use in describing the origin of the Work and
	reproducing the content of the NOTICE file.
	
	7. Disclaimer of Warranty.
	
	Unless required by applicable law or agreed to in writing, Licensor provides the
	Work (and each Contributor provides its Contributions) on an "AS IS" BASIS,
	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied,
	including, without limitation, any warranties or conditions of TITLE,
	NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A PARTICULAR PURPOSE. You are
	solely responsible for determining the appropriateness of using or
	redistributing the Work and assume any risks associated with Your exercise of
	permissions under this License.
	
	8. Limitation of Liability.
	
	In no event and under no legal theory, whether in tort (including negligence),
	contract, or otherwise, unless required by applicable law (such as deliberate
	and grossly negligent acts) or agreed to in writing, shall any Contributor be
	liable to You for damages, including any direct, indirect, special, incidental,
	or consequential damages of any character arising as a result of this License or
	out of the use or inability to use the Work (including but not limited to
	damages for loss of goodwill, work stoppage, computer failure or malfunction, or
	any and all other commercial damages or losses), even if such Contributor has
	been advised of the possibility of such damages.
	
	9. Accepting Warranty or Additional Liability.
	
	While redistributing the Work or Derivative Works thereof, You may choose to
	offer, and charge a fee for, acceptance of support, warranty, indemnity, or
	other liability obligations and/or rights consistent with this License. However,
	in accepting such obligations, You may act only on Your own behalf and on Your
	sole responsibility, not on behalf of any other Contributor, and only if You
	agree to indemnify, defend, and hold each Contributor harmless for any liability
	incurred by, or claims asserted against, such Contributor by reason of your
	accepting any such warranty or additional liability.
	
	END OF TERMS AND CONDITIONS
	
	APPENDIX: How to apply the Apache License to your work
	
	To apply the Apache License to your work, attach the following boilerplate
	notice, with the fields enclosed by brackets "{}" replaced with your own
	identifying information. (Don't include the brackets!) The text should be
	enclosed in the appropriate comment syntax for the file format. We also
	recommend that a file or class name and description of purpose be included on
	the same "printed page" as the copyright notice for easier identification within
	third-party archives.
	
	   Copyright 2020 t-io
	
	   Licensed under the Apache License, Version 2.0 (the "License");
	   you may not use this file except in compliance with the License.
	   You may obtain a copy of the License at
	
	     http://www.apache.org/licenses/LICENSE-2.0
	
	   Unless required by applicable law or agreed to in writing, software
	   distributed under the License is distributed on an "AS IS" BASIS,
	   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	   See the License for the specific language governing permissions and
	   limitations under the License.
*/
package org.tio.http.client;

import java.io.IOException;
import java.util.Date;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.ClientChannelContext;
import org.tio.client.ClientTioConfig;
import org.tio.client.ReconnConf;
import org.tio.client.TioClient;
import org.tio.core.Node;
import org.tio.core.Tio;
import org.tio.http.common.HttpConst;
import org.tio.utils.Threads;
import org.tio.utils.hutool.DateUtil;
import org.tio.utils.hutool.StrUtil;
import org.tio.utils.thread.pool.SynThreadPoolExecutor;

/**
 * 提醒：本工程主要是用于做http暴力测试，代码写得比较了草，新手请勿模仿
 * @author tanyaowu
 */
public class HttpClientStarter {
	@SuppressWarnings("unused")
	private static Logger log = LoggerFactory.getLogger(HttpClientStarter.class);

	private HttpClientAioHandler httpClientAioHandler = new HttpClientAioHandler();

	private HttpClientAioListener httpClientAioListener = new HttpClientAioListener();

	//断链后自动连接的，不想自动连接请设为null
	private ReconnConf reconnConf = null;//new ReconnConf(5000L);

	//一组连接共用的上下文对象
	public ClientTioConfig clientTioConfig = new ClientTioConfig(httpClientAioHandler, httpClientAioListener, reconnConf);

	private TioClient tioClient = null;

	/**
	 * @throws IOException 
	 * 
	 */
	public HttpClientStarter() throws IOException {
		this(null, null);
	}

	/**
	 * 
	 * @param tioExecutor
	 * @param groupExecutor
	 * @throws IOException 
	 */
	public HttpClientStarter(SynThreadPoolExecutor tioExecutor, ThreadPoolExecutor groupExecutor) throws IOException {
		if (tioExecutor == null) {
			tioExecutor = Threads.getTioExecutor();
		}

		if (groupExecutor == null) {
			groupExecutor = Threads.getGroupExecutor();
		}

		init(tioExecutor, groupExecutor);
	}

	/**
	 * @return the httpClientAioHandler
	 */
	public HttpClientAioHandler getHttpClientAioHandler() {
		return httpClientAioHandler;
	}

	/**
	 * @return the httpClientAioListener
	 */
	public HttpClientAioListener getHttpClientAioListener() {
		return httpClientAioListener;
	}

	/**
	 * @return the clientTioConfig
	 */
	public ClientTioConfig getClientTioConfig() {
		return clientTioConfig;
	}

	private void init(SynThreadPoolExecutor tioExecutor, ThreadPoolExecutor groupExecutor) throws IOException {
		//		String system_timer_period = System.getProperty("tio.system.timer.period");
		//		if (StrUtil.isBlank(system_timer_period)) {
		//			System.setProperty("tio.system.timer.period", "50");
		//		}
		clientTioConfig.setName("Tio Http Client");
		clientTioConfig.statOn = false;
		tioClient = new TioClient(clientTioConfig);
	}

	public void stop() throws IOException {
		tioClient.stop();
	}

	public static int						requestCount				= 10000;						//每个客户端的请求数
	public static int						clientCount					= 1000;							//客户端个数
	public static int						totalRequestCount			= requestCount * clientCount;	//总请求数
	public static int						stepCount					= totalRequestCount / 10;
	public static ClientChannelContext[]	clientChannelContextArray	= null;
	public static long						startTime					= System.currentTimeMillis();
	public static long						stageStartTime				= System.currentTimeMillis();

	//received 
	public static AtomicLong	receivedCount		= new AtomicLong();
	public static AtomicLong	receivedStageCount	= new AtomicLong();

	public static AtomicLong	receivedBytes		= new AtomicLong();
	public static AtomicLong	receivedStageBytes	= new AtomicLong();

	public static HttpClientStarter	httpClientStarter	= null;
	public static HttpClientStarter	httpsClientStarter	= null;

	public static String requestPath;

	public static void init() throws Exception {
		httpClientStarter = new HttpClientStarter();
		httpsClientStarter = new HttpClientStarter();
		ClientTioConfig clientTioConfig = httpsClientStarter.getClientTioConfig();
		clientTioConfig.useSsl();
	}

	public static void main(String[] args) throws Exception {
		HttpClientStarter httpClientStarter = new HttpClientStarter();

		init();

		httpClientStarter.readCommand();

	}

	/**
	 * 开始测试
	 * @throws Exception
	 * @author tanyaowu
	 */
	public static void startTest(String serverip, int serverport, String path, int clientCount, int requestCount) throws Exception {
		boolean useSsl = false;
		String queryString = "";

		HttpClientStarter httpClientStarter;
		if (useSsl) {
			httpClientStarter = httpsClientStarter;
		} else {
			httpClientStarter = org.tio.http.client.HttpClientStarter.httpClientStarter;
		}

		HttpClientStarter.clientCount = clientCount; //客户端个数
		HttpClientStarter.requestCount = requestCount; //每个客户端的请求数
		HttpClientStarter.requestPath = path;

		HttpClientStarter.totalRequestCount = HttpClientStarter.requestCount * HttpClientStarter.clientCount; //总请求数
		HttpClientStarter.stepCount = HttpClientStarter.totalRequestCount / 10;

		Node serverNode = new Node(serverip, serverport);
		clientChannelContextArray = new ClientChannelContext[clientCount];
		for (int i = 0; i < clientCount; i++) {
			clientChannelContextArray[i] = httpClientStarter.tioClient.connect(serverNode);
		}

		startTime = System.currentTimeMillis();
		stageStartTime = System.currentTimeMillis();

		//received
		receivedCount = new AtomicLong();
		receivedStageCount = new AtomicLong();

		receivedBytes = new AtomicLong();
		receivedStageBytes = new AtomicLong();

		System.out.println("start time:" + startTime + "(" + DateUtil.formatDateTime(new Date(startTime)) + ")");
		ClientHttpRequest clientHttpRequest = ClientHttpRequest.get(requestPath, queryString);
		for (int i = 0; i < clientCount; i++) {
			for (int j = 0; j < requestCount; j++) {
				clientHttpRequest.addHeader(HttpConst.RequestHeaderKey.Host, clientChannelContextArray[i].getServerNode().getIp());
				Tio.send(clientChannelContextArray[i], clientHttpRequest);
			}
		}
	}

	private String helpStr = null;

	String line = "";

	public void readCommand() throws Exception {
		@SuppressWarnings("resource")
		java.util.Scanner sc = new java.util.Scanner(System.in);
		int i = 1;
		StringBuilder sb = new StringBuilder();
		sb.append("使用指南:\r\n");
		sb.append(i++ + "、需要帮助，输入 '?'.\r\n");
		sb.append(i++ + "、get，输入 'get {ip} {port} {requestPath} {clientCount} {requestCount}'.\r\n");
		sb.append("   eg: get 127.0.0.1 8080 /plaintext 100 10000\r\n");

		sb.append(i++ + "、退出程序，输入 'exit'.\r\n");

		helpStr = sb.toString();

		System.out.println(helpStr);

		line = sc.nextLine(); // 这个就是用户输入的数据
		while (true) {
			if ("exit".equalsIgnoreCase(line)) {
				System.out.println("Thanks for using! bye bye.");
				break;
			} else if ("?".equals(line)) {
				System.out.println(sb);
			}

			processCommand(line);

			line = sc.nextLine(); // 这个就是用户输入的数据
		}

		tioClient.stop();
		System.exit(0);
	}

	public void processCommand(String line) throws Exception {
		if (StrUtil.isBlank(line)) {
			return;
		}

		//get {ip} {port} {requestPath} {clientCount} {requestCount}
		String[] args = line.split(" ");
		String command = args[0];
		if ("get".equalsIgnoreCase(command)) {
			if (args.length != 6) {
				System.out.println(helpStr);
				return;
			}
			int i = 1;
			String ip = args[i++];
			int port = Integer.parseInt(args[i++]);
			String requestPath = args[i++];
			int clientCount = Integer.parseInt(args[i++]);
			int requestCount = Integer.parseInt(args[i++]);
			HttpClientStarter.startTest(ip, port, requestPath, clientCount, requestCount);
		} else {

		}
	}

	public static void gsOsc() throws Exception {
		boolean useSsl = false;
		String serverip = "www.baidu.com";
		int serverport = 80;
		String path = "/";
		//		String requestPath = "/json";
		String queryString = "";

		HttpClientStarter httpClientStarter;
		if (useSsl) {
			httpClientStarter = org.tio.http.client.HttpClientStarter.httpsClientStarter;
		} else {
			httpClientStarter = org.tio.http.client.HttpClientStarter.httpClientStarter;
		}

		Node serverNode = new Node(serverip, serverport);
		clientChannelContextArray = new ClientChannelContext[clientCount];
		for (int i = 0; i < clientCount; i++) {
			clientChannelContextArray[i] = httpClientStarter.tioClient.connect(serverNode);
		}

		requestCount = 10000; //每个客户端的请求数
		clientCount = 100; //客户端个数
		totalRequestCount = requestCount * clientCount; //总请求数
		stepCount = totalRequestCount / 10;
		startTime = System.currentTimeMillis();
		stageStartTime = System.currentTimeMillis();

		//received
		receivedCount = new AtomicLong();
		receivedStageCount = new AtomicLong();

		System.out.println("start time:" + startTime + "(" + DateUtil.formatDateTime(new Date(startTime)) + ")");
		ClientHttpRequest clientHttpRequest = ClientHttpRequest.get(path, queryString);
		for (int i = 0; i < clientCount; i++) {
			for (int j = 0; j < requestCount; j++) {
				Tio.send(clientChannelContextArray[i], clientHttpRequest);
			}
		}
	}
}
