#!/bin/bash
#
# rd2dir.sh -- extract rootfs.cpio.gz to rootfs directory
#
# Copyright (C) 2016-2020 Wu Zhangjin <lzufalcon@163.com>
#

[ -z "$INITRD" ] && INITRD=$1
[ -z "$ROOTDIR" ] && ROOTDIR=$2
[ -z "$INITRD" -o -z "$ROOTDIR" ] && echo "Usage: $0 initrd rootdir" && exit 1

_ROOTDIR=$(echo ${INITRD} | sed -e "s%.cpio.gz%%g" | sed -e "s%.cpio%%g")

FS_CPIO_GZ=${_ROOTDIR}.cpio.gz
CPIO_GZ=${_ROOTDIR}.cpio

mkdir -p ${ROOTDIR}
pushd ${ROOTDIR}

if [ -f ${FS_CPIO_GZ} ]; then
   gzip -cdkf ${FS_CPIO_GZ} | sudo cpio --quiet -idmv -R ${USER}:${USER} >/dev/null 2>&1
elif [ -f ${FS_CPIO} ]; then
   sudo cpio --quiet -idmv -R ${USER}:${USER} < ${FS_CPIO} >/dev/null 2>&1
fi

sudo chown ${USER}:${USER} -R ${ROOTDIR}
popd
