
-- ----------------------------
--  Table structure for `common_city` d
-- ----------------------------
DROP TABLE IF EXISTS `common_city`;
CREATE TABLE `common_city` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `code` varchar(10) DEFAULT NULL COMMENT '地区编码',
  `name` varchar(255) DEFAULT NULL COMMENT '名称',
  `fcode` varchar(11) DEFAULT NULL COMMENT '父级编码',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=346 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
--  Records of `common_city`
-- ----------------------------
BEGIN;
INSERT INTO `common_city` VALUES ('1', '110100', '市辖区', '110000'), ('2', '110200', '县', '110000'), ('3', '120100', '市辖区', '120000'), ('4', '120200', '县', '120000'), ('5', '130100', '石家庄市', '130000'), ('6', '130200', '唐山市', '130000'), ('7', '130300', '秦皇岛市', '130000'), ('8', '130400', '邯郸市', '130000'), ('9', '130500', '邢台市', '130000'), ('10', '130600', '保定市', '130000'), ('11', '130700', '张家口市', '130000'), ('12', '130800', '承德市', '130000'), ('13', '130900', '沧州市', '130000'), ('14', '131000', '廊坊市', '130000'), ('15', '131100', '衡水市', '130000'), ('16', '140100', '太原市', '140000'), ('17', '140200', '大同市', '140000'), ('18', '140300', '阳泉市', '140000'), ('19', '140400', '长治市', '140000'), ('20', '140500', '晋城市', '140000'), ('21', '140600', '朔州市', '140000'), ('22', '140700', '晋中市', '140000'), ('23', '140800', '运城市', '140000'), ('24', '140900', '忻州市', '140000'), ('25', '141000', '临汾市', '140000'), ('26', '141100', '吕梁市', '140000'), ('27', '150100', '呼和浩特市', '150000'), ('28', '150200', '包头市', '150000'), ('29', '150300', '乌海市', '150000'), ('30', '150400', '赤峰市', '150000'), ('31', '150500', '通辽市', '150000'), ('32', '150600', '鄂尔多斯市', '150000'), ('33', '150700', '呼伦贝尔市', '150000'), ('34', '150800', '巴彦淖尔市', '150000'), ('35', '150900', '乌兰察布市', '150000'), ('36', '152200', '兴安盟', '150000'), ('37', '152500', '锡林郭勒盟', '150000'), ('38', '152900', '阿拉善盟', '150000'), ('39', '210100', '沈阳市', '210000'), ('40', '210200', '大连市', '210000'), ('41', '210300', '鞍山市', '210000'), ('42', '210400', '抚顺市', '210000'), ('43', '210500', '本溪市', '210000'), ('44', '210600', '丹东市', '210000'), ('45', '210700', '锦州市', '210000'), ('46', '210800', '营口市', '210000'), ('47', '210900', '阜新市', '210000'), ('48', '211000', '辽阳市', '210000'), ('49', '211100', '盘锦市', '210000'), ('50', '211200', '铁岭市', '210000'), ('51', '211300', '朝阳市', '210000'), ('52', '211400', '葫芦岛市', '210000'), ('53', '220100', '长春市', '220000'), ('54', '220200', '吉林市', '220000'), ('55', '220300', '四平市', '220000'), ('56', '220400', '辽源市', '220000'), ('57', '220500', '通化市', '220000'), ('58', '220600', '白山市', '220000'), ('59', '220700', '松原市', '220000'), ('60', '220800', '白城市', '220000'), ('61', '222400', '延边朝鲜族自治州', '220000'), ('62', '230100', '哈尔滨市', '230000'), ('63', '230200', '齐齐哈尔市', '230000'), ('64', '230300', '鸡西市', '230000'), ('65', '230400', '鹤岗市', '230000'), ('66', '230500', '双鸭山市', '230000'), ('67', '230600', '大庆市', '230000'), ('68', '230700', '伊春市', '230000'), ('69', '230800', '佳木斯市', '230000'), ('70', '230900', '七台河市', '230000'), ('71', '231000', '牡丹江市', '230000'), ('72', '231100', '黑河市', '230000'), ('73', '231200', '绥化市', '230000'), ('74', '232700', '大兴安岭地区', '230000'), ('75', '310100', '市辖区', '310000'), ('76', '310200', '县', '310000'), ('77', '320100', '南京市', '320000'), ('78', '320200', '无锡市', '320000'), ('79', '320300', '徐州市', '320000'), ('80', '320400', '常州市', '320000'), ('81', '320500', '苏州市', '320000'), ('82', '320600', '南通市', '320000'), ('83', '320700', '连云港市', '320000'), ('84', '320800', '淮安市', '320000'), ('85', '320900', '盐城市', '320000'), ('86', '321000', '扬州市', '320000'), ('87', '321100', '镇江市', '320000'), ('88', '321200', '泰州市', '320000'), ('89', '321300', '宿迁市', '320000'), ('90', '330100', '杭州市', '330000'), ('91', '330200', '宁波市', '330000'), ('92', '330300', '温州市', '330000'), ('93', '330400', '嘉兴市', '330000'), ('94', '330500', '湖州市', '330000'), ('95', '330600', '绍兴市', '330000'), ('96', '330700', '金华市', '330000'), ('97', '330800', '衢州市', '330000'), ('98', '330900', '舟山市', '330000'), ('99', '331000', '台州市', '330000'), ('100', '331100', '丽水市', '330000'), ('101', '340100', '合肥市', '340000'), ('102', '340200', '芜湖市', '340000'), ('103', '340300', '蚌埠市', '340000'), ('104', '340400', '淮南市', '340000'), ('105', '340500', '马鞍山市', '340000'), ('106', '340600', '淮北市', '340000'), ('107', '340700', '铜陵市', '340000'), ('108', '340800', '安庆市', '340000'), ('109', '341000', '黄山市', '340000'), ('110', '341100', '滁州市', '340000'), ('111', '341200', '阜阳市', '340000'), ('112', '341300', '宿州市', '340000'), ('113', '341400', '巢湖市', '340000'), ('114', '341500', '六安市', '340000'), ('115', '341600', '亳州市', '340000'), ('116', '341700', '池州市', '340000'), ('117', '341800', '宣城市', '340000'), ('118', '350100', '福州市', '350000'), ('119', '350200', '厦门市', '350000'), ('120', '350300', '莆田市', '350000'), ('121', '350400', '三明市', '350000'), ('122', '350500', '泉州市', '350000'), ('123', '350600', '漳州市', '350000'), ('124', '350700', '南平市', '350000'), ('125', '350800', '龙岩市', '350000'), ('126', '350900', '宁德市', '350000'), ('127', '360100', '南昌市', '360000'), ('128', '360200', '景德镇市', '360000'), ('129', '360300', '萍乡市', '360000'), ('130', '360400', '九江市', '360000'), ('131', '360500', '新余市', '360000'), ('132', '360600', '鹰潭市', '360000'), ('133', '360700', '赣州市', '360000'), ('134', '360800', '吉安市', '360000'), ('135', '360900', '宜春市', '360000'), ('136', '361000', '抚州市', '360000'), ('137', '361100', '上饶市', '360000'), ('138', '370100', '济南市', '370000'), ('139', '370200', '青岛市', '370000'), ('140', '370300', '淄博市', '370000'), ('141', '370400', '枣庄市', '370000'), ('142', '370500', '东营市', '370000'), ('143', '370600', '烟台市', '370000'), ('144', '370700', '潍坊市', '370000'), ('145', '370800', '济宁市', '370000'), ('146', '370900', '泰安市', '370000'), ('147', '371000', '威海市', '370000'), ('148', '371100', '日照市', '370000'), ('149', '371200', '莱芜市', '370000'), ('150', '371300', '临沂市', '370000'), ('151', '371400', '德州市', '370000'), ('152', '371500', '聊城市', '370000'), ('153', '371600', '滨州市', '370000'), ('154', '371700', '荷泽市', '370000'), ('155', '410100', '郑州市', '410000'), ('156', '410200', '开封市', '410000'), ('157', '410300', '洛阳市', '410000'), ('158', '410400', '平顶山市', '410000'), ('159', '410500', '安阳市', '410000'), ('160', '410600', '鹤壁市', '410000'), ('161', '410700', '新乡市', '410000'), ('162', '410800', '焦作市', '410000'), ('163', '410900', '濮阳市', '410000'), ('164', '411000', '许昌市', '410000'), ('165', '411100', '漯河市', '410000'), ('166', '411200', '三门峡市', '410000'), ('167', '411300', '南阳市', '410000'), ('168', '411400', '商丘市', '410000'), ('169', '411500', '信阳市', '410000'), ('170', '411600', '周口市', '410000'), ('171', '411700', '驻马店市', '410000'), ('172', '420100', '武汉市', '420000'), ('173', '420200', '黄石市', '420000'), ('174', '420300', '十堰市', '420000'), ('175', '420500', '宜昌市', '420000'), ('176', '420600', '襄樊市', '420000'), ('177', '420700', '鄂州市', '420000'), ('178', '420800', '荆门市', '420000'), ('179', '420900', '孝感市', '420000'), ('180', '421000', '荆州市', '420000'), ('181', '421100', '黄冈市', '420000'), ('182', '421200', '咸宁市', '420000'), ('183', '421300', '随州市', '420000'), ('184', '422800', '恩施土家族苗族自治州', '420000'), ('185', '429000', '省直辖行政单位', '420000'), ('186', '430100', '长沙市', '430000'), ('187', '430200', '株洲市', '430000'), ('188', '430300', '湘潭市', '430000'), ('189', '430400', '衡阳市', '430000'), ('190', '430500', '邵阳市', '430000'), ('191', '430600', '岳阳市', '430000'), ('192', '430700', '常德市', '430000'), ('193', '430800', '张家界市', '430000'), ('194', '430900', '益阳市', '430000'), ('195', '431000', '郴州市', '430000'), ('196', '431100', '永州市', '430000'), ('197', '431200', '怀化市', '430000'), ('198', '431300', '娄底市', '430000'), ('199', '433100', '湘西土家族苗族自治州', '430000'), ('200', '440100', '广州市', '440000'), ('201', '440200', '韶关市', '440000'), ('202', '440300', '深圳市', '440000'), ('203', '440400', '珠海市', '440000'), ('204', '440500', '汕头市', '440000'), ('205', '440600', '佛山市', '440000'), ('206', '440700', '江门市', '440000'), ('207', '440800', '湛江市', '440000'), ('208', '440900', '茂名市', '440000'), ('209', '441200', '肇庆市', '440000'), ('210', '441300', '惠州市', '440000'), ('211', '441400', '梅州市', '440000'), ('212', '441500', '汕尾市', '440000'), ('213', '441600', '河源市', '440000'), ('214', '441700', '阳江市', '440000'), ('215', '441800', '清远市', '440000'), ('216', '441900', '东莞市', '440000'), ('217', '442000', '中山市', '440000'), ('218', '445100', '潮州市', '440000'), ('219', '445200', '揭阳市', '440000'), ('220', '445300', '云浮市', '440000'), ('221', '450100', '南宁市', '450000'), ('222', '450200', '柳州市', '450000'), ('223', '450300', '桂林市', '450000'), ('224', '450400', '梧州市', '450000'), ('225', '450500', '北海市', '450000'), ('226', '450600', '防城港市', '450000'), ('227', '450700', '钦州市', '450000'), ('228', '450800', '贵港市', '450000'), ('229', '450900', '玉林市', '450000'), ('230', '451000', '百色市', '450000'), ('231', '451100', '贺州市', '450000'), ('232', '451200', '河池市', '450000'), ('233', '451300', '来宾市', '450000'), ('234', '451400', '崇左市', '450000'), ('235', '460100', '海口市', '460000'), ('236', '460200', '三亚市', '460000'), ('237', '469000', '省直辖县级行政单位', '460000'), ('238', '500100', '市辖区', '500000'), ('239', '500200', '县', '500000'), ('240', '500300', '市', '500000'), ('241', '510100', '成都市', '510000'), ('242', '510300', '自贡市', '510000'), ('243', '510400', '攀枝花市', '510000'), ('244', '510500', '泸州市', '510000'), ('245', '510600', '德阳市', '510000'), ('246', '510700', '绵阳市', '510000'), ('247', '510800', '广元市', '510000'), ('248', '510900', '遂宁市', '510000'), ('249', '511000', '内江市', '510000'), ('250', '511100', '乐山市', '510000'), ('251', '511300', '南充市', '510000'), ('252', '511400', '眉山市', '510000'), ('253', '511500', '宜宾市', '510000'), ('254', '511600', '广安市', '510000'), ('255', '511700', '达州市', '510000'), ('256', '511800', '雅安市', '510000'), ('257', '511900', '巴中市', '510000'), ('258', '512000', '资阳市', '510000'), ('259', '513200', '阿坝藏族羌族自治州', '510000'), ('260', '513300', '甘孜藏族自治州', '510000'), ('261', '513400', '凉山彝族自治州', '510000'), ('262', '520100', '贵阳市', '520000'), ('263', '520200', '六盘水市', '520000'), ('264', '520300', '遵义市', '520000'), ('265', '520400', '安顺市', '520000'), ('266', '522200', '铜仁地区', '520000'), ('267', '522300', '黔西南布依族苗族自治州', '520000'), ('268', '522400', '毕节地区', '520000'), ('269', '522600', '黔东南苗族侗族自治州', '520000'), ('270', '522700', '黔南布依族苗族自治州', '520000'), ('271', '530100', '昆明市', '530000'), ('272', '530300', '曲靖市', '530000'), ('273', '530400', '玉溪市', '530000'), ('274', '530500', '保山市', '530000'), ('275', '530600', '昭通市', '530000'), ('276', '530700', '丽江市', '530000'), ('277', '530800', '思茅市', '530000'), ('278', '530900', '临沧市', '530000'), ('279', '532300', '楚雄彝族自治州', '530000'), ('280', '532500', '红河哈尼族彝族自治州', '530000'), ('281', '532600', '文山壮族苗族自治州', '530000'), ('282', '532800', '西双版纳傣族自治州', '530000'), ('283', '532900', '大理白族自治州', '530000'), ('284', '533100', '德宏傣族景颇族自治州', '530000'), ('285', '533300', '怒江傈僳族自治州', '530000'), ('286', '533400', '迪庆藏族自治州', '530000'), ('287', '540100', '拉萨市', '540000'), ('288', '542100', '昌都地区', '540000'), ('289', '542200', '山南地区', '540000'), ('290', '542300', '日喀则地区', '540000'), ('291', '542400', '那曲地区', '540000'), ('292', '542500', '阿里地区', '540000'), ('293', '542600', '林芝地区', '540000'), ('294', '610100', '西安市', '610000'), ('295', '610200', '铜川市', '610000'), ('296', '610300', '宝鸡市', '610000'), ('297', '610400', '咸阳市', '610000'), ('298', '610500', '渭南市', '610000'), ('299', '610600', '延安市', '610000'), ('300', '610700', '汉中市', '610000'), ('301', '610800', '榆林市', '610000'), ('302', '610900', '安康市', '610000'), ('303', '611000', '商洛市', '610000'), ('304', '620100', '兰州市', '620000'), ('305', '620200', '嘉峪关市', '620000'), ('306', '620300', '金昌市', '620000'), ('307', '620400', '白银市', '620000'), ('308', '620500', '天水市', '620000'), ('309', '620600', '武威市', '620000'), ('310', '620700', '张掖市', '620000'), ('311', '620800', '平凉市', '620000'), ('312', '620900', '酒泉市', '620000'), ('313', '621000', '庆阳市', '620000'), ('314', '621100', '定西市', '620000'), ('315', '621200', '陇南市', '620000'), ('316', '622900', '临夏回族自治州', '620000'), ('317', '623000', '甘南藏族自治州', '620000'), ('318', '630100', '西宁市', '630000'), ('319', '632100', '海东地区', '630000'), ('320', '632200', '海北藏族自治州', '630000'), ('321', '632300', '黄南藏族自治州', '630000'), ('322', '632500', '海南藏族自治州', '630000'), ('323', '632600', '果洛藏族自治州', '630000'), ('324', '632700', '玉树藏族自治州', '630000'), ('325', '632800', '海西蒙古族藏族自治州', '630000'), ('326', '640100', '银川市', '640000'), ('327', '640200', '石嘴山市', '640000'), ('328', '640300', '吴忠市', '640000'), ('329', '640400', '固原市', '640000'), ('330', '640500', '中卫市', '640000'), ('331', '650100', '乌鲁木齐市', '650000'), ('332', '650200', '克拉玛依市', '650000'), ('333', '652100', '吐鲁番地区', '650000'), ('334', '652200', '哈密地区', '650000'), ('335', '652300', '昌吉回族自治州', '650000'), ('336', '652700', '博尔塔拉蒙古自治州', '650000'), ('337', '652800', '巴音郭楞蒙古自治州', '650000'), ('338', '652900', '阿克苏地区', '650000'), ('339', '653000', '克孜勒苏柯尔克孜自治州', '650000'), ('340', '653100', '喀什地区', '650000'), ('341', '653200', '和田地区', '650000'), ('342', '654000', '伊犁哈萨克自治州', '650000'), ('343', '654200', '塔城地区', '650000'), ('344', '654300', '阿勒泰地区', '650000'), ('345', '659000', '省直辖行政单位', '650000');
COMMIT;

-- ----------------------------
--  Table structure for `common_province`
-- ----------------------------
DROP TABLE IF EXISTS `common_province`;
CREATE TABLE `common_province` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `code` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=35 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
--  Records of `common_province`
-- ----------------------------
BEGIN;
INSERT INTO `common_province` VALUES ('1', '北京市', '110000'), ('2', '天津市', '120000'), ('3', '河北省', '130000'), ('4', '山西省', '140000'), ('5', '内蒙古自治区', '150000'), ('6', '辽宁省', '210000'), ('7', '吉林省', '220000'), ('8', '黑龙江省', '230000'), ('9', '上海市', '310000'), ('10', '江苏省', '320000'), ('11', '浙江省', '330000'), ('12', '安徽省', '340000'), ('13', '福建省', '350000'), ('14', '江西省', '360000'), ('15', '山东省', '370000'), ('16', '河南省', '410000'), ('17', '湖北省', '420000'), ('18', '湖南省', '430000'), ('19', '广东省', '440000'), ('20', '广西壮族自治区', '450000'), ('21', '海南省', '460000'), ('22', '重庆市', '500000'), ('23', '四川省', '510000'), ('24', '贵州省', '520000'), ('25', '云南省', '530000'), ('26', '西藏自治区', '540000'), ('27', '陕西省', '610000'), ('28', '甘肃省', '620000'), ('29', '青海省', '630000'), ('30', '宁夏回族自治区', '640000'), ('31', '新疆维吾尔自治区', '650000'), ('32', '台湾省', '710000'), ('33', '香港特别行政区', '810000'), ('34', '澳门特别行政区', '820000');
COMMIT;

-- ----------------------------
--  Table structure for `ext_plugins`
-- ----------------------------
DROP TABLE IF EXISTS `ext_plugins`;
CREATE TABLE `ext_plugins` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `description` varchar(256) DEFAULT NULL,
  `time` datetime DEFAULT NULL,
  `author` varchar(50) DEFAULT NULL,
  `tags` varchar(256) DEFAULT NULL,
  `icon` varchar(256) DEFAULT NULL,
  `downloadUrl` varchar(256) DEFAULT NULL,
  `views` int(11) DEFAULT NULL,
  `downloadCount` int(11) DEFAULT NULL,
  `cid` int(11) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `keywords` varchar(256) DEFAULT NULL,
  `content` longtext,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=25 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

-- ----------------------------
--  Records of `ext_plugins`
-- ----------------------------
BEGIN;
INSERT INTO `ext_plugins` VALUES ('1', '前端在线留言组件', '插件描述插件描述插件描述插件描述插件描述插件描述插件描述插件描述插件描述', '2017-08-26 13:57:10', 'marker', '标签|标签2|标签3', 'http://f12.baidu.com/it/u=3131868884,1023344626&fm=72', 'http://www.baidu.com', '94', '0', '157', '1', null, '【《爱情公寓5》路透！陈赫大胡子造型首曝光】前段时间电视剧《#爱情公寓5#》在上海热拍，原班人马再度集结，胡一菲#娄艺潇#边玩游戏边赶往片场开工，过一会儿张益达#李佳航#也出现了！等了半天，曾小贤#陈赫#终于从片场出来，脸上的妆都还没卸，竟然还戴着一脸W型的大胡子，穿着一身军装[允悲]，陈赫好友朱桢也出现在片场，不知是否是来客串。'), ('2', '客服插件，在线客服支持', '插件描述插件描述插件描述插件描述插件描述插件描述插件描述插件描述插件描述', '2017-08-26 13:57:10', 'marker', '标签|标签2|标签3', 'http://f12.baidu.com/it/u=3131868884,1023344626&fm=72', 'http://www.baidu.com', '5', '0', '157', '1', null, '【《爱情公寓5》路透！陈赫大胡子造型首曝光】前段时间电视剧《#爱情公寓5#》在上海热拍，原班人马再度集结，胡一菲#娄艺潇#边玩游戏边赶往片场开工，过一会儿张益达#李佳航#也出现了！等了半天，曾小贤#陈赫#终于从片场出来，脸上的妆都还没卸，竟然还戴着一脸W型的大胡子，穿着一身军装[允悲]，陈赫好友朱桢也出现在片场，不知是否是来客串。'), ('3', '留言插件', '插件描述插件描述插件描述插件描述插件描述插件描述插件描述插件描述插件描述', '2017-08-26 13:57:10', 'marker', '标签|标签2|标签3', 'http://f12.baidu.com/it/u=3131868884,1023344626&fm=72', 'http://www.baidu.com', '1', '0', '157', '1', null, '【《爱情公寓5》路透！陈赫大胡子造型首曝光】前段时间电视剧《#爱情公寓5#》在上海热拍，原班人马再度集结，胡一菲#娄艺潇#边玩游戏边赶往片场开工，过一会儿张益达#李佳航#也出现了！等了半天，曾小贤#陈赫#终于从片场出来，脸上的妆都还没卸，竟然还戴着一脸W型的大胡子，穿着一身军装[允悲]，陈赫好友朱桢也出现在片场，不知是否是来客串。'), ('4', '留言插件', '插件描述插件描述插件描述插件描述插件描述插件描述插件描述插件描述插件描述', '2017-08-26 13:57:10', 'marker', '标签|标签2|标签3', 'http://f12.baidu.com/it/u=3131868884,1023344626&fm=72', 'http://www.baidu.com', '0', '0', '157', '1', null, '【《爱情公寓5》路透！陈赫大胡子造型首曝光】前段时间电视剧《#爱情公寓5#》在上海热拍，原班人马再度集结，胡一菲#娄艺潇#边玩游戏边赶往片场开工，过一会儿张益达#李佳航#也出现了！等了半天，曾小贤#陈赫#终于从片场出来，脸上的妆都还没卸，竟然还戴着一脸W型的大胡子，穿着一身军装[允悲]，陈赫好友朱桢也出现在片场，不知是否是来客串。'), ('5', '留言插件', '插件描述插件描述插件描述插件描述插件描述插件描述插件描述插件描述插件描述', '2017-08-26 13:57:10', 'marker', '标签|标签2|标签3', 'http://f12.baidu.com/it/u=3131868884,1023344626&fm=72', 'http://www.baidu.com', '0', '0', '157', '1', null, '【《爱情公寓5》路透！陈赫大胡子造型首曝光】前段时间电视剧《#爱情公寓5#》在上海热拍，原班人马再度集结，胡一菲#娄艺潇#边玩游戏边赶往片场开工，过一会儿张益达#李佳航#也出现了！等了半天，曾小贤#陈赫#终于从片场出来，脸上的妆都还没卸，竟然还戴着一脸W型的大胡子，穿着一身军装[允悲]，陈赫好友朱桢也出现在片场，不知是否是来客串。'), ('6', '留言插件', '插件描述插件描述插件描述插件描述插件描述插件描述插件描述插件描述插件描述', '2017-08-26 13:57:10', 'marker', '标签|标签2|标签3', 'http://f12.baidu.com/it/u=3131868884,1023344626&fm=72', 'http://www.baidu.com', '0', '0', '157', '1', null, '【《爱情公寓5》路透！陈赫大胡子造型首曝光】前段时间电视剧《#爱情公寓5#》在上海热拍，原班人马再度集结，胡一菲#娄艺潇#边玩游戏边赶往片场开工，过一会儿张益达#李佳航#也出现了！等了半天，曾小贤#陈赫#终于从片场出来，脸上的妆都还没卸，竟然还戴着一脸W型的大胡子，穿着一身军装[允悲]，陈赫好友朱桢也出现在片场，不知是否是来客串。'), ('7', '留言插件', '插件描述插件描述插件描述插件描述插件描述插件描述插件描述插件描述插件描述', '2017-08-26 13:57:10', 'marker', '标签|标签2|标签3', 'http://f12.baidu.com/it/u=3131868884,1023344626&fm=72', 'http://www.baidu.com', '0', '0', '157', '1', null, '【《爱情公寓5》路透！陈赫大胡子造型首曝光】前段时间电视剧《#爱情公寓5#》在上海热拍，原班人马再度集结，胡一菲#娄艺潇#边玩游戏边赶往片场开工，过一会儿张益达#李佳航#也出现了！等了半天，曾小贤#陈赫#终于从片场出来，脸上的妆都还没卸，竟然还戴着一脸W型的大胡子，穿着一身军装[允悲]，陈赫好友朱桢也出现在片场，不知是否是来客串。'), ('8', '留言插件', '插件描述插件描述插件描述插件描述插件描述插件描述插件描述插件描述插件描述', '2017-08-26 13:57:10', 'marker', '标签|标签2|标签3', 'http://f12.baidu.com/it/u=3131868884,1023344626&fm=72', 'http://www.baidu.com', '0', '0', '157', '1', null, null), ('9', '留言插件', '插件描述插件描述插件描述插件描述插件描述插件描述插件描述插件描述插件描述', '2017-08-26 13:57:10', 'marker', '标签|标签2|标签3', 'http://f12.baidu.com/it/u=3131868884,1023344626&fm=72', 'http://www.baidu.com', '0', '0', '157', '1', null, null), ('10', '留言插件', '插件描述插件描述插件描述插件描述插件描述插件描述插件描述插件描述插件描述', '2017-08-26 13:57:10', 'marker', '标签|标签2|标签3', 'http://f12.baidu.com/it/u=3131868884,1023344626&fm=72', 'http://www.baidu.com', '0', '0', '157', '1', null, null), ('11', '留言插件', '插件描述插件描述插件描述插件描述插件描述插件描述插件描述插件描述插件描述', '2017-08-26 13:57:10', 'marker', '标签|标签2|标签3', 'http://f12.baidu.com/it/u=3131868884,1023344626&fm=72', 'http://www.baidu.com', '16', '0', '157', '1', null, '【《爱情公寓5》路透！陈赫大胡子造型首曝光】前段时间电视剧《#爱情公寓5#》在上海热拍，原班人马再度集结，胡一菲#娄艺潇#边玩游戏边赶往片场开工，过一会儿张益达#李佳航#也出现了！等了半天，曾小贤#陈赫#终于从片场出来，脸上的妆都还没卸，竟然还戴着一脸W型的大胡子，穿着一身军装[允悲]，陈赫好友朱桢也出现在片场，不知是否是来客串。'), ('12', '留言插件', '插件描述插件描述插件描述插件描述插件描述插件描述插件描述插件描述插件描述', '2017-08-26 13:57:10', 'marker', '标签|标签2|标签3', 'http://f12.baidu.com/it/u=3131868884,1023344626&fm=72', 'http://www.baidu.com', '0', '0', '157', '1', null, null), ('13', '留言插件', '插件描述插件描述插件描述插件描述插件描述插件描述插件描述插件描述插件描述', '2017-08-26 13:57:10', 'marker', '标签|标签2|标签3', 'http://f12.baidu.com/it/u=3131868884,1023344626&fm=72', 'http://www.baidu.com', '0', '0', '157', '1', null, null), ('14', '留言插件', '插件描述插件描述插件描述插件描述插件描述插件描述插件描述插件描述插件描述', '2017-08-26 13:57:10', 'marker', '标签|标签2|标签3', 'http://f12.baidu.com/it/u=3131868884,1023344626&fm=72', 'http://www.baidu.com', '0', '0', '157', '1', null, null), ('15', '留言插件', '插件描述插件描述插件描述插件描述插件描述插件描述插件描述插件描述插件描述', '2017-08-26 13:57:10', 'marker', '标签|标签2|标签3', 'http://f12.baidu.com/it/u=3131868884,1023344626&fm=72', 'http://www.baidu.com', '0', '0', '157', '1', null, null), ('16', '留言插件', '插件描述插件描述插件描述插件描述插件描述插件描述插件描述插件描述插件描述', '2017-08-26 13:57:10', 'marker', '标签|标签2|标签3', 'http://f12.baidu.com/it/u=3131868884,1023344626&fm=72', 'http://www.baidu.com', '0', '0', '157', '1', null, null), ('17', '留言插件', '插件描述插件描述插件描述插件描述插件描述插件描述插件描述插件描述插件描述', '2017-08-26 13:57:10', 'marker', '标签|标签2|标签3', 'http://f12.baidu.com/it/u=3131868884,1023344626&fm=72', 'http://www.baidu.com', '0', '0', '157', '1', null, null), ('18', '留言插件', '插件描述插件描述插件描述插件描述插件描述插件描述插件描述插件描述插件描述', '2017-08-26 13:57:10', 'marker', '标签|标签2|标签3', 'http://f12.baidu.com/it/u=3131868884,1023344626&fm=72', 'http://www.baidu.com', '0', '0', '157', '1', null, null), ('19', '留言插件', '插件描述插件描述插件描述插件描述插件描述插件描述插件描述插件描述插件描述', '2017-08-26 13:57:10', 'marker', '标签|标签2|标签3', 'http://f12.baidu.com/it/u=3131868884,1023344626&fm=72', 'http://www.baidu.com', '0', '0', '157', '1', null, null), ('20', '留言插件', '插件描述插件描述插件描述插件描述插件描述插件描述插件描述插件描述插件描述', '2017-08-26 13:57:10', 'marker', '标签|标签2|标签3', 'http://f12.baidu.com/it/u=3131868884,1023344626&fm=72', 'http://www.baidu.com', '0', '0', '157', '1', null, null), ('21', '留言插件', '插件描述插件描述插件描述插件描述插件描述插件描述插件描述插件描述插件描述', '2017-08-26 13:57:10', 'marker', '标签|标签2|标签3', 'http://f12.baidu.com/it/u=3131868884,1023344626&fm=72', 'http://www.baidu.com', '5', '0', '157', '1', null, null), ('22', '留言插件', '插件描述插件描述插件描述插件描述插件描述插件描述插件描述插件描述插件描述', '2017-08-26 13:57:10', 'marker', '标签|标签2|标签3', 'http://f12.baidu.com/it/u=3131868884,1023344626&fm=72', 'http://www.baidu.com', '0', '0', '157', '1', null, null), ('23', '留言插件', '插件描述插件描述插件描述插件描述插件描述插件描述插件描述插件描述插件描述', '2017-08-26 13:57:10', 'marker', '标签|标签2|标签3', 'http://f12.baidu.com/it/u=3131868884,1023344626&fm=72', 'http://www.baidu.com', '0', '0', '157', '1', null, null), ('24', '留言插件', '插件描述插件描述插件描述插件描述插件描述插件描述插件描述插件描述插件描述', '2017-08-26 13:57:10', 'marker', '标签|标签2|标签3', 'http://f12.baidu.com/it/u=3131868884,1023344626&fm=72', 'http://www.baidu.com', '1', '0', '157', '1', null, null);
COMMIT;

-- ----------------------------
--  Table structure for `friendlink`
-- ----------------------------
DROP TABLE IF EXISTS `friendlink`;
CREATE TABLE `friendlink` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `icon` varchar(255) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `visited` bigint(11) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

-- ----------------------------
--  Records of `friendlink`
-- ----------------------------
BEGIN;
INSERT INTO `friendlink` VALUES ('1', 'null', '百度', 'www.baidu.com', '0', '百度搜索'), ('2', 'dsa', 'dsa', 'www.baidu.com', '11', '百度搜索');
COMMIT;

-- ----------------------------
--  Table structure for `mr_article`
-- ----------------------------
DROP TABLE IF EXISTS `mr_article`;
CREATE TABLE `mr_article` (
  `id` int(20) unsigned NOT NULL AUTO_INCREMENT,
  `did` int(11) DEFAULT NULL,
  `cid` int(20) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `keywords` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `author` varchar(255) DEFAULT NULL,
  `time` datetime DEFAULT NULL,
  `views` int(20) DEFAULT NULL,
  `content` longtext,
  `status` int(11) DEFAULT NULL,
  `source` varchar(255) DEFAULT NULL,
  `icon` varchar(255) DEFAULT NULL,
  `type` int(11) DEFAULT NULL,
  `orginal` text,
  `updateTime` datetime DEFAULT NULL,
  `stick` int(1) DEFAULT '0' COMMENT '是否置顶',
  PRIMARY KEY (`id`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=378 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

 

-- ----------------------------
--  Table structure for `mr_category`
-- ----------------------------
DROP TABLE IF EXISTS `mr_category`;
CREATE TABLE `mr_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cid` int(11) DEFAULT NULL,
  `pid` int(11) DEFAULT NULL,
  `root` int(11) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `alias` varchar(255) DEFAULT NULL,
  `sort` int(11) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `type` varchar(255) DEFAULT NULL,
  `model` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=111 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
--  Records of `mr_category`
-- ----------------------------
BEGIN;
INSERT INTO `mr_category` VALUES ('110', null, '0', null, '测试分类', null, '0', '', null, null);
COMMIT;

-- ----------------------------
--  Table structure for `mr_channel`
-- ----------------------------
DROP TABLE IF EXISTS `mr_channel`;
CREATE TABLE `mr_channel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) DEFAULT NULL,
  `sort` int(11) DEFAULT NULL,
  `rows` int(11) DEFAULT NULL,
  `name` varchar(20) DEFAULT NULL,
  `template` varchar(255) DEFAULT NULL,
  `hide` tinyint(1) DEFAULT NULL,
  `keywords` varchar(100) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `icon` varchar(255) DEFAULT NULL,
  `redirect` varchar(255) DEFAULT NULL,
  `langkey` varchar(255) DEFAULT NULL,
  `end` int(11) DEFAULT NULL,
  `categoryIds` varchar(255) DEFAULT NULL,
  `contentId` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=158 DEFAULT CHARSET=gbk ROW_FORMAT=DYNAMIC;

-- ----------------------------
--  Records of `mr_channel`
-- ----------------------------
BEGIN;
INSERT INTO `mr_channel` VALUES ('1', '0', '10', '10', '首页', 'index.html', '1', ' ', ' ', 'index', '', '', '', '0', '1,11,18,2,6', '23'), ('2', '0', '15', '2', '关于', 'about.html', '1', 'About', '', 'about', 'http://localhost:8080/upload/image/20170617/1497685531952007425.png', 'about/us', '', '0', '', '9'), ('3', '0', '20', '10', '案例', 'case.html', '1', '', '', 'case', 'http://localhost:8080/upload/image/20170614/1497423187843016484.png', '', '', '0', '', '8'), ('5', '0', '30', '5', '文档', 'document.html', '1', '', '', 'document', '', '', '', '0', '', '34'), ('15', '0', '40', '10', '下载', 'download.html', '1', 'MRCMS下载  下载', 'MRCMS下载地址', 'download', '', '', '', '0', '', '22'), ('73', '0', '90', '3', '博客', 'about.html', '1', '', '', 'blog', '', 'http://www.yl-blog.com/', '', '1', '', '26'), ('150', '2', '30', '10', '产品概念', 'about.html', '1', 'MRCMS mrcms下载 内容管理系统 javacms', 'MRCMS是安全稳定的内容管理系统，能够为中小型企业或个人提供快速且灵活的网站建设服务。', 'about/gainian', '', '', '', '0', '', '39'), ('151', '2', '40', '10', '蘑菇团队', 'about.html', '1', '', '', 'about/team', '', '', '', '0', '', '40'), ('152', '2', '60', '10', '联系我们', 'about.html', '1', '', '', 'about/concat', '', '', '', '0', '', '41'), ('153', '2', '70', '10', '加入我们', 'about.html', '1', '', '', 'about/joinUs', '', '', '', '0', '', '42'), ('154', '2', '0', '10', '关于我们', 'about.html', '1', '', '', 'about/us', '', '', '', '0', '', '43'), ('155', '5', '0', '10', '模板开发', 'list.html', '1', '', '', 'document/template', 'http://localhost:8080/upload/image/20170625/1498401401067047928.png', '', '', '0', '', '44'), ('156', '5', '0', '10', '内容模型开发', 'list.html', '1', '', '', 'document/model', 'http://localhost:8080/upload/image/20170625/1498401818732040106.png', '', '', '1', '', '45'), ('157', '0', '50', '10', '插件', 'plugins.html', '1', '插件、插件、插件', 'MRCMS插件列表', 'plugins', '', '', '', '0', null, '46');
COMMIT;

-- ----------------------------
--  Table structure for `mr_chip`
-- ----------------------------
DROP TABLE IF EXISTS `mr_chip`;
CREATE TABLE `mr_chip` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `mark` varchar(50) DEFAULT NULL,
  `content` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=182 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

 

-- ----------------------------
--  Table structure for `mr_content`
-- ----------------------------
DROP TABLE IF EXISTS `mr_content`;
CREATE TABLE `mr_content` (
  `content` text,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `time` datetime DEFAULT NULL,
  `model` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=47 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

-- ----------------------------
--  Table structure for `mr_doctor`
-- ----------------------------
DROP TABLE IF EXISTS `mr_doctor`;
CREATE TABLE `mr_doctor` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `deptname` varchar(100) DEFAULT NULL,
  `content` text,
  `time` datetime DEFAULT NULL,
  `views` int(11) DEFAULT NULL,
  `icon` varchar(255) DEFAULT NULL,
  `did` int(11) DEFAULT NULL,
  `cid` int(11) DEFAULT NULL,
  `jobname` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `keywords` varchar(255) DEFAULT NULL,
  `updateTime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;


-- ----------------------------
--  Table structure for `mr_goods`
-- ----------------------------
DROP TABLE IF EXISTS `mr_goods`;
CREATE TABLE `mr_goods` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `uid` int(11) DEFAULT NULL,
  `cid` int(11) DEFAULT NULL,
  `price` decimal(10,2) DEFAULT NULL,
  `mount` int(11) DEFAULT NULL,
  `time` datetime DEFAULT NULL,
  `marktime` datetime DEFAULT NULL,
  `color` varchar(255) DEFAULT NULL,
  `count` int(11) DEFAULT NULL,
  `order` int(11) DEFAULT NULL,
  `info` text,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
--  Records of `mr_goods`
-- ----------------------------
BEGIN;
INSERT INTO `mr_goods` VALUES ('1', '的撒旦', '1', '1', '1.00', '1', '2014-10-08 13:57:38', '2014-10-15 13:57:34', 'red', '1', '1', '大苏打撒大大撒', '1');
COMMIT;

-- ----------------------------
--  Table structure for `mr_guestbook`
-- ----------------------------
DROP TABLE IF EXISTS `mr_guestbook`;
CREATE TABLE `mr_guestbook` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nickname` varchar(255) DEFAULT NULL,
  `ip` varchar(255) DEFAULT NULL,
  `content` varchar(255) DEFAULT NULL,
  `time` datetime DEFAULT NULL,
  `status` int(10) unsigned zerofill DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;



-- ----------------------------
--  Table structure for `mr_history`
-- ----------------------------
DROP TABLE IF EXISTS `mr_history`;
CREATE TABLE `mr_history` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `year` int(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=36 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
--  Records of `mr_history`
-- ----------------------------
BEGIN;
INSERT INTO `mr_history` VALUES ('34', '2014', '', '打开的拉伸快乐的快乐撒到了阿斯顿撒范德萨发'), ('33', '2015', '', '的撒的撒范德萨范德萨范德萨发都是啊的'), ('35', '2016', '', 'dsa范德萨范德萨范德萨范德萨范德萨');
COMMIT;

-- ----------------------------
--  Table structure for `mr_honer`
-- ----------------------------
DROP TABLE IF EXISTS `mr_honer`;
CREATE TABLE `mr_honer` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `icon` varchar(255) DEFAULT NULL,
  `year` int(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=35 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
--  Records of `mr_honer`
-- ----------------------------
BEGIN;
INSERT INTO `mr_honer` VALUES ('34', '荣誉', '', '/upload/image/20170929/1506693662172082148.jpg', '2014'), ('33', '的萨达撒多撒范德萨发大', '的撒的撒', '/upload/image/20170929/1506689479475049334.jpg', '2013');
COMMIT;

-- ----------------------------
--  Table structure for `mr_link`
-- ----------------------------
DROP TABLE IF EXISTS `mr_link`;
CREATE TABLE `mr_link` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(20) DEFAULT NULL,
  `url` varchar(50) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `icon` varchar(255) DEFAULT NULL,
  `views` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=23 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
--  Records of `mr_link`
-- ----------------------------
BEGIN;
INSERT INTO `mr_link` VALUES ('1', '百度', 'http://www.baidu.com', 'heiehi', 'http://localhost:8080/upload/image/20180603/1528002794307054948.png', '0'), ('2', '谷歌', 'http://www.baidu.com', 'heiehi', 'http://localhost:8080/upload/image/20170825/1503672720845000376.png', '0'), ('4', '雨林博客', 'http://www.yl-blog.com', '我的雨林博客！', '/upload/image/20170825/1503671692827096183.png', '0'), ('18', '雨林博客', 'http://www.baidu.com', '321', '/upload/image/20170825/1503672720845000376.png', '0'), ('20', '雨林博客', 'http://www.baidu.com', 'dsadsa', '/upload/image/20170825/1503671692827096183.png', '0');
COMMIT;

-- ----------------------------
--  Table structure for `mr_model`
-- ----------------------------
DROP TABLE IF EXISTS `mr_model`;
CREATE TABLE `mr_model` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `icon` varchar(255) DEFAULT NULL,
  `version` varchar(11) DEFAULT NULL,
  `template` varchar(255) DEFAULT NULL,
  `type` varchar(255) DEFAULT NULL,
  `author` varchar(30) DEFAULT NULL,
  `time` datetime DEFAULT NULL,
  `module` varchar(40) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=161 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
--  Records of `mr_model`
-- ----------------------------
BEGIN;
INSERT INTO `mr_model` VALUES ('152', '单页模型', 'images/demo.jpg', '0.1', '', 'channel', 'marker', '2014-11-16 12:10:50', '5ff93bba7d1f4635bb63624e59c670a0'), ('153', '帮助模型', 'images/demo.jpg', '0.1', 'help.html', 'help', 'marker', '2014-11-16 12:10:51', '12100b11c45949059340a57133d671eb'), ('154', '文章模型', 'images/demo.jpg', '0.1', 'article.html', 'article', 'marker', '2014-11-16 12:10:53', 'afb1615c2dc8461f82c2abbb44b47271'), ('151', '商品模型', 'images/demo.jpg', '0.1', 'goods.html', 'goods', 'marker', '2014-10-04 22:14:05', 'afb1615c2dc8461f82c2abbb44b47271'), ('155', '医生模型', 'images/demo.jpg', '0.1', 'doctor.html', 'doctor', 'marker', '2017-06-13 14:50:51', 'doctor'), ('156', '科室模型', 'images/demo.jpg', '0.1', 'content/dept.html', 'dept', 'marker', '2017-06-20 18:01:03', null), ('157', '科室模型', 'images/demo.jpg', '0.1', 'content/dept.html', 'category', 'marker', '2017-06-20 18:07:34', null), ('158', '专题模型', 'images/demo.jpg', '0.1', 'thematic.html', 'thematic', 'marker', '2017-06-26 21:47:52', null), ('159', '插件模型', 'images/demo.jpg', '0.1', 'content_plugin.html', 'plugin', 'marker', '2017-08-26 15:06:06', null), ('160', '插件模型', 'images/demo.jpg', '0.1', 'content_plugin.html', 'plugins', 'marker', '2017-08-26 15:47:37', null);
COMMIT;

-- ----------------------------
--  Table structure for `mr_plugin`
-- ----------------------------
DROP TABLE IF EXISTS `mr_plugin`;
CREATE TABLE `mr_plugin` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `module` varchar(100) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `type` varchar(255) DEFAULT NULL,
  `author` varchar(30) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=65 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
--  Records of `mr_plugin`
-- ----------------------------
BEGIN;
INSERT INTO `mr_plugin` VALUES ('64', 'guestbook', '留言插件', 'guestbook', 'marker', '供了留言功能');
COMMIT;

-- ----------------------------
--  Table structure for `mr_position`
-- ----------------------------
DROP TABLE IF EXISTS `mr_position`;
CREATE TABLE `mr_position` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `area` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `company` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=36 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
--  Records of `mr_position`
-- ----------------------------
BEGIN;
INSERT INTO `mr_position` VALUES ('34', '成都市', '', '土木建筑学会团体会员单位'), ('33', '成都市', '', '风景园林学会会员单位'), ('35', '成都市', null, '园林绿化行业协会副会长单位');
COMMIT;

-- ----------------------------
--  Table structure for `mr_project`
-- ----------------------------
DROP TABLE IF EXISTS `mr_project`;
CREATE TABLE `mr_project` (
  `id` int(20) unsigned NOT NULL AUTO_INCREMENT,
  `did` int(11) DEFAULT NULL,
  `cid` int(20) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `keywords` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `author` varchar(255) DEFAULT NULL,
  `time` datetime DEFAULT NULL,
  `views` int(20) DEFAULT NULL,
  `content` longtext,
  `status` int(11) DEFAULT NULL,
  `source` varchar(255) DEFAULT NULL,
  `icon` varchar(255) DEFAULT NULL,
  `type` int(11) DEFAULT NULL,
  `orginal` text,
  `updateTime` datetime DEFAULT NULL,
  `location` varchar(100) DEFAULT NULL,
  `customer` varchar(100) DEFAULT NULL,
  `scale` varchar(100) DEFAULT NULL,
  `startTime` varchar(100) DEFAULT NULL,
  `extJson` text,
  `stick` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=413 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
--  Records of `mr_project`
-- ----------------------------
BEGIN;
INSERT INTO `mr_project` VALUES ('386', '-1', '158', '中粮', '', '', '雨林博客', '2017-09-30 17:12:25', '144', '', '1', '', '/upload/image/20171030/1509365004301052949.jpg', '0', null, null, '四川成都', '中粮', '2000 ', '-', '[{\"src\":\"/upload/image/20171030/1509365004223023227.jpg\"},{\"src\":\"/upload/image/20171030/1509365004223046168.jpg\"},{\"src\":\"/upload/image/20171030/1509365004223081453.jpg\"},{\"src\":\"/upload/image/20171030/1509365004288085299.jpg\"},{\"src\":\"/upload/image/20171030/1509365004301052949.jpg\"}]', '0'), ('407', '-1', '158', '黑钻山庄', '', '', '雨林博客', '2017-10-30 22:19:56', '14', '', '1', '', '/upload/image/20171030/1509373191216029074.jpg', '0', null, null, '', '', '', '', '[{\"src\":\"/upload/image/20171030/1509373191203017203.jpg\"},{\"src\":\"/upload/image/20171030/1509373191216029074.jpg\"},{\"src\":\"/upload/image/20171030/1509373191241011553.jpg\"},{\"src\":\"/upload/image/20171030/1509373191279079150.jpg\"},{\"src\":\"/upload/image/20171030/1509373191291003411.jpg\"},{\"src\":\"/upload/image/20171030/1509373191318022850.jpg\"},{\"src\":\"/upload/image/20171030/1509373191333057077.jpg\"},{\"src\":\"/upload/image/20171030/1509373191351058565.jpg\"},{\"src\":\"/upload/image/20171030/1509373191385067149.jpg\"},{\"src\":\"/upload/image/20171030/1509373191396053780.jpg\"}]', '0'), ('408', '-1', '158', '锦云', '', '', '雨林博客', '2017-10-30 22:21:51', '8', '', '1', '', '/upload/image/20171030/1509373291303085606.jpg', '0', null, null, '成都', '锦云', '11', '', '[{\"src\":\"/upload/image/20171031/1509415853849089039.jpg\"},{\"src\":\"/upload/image/20171031/1509415853598005174.jpg\"},{\"src\":\"/upload/image/20171031/1509415853598013105.jpg\"},{\"src\":\"/upload/image/20171031/1509415853598050376.jpg\"}]', '0'), ('409', '-1', '158', '悦街', '', '', '雨林博客', '2017-10-30 22:23:53', '4', '', '1', '', '/upload/image/20171030/1509373425917002484.jpg', '0', null, null, '', '悦街', '', '', '[{\"src\":\"/upload/image/20171030/1509373425917002484.jpg\"},{\"src\":\"/upload/image/20171030/1509373425933039622.jpg\"},{\"src\":\"/upload/image/20171030/1509373425955019159.jpg\"},{\"src\":\"/upload/image/20171030/1509373425969033132.jpg\"},{\"src\":\"/upload/image/20171030/1509373425986075140.jpg\"},{\"src\":\"/upload/image/20171030/1509373425993069760.jpg\"},{\"src\":\"/upload/image/20171030/1509373426008071338.jpg\"},{\"src\":\"/upload/image/20171030/1509373426026014520.jpg\"}]', '0'), ('410', '-1', '158', '大悦城', '', '', '雨林博客', '2017-10-30 22:25:20', '8', '', '1', '', '/upload/image/20171030/1509373538411039799.jpg', '0', null, null, '', '', '', '', '[{\"src\":\"http://localhost:8080/upload/image/20171030/1509373538355027061.jpg\"},{\"src\":\"http://localhost:8080/upload/image/20171030/1509373538370056724.jpg\"},{\"src\":\"http://localhost:8080/upload/image/20171030/1509373538395038020.jpg\"},{\"src\":\"http://localhost:8080/upload/image/20171030/1509373538411039799.jpg\"},{\"src\":\"http://localhost:8080/upload/image/20171030/1509373538422014158.jpg\"},{\"src\":\"http://localhost:8080/upload/image/20171030/1509373538430072441.jpg\"},{\"src\":\"http://localhost:8080/upload/image/20171030/1509373538452071269.jpg\"}]', '0'), ('411', '-1', '159', '塞尔维蒙', '', '', '雨林博客', '2017-10-30 22:26:13', '7', '', '1', '', '/upload/image/20171030/1509365004223081453.jpg', '0', null, null, '', '', '', '', '[{\"src\":\"http://localhost:8080/upload/image/20171030/1509373590666015470.jpg\"},{\"src\":\"http://localhost:8080/upload/image/20171030/1509373590684004410.jpg\"},{\"src\":\"http://localhost:8080/upload/image/20171030/1509373590715031767.jpg\"},{\"src\":\"http://localhost:8080/upload/image/20171030/1509373590722028191.jpg\"},{\"src\":\"http://localhost:8080/upload/image/20171030/1509373590737032909.jpg\"},{\"src\":\"http://localhost:8080/upload/image/20171030/1509373590760029332.jpg\"},{\"src\":\"http://localhost:8080/upload/image/20171030/1509373590770055397.jpg\"}]', '0'), ('412', '-1', '158', '信和御龙山', '', '', '雨林博客', '2017-10-30 22:32:10', '4', '', '1', '', '', '0', null, null, '', '', '', '', '[{\"src\":\"http://localhost:8080/upload/image/20171030/1509373947657040208.jpg\"},{\"src\":\"http://localhost:8080/upload/image/20171030/1509373947685051852.jpg\"},{\"src\":\"http://localhost:8080/upload/image/20171030/1509373947697008649.jpg\"}]', '0');
COMMIT;

-- ----------------------------
--  Table structure for `mr_searchinfo`
-- ----------------------------
DROP TABLE IF EXISTS `mr_searchinfo`;
CREATE TABLE `mr_searchinfo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `keyword` varchar(255) DEFAULT NULL,
  `ip` varchar(255) DEFAULT NULL,
  `time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=121 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
--  Table structure for `mr_sys_config`
-- ----------------------------
DROP TABLE IF EXISTS `mr_sys_config`;
CREATE TABLE `mr_sys_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `config` varchar(255) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=120 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;



-- ----------------------------
--  Table structure for `mr_sys_language`
-- ----------------------------
DROP TABLE IF EXISTS `mr_sys_language`;
CREATE TABLE `mr_sys_language` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lang` varchar(255) DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `value` text,
  `updateTime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=609 DEFAULT CHARSET=utf8 ;

-- ----------------------------
--  Records of `mr_sys_language`
-- ----------------------------


-- ----------------------------
--  Table structure for `mr_template`
-- ----------------------------
DROP TABLE IF EXISTS `mr_template`;
CREATE TABLE `mr_template` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `time` datetime DEFAULT NULL,
  `durl` varchar(255) DEFAULT NULL,
  `dloaded` bigint(20) DEFAULT NULL,
  `grade` int(11) DEFAULT NULL,
  `pid` bigint(20) DEFAULT NULL,
  `author` varchar(255) DEFAULT NULL,
  `icon` varchar(255) DEFAULT NULL,
  `description` mediumtext,
  `views` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
--  Records of `mr_template`
-- ----------------------------
BEGIN;
INSERT INTO `mr_template` VALUES ('1', '简约红色企业模板', '2013-04-23 23:48:23', 'http://dsadsa.dsadsadsa,com/dsadsa', '22', '0', '40', '跌名', 'upload/images/shuangzhi.png', '的撒的撒', '345'), ('2', '蓝色企业网站模板', '2013-04-11 00:09:24', 'http://dsadsa.dsadsadsa,com/dsadsa', '0', '0', '40', '跌名', 'upload/images/shuangzhi.png', '的撒的撒', '215'), ('3', '绿色坏境艺术网站模板', '2013-04-24 00:20:03', 'http://dsadsa.dsadsadsa,com/dsadsa', '0', '0', '40', '跌名', 'upload/images/shuangzhi.png', 'sad', '24'), ('4', '啊嘻嘻嘻', '2013-07-27 16:47:23', 'http://dsadsa.dsadsadsa,com/dsadsa', '1', '1', '40', '跌名', 'upload/images/shuangzhi.png', '的撒的撒', '336');
COMMIT;

-- ----------------------------
--  Table structure for `mr_user`
-- ----------------------------
DROP TABLE IF EXISTS `mr_user`;
CREATE TABLE `mr_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `gid` int(11) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `pass` varchar(255) NOT NULL,
  `group` int(11) DEFAULT NULL,
  `nickname` varchar(255) DEFAULT NULL,
  `createtime` datetime DEFAULT NULL,
  `logintime` datetime DEFAULT NULL,
  `status` int(1) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `ip` varchar(60) DEFAULT NULL,
  `token` varchar(40) DEFAULT NULL,
  `underwrite` varchar(255) DEFAULT NULL,
  `sex` int(11) DEFAULT NULL,
  `points` bigint(22) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=149 DEFAULT CHARSET=gbk ROW_FORMAT=DYNAMIC;

-- ----------------------------
--  Records of `mr_user`
-- ----------------------------
BEGIN;
INSERT INTO `mr_user` VALUES ('1', '1', null, 'admin', '7a8c6aa691085a97a3c66937a9e9daf6', '1', '雨林博客', '2013-06-12 15:27:53', '2018-08-11 08:36:08', '1', '网站超级管理员', null, null, null, null, null), ('145', '98', null, 'marker', '7a8c6aa691085a97a3c66937a9e9daf6', '1', '马克', '2014-11-16 11:39:12', '2017-06-23 15:28:13', '1', 'marker', null, null, null, '0', '0');
COMMIT;

-- ----------------------------
--  Table structure for `mr_user_group`
-- ----------------------------
DROP TABLE IF EXISTS `mr_user_group`;
CREATE TABLE `mr_user_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `scope` int(4) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=99 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
--  Records of `mr_user_group`
-- ----------------------------
BEGIN;
INSERT INTO `mr_user_group` VALUES ('1', '超级管理员', '1', '超级管理员组是默认的，不能删除'), ('98', '编辑', '1', '十大');
COMMIT;

-- ----------------------------
--  Table structure for `mr_user_group_category`
-- ----------------------------
DROP TABLE IF EXISTS `mr_user_group_category`;
CREATE TABLE `mr_user_group_category` (
  `gid` int(11) NOT NULL DEFAULT '0',
  `cid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`gid`,`cid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;

-- ----------------------------
--  Records of `mr_user_group_category`
-- ----------------------------
BEGIN;
INSERT INTO `mr_user_group_category` VALUES ('1', '43'), ('1', '44'), ('1', '45'), ('1', '47'), ('1', '48'), ('1', '49'), ('1', '50'), ('1', '51'), ('1', '52'), ('1', '53'), ('1', '54'), ('1', '55'), ('1', '56'), ('1', '57'), ('1', '58'), ('1', '59'), ('1', '60'), ('1', '61'), ('1', '62'), ('1', '63'), ('1', '64'), ('1', '65'), ('1', '66'), ('1', '67'), ('1', '68'), ('1', '69'), ('1', '70'), ('1', '71'), ('1', '72'), ('1', '73'), ('1', '74'), ('1', '75'), ('1', '76'), ('1', '77'), ('1', '78'), ('1', '79'), ('1', '80'), ('1', '81'), ('1', '82'), ('1', '83'), ('1', '84'), ('1', '85'), ('1', '86'), ('1', '87'), ('1', '88'), ('1', '89'), ('1', '90'), ('1', '91'), ('1', '92'), ('1', '93'), ('1', '94'), ('1', '95'), ('1', '96'), ('1', '97'), ('1', '98'), ('1', '99'), ('1', '100'), ('1', '101'), ('1', '102'), ('1', '103'), ('1', '104'), ('1', '105'), ('1', '106'), ('98', '43'), ('98', '45'), ('98', '57'), ('98', '61'), ('98', '65'), ('98', '66'), ('98', '67'), ('98', '68'), ('98', '70'), ('98', '71'), ('98', '73'), ('98', '88');
COMMIT;

-- ----------------------------
--  Table structure for `mr_user_group_channel`
-- ----------------------------
DROP TABLE IF EXISTS `mr_user_group_channel`;
CREATE TABLE `mr_user_group_channel` (
  `gid` int(11) NOT NULL DEFAULT '0',
  `cid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`gid`,`cid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;

-- ----------------------------
--  Records of `mr_user_group_channel`
-- ----------------------------
BEGIN;
INSERT INTO `mr_user_group_channel` VALUES ('1', '1'), ('1', '2'), ('1', '3'), ('1', '5'), ('1', '15'), ('1', '73'), ('1', '74'), ('1', '87'), ('1', '88'), ('1', '92'), ('1', '107'), ('1', '108'), ('1', '109'), ('1', '110'), ('1', '111'), ('1', '112'), ('1', '113'), ('1', '114'), ('1', '115'), ('1', '116'), ('1', '117'), ('1', '118'), ('1', '119'), ('1', '120'), ('1', '121'), ('1', '122'), ('1', '123'), ('1', '124'), ('1', '125'), ('1', '126'), ('1', '127'), ('1', '128'), ('1', '129'), ('1', '130'), ('1', '131'), ('1', '132'), ('1', '135'), ('1', '136'), ('1', '137'), ('1', '138'), ('1', '139'), ('1', '140'), ('1', '141'), ('1', '142'), ('1', '143'), ('1', '144'), ('1', '145'), ('1', '146'), ('98', '1'), ('98', '3'), ('98', '87'), ('98', '144');
COMMIT;

-- ----------------------------
--  Table structure for `mr_user_group_menu`
-- ----------------------------
DROP TABLE IF EXISTS `mr_user_group_menu`;
CREATE TABLE `mr_user_group_menu` (
  `gid` int(11) NOT NULL DEFAULT '0',
  `mid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`gid`,`mid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED;

-- ----------------------------
--  Records of `mr_user_group_menu`
-- ----------------------------
BEGIN;
INSERT INTO `mr_user_group_menu` VALUES ('1', '1'), ('1', '2'), ('1', '3'), ('1', '4'), ('1', '5'), ('1', '6'), ('1', '18'), ('1', '19'), ('1', '20'), ('1', '21'), ('1', '22'), ('1', '24'), ('1', '27'), ('1', '28'), ('1', '30'), ('1', '34'), ('1', '37'), ('1', '38'), ('1', '39'), ('1', '40'), ('1', '54'), ('1', '60'), ('1', '164'), ('1', '165'), ('1', '166'), ('1', '167'), ('1', '169'), ('1', '193'), ('1', '198'), ('1', '200'), ('1', '201'), ('1', '202'), ('1', '203'), ('1', '204'), ('98', '4'), ('98', '198'), ('98', '200');
COMMIT;

-- ----------------------------
--  Table structure for `mr_user_login_log`
-- ----------------------------
DROP TABLE IF EXISTS `mr_user_login_log`;
CREATE TABLE `mr_user_login_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(11) DEFAULT NULL,
  `ip` varchar(20) DEFAULT NULL,
  `time` datetime DEFAULT NULL,
  `area` varchar(20) DEFAULT NULL,
  `info` varchar(255) DEFAULT NULL,
  `errorCode` int(11) DEFAULT NULL,
  `device` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1210 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

 

-- ----------------------------
--  Table structure for `mr_user_menu`
-- ----------------------------
DROP TABLE IF EXISTS `mr_user_menu`;
CREATE TABLE `mr_user_menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL,
  `icon` varchar(255) DEFAULT NULL,
  `name` varchar(20) NOT NULL,
  `url` varchar(255) DEFAULT NULL,
  `sort` int(11) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `type` varchar(32) DEFAULT NULL,
  `end` int(11) DEFAULT NULL,
  `moduleId` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=205 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
--  Records of `mr_user_menu`
-- ----------------------------
BEGIN;
INSERT INTO `mr_user_menu` VALUES ('1', '0', 'fa-home', '首页', 'systeminfo.do', '1', '后台主界面，不解释。', 'b8db3088786a43e2916b810bbab8425b', '0', null), ('2', '0', 'fa-cog', '系统', '', '10', '', 'a1d6ac255acf4feab32ee70795b7b265', '0', null), ('3', '0', 'fa-archive', '页面', '', '20', '', '91ea1c25538b4c4e90401289cbe981fb', '0', null), ('4', '0', 'fa-list-alt', '内容', '', '30', '', 'bb2bc5fb802544a2a4634013d2c19936', '0', null), ('5', '0', 'fa-users', '用户', '', '40', '', 'c18166b148444928a4bab628da4190c8', '0', null), ('6', '0', 'fa-bullseye', '扩展', '', '50', '', 'bf41a349eec94e039648cc6de833440a', '0', null), ('18', '2', 'fa-info-circle', '基本信息', 'system/siteinfo.do', '10', '基本信息的管理', null, '0', null), ('19', '2', 'fa-clipboard', '数据配置', 'system/dbinfo.do', '20', '数据库配置', null, '0', null), ('20', '5', 'fa-user', '用户管理', 'user/list.do?currentPageNo=1', '30', '管理用户信息', null, '0', null), ('21', '5', 'fa-users', '分组管理', 'group/list.do', '40', '', null, '1', null), ('22', '2', 'fa-terminal', '登录日志', 'user/loginlog/list.do?currentPageNo=1', '50', '', null, '0', null), ('24', '3', 'fa-archive', '栏目管理', 'channel/list.do?currentPageNo=1', '20', '', null, '0', null), ('198', '4', 'fa-th', '文章管理', 'article/list.do', '0', '系统基础内容管理', '6cd7004ae4bc4aaca1435708cb7dd079', '0', null), ('27', '4', 'fa-th', '碎片管理', 'chip/list.do?currentPageNo=1', '30', '', null, '0', null), ('28', '4', 'fa-folder-o', '文件管理', 'file/list.do?path=/', '40', '', null, '0', null), ('165', '0', 'fa-bar-chart-o', '统计', '', '55', '', null, '0', null), ('30', '6', 'fa-plus-square', '模型列表', 'model/list.do', '20', '', null, '0', null), ('34', '6', 'fa-plus-square', '插件列表', 'plugin/list.do?currentPageNo=1', '30', '', null, '0', null), ('204', '4', 'fa-comments-o', '留言管理', '/plugin/guestbook/list', '1000', null, null, '0', '唯一标记'), ('37', '2', 'fa-search', 'SEO配置', 'system/seoinfo.do', '80', '', null, '0', null), ('38', '2', 'fa-bars', '菜单管理', 'menu/list.do', '90', '', null, '0', null), ('39', '1', 'fa-shield', '关于系统', 'center/software.html', '10', '', null, '0', null), ('40', '1', 'fa-shield', '关于我们', 'center/about.html', '20', '', null, '1', null), ('49', '2', 'fa-cogs', '缓存管理', 'system/cache.do', '50', '', null, '0', null), ('50', '2', 'fa-envelope', '邮箱配置', 'system/mailinfo.do', '50', '', null, '0', null), ('193', '2', 'fa-bars', '国际化站', 'international/list.do', '200', '网站国际化配置', null, '1', null), ('52', '6', 'fa-bullseye', '备份管理', '', '90', '为防止意外情况，对系统，或者内容模型、插件数据进行备份。', null, '1', null), ('53', '3', 'fa-archive', '专题管理', '', '200', '', null, '1', null), ('54', '6', 'fa-bullseye', '标签列表', 'taglib/list.do', '40', '标签', null, '0', null), ('166', '165', 'fa-bar-chart-o', '昨日统计', 'statistics/yesterday.do', '200', '', null, '0', null), ('164', '165', 'fa-bar-chart-o', '今日统计', 'statistics/today.do', '100', '', null, '0', null), ('167', '165', 'fa-bar-chart-o', '百度统计', 'https://tongji.baidu.com', '300', '', null, '1', null), ('202', '6', 'fa-bullseye', 'URL替换', 'urlreplace/list.do', '50', '', null, '0', null), ('169', '3', 'fa-clipboard', '分类管理', 'category/list.do', '30', '', null, '0', null), ('199', '4', '', '幻灯管理', 'slide/list.do', '0', '', null, '0', null), ('201', '3', 'fa-link', '外链管理', 'link/list.do?currentPageNo=1', '40', '', null, '0', null);
COMMIT;

-- ----------------------------
--  Table structure for `mr_visited_his`
-- ----------------------------
DROP TABLE IF EXISTS `mr_visited_his`;
CREATE TABLE `mr_visited_his` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `ip` varchar(20) DEFAULT NULL,
  `visitor` varchar(40) NOT NULL,
  `language` varchar(50) DEFAULT NULL,
  `system` varchar(50) DEFAULT NULL,
  `browser` varchar(50) DEFAULT NULL,
  `version` varchar(50) DEFAULT NULL,
  `screen` varchar(30) DEFAULT NULL,
  `flash` int(2) DEFAULT NULL,
  `url` varchar(500) DEFAULT NULL,
  `referer` varchar(500) DEFAULT NULL,
  `province` varchar(11) DEFAULT NULL,
  `city` varchar(11) DEFAULT NULL,
  `time` datetime DEFAULT NULL,
  `leavetime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `time` (`time`)
) ENGINE=MyISAM AUTO_INCREMENT=252039 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
 

-- ----------------------------
--  Table structure for `public_sensitive`
-- ----------------------------
DROP TABLE IF EXISTS `public_sensitive`;
CREATE TABLE `public_sensitive` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` int(11) DEFAULT NULL,
  `value` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1060 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

-- ----------------------------
--  Records of `public_sensitive`
-- ----------------------------
BEGIN;
INSERT INTO `public_sensitive` VALUES ('1', null, '阿扁推翻'), ('2', null, '阿宾'), ('3', null, '阿賓'), ('4', null, '挨了一炮'), ('5', null, '爱液横流'), ('6', null, '安街逆'), ('7', null, '安局办公楼'), ('8', null, '安局豪华'), ('9', null, '安门事'), ('10', null, '安眠藥'), ('11', null, '案的准确'), ('12', null, '八九民'), ('13', null, '八九学'), ('14', null, '八九政治'), ('15', null, '把病人整'), ('16', null, '把邓小平'), ('17', null, '把学生整'), ('18', null, '罢工门'), ('19', null, '白黄牙签'), ('20', null, '败培训'), ('21', null, '办本科'), ('22', null, '办理本科'), ('23', null, '办理各种'), ('24', null, '办理票据'), ('25', null, '办理文凭'), ('26', null, '办理真实'), ('27', null, '办理证书'), ('28', null, '办理资格'), ('29', null, '办文凭'), ('30', null, '办怔'), ('31', null, '办证'), ('32', null, '半刺刀'), ('33', null, '辦毕业'), ('34', null, '辦證'), ('35', null, '谤罪获刑'), ('36', null, '磅解码器'), ('37', null, '磅遥控器'), ('38', null, '宝在甘肃修'), ('39', null, '保过答案'), ('40', null, '报复执法'), ('41', null, '爆发骚'), ('42', null, '北省委门'), ('43', null, '被打死'), ('44', null, '被指抄袭'), ('45', null, '被中共'), ('46', null, '本公司担'), ('47', null, '本无码'), ('48', null, '毕业證'), ('49', null, '变牌绝'), ('50', null, '辩词与梦'), ('51', null, '冰毒'), ('52', null, '冰火毒'), ('53', null, '冰火佳'), ('54', null, '冰火九重'), ('55', null, '冰火漫'), ('56', null, '冰淫传'), ('57', null, '冰在火上'), ('58', null, '波推龙'), ('59', null, '博彩娱'), ('60', null, '博会暂停'), ('61', null, '博园区伪'), ('62', null, '不查都'), ('63', null, '不查全'), ('64', null, '不思四化'), ('65', null, '布卖淫女'), ('66', null, '部忙组阁'), ('67', null, '部是这样'), ('68', null, '才知道只生'), ('69', null, '财众科技'), ('70', null, '采花堂'), ('71', null, '踩踏事'), ('72', null, '苍山兰'), ('73', null, '苍蝇水'), ('74', null, '藏春阁'), ('75', null, '藏獨'), ('76', null, '操了嫂'), ('77', null, '操嫂子'), ('78', null, '策没有不'), ('79', null, '插屁屁'), ('80', null, '察象蚂'), ('81', null, '拆迁灭'), ('82', null, '车牌隐'), ('83', null, '成人电'), ('84', null, '成人卡通'), ('85', null, '成人聊'), ('86', null, '成人片'), ('87', null, '成人视'), ('88', null, '成人图'), ('89', null, '成人文'), ('90', null, '成人小'), ('91', null, '城管灭'), ('92', null, '惩公安'), ('93', null, '惩贪难'), ('94', null, '充气娃'), ('95', null, '冲凉死'), ('96', null, '抽着大中'), ('97', null, '抽着芙蓉'), ('98', null, '出成绩付'), ('99', null, '出售发票'), ('100', null, '出售军'), ('101', null, '穿透仪器'), ('102', null, '春水横溢'), ('103', null, '纯度白'), ('104', null, '纯度黄'), ('105', null, '次通过考'), ('106', null, '催眠水'), ('107', null, '催情粉'), ('108', null, '催情药'), ('109', null, '催情藥'), ('110', null, '挫仑'), ('111', null, '达毕业证'), ('112', null, '答案包'), ('113', null, '答案提供'), ('114', null, '打飞机专'), ('115', null, '打死经过'), ('116', null, '打死人'), ('117', null, '打砸办公'), ('118', null, '大鸡巴'), ('119', null, '大雞巴'), ('120', null, '大纪元'), ('121', null, '大揭露'), ('122', null, '大奶子'), ('123', null, '大批贪官'), ('124', null, '大肉棒'), ('125', null, '大嘴歌'), ('126', null, '代办发票'), ('127', null, '代办各'), ('128', null, '代办文'), ('129', null, '代办学'), ('130', null, '代办制'), ('131', null, '代辦'), ('132', null, '代表烦'), ('133', null, '代理发票'), ('134', null, '代理票据'), ('135', null, '代您考'), ('136', null, '代您考'), ('137', null, '代写毕'), ('138', null, '代写论'), ('139', null, '代孕'), ('140', null, '贷办'), ('141', null, '贷借款'), ('142', null, '贷开'), ('143', null, '戴海静'), ('144', null, '当代七整'), ('145', null, '当官要精'), ('146', null, '当官在于'), ('147', null, '党的官'), ('148', null, '党后萎'), ('149', null, '党前干劲'), ('150', null, '刀架保安'), ('151', null, '导的情人'), ('152', null, '导叫失'), ('153', null, '导人的最'), ('154', null, '导人最'), ('155', null, '导小商'), ('156', null, '到花心'), ('157', null, '得财兼'), ('158', null, '的同修'), ('159', null, '灯草和'), ('160', null, '等级證'), ('161', null, '等屁民'), ('162', null, '等人老百'), ('163', null, '等人是老'), ('164', null, '等人手术'), ('165', null, '邓爷爷转'), ('166', null, '邓玉娇'), ('167', null, '地产之歌'), ('168', null, '地下先烈'), ('169', null, '地震哥'), ('170', null, '帝国之梦'), ('171', null, '递纸死'), ('172', null, '点数优惠'), ('173', null, '电狗'), ('174', null, '电话监'), ('175', null, '电鸡'), ('176', null, '甸果敢'), ('177', null, '蝶舞按'), ('178', null, '丁香社'), ('179', null, '丁子霖'), ('180', null, '顶花心'), ('181', null, '东北独立'), ('182', null, '东复活'), ('183', null, '东京热'), ('184', null, '東京熱'), ('185', null, '洞小口紧'), ('186', null, '都当警'), ('187', null, '都当小姐'), ('188', null, '都进中央'), ('189', null, '毒蛇钻'), ('190', null, '独立台湾'), ('191', null, '赌球网'), ('192', null, '短信截'), ('193', null, '对日强硬'), ('194', null, '多美康'), ('195', null, '躲猫猫'), ('196', null, '俄羅斯'), ('197', null, '恶势力操'), ('198', null, '恶势力插'), ('199', null, '恩氟烷'), ('200', null, '儿园惨'), ('201', null, '儿园砍'), ('202', null, '儿园杀'), ('203', null, '儿园凶'), ('204', null, '二奶大'), ('205', null, '发牌绝'), ('206', null, '发票出'), ('207', null, '发票代'), ('208', null, '发票销'), ('209', null, '發票'), ('210', null, '法车仑'), ('211', null, '法伦功'), ('212', null, '法轮'), ('213', null, '法轮佛'), ('214', null, '法维权'), ('215', null, '法一轮'), ('216', null, '法院给废'), ('217', null, '法正乾'), ('218', null, '反测速雷'), ('219', null, '反雷达测'), ('220', null, '反屏蔽'), ('221', null, '范燕琼'), ('222', null, '方迷香'), ('223', null, '防电子眼'), ('224', null, '防身药水'), ('225', null, '房贷给废'), ('226', null, '仿真枪'), ('227', null, '仿真证'), ('228', null, '诽谤罪'), ('229', null, '费私服'), ('230', null, '封锁消'), ('231', null, '佛同修'), ('232', null, '夫妻交换'), ('233', null, '福尔马林'), ('234', null, '福娃的預'), ('235', null, '福娃頭上'), ('236', null, '福香巴'), ('237', null, '府包庇'), ('238', null, '府集中领'), ('239', null, '妇销魂'), ('240', null, '附送枪'), ('241', null, '复印件生'), ('242', null, '复印件制'), ('243', null, '富民穷'), ('244', null, '富婆给废'), ('245', null, '改号软件'), ('246', null, '感扑克'), ('247', null, '冈本真'), ('248', null, '肛交'), ('249', null, '肛门是邻'), ('250', null, '岡本真'), ('251', null, '钢针狗'), ('252', null, '钢珠枪'), ('253', null, '港澳博球'), ('254', null, '港馬會'), ('255', null, '港鑫華'), ('256', null, '高就在政'), ('257', null, '高考黑'), ('258', null, '高莺莺'), ('259', null, '搞媛交'), ('260', null, '告长期'), ('261', null, '告洋状'), ('262', null, '格证考试'), ('263', null, '各类考试'), ('264', null, '各类文凭'), ('265', null, '跟踪器'), ('266', null, '工程吞得'), ('267', null, '工力人'), ('268', null, '公安错打'), ('269', null, '公安网监'), ('270', null, '公开小姐'), ('271', null, '攻官小姐'), ('272', null, '共狗'), ('273', null, '共王储'), ('274', null, '狗粮'), ('275', null, '狗屁专家'), ('276', null, '鼓动一些'), ('277', null, '乖乖粉'), ('278', null, '官商勾'), ('279', null, '官也不容'), ('280', null, '官因发帖'), ('281', null, '光学真题'), ('282', null, '跪真相'), ('283', null, '滚圆大乳'), ('284', null, '国际投注'), ('285', null, '国家妓'), ('286', null, '国家软弱'), ('287', null, '国家吞得'), ('288', null, '国库折'), ('289', null, '国一九五七'), ('290', null, '國內美'), ('291', null, '哈药直销'), ('292', null, '海访民'), ('293', null, '豪圈钱'), ('294', null, '号屏蔽器'), ('295', null, '和狗交'), ('296', null, '和狗性'), ('297', null, '和狗做'), ('298', null, '黑火药的'), ('299', null, '红色恐怖'), ('300', null, '红外透视'), ('301', null, '紅色恐'), ('302', null, '胡江内斗'), ('303', null, '胡紧套'), ('304', null, '胡錦濤'), ('305', null, '胡适眼'), ('306', null, '胡耀邦'), ('307', null, '湖淫娘'), ('308', null, '虎头猎'), ('309', null, '华国锋'), ('310', null, '华门开'), ('311', null, '化学扫盲'), ('312', null, '划老公'), ('313', null, '还会吹萧'), ('314', null, '还看锦涛'), ('315', null, '环球证件'), ('316', null, '换妻'), ('317', null, '皇冠投注'), ('318', null, '黄冰'), ('319', null, '浑圆豪乳'), ('320', null, '活不起'), ('321', null, '火车也疯'), ('322', null, '机定位器'), ('323', null, '机号定'), ('324', null, '机号卫'), ('325', null, '机卡密'), ('326', null, '机屏蔽器'), ('327', null, '基本靠吼'), ('328', null, '绩过后付'), ('329', null, '激情电'), ('330', null, '激情短'), ('331', null, '激情妹'), ('332', null, '激情炮'), ('333', null, '级办理'), ('334', null, '级答案'), ('335', null, '急需嫖'), ('336', null, '集体打砸'), ('337', null, '集体腐'), ('338', null, '挤乳汁'), ('339', null, '擠乳汁'), ('340', null, '佳静安定'), ('341', null, '家一样饱'), ('342', null, '家属被打'), ('343', null, '甲虫跳'), ('344', null, '甲流了'), ('345', null, '奸成瘾'), ('346', null, '兼职上门'), ('347', null, '监听器'), ('348', null, '监听王'), ('349', null, '简易炸'), ('350', null, '江胡内斗'), ('351', null, '江太上'), ('352', null, '江系人'), ('353', null, '江贼民'), ('354', null, '疆獨'), ('355', null, '蒋彦永'), ('356', null, '叫自慰'), ('357', null, '揭贪难'), ('358', null, '姐包夜'), ('359', null, '姐服务'), ('360', null, '姐兼职'), ('361', null, '姐上门'), ('362', null, '金扎金'), ('363', null, '金钟气'), ('364', null, '津大地震'), ('365', null, '津地震'), ('366', null, '进来的罪'), ('367', null, '京地震'), ('368', null, '京要地震'), ('369', null, '经典谎言'), ('370', null, '精子射在'), ('371', null, '警察被'), ('372', null, '警察的幌'), ('373', null, '警察殴打'), ('374', null, '警察说保'), ('375', null, '警车雷达'), ('376', null, '警方包庇'), ('377', null, '警用品'), ('378', null, '径步枪'), ('379', null, '敬请忍'), ('380', null, '究生答案'), ('381', null, '九龙论坛'), ('382', null, '九评共'), ('383', null, '酒象喝汤'), ('384', null, '酒像喝汤'), ('385', null, '就爱插'), ('386', null, '就要色'), ('387', null, '举国体'), ('388', null, '巨乳'), ('389', null, '据说全民'), ('390', null, '绝食声'), ('391', null, '军长发威'), ('392', null, '军刺'), ('393', null, '军品特'), ('394', null, '军用手'), ('395', null, '开邓选'), ('396', null, '开锁工具'), ('397', null, '開碼'), ('398', null, '開票'), ('399', null, '砍杀幼'), ('400', null, '砍伤儿'), ('401', null, '康没有不'), ('402', null, '康跳楼'), ('403', null, '考答案'), ('404', null, '考后付款'), ('405', null, '考机构'), ('406', null, '考考邓'), ('407', null, '考联盟'), ('408', null, '考前答'), ('409', null, '考前答案'), ('410', null, '考前付'), ('411', null, '考设备'), ('412', null, '考试包过'), ('413', null, '考试保'), ('414', null, '考试答案'), ('415', null, '考试机构'), ('416', null, '考试联盟'), ('417', null, '考试枪'), ('418', null, '考研考中'), ('419', null, '考中答案'), ('420', null, '磕彰'), ('421', null, '克分析'), ('422', null, '克千术'), ('423', null, '克透视'), ('424', null, '空和雅典'), ('425', null, '孔摄像'), ('426', null, '控诉世博'), ('427', null, '控制媒'), ('428', null, '口手枪'), ('429', null, '骷髅死'), ('430', null, '快速办'), ('431', null, '矿难不公'), ('432', null, '拉登说'), ('433', null, '拉开水晶'), ('434', null, '来福猎'), ('435', null, '拦截器'), ('436', null, '狼全部跪'), ('437', null, '浪穴'), ('438', null, '老虎机'), ('439', null, '雷人女官'), ('440', null, '类准确答'), ('441', null, '黎阳平'), ('442', null, '李洪志'), ('443', null, '李咏曰'), ('444', null, '理各种证'), ('445', null, '理是影帝'), ('446', null, '理证件'), ('447', null, '理做帐报'), ('448', null, '力骗中央'), ('449', null, '力月西'), ('450', null, '丽媛离'), ('451', null, '利他林'), ('452', null, '连发手'), ('453', null, '聯繫電'), ('454', null, '炼大法'), ('455', null, '两岸才子'), ('456', null, '两会代'), ('457', null, '两会又三'), ('458', null, '聊视频'), ('459', null, '聊斋艳'), ('460', null, '了件渔袍'), ('461', null, '猎好帮手'), ('462', null, '猎枪销'), ('463', null, '猎槍'), ('464', null, '獵槍'), ('465', null, '领土拿'), ('466', null, '流血事'), ('467', null, '六合彩'), ('468', null, '六死'), ('469', null, '六四事'), ('470', null, '六月联盟'), ('471', null, '龙湾事件'), ('472', null, '隆手指'), ('473', null, '陆封锁'), ('474', null, '陆同修'), ('475', null, '氯胺酮'), ('476', null, '乱奸'), ('477', null, '乱伦类'), ('478', null, '乱伦小'), ('479', null, '亂倫'), ('480', null, '伦理大'), ('481', null, '伦理电影'), ('482', null, '伦理毛'), ('483', null, '伦理片'), ('484', null, '轮功'), ('485', null, '轮手枪'), ('486', null, '论文代'), ('487', null, '罗斯小姐'), ('488', null, '裸聊网'), ('489', null, '裸舞视'), ('490', null, '落霞缀'), ('491', null, '麻古'), ('492', null, '麻果配'), ('493', null, '麻果丸'), ('494', null, '麻将透'), ('495', null, '麻醉狗'), ('496', null, '麻醉枪'), ('497', null, '麻醉槍'), ('498', null, '麻醉藥'), ('499', null, '蟆叫专家'), ('500', null, '卖地财政'), ('501', null, '卖发票'), ('502', null, '卖银行卡'), ('503', null, '卖自考'), ('504', null, '漫步丝'), ('505', null, '忙爱国'), ('506', null, '猫眼工具'), ('507', null, '毛一鲜'), ('508', null, '媒体封锁'), ('509', null, '每周一死'), ('510', null, '美艳少妇'), ('511', null, '妹按摩'), ('512', null, '妹上门'), ('513', null, '门按摩'), ('514', null, '门保健'), ('515', null, '門服務'), ('516', null, '氓培训'), ('517', null, '蒙汗药'), ('518', null, '迷幻型'), ('519', null, '迷幻药'), ('520', null, '迷幻藥'), ('521', null, '迷昏口'), ('522', null, '迷昏药'), ('523', null, '迷昏藥'), ('524', null, '迷魂香'), ('525', null, '迷魂药'), ('526', null, '迷魂藥'), ('527', null, '迷奸药'), ('528', null, '迷情水'), ('529', null, '迷情药'), ('530', null, '迷藥'), ('531', null, '谜奸药'), ('532', null, '蜜穴'), ('533', null, '灭绝罪'), ('534', null, '民储害'), ('535', null, '民九亿商'), ('536', null, '民抗议'), ('537', null, '明慧网'), ('538', null, '铭记印尼'), ('539', null, '摩小姐'), ('540', null, '母乳家'), ('541', null, '木齐针'), ('542', null, '幕没有不'), ('543', null, '幕前戲'), ('544', null, '内射'), ('545', null, '南充针'), ('546', null, '嫩穴'), ('547', null, '嫩阴'), ('548', null, '泥马之歌'), ('549', null, '你的西域'), ('550', null, '拟涛哥'), ('551', null, '娘两腿之间'), ('552', null, '妞上门'), ('553', null, '浓精'), ('554', null, '怒的志愿'), ('555', null, '女被人家搞'), ('556', null, '女激情'), ('557', null, '女技师'), ('558', null, '女人和狗'), ('559', null, '女任职名'), ('560', null, '女上门'), ('561', null, '女優'), ('562', null, '鸥之歌'), ('563', null, '拍肩神药'), ('564', null, '拍肩型'), ('565', null, '牌分析'), ('566', null, '牌技网'), ('567', null, '炮的小蜜'), ('568', null, '陪考枪'), ('569', null, '配有消'), ('570', null, '喷尿'), ('571', null, '嫖俄罗'), ('572', null, '嫖鸡'), ('573', null, '平惨案'), ('574', null, '平叫到床'), ('575', null, '仆不怕饮'), ('576', null, '普通嘌'), ('577', null, '期货配'), ('578', null, '奇迹的黄'), ('579', null, '奇淫散'), ('580', null, '骑单车出'), ('581', null, '气狗'), ('582', null, '气枪'), ('583', null, '汽狗'), ('584', null, '汽枪'), ('585', null, '氣槍'), ('586', null, '铅弹'), ('587', null, '钱三字经'), ('588', null, '枪出售'), ('589', null, '枪的参'), ('590', null, '枪的分'), ('591', null, '枪的结'), ('592', null, '枪的制'), ('593', null, '枪货到'), ('594', null, '枪决女犯'), ('595', null, '枪决现场'), ('596', null, '枪模'), ('597', null, '枪手队'), ('598', null, '枪手网'), ('599', null, '枪销售'), ('600', null, '枪械制'), ('601', null, '枪子弹'), ('602', null, '强权政府'), ('603', null, '强硬发言'), ('604', null, '抢其火炬'), ('605', null, '切听器'), ('606', null, '窃听器'), ('607', null, '禽流感了'), ('608', null, '勤捞致'), ('609', null, '氢弹手'), ('610', null, '清除负面'), ('611', null, '清純壆'), ('612', null, '情聊天室'), ('613', null, '情妹妹'), ('614', null, '情视频'), ('615', null, '情自拍'), ('616', null, '氰化钾'), ('617', null, '氰化钠'), ('618', null, '请集会'), ('619', null, '请示威'), ('620', null, '请愿'), ('621', null, '琼花问'), ('622', null, '区的雷人'), ('623', null, '娶韩国'), ('624', null, '全真证'), ('625', null, '群奸暴'), ('626', null, '群起抗暴'), ('627', null, '群体性事'), ('628', null, '绕过封锁'), ('629', null, '惹的国'), ('630', null, '人权律'), ('631', null, '人体艺'), ('632', null, '人游行'), ('633', null, '人在云上'), ('634', null, '人真钱'), ('635', null, '认牌绝'), ('636', null, '任于斯国'), ('637', null, '柔胸粉'), ('638', null, '肉洞'), ('639', null, '肉棍'), ('640', null, '如厕死'), ('641', null, '乳交'), ('642', null, '软弱的国'), ('643', null, '赛后骚'), ('644', null, '三挫'), ('645', null, '三级片'), ('646', null, '三秒倒'), ('647', null, '三网友'), ('648', null, '三唑'), ('649', null, '骚妇'), ('650', null, '骚浪'), ('651', null, '骚穴'), ('652', null, '骚嘴'), ('653', null, '扫了爷爷'), ('654', null, '色电影'), ('655', null, '色妹妹'), ('656', null, '色视频'), ('657', null, '色小说'), ('658', null, '杀指南'), ('659', null, '山涉黑'), ('660', null, '煽动不明'), ('661', null, '煽动群众'), ('662', null, '上门激'), ('663', null, '烧公安局'), ('664', null, '烧瓶的'), ('665', null, '韶关斗'), ('666', null, '韶关玩'), ('667', null, '韶关旭'), ('668', null, '射网枪'), ('669', null, '涉嫌抄袭'), ('670', null, '深喉冰'), ('671', null, '神七假'), ('672', null, '神韵艺术'), ('673', null, '生被砍'), ('674', null, '生踩踏'), ('675', null, '生肖中特'), ('676', null, '圣战不息'), ('677', null, '盛行在舞'), ('678', null, '尸博'), ('679', null, '失身水'), ('680', null, '失意药'), ('681', null, '狮子旗'), ('682', null, '十八等'), ('683', null, '十大谎'), ('684', null, '十大禁'), ('685', null, '十个预言'), ('686', null, '十类人不'), ('687', null, '十七大幕'), ('688', null, '实毕业证'), ('689', null, '实体娃'), ('690', null, '实学历文'), ('691', null, '士康事件'), ('692', null, '式粉推'), ('693', null, '视解密'), ('694', null, '是躲猫'), ('695', null, '手变牌'), ('696', null, '手答案'), ('697', null, '手狗'), ('698', null, '手机跟'), ('699', null, '手机监'), ('700', null, '手机窃'), ('701', null, '手机追'), ('702', null, '手拉鸡'), ('703', null, '手木仓'), ('704', null, '手槍'), ('705', null, '守所死法'), ('706', null, '兽交'), ('707', null, '售步枪'), ('708', null, '售纯度'), ('709', null, '售单管'), ('710', null, '售弹簧刀'), ('711', null, '售防身'), ('712', null, '售狗子'), ('713', null, '售虎头'), ('714', null, '售火药'), ('715', null, '售假币'), ('716', null, '售健卫'), ('717', null, '售军用'), ('718', null, '售猎枪'), ('719', null, '售氯胺'), ('720', null, '售麻醉'), ('721', null, '售冒名'), ('722', null, '售枪支'), ('723', null, '售热武'), ('724', null, '售三棱'), ('725', null, '售手枪'), ('726', null, '售五四'), ('727', null, '售信用'), ('728', null, '售一元硬'), ('729', null, '售子弹'), ('730', null, '售左轮'), ('731', null, '书办理'), ('732', null, '熟妇'), ('733', null, '术牌具'), ('734', null, '双管立'), ('735', null, '双管平'), ('736', null, '水阎王'), ('737', null, '丝护士'), ('738', null, '丝情侣'), ('739', null, '丝袜保'), ('740', null, '丝袜恋'), ('741', null, '丝袜美'), ('742', null, '丝袜妹'), ('743', null, '丝袜网'), ('744', null, '丝足按'), ('745', null, '司长期有'), ('746', null, '司法黑'), ('747', null, '私房写真'), ('748', null, '死法分布'), ('749', null, '死要见毛'), ('750', null, '四博会'), ('751', null, '四大扯个'), ('752', null, '四小码'), ('753', null, '苏家屯集'), ('754', null, '诉讼集团'), ('755', null, '素女心'), ('756', null, '速代办'), ('757', null, '速取证'), ('758', null, '酸羟亚胺'), ('759', null, '蹋纳税'), ('760', null, '太王四神'), ('761', null, '泰兴幼'), ('762', null, '泰兴镇中'), ('763', null, '泰州幼'), ('764', null, '贪官也辛'), ('765', null, '探测狗'), ('766', null, '涛共产'), ('767', null, '涛一样胡'), ('768', null, '特工资'), ('769', null, '特码'), ('770', null, '特上门'), ('771', null, '体透视镜'), ('772', null, '替考'), ('773', null, '替人体'), ('774', null, '天朝特'), ('775', null, '天鹅之旅'), ('776', null, '天推广歌'), ('777', null, '田罢工'), ('778', null, '田田桑'), ('779', null, '田停工'), ('780', null, '庭保养'), ('781', null, '庭审直播'), ('782', null, '通钢总经'), ('783', null, '偷電器'), ('784', null, '偷肃贪'), ('785', null, '偷听器'), ('786', null, '偷偷贪'), ('787', null, '头双管'), ('788', null, '透视功能'), ('789', null, '透视镜'), ('790', null, '透视扑'), ('791', null, '透视器'), ('792', null, '透视眼镜'), ('793', null, '透视药'), ('794', null, '透视仪'), ('795', null, '秃鹰汽'), ('796', null, '突破封锁'), ('797', null, '突破网路'), ('798', null, '推油按'), ('799', null, '脱衣艳'), ('800', null, '瓦斯手'), ('801', null, '袜按摩'), ('802', null, '外透视镜'), ('803', null, '外围赌球'), ('804', null, '湾版假'), ('805', null, '万能钥匙'), ('806', null, '万人骚动'), ('807', null, '王立军'), ('808', null, '王益案'), ('809', null, '网民案'), ('810', null, '网民获刑'), ('811', null, '网民诬'), ('812', null, '微型摄像'), ('813', null, '围攻警'), ('814', null, '围攻上海'), ('815', null, '维汉员'), ('816', null, '维权基'), ('817', null, '维权人'), ('818', null, '维权谈'), ('819', null, '委坐船'), ('820', null, '谓的和谐'), ('821', null, '温家堡'), ('822', null, '温切斯特'), ('823', null, '温影帝'), ('824', null, '溫家寶'), ('825', null, '瘟加饱'), ('826', null, '瘟假饱'), ('827', null, '文凭证'), ('828', null, '文强'), ('829', null, '纹了毛'), ('830', null, '闻被控制'), ('831', null, '闻封锁'), ('832', null, '瓮安'), ('833', null, '我的西域'), ('834', null, '我搞台独'), ('835', null, '乌蝇水'), ('836', null, '无耻语录'), ('837', null, '无码专'), ('838', null, '五套功'), ('839', null, '五月天'), ('840', null, '午夜电'), ('841', null, '午夜极'), ('842', null, '武警暴'), ('843', null, '武警殴'), ('844', null, '武警已增'), ('845', null, '务员答案'), ('846', null, '务员考试'), ('847', null, '雾型迷'), ('848', null, '西藏限'), ('849', null, '西服进去'), ('850', null, '希脏'), ('851', null, '习进平'), ('852', null, '习晋平'), ('853', null, '席复活'), ('854', null, '席临终前'), ('855', null, '席指着护'), ('856', null, '洗澡死'), ('857', null, '喜贪赃'), ('858', null, '先烈纷纷'), ('859', null, '现大地震'), ('860', null, '现金投注'), ('861', null, '线透视镜'), ('862', null, '限制言'), ('863', null, '陷害案'), ('864', null, '陷害罪'), ('865', null, '相自首'), ('866', null, '香港论坛'), ('867', null, '香港马会'), ('868', null, '香港一类'), ('869', null, '香港总彩'), ('870', null, '硝化甘'), ('871', null, '小穴'), ('872', null, '校骚乱'), ('873', null, '协晃悠'), ('874', null, '写两会'), ('875', null, '泄漏的内'), ('876', null, '新建户'), ('877', null, '新疆叛'), ('878', null, '新疆限'), ('879', null, '新金瓶'), ('880', null, '新唐人'), ('881', null, '信访专班'), ('882', null, '信接收器'), ('883', null, '兴中心幼'), ('884', null, '星上门'), ('885', null, '行长王益'), ('886', null, '形透视镜'), ('887', null, '型手枪'), ('888', null, '姓忽悠'), ('889', null, '幸运码'), ('890', null, '性爱日'), ('891', null, '性福情'), ('892', null, '性感少'), ('893', null, '性推广歌'), ('894', null, '胸主席'), ('895', null, '徐玉元'), ('896', null, '学骚乱'), ('897', null, '学位證'), ('898', null, '學生妹'), ('899', null, '丫与王益'), ('900', null, '烟感器'), ('901', null, '严晓玲'), ('902', null, '言被劳教'), ('903', null, '言论罪'), ('904', null, '盐酸曲'), ('905', null, '颜射'), ('906', null, '恙虫病'), ('907', null, '姚明进去'), ('908', null, '要人权'), ('909', null, '要射精了'), ('910', null, '要射了'), ('911', null, '要泄了'), ('912', null, '夜激情'), ('913', null, '液体炸'), ('914', null, '一小撮别'), ('915', null, '遗情书'), ('916', null, '蚁力神'), ('917', null, '益关注组'), ('918', null, '益受贿'), ('919', null, '阴间来电'), ('920', null, '陰唇'), ('921', null, '陰道'), ('922', null, '陰戶'), ('923', null, '淫魔舞'), ('924', null, '淫情女'), ('925', null, '淫肉'), ('926', null, '淫騷妹'), ('927', null, '淫兽'), ('928', null, '淫兽学'), ('929', null, '淫水'), ('930', null, '淫穴'), ('931', null, '隐形耳'), ('932', null, '隐形喷剂'), ('933', null, '应子弹'), ('934', null, '婴儿命'), ('935', null, '咏妓'), ('936', null, '用手枪'), ('937', null, '幽谷三'), ('938', null, '游精佑'), ('939', null, '有奶不一'), ('940', null, '右转是政'), ('941', null, '幼齿类'), ('942', null, '娱乐透视'), ('943', null, '愚民同'), ('944', null, '愚民政'), ('945', null, '与狗性'), ('946', null, '玉蒲团'), ('947', null, '育部女官'), ('948', null, '冤民大'), ('949', null, '鸳鸯洗'), ('950', null, '园惨案'), ('951', null, '园发生砍'), ('952', null, '园砍杀'), ('953', null, '园凶杀'), ('954', null, '园血案'), ('955', null, '原一九五七'), ('956', null, '原装弹'), ('957', null, '袁腾飞'), ('958', null, '晕倒型'), ('959', null, '韵徐娘'), ('960', null, '遭便衣'), ('961', null, '遭到警'), ('962', null, '遭警察'), ('963', null, '遭武警'), ('964', null, '择油录'), ('965', null, '曾道人'), ('966', null, '炸弹教'), ('967', null, '炸弹遥控'), ('968', null, '炸广州'), ('969', null, '炸立交'), ('970', null, '炸药的制'), ('971', null, '炸药配'), ('972', null, '炸药制'), ('973', null, '张春桥'), ('974', null, '找枪手'), ('975', null, '找援交'), ('976', null, '找政法委副'), ('977', null, '赵紫阳'), ('978', null, '针刺案'), ('979', null, '针刺伤'), ('980', null, '针刺事'), ('981', null, '针刺死'), ('982', null, '侦探设备'), ('983', null, '真钱斗地'), ('984', null, '真钱投注'), ('985', null, '真善忍'), ('986', null, '真实文凭'), ('987', null, '真实资格'), ('988', null, '震惊一个民'), ('989', null, '震其国土'), ('990', null, '证到付款'), ('991', null, '证件办'), ('992', null, '证件集团'), ('993', null, '证生成器'), ('994', null, '证书办'), ('995', null, '证一次性'), ('996', null, '政府操'), ('997', null, '政论区'), ('998', null, '證件'), ('999', null, '植物冰'), ('1000', null, '殖器护'), ('1001', null, '指纹考勤'), ('1002', null, '指纹膜'), ('1003', null, '指纹套'), ('1004', null, '至国家高'), ('1005', null, '志不愿跟'), ('1006', null, '制服诱'), ('1007', null, '制手枪'), ('1008', null, '制证定金'), ('1009', null, '制作证件'), ('1010', null, '中的班禅'), ('1011', null, '中共黑'), ('1012', null, '中国不强'), ('1013', null, '种公务员'), ('1014', null, '种学历证'), ('1015', null, '众像羔'), ('1016', null, '州惨案'), ('1017', null, '州大批贪'), ('1018', null, '州三箭'), ('1019', null, '宙最高法'), ('1020', null, '昼将近'), ('1021', null, '主席忏'), ('1022', null, '住英国房'), ('1023', null, '助考'), ('1024', null, '助考网'), ('1025', null, '专业办理'), ('1026', null, '专业代'), ('1027', null, '专业代写'), ('1028', null, '专业助'), ('1029', null, '转是政府'), ('1030', null, '赚钱资料'), ('1031', null, '装弹甲'), ('1032', null, '装枪套'), ('1033', null, '装消音'), ('1034', null, '着护士的胸'), ('1035', null, '着涛哥'), ('1036', null, '姿不对死'), ('1037', null, '资格證'), ('1038', null, '资料泄'), ('1039', null, '梓健特药'), ('1040', null, '字牌汽'), ('1041', null, '自己找枪'), ('1042', null, '自慰用'), ('1043', null, '自由圣'), ('1044', null, '自由亚'), ('1045', null, '总会美女'), ('1046', null, '足球玩法'), ('1047', null, '最牛公安'), ('1048', null, '醉钢枪'), ('1049', null, '醉迷药'), ('1050', null, '醉乙醚'), ('1051', null, '尊爵粉'), ('1052', null, '左转是政'), ('1053', null, '作弊器'), ('1054', null, '作各种证'), ('1055', null, '作硝化甘'), ('1056', null, '唑仑'), ('1057', null, '做爱小'), ('1058', null, '做原子弹'), ('1059', null, '做证件');
COMMIT;

