##########################################################################################################################
# Cloud_STM32F429IGTx_FIRE GCC compiler config
##########################################################################################################################

# ------------------------------------------------
# Generic Makefile (based on gcc)
# ------------------------------------------------
# compile option

#######################################
# use USE_BOOTLOADER
#######################################
USE_BOOTLOADER  := no

#######################################
# use Lwm2m protocol
#######################################
WITH_LWM2M  := yes

#######################################
# use MQTT protocol
#######################################
WITH_MQTT  := no


#######################################
# use ethernet
#######################################
WITH_LWIP  := yes

#######################################
# use usart AT command
#######################################
WITH_AT_FRAMEWORK := no
ifeq ($(WITH_AT_FRAMEWORK), yes)
#ESP8266   # SIM900A  # NB_NEUL95  # ALL
	NETWORK_TYPE := NB_NEUL95
endif

#######################################
# use mbedtls
#######################################
WITH_DTLS := yes

#######################################
# whether OTA Pack use checksum
#######################################
#SHA256_RSA2048   #SHA256  #NO_CHECKSUM
OTA_PACK_CHECKSUM := SHA256_RSA2048

#######################################
# Firmware Over-The-Air
#######################################
USE_FOTA := no

#######################################
# Firmware Over-The-Air
#######################################
USE_SOTA := no

#######################################
# Lwm2m bootstrap program 
#######################################
LWM2M_BOOTSTRAP := yes

#######################################
# Lwm2m bootstrap used 
#######################################
SUPPORT_DTLS_SRV := no

#######################################
# Lwm2m core log
#######################################
LWM2M_WITH_LOGS := no

#######################################
# Agenttiny log
#######################################
ATINY_DEBUG := no

#######################################
# File System
#######################################
WITH_FILESYSTEM := no
ifeq ($(WITH_FILESYSTEM), yes)
#SPIFFS   #FATFS   #JFFS2
	FILESYSTEM_TYPE := FATFS
endif

#######################################
# CMockery Test
#######################################
WITH_CMOCKERY_TEST := no
