<?php
/* +----------------------------------------------------------------------+
   | Copyright (c) 2018-2019 YmPay                                        |
   |              <530759076@qq.com>                                      |
   +----------------------------------------------------------------------+*/
namespace App\Http\Controllers\Admin;
use Vinkla\Hashids\Facades\Hashids;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Http\Models\OrderModel;
use App\Http\Models\DrawingModel;
use App\Http\Models\MemberpaymentModel;
use App\Http\Models\PaymentModel;
use App\Http\Models\DiepollingpaymentModel;
use App\Http\Models\LivepollingpaymentModel;
use App\Http\Models\QrcodeErrorModel;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Common\Alipay;
use App\Http\Controllers\Common\Google;
use App\Http\Controllers\Common\Order_Redis;
use GatewayClient\Gateway;
use Illuminate\Support\Facades\Redis;
use QrCode;

class AdminController extends AdminCommonController{
	/****后台首页****/
	public function main(Request $arr){

	   	if($arr->isMethod('post')){
	   		if($arr->input('action') == 'text'){
	   			/***总成功订单量****/
	   			$json['data']['text']['order_success_num']=DB::table('order')->where('status',2)->count();
	   			/***总成功订单额****/
	   			$json['data']['text']['order_success_money']=DB::table('order')->where('status',2)->sum('order_price');
	   			/***总商户数量*****/
	   			$json['data']['text']['member_num']=DB::table('user')->count();
	   			/***总码商数量****/
	   			$json['data']['text']['merchant_num']=DB::table('member')->count();
	   			/****当月订单量****/
	   			$map['status']=2;
	   			$map[]=['sub_time','<',strtotime(date('Y-m-d 00:00:00'))+86400];
	   			$map[]=['sub_time','>=',strtotime(date('Y-m-d 00:00:00'))-86400*30];
	   			$json['data']['text']['order_month_success_num']=DB::table('order')->where($map)->count();
	   			/****当日订单额****/
	   			$map2['status']=2;
	   			$map2[]=['sub_time','<',strtotime(date('Y-m-d 00:00:00'))+86400];
	   			$map2[]=['sub_time','>=',strtotime(date('Y-m-d 00:00:00'))];
	   			$json['data']['text']['order_day_success_money']=DB::table('order')->where($map2)->sum('order_price');
	   			/****当日订单额占总额比例****/
	   			$json['data']['text']['order_day_success_money_comparison']=$json['data']['text']['order_success_money'] == 0 ? 0 : ceil($json['data']['text']['order_day_success_money']/$json['data']['text']['order_success_money']*100);
	   			/****上月订单量****/
	   			$map3['status']=2;
	   			$map3[]=['sub_time','<',strtotime(date('Y-m-d 00:00:00'))-86400*30];
	   			$map3[]=['sub_time','>=',strtotime(date('Y-m-d 00:00:00'))-86400*60];
	   			$json['data']['text']['order_lastmonth_success_num']=DB::table('order')->where($map3)->count();
	   			/****当月与上月对比同比***/
	   			if($json['data']['text']['order_lastmonth_success_num'] != 0){
                    if($json['data']['text']['order_lastmonth_success_num']>$json['data']['text']['order_month_success_num']){
                    $json['data']['text']['monthly_comparison']='-'.number_format(($json['data']['text']['order_lastmonth_success_num']-$json['data']['text']['order_month_success_num'])/$json['data']['text']['order_lastmonth_success_num']*100,2,".","").'%';
                    }else{
                        $json['data']['text']['monthly_comparison']='+'.number_format(($json['data']['text']['order_month_success_num']-$json['data']['text']['order_lastmonth_success_num'])/$json['data']['text']['order_lastmonth_success_num']*100,2,".","").'%';
                    }
                }else{
                    $json['data']['text']['monthly_comparison']='+100%';
                }
                /***当月新增商户数量****/
                $map4[]=['time','<',strtotime(date('Y-m-d 00:00:00'))+86400];
	   			$map4[]=['time','>=',strtotime(date('Y-m-d 00:00:00'))-86400*30];
	   			$json['data']['text']['member_regmonth_num']=DB::table('user')->where($map4)->count();
	   			/***当月新注册前3商户组*****/
	   			$json['data']['text']['member_regtop3']=DB::table('user')->where($map4)->orderBy('id','desc')->take(3)->select('Id','phone')->get()->toarray();
	   			/***当月新增码商数量****/
	   			$json['data']['text']['merchant_regmonth_num']=DB::table('member')->where($map4)->count();
	   			/***当月新注册前3码商组*****/
	   			$json['data']['text']['merchant_regtop3']=DB::table('member')->where($map4)->orderBy('id','desc')->take(3)->select('Id','phone')->get()->toarray();

	   		}else if($arr->input('action')== 'chart'){
	   			$week= !empty($arr->input('time')) ? getweek('',$arr->input('time')) : getweek();
	   			$time= !empty($arr->input('time')) ? $arr->input('time') : 7;
		    	foreach ($week as $k => $v) {
		    		$map[$k][]=['sub_time','>=',$v['time']];
					$map[$k][]=['sub_time','<',$v['time']+86400];
		    		$json['data']['chart'][$k]['日期']=$v['date'];
		    		/****遍历查询每日成功订单金额****/
		    		$map[$k]['status']=2;
		    		/****遍历查询每日成功订单金额****/
		    		$json['data']['chart'][$k]['订单金额']=number_format(DB::table('order')->where($map[$k])->sum('order_money'),2,".","");
		    	}
		    	$map2['status']=2;
		    	$map2[]=['sub_time','<',strtotime(date('Y-m-d 00:00:00'))+86400];
        		$map2[]=['sub_time','>=',strtotime(date('Y-m-d 00:00:00'))-86400*$time];
		    	/****查询订单量最大前10个码商****/
		        $memberorder=OrderModel::where($map2)->selectRaw('sum(order_price) as price_total,member_id')->selectRaw('count(member_id) as count_member,member_id')->groupBy('member_id')->with(['merchant' => function ($query) {
		                return $query->select('Id','phone');
		            }])->orderBy('price_total','desc')->take(10)->get()->toArray();
		        if(!empty($memberorder)){
		             $json['data']['top']=$memberorder;
		        }else{
		        	$json['data']['top']=[];
		        }
	   		}
	   		return $json;
	   	}
	   	return view('admin/main');
	}
	/****后台登录日志****/
	public function login_log(Request $arr){
		if($arr->isMethod('post')){
			if($arr->has('page')){
				if($arr->filled('time') && is_array($arr->input('time'))){
					$time=$arr->input('time');
					if(!empty($time[0]) && !empty($time[1])){
						$map[]=['time','>=',strtotime($time[0])];
		       	  		$map[]=['time','<',strtotime($time[1])+86400];
					}
				}
				$listpage=DB::table('admin_log')->orderBy('id','desc')->paginate(15)->toarray();
				if($listpage['total'] >= 1){
	       	  		$data=$listpage['data'];
	       	  		foreach ($data as $k => $v) {
	       	  			$v=(array)$v;
	       	  			$v['time']=date('Y-m-d H:i:s',$v['time']);
	       	  			$json['data']['list'][]=$v;
	       	  		}
	       	  	}else{
	       	  		$json['data']['list']=[];
	       	  	}
	       	  	$json['current_page']=$listpage['current_page'];
			   	$json['total']=$listpage['total'];
			   	$json['status']="ok";
			}else if($arr->input('action') == 'del'){
				$data = $arr->input('form');
				if(is_array($data)){
					foreach($data as $k => $v){
						$v = (array)$v;
						if($k < 1){
							$deldata[]=['Id','=',$v['Id']];
						}else{
							$deldata[]=['Id','=',$v['Id'],'or'];
						}
					}
					$num = DB::table('admin_log')->where($deldata)->delete();
					if($num == 0){
						$json['status'] = "error";
						$json['msg'] = "删除失败,出现错误";
					}else{
						$json['status'] = "ok";
						$json['msg'] = "删除成功,共删除{$num}条";
					}
				}else{
					$json['status']="error";
					$json['msg']="提交出现错误,请刷新重试";
				}
			}else{
				$json['status']="error";
				$json['msg']="不安全的提交方式";
			}
			return $json;
		}

		return view('admin/login_log');
	}
	/****后台操作日志****/
	public function operation_log(Request $arr){
		if($arr->isMethod('post')){
			if($arr->has('page')){
				if($arr->filled('time') && is_array($arr->input('time'))){
					$time=$arr->input('time');
					if(!empty($time[0]) && !empty($time[1])){
						$map[]=['time','>=',strtotime($time[0])];
		       	  		$map[]=['time','<',strtotime($time[1])+86400];
					}
				}
				$listpage=DB::table('admin_operation')->orderBy('id','desc')->paginate(15)->toarray();
				if($listpage['total'] >= 1){
	       	  		$data=$listpage['data'];
	       	  		foreach ($data as $k => $v) {
	       	  			$v=(array)$v;
	       	  			$v['time']=date('Y-m-d H:i:s',$v['time']);
	       	  			$json['data']['list'][]=$v;
	       	  		}
	       	  	}else{
	       	  		$json['data']['list']=[];
	       	  	}
	       	  	$json['current_page']=$listpage['current_page'];
			   	$json['total']=$listpage['total'];
			   	$json['status']="ok";
			}else if($arr->input('action') == 'del'){
				$data = $arr->input('form');
				if(is_array($data)){
					foreach($data as $k => $v){
						$v = (array)$v;
						if($k < 1){
							$deldata[]=['Id','=',$v['Id']];
						}else{
							$deldata[]=['Id','=',$v['Id'],'or'];
						}
					}
					$num = DB::table('admin_operation')->where($deldata)->delete();
					if($num == 0){
						$json['status'] = "error";
						$json['msg'] = "删除失败,出现错误";
					}else{
						$json['status'] = "ok";
						$json['msg'] = "删除成功,共删除{$num}条";
					}
				}else{
					$json['status']="error";
					$json['msg']="提交出现错误,请刷新重试";
				}
			}else{
				$json['status']="error";
				$json['msg']="不安全的提交方式";
			}
			return $json;
		}

		return view('admin/operation_log');
	}
	/****后台码商列表****/
	public function merchantlist(Request $arr){
		if($arr->isMethod('post')){
			if($arr->has('page')){
				if($arr->filled('field') && $arr->input('field')!='-1' && $arr->filled('value')){
					$map[]=[$arr->input('field'),'like','%'.$arr->input('value').'%'];
				}
				if($arr->filled('open') && $arr->input('open')!= '-1' ){
					$map['open']=intval($arr->input('open'));
				}
				if($arr->filled('time') && is_array($arr->input('time'))){
					$time=$arr->input('time');
					if(!empty($time[0]) && !empty($time[1])){
						$map[]=['time','>=',strtotime($time[0])];
		       	  		$map[]=['time','<',strtotime($time[1])+86400];
					}
				}
				if($arr->filled('status')){
					if($arr->input('status') == "全部"){
						$map[]=['status','!=',null];
					}else if($arr->input('status') == "正常"){
						$map[]=['status',1];
					}else{
						$map[]=['status',2];
					}
				}else{
					$map[]=['status','!=',null];
				}
			   $listpage=DB::table('member')->where($map)->orderBy('id','desc')->paginate(15)->toarray();
			   /****总码商个数****/
			   $json['data']['toptext']['merchant_count']=DB::table('member')->count();
			   /****正常码商个数****/
			   $map2['status']=1;
			   $json['data']['toptext']['merchant_normal']=DB::table('member')->where($map2)->count();
			   /****冻结码商个数****/
			   $map2['status']=2;
			   $json['data']['toptext']['merchant_frozen']=DB::table('member')->where($map2)->count();
			   /****总码商可用余额****/
			   $json['data']['toptext']['merchant_price']=number_format(DB::table('member')->sum('price'),2,".","");
			   if($listpage['total'] >= 1){
	       	  		$data=$listpage['data'];
	       	  		foreach ($data as $k => $v) {
	       	  			$v=(array)$v;
	       	  			$v['time']=date('Y-m-d H:i:s',$v['time']);
	       	  			$v['service'] = $v['service']*100;
	       	  			$json['data']['list'][]=$v;
	       	  		}
	       	  	}else{
	       	  		$json['data']['list']=[];
	       	  	}
	       	  	$json['data']['merchant_site']=DB::table('admin_member_site')->first();
	       	  	$json['data']['merchant_site']->service = $json['data']['merchant_site']->service*100;
	       	  	$json['current_page']=$listpage['current_page'];
			   	$json['total']=$listpage['total'];
			   	$json['status']="ok";
			}else if($arr->input('action') == 'passageway'){
				/****获取所有固码****/
				$json['data']['diepassageway']=DB::table('die_passageway')->where('status',1)->get()->toarray();
				/****获取所有活码****/
				$json['data']['livepassageway']=DB::table('live_passageway')->where('status',1)->get()->toarray();
			}else if($arr->input('action') == 'add'){
				$postdata = $arr->input('form');
				$merchant_site = DB::table('admin_member_site')->first();
				if(checkphone($postdata['phone'])){
					if(checkpass($postdata['password'])){
						//查询是否存在该手机号码商
					  if(!DB::table('member')->where('phone',$postdata['phone'])->first()){
						if((float)$postdata['service'] >= '0.01'){
							$ga = new Google;
							$postdata['service']=$postdata['service']/100;
							$postdata['password'] = xpass($postdata['password']);
							$postdata['safetycode'] = $ga->createSecret();

							if(empty($postdata['diepolling_num'])){
								$postdata['diepolling_num'] =  $merchant_site->diepolling_max;
							}
							if(empty($postdata['livepolling_num'])){
								$postdata['livepolling_num'] =  $merchant_site->livepolling_max;
							}
							if(empty($postdata['frozen_amount']) || $postdata['frozen_amount']<1){
								$postdata['frozen_amount'] =  $merchant_site->frozen_amount;
							}else{
								$postdata['frozen_amount'] = (float)$postdata['frozen_amount'];
							}
							if(empty($postdata['price']) || $postdata['price']<1){
								$postdata['price'] =  $merchant_site->price;
							}else{
								$postdata['price'] = (float)$postdata['price'];
							}
							if(empty($postdata['frozen_amount']) || $postdata['frozen_amount']<1){
								$postdata['frozen_amount'] =  $merchant_site->frozen_amount;
							}else{
								$postdata['frozen_amount'] = (float)$postdata['frozen_amount'];
							}

							if($postdata['open'] == "开放平台"){
								$postdata['open'] = 1;
							}else{
								$postdata['open'] = 2;
							}
							if($postdata['status'] == "正常"){
								$postdata['status'] = 1;
							}else{
								$postdata['status'] = 2;
							}
							$postdata['apikey'] = getmerchantkey();
							$postdata['time'] = time();
							$data = $postdata;
							/***转换后清除添加码商通道数据***/
							unset($postdata['diepassageway']);
							unset($postdata['livepassageway']);
							$status = DB::table('member')->insertGetId($postdata);
							if($status){
								if(!empty($data['diepassageway'])){
									if($data['diepassageway'] == '-1' || in_array('-1',$data['diepassageway'])){
										$payment=DB::table('die_passageway')->where('status',1)->select('Id')->get()->toarray();
										foreach ($payment as $v) {
											$v = (array)$v;
											$v['passageway_id'] =$v['Id'];
						                    $v['passageway_type'] = 1;
						                    $v['member_id'] = $status;
						                    unset($v['Id']);
						                    $addpayment[] = $v;
										}
									}else{
										foreach ($data['diepassageway'] as $v) {
											$addpayment[]=array('member_id'=>$status,'passageway_id'=>$v,'passageway_type'=>1);
										}
									}

								}
								if(!empty($data['livepassageway'])){
									if($data['livepassageway'] == '-1' || in_array('-1',$data['livepassageway'])){
										$payment=DB::table('live_passageway')->where('status',1)->select('Id')->get()->toarray();
										foreach ($payment as $v) {
											$v = (array)$v;
											$v['passageway_id'] =$v['Id'];
						                    $v['passageway_type'] = 2;
						                    $v['member_id'] = $status;
						                    unset($v['Id']);
						                    $addpayment[] = $v;
										}
									}else{
										foreach ($data['livepassageway'] as $v) {
											$addpayment[]=array('member_id'=>$status,'passageway_id'=>$v,'passageway_type'=>2);
										}
									}
								}
								$payment_status = DB::table('memberpayment')->insert($addpayment);
								if($payment_status){
									$json['status']="ok";
									$json['msg']="码商添加成功,当前添加码商ID:{$status}";
								}else{
									$json['status']="ok";
									$json['msg']="码商添加成功,通道添加失败,添加码商ID:{$status}";
								}
							}else{
								$json['status']="error";
								$json['msg']="码商添加失败,请重试";
							}
						}else{
							$json['status']="error";
							$json['msg']="码商费率最低在0.01%";
						}
					  }else{
					  	$json['status']="error";
						$json['msg']="该手机号码商已存在";
					  }
					}else{
						$json['status']="error";
						$json['msg']="密码请输入在6~20位";
					}
				}else{
					$json['status']="error";
					$json['msg']="请输入正确的手机号";
				}
			}else if($arr->input('action') == 'edit'){
				$postdata = $arr->input('form');
				if(!empty($postdata['phone'])){
					if(!checkphone($postdata['phone'])){
						$json['status']="error";
						$json['msg']="请输入正确的手机号";
					}else{
						if(!DB::table('member')->where('phone',$postdata['phone'])->first()){
							 $updata['phone'] = $postdata['phone'];
						}else{
							$json['status'] ="error";
							$json['msg'] = "当前手机号码商已存在";
						}
					}
				}
				if(!empty($postdata['password'])){
					if(!checkpass($postdata['password'])){
						$json['status']="error";
						$json['msg']="密码请输入在6~20位";
					}else{
						$updata['password'] = xpass($postdata['password']);
					}
				}
				if(empty($postdata['diepolling_num']) || intval($postdata['diepolling_num']) < 1){
					$updata['diepolling_num'] = 0;
				}else{
					$updata['diepolling_num'] = intval($postdata['diepolling_num']);
				}
				if(empty($postdata['livepolling_num']) || intval($postdata['livepolling_num']) < 1){
					$updata['livepolling_num'] = 0;
				}else{
					$updata['livepolling_num'] = intval($postdata['livepolling_num']);
				}
				if((float)$postdata['service'] < '0.01'){
					$json['status']="error";
					$json['msg']="码商费率最低在0.01%";
				}else{
					$updata['service'] = $postdata['service']/100;
				}
				$updata['open'] = $postdata['open'];
				$updata['status'] = $postdata['status'];
				if(!isset($json)){
					$status = DB::table('member')->where('Id',$postdata['Id'])->update($updata);
					if($status){
						$admin_site = DB::table('admin_site')->first();
						$Order_Redis = new Order_Redis;
						//清除此码商码池
                        $redis_data['member_id'] = $postdata['Id'];
                        /****删除支付宝二维码****/
                        $Order_Redis->delete($admin_site->payment_type,'alipay',1,$redis_data);
                        /****删除支付宝H5二维码****/
                        $Order_Redis->delete($admin_site->payment_type,'aliwap',1,$redis_data);
                        /****删除微信二维码****/
                        $Order_Redis->delete($admin_site->payment_type,'wechat',1,$redis_data);
                        /****删除银联二维码****/
                        $Order_Redis->delete($admin_site->payment_type,'unionpay',1,$redis_data);
                        /****删除支付宝二维码****/
                        $Order_Redis->delete($admin_site->payment_type,'alipay',2,$redis_data);
                        /****删除支付宝H5二维码****/
                        $Order_Redis->delete($admin_site->payment_type,'aliwap',2,$redis_data);
                        /****删除微信二维码****/
                        $Order_Redis->delete($admin_site->payment_type,'wechat',2,$redis_data);
                        /****删除银联二维码****/
                        $Order_Redis->delete($admin_site->payment_type,'unionpay',2,$redis_data);
						if($updata['status'] != 2){
							//再次添加此码商码池
							$order_redis_die_list = DiepollingpaymentModel::where(array('member_id'=>$redis_data['member_id'],'gateway_state'=>1))->whereHas('user',function($query){
					    		$query->where('status','=',1);
					    		$query->where('loop','=',1);
					    	})->whereHas('merchant',function($query){
					    		$query->where('price','>',1);
					    		$query->where('frozen_amount','>=',0);
					    	})->with(['user','payment','merchant'])->get();
					    	//活码
					    	$order_redis_live_list = LivepollingpaymentModel::where(array('member_id'=>$redis_data['member_id'],'gateway_state'=>1))->whereHas('user',function($query){
					    		$query->where('status','=',1);
					    		$query->where('loop','=',1);
					    	})->whereHas('merchant',function($query){
					    		$query->where('price','>',1);
					    		$query->where('frozen_amount','>=',0);
					    	})->with(['user','payment','merchant'])->get();
					    	if($order_redis_die_list->isNotEmpty()){
					    		$order_redis_die_list = $order_redis_die_list->toarray();
					    		 if($admin_site->payment_type = 1){
					    		 	foreach ($order_redis_die_list as $v){
						    			$v = (array)$v;
                                        if(stristr($v['payment']['paytype'],'alipay') !== false){
                                            //添加顺序列表
                                            Redis::rpush('sort_alipay_die',json_encode($v));
                                        }
                                        if(stristr($v['payment']['paytype'],'aliwap') !== false){
                                            //添加顺序列表
                                            Redis::rpush('sort_aliwap_die',json_encode($v));
                                        }
                                        if(stristr($v['payment']['paytype'],'wechat') !== false){
                                            //添加顺序列表
                                            Redis::rpush('sort_wechat_die',json_encode($v));
                                        }
                                        if(stristr($v['payment']['paytype'],'unionpay') !== false){
                                            //添加顺序列表
                                            Redis::rpush('sort_unionpay_die',json_encode($v));
                                        }
						    		}
					    		 }else{
					    		 	foreach ($order_redis_die_list as $v){
					    		 		$v = (array)$v;
					    		 		if(stristr($v['payment']['paytype'],'alipay') !== false){
                                            //添加随机列表
                                            Redis::sadd('random_alipay_die',json_encode($v));
                                        }
                                        if(stristr($v['payment']['paytype'],'aliwap') !== false){
                                            //添加随机列表
                                            Redis::sadd('random_aliwap_die',json_encode($v));
                                        }
                                        if(stristr($v['payment']['paytype'],'wechat') !== false){
                                            //添加随机列表
                                            Redis::sadd('random_wechat_die',json_encode($v));
                                        }
                                        if(stristr($v['payment']['paytype'],'unionpay') !== false){
                                            //添加随机列表
                                            Redis::sadd('random_unionpay_die',json_encode($v));
                                        }
					    		 	}
					    		 }
					    	}
					    	if($order_redis_live_list->isNotEmpty()){
					    		$order_redis_live_list = $order_redis_live_list->toarray();
					    		if($admin_site->payment_type = 1){
					    		 	foreach ($order_redis_live_list as $v){
						    			$v = (array)$v;
                                        if(stristr($v['payment']['paytype'],'alipay') !== false){
                                            //添加顺序列表
                                            Redis::rpush('sort_alipay_live',json_encode($v));
                                        }
                                        if(stristr($v['payment']['paytype'],'aliwap') !== false){
                                            //添加顺序列表
                                            Redis::rpush('sort_aliwap_live',json_encode($v));
                                        }
                                        if(stristr($v['payment']['paytype'],'wechat') !== false){
                                            //添加顺序列表
                                            Redis::rpush('sort_wechat_live',json_encode($v));
                                        }
                                        if(stristr($v['payment']['paytype'],'unionpay') !== false){
                                            //添加顺序列表
                                            Redis::rpush('sort_unionpay_live',json_encode($v));
                                        }
						    		}
					    		 }else{
					    		 	foreach ($order_redis_live_list as $v){
					    		 		$v = (array)$v;
					    		 		if(stristr($v['payment']['paytype'],'alipay') !== false){
                                            //添加随机列表
                                            Redis::sadd('random_alipay_live',json_encode($v));
                                        }
                                        if(stristr($v['payment']['paytype'],'aliwap') !== false){
                                            //添加随机列表
                                            Redis::sadd('random_aliwap_live',json_encode($v));
                                        }
                                        if(stristr($v['payment']['paytype'],'wechat') !== false){
                                            //添加随机列表
                                            Redis::sadd('random_wechat_live',json_encode($v));
                                        }
                                        if(stristr($v['payment']['paytype'],'unionpay') !== false){
                                            //添加随机列表
                                            Redis::sadd('random_unionpay_live',json_encode($v));
                                        }
					    		 	}
					    		 }
					    	}
						}
						$json['status']="ok";
						$json['msg']="修改成功";
					}else{
						$json['status']="error";
						$json['msg']="当前无更改,修改失败";
						$json['data']=$updata;
					}
				}
			}else if($arr->input('action') == 'amount'){
				$data =$arr->input('form');
				if(!empty($data['Id'])){
					 $merchant = DB::table('member')->where('Id',$data['Id'])->first();
					if(!empty($data['price'])){
						if($data['price'] != 0){
							if($data['price'] < 0){
								$amount_change['type'] = 4;
								$amount_change['amount'] = abs($data['price']);
							}else{
								$amount_change['type'] = 2;
								$amount_change['amount'] = $data['price'];
							}
							$updata['price'] = $merchant->price+$data['price'];
							$updata['frozen_amount'] = $merchant->frozen_amount+$data['frozen_amount'];
							$status = DB::table('member')->where('Id',$data['Id'])->update($updata);
							if($status){
								//添加码商余额明细
								$amount_change['member_id'] = $data['Id'];
								$amount_change['member_price'] = $updata['price'];
								$amount_change['time'] = time();
								DB::table('member_amount_change')->insert($amount_change);
								//更新码池
								$Order_Redis = new Order_Redis;
								$admin_site = DB::table('admin_site')->first();
								//清除此码商码池
		                        $redis_data['member_id'] = $data['Id'];
		                        /****删除支付宝二维码****/
		                        $Order_Redis->delete($admin_site->payment_type,'alipay',1,$redis_data);
		                        /****删除支付宝H5二维码****/
		                        $Order_Redis->delete($admin_site->payment_type,'aliwap',1,$redis_data);
		                        /****删除微信二维码****/
		                        $Order_Redis->delete($admin_site->payment_type,'wechat',1,$redis_data);
		                        /****删除银联二维码****/
		                        $Order_Redis->delete($admin_site->payment_type,'unionpay',1,$redis_data);
		                        /****删除支付宝二维码****/
		                        $Order_Redis->delete($admin_site->payment_type,'alipay',2,$redis_data);
		                        /****删除支付宝H5二维码****/
		                        $Order_Redis->delete($admin_site->payment_type,'aliwap',2,$redis_data);
		                        /****删除微信二维码****/
		                        $Order_Redis->delete($admin_site->payment_type,'wechat',2,$redis_data);
		                        /****删除银联二维码****/
		                        $Order_Redis->delete($admin_site->payment_type,'unionpay',2,$redis_data);
								//再次添加此码商码池
								$order_redis_die_list = DiepollingpaymentModel::where(array('member_id'=>$redis_data['member_id'],'gateway_state'=>1))->whereHas('user',function($query){
						    		$query->where('status','=',1);
						    		$query->where('loop','=',1);
						    	})->whereHas('merchant',function($query){
						    		$query->where('price','>',1);
						    		$query->where('frozen_amount','>=',0);
						    	})->with(['user','payment','merchant'])->get();
						    	//活码
						    	$order_redis_live_list = LivepollingpaymentModel::where(array('member_id'=>$redis_data['member_id'],'gateway_state'=>1))->whereHas('user',function($query){
						    		$query->where('status','=',1);
						    		$query->where('loop','=',1);
						    	})->whereHas('merchant',function($query){
						    		$query->where('price','>',1);
						    		$query->where('frozen_amount','>=',0);
						    	})->with(['user','payment','merchant'])->get();
						    	if($order_redis_die_list->isNotEmpty()){
						    		$order_redis_die_list = $order_redis_die_list->toarray();
						    		 if($admin_site->payment_type = 1){
						    		 	foreach ($order_redis_die_list as $v){
							    			$v = (array)$v;
	                                        if(stristr($v['payment']['paytype'],'alipay') !== false){
	                                            //添加顺序列表
	                                            Redis::rpush('sort_alipay_die',json_encode($v));
	                                        }
	                                        if(stristr($v['payment']['paytype'],'aliwap') !== false){
	                                            //添加顺序列表
	                                            Redis::rpush('sort_aliwap_die',json_encode($v));
	                                        }
	                                        if(stristr($v['payment']['paytype'],'wechat') !== false){
	                                            //添加顺序列表
	                                            Redis::rpush('sort_wechat_die',json_encode($v));
	                                        }
	                                        if(stristr($v['payment']['paytype'],'unionpay') !== false){
	                                            //添加顺序列表
	                                            Redis::rpush('sort_unionpay_die',json_encode($v));
	                                        }
							    		}
						    		 }else{
						    		 	foreach ($order_redis_die_list as $v){
						    		 		$v = (array)$v;
						    		 		if(stristr($v['payment']['paytype'],'alipay') !== false){
	                                            //添加随机列表
	                                            Redis::sadd('random_alipay_die',json_encode($v));
	                                        }
	                                        if(stristr($v['payment']['paytype'],'aliwap') !== false){
	                                            //添加随机列表
	                                            Redis::sadd('random_aliwap_die',json_encode($v));
	                                        }
	                                        if(stristr($v['payment']['paytype'],'wechat') !== false){
	                                            //添加随机列表
	                                            Redis::sadd('random_wechat_die',json_encode($v));
	                                        }
	                                        if(stristr($v['payment']['paytype'],'unionpay') !== false){
	                                            //添加随机列表
	                                            Redis::sadd('random_unionpay_die',json_encode($v));
	                                        }
						    		 	}
						    		 }
						    	}
						    	if($order_redis_live_list->isNotEmpty()){
						    		$order_redis_live_list = $order_redis_live_list->toarray();
						    		if($admin_site->payment_type = 1){
						    		 	foreach ($order_redis_live_list as $v){
							    			$v = (array)$v;
	                                        if(stristr($v['payment']['paytype'],'alipay') !== false){
	                                            //添加顺序列表
	                                            Redis::rpush('sort_alipay_live',json_encode($v));
	                                        }
	                                        if(stristr($v['payment']['paytype'],'aliwap') !== false){
	                                            //添加顺序列表
	                                            Redis::rpush('sort_aliwap_live',json_encode($v));
	                                        }
	                                        if(stristr($v['payment']['paytype'],'wechat') !== false){
	                                            //添加顺序列表
	                                            Redis::rpush('sort_wechat_live',json_encode($v));
	                                        }
	                                        if(stristr($v['payment']['paytype'],'unionpay') !== false){
	                                            //添加顺序列表
	                                            Redis::rpush('sort_unionpay_live',json_encode($v));
	                                        }
							    		}
						    		 }else{
						    		 	foreach ($order_redis_live_list as $v){
						    		 		$v = (array)$v;
						    		 		if(stristr($v['payment']['paytype'],'alipay') !== false){
	                                            //添加随机列表
	                                            Redis::sadd('random_alipay_live',json_encode($v));
	                                        }
	                                        if(stristr($v['payment']['paytype'],'aliwap') !== false){
	                                            //添加随机列表
	                                            Redis::sadd('random_aliwap_live',json_encode($v));
	                                        }
	                                        if(stristr($v['payment']['paytype'],'wechat') !== false){
	                                            //添加随机列表
	                                            Redis::sadd('random_wechat_live',json_encode($v));
	                                        }
	                                        if(stristr($v['payment']['paytype'],'unionpay') !== false){
	                                            //添加随机列表
	                                            Redis::sadd('random_unionpay_live',json_encode($v));
	                                        }
						    		 	}
						    		 }
						    	}
								$json['status'] = "ok";
								$json['msg'] = "充值成功";
							}else{
								$json['status'] = "error";
								$json['msg'] = "金额充值失败";
							}
						}else{
							$json['status'] = "error";
							$json['msg'] = "充值金额不得为0";
						}
					}else{
						$json['status'] = "error";
						$json['msg'] = "请输入充值可用金额";
					}
				}else{
					$json['status'] = "error";
					$json['msg'] = "提交参数错误";
				}
			}else if($arr->input('action') == 'frozen_amount'){
				$data =$arr->input('form');
				if(!empty($data['Id'])){
					 $merchant = DB::table('member')->where('Id',$data['Id'])->first();
					if(!empty($data['frozen_amount'])){
						if((float)$data['frozen_amount'] >0){
							if($data['frozen_amount'] <= $merchant->frozen_amount){
								$updata['price'] = $merchant->price + $data['frozen_amount'];
								$updata['frozen_amount'] = $merchant->frozen_amount - $data['frozen_amount'];
								$status = DB::table('member')->where('Id',$data['Id'])->update($updata);
								if($status){
									//添加码商余额明细
									$amount_change['type'] = 2;
									$amount_change['member_id'] = $data['Id'];
									$amount_change['amount'] = $data['frozen_amount'];
									$amount_change['member_price'] = $updata['price'];
									$amount_change['time'] = time();
									DB::table('member_amount_change')->insert($amount_change);
									//更新码池
									$Order_Redis = new Order_Redis;
									$admin_site = DB::table('admin_site')->first();
									//清除此码商码池
			                        $redis_data['member_id'] = $data['Id'];
			                        /****删除支付宝二维码****/
			                        $Order_Redis->delete($admin_site->payment_type,'alipay',1,$redis_data);
			                        /****删除支付宝H5二维码****/
			                        $Order_Redis->delete($admin_site->payment_type,'aliwap',1,$redis_data);
			                        /****删除微信二维码****/
			                        $Order_Redis->delete($admin_site->payment_type,'wechat',1,$redis_data);
			                        /****删除银联二维码****/
			                        $Order_Redis->delete($admin_site->payment_type,'unionpay',1,$redis_data);
			                        /****删除支付宝二维码****/
			                        $Order_Redis->delete($admin_site->payment_type,'alipay',2,$redis_data);
			                        /****删除支付宝H5二维码****/
			                        $Order_Redis->delete($admin_site->payment_type,'aliwap',2,$redis_data);
			                        /****删除微信二维码****/
			                        $Order_Redis->delete($admin_site->payment_type,'wechat',2,$redis_data);
			                        /****删除银联二维码****/
			                        $Order_Redis->delete($admin_site->payment_type,'unionpay',2,$redis_data);
									//再次添加此码商码池
									$order_redis_die_list = DiepollingpaymentModel::where(array('member_id'=>$redis_data['member_id'],'gateway_state'=>1))->whereHas('user',function($query){
							    		$query->where('status','=',1);
							    		$query->where('loop','=',1);
							    	})->whereHas('merchant',function($query){
							    		$query->where('price','>',1);
							    		$query->where('frozen_amount','>=',0);
							    	})->with(['user','payment','merchant'])->get();
							    	//活码
							    	$order_redis_live_list = LivepollingpaymentModel::where(array('member_id'=>$redis_data['member_id'],'gateway_state'=>1))->whereHas('user',function($query){
							    		$query->where('status','=',1);
							    		$query->where('loop','=',1);
							    	})->whereHas('merchant',function($query){
							    		$query->where('price','>',1);
							    		$query->where('frozen_amount','>=',0);
							    	})->with(['user','payment','merchant'])->get();
							    	if($order_redis_die_list->isNotEmpty()){
							    		$order_redis_die_list = $order_redis_die_list->toarray();
							    		 if($admin_site->payment_type = 1){
							    		 	foreach ($order_redis_die_list as $v){
								    			$v = (array)$v;
		                                        if(stristr($v['payment']['paytype'],'alipay') !== false){
		                                            //添加顺序列表
		                                            Redis::rpush('sort_alipay_die',json_encode($v));
		                                        }
		                                        if(stristr($v['payment']['paytype'],'aliwap') !== false){
		                                            //添加顺序列表
		                                            Redis::rpush('sort_aliwap_die',json_encode($v));
		                                        }
		                                        if(stristr($v['payment']['paytype'],'wechat') !== false){
		                                            //添加顺序列表
		                                            Redis::rpush('sort_wechat_die',json_encode($v));
		                                        }
		                                        if(stristr($v['payment']['paytype'],'unionpay') !== false){
		                                            //添加顺序列表
		                                            Redis::rpush('sort_unionpay_die',json_encode($v));
		                                        }
								    		}
							    		 }else{
							    		 	foreach ($order_redis_die_list as $v){
							    		 		$v = (array)$v;
							    		 		if(stristr($v['payment']['paytype'],'alipay') !== false){
		                                            //添加随机列表
		                                            Redis::sadd('random_alipay_die',json_encode($v));
		                                        }
		                                        if(stristr($v['payment']['paytype'],'aliwap') !== false){
		                                            //添加随机列表
		                                            Redis::sadd('random_aliwap_die',json_encode($v));
		                                        }
		                                        if(stristr($v['payment']['paytype'],'wechat') !== false){
		                                            //添加随机列表
		                                            Redis::sadd('random_wechat_die',json_encode($v));
		                                        }
		                                        if(stristr($v['payment']['paytype'],'unionpay') !== false){
		                                            //添加随机列表
		                                            Redis::sadd('random_unionpay_die',json_encode($v));
		                                        }
							    		 	}
							    		 }
							    	}
							    	if($order_redis_live_list->isNotEmpty()){
							    		$order_redis_live_list = $order_redis_live_list->toarray();
							    		if($admin_site->payment_type = 1){
							    		 	foreach ($order_redis_live_list as $v){
								    			$v = (array)$v;
		                                        if(stristr($v['payment']['paytype'],'alipay') !== false){
		                                            //添加顺序列表
		                                            Redis::rpush('sort_alipay_live',json_encode($v));
		                                        }
		                                        if(stristr($v['payment']['paytype'],'aliwap') !== false){
		                                            //添加顺序列表
		                                            Redis::rpush('sort_aliwap_live',json_encode($v));
		                                        }
		                                        if(stristr($v['payment']['paytype'],'wechat') !== false){
		                                            //添加顺序列表
		                                            Redis::rpush('sort_wechat_live',json_encode($v));
		                                        }
		                                        if(stristr($v['payment']['paytype'],'unionpay') !== false){
		                                            //添加顺序列表
		                                            Redis::rpush('sort_unionpay_live',json_encode($v));
		                                        }
								    		}
							    		 }else{
							    		 	foreach ($order_redis_live_list as $v){
							    		 		$v = (array)$v;
							    		 		if(stristr($v['payment']['paytype'],'alipay') !== false){
		                                            //添加随机列表
		                                            Redis::sadd('random_alipay_live',json_encode($v));
		                                        }
		                                        if(stristr($v['payment']['paytype'],'aliwap') !== false){
		                                            //添加随机列表
		                                            Redis::sadd('random_aliwap_live',json_encode($v));
		                                        }
		                                        if(stristr($v['payment']['paytype'],'wechat') !== false){
		                                            //添加随机列表
		                                            Redis::sadd('random_wechat_live',json_encode($v));
		                                        }
		                                        if(stristr($v['payment']['paytype'],'unionpay') !== false){
		                                            //添加随机列表
		                                            Redis::sadd('random_unionpay_live',json_encode($v));
		                                        }
							    		 	}
							    		 }
							    	}

									$json['status'] = "ok";
									$json['msg'] = "释放成功,已转入可用余额";
								}else{
									$json['status'] = "error";
									$json['msg'] = "释放失败,出现错误";
								}
							}else{
								$json['status'] = "error";
								$json['msg'] = "释放冻结金额不能大于当前所剩冻结金额";
							}
						}else{
							$json['status'] = "error";
							$json['msg'] = "释放冻结金额不能为0";
						}
					}else{
						$json['status'] = "error";
						$json['msg'] = "释放冻结金额不可为空";
					}
				}else{
					$json['status'] = "error";
					$json['msg'] = "提交参数错误";
				}
			}else if($arr->input('action') == 'del'){
				$data = $arr->input('form');
				if(is_array($data)){
					foreach($data as $k => $v){
						$v = (array)$v;
						//清除Redis码池
						$admin_site = DB::table('admin_site')->first();
						$Order_Redis = new Order_Redis;
                        $redis_data['member_id']= $v['Id'];
                        /****删除支付宝二维码****/
                        $Order_Redis->delete($admin_site->payment_type,'alipay',1,$redis_data);
                        /****删除支付宝H5二维码****/
                        $Order_Redis->delete($admin_site->payment_type,'aliwap',1,$redis_data);
                        /****删除微信二维码****/
                        $Order_Redis->delete($admin_site->payment_type,'wechat',1,$redis_data);
                        /****删除银联二维码****/
                        $Order_Redis->delete($admin_site->payment_type,'unionpay',1,$redis_data);
                        /****删除支付宝二维码****/
                        $Order_Redis->delete($admin_site->payment_type,'alipay',2,$redis_data);
                        /****删除支付宝H5二维码****/
                        $Order_Redis->delete($admin_site->payment_type,'aliwap',2,$redis_data);
                        /****删除微信二维码****/
                        $Order_Redis->delete($admin_site->payment_type,'wechat',2,$redis_data);
                        /****删除银联二维码****/
                        $Order_Redis->delete($admin_site->payment_type,'unionpay',2,$redis_data);
						if($k < 1){
							//查询当前码商是否存在资金明细
							if(DB::table('member_amount_change')->where('member_id',$v['Id'])->first()){
								$amount[] = ['member_id','=',$v['Id']];
							}
							//查询当前码商是否存在固码通道
							if(DB::table('member_diepolling_payment')->where('member_id',$v['Id'])->first()){
								$diepayment[] = ['member_id','=',$v['Id']];
							}
							//查询当前码商是否存在活码通道
							if(DB::table('member_livepolling_payment')->where('member_id',$v['Id'])->first()){
								$livepayment[] = ['member_id','=',$v['Id']];
							}
							//查询当前码商是否存在登录日志
							if(DB::table('member_log')->where('member_id',$v['Id'])->first()){
								$loginlog[] = ['member_id','=',$v['Id']];
							}
							//查询当前码商是否存在订单记录
							if(DB::table('order')->where('member_id',$v['Id'])->first()){
								$order[] = ['member_id','=',$v['Id']];
							}
							//查询当前码商是否存在充值记录
							if(DB::table('member_pay')->where('member_id',$v['Id'])->first()){
								$paylog[] = ['member_id','=',$v['Id']];
							}
							//查询当前码商是否存在收款账号
							if(DB::table('member_polling')->where('member_id',$v['Id'])->first()){
								$polling[] = ['member_id','=',$v['Id']];
							}
							//查询当前码商是否存在APP支持通道
							if(DB::table('memberpayment')->where('member_id',$v['Id'])->first()){
								$payment[] = ['member_id','=',$v['Id']];
							}
							$deldata[]=['Id','=',$v['Id']];
						}else{
							//查询当前码商是否存在资金明细
							if(DB::table('member_amount_change')->where('member_id',$v['Id'])->first()){
								$amount[] = ['member_id','=',$v['Id'],'or'];
							}
							//查询当前码商是否存在固码通道
							if(DB::table('member_diepolling_payment')->where('member_id',$v['Id'])->first()){
								$diepayment[] = ['member_id','=',$v['Id'],'or'];
							}
							//查询当前码商是否存在活码通道
							if(DB::table('member_livepolling_payment')->where('member_id',$v['Id'])->first()){
								$livepayment[] = ['member_id','=',$v['Id'],'or'];
							}
							//查询当前码商是否存在登录日志
							if(DB::table('member_log')->where('member_id',$v['Id'])->first()){
								$loginlog[] = ['member_id','=',$v['Id'],'or'];
							}
							//查询当前码商是否存在充值记录
							if(DB::table('member_pay')->where('member_id',$v['Id'])->first()){
								$paylog[] = ['member_id','=',$v['Id'],'or'];
							}
							//查询当前码商是否存在订单记录
							if(DB::table('order')->where('member_id',$v['Id'])->first()){
								$order[] = ['member_id','=',$v['Id'],'or'];
							}
							//查询当前码商是否存在收款账号
							if(DB::table('member_polling')->where('member_id',$v['Id'])->first()){
								$polling[] = ['member_id','=',$v['Id'],'or'];
							}
							//查询当前码商是否存在APP支持通道
							if(DB::table('memberpayment')->where('member_id',$v['Id'])->first()){
								$payment[] = ['member_id','=',$v['Id'],'or'];
							}
							$deldata[]=['Id','=',$v['Id'],'or'];
						}
					}
					//先删除各种数据
					if(isset($amount)){
						DB::table('member_amount_change')->where($amount)->delete();
					}
					if(isset($diepayment)){
						DB::table('member_diepolling_payment')->where($diepayment)->delete();
					}
					if(isset($livepayment)){
						DB::table('member_livepolling_payment')->where($livepayment)->delete();
					}
					if(isset($loginlog)){
						DB::table('member_log')->where($loginlog)->delete();
					}
					if(isset($paylog)){
						DB::table('member_pay')->where($paylog)->delete();
					}
					if(isset($order)){
						DB::table('order')->where($order)->delete();
					}
					if(isset($polling)){
						DB::table('member_polling')->where($polling)->delete();
					}
					if(isset($payment)){
						DB::table('memberpayment')->where($payment)->delete();
					}

					$num = DB::table('member')->where($deldata)->delete();
					if($num == 0){
						$json['status'] = "error";
						$json['msg'] = "删除失败,出现错误";
					}else{
						$json['status'] = "ok";
						$json['msg'] = "删除成功,共删除{$num}条";
					}
				}else{
					$json['status']="error";
					$json['msg']="提交出现错误,请刷新重试";
				}
			}else if($arr->input('action') == 'login'){
				$data = $arr->input('form');
				//查询当前码商是否存在
				$merchant = DB::table('member')->where('Id',$data['Id'])->first();
				if($merchant){
					//设置ssession
					session()->put('merchant',(array)$merchant);
					$json['status'] = "ok";
					$json['url'] = 'http://'.config('route.domain.merchant');
					$json['msg'] = "验证成功";
				}else{
					$json['status']="error";
					$json['msg']="当前码商不存在";
				}
			}else{
				$json['status']="error";
				$json['msg']="不安全的提交方式";
			}
			return $json;
		}
		return view('admin/merchantlist');
	}

	/****后台码商登录记录****/
	public function merchant_loginlog(Request $arr){
		if($arr->isMethod('post')){
			if($arr->has('page')){
				  $data=$arr->all();
				if($arr->filled('member_id') && $arr->input('member_id')!= '-1' ){
					$map['member_id']=$arr->input('member_id');
				}else{
					$map[]=['time','!=',null];
				}

				if($arr->filled('time') && is_array($arr->input('time'))){
					$time=$arr->input('time');
					if(!empty($time[0]) && !empty($time[1])){
						$map[]=['time','>=',strtotime($time[0])];
		       	  		$map[]=['time','<',strtotime($time[1])+86400];
					}
				}
				$listpage=DB::table('member_log')->where($map)->orderBy('id','desc')->paginate(15)->toarray();
				if($listpage['total'] >= 1){
	       	  		$data=$listpage['data'];
	       	  		foreach ($data as $k => $v) {
	       	  			$v=(array)$v;
	       	  			$v['time']=date('Y-m-d H:i:s',$v['time']);
	       	  			$json['data']['list'][]=$v;
	       	  		}
	       	  	}else{
	       	  		$json['data']['list']=[];
	       	  	}
	       	  	$json['current_page']=$listpage['current_page'];
			   	$json['total']=$listpage['total'];
			   	$json['status']="ok";
			}else if($arr->input('action') == 'del'){
				$data = $arr->input('form');
				if(is_array($data)){
					foreach($data as $k => $v){
						$v = (array)$v;
						if($k < 1){
							$deldata[]=['Id','=',$v['Id']];
						}else{
							$deldata[]=['Id','=',$v['Id'],'or'];
						}
					}
					$num = DB::table('member_log')->where($deldata)->delete();
					if($num == 0){
						$json['status'] = "error";
						$json['msg'] = "删除失败,出现错误";
					}else{
						$json['status'] = "ok";
						$json['msg'] = "删除成功,共删除{$num}条";
					}
				}else{
					$json['status']="error";
					$json['msg']="提交出现错误,请刷新重试";
				}
			}else{
				$json['status']="error";
				$json['msg']="不安全的提交方式";
			}
			return $json;
		}

		return view('admin/merchant_loginlog');
	}
	/****后台码商加款记录****/
	public function merchant_amount_change(Request $arr){
		if($arr->isMethod('post')){
			if($arr->has('page')){
				  $data=$arr->all();
				  $map[]=['type','!=',1];
				if($arr->filled('member_id') && $arr->input('member_id')!= '-1' ){
					$map['member_id']=$arr->input('member_id');
				}

				if($arr->filled('time') && is_array($arr->input('time'))){
					$time=$arr->input('time');
					if(!empty($time[0]) && !empty($time[1])){
						$map[]=['time','>=',strtotime($time[0])];
		       	  		$map[]=['time','<',strtotime($time[1])+86400];
					}
				}
				$listpage=DB::table('member_amount_change')->where($map)->orderBy('id','desc')->paginate(15)->toarray();
				if($listpage['total'] >= 1){
	       	  		$data=$listpage['data'];
	       	  		foreach ($data as $k => $v) {
	       	  			$v=(array)$v;
	       	  			if($v['type'] == 2){
	       	  				$v['type'] = "平台充值";
	       	  				$v['amount']= "+".$v['amount'];
	       	  			}else if($v['type'] == 3){
	       	  				$v['type'] = "平台释放冻结金额";
	       	  				$v['amount']= "-".$v['amount'];
	       	  			}else if($v['type'] == 4){
	       	  				$v['type'] = "平台扣款";
	       	  				$v['amount']= "-".$v['amount'];
	       	  			}
	       	  			$v['time']=date('Y-m-d H:i:s',$v['time']);
	       	  			$json['data']['list'][]=$v;
	       	  		}
	       	  	}else{
	       	  		$json['data']['list']=[];
	       	  	}
	       	  	$json['current_page']=$listpage['current_page'];
			   	$json['total']=$listpage['total'];
			   	$json['status']="ok";
			}else if($arr->input('action') == 'del'){
				$data = $arr->input('form');
				if(is_array($data)){
					foreach($data as $k => $v){
						$v = (array)$v;
						if($k < 1){
							$deldata[]=['Id','=',$v['Id']];
						}else{
							$deldata[]=['Id','=',$v['Id'],'or'];
						}
					}
					$num = DB::table('member_amount_change')->where($deldata)->delete();
					if($num == 0){
						$json['status'] = "error";
						$json['msg'] = "删除失败,出现错误";
					}else{
						$json['status'] = "ok";
						$json['msg'] = "删除成功,共删除{$num}条";
					}
				}else{
					$json['status']="error";
					$json['msg']="提交出现错误,请刷新重试";
				}
			}else{
				$json['status']="error";
				$json['msg']="不安全的提交方式";
			}
			return $json;
		}

		return view('admin/merchant_amount_change');
	}
	/****后台码商APP通道控制****/
	public function merchant_payment(Request $arr){
		if($arr->isMethod('post')){
			if($arr->has('page')){
				if($arr->filled('member_id') && $arr->input('member_id')!= '-1' ){
					$map['member_id']=$arr->input('member_id');
				}else{
					$map[]=['status','!=',null];
				}
				if($arr->filled('passageway_type') && $arr->input('passageway_type')!= '-1' ){
					$map['passageway_type']=$arr->input('passageway_type');
				}
				if($arr->filled('passageway_id') && $arr->input('passageway_id')!= '-1' ){
					$map['passageway_id']=$arr->input('passageway_id');
				}

				$listpage=MemberpaymentModel::where($map)->with('diepay','livepay')->orderBy('id','desc')->paginate(15)->toarray();
				if($listpage['total'] >= 1){
	       	  		$data=$listpage['data'];
	       	  		foreach ($data as $k => $v) {
	       	  			$v=(array)$v;
	       	  			if(!empty($v['diepay'])){
	       	  				$v['passageway_name']=$v['diepay']['name'];
	       	  			}else{
	       	  				$v['passageway_name']=$v['livepay']['name'];
	       	  			}
	       	  			$json['data']['list'][]=$v;
	       	  		}
	       	  	}else{
	       	  		$json['data']['list']=[];
	       	  	}
	       	  	$json['current_page']=$listpage['current_page'];
			   	$json['total']=$listpage['total'];
			   	$json['status']="ok";
			}else if($arr->input('action') == 'add'){
				$postdata = $arr->input('form');
				try {

				if(!empty($postdata['passageway_id']) && !empty($postdata['passageway_type'])){
					//查询码商是否存在
					if(!empty($postdata['member_id'])){
						if(DB::table('member')->where('Id',$postdata['member_id'])->first()){
							if($postdata['passageway_type'] != '-1'){
								if($postdata['passageway_id'] == '-1' || in_array("-1",$postdata['passageway_id'])){
									if($postdata['passageway_type'] == 1){
										$payment=DB::table('die_passageway')->where('status',1)->select('Id')->get()->toarray();
									}else{
										$payment=DB::table('live_passageway')->where('status',1)->select('Id')->get()->toarray();
									}
									foreach ($payment as $k => $v) {
										$v = (array)$v;
										$v['passageway_id'] =$v['Id'];
					                    $v['passageway_type'] = $postdata['passageway_type'];
					                    $v['member_id'] = $postdata['member_id'];
					                    unset($v['Id']);
					                    //查询该码商是否存在该通道
					                    if(!DB::table('memberpayment')->where(array(
					                    	'member_id'=>$postdata['member_id'],
					                    	'passageway_type'=>$postdata['passageway_type'],
					                    	'passageway_id'=>$v['passageway_id']))->first()){
					                    	$addpayment[] = $v;
					                    }

									}
								}else{
									//查询该码商是否存在该通道
									foreach ($postdata['passageway_id'] as $v) {
										if(!DB::table('memberpayment')->where(array(
				                    	'member_id'=>$postdata['member_id'],
				                    	'passageway_type'=>$postdata['passageway_type'],
				                    	'passageway_id'=>$v))->first()){
											$addpayment[] = array('member_id'=>$postdata['member_id'],'passageway_id'=>$v,'passageway_type'=>$postdata['passageway_type']);
				                    	}
									}
								}
								if(isset($addpayment)){
									$payment_status = DB::table('memberpayment')->insert($addpayment);
									if($payment_status){
										$json['status']="ok";
										$json['msg']="APP通道添加成功";
									}else{
										$json['status']="error";
										$json['msg']="APP通道添加失败";
									}
								}else{
									$json['status']="error";
									$json['msg']="当前码商无可添加通道哦";
								}
							}else{
								$json['status'] = "error";
								$json['msg'] = "请先选择通道类型";
							}
						}else{
							$json['status'] = "error";
							$json['msg'] = "不存在当前码商";
						}
					}else{
						$json['status'] = "error";
						$json['msg'] = "请填写码商ID编号";
					}
				}
				} catch (\Exception $e) {
					$json['status'] = "error";
					$json['msg'] = $e->getMessage();
				}
			}else if($arr->input('action') == 'del'){
				$data = $arr->input('form');
				if(is_array($data)){
					foreach($data as $k => $v){
						$v = (array)$v;
						//清除Redis码池
						$admin_site = DB::table('admin_site')->first();
						$Order_Redis = new Order_Redis;
                        $redis_data['member_id']= $v['member_id'];
                        $redis_data['passageway_id'] = $v['passageway_id'];
                        /****删除支付宝二维码****/
                        $Order_Redis->delete($admin_site->payment_type,'alipay',1,$redis_data);
                        /****删除支付宝H5二维码****/
                        $Order_Redis->delete($admin_site->payment_type,'aliwap',1,$redis_data);
                        /****删除微信二维码****/
                        $Order_Redis->delete($admin_site->payment_type,'wechat',1,$redis_data);
                        /****删除银联二维码****/
                        $Order_Redis->delete($admin_site->payment_type,'unionpay',1,$redis_data);
                        /****删除支付宝二维码****/
                        $Order_Redis->delete($admin_site->payment_type,'alipay',2,$redis_data);
                        /****删除支付宝H5二维码****/
                        $Order_Redis->delete($admin_site->payment_type,'aliwap',2,$redis_data);
                        /****删除微信二维码****/
                        $Order_Redis->delete($admin_site->payment_type,'wechat',2,$redis_data);
                        /****删除银联二维码****/
                        $Order_Redis->delete($admin_site->payment_type,'unionpay',2,$redis_data);
						if($k < 1){
							//查询是否存在添加过此通道的收款账户
							if($v['passageway_type'] == 1){
								if(DB::table('member_diepolling_payment')->where(array(
									'member_id'=>$v['member_id'],
									'passageway_id'=>$v['passageway_id']))->first()){
									$diepayment[] = ['member_id','=',$v['member_id']];
									$diepayment[] = ['passageway_id','=',$v['passageway_id']];
								}
							}else{
								if(DB::table('member_livepolling_payment')->where(array(
									'member_id'=>$v['member_id'],
									'passageway_id'=>$v['passageway_id']))->first()){
									$livepayment[] = ['member_id','=',$v['member_id']];
									$livepayment[] = ['passageway_id','=',$v['passageway_id']];
								}
							}
							$deldata[]=['Id','=',$v['Id']];
						}else{
							//查询是否存在添加过此通道的收款账户
							if($v['passageway_type'] == 1){
								if(DB::table('member_diepolling_payment')->where(array(
									'member_id'=>$v['member_id'],
									'passageway_id'=>$v['passageway_id']))->first()){
									$diepayment[] = ['member_id','=',$v['member_id'],'or'];
									$diepayment[] = ['passageway_id','=',$v['passageway_id'],'or'];
								}
							}else{
								if(DB::table('member_livepolling_payment')->where(array(
									'member_id'=>$v['member_id'],
									'passageway_id'=>$v['passageway_id']))->first()){
									$livepayment[] = ['member_id','=',$v['member_id'],'or'];
									$livepayment[] = ['passageway_id','=',$v['passageway_id'],'or'];
								}
							}
							$deldata[]=['Id','=',$v['Id'],'or'];
						}
					}
					if(isset($diepayment)){
						DB::table('member_diepolling_payment')->where($diepayment)->delete();
					}
					if(isset($livepayment)){
						DB::table('member_livepolling_payment')->where($livepayment)->delete();
					}
					$num = DB::table('memberpayment')->where($deldata)->delete();
					if($num == 0){
						$json['status'] = "error";
						$json['msg'] = "删除失败,出现错误";
					}else{
						$json['status'] = "ok";
						$json['msg'] = "删除成功,共删除{$num}条";
					}
				}else{
					$json['status']="error";
					$json['msg']="提交出现错误,请刷新重试";
				}
			}else{
				$json['status']="error";
				$json['msg']="不安全的提交方式";
			}
			return $json;
		}
		return view('admin/merchant_payment');
	}

	/***后台码商通道账户****/
	public function merchant_polling(Request $arr){
		if($arr->isMethod('post')){
			if($arr->has('page')){

				if($arr->filled('type') && $arr->input('type')!= '-1' ){
					$map['type']=$arr->input('type');
				}
				if($arr->filled('status') && $arr->input('status')!= '-1' ){
					$map['status']=$arr->input('status');
				}else{
					$map[]=['status','!=',null];
				}
				if($arr->filled('field') && $arr->input('field')!= '-1' && $arr->filled('value') && !empty($arr->input('value'))){
					$map[]=[$arr->input('field'),'like','%'.$arr->input('value').'%'];
				}

				$listpage=DB::table('member_polling')->where($map)->orderBy('id','desc')->paginate(15)->toarray();
				//查询总数量
				$json['data']['toptext']['count'] = DB::table('member_polling')->where($map)->count();
				//查询在线数量
				$map['status'] = 1;
				$json['data']['toptext']['on_count'] = DB::table('member_polling')->where($map)->count();
				//查询离线数量
				$map['status'] = 2;
				$json['data']['toptext']['off_count'] = DB::table('member_polling')->where($map)->count();
				if($listpage['total'] >= 1){
	       	  		$data = $listpage['data'];
	       	  		foreach ($data as $k => $v) {
	       	  			$v=(array)$v;
	       	  			if(empty($v['ip'])){
	       	  				$v['ip'] = "无";
	       	  			}
	       	  			if(empty($v['address'])){
	       	  				$v['address'] = "无";
	       	  			}
	       	  			$v['login_time'] = !empty($v['login_time']) ? date('Y-m-d H:i',$v['login_time']) : "无";
	       	  			$json['data']['list'][]=$v;
	       	  		}
	       	  	}else{
	       	  		$json['data']['list']=[];
	       	  	}
	       	  	$json['current_page']=$listpage['current_page'];
			   	$json['total']=$listpage['total'];
			   	$json['status']="ok";
			}else if($arr->input('action') == 'loseapp'){
				$data = $arr->input('form');
				if(is_array($data)){
					//清除Redis码池
					$admin_site = DB::table('admin_site')->first();
					$Order_Redis = new Order_Redis;
					foreach ($data as $k =>$v) {
						$v = (array)$v;
						if(!empty($v['token'])){
	                        $redis_data['polling_id']= $v['Id'];
	                        /****删除支付宝二维码****/
	                        $Order_Redis->delete($admin_site->payment_type,'alipay',$v['type'],$redis_data);
	                        /****删除支付宝H5二维码****/
	                        $Order_Redis->delete($admin_site->payment_type,'aliwap',$v['type'],$redis_data);
	                        /****删除微信二维码****/
	                        $Order_Redis->delete($admin_site->payment_type,'wechat',$v['type'],$redis_data);
	                        /****删除银联二维码****/
	                        $Order_Redis->delete($admin_site->payment_type,'unionpay',$v['type'],$redis_data);
							if($k < 1){
								$upwhere[]=['Id','=',$v['Id']];
							}else{
								$upwhere[]=['Id','=',$v['Id'],'or'];
							}
							//推送掉线消息
	                        Gateway::sendToClient($v['token'], json_encode(array("type"=>"loseuser","msg"=>"当前账户已在别处登录或被强制下线")));
						}
					}
					if(isset($upwhere)){
						$num = DB::table('member_polling')->where($upwhere)->update(array('token'=>null,'status'=>2));
						if($num == 0){
							$json['status'] = "error";
							$json['msg'] = "当前无用户在线";
						}else{
							$json['status'] = "ok";
							$json['msg'] = "成功踢下线用户{$num}个";
						}
					}else{
						$json['status'] = "error";
						$json['msg'] = "当前无用户在线";
					}
				}else{
					$json['status'] = "error";
					$json['msg'] = "请提交正确的方式";
				}
			}else if($arr->input('action') == 'del'){
				$data = $arr->input('form');
				if(is_array($data)){
					foreach ($data as $k =>$v) {
						$v = (array)$v;
						//清除Redis码池
						$admin_site = DB::table('admin_site')->first();
						$Order_Redis = new Order_Redis;
                        $redis_data['polling_id']= $v['Id'];
                        /****删除支付宝二维码****/
                        $Order_Redis->delete($admin_site->payment_type,'alipay',$v['type'],$redis_data);
                        /****删除支付宝H5二维码****/
                        $Order_Redis->delete($admin_site->payment_type,'aliwap',$v['type'],$redis_data);
                        /****删除微信二维码****/
                        $Order_Redis->delete($admin_site->payment_type,'wechat',$v['type'],$redis_data);
                        /****删除银联二维码****/
                        $Order_Redis->delete($admin_site->payment_type,'unionpay',$v['type'],$redis_data);
						if($k < 1){
							if($v['type'] == 1){
								//查询当前账户是否存在固码通道
								if(DB::table('member_diepolling_payment')->where('polling_id',$v['Id'])->first()){
									$diepayment[] = ['polling_id','=',$v['Id']];
								}
							}else{
								//查询当前账户是否存在活码通道
								if(DB::table('member_livepolling_payment')->where('polling_id',$v['Id'])->first()){
									$livepayment[] = ['polling_id','=',$v['Id']];
								}
							}
							$deldata[]=['Id','=',$v['Id']];
						}else{
							if($v['type'] == 1){
								//查询当前账户是否存在固码通道
								if(DB::table('member_diepolling_payment')->where('polling_id',$v['Id'])->first()){
									$diepayment[] = ['polling_id','=',$v['Id'],'or'];
								}
							}else{
								//查询当前账户是否存在活码通道
								if(DB::table('member_livepolling_payment')->where('polling_id',$v['Id'])->first()){
									$livepayment[] = ['polling_id','=',$v['Id'],'or'];
								}
							}
							$deldata[]=['Id','=',$v['Id'],'or'];
						}
					}
					//先删除各类通道
					if(isset($diepayment)){
						DB::table('member_diepolling_payment')->where($diepayment)->delete();
					}
					if(isset($livepayment)){
						DB::table('member_diepolling_payment')->where($livepayment)->delete();
					}
					$num = DB::table('member_polling')->where($deldata)->delete();
					if($num == 0){
						$json['status'] = "error";
						$json['msg'] = "删除失败,出现错误";
					}else{
						$json['status'] = "ok";
						$json['msg'] = "删除成功,共删除{$num}条";
					}
				}else{
					$json['status'] = "error";
					$json['msg'] = "请提交正确的方式";
				}
			}else if($arr->input('action') == 'add'){
				$data = $arr->input('form');
				if(!empty($data['remarks'])){
					if(!empty($data['member_id'])){
						if(checkpass($data['password'])){
							//查询码商是否存在
							$merchantinfo = DB::table('member')->where('Id',$data['member_id'])->first();
							if($merchantinfo){
								//查询该码商有几个固码账户
								$pollingnum = DB::table('member_polling')->where(array(
									'member_id'=>$merchantinfo->Id,
									'type'=>$data['type']
								))->count();
								if($data['type'] == 1){
									if($merchantinfo->diepolling_num !=0 && $pollingnum >= $merchantinfo->diepolling_num){
										$json['status'] ="error";
										$json['msg'] = "该码商限制添加{$pollingnum}个固码账户";
									}
								}else{
									if($merchantinfo->livepolling_num !=0 && $pollingnum >= $merchantinfo->livepolling_num){
										$json['status'] ="error";
										$json['msg'] = "该码商限制添加{$pollingnum}个活码账户";
									}
								}
								if(!isset($json)){
									$max_user =DB::table('member_polling')->max('username');
									if(!empty($max_user)){
										$addarr['username'] = 'YM'.(str_replace("YM","",$max_user)+1);
									}else{
										$addarr['username'] = 'YM10000';
									}
									$addarr['member_id'] = $merchantinfo->Id;
							        $addarr['type'] = $data['type'];
							        $addarr['password'] = xpass($data['password']);
							        $addarr['remarks'] = $data['remarks'];
							        $addarr['time'] = time();
							        $status = DB::table('member_polling')->insert($addarr);
							        if($status){
							        	$json['status'] = "ok";
										$json['msg'] = "添加账户成功";
							        }else{
							        	$json['status'] = "error";
										$json['msg'] = "添加账户失败";
							        }
								}
							}else{
								$json['status'] = "error";
								$json['msg'] = "不存在当前码商";
							}
						}else{
							$json['status'] = "error";
							$json['msg'] = "请输入6~20位密码";
						}
					}else{
						$json['status'] = "error";
						$json['msg'] = "请输入码商ID编号";
					}
				}else{
					$json['status'] = "error";
					$json['msg'] = "请输入账号备注";
				}
			}else if($arr->input('action') == 'edit'){
				$data = $arr->input('form');
				if(!empty($data['remarks'])){
					if(!empty($data['password'])){
						if(checkpass($data['password'])){
							$updata['password'] = xpass($data['password']);
						}
					}
					$updata['remarks'] = $data['remarks'];
					$status = DB::table('member_polling')->where('Id',$data['Id'])->update($updata);
					if($status){
						$json['status'] = "ok";
						$json['msg'] = "修改成功";
					}else{
						$json['status'] = "error";
						$json['msg'] = "当前无更改,修改失败";
					}
				}else{
					$json['status'] = "error";
					$json['msg'] = "请填写账号备注";
				}
			}else{
				$json['status'] = "error";
				$json['msg'] = "不安全的提交方式";
			}
			return $json;
		}
		return view('admin/merchant_polling');
	}

	/****后台码商固码通道****/
	public function merchant_diecode(Request $arr){
		if($arr->isMethod('post')){

			if($arr->has('page')){
				if($arr->filled('gateway_state') && $arr->input('gateway_state')!= '-1' ){
					$map['gateway_state']=$arr->input('gateway_state');
				}else{
					$map[]=['gateway_state','!=',null];
				}

				if($arr->filled('field') && $arr->input('field')!= '-1' && $arr->filled('value') && !empty($arr->input('value'))){
					if($arr->input('field') == 'polling_user'){
						//查询该账号ID
						$pollinginfo = DB::table('member_polling')->where('username',$arr->input('value'))->first();
						if($pollinginfo){
							$map[] = ['polling_id','=',$pollinginfo->Id];
						}else{
							$map['polling_id'] = 0;
						}
					}else{
						$map[]=[$arr->input('field'),'like','%'.$arr->input('value').'%'];
					}
				}
				if($arr->has('region_id') && !is_null($arr->input('region_id')) && $arr->input('region_id')!=  999999){
					$map['region_id']=$arr->input('region_id');
				}
				if($arr->has('city_id') && !is_null($arr->input('city_id')) && $arr->input('city_id')!= 0){
					$map['city_id']=$arr->input('city_id');
				}
				$listpage=DiepollingpaymentModel::where($map)->with('payment','user')->orderBy('id','desc')->paginate(15)->toarray();
				//查询总数量
				$json['data']['toptext']['count'] = DiepollingpaymentModel::where($map)->count();
				//查询Redis码池数量
				$admin_site = DB::table('admin_site')->first();
				if($admin_site->payment_type ==1){
					$alipay = Redis::exists('sort_alipay_die') ? Redis::llen('sort_alipay_die') : 0;
					$aliwap = Redis::exists('sort_aliwap_die') ? Redis::llen('sort_aliwap_die') : 0;
					$wechat = Redis::exists('sort_wechat_die') ? Redis::llen('sort_wechat_die') : 0;
					$unionpay = Redis::exists('sort_unionpay_die') ? Redis::llen('sort_unionpay_die') : 0;
				}else{
					$alipay = Redis::exists('random_alipay_die') ? Redis::llen('random_alipay_die') : 0;
					$aliwap = Redis::exists('random_aliwap_die') ? Redis::llen('random_aliwap_die') : 0;
					$wechat = Redis::exists('random_wechat_die') ? Redis::llen('random_wechat_die') : 0;
					$unionpay = Redis::exists('random_unionpay_die') ? Redis::llen('random_unionpay_die') : 0;
				}
				$json['data']['toptext']['on_count'] = $alipay+$aliwap+$wechat+$unionpay;
				$json['data']['toptext']['off_count'] =0;
				if($listpage['total'] >= 1){
	       	  		$data = $listpage['data'];
	       	  		foreach ($data as $k => $v) {
	       	  			$v=(array)$v;
	       	  			if($v['passageway_id']	== 804){
							$v['bankcard']=cut('cardNo=','&bank',$v['qrcode']);
							$v['bankname']=urldecode(cut('bankAccount=','&bankMark',$v['qrcode']));
							$v['cardid']=cut('cardIndex=','&money',$v['qrcode']);
						}
						$map3['status']=2;
						$map3['polling_passageway_key']=$v['key'];
						$map3[]=['sub_time','<',strtotime(date('Y-m-d 00:00:00'))+86400];
						$map3[]=['sub_time','>=',strtotime(date('Y-m-d 00:00:00'))];
						$v['today_amount'] = OrderModel::where($map3)->sum('order_price');
						$v['passageway_name'] = $v['payment']['name'];
						$v['polling_user'] = $v['user']['username'];
	       	  			$json['data']['list'][]=$v;
	       	  		}
	       	  	}else{
	       	  		$json['data']['list']=[];
	       	  	}
	       	  	$json['current_page']=$listpage['current_page'];
			   	$json['total']=$listpage['total'];
			   	$json['status']="ok";
			}else if($arr->input('action') == 'lose' || $arr->input('action')=='open'){
				$data = $arr->input('form');
				if(is_array($data)){
					$admin_site = DB::table('admin_site')->first();
					$order_redis = new Order_Redis;
					foreach ($data as $k =>$v) {
						$v = (array)$v;
						$info = DiepollingpaymentModel::where('Id',$v)->with('user','payment','merchant')->first();
						//清除该通道二维码
                        $order_redis->delete($admin_site->payment_type,'alipay',1,array('key'=>$info->key));
                        $order_redis->delete($admin_site->payment_type,'aliwap',1,array('key'=>$info->key));
                        $order_redis->delete($admin_site->payment_type,'wechat',1,array('key'=>$info->key));
                        $order_redis->delete($admin_site->payment_type,'unionpay',1,array('key'=>$info->key));
						if($info->user->status == 1 && $info->user->loop == 1 && $info->merchant->price > 1 && $info->merchant->frozen_amount >= 0){
							$info->gateway_state = 1;
							if($arr->input('action') == 'open'){
								//添加二维码
								if($admin_site->payment_type == 1){
									if(stristr($info->payment->paytype,'alipay') !== false){
                                        Redis::rpush('sort_alipay_die',json_encode($info));
                                    }
                                    if(stristr($info->payment->paytype,'aliwap') !== false){
                                        Redis::rpush('sort_aliwap_die',json_encode($info));
                                    }
                                    if(stristr($info->payment->paytype,'wechat') !== false){
                                        Redis::rpush('sort_wechat_die',json_encode($info));
                                    }
                                    if(stristr($info->payment->paytype,'unionpay') !== false){
                                        Redis::rpush('sort_unionpay_die',json_encode($info));
                                    }
								}else{
									if(stristr($info->payment->paytype,'alipay') !== false){
                                        Redis::sadd('random_alipay_die',json_encode($info));
                                    }
                                    if(stristr($info->payment->paytype,'aliwap') !== false){
                                        Redis::sadd('random_aliwap_die',json_encode($info));
                                    }
                                    if(stristr($info->payment->paytype,'wechat') !== false){
                                        Redis::sadd('random_wechat_die',json_encode($info));
                                    }
                                    if(stristr($info->payment->paytype,'unionpay') !== false){
                                        Redis::sadd('random_unionpay_die',json_encode($info));
                                    }
								}
							}
						}
						if($k < 1){
							$upwhere[]=['Id','=',$v['Id']];
						}else{
							$upwhere[]=['Id','=',$v['Id'],'or'];
						}
					}
						$updata['gateway_state'] = $arr->input('action') == 'lose' ? 2 : 1;
						$num = DB::table('member_diepolling_payment')->where($upwhere)->update($updata);
						if($num == 0){
							$json['status'] = "error";
							$json['msg'] = $arr->input('action') == 'lose' ? "当前无通道网关开启" : "当前无通道网关关闭";
						}else{
							$json['status'] = "ok";
							$json['msg'] = $arr->input('action') == 'lose' ? "成功关闭网关{$num}个" : "成功开启网关{$num}个";
						}
				}else{
					$json['status'] = "error";
					$json['msg'] = "请提交正确的方式";
				}
			}else if($arr->input('action') == 'del'){
				$data = $arr->input('form');
				$admin_site = DB::table('admin_site')->first();
				$Order_Redis = new Order_Redis;
				if(is_array($data)){
					foreach ($data as $k =>$v) {
						$v = (array)$v;
						//删除通道收款池
						$Order_Redis->delete($admin_site->payment_type,'alipay',1,array('key'=>$v['key']));
                        /****删除支付宝H5二维码****/
                        $Order_Redis->delete($admin_site->payment_type,'aliwap',1,array('key'=>$v['key']));
                        /****删除微信二维码****/
                        $Order_Redis->delete($admin_site->payment_type,'wechat',1,array('key'=>$v['key']));
                        /****删除银联二维码****/
                        $Order_Redis->delete($admin_site->payment_type,'unionpay',1,array('key'=>$v['key']));
						if($k < 1){
							$deldata[]=['Id','=',$v['Id']];
						}else{
							$deldata[]=['Id','=',$v['Id'],'or'];
						}
					}

					$num = DB::table('member_diepolling_payment')->where($deldata)->delete();
					if($num == 0){
						$json['status'] = "error";
						$json['msg'] = "删除失败,出现错误";
					}else{
						$json['status'] = "ok";
						$json['msg'] = "删除成功,共删除{$num}条";
					}
				}else{
					$json['status'] = "error";
					$json['msg'] = "请提交正确的方式";
				}
			}else if($arr->input('action') == 'add'){
				$data = $arr->input('form');
				if(!empty($data['remarks'])){
					if(!empty($data['polling_user'])){
						//查询收款账号是否存在
						$pollinginfo =DB::table('member_polling')->where(array('username'=>$data['polling_user'],'type'=>1))->first();
						if($pollinginfo){
							$adddata['polling_id'] = $pollinginfo->Id;
							$adddata['member_id'] = $pollinginfo->member_id;
							//查询当前码商是否支持添加该通道
							$payment = DB::table('memberpayment')->where(array('member_id'=>$pollinginfo->member_id,'passageway_id'=>$data['passageway_id']))->first();
							if($payment){
								if($data['passageway_id'] != 804){
									//查询二维码是否正确
									if(!checkqrcode($data)){
										$json['status'] = "error";
										$json['msg'] = "当前二维码地址不正确哦";
									}else{
										//查询是否已添加过该通道的二维码
			        					$map[]=['qrcode','like','%'.$data['qrcode'].'%'];
			    						$info=DB::table('member_diepolling_payment')->where($map)->first();
			        					if($info){
			        						$json['status'] = "error";
			        						$json['msg'] = "平台已存在该二维码哦";
			        					}else{
			        						//查询是否已添加过该通道
			        						$map2['passageway_id'] = $data['passageway_id'];
			        						$map2['polling_id'] = $pollinginfo->Id;
			        						$pay = DB::table('member_diepolling_payment')->where($map2)->first();
			        						if($pay){
			        							$json['status'] = "error";
			        							$json['msg'] = "该收款账号已添加过该通道了哦";
			        						}else{
			        							$adddata['qrcode'] = $data['qrcode'];
			        						}
			        					}
									}
								}else{
									//验证添加银行是否支持
		        					$bankreturn=addalicard($data['bankcard']);
		        					if($bankreturn['code'] != 1){
		        						$json['status'] = "error";
		        						$json['msg'] = $bankreturn['msg'];
		        					}else{
			        					//验证CardId是否正确
				        				if(!preg_match("/^[0-9]{19}$/",$data['cardid'])){
				        					$json['status']="error";
				        					$json['msg']="当前支付宝CardId不正确";
				        				}else{
				        					//查询是否已添加过该银行卡生成的二维码
				        					$map[]=['qrcode','like','%'.$data['bankcard'].'%'];
				    						$info=DB::table('member_diepolling_payment')->where($map)->first();
				        					if($info){
				        						$json['status'] = "error";
				        						$json['msg'] = "平台已存在该银行卡哦";
				        					}else{
				        					//拼接二维码
				        					$adddata['qrcode']="alipays://platformapi/startapp?appId=09999988&actionType=toCard&sourceId=bill&cardNoHidden=true&cardChannel=HISTORY_CARD&orderSource=from&cardNo=".$data['bankcard']."&bankAccount=".urlencode($data['bankname'])."&bankMark=".$bankreturn['data']['bank']."&cardIndex=".$data['cardid']."&money=(order_price)&amount=(order_price)";
				        					}
				        				}
			        				}
								}
								if(!isset($json)){
									$adddata['remarks'] = $data['remarks'];
									$adddata['key'] = getpassagewaykey();
									$adddata['region_id'] = $data['region_id'];
									$adddata['city_id'] = $data['city_id'];
									if($adddata['region_id'] == 999999){
										$adddata['region_name']="全国";
									}else{
										$adddata['region_name']=DB::table('region')->where('region_id',$updata['region_id'])->first()->region_name;
									}
									if($adddata['city_id'] ==  0){
										$adddata['city_name'] = "全市";
									}else{
										$adddata['city_name'] = DB::table('region')->where('city_id',$updata['city_id'])->first()->city_name;
									}
									if(!empty($data['today_money'])){
			        					if((float)$data['today_money'] > 200000 || (float)$data['today_money']< 0){
			        						$adddata['today_money']=0;
			        					}else{
			        						$adddata['today_money'] = $data['today_money'];
			        					}
			        				}else{
			        					$adddata['today_money']=0;
			        				}
			        				if(!empty($data['total_money'])){
			        					if((float)$data['total_money'] > 10000000 || (float)$data['total_money']< 0){
			        						$adddata['total_money']=0;
			        					}else{
			        						$adddata['total_money'] = $data['total_money'];
			        					}
			        				}else{
			        					$adddata['total_money']=0;
			        				}
			        				$adddata['passageway_id'] = $data['passageway_id'];
			        				$status = DB::table('member_diepolling_payment')->insert($adddata);
			        				if($status){
			        					$json['status']="ok";
										$json['msg'] = "添加成功";
			        				}else{
			        					$json['status']="error";
										$json['msg'] = "出现错误,添加失败";
			        				}
								}
							}else{
								$json['status']="error";
								$json['msg'] = "当前码商不支持添加该通道,请在APP通道添加";
							}
						}else{
							$json['status']="error";
							$json['msg'] = "当前收款账号不存在";
						}
					}else{
						$json['status']="error";
						$json['msg'] = "请输入APP收款账号";
					}
				}else{
					$json['status'] = "error";
					$json['msg'] = "请输入通道备注";
				}
			}else if($arr->input('action') == 'edit'){
				$data = $arr->input('form');
				if(!empty($data['remarks'])){
					if(!empty($data['Id'])){
						if(!empty($data['key'])){
							$pollinginfo =DB::table('member_polling')->where(array('Id'=>$data['polling_id'],'type'=>1))->first();
							if($pollinginfo){
								//查询当前码商是否支持添加该通道
								$payment = DB::table('memberpayment')->where(array('member_id'=>$pollinginfo->member_id,'passageway_id'=>$data['passageway_id']))->first();
								if($payment){
									$payinfo = DiepollingpaymentModel::where('key',$data['key'])->with('user','payment','merchant')->first();
									if($data['passageway_id'] != 804){
										//查询二维码是否正确
										if(!checkqrcode($data)){
											$json['status'] = "error";
											$json['msg'] = "当前二维码地址不正确哦";
										}else{
											//查询是否已添加过该通道的二维码
				        					$map[]=['qrcode','like','%'.$data['qrcode'].'%'];
				    						$info=DB::table('member_diepolling_payment')->where($map)->first();
				        					if($info){
				        						if(isset($info->key)){
				        							if($data['key'] != $info->key){
					        							$json['status'] = "error";
				        								$json['msg'] = "平台已存在该二维码哦";
					        						}
				        						}
				        					}else{
				        						//查询是否已添加过该通道
				        						$map2['passageway_id'] = $data['passageway_id'];
				        						$map2['polling_id'] = $pollinginfo->Id;
				        						$pay = DB::table('member_diepolling_payment')->where($map2)->first();
				        						if($pay){
				        							$json['status'] = "error";
				        							$json['msg'] = "该收款账号已添加过该通道了哦";
				        						}else{
				        							$updata['qrcode'] = $data['qrcode'];
				        						}
				        					}
										}
									}else{
										//验证添加银行是否支持
			        					$bankreturn=addalicard($data['bankcard']);
			        					if($bankreturn['code'] != 1){
			        						$json['status'] = "error";
			        						$json['msg'] = $bankreturn['msg'];
			        					}else{
				        					//验证CardId是否正确
					        				if(!preg_match("/^[0-9]{19}$/",$data['cardid'])){
					        					$json['status']="error";
					        					$json['msg']="当前支付宝CardId不正确";
					        				}else{
					        					//查询是否已添加过该银行卡生成的二维码
					        					$map[]=['qrcode','like','%'.$data['bankcard'].'%'];
					    						$info=DB::table('member_diepolling_payment')->where($map)->first();
					        					if($info){
					        						if(isset($info->key)){
					        							if($data['key'] != $info->key){
						        							$json['status'] = "error";
						        							$json['msg'] = "平台已存在该银行卡哦";
						        						}
					        						}
					        					}else{
					        					//拼接二维码
					        					$updata['qrcode']="alipays://platformapi/startapp?appId=09999988&actionType=toCard&sourceId=bill&cardNoHidden=true&cardChannel=HISTORY_CARD&orderSource=from&cardNo=".$data['bankcard']."&bankAccount=".urlencode($data['bankname'])."&bankMark=".$bankreturn['data']['bank']."&cardIndex=".$data['cardid']."&money=(order_price)&amount=(order_price)";
					        					}
					        				}
				        				}
									}
									if(!isset($json)){
										$updata['remarks'] = $data['remarks'];
										$updata['region_id'] = $data['region_id'];
										$updata['city_id'] = $data['city_id'];
										if($updata['region_id'] == 999999){
											$updata['region_name']="全国";
										}else{
											$updata['region_name']=DB::table('region')->where('region_id',$updata['region_id'])->first()->region_name;
										}
										if($updata['city_id'] ==  0){
											$updata['city_name'] = "全市";
										}else{
											$updata['city_name'] = DB::table('region')->where('city_id',$updata['city_id'])->first()->city_name;
										}
										if(!empty($data['today_money'])){
				        					if((float)$data['today_money'] > 200000 || (float)$data['today_money']< 0){
				        						$updata['today_money']=0;
				        					}else{
				        						$updata['today_money'] = $data['today_money'];
				        					}
				        				}else{
				        					$adddata['today_money']=0;
				        				}
				        				if(!empty($data['total_money'])){
				        					if((float)$data['total_money'] > 10000000 || (float)$data['total_money']< 0){
				        						$updata['total_money']=0;
				        					}else{
				        						$updata['total_money'] = $data['total_money'];
				        					}
				        				}else{
				        					$updata['total_money']=0;
				        				}
				        				$updata['passageway_id'] = $data['passageway_id'];
				        				$status = DB::table('member_diepolling_payment')->where('key',$data['key'])->update($updata);
				        				if($status){
				        					//查询该二维码新数据
											$payment = DiepollingpaymentModel::where('key',$data['key'])->with('user','payment','merchant')->first();
											//判断平台出码方式
                                            $admin_site=DB::table('admin_site')->first();
                                            //清除该通道二维码
                                            $order_redis = new Order_Redis;
			                                $order_redis->delete($admin_site->payment_type,'alipay',1,array('key'=>$payment->key));
			                                $order_redis->delete($admin_site->payment_type,'aliwap',1,array('key'=>$payment->key));
			                                $order_redis->delete($admin_site->payment_type,'wechat',1,array('key'=>$payment->key));
			                                $order_redis->delete($admin_site->payment_type,'unionpay',1,array('key'=>$payment->key));
											if($payment->user->status == 1 && $payment->user->loop == 1 && $payment->merchant->price >1 && $payment->merchant->frozen_amount >= 0){
	                                            if($admin_site->payment_type == 1){
	                                                if(stristr($payment->payment->paytype,'alipay') !== false){
	                                                    Redis::rpush('sort_alipay_die',json_encode($payment));
	                                                }
	                                                if(stristr($payment->payment->paytype,'aliwap') !== false){
	                                                    Redis::rpush('sort_aliwap_die',json_encode($payment));
	                                                }
	                                                if(stristr($payment->payment->paytype,'wechat') !== false){
	                                                    Redis::rpush('sort_wechat_die',json_encode($payment));
	                                                }
	                                                if(stristr($payment->payment->paytype,'unionpay') !== false){
	                                                    Redis::rpush('sort_unionpay_die',json_encode($payment));
	                                                }
	                                            }else{
	                                                if(stristr($payment->payment->paytype,'alipay') !== false){
	                                                    Redis::sadd('random_alipay_die',json_encode($payment));
	                                                }
	                                                if(stristr($payment->payment->paytype,'aliwap') !== false){
	                                                    Redis::sadd('random_aliwap_die',json_encode($payment));
	                                                }
	                                                if(stristr($payment->payment->paytype,'wechat') !== false){
	                                                    Redis::sadd('random_wechat_die',json_encode($payment));
	                                                }
	                                                if(stristr($payment->payment->paytype,'unionpay') !== false){
	                                                    Redis::sadd('random_unionpay_die',json_encode($payment));
	                                                }
	                                            }
											}
				        					$json['status'] = "ok";
				        					$json['msg'] = "修改成功";
				        				}else{
				        					$json['status'] = "error";
											$json['msg']=  "当前无更改,修改失败";
				        				}
									}
								}else{
									$json['status'] = "error";
									$json['msg'] ="当前码商不支持添加该通道,请在APP通道添加";
								}
							}else{
								$json['status'] = "error";
								$json['msg'] = "当前收款账号不存在";
							}
						}else{
							$json['status'] = "error";
							$json['msg']=  "提交参数错误";
						}
					}else{
						$json['status']="error";
						$json['msg'] = "提交参数错误";
					}
				}else{
					$json['status'] = "error";
					$json['msg'] = "请填写通道备注";
				}
			}else if($arr->input('action') == 'region'){
				$json['status']="ok";
				$json['region'] = DB::table('region')->select(['region_name','region_id'])->distinct()->get()->toArray();
				if($arr->filled('region_id') && $arr->input('region_id')!= 999999){
					$json['city'] = DB::table('region')->where('region_id',$arr->input('region_id'))->select(['city_name','city_id'])->get()->toArray();
				}else{
					$json['city'][] = array('city_name'=>"全市",'city_id'=>0);
				}
			}else{
				$json['status'] = "error";
				$json['msg'] = "不安全的提交方式";
			}
			return $json;
		}
		return view('admin/merchant_diecode');
	}
	/****后台码商活码通道****/
	public function merchant_livecode(Request $arr){
		if($arr->isMethod('post')){

			if($arr->has('page')){
				if($arr->filled('gateway_state') && $arr->input('gateway_state')!= '-1' ){
					$map['gateway_state']=$arr->input('gateway_state');
				}else{
					$map[]=['gateway_state','!=',null];
				}

				if($arr->filled('field') && $arr->input('field')!= '-1' && $arr->filled('value') && !empty($arr->input('value'))){
					if($arr->input('field') == 'polling_user'){
						//查询该账号ID
						$pollinginfo = DB::table('member_polling')->where('username',$arr->input('value'))->first();
						if($pollinginfo){
							$map[] = ['polling_id','=',$pollinginfo->Id];
						}else{
							$map['polling_id'] = 0;
						}
					}else{
						$map[]=[$arr->input('field'),'like','%'.$arr->input('value').'%'];
					}
				}
				if($arr->has('region_id') && !is_null($arr->input('region_id')) && $arr->input('region_id')!=  999999){
					$map['region_id']=$arr->input('region_id');
				}
				if($arr->has('city_id') && !is_null($arr->input('city_id')) && $arr->input('city_id')!= 0){
					$map['city_id']=$arr->input('city_id');
				}
				$listpage=LivepollingpaymentModel::where($map)->with('payment','user')->orderBy('id','desc')->paginate(15)->toarray();
				//查询总数量
				$json['data']['toptext']['count'] = LivepollingpaymentModel::where($map)->count();
				//查询Redis码池数量
				$admin_site = DB::table('admin_site')->first();
				if($admin_site->payment_type ==1){
					$alipay = Redis::exists('sort_alipay_live') ? Redis::llen('sort_alipay_live') : 0;
					$aliwap = Redis::exists('sort_aliwap_live') ? Redis::llen('sort_aliwap_live') : 0;
					$wechat = Redis::exists('sort_wechat_live') ? Redis::llen('sort_wechat_live') : 0;
					$unionpay = Redis::exists('sort_unionpay_live') ? Redis::llen('sort_unionpay_live') : 0;
				}else{
					$alipay = Redis::exists('random_alipay_live') ? Redis::llen('random_alipay_live') : 0;
					$aliwap = Redis::exists('random_aliwap_live') ? Redis::llen('random_aliwap_live') : 0;
					$wechat = Redis::exists('random_wechat_live') ? Redis::llen('random_wechat_live') : 0;
					$unionpay = Redis::exists('random_unionpay_live') ? Redis::llen('random_unionpay_live') : 0;
				}
				$json['data']['toptext']['on_count'] = $alipay+$aliwap+$wechat+$unionpay;
				$json['data']['toptext']['off_count'] = 0;
				if($listpage['total'] >= 1){
	       	  		$data = $listpage['data'];
	       	  		foreach ($data as $k => $v) {
	       	  			$v=(array)$v;
	       	  			$map3['status']=2;
						$map3['polling_passageway_key']=$v['key'];
						$map3[]=['sub_time','<',strtotime(date('Y-m-d 00:00:00'))+86400];
						$map3[]=['sub_time','>=',strtotime(date('Y-m-d 00:00:00'))];
						$v['today_amount'] = OrderModel::where($map3)->sum('order_price');
						$v['passageway_name'] = $v['payment']['name'];
						$v['polling_user'] = $v['user']['username'];
	       	  			$json['data']['list'][]=$v;
	       	  		}
	       	  	}else{
	       	  		$json['data']['list']=[];
	       	  	}
	       	  	$json['current_page']=$listpage['current_page'];
			   	$json['total']=$listpage['total'];
			   	$json['status']="ok";
			}else if($arr->input('action') == 'lose' || $arr->input('action')=='open'){
				$data = $arr->input('form');
				if(is_array($data)){
					$admin_site = DB::table('admin_site')->first();
					$order_redis = new Order_Redis;
					foreach ($data as $k =>$v) {
						$v = (array)$v;
						$info = LivepollingpaymentModel::where('Id',$v)->with('user','payment','merchant')->first();
						//清除该通道二维码
                        $order_redis->delete($admin_site->payment_type,'alipay',2,array('key'=>$info->key));
                        $order_redis->delete($admin_site->payment_type,'aliwap',2,array('key'=>$info->key));
                        $order_redis->delete($admin_site->payment_type,'wechat',2,array('key'=>$info->key));
                        $order_redis->delete($admin_site->payment_type,'unionpay',2,array('key'=>$info->key));
						if($info->user->status == 1 && $info->user->loop == 1 && $info->merchant->price >1 && $info->merchant->frozen_amount >= 0){
							$info->gateway_state = 1;
							if($arr->input('action') == 'open'){
								//添加二维码
								if($admin_site->payment_type == 1){
									if(stristr($info->payment->paytype,'alipay') !== false){
                                        Redis::rpush('sort_alipay_live',json_encode($info));
                                    }
                                    if(stristr($info->payment->paytype,'aliwap') !== false){
                                        Redis::rpush('sort_aliwap_live',json_encode($info));
                                    }
                                    if(stristr($info->payment->paytype,'wechat') !== false){
                                        Redis::rpush('sort_wechat_live',json_encode($info));
                                    }
                                    if(stristr($info->payment->paytype,'unionpay') !== false){
                                        Redis::rpush('sort_unionpay_live',json_encode($info));
                                    }
								}else{
									if(stristr($info->payment->paytype,'alipay') !== false){
                                        Redis::sadd('random_alipay_live',json_encode($info));
                                    }
                                    if(stristr($info->payment->paytype,'aliwap') !== false){
                                        Redis::sadd('random_aliwap_live',json_encode($info));
                                    }
                                    if(stristr($info->payment->paytype,'wechat') !== false){
                                        Redis::sadd('random_wechat_live',json_encode($info));
                                    }
                                    if(stristr($info->payment->paytype,'unionpay') !== false){
                                        Redis::sadd('random_unionpay_live',json_encode($info));
                                    }
								}
							}
						}
						if($k < 1){
							$upwhere[]=['Id','=',$v['Id']];
						}else{
							$upwhere[]=['Id','=',$v['Id'],'or'];
						}
					}
						$updata['gateway_state'] = $arr->input('action') == 'lose' ? 2 : 1;
						$num = DB::table('member_livepolling_payment')->where($upwhere)->update($updata);
						if($num == 0){
							$json['status'] = "error";
							$json['msg'] = $arr->input('action') == 'lose' ? "当前无通道网关开启" : "当前无通道网关关闭";
						}else{
							$json['status'] = "ok";
							$json['msg'] = $arr->input('action') == 'lose' ? "成功关闭网关{$num}个" : "成功开启网关{$num}个";
						}
				}else{
					$json['status'] = "error";
					$json['msg'] = "请提交正确的方式";
				}
			}else if($arr->input('action') == 'del'){
				$data = $arr->input('form');
				$admin_site = DB::table('admin_site')->first();
				$Order_Redis = new Order_Redis;
				if(is_array($data)){
					foreach ($data as $k =>$v) {
						$v = (array)$v;
						//删除通道收款池
						$Order_Redis->delete($admin_site->payment_type,'alipay',2,array('key'=>$v['key']));
                        /****删除支付宝H5二维码****/
                        $Order_Redis->delete($admin_site->payment_type,'aliwap',2,array('key'=>$v['key']));
                        /****删除微信二维码****/
                        $Order_Redis->delete($admin_site->payment_type,'wechat',2,array('key'=>$v['key']));
                        /****删除银联二维码****/
                        $Order_Redis->delete($admin_site->payment_type,'unionpay',2,array('key'=>$v['key']));
						if($k < 1){
							$deldata[]=['Id','=',$v['Id']];
						}else{
							$deldata[]=['Id','=',$v['Id'],'or'];
						}
					}

					$num = DB::table('member_livepolling_payment')->where($deldata)->delete();
					if($num == 0){
						$json['status'] = "error";
						$json['msg'] = "删除失败,出现错误";
					}else{
						$json['status'] = "ok";
						$json['msg'] = "删除成功,共删除{$num}条";
					}
				}else{
					$json['status'] = "error";
					$json['msg'] = "请提交正确的方式";
				}
			}else if($arr->input('action') == 'add'){
				$data = $arr->input('form');
				if(!empty($data['remarks'])){
					if(!empty($data['polling_user'])){
						//查询收款账号是否存在
						$pollinginfo =DB::table('member_polling')->where(array('username'=>$data['polling_user'],'type'=>2))->first();
						if($pollinginfo){
							$adddata['polling_id'] = $pollinginfo->Id;
							$adddata['member_id'] = $pollinginfo->member_id;
							//查询当前码商是否支持添加该通道
							$payment = DB::table('memberpayment')->where(array('member_id'=>$pollinginfo->member_id,'passageway_id'=>$data['passageway_id']))->first();
							if($payment){
								//查询是否已添加过该通道
	        					$map['passageway_id']=$data['passageway_id'];
	        					$map['polling_id'] = $pollinginfo->Id;
	    						$info=DB::table('member_livepolling_payment')->where($map)->first();
	        					if($info){
	        						$json['status'] = "error";
	        						$json['msg'] = "该收款账号已存在该通道哦";
	        					}
								if(!isset($json)){
									$adddata['remarks'] = $data['remarks'];
									$adddata['key'] = getpassagewaykey();
									$adddata['region_id'] = $data['region_id'];
									$adddata['city_id'] = $data['city_id'];
									if($adddata['region_id'] == 999999){
										$adddata['region_name']="全国";
									}else{
										$adddata['region_name']=DB::table('region')->where('region_id',$updata['region_id'])->first()->region_name;
									}
									if($adddata['city_id'] ==  0){
										$adddata['city_name'] = "全市";
									}else{
										$adddata['city_name'] = DB::table('region')->where('city_id',$updata['city_id'])->first()->city_name;
									}
									if(!empty($data['today_money'])){
			        					if((float)$data['today_money'] > 200000 || (float)$data['today_money']< 0){
			        						$adddata['today_money']=0;
			        					}else{
			        						$adddata['today_money'] = $data['today_money'];
			        					}
			        				}else{
			        					$adddata['today_money']=0;
			        				}
			        				if(!empty($data['total_money'])){
			        					if((float)$data['total_money'] > 10000000 || (float)$data['total_money']< 0){
			        						$adddata['total_money']=0;
			        					}else{
			        						$adddata['total_money'] = $data['total_money'];
			        					}
			        				}else{
			        					$adddata['total_money']=0;
			        				}
			        				$adddata['passageway_id'] = $data['passageway_id'];
			        				$status = DB::table('member_livepolling_payment')->insert($adddata);
			        				if($status){
			        					$json['status']="ok";
										$json['msg'] = "添加成功";
			        				}else{
			        					$json['status']="error";
										$json['msg'] = "出现错误,添加失败";
			        				}
								}
							}else{
								$json['status']="error";
								$json['msg'] = "当前码商不支持添加该通道,请在APP通道添加";
							}
						}else{
							$json['status']="error";
							$json['msg'] = "当前收款账号不存在";
						}
					}else{
						$json['status']="error";
						$json['msg'] = "请输入APP收款账号";
					}
				}else{
					$json['status'] = "error";
					$json['msg'] = "请输入通道备注";
				}
			}else if($arr->input('action') == 'edit'){
				$data = $arr->input('form');
				if(!empty($data['remarks'])){
					if(!empty($data['Id'])){
						if(!empty($data['key'])){
							$pollinginfo =DB::table('member_polling')->where(array('Id'=>$data['polling_id'],'type'=>2))->first();
							if($pollinginfo){
								//查询商户是否支持添加该通道
								$payment = DB::table('memberpayment')->where(array('member_id'=>$pollinginfo->member_id,'passageway_id'=>$data['passageway_id']))->first();
								if($payment){
									$payinfo = LivepollingpaymentModel::where('key',$data['key'])->with('user','payment','merchant')->first();
									//查询是否已添加过该通道
		        					$map['passageway_id']=$data['passageway_id'];
		        					$map['polling_id'] = $pollinginfo->Id;
		    						$info=DB::table('member_livepolling_payment')->where($map)->first();
		        					if($info){
		        						if(isset($info->key)){
		        							if($data['key'] != $info->key){
		        								$json['status'] = "error";
		        								$json['msg'] = "该收款账号已存在该通道哦";
		        							}
		        						}
		        					}
									if(!isset($json)){
										$updata['remarks'] = $data['remarks'];
										$updata['region_id'] = $data['region_id'];
										$updata['city_id'] = $data['city_id'];
										if($updata['region_id'] == 999999){
											$updata['region_name']="全国";
										}else{
											$updata['region_name']=DB::table('region')->where('region_id',$updata['region_id'])->first()->region_name;
										}
										if($updata['city_id'] ==  0){
											$updata['city_name'] = "全市";
										}else{
											$updata['city_name'] = DB::table('region')->where('city_id',$updata['city_id'])->first()->city_name;
										}
										if(!empty($data['today_money'])){
				        					if((float)$data['today_money'] > 200000 || (float)$data['today_money']< 0){
				        						$updata['today_money']=0;
				        					}else{
				        						$updata['today_money'] = $data['today_money'];
				        					}
				        				}else{
				        					$adddata['today_money']=0;
				        				}
				        				if(!empty($data['total_money'])){
				        					if((float)$data['total_money'] > 10000000 || (float)$data['total_money']< 0){
				        						$updata['total_money']=0;
				        					}else{
				        						$updata['total_money'] = $data['total_money'];
				        					}
				        				}else{
				        					$updata['total_money']=0;
				        				}
				        				$updata['passageway_id'] = $data['passageway_id'];
				        				$status = DB::table('member_livepolling_payment')->where('key',$data['key'])->update($updata);
				        				if($status){
				        					//查询该二维码新数据
											$payment = DiepollingpaymentModel::where('key',$data['key'])->with('user','payment','merchant')->first();
											//判断平台出码方式
                                            $admin_site=DB::table('admin_site')->first();
                                            //清除该通道二维码
			                                $order_redis = new Order_Redis;
			                                $order_redis->delete($admin_site->payment_type,'alipay',2,array('key'=>$payment->key));
			                                $order_redis->delete($admin_site->payment_type,'aliwap',2,array('key'=>$payment->key));
			                                $order_redis->delete($admin_site->payment_type,'wechat',2,array('key'=>$payment->key));
			                                $order_redis->delete($admin_site->payment_type,'unionpay',2,array('key'=>$payment->key));
											if($payment->user->status == 1 && $payment->user->loop == 1 && $payment->merchant->price >1 && $payment->merchant->frozen_amount>0){
	                                            if($admin_site->payment_type == 1){
	                                                if(stristr($payment->payment->paytype,'alipay') !== false){
	                                                    Redis::rpush('sort_alipay_live',json_encode($payment));
	                                                }
	                                                if(stristr($payment->payment->paytype,'aliwap') !== false){
	                                                    Redis::rpush('sort_aliwap_live',json_encode($payment));
	                                                }
	                                                if(stristr($payment->payment->paytype,'wechat') !== false){
	                                                    Redis::rpush('sort_wechat_live',json_encode($payment));
	                                                }
	                                                if(stristr($payment->payment->paytype,'unionpay') !== false){
	                                                    Redis::rpush('sort_unionpay_live',json_encode($payment));
	                                                }
	                                            }else{
	                                                if(stristr($payment->payment->paytype,'alipay') !== false){
	                                                    Redis::sadd('random_alipay_live',json_encode($payment));
	                                                }
	                                                if(stristr($payment->payment->paytype,'aliwap') !== false){
	                                                    Redis::sadd('random_aliwap_live',json_encode($payment));
	                                                }
	                                                if(stristr($payment->payment->paytype,'wechat') !== false){
	                                                    Redis::sadd('random_wechat_live',json_encode($payment));
	                                                }
	                                                if(stristr($payment->payment->paytype,'unionpay') !== false){
	                                                    Redis::sadd('random_unionpay_live',json_encode($payment));
	                                                }
	                                            }
											}
				        					$json['status'] = "ok";
				        					$json['msg'] = "修改成功";
				        				}else{
				        					$json['status'] = "error";
											$json['msg']=  "当前无更改,修改失败";
				        				}
									}
								}else{
									$json['status'] = "error";
									$json['msg'] = "当前码商不支持添加该通道,请在APP通道添加";
								}
							}else{
								$json['status'] = "error";
								$json['msg'] = "当前收款账号不存在";
							}
						}else{
							$json['status'] = "error";
							$json['msg']=  "提交参数错误";
						}
					}else{
						$json['status']="error";
						$json['msg'] = "提交参数错误";
					}
				}else{
					$json['status'] = "error";
					$json['msg'] = "请填写通道备注";
				}
			}else if($arr->input('action') == 'region'){
				$json['status']="ok";
				$json['region'] = DB::table('region')->select(['region_name','region_id'])->distinct()->get()->toArray();
				if($arr->filled('region_id') && $arr->input('region_id')!= 999999){
					$json['city'] = DB::table('region')->where('region_id',$arr->input('region_id'))->select(['city_name','city_id'])->get()->toArray();
				}else{
					$json['city'][] = array('city_name'=>"全市",'city_id'=>0);
				}
			}else{
				$json['status'] = "error";
				$json['msg'] = "不安全的提交方式";
			}
			return $json;
		}
		return view('admin/merchant_livecode');
	}
	/****后台商户列表****/
	public function memberlist(Request $arr){
		if($arr->isMethod('post')){
			if($arr->has('page')){
				if($arr->filled('field') && $arr->input('field')!='-1' && $arr->filled('value')){
					$map[]=[$arr->input('field'),'like','%'.$arr->input('value').'%'];
				}
				if($arr->filled('type') && $arr->input('type')!= '-1' ){
					$map['type']=intval($arr->input('type'));
				}
				if($arr->filled('time') && is_array($arr->input('time'))){
					$time=$arr->input('time');
					if(!empty($time[0]) && !empty($time[1])){
						$map[]=['time','>=',strtotime($time[0])];
		       	  		$map[]=['time','<',strtotime($time[1])+86400];
					}
				}
				if($arr->filled('status')){
					if($arr->input('status') == "全部"){
						$map[]=['status','!=',null];
					}else if($arr->input('status') == "正常"){
						$map[]=['status',1];
					}else{
						$map[]=['status',2];
					}
				}else{
					$map[]=['status','!=',null];
				}
			   $listpage=DB::table('user')->where($map)->orderBy('id','desc')->paginate(15)->toarray();
			   /****总码商个数****/
			   $json['data']['toptext']['user_count']=DB::table('user')->count();
			   /****正常码商个数****/
			   $map2['status']=1;
			   $json['data']['toptext']['user_normal']=DB::table('user')->where($map2)->count();
			   /****冻结码商个数****/
			   $map2['status']=2;
			   $json['data']['toptext']['user_frozen']=DB::table('user')->where($map2)->count();
			   /****总码商可用余额****/
			   $json['data']['toptext']['user_price']=number_format(DB::table('user')->sum('price'),2,".","");
			   if($listpage['total'] >= 1){
	       	  		$data=$listpage['data'];
	       	  		foreach ($data as $k => $v) {
	       	  			$v=(array)$v;
	       	  			$v['time']=date('Y-m-d H:i:s',$v['time']);
	       	  			$v['order_service'] = $v['order_service']*100;
	       	  			$v['safety_service'] = $v['safety_service']*100;
	       	  			$json['data']['list'][]=$v;
	       	  		}
	       	  	}else{
	       	  		$json['data']['list']=[];
	       	  	}
	       	  	$json['current_page']=$listpage['current_page'];
			   	$json['total']=$listpage['total'];
			   	$json['status']="ok";
			}else if($arr->input('action') == 'passageway'){
				/****获取所有固码****/
				$json['data']['diepassageway']=DB::table('die_passageway')->where('status',1)->get()->toarray();
				/****获取所有活码****/
				$json['data']['livepassageway']=DB::table('live_passageway')->where('status',1)->get()->toarray();
			}else if($arr->input('action') == 'add'){
				$postdata = $arr->input('form');
				if(checkphone($postdata['phone'])){
					//查询是否存在该手机号商户
				   if(!DB::table('user')->where('phone',$postdata['phone'])->first()){
					if(checkpass($postdata['password'])){
						if((float)$postdata['order_service'] >= '0.01'){
							if((float)$postdata['safety_service'] >= '0.01'){
								if(!empty($postdata['diepassageway']) || !empty($postdata['livepassageway'])){
										$adddata['phone'] = $postdata['phone'];
										$adddata['password'] = xpass($postdata['password']);
										$ga = new Google;
										$adddata['safetycode'] = $ga->createSecret();
										$adddata['type'] = $postdata['type'];
										$adddata['price'] = intval($postdata['price']) <= 0 ? 0 : (float)$postdata['price'];
											$adddata['order_service'] = $postdata['order_service']/100;
										$adddata['safety_service'] = $postdata['safety_service']/100;
										$adddata['token'] = getusertoken();
										$adddata['time'] = time();
										$adddata['status'] = $postdata['status'];
										$status = DB::table('user')->insertGetId($adddata);
										if($status){
											//添加支持商户通道
											if(!empty($postdata['diepassageway'])){
												if($postdata['diepassageway'] == '-1' || in_array('-1',$postdata['diepassageway'])){
													$payment=DB::table('die_passageway')->where('status',1)->select('Id')->get()->toarray();
													foreach ($payment as $v) {
														$v = (array)$v;
														$v['passageway_id'] =$v['Id'];
									                    $v['passageway_type'] = 1;
									                    $v['user_id'] = $status;
									                    unset($v['Id']);
									                    $addpayment[] = $v;
													}
												}else{
													foreach ($postdata['diepassageway'] as $v) {
														$addpayment[]=array('user_id'=>$status,'passageway_id'=>$v,'passageway_type'=>1);
													}
												}

											}
											if(!empty($postdata['livepassageway'])){
												if($postdata['livepassageway'] == '-1' || in_array('-1',$postdata['livepassageway'])){
													$payment=DB::table('live_passageway')->where('status',1)->select('Id')->get()->toarray();
													foreach ($payment as $v) {
														$v = (array)$v;
														$v['passageway_id'] =$v['Id'];
									                    $v['passageway_type'] = 2;
									                    $v['user_id'] = $status;
									                    unset($v['Id']);
									                    $addpayment[] = $v;
													}
												}else{
													foreach ($postdata['livepassageway'] as $v) {
														$addpayment[]=array('user_id'=>$status,'passageway_id'=>$v,'passageway_type'=>2);
													}
												}
											}
											$payment_status = DB::table('userpayment')->insert($addpayment);
											if($payment_status){
												$json['status']="ok";
												$json['msg']="商户添加成功,当前添加商户ID:{$status}";
											}else{
												$json['status']="ok";
												$json['msg']="商户添加成功,通道添加失败,添加商户ID:{$status}";
											}
										}else{
											$json['status'] = "error";
											$json['msg'] = "出现错误,商户添加失败";
										}
								}else{
									$json['status'] = "error";
									$json['msg'] = "请至少选择一个通道";
								}
							}else{
								$json['status'] = "error";
								$json['msg'] = "通道费率不能低于0.01%哦";
							}
						}else{
							$json['status'] = "error";
							$json['msg'] = "订单费率不能低于0.01%哦";
						}
					}else{
						$json['status'] = "error";
						$json['msg'] = "密码不符合规则";
					}
				   }else{
				   		$json['status'] = "error";
						$json['msg'] = "当前手机号商户已存在";
				   }
				}else{
					$json['status'] = "error";
					$json['msg'] = "请输入正确的手机号";
				}
			}else if($arr->input('action') == 'edit'){
				$data = $arr->input('form');
				if((float)$data['order_service'] >= '0.01'){
					if((float)$data['safety_service'] >= '0.01'){
						if(!empty($data['phone'])){
							if(!checkphone($data['phone'])){
								$json['status'] = "error";
								$json['msg'] = "请填写正确的手机号";
							}else{
								if(!DB::table('user')->where('phone',$data['phone'])->first()){
									$updata['phone'] = $data['phone'];
								}else{
									$json['status'] = "error";
									$json['msg'] = "当前手机号商户已存在";
								}
							}
						}
						if(!empty($data['member_arr'])){
							$arr_id = explode(",",$data['member_arr']);
							if(is_array($arr_id)){
								foreach ($arr_id as $v){
									$merchant = DB::table('member')->where('Id',$v)->first();
									if(!$merchant){
										$json['status'] = "error";
										$json['msg'] = "未找到当前Id为".$v."的码商";break;
									}
								}
							}else{
								$json['status'] = "error";
								$json['msg'] = "请填写正确的格式的指定码商";
							}
						}
						if(!empty($data['password'])){
							if(!checkpass($data['password'])){
								$json['status'] = "error";
								$json['msg'] = "请填写6~20位的密码";
							}else{
								$updata['password'] = xpass($data['password']);
							}
						}
						if(!isset($json)){
							$updata['member_arr'] = $data['member_arr'];
							$updata['type'] = $data['type'];
							$updata['order_service'] = $data['order_service']/100;
							$updata['safety_service'] = $data['safety_service']/100;
							$updata['status'] = $data['status'];

							$status = DB::table('user')->where('Id',$data['Id'])->update($updata);
							if($status){
								$json['status'] = "ok";
								$json['msg'] = "修改成功";
							}else{
								$json['status'] = "error";
								$json['msg'] = "当前无更改,修改失败";
							}
						}
					}else{
						$json['status'] = "error";
						$json['msg'] = "单笔通道费率不能低于0.01%";
					}
				}else{
					$json['status'] = "error";
					$json['msg'] = "单笔订单费率不能低于0.01%";
				}
			}else if($arr->input('action') == 'amount'){
				$data =$arr->input('form');
				if(!empty($data['Id'])){
					 $user = DB::table('user')->where('Id',$data['Id'])->first();
					if(!empty($data['price'])){
						if($data['price'] != 0){
							if($data['price'] < 0){
								$amount_change['type'] = 6;
								$amount_change['amount'] = abs($data['price']);
							}else{
								$amount_change['type'] = 5;
								$amount_change['amount'] = $data['price'];
							}
							$updata['price'] = $user->price+$data['price'];
							$status = DB::table('user')->where('Id',$data['Id'])->update($updata);
							if($status){
								//添加商户余额明细
								$amount_change['user_id'] = $data['Id'];
								$amount_change['user_price'] = $updata['price'];
								$amount_change['time'] = time();
								DB::table('user_amount_change')->insert($amount_change);
								$json['status'] = "ok";
								$json['msg'] = "充值成功";
							}else{
								$json['status'] = "error";
								$json['msg'] = "金额充值失败";
							}
						}else{
							$json['status'] = "error";
							$json['msg'] = "充值金额不得为0";
						}
					}else{
						$json['status'] = "error";
						$json['msg'] = "请输入充值可用金额";
					}
				}else{
					$json['status'] = "error";
					$json['msg'] = "提交参数错误";
				}
			}else if($arr->input('action') == 'login'){
				$data = $arr->input('form');
				//查询当前用户是否存在
				$user = DB::table('user')->where('Id',$data['Id'])->first();
				if($user){
					//设置ssession
					session()->put('user',(array)$user);
					$json['status'] = "ok";
					$json['url'] = 'http://'.config('route.domain.member');
					$json['msg'] = "验证成功";
				}else{
					$json['status']="error";
					$json['msg']="当前商户不存在";
				}
			}else if($arr->input('action') == 'del'){
				$data = $arr->input('form');
				if(is_array($data)){
					foreach($data as $k => $v){
						$v = (array)$v;
						if($k < 1){
							//查询当前商户是否存在资金明细
							if(DB::table('user_amount_change')->where('user_id',$v['Id'])->first()){
								$amount[] = ['user_id','=',$v['Id']];
							}
							//查询当前商户是否存在登录日志
							if(DB::table('user_log')->where('user_id',$v['Id'])->first()){
								$loginlog[] = ['user_id','=',$v['Id']];
							}
							//查询当前商户是否存在升级记录
							if(DB::table('user_upgradepay')->where('user_id',$v['Id'])->first()){
								$paylog[] = ['user_id','=',$v['Id']];
							}
							//查询当前商户是否存在提现账户
							if(DB::table('user_cash_account')->where('user_id',$v['Id'])->first()){
								$cash[] = ['user_id','=',$v['Id']];
							}
							//查询当前商户是否存在提现记录
							if(DB::table('user_drawing')->where('user_id',$v['Id'])->first()){
								$drawing[] =['user_id','=',$v['Id']];
							}
							//查询当前商户是否存在APP支持通道
							if(DB::table('userpayment')->where('user_id',$v['Id'])->first()){
								$payment[] = ['user_id','=',$v['Id']];
							}
							$deldata[]=['Id','=',$v['Id']];
						}else{
							//查询当前商户是否存在资金明细
							if(DB::table('user_amount_change')->where('user_id',$v['Id'])->first()){
								$amount[] = ['user_id','=',$v['Id'],'or'];
							}
							//查询当前商户是否存在登录日志
							if(DB::table('user_log')->where('user_id',$v['Id'])->first()){
								$loginlog[] = ['user_id','=',$v['Id'],'or'];
							}
							//查询当前商户是否存在升级记录
							if(DB::table('user_upgradepay')->where('user_id',$v['Id'])->first()){
								$paylog[] = ['user_id','=',$v['Id'],'or'];
							}
							//查询当前商户是否存在提现账户
							if(DB::table('user_cash_account')->where('user_id',$v['Id'])->first()){
								$cash[] = ['user_id','=',$v['Id'],'or'];
							}
							//查询当前商户是否存在提现记录
							if(DB::table('user_drawing')->where('user_id',$v['Id'])->first()){
								$drawing[] =['user_id','=',$v['Id'],'or'];
							}
							//查询当前商户是否存在APP支持通道
							if(DB::table('userpayment')->where('user_id',$v['Id'])->first()){
								$payment[] = ['user_id','=',$v['Id'],'or'];
							}
							$deldata[]=['Id','=',$v['Id'],'or'];
						}
					}
						//先删除各种数据
						if(isset($amount)){
							DB::table('user_amount_change')->where($amount)->delete();
						}
						if(isset($loginlog)){
							DB::table('user_log')->where($loginlog)->delete();
						}
						if(isset($paylog)){
							DB::table('user_upgradepay')->where($paylog)->delete();
						}
						if(isset($cash)){
							DB::table('user_cash_account')->where($cash)->delete();
						}
						if(isset($drawing)){
							DB::table('user_drawing')->where($drawing)->delete();
						}
						if(isset($payment)){
							DB::table('userpayment')->where($payment)->delete();
						}
						$num = DB::table('user')->where($deldata)->delete();
						if($num == 0){
							$json['status'] = "error";
							$json['msg'] = "删除失败,出现错误";
						}else{
							$json['status'] = "ok";
							$json['msg'] = "删除成功,共删除{$num}条";
						}
					}else{
						$json['status']="error";
						$json['msg']="提交出现错误,请刷新重试";
					}
			}else{
				$json['status']="error";
				$json['msg']="不安全的提交方式";
			}
			return $json;
		}
		return view('admin/memberlist');
	}

	/****后台商户登录记录****/
	public function member_loginlog(Request $arr){
		if($arr->isMethod('post')){
			if($arr->has('page')){
				  $data=$arr->all();
				if($arr->filled('user_id') && $arr->input('user_id')!= '-1'){
					$map['user_id']=$arr->input('user_id');
				}else{
					$map[]=['time','!=',null];
				}

				if($arr->filled('time') && is_array($arr->input('time'))){
					$time=$arr->input('time');
					if(!empty($time[0]) && !empty($time[1])){
						$map[]=['time','>=',strtotime($time[0])];
		       	  		$map[]=['time','<',strtotime($time[1])+86400];
					}
				}
				$listpage=DB::table('user_log')->where($map)->orderBy('id','desc')->paginate(15)->toarray();
				if($listpage['total'] >= 1){
	       	  		$data=$listpage['data'];
	       	  		foreach ($data as $k => $v) {
	       	  			$v=(array)$v;
	       	  			$v['time']=date('Y-m-d H:i:s',$v['time']);
	       	  			$json['data']['list'][]=$v;
	       	  		}
	       	  	}else{
	       	  		$json['data']['list']=[];
	       	  	}
	       	  	$json['current_page']=$listpage['current_page'];
			   	$json['total']=$listpage['total'];
			   	$json['status']="ok";
			}else if($arr->input('action') == 'del'){
				$data = $arr->input('form');
				if(is_array($data)){
					foreach($data as $k => $v){
						$v = (array)$v;
						if($k < 1){
							$deldata[]=['Id','=',$v['Id']];
						}else{
							$deldata[]=['Id','=',$v['Id'],'or'];
						}
					}
					$num = DB::table('user_log')->where($deldata)->delete();
					if($num == 0){
						$json['status'] = "error";
						$json['msg'] = "删除失败,出现错误";
					}else{
						$json['status'] = "ok";
						$json['msg'] = "删除成功,共删除{$num}条";
					}
				}else{
					$json['status']="error";
					$json['msg']="提交出现错误,请刷新重试";
				}
			}else{
				$json['status']="error";
				$json['msg']="不安全的提交方式";
			}
			return $json;
		}

		return view('admin/member_loginlog');
	}
	/****后台商户加款记录****/
	public function member_amount_change(Request $arr){
		if($arr->isMethod('post')){
			if($arr->has('page')){
				  $data=$arr->all();
				  $map[] = ['type','>=',5];
				if($arr->filled('user_id') && $arr->input('user_id')!= '-1'){
					$map['user_id']=$arr->input('user_id');
				}else{
					$map[]=['time','!=',null];
				}

				if($arr->filled('time') && is_array($arr->input('time'))){
					$time=$arr->input('time');
					if(!empty($time[0]) && !empty($time[1])){
						$map[]=['time','>=',strtotime($time[0])];
		       	  		$map[]=['time','<',strtotime($time[1])+86400];
					}
				}
				$listpage=DB::table('user_amount_change')->where($map)->orderBy('id','desc')->paginate(15)->toarray();
				if($listpage['total'] >= 1){
	       	  		$data=$listpage['data'];
	       	  		foreach ($data as $k => $v) {
	       	  			$v=(array)$v;
	       	  			if($v['type'] == 5){
	       	  				$v['type'] = "平台充值";
	       	  				$v['amount']= "+".$v['amount'];
	       	  			}else if($v['type'] == 6){
	       	  				$v['type'] = "平台扣款";
	       	  				$v['amount']= "-".$v['amount'];
	       	  			}
	       	  			$v['time']=date('Y-m-d H:i:s',$v['time']);
	       	  			$json['data']['list'][]=$v;
	       	  		}
	       	  	}else{
	       	  		$json['data']['list']=[];
	       	  	}
	       	  	$json['current_page']=$listpage['current_page'];
			   	$json['total']=$listpage['total'];
			   	$json['status']="ok";
			}else if($arr->input('action') == 'del'){
				$data = $arr->input('form');
				if(is_array($data)){
					foreach($data as $k => $v){
						$v = (array)$v;
						if($k < 1){
							$deldata[]=['Id','=',$v['Id']];
						}else{
							$deldata[]=['Id','=',$v['Id'],'or'];
						}
					}
					$num = DB::table('user_amount_change')->where($deldata)->delete();
					if($num == 0){
						$json['status'] = "error";
						$json['msg'] = "删除失败,出现错误";
					}else{
						$json['status'] = "ok";
						$json['msg'] = "删除成功,共删除{$num}条";
					}
				}else{
					$json['status']="error";
					$json['msg']="提交出现错误,请刷新重试";
				}
			}else{
				$json['status']="error";
				$json['msg']="不安全的提交方式";
			}
			return $json;
		}

		return view('admin/member_amount_change');
	}
	/****后台商户APP通道控制****/
	public function member_payment(Request $arr){
		if($arr->isMethod('post')){
			if($arr->has('page')){
				if($arr->filled('user_id') && $arr->input('user_id')!= '-1' ){
					$map['user_id']=$arr->input('user_id');
				}else{
					$map[]=['status','!=',null];
				}
				if($arr->filled('passageway_type') && $arr->input('passageway_type')!= '-1' ){
					$map['passageway_type']=$arr->input('passageway_type');
				}
				if($arr->filled('passageway_id') && $arr->input('passageway_id')!= '-1' ){
					$map['passageway_id']=$arr->input('passageway_id');
				}

				$listpage=PaymentModel::where($map)->with('diepay','livepay')->orderBy('id','desc')->paginate(15)->toarray();
				if($listpage['total'] >= 1){
	       	  		$data=$listpage['data'];
	       	  		foreach ($data as $k => $v) {
	       	  			$v=(array)$v;
	       	  			if(!empty($v['diepay'])){
	       	  				$v['passageway_name']=$v['diepay']['name'];
	       	  			}else{
	       	  				$v['passageway_name']=$v['livepay']['name'];
	       	  			}
	       	  			$json['data']['list'][]=$v;
	       	  		}
	       	  	}else{
	       	  		$json['data']['list']=[];
	       	  	}
	       	  	$json['current_page']=$listpage['current_page'];
			   	$json['total']=$listpage['total'];
			   	$json['status']="ok";
			}else if($arr->input('action') == 'add'){
				$postdata = $arr->input('form');
				try {

				if(!empty($postdata['passageway_id']) && !empty($postdata['passageway_type'])){
					//查询商户是否存在
					if(!empty($postdata['user_id'])){
						if(DB::table('user')->where('Id',$postdata['user_id'])->first()){
							if($postdata['passageway_type'] != '-1'){
								if($postdata['passageway_id'] == '-1' || in_array("-1",$postdata['passageway_id'])){
									if($postdata['passageway_type'] == 1){
										$payment=DB::table('die_passageway')->where('status',1)->select('Id')->get()->toarray();
									}else{
										$payment=DB::table('live_passageway')->where('status',1)->select('Id')->get()->toarray();
									}
									foreach ($payment as $k => $v) {
										$v = (array)$v;
										$v['passageway_id'] =$v['Id'];
					                    $v['passageway_type'] = $postdata['passageway_type'];
					                    $v['user_id'] = $postdata['user_id'];
					                    unset($v['Id']);
					                    //查询该商户是否存在该通道
					                    if(!DB::table('userpayment')->where(array(
					                    	'user_id'=>$postdata['user_id'],
					                    	'passageway_type'=>$postdata['passageway_type'],
					                    	'passageway_id'=>$v['passageway_id']))->first()){
					                    	$addpayment[] = $v;
					                    }

									}
								}else{
									//查询该商户是否存在该通道
									foreach ($postdata['passageway_id'] as $v) {
										if(!DB::table('userpayment')->where(array(
				                    	'user_id'=>$postdata['user_id'],
				                    	'passageway_type'=>$postdata['passageway_type'],
				                    	'passageway_id'=>$v))->first()){
											$addpayment[] = array('user_id'=>$postdata['user_id'],'passageway_id'=>$v,'passageway_type'=>$postdata['passageway_type']);
				                    	}
									}
								}
								if(isset($addpayment)){
									$payment_status = DB::table('userpayment')->insert($addpayment);
									if($payment_status){
										$json['status']="ok";
										$json['msg']="通道添加成功";
									}else{
										$json['status']="error";
										$json['msg']="通道添加失败";
									}
								}else{
									$json['status']="error";
									$json['msg']="当前商户无可添加通道哦";
								}
							}else{
								$json['status'] = "error";
								$json['msg'] = "请先选择通道类型";
							}
						}else{
							$json['status'] = "error";
							$json['msg'] = "不存在当前商户";
						}
					}else{
						$json['status'] = "error";
						$json['msg'] = "请填写商户ID编号";
					}
				}
				} catch (\Exception $e) {
					$json['status'] = "error";
					$json['msg'] = $e->getMessage();
				}
			}else if($arr->input('action') == 'lose' || $arr->input('action')=='open'){
				$data = $arr->input('form');
				if(is_array($data)){
					foreach ($data as $k =>$v) {
						$v = (array)$v;
						if($k < 1){
							$upwhere[]=['Id','=',$v['Id']];
						}else{
							$upwhere[]=['Id','=',$v['Id'],'or'];
						}
					}
						$updata['status'] = $arr->input('action') == 'lose' ? 2 : 1;
						$num = DB::table('userpayment')->where($upwhere)->update($updata);
						if($num == 0){
							$json['status'] = "error";
							$json['msg'] = $arr->input('action') == 'lose' ? "当前无APP通道开启" : "当前无通道无APP通道关闭";
						}else{
							$json['status'] = "ok";
							$json['msg'] = $arr->input('action') == 'lose' ? "成功暂停APP通道{$num}个" : "成功开启APP通道{$num}个";
						}
				}else{
					$json['status'] = "error";
					$json['msg'] = "请提交正确的方式";
				}
			}else if($arr->input('action') == 'del'){
				$data = $arr->input('form');
				if(is_array($data)){
					foreach($data as $k => $v){
						$v = (array)$v;
						if($k < 1){
							$deldata[]=['Id','=',$v['Id']];
						}else{
							$deldata[]=['Id','=',$v['Id'],'or'];
						}
					}
					$num = DB::table('userpayment')->where($deldata)->delete();
					if($num == 0){
						$json['status'] = "error";
						$json['msg'] = "删除失败,出现错误";
					}else{
						$json['status'] = "ok";
						$json['msg'] = "删除成功,共删除{$num}条";
					}
				}else{
					$json['status']="error";
					$json['msg']="提交出现错误,请刷新重试";
				}
			}else{
				$json['status']="error";
				$json['msg']="不安全的提交方式";
			}
			return $json;
		}
		return view('admin/member_payment');
	}

	/****后台商户设置****/
	public function membersite(Request $arr){
		 if($arr->isMethod('post')){
		 	 if($arr->input('action') == 'ajax'){
		 	 	$json['data']['userform']=DB::table('admin_user_site')->first();
		 	 	if($json['data']['userform']->status == 1){
		 	 		$json['data']['userform']->status = true;
		 	 	}else{
		 	 		$json['data']['userform']->status = false;
		 	 	}
		 	 	$json['data']['userform']->order_service = $json['data']['userform']->order_service*100;
		 	 	$json['data']['userform']->safety_service = $json['data']['userform']->safety_service*100;
		 	 	$json['data']['userform']->cash_service = $json['data']['userform']->cash_service*100;
		 	 	$diepassageway=explode(",",$json['data']['userform']->diepassageway);
		 	 	foreach ($diepassageway as $v) {
				    $die[] = intval(trim($v));
				}
				$json['data']['userform']->diepassageway=$die;
		 	 	$livepassageway=explode(",",$json['data']['userform']->livepassageway);
		 	 	foreach ($livepassageway as $v) {
				    $live[] = intval(trim($v));
				}
				$json['data']['userform']->livepassageway=$live;

		 	 	$json['data']['userseniorform']=DB::table('admin_user_senior_site')->first();
		 	 	$json['data']['userseniorform']->order_service = $json['data']['userseniorform']->order_service*100;
		 	 	$json['data']['userseniorform']->safety_service = $json['data']['userseniorform']->safety_service*100;
		 	 	$json['data']['userseniorform']->cash_service = $json['data']['userseniorform']->cash_service*100;
		 	 	$json['data']['uservipform']=DB::table('admin_user_vip_site')->first();
		 	 	$json['data']['uservipform']->order_service = $json['data']['uservipform']->order_service*100;
		 	 	$json['data']['uservipform']->safety_service = $json['data']['uservipform']->safety_service*100;
		 	 	$json['data']['uservipform']->cash_service = $json['data']['uservipform']->cash_service*100;
		 	 }else if($arr->input('action')=='user' && $arr->filled('form')){
		 	 	$postdata=$arr->input('form');
		 	 	if(!empty($postdata['cash_min']) && (float)$postdata['cash_min'] >= 1){
		 	 		if(!empty($postdata['cash_service']) && (float)$postdata['cash_service'] >0){
		 	 			if(!empty($postdata['order_service']) && (float)$postdata['order_service'] >0){
		 	 				if(!empty($postdata['safety_service']) && (float)$postdata['safety_service'] >0){
		 	 					$postdata['cash_service'] =  $postdata['cash_service']/100;
		 	 					$postdata['order_service'] = $postdata['order_service']/100;
		 	 					$postdata['safety_service'] = $postdata['safety_service']/100;
		 	 					if(empty($postdata['cash_num'])){
		 	 						$postdata['cash_num']=0;
		 	 					}
		 	 					if(empty($postdata['cash_max'])){
		 	 						$postdata['cash_max']=0;
		 	 					}
		 	 					if(empty($postdata['order_everyday_money'])){
		 	 						$postdata['order_everyday_money']=0;
		 	 					}
		 	 					if($postdata['status']){
		 	 						$postdata['status']=1;
		 	 					}else{
		 	 						$postdata['status']=2;
		 	 					}
		 	 					if(!empty($postdata['diepassageway'])){
		 	 						$diepassageway='';
		 	 						foreach ($postdata['diepassageway'] as $v) {
			 	 						$diepassageway.=$v.',';
			 	 					}
			 	 					$postdata['diepassageway']=rtrim($diepassageway,",");
		 	 					}
		 	 					if(!empty($postdata['livepassageway']) || $postdata['livepassageway'] != "-1"){
		 	 						$livepassageway='';
		 	 						foreach ($postdata['livepassageway'] as $v) {
			 	 						$livepassageway.=$v.',';
			 	 					}
			 	 					$postdata['livepassageway']=rtrim($livepassageway,",");
		 	 					}
		 	 					$status = DB::table('admin_user_site')->update($postdata);
		 	 					if($status){
		 	 						$json['status']="ok";
		 	 						$json['msg']="保存成功";
		 	 					}else{
		 	 						$json['status']="error";
			 	 					$json['msg']="未更改参数,保存失败";
		 	 					}
		 	 				}else{
		 	 					$json['status']="error";
			 	 				$json['msg']="订单支付通道费率不能为0哦";
		 	 				}
		 	 			}else{
			 	 			$json['status']="error";
			 	 			$json['msg']="订单费率不能为0哦";
			 	 		}
		 	 		}else{
		 	 			$json['status']="error";
		 	 			$json['msg']="提现费率不能为0哦";
		 	 		}
		 	 	}else{
		 	 		$json['status']="error";
		 	 		$json['msg']="最低提现金额不能少于1元";
		 	 	}
		 	 }else if($arr->input('action')=='senior' && $arr->filled('form')){
		 	 	$postdata=$arr->input('form');
		 	 	if(!empty($postdata['cash_min']) && (float)$postdata['cash_min'] >= 1){
		 	 		if(!empty($postdata['cash_service']) && (float)$postdata['cash_service'] >0){
		 	 			if(!empty($postdata['order_service']) && (float)$postdata['order_service'] >0){
		 	 				if(!empty($postdata['safety_service']) && (float)$postdata['safety_service'] >0){
		 	 					$postdata['cash_service'] =  $postdata['cash_service']/100;
		 	 					$postdata['order_service'] = $postdata['order_service']/100;
		 	 					$postdata['safety_service'] = $postdata['safety_service']/100;
		 	 					if(empty($postdata['cash_num'])){
		 	 						$postdata['cash_num']=0;
		 	 					}
		 	 					if(empty($postdata['cash_max'])){
		 	 						$postdata['cash_max']=0;
		 	 					}
		 	 					if(empty($postdata['order_everyday_money'])){
		 	 						$postdata['order_everyday_money']=0;
		 	 					}
		 	 					$status = DB::table('admin_user_senior_site')->update($postdata);
		 	 					if($status){
		 	 						$json['status']="ok";
		 	 						$json['msg']="保存成功";
		 	 					}else{
		 	 						$json['status']="error";
			 	 					$json['msg']="未更改参数,保存失败";
		 	 					}
		 	 				}else{
		 	 					$json['status']="error";
		 	 					$json['msg']="订单支付通道费率不能为0哦";
		 	 				}
		 	 			}else{
		 	 				$json['status']="error";
		 	 				$json['msg']="订单费率不能为0哦";
		 	 			}
		 	 		}else{
		 	 			$json['status']="error";
		 	 			$json['msg']="提现费率不能为0哦";
		 	 		}
		 	 	}else{
		 	 		$json['status']="error";
		 	 		$json['msg']="最低提现金额不能少于1元";
		 	 	}
		 	 }else if($arr->input('action')=='vip' && $arr->filled('form')){
		 	 	$postdata=$arr->input('form');
		 	 	if(!empty($postdata['cash_min']) && (float)$postdata['cash_min'] >= 1){
		 	 		if(!empty($postdata['cash_service']) && (float)$postdata['cash_service'] >0){
		 	 			if(!empty($postdata['order_service']) && (float)$postdata['order_service'] >0){
		 	 				if(!empty($postdata['safety_service']) && (float)$postdata['safety_service'] >0){
		 	 					$postdata['cash_service'] =  $postdata['cash_service']/100;
		 	 					$postdata['order_service'] = $postdata['order_service']/100;
		 	 					$postdata['safety_service'] = $postdata['safety_service']/100;
		 	 					if(empty($postdata['cash_num'])){
		 	 						$postdata['cash_num']=0;
		 	 					}
		 	 					if(empty($postdata['cash_max'])){
		 	 						$postdata['cash_max']=0;
		 	 					}
		 	 					if(empty($postdata['order_everyday_money'])){
		 	 						$postdata['order_everyday_money']=0;
		 	 					}
		 	 					$status = DB::table('admin_user_vip_site')->update($postdata);
		 	 					if($status){
		 	 						$json['status']="ok";
		 	 						$json['msg']="保存成功";
		 	 					}else{
		 	 						$json['status']="error";
			 	 					$json['msg']="未更改参数,保存失败";
		 	 					}
		 	 				}else{
		 	 					$json['status']="error";
		 	 					$json['msg']="订单支付通道费率不能为0哦";
		 	 				}
		 	 			}else{
		 	 				$json['status']="error";
		 	 				$json['msg']="订单费率不能为0哦";
		 	 			}
		 	 		}else{
		 	 			$json['status']="error";
		 	 			$json['msg']="提现费率不能为0哦";
		 	 		}
		 	 	}else{
		 	 		$json['status']="error";
		 	 		$json['msg']="最低提现金额不能少于1元";
		 	 	}
		 	 }else{
		 	 	$json['status']="error";
		 	 	$json['msg']="不安全的提交方式";
		 	 }
		 	 return $json;
		 }
		 return view('admin/membersite');
	}

	/****后台订单记录****/
	public function order_record(Request $arr){
		if($arr->isMethod('post')){
			if($arr->has('page')){
			  	//搜索条件
			  	if($arr->has('order') && !is_null($arr->input('order')) && $arr->input('order')!= '-1' && !is_null($arr->input('value'))){
			  	   	if($arr->input('order')=='order_money' || $arr->input('order')=='order_price' || $arr->input('order')=='user_id' || $arr->input('order')=='member_id'){
			  	   		$map[]=[$arr->input('order'),'=',$arr->input('value')];
			  	   	}else{
			  	   		$map[]=[$arr->input('order'),'like','%'.$arr->input('value').'%'];
			  	   	}
			  	}

			  	if($arr->has('status') && !empty($arr->input('status')) && $arr->input('status')!='-1'){
			  		$map['status']=$arr->input('status');
			  	}else{
			  		$map[]=['status','!=',null];
			  	}
			  	if($arr->has('notice') && !empty($arr->input('notice')) && $arr->input('notice')!='-1'){
			  		$map['notice']=$arr->input('notice');
			  	}
			  	if($arr->has('code_type') && !empty($arr->input('code_type')) && $arr->input('code_type')!='-1'){
			  		$map['code_type']=$arr->input('code_type');
			  	}
			  	if($arr->has('passageway_id') && !empty($arr->input('passageway_id')) && $arr->input('passageway_id')!='-1'){
			  		$map['passageway_id']=$arr->input('passageway_id');
			  	}
			  	if($arr->has('paytype') && !empty($arr->input('paytype')) && $arr->input('paytype')!='-1'){
			  		$map['type']=$arr->input('paytype');
			  	}
			  	if($arr->filled('time') && is_array($arr->input('time'))){
					$time=$arr->input('time');
					if(!empty($time[0]) && !empty($time[1])){
						$map[]=['sub_time','>=',strtotime($time[0])];
		       	  		$map[]=['sub_time','<',strtotime($time[1])];
					}
				}
			  	//条件结束
		  		$map2=$map;
		  		/****总提交金额****/
		  		$json['data']['record_money']['totalmoney']=DB::table('order')->where($map2)->sum('order_money');
		  		$map2['status']=2;
		  		/****成功金额****/
		  		$json['data']['record_money']['successmoney']=DB::table('order')->where($map2)->sum('order_price');
		  		/****商户收入****/
		  		$json['data']['record_money']['member_lncome']=number_format($json['data']['record_money']['successmoney']-DB::table('order')->where($map2)->sum('order_service')-DB::table('order')->where($map2)->sum('software_service'),3,".","");
		  		/****码商收入****/
		  		$json['data']['record_money']['merchant_lncome']=number_format(DB::table('order')->where($map2)->sum('order_service')+DB::table('order')->where($map2)->sum('software_service')-DB::table('order')->where($map2)->sum('passageway_service'),3,".","");
			  	$orderarr=OrderModel::where($map)->with('livepassageway','diepassageway','livepollingpayment','diepollingpayment')->orderBy('id','desc')->paginate(15)->toarray();
			  	if(intval($orderarr['total']) >= 1){
			  	   $order=$orderarr['data'];
				  	foreach($order as $k => $v){
						$v=(array)$v;
						$v['time']=date('Y-m-d H:i:s',$v['sub_time']);
						if($v['type']== 'alipay') $v['type']="支付宝扫码";else if($v['type']=='aliwap') $v['type']="支付宝H5";else if($v['type']=='wechat') $v['type']="微信扫码";else $v['type']="银联扫码";
						if(!empty($v['livepassageway'])){
							$v['passageway']=$v['livepassageway']['name'];
						}else if(!empty($v['diepassageway'])){
							$v['passageway']=$v['diepassageway']['name'];
						}
						$orderlist[]=$v;
					}
				  	$json['data']['list']=$orderlist;
			  	}else{
			  		$json['data']['list']=[];
			  	}
			  	   $json['current_page']=$orderarr['current_page'];
				   $json['total']=$orderarr['total'];
			  	   $json['status']="ok";
		    }else if($arr->input('action') == 'amount'){
		    	//修改订单金额
		    	$data = $arr->input('form');
		    	if($data['order_price'] > '0.01'){
		    		//获取码商信息
		    		$merchant = DB::table('member')->where('Id',$data['member_id'])->first();
		    		//获取用户信息
		    		$userinfo = DB::table('user')->where('Id',$data['user_id'])->first();

		    		$updata['order_price'] = $data['order_price'];
		    		$updata['order_service'] = number_format($updata['order_price']*$userinfo->order_service,3,".","");
		    		$updata['software_service'] = number_format($updata['order_price']*$userinfo->safety_service,3,".","");
		    		$updata['passageway_service'] = number_format($updata['order_price']*$merchant->service,3,".","");
		    		$updata['com_time'] = time();
		    		$updata['status'] = 2;
		    		//判断码商余额是否支持更改
		    		if($merchant->price >= number_format($updata['order_price'] - $updata['order_service'] - $updata['software_service'] + $updata['passageway_service'],3,".","")){
		    			$status = OrderModel::where('Id', $data['Id'])->update($updata);
		    			if($status){
		    				$order_redis = new Order_Redis;
		    				$admin_site = DB::table('admin_site')->first();
		    				//查询该订单
		    				$info = OrderModel::where('Id',$data['Id'])->with('user')->first()->toarray();
		    				//发送补发通知
	  			 			$postarr['form']['user_id'] = $info['user_id'];
  			 				$postarr['form']['order_id'] = $info['order_id'];
	                        $postarr['form']['apiorder_id'] = $info['apiorder_id'];
	                        $postarr['form']['amount'] = $info['order_money'];
	                        $postarr['form']['amount_actual'] = $info['order_price'];
	                        $postarr['form']['paytype'] = $info['type'];
	                        if ($info['remarks'] != "无") {
	                            $postarr['form']['remarks'] = $info['remarks'];
	                        }
	                        $postarr['form']['success_time'] =$info['com_time'];
	                        $postarr['form']['sign'] = getsign($postarr['form'],$info['user']['token']);
	                        $postarr['notify_url'] = $info['notify_url'];
	                        $postarr['number_notice'] = 2;
	                        //添加到Redis回调列表
	                        $redis_status = Redis::rpush('ordernotice',json_encode($postarr));
	                        if($redis_status){
	                        	/***先处理商户余额以及添加余额明细****/
                                $change_data['type'] = 1;
                                $change_data['user_id'] = $info['user_id'];
                                $change_data['amount'] = $info['order_price'] - $info['order_service'] - $info['software_service'];
                                $change_data['time'] = time();
                                $change_data['user_price'] = $userinfo->price + $change_data['amount'];
                                //再给商户加余额
                                $status = DB::table('user')->where('Id', $change_data['user_id'])->update(array(
                                    'price' => $change_data['user_price']
                                ));
                                if (!$status) {
                                	//记录加余额失败用户
                                    $amount_error_a['form']['apiorder_id'] = $info['apiorder_id'];
                                    $amount_error_a['form']['user_id'] = $change_data['user_id'];
                                    $amount_error_a['form']['amount'] = $change_data['amount'];
                                    $amount_error_a['type'] = 1001;
                                    Redis::rpush('order_amount_error',json_encode($amount_error_a));
                                }
                                //添加商户余额明细
                                $addstatus = DB::table('user_amount_change')->insert($change_data);
                                if (!$addstatus) {
                                    //记录加余额明细失败用户
                                    $amount_error_b['form'] = $change_data;
                                    $amount_error_b['type'] = 1002;
                                    Redis::rpush('order_amount_error',json_encode($amount_error_b));
                                }
                                /***再次处理码商余额以及添加余额明细****/
                                $change_datas['type'] = 1;
                                $change_datas['member_id'] = $info['member_id'];
                                $change_datas['amount'] = number_format($info['order_price'] - $info['order_service'] - $info['software_service'] + $info['passageway_service'],3,".","");
                                $change_datas['time'] = $change_data['time'];
                                $change_datas['member_price'] = $merchant->price - $change_datas['amount'];
                                //再给码商扣除余额
                                $merchantstatus = DB::table('member')->where('Id', $change_datas['member_id'])->update(array(
                                    'price' => $change_datas['member_price']
                                ));
                                if (!$merchantstatus) {
                                    //记录扣余额失败码商
                                    $amount_error_c['form']['apiorder_id'] = $info['apiorder_id'];
                                    $amount_error_c['form']['member_id'] = $change_datas['member_id'];
                                    $amount_error_c['form']['amount'] = $change_datas['amount'];
                                    $amount_error_c['type'] = 2001;
                                     Redis::rpush('order_amount_error',json_encode($amount_error_c));
                                }
                                //添加码商余额明细
                                $memberamountadd = DB::table('member_amount_change')->insert($change_datas);
                                if (!$memberamountadd) {
                                     //记录加余额明细失败码商
                                    $amount_error_d['form'] = $change_datas;
                                    $amount_error_d['type'] = 2002;
                                    Redis::rpush('order_amount_error',json_encode($amount_error_d));
                                }
                                //清除该二维码
                                $order_redis->delete($admin_site->payment_type,'alipay',$info['code_type'],array('key'=>$info['polling_passageway_key']));
                                $order_redis->delete($admin_site->payment_type,'aliwap',$info['code_type'],array('key'=>$info['polling_passageway_key']));
                                $order_redis->delete($admin_site->payment_type,'wechat',$info['code_type'],array('key'=>$info['polling_passageway_key']));
                                $order_redis->delete($admin_site->payment_type,'unionpay',$info['code_type'],array('key'=>$info['polling_passageway_key']));
                                //清除该二维码出码记录
	                            $order_redis->query_delete('alipay',$info['code_type'],$info['polling_passageway_key']);
	                            $order_redis->query_delete('aliwap',$info['code_type'],$info['polling_passageway_key']);
	                            $order_redis->query_delete('wechat',$info['code_type'],$info['polling_passageway_key']);
	                            $order_redis->query_delete('unionpay',$info['code_type'],$info['polling_passageway_key']);
	                            $payment = $info['code_type'] == 1 ? new DiepollingpaymentModel : new LivepollingpaymentModel;
	                            $typename = $info['code_type'] == 1 ? 'die' : 'live';
	                            $payment_info  = $payment->where('key',$info['polling_passageway_key'])->with('user','payment', 'merchant')->first();
	                            if($payment_info->merchant->price > 1 && $payment_info->merchant->frozen_amount >=0 && $payment_info->user->status == 1 && $payment_info->user->loop == 1 && $payment_info->gateway_state ==1){
			                        if($admin_site->payment_type == 1){
                                        if(stristr($payment_info->payment->paytype,'alipay') !== false){
                                            Redis::rpush('sort_alipay_'.$typename,json_encode($payment_info));
                                        }
                                        if(stristr($payment_info->payment->paytype,'aliwap') !== false){
                                            Redis::rpush('sort_aliwap_'.$typename,json_encode($payment_info));
                                        }
                                        if(stristr($payment_info->payment->paytype,'wechat') !== false){
                                            Redis::rpush('sort_wechat_'.$typename,json_encode($payment_info));
                                        }
                                        if(stristr($payment_info->payment->paytype,'unionpay') !== false){
                                            Redis::rpush('sort_unionpay_'.$typename,json_encode($payment_info));
                                        }
                                    }else{
                                        if(stristr($payment_info->payment->paytype,'alipay') !== false){
                                            Redis::sadd('random_alipay_'.$typename,json_encode($payment_info));
                                        }
                                        if(stristr($payment_info->payment->paytype,'aliwap') !== false){
                                            Redis::sadd('random_aliwap_'.$typename,json_encode($payment_info));
                                        }
                                        if(stristr($payment_info->payment->paytype,'wechat') !== false){
                                            Redis::sadd('random_wechat_'.$typename,json_encode($payment_info));
                                        }
                                        if(stristr($payment_info->payment->paytype,'unionpay') !== false){
                                            Redis::sadd('random_unionpay_'.$typename,json_encode($payment_info));
                                        }
                                    }
						        }
                                $json['status'] = "ok";
                                $json['msg'] = "订单修改成功,已自动补单";
	                        }
		    			}else{
		    				$json['status'] = "error";
		    				$json['msg'] = "当前无更改,修改失败";
		    			}
		    		}else{
		    			$json['status'] = "error";
		    			$json['msg'] = "当前码商可用余额不足";
		    		}
		    	}else{
		    		$json['status'] = "error";
		    		$json['msg'] = "订单实付不能小于0.01";
		    	}
		    }else if($arr->input('action') == 'notice'){
		    	//补发通知
		    	$data = $arr->input('form');
		    	if(is_array($data)){
		    		$num = 0;
		    		foreach ($data as $k => $v) {
		    			$infoarr[$k] = OrderModel::where('Id', $v)->with('user')->first()->toarray();
		  			 		if($infoarr[$k] && $infoarr[$k]['status'] == 2){
		  			 			//发送补发通知
		  			 			$postarr['form']['user_id'] = $infoarr[$k]['user_id'];
	  			 				$postarr['form']['order_id'] = $infoarr[$k]['order_id'];
		                        $postarr['form']['apiorder_id'] = $infoarr[$k]['apiorder_id'];
		                        $postarr['form']['amount'] = $infoarr[$k]['order_money'];
		                        $postarr['form']['amount_actual'] = $infoarr[$k]['order_price'];
		                        $postarr['form']['paytype'] = $infoarr[$k]['type'];
		                        if ($infoarr[$k]['remarks'] != "无") {
		                            $postarr['form']['remarks'] = $infoarr[$k]['remarks'];
		                        }
		                        $postarr['form']['success_time'] =$infoarr[$k]['com_time'];
		                        $postarr['form']['sign'] = getsign($postarr['form'],$infoarr[$k]['user']['token']);
		                        $postarr['notify_url'] = $infoarr[$k]['notify_url'];
		                        $postarr['number_notice'] = 2;
		                        //添加到Redis回调列表
		                        $redis_status = Redis::rpush('ordernotice',json_encode($postarr));
		                        if($redis_status){
		                        	$num++;
		                        }
		  			 		}
		    		}
		    		if($num!=0){
	  			 		$json['status']="ok";
	  			 		$json['msg']="成功补发通知{$num}个,已自动添加通知任务";
		  			}else{
		  				$json['status']="error";
		  				$json['msg']="操作失败,当前订单无订单支付成功";
		  			}
		    	}else{
		    		$json['status'] = "error";
		    		$json['msg'] = "不安全的提交方式";
		    	}
		    }else if($arr->input('action') == 'repair'){
		    	//补单
		    	$data = $arr->input('form');
		    	if(is_array($data)){
		    		$num = 0;
		    		foreach ($data as $k => $v) {
		    			$v = (array)$v;
		    			//查询码商余额及冻结金额
				  	    $merchant = DB::table('member')->where('Id',$v['member_id'])->first();
		  			 	if($merchant->price >= number_format($v['order_price'] - $v['order_service'] - $v['software_service'] + $v['passageway_service'],3,".","")){
		  			 		$infoarr[$k] = OrderModel::where('Id', $v)->with('user')->first()->toarray();
		  			 		if($infoarr[$k] && $infoarr[$k]['status'] != 2){
			  			 		$status = OrderModel::where('Id',$v['Id'])->update(array('status'=>2,'com_time'=>time()));
			  			 		if($status){
			  			 			$num++;
			  			 			//发送补发通知
			  			 			$postarr['form']['user_id'] = $infoarr[$k]['user_id'];
		  			 				$postarr['form']['order_id'] = $infoarr[$k]['order_id'];
			                        $postarr['form']['apiorder_id'] = $infoarr[$k]['apiorder_id'];
			                        $postarr['form']['amount'] = $infoarr[$k]['order_money'];
			                        $postarr['form']['amount_actual'] = $infoarr[$k]['order_price'];
			                        $postarr['form']['paytype'] = $infoarr[$k]['type'];
			                        if ($infoarr[$k]['remarks'] != "无") {
			                            $postarr['form']['remarks'] = $infoarr[$k]['remarks'];
			                        }
			                        $postarr['form']['success_time'] =$infoarr[$k]['com_time'];
			                        $postarr['form']['sign'] = getsign($postarr['form'],$infoarr[$k]['user']['token']);
			                        $postarr['notify_url'] = $infoarr[$k]['notify_url'];
			                        $postarr['number_notice'] = 2;
			                        //添加到Redis回调列表
			                        $redis_status = Redis::rpush('ordernotice',json_encode($postarr));
			                        if($redis_status){
			                        	/***先处理商户余额以及添加余额明细****/
                                        $change_data['type'] = 1;
                                        $change_data['user_id'] = $infoarr[$k]['user_id'];
                                        $change_data['amount'] = $infoarr[$k]['order_price'] - $infoarr[$k]['order_service'] - $infoarr[$k]['software_service'];
                                        $change_data['time'] = time();
                                        //先获取商户原余额
                                        $price = DB::table('user')->where('Id', $infoarr[$k]['user_id'])->first()->price;
                                        $change_data['user_price'] = $price + $change_data['amount'];
                                        //再给商户加余额
                                        $status = DB::table('user')->where('Id', $change_data['user_id'])->update(array(
                                            'price' => $change_data['user_price']
                                        ));
                                        if (!$status) {
                                           //记录加余额失败用户
		                                    $amount_error_a['form']['apiorder_id'] = $info['apiorder_id'];
		                                    $amount_error_a['form']['user_id'] = $change_data['user_id'];
		                                    $amount_error_a['form']['amount'] = $change_data['amount'];
		                                    $amount_error_a['type'] = 1001;
		                                    Redis::rpush('order_amount_error',json_encode($amount_error_a));
                                        }
                                        //添加商户余额明细
                                        $addstatus = DB::table('user_amount_change')->insert($change_data);
                                        if (!$addstatus) {
                                            //记录加余额明细失败用户
		                                    $amount_error_b['form'] = $change_data;
		                                    $amount_error_b['type'] = 1002;
		                                    Redis::rpush('order_amount_error',json_encode($amount_error_b));
                                        }
                                        /***再次处理码商余额以及添加余额明细****/
                                        $change_datas['type'] = 1;
                                        $change_datas['member_id'] = $infoarr[$k]['member_id'];
                                        $change_datas['amount'] = number_format($infoarr[$k]['order_price'] - $infoarr[$k]['order_service'] - $infoarr[$k]['software_service'] + $v['passageway_service'],3,".","");
                                        $change_datas['time'] = $change_data['time'];
                                        //先获取码商原余额
                                        $price = DB::table('member')->where('Id', $infoarr[$k]['member_id'])->first()->price;
                                        $change_datas['member_price'] = $price - $change_datas['amount'];
                                        //再给码商扣除余额
                                        $merchantstatus = DB::table('member')->where('Id', $change_datas['member_id'])->update(array(
                                            'price' => $change_datas['member_price']
                                        ));
                                        if (!$merchantstatus) {
                                            //记录扣余额失败码商
		                                    $amount_error_c['form']['apiorder_id'] = $info['apiorder_id'];
		                                    $amount_error_c['form']['member_id'] = $change_datas['member_id'];
		                                    $amount_error_c['form']['amount'] = $change_datas['amount'];
		                                    $amount_error_c['type'] = 2001;
		                                     Redis::rpush('order_amount_error',json_encode($amount_error_c));
                                        }
                                        //添加码商余额明细
                                        $memberamountadd = DB::table('member_amount_change')->insert($change_datas);
                                        if (!$memberamountadd) {
                                            //记录加余额明细失败码商
		                                    $amount_error_d['form'] = $change_datas;
		                                    $amount_error_d['type'] = 2002;
		                                    Redis::rpush('order_amount_error',json_encode($amount_error_d));
                                        }
			                        }
			  			 		}
			  			 	}
		  			 	}else{
		  			 		break;
		  			 		return array('status'=>'error','msg'=>"当前码商可用余额不足,已成功补单{$num}个");
		  			 	}
		    		}
		    		if($num!=0){
	  			 		$json['status']="ok";
	  			 		$json['msg']="成功补单{$num}个,已自动添加通知任务";
		  			}else{
		  				$json['status']="error";
		  				$json['msg']="操作失败,当前订单已支付成功或码商可用余额不足";
		  			}
		    	}else{
		    		$json['status'] = "error";
		    		$json['msg'] = "请提交正确的方式";
		    	}
		    }else if($arr->input('action') == 'del'){
				$data = $arr->input('form');
				if(is_array($data)){
					foreach($data as $k => $v){
						$v = (array)$v;
						if($v['status'] != 1){
							if($k < 1){
								$deldata[]=['Id','=',$v['Id']];
							}else{
								$deldata[]=['Id','=',$v['Id'],'or'];
							}
						}
					}
					$num = DB::table('order')->where($deldata)->delete();
					if($num == 0){
						$json['status'] = "error";
						$json['msg'] = "删除失败,当前有订单正在交易";
					}else{
						$json['status'] = "ok";
						$json['msg'] = "删除成功,共删除{$num}条";
					}
				}else{
					$json['status']="error";
					$json['msg']="提交出现错误,请刷新重试";
				}
			}else{
				$json['status']="error";
				$json['msg']="不安全的提交方式";
			}
		    return $json;
		}
		return view('admin/order_record');
	}

	/****后台码商充值记录****/
	public function merchant_recharge(Request $arr){
		if($arr->isMethod('post')){
			if($arr->has('page')){
				if($arr->filled('field') && $arr->filled('value') && $arr->input('field')!= '-1'){
					if($arr->input('field') == 'amount'){
						$map[]=[$arr->input('field'),'='.$arr->input('value')];
					}else{
						$map[]=[$arr->input('field'),'like','%'.$arr->input('value').'%'];
					}
				}

				if($arr->has('status') && !empty($arr->input('status')) && $arr->input('status')!='-1'){
			  		$map['status']=$arr->input('status');
			  	}else{
			  		$map[]=['status','!=',null];
			  	}
			  	if($arr->has('type') && !empty($arr->input('type')) && $arr->input('type')!='-1'){
			  		$map['type']=$arr->input('type');
			  	}

				if($arr->filled('time') && is_array($arr->input('time'))){
					$time=$arr->input('time');
					if(!empty($time[0]) && !empty($time[1])){
						$map[]=['sub_time','>=',strtotime($time[0])];
		       	  		$map[]=['sub_time','<',strtotime($time[1])+86400];
					}
				}
				$listpage=DB::table('member_pay')->where($map)->orderBy('id','desc')->paginate(15)->toarray();
				$json['data']['toptext']['count'] = 0;
				$json['data']['toptext']['success_count'] = 0;
				$json['data']['toptext']['money'] = 0;
				if($listpage['total'] >= 1){
	       	  		$data=$listpage['data'];
	       	  		foreach ($data as $k => $v) {
	       	  			$v=(array)$v;
	       	  			$v['time']=date('Y-m-d H:i:s',$v['sub_time']);
	       	  			$json['data']['list'][]=$v;
	       	  		}
	       	  	}else{
	       	  		$json['data']['list']=[];
	       	  	}
	       	  	$json['current_page']=$listpage['current_page'];
			   	$json['total']=$listpage['total'];
			   	$json['status']="ok";
			}else if($arr->input('action') == 'del'){
				$data = $arr->input('form');
				if(is_array($data)){
					foreach($data as $k => $v){
						$v = (array)$v;
						if($k < 1){
							$deldata[]=['Id','=',$v['Id']];
						}else{
							$deldata[]=['Id','=',$v['Id'],'or'];
						}
					}
					$num = DB::table('member_log')->where($deldata)->delete();
					if($num == 0){
						$json['status'] = "error";
						$json['msg'] = "删除失败,出现错误";
					}else{
						$json['status'] = "ok";
						$json['msg'] = "删除成功,共删除{$num}条";
					}
				}else{
					$json['status']="error";
					$json['msg']="提交出现错误,请刷新重试";
				}
			}else if($arr->input('action') == 'notice'){
				//补发通知
		    	$data = $arr->input('form');
		    	if(is_array($data)){
		    		$num = 0;
		    		foreach ($data as $k => $v) {
		    			$infoarr[$k] = OrderModel::where('Id', $v)->with('user')->first()->toarray();
		  			 		if($infoarr[$k] && $infoarr[$k]['status'] == 2){
		  			 			//发送补发通知
		  			 			$postarr['form']['user_id'] = $infoarr[$k]['user_id'];
	  			 				$postarr['form']['order_id'] = $infoarr[$k]['order_id'];
		                        $postarr['form']['apiorder_id'] = $infoarr[$k]['apiorder_id'];
		                        $postarr['form']['amount'] = $infoarr[$k]['order_money'];
		                        $postarr['form']['amount_actual'] = $infoarr[$k]['order_price'];
		                        $postarr['form']['paytype'] = $infoarr[$k]['type'];
		                        if ($infoarr[$k]['remarks'] != "无") {
		                            $postarr['form']['remarks'] = $infoarr[$k]['remarks'];
		                        }
		                        $postarr['form']['success_time'] =$infoarr[$k]['com_time'];
		                        $postarr['form']['sign'] = getsign($postarr['form'],$infoarr[$k]['user']['token']);
		                        $postarr['notify_url'] = $infoarr[$k]['notify_url'];
		                        $postarr['number_notice'] = 2;
		                        //添加到Redis回调列表
		                        $redis_status = Redis::rpush('ordernotice',json_encode($postarr));
		                        if($redis_status){
		                        	$num++;
		                        }
		  			 		}
		    		}
		    		if($num!=0){
	  			 		$json['status']="ok";
	  			 		$json['msg']="成功补发通知{$num}个,已自动添加通知任务";
		  			}else{
		  				$json['status']="error";
		  				$json['msg']="处理失败,当前订单无订单支付成功";
		  			}
		    	}else{
		    		$json['status'] = "error";
		    		$json['msg'] = "不安全的提交方式";
		    	}
			}else{
				$json['status']="error";
				$json['msg']="不安全的提交方式";
			}
			return $json;
		}
		return view('admin/merchant_recharge');
	}

	/****后台提现记录****/
	public function drawing(Request $arr){
		if($arr->isMethod('post')){
			if($arr->has('page')){
				  $data=$arr->all();
				if($arr->filled('status') && $arr->input('status')!= '-1' ){
					$map['status']=$arr->input('status');
				}else{
					$map[]=['status','!=',null];
				}

				if($arr->filled('time') && is_array($arr->input('time'))){
					$time=$arr->input('time');
					if(!empty($time[0]) && !empty($time[1])){
						$map[]=['sub_time','>=',strtotime($time[0])];
		       	  		$map[]=['sub_time','<',strtotime($time[1])+86400];
					}
				}
				if($arr->filled('field') && $arr->filled('value') && $arr->input('field')!= '-1'){
					if($arr->input('field') == 'money'){
						$map[]=[$arr->input('field'),'='.$arr->input('value')];
					}else{
						$map[]=[$arr->input('field'),'like','%'.$arr->input('value').'%'];
					}
				}
				$listpage=DrawingModel::where($map)->with('bank')->orderBy('id','desc')->paginate(15)->toarray();
				$json['data']['toptext']['money_total'] = DrawingModel::where($map)->sum('money');
				$map['status'] = 1;
				$json['data']['toptext']['success_money'] = DrawingModel::where($map)->sum('money');
				$json['data']['toptext']['service'] = DrawingModel::where($map)->sum('service');
				$json['data']['toptext']['lncome'] =  $json['data']['toptext']['service'];
				if($listpage['total'] >= 1){
	       	  		$data=$listpage['data'];
	       	  		foreach ($data as $k => $v) {
	       	  			$v=(array)$v;
	       	  			$v['time']=date('Y-m-d H:i:s',$v['sub_time']);
	       	  			$v['name'] = $v['bank']['name'];
	       	  			$v['bank_card'] = $v['bank']['bank_card'];
	       	  			$v['bank_type'] = $v['bank']['bank_type'];
	       	  			$v['mode'] = $v['bank']['bank_type'] == "支付宝" ? 2 : 1;
	       	  			$v['money_actual']= number_format($v['money'] - $v['service'],2,".","");
	       	  			$json['data']['list'][]=$v;
	       	  		}
	       	  	}else{
	       	  		$json['data']['list']=[];
	       	  	}
	       	  	$json['current_page']=$listpage['current_page'];
			   	$json['total']=$listpage['total'];
			   	$json['status']="ok";
			}else if($arr->input('action') == 'result'){
				$data = $arr->input('form');
				$num = 0;
				if(is_array($data)){
					//批量处理提现
					foreach($data as $k => $v){
						$v = (array)$v;
						if($v['status'] == 2){
							if($v['mode'] == 2){
								//支付宝一键打款
								$Alipay = new Alipay;
								$ali_return = $Alipay->toTransfer(date('YmdHis',time()).rand(10000,99999),$v['bank_card'],$v['money_actual'],$v['name']);
								if($ali_return['code'] == 10000){
									//修改该提现为成功
									$status = DB::table('user_drawing')->where('Id',$v['Id'])->update(array('com_time'=>time(),'status'=>1));
									if($status){
										$num++;
									}
								}else{
									return array('status'=>'error','msg'=>$ali_return['msg']);exit;
								}
							}else{
								//修改该提现为成功
								$status = DB::table('user_drawing')->where('Id',$v['Id'])->update(array('com_time'=>time(),'status'=>1));
								if($status){
									$num++;
								}
							}
						}
					}
					if($num == 0){
						$json['status']="error";
						$json['msg']="出现错误,打款失败";
					}else{
						$json['status']="ok";
						$json['msg']="已成功打款{$num}个";
					}
				}else{
					$json['status']="error";
					$json['msg']="提交出现错误,请刷新重试";
				}
			}else if($arr->input('action') == 'reject'){
				$data = $arr->input('form');
				$num = 0;
				if(is_array($data)){
					//批量驳回提现
					foreach($data as $k => $v){
						$v = (array)$v;
						if($v['status'] == 2){
							//修改该提现为驳回处理
							$status = DB::table('user_drawing')->where('Id',$v['Id'])->update(array('com_time'=>time(),'status'=>3));
							if($status){
								$num++;
								//添加余额明细
								$userprice = DB::table('user')->where('Id',$v['user_id'])->first()->price + $v['money'];
								$amount_change['type'] = 3;
								$amount_change['user_id'] = $v['user_id'];
								$amount_change['amount'] = $v['money'];
								$amount_change['user_price'] = $userprice;
								$amount_change['time'] = time();
								DB::table('user_amount_change')->insert($amount_change);
								//修改商户余额
								DB::table('user')->where('Id',$v['user_id'])->update(array('price'=>$userprice));
							}
						}
					}
					if($num == 0){
						$json['status']="error";
						$json['msg']="出现错误,驳回处理失败";
					}else{
						$json['status']="ok";
						$json['msg']="已成功驳回{$num}个";
					}
				}else{
					$json['status']="error";
					$json['msg']="提交出现错误,请刷新重试";
				}
			}else if($arr->input('action') == 'del'){
				$data = $arr->input('form');
				if(is_array($data)){
					foreach($data as $k => $v){
						$v = (array)$v;
						if($k < 1){
							$deldata[]=['Id','=',$v['Id']];
						}else{
							$deldata[]=['Id','=',$v['Id'],'or'];
						}
					}
					$num = DrawingModel::where($deldata)->delete();
					if($num == 0){
						$json['status'] = "error";
						$json['msg'] = "删除失败,出现错误";
					}else{
						$json['status'] = "ok";
						$json['msg'] = "删除成功,共删除{$num}条";
					}
				}else{
					$json['status']="error";
					$json['msg']="提交出现错误,请刷新重试";
				}
			}else{
				$json['status']="error";
				$json['msg']="不安全的提交方式";
			}
			return $json;
		}
		return view('admin/drawing');
	}

	/****后台连续失败码队列****/
	public function code_error(Request $arr){
		if($arr->isMethod('post')){
			if($arr->has('page')){
				if($arr->filled('field') && $arr->filled('value') && $arr->input('field')!= '-1'){
					$map[$arr->input('field')]=$arr->input('value');
				}else{
					$map[]=['time','!=',null];
				}
				if($arr->filled('time') && is_array($arr->input('time'))){
					$time=$arr->input('time');
					if(!empty($time[0]) && !empty($time[1])){
						$map[]=['time','>=',strtotime($time[0])];
		       	  		$map[]=['time','<',strtotime($time[1])+86400];
					}
				}
				$listpage=QrcodeErrorModel::where($map)->with(['diepay','livepay'])->orderBy('id','desc')->paginate(15)->toarray();
				if($listpage['total'] >= 1){
	       	  		$data=$listpage['data'];
	       	  		foreach ($data as $k => $v) {
	       	  			$v=(array)$v;
	       	  			$v['payment_name'] = !empty($v['diepay']) ? $v['diepay']['name'] : $v['livepay']['name'];
	       	  			$v['qrcode'] = !empty($v['qrcode']) ? "data:image/png;base64,".base64_encode(QrCode::format('png')->size(100)->margin(0)->generate($v['qrcode'])) : '';
	       	  			$v['time']=date('Y-m-d H:i:s',$v['time']);
	       	  			$json['data']['list'][]=$v;
	       	  		}
	       	  	}else{
	       	  		$json['data']['list']=[];
	       	  	}
	       	  	$json['current_page']=$listpage['current_page'];
			   	$json['total']=$listpage['total'];
			   	$json['status']="ok";
			}else if($arr->input('action') == 'del'){
				$data = $arr->input('form');
				if(is_array($data)){
					foreach($data as $k => $v){
						$v = (array)$v;
						if($k < 1){
							$deldata[]=['Id','=',$v['Id']];
						}else{
							$deldata[]=['Id','=',$v['Id'],'or'];
						}
					}
					$num = DB::table('qrcode_error')->where($deldata)->delete();
					if($num == 0){
						$json['status'] = "error";
						$json['msg'] = "删除失败,出现错误";
					}else{
						$json['status'] = "ok";
						$json['msg'] = "删除成功,共删除{$num}条";
					}
				}else{
					$json['status']="error";
					$json['msg']="提交出现错误,请刷新重试";
				}
			}else if($arr->input('action') == 'open'){
				$data = $arr->input('form')[0];
				$payment = $data['code_type'] == 1 ? new DiepollingpaymentModel : new LivepollingpaymentModel;
				$status = $payment->where('key',$data['key'])->update(array('gateway_state'=>1));
				if($status){
					//判断平台出码方式
                    $admin_site=DB::table('admin_site')->first();
                    $order_redis = new Order_Redis;
                    $order_redis_info = $payment->where(array('key'=>$data['key']))->with('user','payment','merchant')->first();
                    $typename = $data['code_type'] == 1 ? 'die' : 'live';
                    if($order_redis_info->merchant->price >1 && $order_redis_info->user->loop == 1 && $order_redis_info->merchant->frozen_amount >= 0 && $order_redis_info->user->status == 1){
                    	//添加到Redis
                        if($admin_site->payment_type == 1){
                            if(stristr($order_redis_info->payment->paytype,'alipay') !== false){
                                Redis::rpush('sort_alipay_'.$typename,json_encode($order_redis_info));
                            }
                            if(stristr($order_redis_info->payment->paytype,'aliwap') !== false){
                                Redis::rpush('sort_aliwap_'.$typename,json_encode($order_redis_info));
                            }
                            if(stristr($order_redis_info->payment->paytype,'wechat') !== false){
                                Redis::rpush('sort_wechat_'.$typename,json_encode($order_redis_info));
                            }
                            if(stristr($order_redis_info->payment->paytype,'unionpay') !== false){
                                Redis::rpush('sort_unionpay_'.$typename,json_encode($order_redis_info));
                            }
                        }else{
                            if(stristr($order_redis_info->payment->paytype,'alipay') !== false){
                                Redis::sadd('random_alipay_'.$typename,json_encode($order_redis_info));
                            }
                            if(stristr($order_redis_info->payment->paytype,'aliwap') !== false){
                                Redis::sadd('random_aliwap_'.$typename,json_encode($order_redis_info));
                            }
                            if(stristr($order_redis_info->payment->paytype,'wechat') !== false){
                                Redis::sadd('random_wechat_'.$typename,json_encode($order_redis_info));
                            }
                            if(stristr($order_redis_info->payment->paytype,'unionpay') !== false){
                                Redis::sadd('random_unionpay_'.$typename,json_encode($order_redis_info));
                            }
                        }
                    }
                    $json['status'] = "ok";
                    $json['msg'] = "开启网关成功";
                    //删除当前记录
                    DB::table('qrcode_error')->where('Id',$data['Id'])->delete();
				}else{
					$json['status'] = "error";
                    $json['msg'] = "当前通道网关已开启过,请自行清除记录";
				}
			}else{
				$json['status']="error";
				$json['msg']="不安全的提交方式";
			}
			return $json;
		}

		return view('admin/code_error');
	}
	/****后台固码通道列表****/
	public function diecode(Request $arr){
		if($arr->isMethod('post')){
			if($arr->has('page')){
				$map[]=['status','!=',null];
				$listpage=DB::table('die_passageway')->where($map)->orderBy('id','desc')->paginate(15)->toarray();
				if($listpage['total'] >= 1){
	       	  		$data=$listpage['data'];
	       	  		foreach ($data as $k => $v) {
	       	  			$v=(array)$v;
	       	  			$v['type'] = explode(",",$v['paytype']);
	       	  			$v['paytype']=getpassageway($v['paytype']);
	       	  			$json['data']['list'][]=$v;
	       	  		}
	       	  	}else{
	       	  		$json['data']['list']=[];
	       	  	}
	       	  	$json['current_page']=$listpage['current_page'];
			   	$json['total']=$listpage['total'];
			   	$json['status']="ok";
			}else if($arr->input('action') == 'edit'){
				//修改通道
				$data = $arr->input('form');
				if(!empty($data['Id'])){
					if(!empty($data['type'])){
						if(!empty($data['order_exptime'])){
							if(intval($data['order_exptime']) > 200 && intval($data['order_exptime'])<1000){
								$updata['order_exptime'] = $data['order_exptime'];
							}else{
								$json['status'] = "error";
								$json['msg'] =  "订单有效时间最低大于200,最高小于1000";
							}
						}
						if(!isset($json)){
							$updata['paytype']='';
							foreach ($data['type'] as $v) {
								$updata['paytype'].=$v.',';
							}
							$updata['paytype']=rtrim($updata['paytype'],",");
							$status = DB::table('die_passageway')->where('Id',$data['Id'])->update($updata);
							if($status){
								$json['status'] = "ok";
								$json['msg'] = "修改成功";
							}else{
								$json['status'] = "error";
								$json['msg'] = "当前无更改,修改失败";
							}
						}
					}else{
						$json['status'] = "error";
						$json['msg'] = "支持的支付方式最少为一种";
					}
				}else{
					$json['status'] = "error";
					$json['msg'] = "不安全的提交方式";
				}
			}else if($arr->input('action') == 'open'){
				$data = $arr->input('form');
				$status = DB::table('die_passageway')->where('Id',$data['Id'])->update(array('status'=>1));
				if($status){
					$json['status'] = "ok";
					$json['msg'] = "恢复成功";
				}else{
					$json['status'] = "error";
					$json['msg'] = "当前无更改,修改失败";
				}
			}else if($arr->input('action') == 'close'){
				$data = $arr->input('form');
				$status = DB::table('die_passageway')->where('Id',$data['Id'])->update(array('status'=>2));
				if($status){
					$json['status'] = "ok";
					$json['msg'] = "暂停成功";
				}else{
					$json['status'] = "error";
					$json['msg'] = "当前无更改,修改失败";
				}
			}else{
				$json['status']="error";
				$json['msg']="不安全的提交方式";
			}
			return $json;
		}
		return view('admin/diecode');
	}

	/****后台活码通道列表****/
	public function livecode(Request $arr){
		if($arr->isMethod('post')){
			if($arr->has('page')){
				$map[]=['status','!=',null];
				$listpage=DB::table('live_passageway')->where($map)->orderBy('id','desc')->paginate(15)->toarray();
				if($listpage['total'] >= 1){
	       	  		$data=$listpage['data'];
	       	  		foreach ($data as $k => $v) {
	       	  			$v=(array)$v;
	       	  			$v['type'] = explode(",",$v['paytype']);
	       	  			$v['paytype']=getpassageway($v['paytype']);
	       	  			$json['data']['list'][]=$v;
	       	  		}
	       	  	}else{
	       	  		$json['data']['list']=[];
	       	  	}
	       	  	$json['current_page']=$listpage['current_page'];
			   	$json['total']=$listpage['total'];
			   	$json['status']="ok";
			}else if($arr->input('action') == 'open'){
				$data = $arr->input('form');
				$status = DB::table('live_passageway')->where('Id',$data['Id'])->update(array('status'=>1));
				if($status){
					$json['status'] = "ok";
					$json['msg'] = "恢复成功";
				}else{
					$json['status'] = "error";
					$json['msg'] = "当前无更改,修改失败";
				}
			}else if($arr->input('action') == 'close'){
				$data = $arr->input('form');
				$status = DB::table('live_passageway')->where('Id',$data['Id'])->update(array('status'=>2));
				if($status){
					$json['status'] = "ok";
					$json['msg'] = "暂停成功";
				}else{
					$json['status'] = "error";
					$json['msg'] = "当前无更改,修改失败";
				}
			}else if($arr->input('action') == 'edit'){
				//修改通道
				$data = $arr->input('form');
				if(!empty($data['Id'])){
					if(!empty($data['type'])){
						if(!empty($data['order_exptime'])){
							if(intval($data['order_exptime']) > 200 && intval($data['order_exptime'])<1000){
								$updata['order_exptime'] = $data['order_exptime'];
							}else{
								$json['status'] = "error";
								$json['msg'] =  "订单有效时间最低大于200,最高小于1000";
							}
						}
						if(!empty($data['return_time'])){
							if(intval($data['return_time']) > 1 || intval($data['return_time'])<10){
								$updata['return_time'] = $data['return_time'];
							}else{
								$json['status'] = "error";
								$json['msg'] =  "同步返回时间最低为1,最高小于10";
							}
						}
						if(!isset($json)){
							$updata['paytype']='';
							foreach ($data['type'] as $v) {
								$updata['paytype'].=$v.',';
							}
							$updata['paytype']=rtrim($updata['paytype'],",");
							$status = DB::table('live_passageway')->where('Id',$data['Id'])->update($updata);
							if($status){
								$json['status'] = "ok";
								$json['msg'] = "修改成功";
							}else{
								$json['status'] = "error";
								$json['msg'] = "当前无更改,修改失败";
							}
						}
					}else{
						$json['status'] = "error";
						$json['msg'] = "支持的支付方式最少为一种";
					}
				}else{
					$json['status'] = "error";
					$json['msg'] = "不安全的提交方式";
				}
			}else{
				$json['status']="error";
				$json['msg']="不安全的提交方式";
			}
			return $json;
		}
		return view('admin/livecode');
	}

	/****后台统计页面******/
	public function statistics(Request $arr){
		if($arr->isMethod('post')){
			if($arr->input('action') == 'chart'){
				/***查询平台总提交金额****/
				$json['toptext']['count_money'] = DB::table('order')->sum('order_money');
				/****总提交订单****/
				$json['toptext']['count_order'] = DB::table('order')->count();
				/****总支付金额****/
				$json['toptext']['count_success_money'] = DB::table('order')->where('status',2)->sum('order_price');
				/****总支付订单****/
				$json['toptext']['count_success_order'] = DB::table('order')->where('status',2)->count();
				/****总订单平台盈利*****/
				$json['toptext']['count_lncome'] = DB::table('order')->where('status',2)->sum('passageway_service');
				/****提现总盈利****/
				$json['toptext']['cash_lncome'] = DB::table('user_drawing')->where('status',1)->sum('service');
				$week = !empty($arr->input('time')) ? getweek('',$arr->input('time')) : getweek();
                foreach ($week as $k => $v) {
                    $map[$k][] = ['sub_time', '>=', $v['time']];
                    $map[$k][] = ['sub_time', '<', $v['time'] + 86400];
                    /****遍历查询每日提交订单数****/
                    $json['data'][$k]['日期'] = $v['date'];
                    $json['data'][$k]['提交订单'] = DB::table('order')->where($map[$k])->count();
                    /****遍历查询每日提交订单金额****/
                    $json['data'][$k]['提交金额'] = DB::table('order')->where($map[$k])->sum('order_money');
                    /****遍历查询每日成功订单数****/
                    $map[$k]['status'] = 2;
                    $json['data'][$k]['成功订单'] = DB::table('order')->where($map[$k])->count();
                    /****遍历查询每日成功订单金额****/
                    $json['data'][$k]['成功金额'] = DB::table('order')->where($map[$k])->sum('order_price');
                    $json['data'][$k]['发放金额'] =  $json['data'][$k]['成功金额'] - DB::table('order')->where($map[$k])->sum('passageway_service');
                    $json['data'][$k]['平台盈利'] = DB::table('order')->where($map[$k])->sum('passageway_service');

                }
			}
			return $json;
		}
		return view('admin/statistics');
	}

	/****后台系统设置****/
	public function site(Request $arr){
		if($arr->isMethod('post')){
			if($arr->input('action') == 'ajax'){
				$info = DB::table('admin')->first();
				$json['data'] = DB::table('admin_site')->first();
				$json['data']->safety = $info->safety == 1 ? true : false;
				$json['data']->payment_type = $json['data']->payment_type == 1 ? true : false;
				$ga = new Google;
				$json['data']->safetycode = !empty($info->safetycode) ? $info->safetycode : $ga->createSecret();
                $url = $ga->getQRCodeGoogleUrl('YM_Pay',$json['data']->safetycode);
                $json['data']->safety_qrcode = "data:image/png;base64,".base64_encode(QrCode::format('png')->size(200)->margin(1)->generate($url));
			}else if($arr->input('action') == 'edit'){
				$data = $arr->input('form');
				$info = DB::table('admin')->first();
                if($info->safety == 1){
                   //验证谷歌验证码是否正确
                    if(!empty($data['code'])){
                        $ga = new Google;
                        $checkResult = $ga->verifyCode($info->safetycode,trim($data['code']),2);
                        if(!$checkResult){
                            $json['status'] = "error";
                            $json['msg'] = "当前谷歌验证码错误";
                        }
                    }else{
                        $json['status']= "error";
                        $json['msg'] = "请输入谷歌验证码";
                    }
                }
				if(!isset($json)){
					unset($data['code']);
					unset($data['safety']);
					unset($data['safetycode']);
					unset($data['safety_qrcode']);
					if((float)$data['order_min'] < 1){
						$json['status'] = "error";
						$json['msg'] = "最小订单金额不能低于1元";
					}

					if((float)$data['order_max'] > 10000){
						$json['status'] = "error";
						$json['msg'] = "最大订单金额不能高于10000元";
					}

					if((float)$data['order_amount_float'] > 1 || (float)$data['order_amount_float'] < '-1'){
						$json['status'] = "error";
						$json['msg'] = "金额浮动在-1或1之间";
					}

					$data['payment_type'] = $data['payment_type'] === true ? 1 : 2;
					if(!empty($data['pay_user_id'])){
						if(!DB::table('user')->where('Id',$data['pay_user_id'])->first()){
							$json['status'] = "error";
							$json['msg'] = "当前配置商户不存在";
						}
					}
					if(!empty($data['pay_merchant_key'])){
						if(!DB::table('member')->where('apikey',$data['pay_merchant_key'])->first()){
							$json['status'] = "error";
							$json['msg'] = "当前配置码商不存在";
						}
					}
					$data['reg_sms_status'] = "false";
					if(!isset($json)){
						$status = DB::table('admin_site')->update($data);
						if($status){
							(new Order_redis())->move($data['payment_type']);
							$json['status'] = "ok";
							$json['msg'] = "修改成功";
						}else{
							$json['status'] = "error";
							$json['msg'] = "当前无更改,修改失败";
						}
					}
				}
			}else if($arr->input('action') == 'open'){
				if($arr->filled('code')){
					$status = DB::table('admin')->update(array('safetycode'=>$arr->input('code'),'safety'=>1));
					if($status){
						$json['status'] = "ok";
					}else{
						$json['status'] = "error";
					}
				}
			}
			return $json;
		}
		return view('admin/site');
	}

	/****后台码商设置****/
	public function merchantsite(Request $arr){
		if($arr->isMethod('post')){
			if($arr->input('action') == 'ajax'){
				$json['data'] = DB::table('admin_member_site')->first();
				$json['data']->service = $json['data']->service*100;
			}else if($arr->input('action') == 'edit'){
				$data = $arr->input('form');
				if((float)$data['service'] <=  0){
					$json['status'] = "error";
					$json['msg'] = "码商费率不能为0";
				}else{
					$data['service'] = $data['service']/100;
				}
				if((float)$data['diepolling_max'] < 0){
					$json['status'] = "error";
					$json['msg'] = "固码账号个数不能小于0";
				}
				if((float)$data['livepolling_max'] < 0){
					$json['status'] = "error";
					$json['msg'] = "活码账号个数不能小于0";
				}

				if((float)$data['price'] < 0){
					$json['status'] = "error";
					$json['msg'] = "可用余额不能小于0";
				}

				if((float)$data['frozen_amount'] < 0){
					$json['status'] = "error";
					$json['msg'] = "冻结余额不能小于0";
				}

				if(!isset($json)){
					$status = DB::table('admin_member_site')->update($data);
					if($status){
						$json['status'] = "ok";
						$json['msg'] = "修改成功";
					}else{
						$json['status'] = "error";
						$json['msg'] = "当前无更改,修改失败";
					}
				}


			}
			return $json;
		}
		return view('admin/merchantsite');
	}

	/****后台通道接口****/
	public function appment(Request $arr){
		if($arr->isMethod('post')){
			if($arr->input('action') == 'appment'){
				if($arr->filled('type')){
					if($arr->input('type') == 1){
						$passageway = DB::table('die_passageway');
					}else{
						$passageway = DB::table('live_passageway');
					}
					$json['data']['list'] = $passageway->where('status',1)->get()->toarray();
				}
			}
			return $json;
		}
	}

	/****退出登录****/
	public function signout(Request $arr){
		session()->pull('admin');
		//跳转到登录页
        return redirect('/login');
	}

	/***修改密码****/
	public function change_password(Request $arr){
		if($arr->isMethod('post')){
		    if($arr->filled('form')){
		    	if(is_array($arr->input('form'))){
		    		$data = $arr->input('form');
		    		if(checkpass($data['password'])){
		    			if(!empty($data['repass'])){
		    				if(checkpass($data['repass'])){
		    					$info = DB::table('admin')->where('Id',session()->get('admin') ['Id'])->first();
		    					if($info->safety == 1){
		    						if(empty($data['code'])){
		    							$json['status']="error";
		    							$json['msg'] = "请输入谷歌验证码";
		    						}else{
		    							//验证谷歌验证码是否正确
										$ga = new Google;
										$checkResult = $ga->verifyCode($info->safetycode,trim($data['code']),2);
										if(!$checkResult){
											$json['status'] = "error";
											$json['msg'] = "当前谷歌验证码错误";
										}
		    						}
		    					}
		    					if(!isset($json)){
		    						if(ypass($data['password'],$info->password)){
		    							$updata['password'] = xpass(trim($data['password']));
				    					$status = DB::table('admin')->where('Id',session()->get('admin') ['Id'])->update($updata);
				    					if($status){
				    						$json['status'] = "ok";
				    						$json['msg'] = "修改密码成功";
				    					}else{
				    						$json['status'] = "error";
			    							$json['msg']  = "密码修改错误";
				    					}
			    					}else{
			    						$json['status'] = "error";
			    						$json['msg'] = "原密码不一致";
			    					}
		    					}
		    				}else{
		    					$json['status'] = "error";
		    					$json['msg']  = "新密码不符合规则";
		    				}
		    			}else{
		    				$json['status'] = "error";
		    				$json['msg'] = "请输入新密码";
		    			}
		    		}else{
		    			$json['status'] = "error";
		    			$json['msg'] = "原密码不符合规则";
		    		}
		    	}else{
		    		$json['status'] = "error";
		    		$json['msg'] = "不安全的提交方式";
		    	}
		    }
		    return $json;
		}
	    return view('admin/change_password');
	}
	//webtext代理添加
	public function daililist(Request $arr) {

		$add_box = 0;
		if ($arr->has('add_box')) {
			$add_box = 1;

		}
$listpage = [];
			//if($arr->has('page')){
				if($arr->filled('field') && $arr->input('field')!='-1' && $arr->filled('value')){
					$map[]=[$arr->input('field'),'like','%'.$arr->input('value').'%'];
				}
				if($arr->filled('open') && $arr->input('open')!= '-1' ){
					$map['open']=intval($arr->input('open'));
				}
				if($arr->filled('time') && is_array($arr->input('time'))){
					$time=$arr->input('time');
					if(!empty($time[0]) && !empty($time[1])){
						$map[]=['time','>=',strtotime($time[0])];
		       	  		$map[]=['time','<',strtotime($time[1])+86400];
					}
				}
				if($arr->filled('status')){
					if($arr->input('status') == "全部"){
						$map[]=['status','!=',null];
					}else if($arr->input('status') == "正常"){
						$map[]=['status',1];
					}else{
						$map[]=['status',2];
					}
				}else{
					$map[]=['status','!=',null];
				}
			   $listpage=DB::table('daili')->where($map)->orderBy('id','desc')->paginate(15)->toarray();

				 $allmoney = number_format(DB::table('daili')->sum('price'),2,".","");
				 $listpage['allmoney'] = $allmoney;

				 $okcount = DB::table('daili')->where(['status' => 1])->count();
				 $badcount = DB::table('daili')->where(['status' => 2])->count();
				  $listpage['okcount'] = $okcount;
					 $listpage['badcount'] = $badcount;
			 //}
			 if($listpage['total'] >= 1){
							 $data=$listpage['data'];
							 foreach ($data as $k => $v) {
								 $v=(array)$v;
								 $v['time']=date('Y-m-d H:i:s',$v['time']);
								 $json['data']['list'][]=$v;
							 }
						 }else{
							 $json['data']['list']=[];
						 }
						 $json['current_page']=$listpage['current_page'];
				 //$json['total']=$listpage['total'];
				 //$json['status']="ok";
				 //return $json;

		 //print_r($listpage);exit;
		 $dailiInfo = [];
		 if ($arr->has('daili_id')) {
			 $daili_id = $arr->get('daili_id');
			 $dailiInfo = DB::table('daili')->where(['Id' => $daili_id])->get()->toArray();
			 //print_r($dailiInfo);exit;

		 }
		return view('admin/daililist',['add_box' => $add_box, 'listpage'=>$listpage, 'dailiInfo' => $dailiInfo]);
	}
	//webtext代理添加
	public function dailiadd(Request $arr) {
		if($arr->isMethod('post')){

			$phone = $arr->input('phone');
			$password = $arr->input('password');
			$price = $arr->input('price');
			$service = $arr->input('service');
			$frozen_amount = $arr->input('frozen_amount');
			$status = $arr->input('status');


			$array = [
				'phone' => $phone,
	    	'password' => $password,
	   		'service' => $service ? $service : 0,
	    	'price' => $price ? $price : 0,
	    	'frozen_amount' => $frozen_amount ? $frozen_amount : 0,
				'status'		=> $status,
				'time'		=> time()

			];
			if ($arr->input('daili_id') && $arr->input('do') == 'edit') {
				unset($array['time']);
				if ($array['password'] == '') {
					unset($array['password']);
				}
				//print_r($array);exit;
				if ($array['password']) {
					$array['password'] = xpass($array['password']);
				}
					DB::table('daili')->where(['Id' => $arr->input('daili_id')])->update($array);
					$json['status']="ok";
					$json['msg']="编辑成功";
					return $json;
			} else {
				if (!$password) {
					$json['status']="error";
					$json['msg']="密码不能为空";
				}
				$array['password'] = xpass($array['password']);
				DB::table('daili')->insert($array);
			}

			$json['status']="ok";
			$json['msg']="添加成功";
			return $json;
		}

		return view('admin/dailiadd');
	}
}
