<?php
/* +----------------------------------------------------------------------+
   | Copyright (c) 2018-2019 YmPay                                        |
   |              <530759076@qq.com>                                      |
   +----------------------------------------------------------------------+*/

namespace App\Http\Controllers\Member;
use App\Http\Models\PaymentModel;
use App\Http\Models\DrawingModel;
use App\Http\Models\MemberpaymentModel;
use App\Http\Models\OrderModel;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redis;
use App\Http\Controllers\Common\Google;
use QrCode;
class MemberController extends MemberCommonController {
    /****主页****/
    public function main() {
        return view('member/main');
    }
    /***用户信息***/
    public function userinfo(Request $arr) {
        if ($arr->isMethod('post')) {
            if ($arr->has('action')) {
                if ($arr->input('action') == 'getinfo') {
                    $user = DB::table('user')->where('id', session()->get('user') ['Id'])->first();
                    $user->order_service = ($user->order_service * 100) . "%";
                    if ($user->type == 1){
                        $user->type = "普通商户";
                    }else if ($user->type == 2) {
                        $user->type = "高级商户";
                    }else{
                        $user->type = "VIP商户";
                    }
                    $user->safety = $user->safety == 1 ? true : false;
                    $ga = new Google;
                    $url = $ga->getQRCodeGoogleUrl('YM_Pay',$user->safetycode);
                    $user->safety_qrcode = "data:image/png;base64,".base64_encode(QrCode::format('png')->size(200)->margin(1)->generate($url));
                    $json['status'] = "ok";
                    $json['data'] = $user;
                }else if($arr->input('action') == 'open'){
                    $status = DB::table('user')->where('id',session()->get('user')['Id'])->update(array('safety'=>1));
                    if($status){
                        $json['status'] = "ok";
                    }else{
                        $json['status'] = "error";
                        $json['msg'] = "当前已开启过了哦";
                    }
                }else if($arr->input('action') == 'ajax'){
                    $data = $arr->all();
                    $ga = new Google;
                    $checkResult = $ga->verifyCode(DB::table('user')->where('id',session()->get('user')['Id'])->first()->safetycode,trim($data['google_code']),2);
                    if($checkResult){
                        $status = DB::table('user')->where('id',session()->get('user')['Id'])->update(array('safety'=>2));
                        if($status){
                            $json['status'] = "ok";
                            $json['msg'] = "关闭成功";
                        }else{
                            $json['status'] = "error";
                            $json['msg'] = "当前已关闭过了哦";
                        }
                    }else{
                        $json['status'] ="error";
                        $json['msg'] = "验证码错误";
                    }
                } else {
                    $json['status'] = "error";
                    $json['msg'] = "请求不规范";
                }
            }
            return $json;
        }
        return view('member/userinfo');
    }
    /****登录记录****/
    public function loginlog(Request $arr) {
        if ($arr->isMethod('post') && $arr->input('action') == 'log') {
            if ($arr->has('page')) {
                $map['user_id'] = session()->get('user') ['Id'];
                if ($arr->filled('time') && is_array($arr->input('time'))) {
                    $time = $arr->input('time');
                    if (!empty($time[0]) && !empty($time[1])) {
                        $map[] = ['time', '>=', strtotime($time[0]) ];
                        $map[] = ['time', '<', strtotime($time[1]) + 86400];
                    }
                }
                $listpage = DB::table('user_log')->where($map)->orderBy('id', 'desc')->paginate(15)->toarray();
                if ($listpage['total'] >= 1) {
                    $data = $listpage['data'];
                    foreach ($data as $k => $v) {
                        $v = (array)$v;
                        $v['time'] = date('Y-m-d H:i:s', $v['time']);
                        $json['data']['list'][] = $v;
                    }
                } else {
                    $json['data']['list'] = 0;
                }
                $json['current_page'] = $listpage['current_page'];
                $json['total'] = $listpage['total'];
                $json['status'] = "ok";
            } else {
                $json['status'] = "error";
                $json['msg'] = "不安全的提交方式";
            }
            return $json;
        }
        return view('member/loginlog');
    }
    /****支付通道****/
    public function payment(Request $arr) {
        if ($arr->isMethod('post') && $arr->has('action')) {
            if ($arr->input('action') == 'payment') {
                $map['user_id'] = session()->get('user') ['Id'];
                $map['status'] = 1;
                $n = PaymentModel::where($map)->with('livepay', 'diepay')->get()->toarray();
                if (!empty($n)) {
                    $json['status'] = "ok";
                    $c = '';
                    foreach ($n as $a) {
                        if (!empty($a['livepay'])) {
                            $c.= $a['livepay']['paytype'] . ',';
                        }
                        if (!empty($a['diepay'])) {
                            $c.= $a['diepay']['paytype'] . ',';
                        }
                    }
                    $d = array_values(array_unique(explode(",", rtrim($c, ","))));
                    foreach ($d as $k => $b) {
                        $json['data'][] = array(
                            'type' => $b,
                            'img' => "/members/icon/" . $b . ".png",
                            'service' => (session()->get('user') ['safety_service'] * 100) . "%"
                        );
                    }
                } else {
                    $json['status'] = "error";
                    $json['msg'] = "当前商户无支付通道";
                }
                return $json;
            }
        }
        return view('member/payment');
    }
    /****二维码生成****/
    public function qrcode(Request $arr){
        if($arr->isMethod('get')){
            if($arr->filled('url') && $arr->filled('type')){
                    $res = $arr->all();
                try {
                    $img = "/public/members/img/{$res['type']}.png";
                    $data = QrCode::format('png')->size(200)->margin(0)->generate($res['url']);
                    $url = base64_encode($data);
                    $json['state'] = 1;
                    $json['data']  = "data:image/png;base64,".$url;
                } catch (Exception $e) {
                    $json['state'] = 0;
                    $json['msg']  = $e->getMessage();
                }
            }else{
                $json['state'] = 0;
                $json['msg'] ="不安全的提交方式";
            }
            return $json;
        }
    }
    /****自助升级****/
    public function upgrade(Request $arr) {
        if($arr->isMethod('post')){
            if($arr->input('action') == 'getsite'){
                $userinfo = DB::table('user')->where('Id',session()->get('user')['Id'])->first();
                if($userinfo->type == 1){
                    $site = DB::table('admin_user_site')->first();
                }else if($userinfo->type == 2){
                    $site = DB::table('admin_user_senior_site')->first();
                    $site->vip = number_format(DB::table('admin_user_site')->first()->vip - DB::table('admin_user_site')->first()->senior,2,".","");
                }else{
                    $site = DB::table('admin_user_senior_site')->first();
                }
                $site->order_service = ($site->order_service*100)."%";
                $site->cash_service = ($site->cash_service*100)."%";
                $site->safety_service = ($site->safety_service*100)."%";
                if($site->order_everyday_money == 0){
                    $site->order_everyday_money = "不限";
                }
                if($site->cash_num == 0){
                    $site->cash_num = "不限";
                }
                if($site->cash_max == 0){
                    $site->cash_max = "不限";
                }
                $json['status']="ok";
                $json['data']=$site;
            }else if($arr->input('action') == 'pay'){
                $data = $arr->all();
                $site =DB::table('admin_user_site')->first();
                $userinfo = DB::table('user')->where('Id',session()->get('user')['Id'])->first();
                /***判断后台是否设置充值****/
                $postdata['merchant_key']=DB::table('admin_site')->first()->pay_merchant_key;
                $postdata['user_id']=DB::table('admin_site')->first()->pay_user_id;
                if(!empty($postdata['user_id']) && !empty($postdata['merchant_key'])){
                    $pay_userinfo = DB::table('user')->where('Id',$postdata['user_id'])->first();
                    $pay_merchant = DB::table('member')->where('apikey',$postdata['merchant_key'])->first();
                    if($pay_userinfo && $pay_merchant){
                        if($data['type'] == 2){
                            $postdata['amount'] = $site->senior;
                        }else{
                            if($userinfo->type == 1){
                                $postdata['amount'] = $site->vip;
                            }else{
                                $postdata['amount'] = $site->vip-$site->senior;
                            }
                        }
                        /******发送API订单*******/
                        $postdata['merchant_key']=$pay_merchant->key;
                        $postdata['user_id']=$pay_userinfo->Id;
                        $postdata['order_id'] = date('Ymdhis',time().rand(10000,99999));
                        $postdata['format'] = "json";
                        $postdata['ip'] = $arr->getClientIp();
                        $postdata['return_url']="http://".config('route.domain.api');
                        $postdata['notice_url']="http://".config('route.domain.api')."/member_notice";
                        $postdata['paytype']=$data['paytype'];
                        $postdata['sign']=getsign($postdata,$pay_userinfo->token);
                       try{
                            $client= new Client();
                            $url="http://".config('route.domain.api').'/pay';
                            $res = $client->request('post',$url,[
                                'verify'=>false,
                                'http_errors' => false,
                                'connect_timeout' =>7,
                                'timeout'=>7,
                                'form_params'=>$postdata
                            ]);
    
                            if($res->getStatusCode() == 200){
                                $return_data = json_decode($res->getBody(),true);
                                if($return_data['state'] == 1){
                                    $adddata['user_id'] = session()->get('user')['Id'];
                                    $adddata['order_id'] = $postdata['order_id'];
                                    $adddata['amount'] = $postdata['amount'];
                                    $adddata['amount_actual'] = $return_data['amount_actual'];
                                    $adddata['type']=$data['paytype'];
                                    $adddata['up_type']=$data['type'];
                                    $adddata['sub_time'] = time();
                                    $adddata['com_time'] = $return_data['endtime'];
                                    $status = DB::table('user_upgradepay')->insert($adddata);
                                    if($status){
                                        $json['status'] = "ok";
                                        $json['data'] =  $return_data;
                                    }else{
                                        $json['status'] = "error";
                                        $json['msg'] = "当前平台充值用户过多,请重新提交";
                                    }
                                }else{
                                    $json['status'] = "error";
                                    $json['msg'] = $return_data['msg'];
                                }
                            }else{
                                $json['status'] = "error";
                                $json['msg'] = "平台繁忙,请重新提交";
                            }
                       }catch(\Exception $e){
                           $json['status'] = "error";
                           $json['msg'] = "平台繁忙,请重新提交";
                      }
                    }else{
                        $json['status'] = "error";
                        $json['msg'] ="平台未开启在线充值,请联系客服充值哦";
                    }
                }else{
                    $json['status'] = "error";
                    $json['msg'] ="平台未开启在线充值,请联系客服充值哦";
                }
            }else if($arr->input('action') == 'exorder'){
                //查询当前订单
                $orderinfo = DB::table('order')->where('apiorder_id',$arr->input('order_id'))->first();
                if($orderinfo){
                    if($orderinfo->status == 2){
                        $json['code'] = 100;
                    }else if($orderinfo->com_time < time()){
                        $json['code'] = 102;
                    }else{
                        $json['code'] = 101;
                    }
                }else{
                    $json['code'] = 99;
                }
            }
            return $json;
        }
        return view('member/upgrade');
    }
    /***修改密码以及安全码****/
    public function change_password(Request $arr){
        if($arr->isMethod('post')){
            if($arr->filled('form')){
                if(is_array($arr->input('form'))){
                    $data = $arr->input('form');
                    if(checkpass($data['password'])){
                        if(!empty($data['repass'])){
                            if(checkpass($data['repass'])){
                                $userinfo = DB::table('user')->where('Id',session()->get('user')['Id'])->first();
                                if($userinfo->safety == 1){
                                   //验证谷歌验证码是否正确
                                    if(!empty($data['code'])){
                                        $ga = new Google;
                                        $checkResult = $ga->verifyCode($userinfo->safetycode,trim($data['code']),2);
                                        if(!$checkResult){
                                            $json['status'] = "error";
                                            $json['msg'] = "当前谷歌验证码错误";
                                        }
                                    }else{
                                        $json['status']= "error";
                                        $json['msg'] = "请输入谷歌验证码";
                                    }
                                }
                                if(!isset($json)){
                                    if(ypass($data['password'],$userinfo->password)){
                                        $updata['password'] = xpass(trim($data['repass']));
                                        $status = DB::table('user')->where('Id',session()->get('user') ['Id'])->update($updata);
                                        if($status){
                                            $json['status'] = "ok";
                                            $json['msg'] = "修改密码成功";
                                        }else{
                                            $json['status'] = "error";
                                            $json['msg']  = "密码修改错误";
                                        }
                                    }else{
                                        $json['status'] = "error";
                                        $json['msg'] = "原密码不一致";
                                    }
                                }
                            }else{
                                $json['status'] = "error";
                                $json['msg']  = "新密码不符合规则";
                            }
                        }else{
                            $json['status'] = "error";
                            $json['msg'] = "请输入新密码";
                        }
                    }else{
                        $json['status'] = "error";
                        $json['msg'] = "原密码不符合规则";
                    }
                }else{
                    $json['status'] = "error";
                    $json['msg'] = "不安全的提交方式";
                }
            }
            return $json;
        }
        return view('member/change_password');
    }
    /****资金变动****/
    public function capital_change(Request $arr) {
        if ($arr->isMethod('post') && $arr->input('action') == 'capital_change') {
            if ($arr->has('page')) {
                $map['user_id'] = session()->get('user') ['Id'];
                if ($arr->filled('time') && is_array($arr->input('time'))) {
                    $time = $arr->input('time');
                    if (!empty($time[0]) && !empty($time[1])) {
                        $map[] = ['time', '>=', strtotime($time[0]) ];
                        $map[] = ['time', '<', strtotime($time[1]) + 86400];
                    }
                }
                $listpage = DB::table('user_amount_change')->where($map)->orderBy('id', 'desc')->paginate(15)->toarray();
                if ($listpage['total'] >= 1) {
                    $data = $listpage['data'];
                    foreach ($data as $k => $v) {
                        $v = (array)$v;
                        if ($v['type'] == 1) {
                            $v['type'] = "订单进账";
                            $v['amount'] = "+" . $v['amount'];
                        } else if ($v['type'] == 2) {
                            $v['type'] = "申请提现";
                            $v['amount'] = "-" . $v['amount'];
                        } else if ($v['type'] == 3) {
                            $v['type'] = "提现驳回";
                            $v['amount'] = "+" . $v['amount'];
                        } else if ($v['type'] == 4) {
                            $v['type'] = "商户升级";
                            $v['amount'] = "-" . $v['amount'];
                        } else if ($v['type'] == 5){
                            $v['type'] = "平台充值";
                            $v['amount'] = "+" . $v['amount'];
                        }else if ($v['type'] == 6){
                            $v['type'] = "平台扣款";
                            $v['amount'] = "-" . $v['amount'];
                        }
                        $v['time'] = date('Y-m-d H:i:s', $v['time']);
                        $json['data']['list'][] = $v;
                    }
                } else {
                    $json['data']['list'] = 0;
                }
                $json['current_page'] = $listpage['current_page'];
                $json['total'] = $listpage['total'];
                $json['status'] = "ok";
            } else {
                $json['status'] = "error";
                $json['msg'] = "不安全的提交方式";
            }
            return $json;
        }
        return view('member/capital_change');
    }
    /****余额提现****/
    public function withdraw(Request $arr) {
        if ($arr->isMethod('post')) {
            if ($arr->input('action') == 'withdraw') {
                $userinfo = DB::table('user')->where('id', session()->get('user') ['Id'])->first();
                if ($userinfo->type == 1) {
                    $site = DB::table('admin_user_site')->first();
                } else if ($userinfo->type == 2) {
                    $site = DB::table('admin_user_senior_site')->first();
                } else {
                    $site = DB::table('admin_user_vip_site')->first();
                }
                $json['data']['price'] = $userinfo->price;
                $json['data']['cash_min'] = $site->cash_min;
                $json['data']['cashmoney'] = DB::table('user_drawing')->where(array('status'=>2,'user_id'=>session()->get('user') ['Id']))->sum('money');
                $bank = DB::table('user_cash_account')->select('id', 'name', 'bank_type')->where('user_id', session()->get('user') ['Id'])->get()->toarray();
                foreach ($bank as $v) {
                    $v = (array)$v;
                    $json['data']['account'][] = array(
                        'label' => $v['name'] . '-' . $v['bank_type'],
                        'value' => $v['id']
                    );
                }
            } else if ($arr->input('action') == 'ajax' && $arr->filled('cash_account_id') && $arr->filled('money')) {
                $userinfo = DB::table('user')->where('id', session()->get('user') ['Id'])->first();
                if ($userinfo->price >= (float)$arr->input('money')) {
                      $data = $arr->all();
                    if($userinfo->safety == 1){
                       //验证谷歌验证码是否正确
                        if(!empty($data['code'])){
                            $ga = new Google;
                            $checkResult = $ga->verifyCode($userinfo->safetycode,trim($data['code']),2);
                            if(!$checkResult){
                                $json['status'] = "error";
                                $json['msg'] = "当前谷歌验证码错误";
                            }
                        }else{
                            $json['status']= "error";
                            $json['msg'] = "请输入谷歌验证码";
                        }
                    }
                    if(!isset($json)){
                        if ($userinfo->type == 1) {
                            $site = DB::table('admin_user_site')->first();
                        } else if ($userinfo->type == 2) {
                            $site = DB::table('admin_user_senior_site')->first();
                        } else {
                            $site = DB::table('admin_user_vip_site')->first();
                        }
                        if ((float)$arr->input('money') >= $site->cash_min) {
                            if ((float)$arr->input('money') <= $site->cash_max || $site->cash_max == 0) {
                                //查询当天已提现次数
                                $map['user_id'] = $userinfo->Id;
                                $map[] = ['sub_time', '<', strtotime(date('Y-m-d 00:00:00')) + 86400];
                                $map[] = ['sub_time', '>=', strtotime(date('Y-m-d 00:00:00')) ];
                                $cashnum = DB::table('user_drawing')->where($map)->count();
                                if ($cashnum < $site->cash_num || $site->cash_num == 0) {
                                    $adddata['user_id'] = $userinfo->Id;
                                    $adddata['cash_account_id'] = $arr->input('cash_account_id');
                                    $adddata['money'] = $arr->input('money');
                                    $adddata['service'] = $arr->input('money') * $site->cash_service;
                                    $adddata['sub_time'] = time();
                                    $status = DB::table('user_drawing')->insertGetId($adddata);
                                    if ($status) {
                                        $userstatus = DB::table('user')->where('Id', $userinfo->Id)->update(array(
                                            'price' => ($userinfo->price - $data['money'])
                                        ));
                                        if ($userstatus) {
                                            //添加资金明细
                                            $amount_change['type'] = 2;
                                            $amount_change['user_id'] = session()->get('user') ['Id'];
                                            $amount_change['amount'] = $data['money'];
                                            $amount_change['user_price'] = $userinfo->price - $data['money'];
                                            $amount_change['time'] = time();
                                            
                                            DB::table('user_amount_change')->insert($amount_change);

                                            $json['status'] = "ok";
                                            $json['msg'] = "申请提现成功,请等待客服处理";
                                        } else {
                                            DB::table('user_drawing')->where('Id', $status)->delete();
                                            $json['status'] = "error";
                                            $json['msg'] = "平台繁忙,请重新申请";
                                        }
                                    } else {
                                        $json['status'] = "error";
                                        $json['msg'] = "平台繁忙,请重新申请";
                                    }
                                } else {
                                    $json['status'] = "error";
                                    $json['msg'] = "当前级别每日只可提现" . $site->cash_num . "次";
                                }
                            } else {
                                $json['status'] = "error";
                                $json['msg'] = "当前级别最多可提现" . $site->cash_max . "元";
                            }
                        } else {
                            $json['status'] = "error";
                            $json['msg'] = "当前级别最低提现" . $site->cash_min . "元";
                        }
                    }
                } else {
                    $json['status'] = "error";
                    $json['msg'] = "当前商户余额不足";
                }
            } else {
                $json['status'] = "error";
                $json['msg'] = "不安全的提交方式";
            }
            return $json;
        }
        return view('member/withdraw');
    }
    /****提款记录****/
    public function settlement_records(Request $arr) {
        if ($arr->isMethod('post')) {
            if ($arr->has('page')) {
                $map['user_id'] = session()->get('user') ['Id'];
                if ($arr->filled('time') && is_array($arr->input('time'))) {
                    $time = $arr->input('time');
                    if (!empty($time[0]) && !empty($time[1])) {
                        $map[] = ['sub_time', '>=', strtotime($time[0]) ];
                        $map[] = ['sub_time', '<', strtotime($time[1]) + 86400];
                    }
                }
                $datapage = DrawingModel::where($map)->with('bank')->orderBy('id', 'desc')->paginate(15)->toarray();
                if (intval($datapage['total']) >= 1) {
                    $data = $datapage['data'];
                    foreach ($data as $k => $v) {
                        $v = (array)$v;
                        if ($v['status'] == 1) {
                            $v['sub_time'] = date('Y-m-d H:i', $v['sub_time']);
                            $v['com_time'] = date('Y-m-d H:i', $v['com_time']);
                        } else {
                            $v['sub_time'] = date('Y-m-d H:i', $v['sub_time']);
                            $v['com_time'] = "正在处理";
                        }
                        if (is_null($v['bank'])) {
                            $v['bank']['name'] = "未知";
                            $v['bank']['bank_type'] = '';
                        }
                        $json['data']['list'][] = $v;
                    }
                    /****成功金额****/
                    $json['data']['success_money'] = DB::table('user_drawing')->where($map)->where('status', 1)->sum('money');
                    /****成功手续费****/
                    $json['data']['success_service'] = DB::table('user_drawing')->where($map)->where('status', 1)->sum('service');
                    /****成功笔数****/
                    $json['data']['success_count'] = DB::table('user_drawing')->where($map)->where('status', 1)->count();
                } else {
                    $json['data']['list'] = 0;
                    $json['data']['success_money'] = 0;
                    $json['data']['success_service'] = 0;
                    $json['data']['success_count'] = 0;
                }
                $json['current_page'] = $datapage['current_page'];
                $json['total'] = $datapage['total'];
                $json['status'] = "ok";
            } else {
                $json['status'] = "error";
            }
            return $json;
        }
        return view('member/settlement_records');
    }
    /****提款账户****/
    public function settlement_account(Request $arr) {
        if ($arr->isMethod('post')) {
            if ($arr->has('page')) {
                $map['user_id'] = session()->get('user') ['Id'];
                $datapage = DB::table('user_cash_account')->where($map)->orderBy('id', 'desc')->paginate(15)->toarray();
                if (intval($datapage['total']) >= 1) {
                    $json['data'] = $datapage['data'];
                } else {
                    $json['data'] = 0;
                }
                $json['current_page'] = $datapage['current_page'];
                $json['total'] = $datapage['total'];
                $json['status'] = "ok";
            } else if ($arr->has('action')) {
                if ($arr->input('action') == 'add' || $arr->input('action') == 'edit') {
                    $data = $arr->all();
                    if ($data['bank_type']=="其它银行" || bank_chk($data)) {
                        if (!empty($data['name'])) {
                            $map2['user_id'] = session()->get('user') ['Id'];
                            $map2['bank_card'] = $data['bank_card'];
                            $info = (array)DB::table('user_cash_account')->where($map2)->first();
                            if (!empty($info)) {
                                $json['status'] = "error";
                                $json['msg'] = "当前商户已存在该银行卡号";
                            } else {
                                unset($data['action']);
                                if ($arr->input('action') == 'add') {
                                    $data['user_id'] = session()->get('user') ['Id'];
                                    $status = DB::table('user_cash_account')->insert($data);
                                    if ($status) {
                                        $json['status'] = "ok";
                                        $json['msg'] = "添加收款账户成功";
                                    } else {
                                        $json['status'] = "error";
                                        $json['msg'] = "服务器繁忙,银行卡号添加失败";
                                    }
                                } else {
                                    $data2 = $data;
                                    unset($data2['id']);
                                    $status = DB::table('user_cash_account')->where('Id', $data['id'])->update($data2);
                                    if ($status) {
                                        $json['status'] = "ok";
                                        $json['msg'] = "编辑收款账户成功";
                                    } else {
                                        $json['status'] = "error";
                                        $json['msg'] = "当前已存在该银行卡号";
                                    }
                                }
                            }
                        } else {
                            $json['status'] = "error";
                            $json['msg'] = "请输入开户姓名";
                        }
                    } else {
                        $json['status'] = "error";
                        $json['msg'] = "请输入正确的银行卡号";
                    }
                } else if ($arr->input('action') == 'del') {
                    if ($arr->has('id')) {
                        DB::table('user_drawing')->where('cash_account_id', $arr->input('id'))->delete();
                        $status = DB::table('user_cash_account')->where('Id', $arr->input('id'))->delete();
                        if ($status) {
                            $json['status'] = "ok";
                            $json['msg'] = "删除成功";
                        } else {
                            $json['status'] = "error";
                            $json['msg'] = "当前不存在此收款账户";
                        }
                    } else {
                        $json['status'] = "error";
                        $json['msg'] = "不安全的提交方式";
                    }
                }
            } else {
                $json['status'] = "error";
            }
            return $json;
        }
        return view('member/settlement_account');
    }
    /****订单交易数据****/
    public function order_record(Request $arr) {
        if ($arr->isMethod('post')) {
            if ($arr->has('page')) {
                $map['user_id'] = session()->get('user') ['Id'];
                //搜索条件
                if ($arr->has('order') && !is_null($arr->input('order')) && $arr->input('order') != '-1' && !is_null($arr->input('value'))) {
                    if ($arr->input('order') == 'order_money' || $arr->input('order') == 'order_price') {
                        $map[] = [$arr->input('order') , '=', $arr->input('value') ];
                    } else {
                        $map[] = [$arr->input('order') , 'like', '%' . $arr->input('value') . '%'];
                    }
                }
                if ($arr->has('paytype') && !empty($arr->input('paytype')) && $arr->input('paytype') != '-1') {
                    $map[] = ['type', '=', $arr->input('paytype') ];
                }
                if ($arr->has('status') && !empty($arr->input('status')) && $arr->input('status') != '-1') {
                    $map['status'] = $arr->input('status');
                }
                if ($arr->has('notice') && !empty($arr->input('notice')) && $arr->input('notice') != '-1') {
                    $map['notice'] = $arr->input('notice');
                }
                if ($arr->filled('time') && is_array($arr->input('time'))) {
                    $time = $arr->input('time');
                    if (!empty($time[0]) && !empty($time[1])) {
                        $map[] = ['sub_time', '>=', strtotime($time[0]) ];
                        $map[] = ['sub_time', '<', strtotime($time[1])];
                    }
                }
                //条件结束
                if ($arr->input('action') == 'main') {
                    $map[] = ['sub_time', '<', strtotime(date('Y-m-d 00:00:00')) + 86400];
                    $map[] = ['sub_time', '>=', strtotime(date('Y-m-d 00:00:00')) - 86400 * 15];
                } else {
                    $map2 = $map;
                    /****总提交金额****/
                    $json['data']['record_money']['totalmoney'] = number_format(DB::table('order')->where($map2)->sum('order_money') , 2, ".", "");
                    $map2['status'] = 2;
                    /****成功金额****/
                    $json['data']['record_money']['successmoney'] = number_format(DB::table('order')->where($map2)->sum('order_price') , 2, ".", "");
                    /****实际进账****/
                    $json['data']['record_money']['lncome'] = number_format($json['data']['record_money']['successmoney'] - DB::table('order')->where($map2)->sum('order_service') - DB::table('order')->where($map2)->sum('software_service') , 3, ".", "");
                }
                $orderarr = DB::table('order')->where($map)->orderBy('id', 'desc')->paginate(15)->toarray();
                if (intval($orderarr['total']) >= 1) {
                    $order = $orderarr['data'];
                    foreach ($order as $k => $v) {
                        $v = (array)$v;
                        $v['time'] = date('Y-m-d H:i:s', $v['sub_time']);
                        if ($v['type'] == 'alipay') $v['type'] = "支付宝扫码";
                        else if ($v['type'] == 'aliwap') $v['type'] = "支付宝H5";
                        else if ($v['type'] == 'wechat') $v['type'] = "微信扫码";
                        else $v['type'] = "银联扫码";
                        $v['check'] = false;
                        $orderlist[] = $v;
                    }
                    $json['data']['list'] = $orderlist;
                } else {
                    $json['data']['list'] = 0;
                }
                $json['map'] = $map;
                $json['current_page'] = $orderarr['current_page'];
                $json['total'] = $orderarr['total'];
                $json['status'] = "ok";
            } else if ($arr->input('action') == 'notice' && $arr->filled('idarr')) {
                $num = 0;
                try {
                    if (is_array($arr->input('idarr'))) {
                        //查询所有通知
                        $redis_order_list = Redis::lrange("ordernotice", 0, -1);
                        foreach ($arr->input('idarr') as $k => $v) {
                            $infoarr[$k] = OrderModel::where('Id', $v)->first()->toarray();
                            if ($infoarr[$k] && $infoarr[$k]['status'] == 2) {
                                $postarr['form']['user_id'] = $infoarr[$k]['user_id'];
                                $postarr['form']['order_id'] = $infoarr[$k]['order_id'];
                                $postarr['form']['apiorder_id'] = $infoarr[$k]['apiorder_id'];
                                $postarr['form']['amount'] = $infoarr[$k]['order_money'];
                                $postarr['form']['amount_actual'] = $infoarr[$k]['order_price'];
                                $postarr['form']['paytype'] = $infoarr[$k]['type'];
                                if ($infoarr[$k]['remarks'] != "无") {
                                    $postarr['form']['remarks'] = $infoarr[$k]['remarks'];
                                }
                                $postarr['form']['success_time'] = $infoarr[$k]['com_time'];
                                $postarr['form']['sign'] = getsign($postarr['form'], session()->get('user') ['token']);
                                $postarr['notify_url'] = $infoarr[$k]['notify_url'];
                                $postarr['number_notice'] = 2;
                                foreach ($redis_order_list as $f => $v) {
                                    //判断是否存在该通知
                                    if (json_encode(json_decode($v, true) ['form']) == json_encode($postarr['form'])) {
                                        $status = true;
                                        break;
                                    }
                                }
                                if (!isset($status)) {
                                    //添加到Redis回调列表
                                    $redis_status[$k] = Redis::rpush('ordernotice', json_encode($postarr));
                                    if ($redis_status[$k]) {
                                        $num++;
                                    }
                                }
                            }
                        }
                        if ($num != 0) {
                            $json['status'] = "ok";
                            $json['msg'] = "成功发送通知{$num}个,请等待通知";
                        } else {
                            $json['status'] = "error";
                            $json['msg'] = "无成功支付订单或通知任务已存在,发送通知失败";
                        }
                    } else {
                        $json['status'] = "error";
                        $json['msg'] = "不安全的提交方式";
                    }
                }
                catch(\Exception $e) {
                    $json['status'] = "error";
                    $json['msg'] = $e->getMessage();
                }
            } else {
                $json['status'] = "error";
                $json['msg'] = "不安全的提交方式";
            }
            return $json;
        }
        return view('member/order_record');
    }
    /****订单统计****/
    public function statistics(Request $arr) {
        if ($arr->isMethod('post')) {
            if ($arr->input('action') == 'text') {
                /****今日订单金额****/
                $map['user_id'] = session()->get('user') ['Id'];
                $map['status'] = 2;
                $map[] = ['sub_time', '>', strtotime(date('Y-m-d 00:00:00')) ];
                $map[] = ['sub_time', '<', strtotime(date('Y-m-d 00:00:00')) + 86400];
                $json['data']['order_today_money'] = number_format(DB::table('order')->where($map)->sum('order_money') , 2, ".", "");
                /****今日订单量****/
                $json['data']['order_today_total'] = DB::table('order')->where($map)->count();
                /****昨日订单金额****/
                $map2['user_id'] = session()->get('user') ['Id'];
                $map2['status'] = 2;
                $map2[] = ['sub_time', '<', strtotime(date('Y-m-d 00:00:00')) ];
                $map2[] = ['sub_time', '>', strtotime(date('Y-m-d 00:00:00')) - 86400];
                $json['data']['order_yesterday_money'] = number_format(DB::table('order')->where($map2)->sum('order_money') , 2, ".", "");
                /****昨日订单量****/
                $json['data']['order_yesterday_total'] = DB::table('order')->where($map2)->count();
                /****总提交金额****/
                $json['data']['order_total_money'] = DB::table('order')->where('user_id', session()->get('user') ['Id'])->sum('order_money');
                /****总提交订单****/
                $json['data']['order_total'] = DB::table('order')->where('user_id', session()->get('user') ['Id'])->count();
                $map3['user_id'] = session()->get('user') ['Id'];
                $map3['status'] = 2;
                /****总支付订单金额****/
                $json['data']['order_money'] = DB::table('order')->where($map3)->sum('order_money');
                /****总支付金额****/
                $json['data']['success_order_total_money'] = DB::table('order')->where($map3)->sum('order_price');
                /****总支付订单****/
                $json['data']['success_order_total'] = $json['data']['order_total'];
                /***首页总出单量***/
                $json['data']['order_total_count'] = $json['data']['success_order_total'];
                /****总扣手续费收益****/
                $json['data']['real_income'] = number_format($json['data']['success_order_total_money'] - DB::table('order')->where($map3)->sum('order_service') - DB::table('order')->where($map3)->sum('software_service') , 3, ".", "");
            } else if ($arr->input('action') == 'charts') {
                $week = !empty($arr->input('time')) ? getweek('', $arr->input('time')) : getweek();
                foreach ($week as $k => $v) {
                    $map[$k]['user_id'] = session()->get('user') ['Id'];
                    $map[$k][] = ['sub_time', '>', $v['time']];
                    $map[$k][] = ['sub_time', '<', $v['time'] + 86400];
                    /****遍历查询每日提交订单数****/
                    $json['data'][$k]['日期'] = $v['date'];
                    $json['data'][$k]['提交订单'] = DB::table('order')->where($map[$k])->count();
                    /****遍历查询每日提交订单金额****/
                    $json['data'][$k]['提交金额'] = DB::table('order')->where($map[$k])->sum('order_money');
                    /****遍历查询每日成功订单数****/
                    $map[$k]['status'] = 2;
                    $json['data'][$k]['成功订单'] = DB::table('order')->where($map[$k])->count();
                    /****遍历查询每日成功订单金额****/
                    $json['data'][$k]['成功金额'] = DB::table('order')->where($map[$k])->sum('order_price');
                }
            } else if ($arr->input('action') == 'paytype') {
                $map['user_id'] = session()->get('user') ['Id'];
                if ($arr->filled('time') && is_array($arr->input('time'))) {
                    $time = $arr->input('time');
                    if (!empty($time[0]) && !empty($time[1])) {
                        $map[] = ['sub_time', '>=', strtotime($time[0]) ];
                        $map[] = ['sub_time', '<', strtotime($time[1]) + 86400];
                    }
                }
                if ($arr->has('type') && !empty($arr->input('type')) && $arr->input('type') != '-1') {
                    /****查询单个统计****/
                    $paylist['type'] = $arr->input('type');
                    $map['type'] = $arr->input('type');
                    /***提交订单****/
                    $paylist['sub_order'] = DB::table('order')->where($map)->count();
                    /***提交金额****/
                    $paylist['sub_ordermoney'] = DB::table('order')->where($map)->sum('order_money');
                    /***成功订单****/
                    $map['status'] = 2;
                    $paylist['success_order'] = DB::table('order')->where($map)->count();
                    /***成功金额****/
                    $paylist['orderprice'] = DB::table('order')->where($map)->sum('order_price');
                    /****实际所得****/
                    $paylist['income'] = number_format($paylist['orderprice'] - DB::table('order')->where($map)->sum('order_service') - DB::table('order')->where($map)->sum('software_service') , 3, ".", "");
                    if ($map['type'] == 'aliwap') {
                        $charts['支付方式'] = "支付宝H5";
                    } else if ($map['type'] == 'alipay') {
                        $charts['支付方式'] = "支付宝扫码";
                    } else if ($map['type'] == 'wechat') {
                        $charts['支付方式'] = "微信扫码";
                    } else {
                        $charts['支付方式'] = "银联扫码";
                    }
                    $charts['支付金额'] = $paylist['orderprice'];
                    $json['data']['paytypelist'][] = $paylist;
                    $json['data']['charts'][] = $charts;
                    $json['data']['textleft'] = array(
                        'success_order_total' => $paylist['success_order'],
                        'order_total' => $paylist['sub_order']
                    );
                } else {
                    /***查询所有统计***/
                    $payarr = array(
                        'alipay',
                        'aliwap',
                        'wechat',
                        'unionpay'
                    );
                    foreach ($payarr as $k => $v) {
                        if (isset($time)) {
                            if (!empty($time[0]) && !empty($time[1])) {
                                $map2[$k][] = ['sub_time', '>=', strtotime($time[0]) ];
                                $map2[$k][] = ['sub_time', '<', strtotime($time[1]) + 86400];
                            }
                        }
                        $map2[$k]['user_id'] = session()->get('user') ['Id'];
                        $map2[$k]['type'] = $v;
                        $json['data']['paytypelist'][$k]['type'] = $v;
                        /****遍历查询当前支付方式提交订单数****/
                        $json['data']['paytypelist'][$k]['sub_order'] = DB::table('order')->where($map2[$k])->count();
                        /****遍历查询当前支付方式提交金额****/
                        $json['data']['paytypelist'][$k]['sub_ordermoney'] = DB::table('order')->where($map2[$k])->sum('order_money');
                        /****遍历查询当前支付方式成功订单****/
                        $map2[$k]['status'] = 2;
                        $json['data']['paytypelist'][$k]['success_order'] = DB::table('order')->where($map2[$k])->count();
                        /****遍历查询当前支付方式成功金额****/
                        $json['data']['paytypelist'][$k]['orderprice'] = DB::table('order')->where($map2[$k])->sum('order_price');
                        /****遍历查询当前支付方式实际所得****/
                        $json['data']['paytypelist'][$k]['income'] = number_format($json['data']['paytypelist'][$k]['orderprice'] - DB::table('order')->where($map2[$k])->sum('order_service') - DB::table('order')->where($map2[$k])->sum('software_service') , 3, ".", "");
                        if ($v == 'aliwap') {
                            $json['data']['charts'][$k]['支付方式'] = "支付宝H5";
                        } else if ($v == 'alipay') {
                            $json['data']['charts'][$k]['支付方式'] = "支付宝扫码";
                        } else if ($v == 'wechat') {
                            $json['data']['charts'][$k]['支付方式'] = "微信扫码";
                        } else {
                            $json['data']['charts'][$k]['支付方式'] = "银联扫码";
                        }
                        $json['data']['charts'][$k]['支付金额'] = $json['data']['paytypelist'][$k]['orderprice'];
                    }
                    $json['data']['textleft'] = array(
                        'success_order_total' => DB::table('order')->where('user_id', session()->get('user') ['Id'])->count() ,
                        'order_total' => DB::table('order')->where(array(
                            'user_id' => session()->get('user') ['Id'],
                            'status' => 2
                        ))->count()
                    );
                }
            } else {
                $json['status'] = "error";
                $json['msg'] = "不安全的提交方式";
            }
            return $json;
        }
        return view('member/statistics');
    }
    /****退出登录****/
    public function signout(Request $arr){
        session()->pull('user');
        //跳转到登录页
        return redirect('/login');
    }
}

