<?php
/* +----------------------------------------------------------------------+
   | Copyright (c) 2018-2019 YmPay                                        |
   |              <530759076@qq.com>                                      |
   +----------------------------------------------------------------------+*/
namespace App\Http\Controllers\Merchant;
use App\Http\Models\OrderModel;
use App\Http\Models\MemberpaymentModel;
use App\Http\Models\DiepollingpaymentModel;
use App\Http\Models\LivepollingpaymentModel;
use Vinkla\Hashids\Facades\Hashids;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redis;
use GuzzleHttp\Client;
use App\Http\Controllers\Common\Google;
use App\Http\Controllers\Common\Order_Redis;
use Log;
use QrCode;

class MerchantController extends MerchantCommonController{

	/****码商首页****/
	public function main(){

		return view('merchant/main');
	}

	/****码商信息*****/
	public function merchantinfo(Request $arr){
		if($arr->isMethod('post')){
			if($arr->has('action')){
				if($arr->input('action') == 'getinfo'){
					$merchant = DB::table('member')->where('id',session()->get('merchant')['Id'])->select('Id','phone','diepolling_num','livepolling_num','price','frozen_amount','apikey','service','safety','safetycode')->first();
					$merchant->service = ($merchant->service*100).'%';
					$merchant->safety =  $merchant->safety == 1 ? true : false;
					$ga = new Google;
					$url = $ga->getQRCodeGoogleUrl('YM_Pay',$merchant->safetycode);
					$merchant->safety_qrcode = "data:image/png;base64,".base64_encode(QrCode::format('png')->size(200)->margin(1)->generate($url));
					$json['status']="ok";
					$json['data']=$merchant;
				}else if($arr->input('action') == 'open'){
					$status = DB::table('member')->where('id',session()->get('merchant')['Id'])->update(array('safety'=>1));
					if($status){
						$json['status'] = "ok";
					}else{
						$json['status'] = "error";
						$json['msg'] = "当前已开启过了哦";
					}
				}else if($arr->input('action') == 'ajax'){
					$data = $arr->all();
					$ga = new Google;
					$checkResult = $ga->verifyCode(DB::table('member')->where('id',session()->get('merchant')['Id'])->first()->safetycode,trim($data['google_code']),2);
					if($checkResult){
						$status = DB::table('member')->where('id',session()->get('merchant')['Id'])->update(array('safety'=>2));
						if($status){
							$json['status'] = "ok";
							$json['msg'] = "关闭成功";
						}else{
							$json['status'] = "error";
							$json['msg'] = "当前已关闭过了哦";
						}
					}else{
						$json['status'] ="error";
						$json['msg'] = "验证码错误";
					}
				}else{
					$json['status']="error";
					$json['msg']="请求不规范";
				}
			}
			return $json;
		}
		return view('merchant/merchantinfo');
	}

	/****码商资金变动****/
	public function capital_change(Request $arr){
		if($arr->isMethod('post') && $arr->input('action') == 'capital_change'){
			if($arr->has('page')){
				$map['member_id']=session()->get('merchant')['Id'];
				if($arr->filled('time') && is_array($arr->input('time'))){
					$time=$arr->input('time');
					if(!empty($time[0]) && !empty($time[1])){
						$map[]=['time','>=',strtotime($time[0])];
						$map[]=['time','<',strtotime($time[1])+86400];
					}
				}
				$listpage=DB::table('member_amount_change')->where($map)->orderBy('id','desc')->paginate(15)->toarray();
				if($listpage['total'] >= 1){
					$data=$listpage['data'];
					foreach ($data as $k => $v) {
						$v=(array)$v;
						if($v['type'] == 1){
							$v['type'] = "出单扣除";
							$v['amount']= "-".$v['amount'];
						}else if($v['type'] == 2){
							$v['type'] = "余额充值";
							$v['amount']= "+".$v['amount'];
						}else if($v['type'] == 3){
							$v['type'] = "冻结扣除(余额不足)";
							$v['amount']= "-".$v['amount'];
						}else{
							$v['type'] = "平台扣款";
							$v['amount']= "-".$v['amount'];
						}

						$v['time']=date('Y-m-d H:i:s',$v['time']);
						$json['data']['list'][]=$v;
					}
				}else{
					$json['data']['list']=0;
				}
				$json['current_page']=$listpage['current_page'];
				$json['total']=$listpage['total'];
				$json['status']="ok";
			}else{
				$json['status']="error";
				$json['msg']="不安全的提交方式";
			}
			return $json;
		}
		return view('merchant/capital_change');
	}

	/****登录记录****/
	public function loginlog(Request $arr){
		if($arr->isMethod('post') && $arr->input('action') == 'log'){
			if($arr->has('page')){
				$map['member_id']=session()->get('merchant')['Id'];
				if($arr->has('time') && is_array($arr->input('time')) && $arr->input('time')!=','){
					$time=$arr->input('time');
					if(!empty($time[0]) && !empty($time[1])){
						$map[]=['time','>=',strtotime($time[0])];
						$map[]=['time','<',strtotime($time[1])+86400];
					}
				}
				$listpage=DB::table('member_log')->where($map)->orderBy('id','desc')->paginate(15)->toarray();
				if($listpage['total'] >= 1){
					$data=$listpage['data'];
					foreach ($data as $k => $v) {
						$v=(array)$v;
						$v['time']=date('Y-m-d H:i:s',$v['time']);
						$json['data']['list'][]=$v;
					}
				}else{
					$json['data']['list']=0;
				}
				$json['current_page']=$listpage['current_page'];
				$json['total']=$listpage['total'];
				$json['status']="ok";
			}else{
				$json['status']="error";
				$json['msg']="不安全的提交方式";
			}
			return $json;
		}
		return view('merchant/loginlog');
	}

	/*****码商操作日志*******/
	public function operation_log(Request $arr){
		if($arr->isMethod('post') && $arr->input('action') == 'log'){
			if($arr->has('page')){
				$map['member_id']=session()->get('merchant')['Id'];
				if($arr->has('time') && is_array($arr->input('time')) && $arr->input('time')!=','){
					$time=$arr->input('time');
					if(!empty($time[0]) && !empty($time[1])){
						$map[]=['time','>=',strtotime($time[0])];
						$map[]=['time','<',strtotime($time[1])+86400];
					}
				}
				$listpage=DB::table('member_operation')->where($map)->orderBy('id','desc')->paginate(15)->toarray();
				if($listpage['total'] >= 1){
					$data=$listpage['data'];
					foreach ($data as $k => $v) {
						$v=(array)$v;
						$v['time']=date('Y-m-d H:i:s',$v['time']);
						$json['data']['list'][]=$v;
					}
				}else{
					$json['data']['list']=0;
				}
				$json['current_page']=$listpage['current_page'];
				$json['total']=$listpage['total'];
				$json['status']="ok";
			}else{
				$json['status']="error";
				$json['msg']="不安全的提交方式";
			}
			return $json;
		}
		return view('merchant/operation_log');
	}
	/****码商自测收银链接****/
	public function pay_url(Request $arr){
		if($arr->isMethod('post')){
			if($arr->input('action') == 'ajax'){
				$json['status'] = 'ok';
				$json['data']['url'] = 'http://'.config('route.domain.api').'/cashier?token='.session()->get('merchant')['apikey'];
				$json['data']['qrcode'] = "data:image/png;base64,".base64_encode(QrCode::format('png')->size(200)->margin(1)->generate($json['data']['url']));
			}
			return $json;
		}
		return view('merchant/pay_url');
	}

	/****码商支持APP通道****/
	public function appment(Request $arr){
		if($arr->isMethod('post') && $arr->has('action')){
			if($arr->input('action') == 'appment'){
				/***获取固码通道****/
				$map['member_id']=session()->get('merchant')['Id'];
				$map['passageway_type']=1;
				$map['status']=1;
				if($arr->has('uid') && !is_null($arr->input('uid')) && $arr->input('uid')!='-1'){
					$map2['polling_id']=Hashids::decode($arr->input('uid'))[0];
					if($arr->input('type') == 1){
						$poldata=DiepollingpaymentModel::where($map2)->select('passageway_id')->get()->toarray();
						foreach ($poldata as $k => $v) {
							if($v['passageway_id'] == 804) continue;
							$map[]=['passageway_id','!=',$v['passageway_id']];
						}
					}else{
						$poldata=LivepollingpaymentModel::where($map2)->select('passageway_id')->get()->toarray();
						foreach ($poldata as $k => $v) {
							$map[]=['passageway_id','!=',$v['passageway_id']];
						}
					}
				}
				$dielist=MemberpaymentModel::where($map)->with('diepay')->get()->toarray();
				/**活码通道****/
				$map['passageway_type']=2;
				$livelist=MemberpaymentModel::where($map)->with('livepay')->get()->toarray();
				/***判断固码通道****/
				if(!empty($dielist)){
					foreach ($dielist as $v) {
						$json['data']['diepay'][]=array('passageway_id'=>$v['passageway_id'],'img'=>"/merchants/icon/".$v['diepay']['Id'].".png",'name'=>$v['diepay']['name'],'paytype'=>getpassageway($v['diepay']['paytype']));
					}
				}else{
					$json['data']['diepay']=0;
				}
				/***判断活码通道****/
				if(!empty($livelist)){
					foreach ($livelist as $v) {
						$json['data']['livepay'][]=array('passageway_id'=>$v['passageway_id'],'img'=>"/merchants/icon/".$v['livepay']['Id'].".png",'name'=>$v['livepay']['name'],'paytype'=>getpassageway($v['livepay']['paytype']));
					}
				}else{
					$json['data']['livepay']=0;
				}
				$json['status']="ok";
				return $json;
			}
		}
		return view('merchant/appment');
	}

	/****码商余额充值****/
	public function recharge(Request $arr){
		if($arr->isMethod('post')){
			if($arr->input('action') == 'exorder'){
				//查询当前订单
				$orderinfo = DB::table('order')->where('apiorder_id',$arr->input('order_id'))->first();
				if($orderinfo){
					if($orderinfo->status == 2){
						$json['code'] = 100;
					}else if($orderinfo->com_time < time()){
						$json['code'] = 102;
					}else{
						$json['code'] = 101;
					}
				}else{
					$json['code'] = 99;
				}
			}else{
				$data = $arr->all();
				/***判断后台是否设置充值****/
				$postdata['merchant_key']=DB::table('admin_site')->first()->pay_merchant_key;
				$postdata['user_id']=DB::table('admin_site')->first()->pay_user_id;
				if(!empty($postdata['user_id']) && !empty($postdata['merchant_key'])){
					$userinfo = DB::table('user')->where('Id',$postdata['user_id'])->first();
					$merchant = DB::table('member')->where('apikey',$postdata['merchant_key'])->first();
					if($userinfo && $merchant){
						/******发送API订单*******/
						$postdata['merchant_key']=DB::table('admin_site')->first()->pay_merchant_key;
						$postdata['user_id']=DB::table('admin_site')->first()->pay_user_id;
						$postdata['order_id'] = date('Ymdhis',time().rand(10000,99999));
						$postdata['format'] = "json";
						$postdata['ip'] = $arr->getClientIp();
						$postdata['amount']=$data['money'];
						$postdata['return_url']="http://".config('route.domain.api');
						$postdata['notice_url']="http://".config('route.domain.api')."/merchant_notice";
						$postdata['paytype']=$data['type'];
						$postdata['sign']=getsign($postdata,$userinfo->token);

						try {
							$client= new Client();
							$url="http://".config('route.domain.api').'/pay';
							$res = $client->request('post',$url,[
									'verify'=>false,
									'connect_timeout' =>7,
									'http_errors' => false,
									'timeout'=>7,
									'form_params'=>$postdata
							]);

							if($res->getStatusCode() == 200){
								$return_data = json_decode($res->getBody(),true);
								if($return_data['state'] == 1){
									$adddata['member_id'] = session()->get('merchant')['Id'];
									$adddata['order_id'] = $postdata['order_id'];
									$adddata['amount'] = $postdata['amount'];
									$adddata['amount_actual'] = $return_data['amount_actual'];
									$adddata['type']=$data['type'];
									$adddata['sub_time'] = time();
									$adddata['com_time'] = $return_data['endtime'];
									$status = DB::table('member_pay')->insert($adddata);
									if($status){
										$json['status'] = "ok";
										$json['data'] =  $return_data;
									}else{
										$json['status'] = "error";
										$json['msg'] = "当前平台充值用户过多,请重新提交";
									}
								}else{
									$json['status'] = "error";
									$json['msg'] = $return_data['msg'];
								}
							}else{
								$json['status'] = "error";
								$json['msg'] = "平台繁忙,请重新提交";
							}
						}catch (\Exception $e) {
							$json['status'] = "error";
							$json['msg'] = "平台繁忙,请重新提交";
						}
					}else{
						$json['status'] = "error";
						$json['msg'] ="平台未开启在线充值,请联系客服充值哦";
					}
				}else{
					$json['status'] = "error";
					$json['msg'] ="平台未开启在线充值,请联系客服充值哦";
				}
			}
			return $json;
		}
		return view('merchant/recharge');
	}

	/****二维码生成****/
	public function qrcode(Request $arr){
		if($arr->isMethod('get')){
			if($arr->filled('url') && $arr->filled('type')){
				$res = $arr->all();
				try {
					$img = "/public/members/img/{$res['type']}.png";
					$data = QrCode::format('png')->size(200)->margin(0)->generate($res['url']);
					$url = base64_encode($data);
					$json['state'] = 1;
					$json['data']  = "data:image/png;base64,".$url;
				} catch (Exception $e) {
					$json['state'] = 0;
					$json['msg']  = $e->getMessage();
				}
			}else{
				$json['state'] = 0;
				$json['msg'] ="不安全的提交方式";
			}
			return $json;
		}
	}

	/****码商所有通道账户管理****/
	public function pollinglist(Request $arr){
		if($arr->isMethod('post')){
			if($arr->has('page')){
				$map['member_id']=session()->get('merchant')['Id'];
				//搜索条件
				if($arr->has('field') && !is_null($arr->input('field')) && $arr->input('field')!= '-1' && !is_null($arr->input('value'))){
					$map[]=[$arr->input('field'),'like','%'.$arr->input('value').'%'];
				}
				if($arr->has('status') && !is_null($arr->input('status')) && $arr->input('status')!= '-1'){
					$map['status']=$arr->input('status');
				}
				if($arr->has('type') && !is_null($arr->input('type')) && $arr->input('type')!= '-1'){
					$map['type']=$arr->input('type');
				}
				$diepagelist=DB::table('member_polling')->where($map)->orderBy('id','desc')->paginate(15)->toarray();
				if(intval($diepagelist['total']) >= 1){
					foreach ($diepagelist['data'] as $v) {
						$v=(array)$v;
						$v['time']=date('Y-m-d H:i:s',$v['time']);
						$v['Id']=Hashids::encode($v['Id']);
						$list[]=$v;
					}
					$json['data']['list']=$list;
				}else{
					$json['data']['list']=0;
				}
				$json['current_page']=$diepagelist['current_page'];
				$json['total']=$diepagelist['total'];
				$json['status']="ok";
			}else if($arr->input('action')=='close' || $arr->input('action')=='open' && $arr->has('username')){
				if($arr->input('action')=='close'){
					$data2['loop']=2;
					$json['msg']="关闭轮循成功!";
				}else{
					$data2['loop']=1;
					$json['msg']="开启轮循成功!";
				}
				//判断当前账户是否在线
				$map['member_id']=session()->get('merchant')['Id'];
				$map['username']=$arr->input('username');
				$polling = DB::table('member_polling')->where($map)->first();
				if($polling){
					if($polling->status == 1){
						$Order_Redis = new Order_Redis;
						$admin_site = DB::table('admin_site')->first();
						if($data2['loop'] == 2){
							//清除当前账户下的收款通道
							$code_type = $polling->type;
	                        $data['polling_id']= $polling->Id;
	                        /****删除支付宝二维码****/
	                        $Order_Redis->delete($admin_site->payment_type,'alipay',$code_type,$data);
	                        /****删除支付宝H5二维码****/
	                        $Order_Redis->delete($admin_site->payment_type,'aliwap',$code_type,$data);
	                        /****删除微信二维码****/
	                        $Order_Redis->delete($admin_site->payment_type,'wechat',$code_type,$data);
	                        /****删除银联二维码****/
	                        $Order_Redis->delete($admin_site->payment_type,'unionpay',$code_type,$data);
						}else{
							//添加当前账户下的可用收款通道
							$P = $polling->type == 1 ? new DiepollingpaymentModel : new LivepollingpaymentModel;
							$payment = $P->where(array('polling_id'=>$polling->Id,'gateway_state'=>1))->whereHas('user',function($query){
					    		$query->where('status','=',1);
					    		$query->where('loop','=',1);
					    	})->whereHas('merchant',function($query){
					    		$query->where('price','>',1);
					    		$query->where('frozen_amount','>=',0);
					    	})->with('user','payment','merchant')->get();
							if(!$payment->isEmpty()){
								$order_redis_list = $payment->toarray();
								$typename = $polling->type == 1 ? 'die' : 'live';
								//添加到收款池
								if($admin_site->payment_type == 1){
									//添加顺序池
									foreach ($order_redis_list as $v) {
                                        $v = (array)$v;
                                        if(stristr($v['payment']['paytype'],'alipay') !== false){
                                            //添加顺序列表
                                            Redis::rpush('sort_alipay_'.$typename,json_encode($v));
                                        }
                                        if(stristr($v['payment']['paytype'],'aliwap') !== false){
                                            //添加顺序列表
                                            Redis::rpush('sort_aliwap_'.$typename,json_encode($v));
                                        }
                                        if(stristr($v['payment']['paytype'],'wechat') !== false){
                                            //添加顺序列表
                                            Redis::rpush('sort_wechat_'.$typename,json_encode($v));
                                        }
                                        if(stristr($v['payment']['paytype'],'unionpay') !== false){
                                            //添加顺序列表
                                            Redis::rpush('sort_unionpay_'.$typename,json_encode($v));
                                        }
                                    }
								}else{
									//添加随机池
									foreach ($order_redis_list as $v) {
                                        $v = (array)$v;
                                        if(stristr($v['payment']['paytype'],'alipay') !== false){
                                            //添加随机列表
                                            Redis::sadd('random_alipay_'.$typename,json_encode($v));
                                        }
                                        if(stristr($v['payment']['paytype'],'aliwap') !== false){
                                            //添加随机列表
                                            Redis::sadd('random_aliwap_'.$typename,json_encode($v));
                                        }
                                        if(stristr($v['payment']['paytype'],'wechat') !== false){
                                            //添加随机列表
                                            Redis::sadd('random_wechat_'.$typename,json_encode($v));
                                        }
                                        if(stristr($v['payment']['paytype'],'unionpay') !== false){
                                            //添加随机列表
                                            Redis::sadd('random_unionpay_'.$typename,json_encode($v));
                                        }
                                    }
								}
							}
						}
					}
					$status=DB::table('member_polling')->where($map)->update($data2);
					if(!$status){
						$json['status']="error";
						$json['msg']="当前账户已开启轮循或已关闭!";
					}else{
						$json['status']="ok";
					}
				}else{
					$json['status']="error";
					$json['msg']="当前账户不存在";
				}
			}else if($arr->input('action')=='add'){
				$data = $arr->input('form');
				//判断当前商户是否开启谷歌验证
				$merchant = DB::table('member')->where('id',session()->get('merchant')['Id'])->first();
				if($merchant->safety == 1){
					//验证谷歌验证码是否正确
					if(!empty($data['code'])){
						$ga = new Google;
						$checkResult = $ga->verifyCode($merchant->safetycode,trim($data['code']),2);
						if(!$checkResult){
							$json['status'] = "error";
							$json['msg'] = "当前谷歌验证码错误";
						}
					}else{
						$json['status']="error";
						$json['msg'] = "请输入谷歌验证码";
					}
				}
				if(!isset($json)){
					if(!empty($data['remarks'])){
						if(checkpass($data['password'])){
							$merchantinfo = DB::table('member')->where('Id',session()->get('merchant')['Id'])->first();
							//查询该码商有几个对应码的账户
							$pollingnum = DB::table('member_polling')->where(array(
									'member_id'=>$merchantinfo->Id,
									'type'=>$data['type']
							))->count();
							if($data['type'] == 1){
								if($merchantinfo->diepolling_num !=0 && $pollingnum >= $merchantinfo->diepolling_num){
									$json['status'] ="error";
									$json['msg'] = "限制添加{$pollingnum}个固码账户";
								}
							}else{
								if($merchantinfo->livepolling_num !=0 && $pollingnum >= $merchantinfo->livepolling_num){
									$json['status'] ="error";
									$json['msg'] = "限制添加{$pollingnum}个活码账户";
								}
							}
							if(!isset($json)){
								$max_user =DB::table('member_polling')->max('username');
								if(!empty($max_user)){
									$addarr['username'] = 'YM'.(str_replace("YM","",$max_user)+1);
								}else{
									$addarr['username'] = 'YM10000';
								}
								$addarr['member_id'] = $merchantinfo->Id;
								$addarr['type'] = $data['type'];
								$addarr['password'] = xpass($data['password']);
								$addarr['remarks'] = $data['remarks'];
								$addarr['time'] = time();
								$status = DB::table('member_polling')->insert($addarr);
								if($status){
									$json['status'] = "ok";
									$json['msg'] = "添加账户成功";
								}else{
									$json['status'] = "error";
									$json['msg'] = "添加账户失败";
								}
							}
						}else{
							$json['status'] = "error";
							$json['msg'] = "密码请设置在6~20位";
						}
					}else{
						$json['status'] = "error";
						$json['msg'] = "请填写账号备注";
					}
				}
			}else if($arr->input('action') == 'edit'){
				$data = $arr->input('form');
				//判断当前商户是否开启谷歌验证
				$merchant = DB::table('member')->where('id',session()->get('merchant')['Id'])->first();
				if($merchant->safety == 1){
					//验证谷歌验证码是否正确
					if(!empty($data['code'])){
						$ga = new Google;
						$checkResult = $ga->verifyCode($merchant->safetycode,trim($data['code']),2);
						if(!$checkResult){
							$json['status'] = "error";
							$json['msg'] = "当前谷歌验证码错误";
						}
					}else{
						$json['status']="error";
						$json['msg'] = "请输入谷歌验证码";
					}
				}
				if(!isset($json)){
					if(!empty($data['remarks'])){
						$updata['remarks'] = $data['remarks'];
						if(!empty($data['password'])){
							if(checkpass($data['password'])){
								$updata['password'] = xpass($data['password']);
							}else{
								$json['status'] = "error";
								$json['msg'] = "密码请设置在6~20位";
							}
						}
						if(!isset($json)){
							$status = DB::table('member_polling')->where('Id',Hashids::decode($data['Id'])[0])->update($updata);
							if($status){
								$json['status'] = "ok";
								$json['msg'] = "修改成功";
							}else{
								$json['status'] = "error";
								$json['msg'] = "当前无更改修改失败";
							}
						}
					}else{
						$json['status'] = "error";
						$json['msg'] = "请填写账号备注";
					}
				}
			}else{
				$json['status']="error";
			}
			return $json;
		}

		return view('merchant/pollinglist');
	}

	/****码商账户固码通道管理****/
	public function diecode(Request $arr){
		if($arr->isMethod('post')){
			if($arr->has('page')){
				$map['member_id']=session()->get('merchant')['Id'];
				if($arr->has('uid') && !is_null($arr->input('uid')) && $arr->input('uid')!= '-1'){
					if(Hashids::decode($arr->input('uid'))){
						$map['polling_id']=Hashids::decode($arr->input('uid'))[0];
					}
				}
				if($arr->has('passageway_id') && !is_null($arr->input('passageway_id')) && $arr->input('passageway_id')!= '-1'){
					$map['passageway_id']=$arr->input('passageway_id');
				}
				$map2 = $map;
				if($arr->has('region_id') && !is_null($arr->input('region_id')) && $arr->input('region_id')!=  999999){
					$map['region_id']=$arr->input('region_id');
				}
				if($arr->has('city_id') && !is_null($arr->input('city_id')) && $arr->input('city_id')!= 0){
					$map['city_id']=$arr->input('city_id');
				}
				$dielist=DiepollingpaymentModel::where($map)->with('user','payment')->orderBy('id','desc')->paginate(15)->toarray();
				/****通道数量****/
				$json['data']['text']['count']=DiepollingpaymentModel::where($map2)->count();
				if(isset($map2['polling_id'])){
					//查询该账户账号
					$map2['polling_user']=DB::table('member_polling')->where('Id',$map2['polling_id'])->first()->username;
					unset($map2['polling_id']);
				}
				/****通道成功收款金额****/
				$map2['status']=2;
				$map2['code_type']=1;
				$json['data']['text']['order_price']=OrderModel::where($map2)->sum('order_price');
				/****通道成功盈利****/
				$json['data']['text']['profit']=number_format(OrderModel::where($map2)->sum('order_service')+OrderModel::where($map2)->sum('software_service')-OrderModel::where($map2)->sum('passageway_service'),3,".","");

				if(intval($dielist['total']) >= 1){
					$data=$dielist['data'];
					foreach ($data as $k => $v) {
						$v=(array)$v;
						if($v['passageway_id']	== 804){
							$v['bankcard']=cut('cardNo=','&bank',$v['qrcode']);
							$v['bankname']=urldecode(cut('bankAccount=','&bankMark',$v['qrcode']));
							$v['cardid']=cut('cardIndex=','&money',$v['qrcode']);
							unset($v['qrcode']);
						}
						$map3['status']=2;
						$map3['polling_passageway_key']=$v['key'];
						$map3[]=['sub_time','<',strtotime(date('Y-m-d 00:00:00'))+86400];
						$map3[]=['sub_time','>=',strtotime(date('Y-m-d 00:00:00'))];
						$v['today_amount'] = OrderModel::where($map3)->sum('order_price');
						$v['check'] = false;
						$v['polling_id']=Hashids::encode($v['polling_id']);
						$json['data']['list'][]=$v;
					}
				}else{
					$json['data']['list']=0;
				}
				$json['current_page']=$dielist['current_page'];
				$json['total']=$dielist['total'];
			}else if($arr->input('action')=='add' || $arr->input('action')=='edit' && $arr->has('key') && $arr->filled('polling_id')){
				try {
					$data=$arr->all();
					$data['polling_id']=Hashids::decode($data['polling_id'])[0];
					unset($data['action']);
					unset($data['key']);
					//查询当前商户是否支持当前通道
					$channelinfo = DB::table('memberpayment')->where(array('member_id'=>session()->get('merchant')['Id'],'passageway_type'=>1,'passageway_id'=>$data['passageway_id']))->first();
					if($channelinfo){
						//判断当前商户是否开启谷歌验证
						$merchant = DB::table('member')->where('id',session()->get('merchant')['Id'])->first();
						if($merchant->safety == 1){
							//验证谷歌验证码是否正确
							if(!empty($data['code'])){
								$ga = new Google;
								$checkResult = $ga->verifyCode($merchant->safetycode,trim($data['code']),2);
								if(!$checkResult){
									$json['status'] = "error";
									$json['msg'] = "当前谷歌验证码错误";
								}
							}else{
								$json['status']="error";
								$json['msg'] = "请输入谷歌验证码";
							}
						}
						if(!isset($json)){
							if($data['passageway_id'] == 804){
								//验证添加银行是否支持
								$bankreturn=addalicard($data['bankcard']);
								if($bankreturn['code'] == 1){
									//验证CardId是否正确
									if(preg_match("/^[0-9]{19}$/",$data['cardid'])){
										//拼接二维码
										$data['qrcode']="alipays://platformapi/startapp?appId=09999988&actionType=toCard&sourceId=bill&cardNoHidden=true&cardChannel=HISTORY_CARD&orderSource=from&cardNo=".$data['bankcard']."&bankAccount=".urlencode($data['bankname'])."&bankMark=".$bankreturn['data']['bank']."&cardIndex=".$data['cardid']."&money=(order_price)&amount=(order_price)";
										//查询是否已添加过该银行卡生成的二维码
										$map[]=['qrcode','like','%'.$data['bankcard'].'%'];
										$info=DB::table('member_diepolling_payment')->where($map)->first();
										if($arr->input('action') == 'add'){
											if($info){
												$json['status']="error";
												$json['msg']="平台已拥有该银行卡号,如有疑问请咨询客服";
											}
										}else{
											if($info){
												if(isset($info->key)){
													if($info->key != $arr->input('key')){
														$json['status']="error";
														$json['msg']="平台已拥有该银行卡号,如有疑问请咨询客服";
													}
												}
											}
										}
									}else{
										$json['status']="error";
										$json['msg']="当前支付宝CardId不正确";
									}
								}else{
									$json['status']="error";
									$json['msg']=$bankreturn['msg'];
								}
							}else{
								if($arr->input('action') == 'edit'){
									//验证二维码是否匹配
									if(!empty($data['qrcode'])){
										if(!checkqrcode($data)){
											$json['status']="error";
											$json['msg']="请填写正确的二维码";
										}else{
											//查询平台是否存在该二维码
											$map[]=['qrcode','like','%'.$data['qrcode'].'%'];
											$qrinfo=DB::table('member_diepolling_payment')->where($map)->first();
											if($qrinfo){
												if(isset($qrinfo->key)){
													if($qrinfo->key != $arr->input('key')){
														$json['status']="error";
														$json['msg']="平台已拥有该二维码,如有疑问请咨询客服";
													}
												}
											}
										}
									}else{
										$data['qrcode'] = 2;
									}
								}else{
									//是否填写二维码
									if(!empty($data['qrcode'])){
										//验证二维码是否匹配
										if(!checkqrcode($data)){
											$json['status']="error";
											$json['msg']="请填写正确的二维码";
										}else{
											//查询平台是否存在该二维码
											$map[]=['qrcode','like','%'.$data['qrcode'].'%'];
											$qrinfo=DB::table('member_diepolling_payment')->where($map)->first();
											if($qrinfo){
												$json['status']="error";
												$json['msg']="平台已拥有该二维码,如有疑问请咨询客服";
											}
										}
									}else{
										$data['qrcode'] = 2;
									}
								}
							}
						}
					}else{
						$json['status']="error";
						$json['msg']="当前不支持添加此通道,请联系客服开通";
					}
					if(!isset($json)){
						unset($data['bankcard']);
						unset($data['bankname']);
						unset($data['cardid']);
						unset($data['code']);
						if($data['region_id'] == 999999){
							$data['region_name']="全国";
						}else{
							$data['region_name']=DB::table('region')->where('region_id',$data['region_id'])->first()->region_name;
						}
						if($data['city_id'] ==  0){
							$data['city_name'] = "全市";
						}else{
							$data['city_name'] = DB::table('region')->where('city_id',$data['city_id'])->first()->city_name;
						}
						if(!empty($data['remarks'])){
							if(!empty($data['today_money'])){
								if((float)$data['today_money'] > 200000 || (float)$data['today_money']< 0){
									$data['today_money']=0;
								}
							}else{
								$data['today_money']=0;
							}
							if(!empty($data['total_money'])){
								if((float)$data['total_money'] > 10000000 || (float)$data['total_money']< 0){
									$data['total_money']=0;
								}
							}else{
								$data['total_money']=0;
							}
							if($arr->input('action') == 'add'){
								//查询是否存在该通道
								$map2['polling_id']=$data['polling_id'];
								$map2['passageway_id']=$data['passageway_id'];
								$info=DB::table('member_diepolling_payment')->where($map2)->first();
								if($info && $data['passageway_id'] != 804){
									$json['status']="error";
									$json['msg']="该账户已添加过该通道,请勿重复添加";
								}
								if(!isset($json)){
									$data['key']=getpassagewaykey();
									$data['member_id']=session()->get('merchant')['Id'];
									$status=DB::table('member_diepolling_payment')->insert($data);
									if($status){
										$json['status']="ok";
										$json['msg']="添加通道成功";
									}else{
										$json['status']="error";
										$json['msg']="当前无更改,添加通道失败";
									}
								}
							}else{
								$payinfo=DiepollingpaymentModel::where('key',$arr->input('key'))->with('user','payment','merchant')->first();
								if($data['passageway_id'] != $payinfo->passageway_id && $data['passageway_id'] != 804){
									$map2['polling_id']=$data['polling_id'];
									$map2['passageway_id']=$data['passageway_id'];
									$payinfos=DB::table('member_diepolling_payment')->where($map2)->first();
									if($payinfos){
										$json['status']="error";
										$json['msg']="该账户已添加过该通道,请勿重复";
									}
								}
								if($payinfo->gateway_state == 1 && $data['qrcode'] == 2){
									$json['status']="error";
									$json['msg']="请先关闭该通道网关再留空";
								}
								if(!isset($json)){
									$data2['qrcode']=$data['qrcode'];
									$data2['passageway_id']=$data['passageway_id'];
									$data2['polling_id']=$data['polling_id'];
									$data2['remarks']=$data['remarks'];
									$data2['today_money']=$data['today_money'];
									$data2['total_money']=$data['total_money'];
									$data2['region_id']  = $data['region_id'];
									$data2['region_name'] = $data['region_name'];
									$data2['city_id'] = $data['city_id'];
									$data2['city_name']=  $data['city_name'];
									$status=DB::table('member_diepolling_payment')->where('key',$arr->input('key'))->update($data2);
									if($status){
										//查询该二维码新数据
										$payment = DiepollingpaymentModel::where('key',$arr->input('key'))->with('user','payment','merchant')->first();
										//判断平台出码方式
                                        $admin_site=DB::table('admin_site')->first();
                                        $order_redis = new Order_Redis;
                                        //清除该通道二维码
                                        $order_redis->delete($admin_site->payment_type,'alipay',1,array('key'=>$payment->key));
                                        $order_redis->delete($admin_site->payment_type,'aliwap',1,array('key'=>$payment->key));
                                        $order_redis->delete($admin_site->payment_type,'wechat',1,array('key'=>$payment->key));
                                        $order_redis->delete($admin_site->payment_type,'unionpay',1,array('key'=>$payment->key));
										if($payment->user->status == 1 && $payment->qrcode != 2 && $payment->user->loop == 1 && $payment->merchant->price>1 && $payment->merchant->frozen_amount >= 0){
                                            if($admin_site->payment_type == 1){
                                                if(stristr($payment->payment->paytype,'alipay') !== false){
                                                    Redis::rpush('sort_alipay_die',json_encode($payment));
                                                }
                                                if(stristr($payment->payment->paytype,'aliwap') !== false){
                                                    Redis::rpush('sort_aliwap_die',json_encode($payment));
                                                }
                                                if(stristr($payment->payment->paytype,'wechat') !== false){
                                                    Redis::rpush('sort_wechat_die',json_encode($payment));
                                                }
                                                if(stristr($payment->payment->paytype,'unionpay') !== false){
                                                    Redis::rpush('sort_unionpay_die',json_encode($payment));
                                                }
                                            }else{
                                                if(stristr($payment->payment->paytype,'alipay') !== false){
                                                    Redis::sadd('random_alipay_die',json_encode($payment));
                                                }
                                                if(stristr($payment->payment->paytype,'aliwap') !== false){
                                                    Redis::sadd('random_aliwap_die',json_encode($payment));
                                                }
                                                if(stristr($payment->payment->paytype,'wechat') !== false){
                                                    Redis::sadd('random_wechat_die',json_encode($payment));
                                                }
                                                if(stristr($payment->payment->paytype,'unionpay') !== false){
                                                    Redis::sadd('random_unionpay_die',json_encode($payment));
                                                }
                                            }
										}
										$json['status']="ok";
										$json['msg']="修改通道成功";
									}else{
										$json['status']="error";
										$json['msg']="当前无更改,修改通道失败";
									}
								}
							}
						}else{
							$json['status']="error";
							$json['msg']="请填写通道备注";
						}
					}
				} catch (\Exception $e) {
					$json['status']="error";
					$json['msg']=$e->getMessage();
				}
			}else if($arr->input('action')=='del' && $arr->filled('keyarr')){
				$num = 0;
				$admin_site = DB::table('admin_site')->first();
				$Order_Redis = new Order_Redis;
				foreach ($arr->input('keyarr') as $k => $v) {
					$delnum=DB::table('member_diepolling_payment')->where('key',$v)->delete();
					if($delnum != 0){
						//删除此通道收款池
						$Order_Redis->delete($admin_site->payment_type,'alipay',1,array('key'=>$v));
                        /****删除支付宝H5二维码****/
                        $Order_Redis->delete($admin_site->payment_type,'aliwap',1,array('key'=>$v));
                        /****删除微信二维码****/
                        $Order_Redis->delete($admin_site->payment_type,'wechat',1,array('key'=>$v));
                        /****删除银联二维码****/
                        $Order_Redis->delete($admin_site->payment_type,'unionpay',1,array('key'=>$v));
						$num++;
					}
				}
				if($num!= 0){
					$json['status']="ok";
					$json['msg']="删除成功,共删除{$num}个";
				}else{
					$json['status']="error";
					$json['msg']="出现错误,删除失败";
				}
			}else if($arr->input('action')=='open' || $arr->input('action')=='close' && $arr->filled('key')){
				//查询当前二维码是否为空
				$info = DiepollingpaymentModel::where('key',$arr->input('key'))->with('user','payment','merchant')->first();
				if($arr->input('action')=='open'){
					if($info->qrcode == 2){
						$json['status'] = "error";
						$json['msg'] = "当前二维码未传入,请传入后再开启网关";
					}
					$data['gateway_state']=1;
				}else{
					$data['gateway_state']=2;
				}
				if(!isset($json)){
					$status=DB::table('member_diepolling_payment')->where('key',$arr->input('key'))->update($data);
					if($status){
						$admin_site = DB::table('admin_site')->first();
						$order_redis = new Order_Redis;
                        //清除该通道二维码
                        $order_redis->delete($admin_site->payment_type,'alipay',1,array('key'=>$info->key));
                        $order_redis->delete($admin_site->payment_type,'aliwap',1,array('key'=>$info->key));
                        $order_redis->delete($admin_site->payment_type,'wechat',1,array('key'=>$info->key));
                        $order_redis->delete($admin_site->payment_type,'unionpay',1,array('key'=>$info->key));
						//查询当前账户是否在线
						if($info->user->status == 1 && $info->user->loop == 1 && $info->merchant->price >1 && $info->merchant->frozen_amount >= 0){
							$info->gateway_state = 1;
							if($data['gateway_state'] == 1){
								//添加二维码
								if($admin_site->payment_type == 1){
									if(stristr($info->payment->paytype,'alipay') !== false){
                                        Redis::rpush('sort_alipay_die',json_encode($info));
                                    }
                                    if(stristr($info->payment->paytype,'aliwap') !== false){
                                        Redis::rpush('sort_aliwap_die',json_encode($info));
                                    }
                                    if(stristr($info->payment->paytype,'wechat') !== false){
                                        Redis::rpush('sort_wechat_die',json_encode($info));
                                    }
                                    if(stristr($info->payment->paytype,'unionpay') !== false){
                                        Redis::rpush('sort_unionpay_die',json_encode($info));
                                    }
								}else{
									if(stristr($info->payment->paytype,'alipay') !== false){
                                        Redis::sadd('random_alipay_die',json_encode($info));
                                    }
                                    if(stristr($info->payment->paytype,'aliwap') !== false){
                                        Redis::sadd('random_aliwap_die',json_encode($info));
                                    }
                                    if(stristr($info->payment->paytype,'wechat') !== false){
                                        Redis::sadd('random_wechat_die',json_encode($info));
                                    }
                                    if(stristr($info->payment->paytype,'unionpay') !== false){
                                        Redis::sadd('random_unionpay_die',json_encode($info));
                                    }
								}
							}
						}
						$json['status']="ok";
						$json['msg'] = $arr->input('action')=='open' ? "网关开启成功" : "网关关闭成功";
					}else{
						$json['status']="error";
						$json['msg']= $arr->input('action')=='open'  ? "当前网关开启过了哦"  : "当前网关关闭过了哦";
					}
				}
			}else if($arr->input('action') == 'region'){
				$json['status']="ok";
				$json['region'] = DB::table('region')->select(['region_name','region_id'])->distinct()->get()->toArray();
				if($arr->filled('region_id') && $arr->input('region_id')!= 999999){
					$json['city'] = DB::table('region')->where('region_id',$arr->input('region_id'))->select(['city_name','city_id'])->get()->toArray();
				}else{
					$json['city'][] = array('city_name'=>"全市",'city_id'=>0);
				}
			}else if($arr->input('action')=='getuser'){
				$map['member_id']=session()->get('merchant')['Id'];
				$map['type']=1;
				$userarr=DB::table('member_polling')->where($map)->select('Id','username')->get()->toarray();
				foreach ($userarr as $k => $v) {
					$v=(array)$v;
					$v['Id'] = Hashids::encode($v['Id']);
					$json['data'][]=$v;
				}
				if(!empty($json['data'])){
					$json['status']="ok";
				}else{
					$json['status']="error";
				}
			}else{
				$json['status']="error";
				$json['msg']="不安全的提交方式";
			}
			return $json;
		}
		return view('merchant/diecode');
	}

	/****码商账户活码管理****/
	public function livecode(Request $arr){
		if($arr->isMethod('post')){
			if($arr->has('page')){
				$map['member_id']=session()->get('merchant')['Id'];
				if($arr->has('uid') && !is_null($arr->input('uid')) && $arr->input('uid')!= '-1'){
					if(Hashids::decode($arr->input('uid'))){
						$map['polling_id']=Hashids::decode($arr->input('uid'))[0];
					}
				}
				if($arr->has('passageway_id') && !is_null($arr->input('passageway_id')) && $arr->input('passageway_id')!= '-1'){
					$map['passageway_id']=$arr->input('passageway_id');
				}
				$map2 = $map;
				if($arr->has('region_id') && !is_null($arr->input('region_id')) && $arr->input('region_id')!=  999999){
					$map['region_id']=$arr->input('region_id');
				}
				if($arr->has('city_id') && !is_null($arr->input('city_id')) && $arr->input('city_id')!= 0){
					$map['city_id']=$arr->input('city_id');
				}
				$livelist=LivepollingpaymentModel::where($map)->with('user','payment')->orderBy('id','desc')->paginate(15)->toarray();
				/****通道数量****/
				$json['data']['text']['count']=LivepollingpaymentModel::where($map2)->count();
				if(isset($map2['polling_id'])){
					//查询该账户账号
					$map2['polling_user']=DB::table('member_polling')->where('Id',$map2['polling_id'])->first()->username;
					unset($map2['polling_id']);
				}
				/****通道成功收款金额****/
				$map2['status']=2;
				$map2['code_type']=2;
				$json['data']['text']['order_price']=OrderModel::where($map2)->sum('order_price');
				/****通道成功盈利****/
				$json['data']['text']['profit']=number_format(OrderModel::where($map2)->sum('order_service')+OrderModel::where($map2)->sum('software_service')-OrderModel::where($map2)->sum('passageway_service'),3,".","");

				if(intval($livelist['total']) >= 1){
					$data=$livelist['data'];
					foreach ($data as $k => $v) {
						$v=(array)$v;
						$v['check'] = false;
						$v['polling_id']=Hashids::encode($v['polling_id']);
						$map3['status']=2;
						$map3['polling_passageway_key']=$v['key'];
						$map3[]=['sub_time','<',strtotime(date('Y-m-d 00:00:00'))+86400];
						$map3[]=['sub_time','>=',strtotime(date('Y-m-d 00:00:00'))];
						$v['today_amount'] = OrderModel::where($map3)->sum('order_price');
						$json['data']['list'][]=$v;
					}
				}else{
					$json['data']['list']=0;
				}
				$json['current_page']=$livelist['current_page'];
				$json['total']=$livelist['total'];
			}else if($arr->input('action')=='add' || $arr->input('action')=='edit' && $arr->has('key') && $arr->filled('polling_id')){
				$data=$arr->all();
				$data['polling_id']=Hashids::decode($data['polling_id'])[0];
				unset($data['action']);
				unset($data['key']);
				//查询当前商户是否支持当前通道
				$channelinfo = DB::table('memberpayment')->where(array('member_id'=>session()->get('merchant')['Id'],'passageway_type'=>2,'passageway_id'=>$data['passageway_id']))->first();
				if($channelinfo){
					//判断当前商户是否开启谷歌验证
					$merchant = DB::table('member')->where('id',session()->get('merchant')['Id'])->first();
					if($merchant->safety == 1){
						//验证谷歌验证码是否正确
						if(!empty($data['code'])){
							$ga = new Google;
							$checkResult = $ga->verifyCode($merchant->safetycode,trim($data['code']),2);
							if(!$checkResult){
								$json['status'] = "error";
								$json['msg'] = "当前谷歌验证码错误";
							}
						}else{
							$json['status']="error";
							$json['msg'] = "请输入谷歌验证码";
						}
					}
					if(!isset($json)){
						unset($data['code']);
						if($data['region_id'] == 999999){
							$data['region_name']="全国";
						}else{
							$data['region_name']=DB::table('region')->where('region_id',$data['region_id'])->first()->region_name;
						}
						if($data['city_id'] ==  0){
							$data['city_name'] = "全市";
						}else{
							$data['city_name'] = DB::table('region')->where('city_id',$data['city_id'])->first()->city_name;
						}
						if(!empty($data['remarks'])){
							if($arr->input('action') == 'add'){
								if(!empty($data['today_money'])){
									if((float)$data['today_money'] > 200000 || (float)$data['today_money']< 0){
										$data['today_money']=0;
									}
								}else{
									$data['today_money']=0;
								}
								if(!empty($data['total_money'])){
									if((float)$data['total_money'] > 10000000 || (float)$data['today_money']< 0){
										$data['total_money']=0;
									}
								}else{
									$data['total_money']=0;
								}
								//查询是否存在该通道
								$map2['polling_id']=$data['polling_id'];
								$map2['passageway_id']=$data['passageway_id'];
								$info=DB::table('member_livepolling_payment')->where($map2)->first();
								if(!$info){
									$data['key'] = getpassagewaykey();
									$data['member_id'] = session()->get('merchant')['Id'];
									$status = DB::table('member_livepolling_payment')->insert($data);
									if($status){
										$json['status']="ok";
										$json['msg']="添加成功";
									}else{
										$json['status']="error";
										$json['msg']="添加通道失败";
									}
								}else{
									$json['status']="error";
									$json['msg']="当前账号已添加过该通道哦";
								}
							}else{
								if(!empty($data['today_money'])){
									if((float)$data['today_money'] > 200000 || (float)$data['today_money']< 0){
										$data['today_money']=0;
									}
								}else{
									$data['today_money']=0;
								}
								if(!empty($data['total_money'])){
									if((float)$data['total_money'] > 10000000 || (float)$data['today_money']< 0){
										$data['total_money']=0;
									}
								}else{
									$data['total_money']=0;
								}
								//查询是否存在修改的通道
								$payinfo=DB::table('member_livepolling_payment')->where('key',$arr->input('key'))->first();
								if($data['passageway_id'] != $payinfo->passageway_id){
									$map2['polling_id']=$data['polling_id'];
									$map2['passageway_id']=$data['passageway_id'];
									$info=DB::table('member_livepolling_payment')->where($map2)->first();
									if($info){
										$json['status']="error";
										$json['msg']="当前账号已存在该通道,请修改为其他通道";
									}else{
										$data2['passageway_id'] = $data['passageway_id'];
									}
								}
								if(!isset($json)){
									$data2['polling_id'] = $data['polling_id'];
									$data2['today_money'] = $data['today_money'];
									$data2['total_money'] = $data['total_money'];
									$data2['remarks'] = $data['remarks'];
									$data2['region_id']  = $data['region_id'];
									$data2['region_name'] = $data['region_name'];
									$data2['city_id'] = $data['city_id'];
									$data2['city_name']=  $data['city_name'];
									$status = DB::table('member_livepolling_payment')->where('key',$arr->input('key'))->update($data2);
									if($status){
										//查询该二维码新数据
										$payment = LivepollingpaymentModel::where('key',$arr->input('key'))->with('user','payment','merchant')->first();
										//判断平台出码方式
                                        $admin_site=DB::table('admin_site')->first();
                                        $order_redis = new Order_Redis;
		                                //清除该通道二维码
		                                $order_redis->delete($admin_site->payment_type,'alipay',2,array('key'=>$payment->key));
		                                $order_redis->delete($admin_site->payment_type,'aliwap',2,array('key'=>$payment->key));
		                                $order_redis->delete($admin_site->payment_type,'wechat',2,array('key'=>$payment->key));
		                                $order_redis->delete($admin_site->payment_type,'unionpay',2,array('key'=>$payment->key));
										if($payment->user->status == 1 && $payment->user->loop == 1 && $payment->merchant->price >1 && $payment->merchant->frozen_amount >= 0){
                                            if($admin_site->payment_type == 1){
                                                if(stristr($payment->payment->paytype,'alipay') !== false){
                                                    Redis::rpush('sort_alipay_live',json_encode($payment));
                                                }
                                                if(stristr($payment->payment->paytype,'aliwap') !== false){
                                                    Redis::rpush('sort_aliwap_live',json_encode($payment));
                                                }
                                                if(stristr($payment->payment->paytype,'wechat') !== false){
                                                    Redis::rpush('sort_wechat_live',json_encode($payment));
                                                }
                                                if(stristr($payment->payment->paytype,'unionpay') !== false){
                                                    Redis::rpush('sort_unionpay_live',json_encode($payment));
                                                }
                                            }else{
                                                if(stristr($payment->payment->paytype,'alipay') !== false){
                                                    Redis::sadd('random_alipay_live',json_encode($payment));
                                                }
                                                if(stristr($payment->payment->paytype,'aliwap') !== false){
                                                    Redis::sadd('random_aliwap_live',json_encode($payment));
                                                }
                                                if(stristr($payment->payment->paytype,'wechat') !== false){
                                                    Redis::sadd('random_wechat_live',json_encode($payment));
                                                }
                                                if(stristr($payment->payment->paytype,'unionpay') !== false){
                                                    Redis::sadd('random_unionpay_live',json_encode($payment));
                                                }
                                            }
										}
										$json['status']="ok";
										$json['msg']="修改成功";
									}else{
										$json['status']="error";
										$json['msg']="当前无更改修改失败";
									}
								}
							}
						}else{
							$json['status']="error";
							$json['msg']="请填写通道备注";
						}
					}
				}else{
					$json['status']="error";
					$json['msg']="当前不支持添加此通道,请联系客服开通";
				}
			}else if($arr->input('action')=='del' && $arr->filled('keyarr')){
				$num = 0;
				foreach ($arr->input('keyarr') as $k => $v) {
					$delnum=DB::table('member_livepolling_payment')->where('key',$v)->delete();
					if($delnum != 0){
						//删除此通道收款池
						$Order_Redis->delete($admin_site->payment_type,'alipay',2,array('key'=>$v));
                        /****删除支付宝H5二维码****/
                        $Order_Redis->delete($admin_site->payment_type,'aliwap',2,array('key'=>$v));
                        /****删除微信二维码****/
                        $Order_Redis->delete($admin_site->payment_type,'wechat',2,array('key'=>$v));
                        /****删除银联二维码****/
                        $Order_Redis->delete($admin_site->payment_type,'unionpay',2,array('key'=>$v));
						$num++;
					}
				}
				if($num!= 0){
					$json['status']="ok";
					$json['msg']="删除成功,共删除{$num}个";
				}else{
					$json['status']="error";
					$json['msg']="出现错误,删除失败";
				}
			}else if($arr->input('action')=='open' || $arr->input('action')=='close' && $arr->filled('key')){
				//查询当前信息
				$info = LivepollingpaymentModel::where('key',$arr->input('key'))->with('user','payment','merchant')->first();
				if($arr->input('action')=='open'){
					$data['gateway_state']=1;
					$json['msg']="开启成功";
					$error="当前网关开启过了哦";
				}else{
					$data['gateway_state']=2;
					$json['msg']="关闭成功";
					$error="当前网关关闭过了哦";
				}
				$status=DB::table('member_livepolling_payment')->where('key',$arr->input('key'))->update($data);
				if($status){
					$admin_site = DB::table('admin_site')->first();
					//删除二维码
					$order_redis = new Order_Redis;
                    //清除该通道二维码
                    $order_redis->delete($admin_site->payment_type,'alipay',2,array('key'=>$info->key));
                    $order_redis->delete($admin_site->payment_type,'aliwap',2,array('key'=>$info->key));
                    $order_redis->delete($admin_site->payment_type,'wechat',2,array('key'=>$info->key));
                    $order_redis->delete($admin_site->payment_type,'unionpay',2,array('key'=>$info->key));
					//查询当前账户是否在线
					if($info->user->status == 1 && $info->user->loop == 1 && $info->merchant->price >1 && $info->merchant->frozen_amount >= 0){
						$info->gateway_state = 1;
						if($data['gateway_state'] == 1){
							//添加二维码
							if($admin_site->payment_type == 1){
								if(stristr($info->payment->paytype,'alipay') !== false){
                                    Redis::rpush('sort_alipay_live',json_encode($info));
                                }
                                if(stristr($info->payment->paytype,'aliwap') !== false){
                                    Redis::rpush('sort_aliwap_live',json_encode($info));
                                }
                                if(stristr($info->payment->paytype,'wechat') !== false){
                                    Redis::rpush('sort_wechat_live',json_encode($info));
                                }
                                if(stristr($info->payment->paytype,'unionpay') !== false){
                                    Redis::rpush('sort_unionpay_live',json_encode($info));
                                }
							}else{
								if(stristr($info->payment->paytype,'alipay') !== false){
                                    Redis::sadd('random_alipay_live',json_encode($info));
                                }
                                if(stristr($info->payment->paytype,'aliwap') !== false){
                                    Redis::sadd('random_aliwap_live',json_encode($info));
                                }
                                if(stristr($info->payment->paytype,'wechat') !== false){
                                    Redis::sadd('random_wechat_live',json_encode($info));
                                }
                                if(stristr($info->payment->paytype,'unionpay') !== false){
                                    Redis::sadd('random_unionpay_live',json_encode($info));
                                }
							}
						}
					}
					$json['status']="ok";
				}else{
					$json['status']="error";
					$json['msg']=$error;
				}
			}else if($arr->input('action') == 'region'){
				$json['status']="ok";
				$json['region'] = DB::table('region')->select(['region_name','region_id'])->distinct()->get()->toArray();
				if($arr->filled('region_id') && $arr->input('region_id')!= 999999){
					$json['city'] = DB::table('region')->where('region_id',$arr->input('region_id'))->select(['city_name','city_id'])->get()->toArray();
				}else{
					$json['city'][] = array('city_name'=>"全市",'city_id'=>0);
				}
			}else if($arr->input('action')=='getuser'){
				$map['member_id']=session()->get('merchant')['Id'];
				$map['type']=2;
				$userarr=DB::table('member_polling')->where($map)->select('Id','username')->get()->toarray();
				foreach ($userarr as $k => $v) {
					$v=(array)$v;
					$v['Id'] = Hashids::encode($v['Id']);
					$json['data'][]=$v;
				}
				if(!empty($json['data'])){
					$json['status']="ok";
				}else{
					$json['status']="error";
				}
			}else{
				$json['status']="error";
				$json['msg']="不安全的提交方式";
			}
			return $json;
		}
		return view('merchant/livecode');
	}

	/****码商出单交易数据****/
	public function order_record(Request $arr){
		if($arr->isMethod('post')){
			if($arr->has('page')){
				$map['member_id']=session()->get('merchant')['Id'];
				//搜索条件
				if($arr->has('order') && !is_null($arr->input('order')) && $arr->input('order')!= '-1' && !is_null($arr->input('value'))){
					if($arr->input('order')=='order_money' || $arr->input('order')=='order_price'){
						$map[]=[$arr->input('order'),'=',$arr->input('value')];
					}else{
						$map[]=[$arr->input('order'),'like','%'.$arr->input('value').'%'];
					}
				}

				if($arr->has('status') && !empty($arr->input('status')) && $arr->input('status')!='-1'){
					$map['status']=$arr->input('status');
				}
				if($arr->has('code_type') && !empty($arr->input('code_type')) && $arr->input('code_type')!='-1'){
					$map['code_type']=$arr->input('code_type');
				}
				if($arr->has('passageway_id') && !empty($arr->input('passageway_id')) && $arr->input('passageway_id')!='-1'){
					$map['passageway_id']=$arr->input('passageway_id');
				}
				if($arr->has('paytype') && !empty($arr->input('paytype')) && $arr->input('paytype')!='-1'){
					$map['type']=$arr->input('paytype');
				}
				if($arr->has('time') && is_array($arr->input('time')) && $arr->input('time')!=','){
					$time=$arr->input('time');
					if(!empty($time[0]) && !empty($time[1])){
						$map[]=['sub_time','>=',strtotime($time[0])];
						$map[]=['sub_time','<',strtotime($time[1])+86400];
					}
				}
				//条件结束
				if($arr->input('action')=='main'){
					$map[]=['sub_time','<',strtotime(date('Y-m-d 00:00:00'))+86400];
					$map[]=['sub_time','>=',strtotime(date('Y-m-d 00:00:00'))-86400*15];
				}else{
					$map2=$map;
					/****总提交金额****/
					$json['data']['record_money']['totalmoney']=DB::table('order')->where($map2)->sum('order_money');
					$map2['status']=2;
					/****成功金额****/
					$json['data']['record_money']['successmoney']=DB::table('order')->where($map2)->sum('order_price');
					/****实际收入****/
					$json['data']['record_money']['lncome']=number_format(DB::table('order')->where($map2)->sum('order_service')+DB::table('order')->where($map2)->sum('software_service')-DB::table('order')->where($map2)->sum('passageway_service'),3,".","");
				}
				$orderarr=OrderModel::where($map)->with('livepassageway','diepassageway','livepollingpayment','diepollingpayment')->orderBy('id','desc')->paginate(15)->toarray();
				if(intval($orderarr['total']) >= 1){
					$order=$orderarr['data'];
					foreach($order as $k => $v){
						$v=(array)$v;
						$v['time']=date('Y-m-d H:i:s',$v['sub_time']);
						if($v['type']== 'alipay') $v['type']="支付宝扫码";else if($v['type']=='aliwap') $v['type']="支付宝H5";else if($v['type']=='wechat') $v['type']="微信扫码";else $v['type']="银联扫码";
						$v['check'] = false;
						$orderlist[]=$v;
					}
					$json['data']['list']=$orderlist;
				}else{
					$json['data']['list']=0;
				}
				$json['current_page']=$orderarr['current_page'];
				$json['total']=$orderarr['total'];
				$json['status']="ok";

			}else if($arr->input('action') == 'code'){
				$data =$arr->all();
				//判断当前商户是否开启谷歌验证
				$merchant = DB::table('member')->where('id',session()->get('merchant')['Id'])->first();
				if($merchant->safety == 1){
					//验证谷歌验证码是否正确
					$ga = new Google;
					$checkResult = $ga->verifyCode($merchant->safetycode,trim($data['code']),2);
					if($checkResult){
						$json['status'] = "ok";
					}else{
						$json['status'] = "error";
						$json['msg'] = "当前谷歌验证码错误";
					}
				}else{
					$json['status']= "ok";
				}
			}else if($arr->input('action') == 'repair' && $arr->filled('idarr')){
				//查询码商余额及冻结金额
				$merchant = DB::table('member')->where('Id',session()->get('merchant')['Id'])->first();
				$num = 0;
				try {
					if(is_array($arr->input('idarr'))){
						foreach ($arr->input('idarr') as $k => $v) {
							$infoarr[$k] = OrderModel::where('Id',$v)->with('user')->first()->toarray();
							if($merchant->price >= number_format($infoarr[$k]['order_price'] - $infoarr[$k]['order_service'] - $infoarr[$k]['software_service'] + $infoarr[$k]['passageway_service'],3,".","")){
								if($infoarr[$k] && $infoarr[$k]['status'] != 2){
									$status = OrderModel::where('Id',$infoarr[$k]['Id'])->update(array('status'=>2,'com_time'=>time()));
									if($status){
										$num++;
										//发送补发通知
										$postarr['form']['user_id'] = $infoarr[$k]['user_id'];
										$postarr['form']['order_id'] = $infoarr[$k]['order_id'];
										$postarr['form']['apiorder_id'] = $infoarr[$k]['apiorder_id'];
										$postarr['form']['amount'] = $infoarr[$k]['order_money'];
										$postarr['form']['amount_actual'] = $infoarr[$k]['order_price'];
										$postarr['form']['paytype'] = $infoarr[$k]['type'];
										if ($infoarr[$k]['remarks'] != "无") {
											$postarr['form']['remarks'] = $infoarr[$k]['remarks'];
										}
										$postarr['form']['success_time'] =$infoarr[$k]['com_time'];
										$postarr['form']['sign'] = getsign($postarr['form'],$infoarr[$k]['user']['token']);
										$postarr['notify_url'] = $infoarr[$k]['notify_url'];
										$postarr['number_notice'] = 2;
										//添加到Redis回调列表
										$redis_status = Redis::rpush('ordernotice',json_encode($postarr));
										if($redis_status){
											/***先处理商户余额以及添加余额明细****/
											$change_data['type'] = 1;
											$change_data['user_id'] = $infoarr[$k]['user_id'];
											$change_data['amount'] = $infoarr[$k]['order_price'] - $infoarr[$k]['order_service'] - $infoarr[$k]['software_service'];
											$change_data['time'] = time();
											//先获取商户原余额
											$price = DB::table('user')->where('Id', $infoarr[$k]['user_id'])->first()->price;
											$change_data['user_price'] = $price + $change_data['amount'];
											//再给商户加余额
											$status = DB::table('user')->where('Id', $change_data['user_id'])->update(array(
													'price' => $change_data['user_price']
											));
											if (!$status) {
												//记录加余额失败用户
												Log::channel('amount')->info("amount : {$change_data['user_price']} user:{$change_data['user_id']}, error" . "\r\n");
											}
											//添加商户余额明细
											$addstatus = DB::table('user_amount_change')->insert($change_data);
											if (!$addstatus) {
												//记录加余额明细失败用户
												Log::channel('amount')->info("amount_change : " . json_decode($change_data) . ", error" . "\r\n");
											}
											/***再次处理码商余额以及添加余额明细****/
											$change_datas['type'] = 1;
											$change_datas['member_id'] = $infoarr[$k]['member_id'];
											$change_datas['amount'] = number_format($infoarr[$k]['order_price'] - $infoarr[$k]['order_service'] - $infoarr[$k]['software_service'] + $v['passageway_service'],3,".","");
											$change_datas['time'] = $change_data['time'];
											//先获取码商原余额
											$price = DB::table('member')->where('Id', $infoarr[$k]['member_id'])->first()->price;
											$change_datas['member_price'] = $price - $change_datas['amount'];
											//再给码商扣除余额
											$merchantstatus = DB::table('member')->where('Id', $change_datas['member_id'])->update(array(
													'price' => $change_datas['member_price']
											));
											if (!$merchantstatus) {
												//记录扣余额失败码商
												Log::channel('amount')->info("amount : {$change_datas['member_price']} merchant:{$change_datas['member_id']}, error" . "\r\n");
											}
											//添加码商余额明细
											$memberamountadd = DB::table('member_amount_change')->insert($change_datas);
											if (!$memberamountadd) {
												//记录加余额明细失败用户
												Log::channel('amount')->info("amount_change : " . json_decode($change_datas) . ", error" . "\r\n");
											}
										}
									}
								}
							}
						}
						if($num!=0){
							$json['status']="ok";
							$json['msg']="成功补单{$num}个,已自动添加通知任务";
						}else{
							$json['status']="error";
							$json['msg']="操作失败,当前订单已支付成功或可用余额不足,如有疑问请咨询客服";
						}
					}else{
						$json['status']="error";
						$json['msg']="不安全的提交方式";
					}
				}catch (\Exception $e) {
					$json['status']="error";
					$json['msg']=$e->getMessage();
				}
			}else{
				$json['status']="error";
			}
			return $json;
		}
		return view('merchant/order_record');
	}

	/****码商充值记录****/
	public function recharge_record(Request $arr){
		if($arr->isMethod('post')){
			if($arr->has('page')){
				$map['member_id']=session()->get('merchant')['Id'];
				//搜索条件
				if($arr->has('paytype') && !empty($arr->input('paytype')) && $arr->input('paytype')!='-1'){
					$map['type']=$arr->input('paytype');
				}
				if($arr->has('time') && is_array($arr->input('time')) && $arr->input('time')!=','){
					$time=$arr->input('time');
					if(!empty($time[0]) && !empty($time[1])){
						$map[]=['sub_time','>=',strtotime($time[0])];
						$map[]=['sub_time','<',strtotime($time[1])+86400];
					}
				}
				$listarr =DB::table('member_pay')->where($map)->orderBy('id','desc')->paginate(15)->toarray();
				if(intval($listarr['total']) >= 1){
					$listpage=$listarr['data'];
					foreach($listpage as $k => $v){
						$v=(array)$v;
						$v['time']=date('Y-m-d H:i:s',$v['sub_time']);
						if($v['type']== 'alipay') $v['type']="支付宝扫码";else if($v['type']=='aliwap') $v['type']="支付宝H5";else if($v['type']=='wechat') $v['type']="微信扫码";else $v['type']="银联扫码";
						$list[]=$v;
					}
					$json['data']['list']=$list;
				}else{
					$json['data']['list']=0;
				}
				$json['current_page']=$listarr['current_page'];
				$json['total']=$listarr['total'];
				$json['status']="ok";
			}
			return $json;
		}
		return view('merchant/recharge_record');
	}

	/****出单统计****/
	public function statistics(Request $arr){
		if ($arr->isMethod('post')) {
			if ($arr->input('action') == 'text') {
				/****今日订单金额****/
				$map['member_id'] = session()->get('merchant') ['Id'];
				$map['status'] = 2;
				$map[] = ['sub_time', '>', strtotime(date('Y-m-d 00:00:00')) ];
				$map[] = ['sub_time', '<', strtotime(date('Y-m-d 00:00:00')) + 86400];
				$json['data']['order_today_money'] = number_format(DB::table('order')->where($map)->sum('order_money') , 2, ".", "");
				/****今日订单量****/
				$json['data']['order_today_total'] = DB::table('order')->where($map)->count();
				/****昨日订单金额****/
				$map2['member_id'] = session()->get('merchant') ['Id'];
				$map2['status'] = 2;
				$map2[] = ['sub_time', '<', strtotime(date('Y-m-d 00:00:00')) ];
				$map2[] = ['sub_time', '>', strtotime(date('Y-m-d 00:00:00')) - 86400];
				$json['data']['order_yesterday_money'] = number_format(DB::table('order')->where($map2)->sum('order_money') , 2, ".", "");
				/****昨日订单量****/
				$json['data']['order_yesterday_total'] = DB::table('order')->where($map2)->count();
				/****总提交金额****/
				$json['data']['order_total_money'] = DB::table('order')->where('member_id', session()->get('merchant') ['Id'])->sum('order_money');
				/****总提交订单****/
				$json['data']['order_total'] = DB::table('order')->where('member_id', session()->get('merchant') ['Id'])->count();
				$map3['member_id'] = session()->get('merchant') ['Id'];
				$map3['status'] = 2;
				/****总支付订单金额****/
				$json['data']['order_money'] = DB::table('order')->where($map3)->sum('order_money');
				/****总支付金额****/
				$json['data']['success_order_total_money'] = DB::table('order')->where($map3)->sum('order_price');
				/****总支付订单****/
				$json['data']['success_order_total'] = DB::table('order')->where($map3)->count();
				/***首页总出单量***/
				$json['data']['order_total_count'] = $json['data']['success_order_total'];
				/****总扣手续费收益****/
				$json['data']['real_income'] = number_format(DB::table('order')->where($map3)->sum('order_service') + DB::table('order')->where($map3)->sum('software_service') - DB::table('order')->where($map3)->sum('passageway_service'), 3, ".", "");
			} else if ($arr->input('action') == 'charts') {
				$week = !empty($arr->input('time')) ? getweek('', $arr->input('time')) : getweek();
				foreach ($week as $k => $v) {
					$map[$k]['member_id'] = session()->get('merchant') ['Id'];
					$map[$k][] = ['sub_time', '>=', $v['time']];
					$map[$k][] = ['sub_time', '<', $v['time'] + 86400];
					/****遍历查询每日提交订单数****/
					$json['data'][$k]['日期'] = $v['date'];
					$json['data'][$k]['提交订单'] = DB::table('order')->where($map[$k])->count();
					/****遍历查询每日提交订单金额****/
					$json['data'][$k]['提交金额'] = DB::table('order')->where($map[$k])->sum('order_money');
					/****遍历查询每日成功订单数****/
					$map[$k]['status'] = 2;
					$json['data'][$k]['成功收益'] = number_format(DB::table('order')->where($map[$k])->sum('order_service') + DB::table('order')->where($map[$k])->sum('software_service') - DB::table('order')->where($map[$k])->sum('passageway_service'), 3, ".", "");
					$json['data'][$k]['成功订单'] = DB::table('order')->where($map[$k])->count();
					/****遍历查询每日成功订单金额****/
					$json['data'][$k]['成功金额'] = DB::table('order')->where($map[$k])->sum('order_price');
					$json['data'][$k]['扣除余额'] = $json['data'][$k]['成功金额'] - $json['data'][$k]['成功收益'];
				}
			} else if ($arr->input('action') == 'paytype') {
				$map['member_id'] = session()->get('merchant') ['Id'];
				if ($arr->filled('time') && is_array($arr->input('time'))) {
					$time = $arr->input('time');
					if (!empty($time[0]) && !empty($time[1])) {
						$map[] = ['sub_time', '>=', strtotime($time[0]) ];
						$map[] = ['sub_time', '<', strtotime($time[1]) + 86400];
					}
				}
				//查询当前码商支持的通道类型
				$map3['member_id'] = session()->get('merchant') ['Id'];
				if ($arr->filled('code_type') && $arr->input('code_type') != '-1') {
					$map3['passageway_type'] = $arr->input('code_type');
				}
				$payment = MemberpaymentModel::where($map3)->with('livepay','diepay')->get()->toarray();
				foreach ($payment as $k => $v) {
					if (isset($time)) {
						if (!empty($time[0]) && !empty($time[1])) {
							$map2[$k][] = ['sub_time', '>=', strtotime($time[0]) ];
							$map2[$k][] = ['sub_time', '<', strtotime($time[1]) + 86400];
						}
					}
					if($arr->filled('polling_id') && $arr->input('polling_id')!= '-1'){
						$pollingid = Hashids::decode($arr->input('polling_id'))[0];
						if(!empty($pollingid)){
							$map2[$k]['polling_user'] = DB::table('member_polling')->where('Id',$pollingid)->first()->username;
						}
					}
					if ($arr->filled('code_type') && $arr->input('code_type') != '-1') {
						$map2[$k]['code_type'] = $arr->input('code_type');
					}
					if ($arr->filled('type') && $arr->input('type') != '-1') {
						$map2[$k]['type'] = $arr->input('type');
					}
					$map2[$k]['member_id'] = session()->get('merchant') ['Id'];
					$map2[$k]['passageway_id'] = $v['passageway_id'];
					$json['data']['paytypelist'][$k]['passageway_name'] = !empty($v['diepay']) ? $v['diepay']['name'] : $v['livepay']['name'];
					$json['data']['paytypelist'][$k]['passageway_type'] = $v['passageway_type'];
					/****遍历查询当前通道及支付方式提交订单数****/
					$json['data']['paytypelist'][$k]['sub_order'] = DB::table('order')->where($map2[$k])->count();
					/****遍历查询当前通道及支付方式提交金额****/
					$json['data']['paytypelist'][$k]['sub_ordermoney'] = DB::table('order')->where($map2[$k])->sum('order_money');
					/****遍历查询当前通道及支付方式成功订单****/
					$map2[$k]['status'] = 2;
					$json['data']['paytypelist'][$k]['success_order'] = DB::table('order')->where($map2[$k])->count();
					/****遍历查询当前通道及支付方式成功金额****/
					$json['data']['paytypelist'][$k]['orderprice'] = DB::table('order')->where($map2[$k])->sum('order_price');
					/****遍历查询当前通道及支付方式实际扣除****/
					$json['data']['paytypelist'][$k]['exprice'] = number_format($json['data']['paytypelist'][$k]['orderprice'] - DB::table('order')->where($map2[$k])->sum('order_service') - DB::table('order')->where($map2[$k])->sum('software_service') + DB::table('order')->where($map2[$k])->sum('passageway_service'), 3, ".", "");
					/****遍历查询当前通道及支付方式实际盈利****/
					$json['data']['paytypelist'][$k]['income'] = number_format($json['data']['paytypelist'][$k]['orderprice'] -$json['data']['paytypelist'][$k]['exprice'],3,".","");
					$json['data']['charts'][$k]['支付通道'] = $json['data']['paytypelist'][$k]['passageway_name'];
					$json['data']['charts'][$k]['支付金额'] = $json['data']['paytypelist'][$k]['orderprice'];
				}
				$json['data']['textleft'] = array(
						'success_order_total' => DB::table('order')->where(array(
								'member_id' => session()->get('merchant') ['Id'],
								'status' => 2
						))->count() ,
						'order_total' => DB::table('order')->where('member_id',session()->get('merchant') ['Id'])->count()
				);
			} else {
				$json['status'] = "error";
				$json['msg'] = "不安全的提交方式";
			}
			return $json;
		}
		return view('merchant/statistics');
	}

	/****退出登录****/
	public function signout(Request $arr){
		session()->pull('merchant');
		//跳转到登录页
		return redirect('/login');
	}

	/***修改密码****/
	public function change_password(Request $arr){
		if($arr->isMethod('post')){
			if($arr->filled('form')){
				if(is_array($arr->input('form'))){
					$data = $arr->input('form');
					if(checkpass($data['password'])){
						if(!empty($data['repass'])){
							if(checkpass($data['repass'])){
								$merchant = DB::table('member')->where('Id',session()->get('merchant') ['Id'])->first();
								if($merchant->safety == 1){
									if(empty($data['code'])){
										$json['status']="error";
										$json['msg'] = "请输入谷歌验证码";
									}else{
										//验证谷歌验证码是否正确
										$ga = new Google;
										$checkResult = $ga->verifyCode($merchant->safetycode,trim($data['code']),2);
										if(!$checkResult){
											$json['status'] = "error";
											$json['msg'] = "当前谷歌验证码错误";
										}
									}
								}
								if(!isset($json)){
									if(ypass($data['password'],$merchant->password)){
										$updata['password'] = xpass(trim($data['password']));
										$status = DB::table('member')->where('Id',session()->get('merchant') ['Id'])->update($updata);
										if($status){
											$json['status'] = "ok";
											$json['msg'] = "修改密码成功";
										}else{
											$json['status'] = "error";
											$json['msg']  = "密码修改错误";
										}
									}else{
										$json['status'] = "error";
										$json['msg'] = "原密码不一致";
									}
								}
							}else{
								$json['status'] = "error";
								$json['msg']  = "新密码不符合规则";
							}
						}else{
							$json['status'] = "error";
							$json['msg'] = "请输入新密码";
						}
					}else{
						$json['status'] = "error";
						$json['msg'] = "原密码不符合规则";
					}
				}else{
					$json['status'] = "error";
					$json['msg'] = "不安全的提交方式";
				}
			}
			return $json;
		}
		return view('merchant/change_password');
	}

}