<?php
/* +----------------------------------------------------------------------+
   | Copyright (c) 2018-2019 YmPay                                        |
   |              <530759076@qq.com>                                      |
   +----------------------------------------------------------------------+*/

namespace App\Socket;
use GatewayWorker\Lib\Gateway;
use Workerman\Lib\Timer;
use Illuminate\Support\Facades\Redis;
use App\Http\Models\OrderModel;
use App\Http\Models\MemberPayModel;
use App\Http\Models\UserPayModel;
use App\Http\Models\DiepollingpaymentModel;
use App\Http\Models\LivepollingpaymentModel;
use App\Http\Models\PollingModel;
use App\Http\Controllers\Server\Server;
class Events {
    /**
     * 当客户端连接时触发
     * 如果业务不需此回调可以删除onConnect
     *
     * @param int $uid 连接id
     */
    public static function onConnect($uid) { //如有用户连接时发送到唯一uid标识 token
        $relust['type'] = "login";
        $relust['token'] = $uid;
        Gateway::sendToClient($uid, json_encode($relust));
    }
    //当有客户端发送消息时
    public static function onMessage($uid, $messg) {
        $data = json_decode($messg, true);
        if (isset($data['type'])) {
            switch ($data['type']) {
                case 'websocket':
                    $relust['status'] = 100;
                    $relust['type'] = $data['type'];
                    break;
                case 'api':
                			switch($data['code']){
                				case 10001:/******码商登录*****/
                					break;
                				case 10002:/******码商获取收款账号*****/
                					break;
                				case 10003:/******码商收款账号点击登录*****/
                					break;
                				case 10004:/******单收款账号登录*****/
                					break;
                				case 10005:/******查询余额明细*****/
                					break;
                				case 10006:/******固码二维码接收*****/
                					break;
                				case 10007:/******网关操作*****/
                					break;
                				case 10008:/******刷新当前余额*****/
                					break;
                				case 10009:/******退出登录*****/
                					break;
                				case 10010:/******固码监听回调*****/
                					break;
                				case 10011:/******活码成功回调*****/
                					break;
                			}
                default:
                    $relust['status'] = 101;
            }
        } else {
            $relust['status'] = 101;
        }
        Gateway::sendToClient($uid, json_encode($relust));
    }
    //守护进程时启动常驻内存
    public static function onWorkerStart($businessWorker) {
        if ($businessWorker->id === 0) {
            // 订单过期1
            Timer::add(100, function () {
                self::OrderOut();
            });
            //处理余额不足码池
            Timer::add(60,function(){
            	self::CheckCode();
            });
        } else if($businessWorker->id === 1){
        	// Redis金额池过期3
            Timer::add(20, function () {
                self::amountPool();
            });
            //回调订单5
            Timer::add(25, function () {
                self::OrderNotice();
            });
        } else if($businessWorker->id === 2){
        	 //通知订单6
            Timer::add(1, function () {
                self::OrderSocket();
            });
            //操作日志7
            Timer::add(60, function () {
                self::Operation();
            });
        } else if($businessWorker->id === 3){
        	//失败记录处理
            Timer::add(60, function () {
                self::OrderAmountError();
            });
            //连续失败码处理
            Timer::add(30, function () {
                self::QrcodeLose();
            });
            //连续失败码添加记录
            Timer::add(60, function () {
                self::QrcodeAddmysql();
            });
        }
    }
    /*** 当用户断开连接时触发*$uid连接id*/
    public static function onClose($uid) {
        //先查询当前账号是否存在
        $polinfo = PollingModel::where(array(
            'status' => 1,
            'token' => $uid
        ))->first();
        if ($polinfo) {
            //更新账号状态
            $status = PollingModel::where('Id', $polinfo->Id)->update(array(
                'status' => 2,
                'token' => null
            ));
            if($status){
               (new Server())->CheckPollingClose($polinfo->Id,$polinfo->type);
            }
        }
    }
    /****处理订单过期****/
    public static function OrderOut() {
        //查询是否存在过期订单
        $map[] = ['com_time', '<=', time() ];
        $map[] = ['status', '!=', 2];
        //平台订单
        $orderinfo = OrderModel::where($map)->first();
        //码商充值订单
        $merPay = MemberPayModel::where($map)->first();
        //商户升级订单
        $userPay = UserPayModel::where($map)->first();
        if ($orderinfo) {
            //更新所有过期订单
            OrderModel::where($map)->update(array(
                'status' => 3,
                'notice' => 3
            ));
        }
        if ($merPay) {
            //更新所有过期订单期
            MemberPayModel::where($map)->update(array(
                'status' => 3,
                'result' => 3
            ));
        }
        if ($userPay) {
            //更新所有过期订单期
            UserPayModel::where($map)->update(array(
                'status' => 3,
                'result' => 3
            ));
        }
    }
    /*****检测码商异常掉线*****/
    public static function checkClose() {
        (new Server())->CheckClose();
    }
    /****检测码商余额清除码池**/
    public static function CheckCode(){
    	(new Server())->CheckCode();
    }
    /****Redis更新过期****/
    public static function amountPool() {
        (new Server())->AmountPool();
    }
    /****处理订单回调****/
    public static function OrderNotice() {
        (new Server())->OrderNotice();
    }
    /****订单消息通知****/
    public static function OrderSocket() {
        (new Server())->Socket();
    }
    /****添加操作日志****/
    public static function Operation(){
        (new Server())->Operation();
    }
    /***失败记录处理****/
    public static function OrderAmountError(){
    	(new Server())->Order_amount_error();
    }
    /****连续失败码处理****/
    public static function QrcodeLose(){
    	(new Server())->Qrcode_lose();
    }
    /***失败码添加数据库****/
    public static function QrcodeAddmysql(){
    	(new Server())->Qrcode_addmysql();
    }
}

