<!DOCTYPE html>
<html class="">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1">
    <meta name="viewport" content="width=device-width,minimum-scale=1.0,maximum-scale=1.0,user-scalable=no">
    <meta name="renderer" content="webkit">
    <title>立即支付</title>

    <link rel="stylesheet" media="screen" href="/pay_template_2/css/pay.css"/>
    <link rel="stylesheet" media="screen" href="/pay_template_2/css/font-awesome.min.css"/>
 	 <script src="/pay_template_2/js/board.js"></script>
</head>
<body>
<div class="container">
    <div class="header">
        <div class="logo <?php echo $info['type'];?>"></div>
    </div>
    <div class="mainbody">
        <div class="realprice">￥<span style="color:red;font-size:50px;"><?php echo $info['order_price'];?></span></div>
        		<?php if(ismobile() && $info['type']!='aliwap'){ echo '<div style="color:red;font-size:18px;">请截屏保存到相册扫码</div>';}?>
        		<?php if(ismobile() && $info['type']=='aliwap'){ echo '<div style="color:red;font-size:18px;">请截屏保存到相册扫码,或点击启动支付宝进行支付</div>';}?>
                <div style="color:red;font-size:18px;">扫码后请输入以下金额，输错或者少输导致不到账概不负责</div>
        <div class="qrcode">
          	<img style="padding:0px" class="image" <?php if(isset($info['qrcode_url'])){ if($info['qrcode_url']!=2 ){echo 'src="http://qr.topscan.com/api.php?text='.$info['qrcode_url'].'"';}else{echo 'src="/pay_template_2/images/loading.gif"';} }else{ echo 'src="/pay_template_2/images/loading.gif"';} ?> alt="">
            <div class="logo hidden-xs logo-<?php echo $info['type'];?>"></div>
            <div class="expired hidden"></div>
            <div class="paid hidden"></div>
        </div>
        <div class="remainseconds">
            <div class="time minutes">
                <b id="f">00</b>
                <em>分</em>
            </div>
            <div class="colon">:</div>
            <div class="time seconds">
                <b id="m">00</b>
                <em>秒</em>
            </div>
        </div>
        <div id="tiao">
        </div>
	        <div class="help">
	            <?php if(isset($info['qrcode_url']) && $info['qrcode_url']!=2){echo "支付即时到账，未到账请与我们联系<br>订单号:".$info['apiorder_id'];}else{echo '二维码生成中...请稍等。';}?>
	        </div>

        <div class="tips">
        	<?php if($info['type'] == 'alipay'){echo "打开支付宝「扫一扫」";}else if($info['type']=='aliwap'){ echo "点击上方启动支付宝「支付」"; }else if($info['type'] == 'wechat'){echo "打开微信「扫一扫」";}else if($info['type'] == 'unionpay'){echo "打开手机银行类APP「扫一扫」";}?>
        </div>
    </div>
    <script type="text/javascript" src="/pay_template_2/js/jquery.min.js"></script>
    <script>
$(function () {
  var clipboard = new Clipboard('#bt',{  
       text: function(trigger) { 
			alert("复制成功！请打开支付宝发给任意一个好友打开链接付款");
		   return trigger.getAttribute('data-text');  
       }
   });
  	var query = window.location.search.substring(1);
	var vars = query.split("&");
	for (var i=0;i<vars.length;i++) {
        var pair = vars[i].split("=");
        if(pair[0] == "key"){
          var key = pair[1];
        }
	}
    
    getorder();

    //开始查询订单
    function getorder(){
    	$.post("/do",{action:'getorder',key:key},function(res){
            if(res.state == 1){
                if(res.data.status != 2){
                	    inttime = res.data.inttime;
                		timeint();
                	    order = res.data;
                	if(res.data.qrcode_url == 2){
                 	    ajaxqrcode();
                 	}
                 	checkOrderStatus();
                }else{
		            window.location.href = res.data.return_url;
		        }
            }else{
                alert(res.msg);
            }
        })
    }

    //定时执行订单时间
    function timeint(){
    	var minutes, seconds, ci, qi;
	    ci = setInterval(function () {
	        minutes = parseInt(inttime / 60, 10)
	        seconds = parseInt(inttime % 60, 10);

	        minutes = minutes < 10 ? "0" + minutes : minutes;
	        seconds = seconds < 10 ? "0" + seconds : seconds;

	        $(".minutes b").text(minutes);
	        $(".seconds b").text(seconds);
	        if (--inttime <=  0) {
	            $(".qrcode .expired").removeClass("hidden");
	            $(".minutes b").text('00');
	            $(".seconds b").text('00');
	            $("#tiao").html('');
	            $(".help").html('订单过期,请重新提交订单');
	            clearInterval(ci);
	            clearInterval(t1);
	            clearInterval(t2);
	        }	
	    }, 1000);
    }
    //定时查询订单状态
    function checkOrderStatus() {
        $.post("/do",{action:'exorder',order_id:order.apiorder_id},function(res){
            if(res.state == 1){
            	if(res.data.status == 2){
             		clearTimeout(t1);
             		window.location.href = res.data.return_url;
             	}else{
             		t1 = setInterval(checkOrderStatus(),2000);
             	}
            }else{
            	//订单到期
                inttime = 1;
             	clearInterval(t1);
            }
        });
    };
  	
  	//查询二维码
  	function ajaxqrcode(){
  		$.post("/do",{action:'qrcode',order_id:order.apiorder_id},function(res){
            	if(res.state == 1){
             		order.qrcode_url = res.data.qrcode_url;
             		$(".image").attr("src",res.data.qrcode_url);
             		if(order.type =='aliwap'){
             			$(".tips").html('<a href="alipays://platformapi/startapp?appId=20000067&url='+encodeURIComponent(res.data.h5_url)+'" class="btn btn-info btn-lg" id="moneyss" data-money="'+order.order_price+'">启动支付宝进行支付</a>');
             		}
             		$(".help").html('支付即时到账，未到账请与我们联系<br>订单号:'+order.apiorder_id);

             	}else{
             		t2 = setInterval(ajaxqrcode(),1000);
             	}
        });
  	}
});
    </script>
</div>
</body>
</html>
