<?php

use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

/****添加支付订单****/
Route::match(['get','post'],'pay','Api\ApiController@pay');
/****API查询订单****/
Route::match(['get','post'],'query','Api\ApiController@query');
/****PC支付页面****/
Route::match(['get','post'],'do','Pay\PayController@index');
/****支付宝支付跳转检测****/
Route::match(['get','post'],'alido','Pay\PayController@alido');
/****二维码生成****/
Route::match(['get'],'qrcode','Pay\PayController@qrcode');
/****商户自测收银台****/
Route::match(['get','post'],'cashier','Pay\PayController@cashier');
/****商户接收升级通知****/
Route::match(['get','post'],'member_notice','Api\ApiController@member_notice');
/****码商接收充值通知****/
Route::match(['get','post'],'merchant_notice','Api\ApiController@merchant_notice');
/****测试接收通知****/
Route::match(['get','post'],'demo_notice','Api\ApiController@demo_notice');

/****测试****/
Route::match(['get','post'],'ceshi','Api\ApiController@ceshi');

Route::group(['middleware'=>'Httplog','prefix'=>'app'],function($e){
	/***APP登录****/
  	Route::match(['get','post'],'login','Api\AppController@login');
  	/***APP码商登录后获取收款账号****/
  	Route::match(['get','post'],'pollinglist','Api\AppController@pollinglist');
  	/***APP码商余额明细****/
  	Route::match(['get','post'],'merchant_amount_change','Api\AppController@merchant_amount_change');
  	/***APP码商获取余额****/
  	Route::match(['get','post'],'amount_loading','Api\AppController@amount_loading');
  	/***APP固码接收通知****/
  	Route::match(['get','post'],'dienotice','Api\AppController@dienotice');
  	/***APP活码接收二维码****/
  	Route::match(['get','post'],'qrcode','Api\AppController@qrcode');
  	/***APP活码接收成功支付回调****/
  	Route::match(['get','post'],'success','Api\AppController@success');
  	/***APP固码通道开关****/
  	Route::match(['get','post'],'channel','Api\AppController@channel');
  	/***APP固码上传二维码****/
  	Route::match(['get','post'],'dieqrcode','Api\AppController@dieqrcode');
  	/****APP退出登录****/
  	Route::match(['get','post'],'loseapp','Api\AppController@loseapp');
});