'''
@Author: hua
@Date: 2019-04-17 14:23:19
@LastEditors: hua
@LastEditTime: 2019-05-14 09:48:15
'''
from app.Model.Admin import Admin
from app.Vendor.Code import Code
from app.Vendor.tempDef import backStatus
import hashlib, time

class AdminService():
    """  
        登录
        @param string data['name'] 用户名
        @param string data['pwd'] 密码
        @return array
    """
    def login(self, data):
        name = data['name']
        #生成一个md5对象
        m1 = hashlib.md5()
        #使用md5对象里的update方法md5转换
        m1.update(data['pwd'].encode("utf-8"))
        pwd = m1.hexdigest()
        
        #用户名/邮箱/手机登录
        filters = {
            Admin.name == name,
            Admin.pwd  == pwd,
            Admin.delete_time == 0
        }
        admin = Admin().getOne(filters, Admin.add_time.desc())
        if admin == None:
            filters = {
                Admin.email == name,
                Admin.pwd  == pwd,
                Admin.delete_time == 0
            }
            admin = Admin().getOne(filters, Admin.add_time.desc())
            if admin == None:
                filters = {
                    Admin.mobile == name,
                    Admin.pwd  == pwd,
                    Admin.delete_time == 0
                }
                admin = Admin().getOne(filters, Admin.add_time.desc())


        if admin != None:
            #admin = $admin->append(['role_name','status_text'])->toArray();
			#更新登录时间
            filters = {
                Admin.id== admin['id']
            }
            Admin().edit({Admin.login_time: time.time()}, filters)
            
            return {'code': Code.SUCCESS, 'data': admin }
        
        return {'code': Code.ERROR }
    
    #添加
    def add(self, request, data = [], type=0):
        if 'update_time' in data.keys():
            data['update_time'] = time.time()
         #判断用户名
        if 'name' in data.keys():
            filters = {
                Admin.delete_time == 0,
                Admin.name        == data['name']
            }
            adminData = Admin().getOne(filters, Admin.add_time.desc())
            if adminData != None:
                return backStatus(request, '用户名已经存在', 0)
        #判断手机号码
        if 'mobile' in data.keys():
            filters = {
                Admin.delete_time == 0,
                Admin.mobile      == data['mobile']
            }
            admin = Admin().getOne(filters, Admin.add_time.desc())
            if admin:
                return backStatus(request, '手机号码已经存在', 0) 
        #判断邮箱
        if 'email' in data.keys():
            filters = {
                Admin.delete_time == 0,
                Admin.email      == data['email']
            }
            admin = Admin().getOne(filters, Admin.add_time.desc())
            if admin:
                return backStatus(request, '邮箱已经存在', 0)
         #生成一个md5对象
        m1 = hashlib.md5()
        #使用md5对象里的update方法md5转换
        m1.update(data['pwd'].encode("utf-8"))
        data['pwd'] = m1.hexdigest()    
        res = Admin().add(data)
        if res==True:
            return backStatus(request, '添加成功')
        return backStatus(request, '添加失败', 0)

    #修改
    def edit(self, request, data, filters = {}):
    
        if 'update_time' in data.keys():
            data['update_time'] = time.time()
        adminData = Admin().getOne(filters, Admin.add_time.desc())
        if adminData == None:
            return backStatus(request, '用户不存在', 0)
        #判断用户名
        if 'name' in data.keys():
            filters = {
                Admin.delete_time == 0,
                Admin.name        == data['name'],
                Admin.id          != adminData['id']
            }
            admin = Admin().getOne(filters, Admin.add_time.desc())
            if admin != None:
                return backStatus(request, '用户名已经存在', 0)


        
        #判断手机号码
        if 'mobile' in data.keys():
            filters = {
                Admin.delete_time == 0,
                Admin.mobile      == data['mobile'],
                Admin.id          != adminData['id']
            }
            admin = Admin().getOne(filters, Admin.add_time.desc())
            if admin != None:
                return backStatus(request, '手机号码已经存在', 0)
        
        #判断邮箱
        if 'email' in data.keys():
            filters = {
                Admin.delete_time == 0,
                Admin.email       == data['email'],
                Admin.id          != adminData['id']
            }
            admin = Admin().getOne(filters, Admin.add_time.desc())
            if admin != None:
                return backStatus(request, '邮箱已经存在', 0)
        
        if 'pwd' in data.keys():
            #生成一个md5对象
            m1 = hashlib.md5()
            #使用md5对象里的update方法md5转换
            m1.update(data['pwd'].encode("utf-8"))
            data['pwd'] = m1.hexdigest()      
        res = Admin().edit(data, filters)
        if res==True:
            return backStatus(request, '编辑成功')
        return backStatus(request, '编辑失败', 0)