from aiohttp import web
from aiohttp_session import get_session
from app import dBSession
from app.Model.Article import Article
from app.Model.ArticleType import ArticleType
from app.Model.Taglist import Taglist
from app.Model.Tag import Tag
from app.Service.ArticleService import ArticleService
from app.Vendor.Decorator import validator
from app.Vendor.tempDef import sysconfig, backStatus
from  sqlalchemy.sql.expression import func
from app.Vendor.Code import Code
import aiohttp_jinja2
import time, jieba, json


#列表
@aiohttp_jinja2.template('fladmin/article_type/index.html')
async def index(request, **k):
    data = dict()
    #分类列表
    article_type_list = ArticleType().tree_to_list(ArticleType().list_to_tree(), parent_id=0, temp=[])
    data['list'] = article_type_list
    return data

#添加
@aiohttp_jinja2.template('fladmin/article_type/add.html')
async def addByPost(request, **k):
    params = dict()
    if  request.content_type == 'application/json':
        reqMultiDictValue = json.loads(str(await request.content.read(), encoding="utf-8"))
    elif request.content_type == 'application/x-www-form-urlencoded' or request.content_type == 'multipart/form-data':
        reqMultiDictValue = await  request.post()
    for k,v in reqMultiDictValue.items():
        params[k] = v
    
    params['update_time'] = time.time()
    params['add_time'] = params['update_time']
    res = ArticleType().add(params)
    if res==True:
        return backStatus(request, '添加成功')
    return backStatus(request, '添加失败', 0)
        
    
#添加
@aiohttp_jinja2.template('fladmin/article_type/add.html')
async def addByGet(request, **k):
    params = request.query
    data = dict()
    if 'parent_id' not in params.keys():
        parent_id = 0
    else:
        parent_id = params['parent_id']
    if parent_id != 0:
        filters = {
            ArticleType.parent_id == parent_id
        }
        data['parent_article_type'] = ArticleType().getOne(filters, ArticleType.add_time.desc())
    data['parent_id'] = parent_id
    
    return data

#修改
@aiohttp_jinja2.template('fladmin/article_type/edit.html')
async def editByPost(request, **k):
    params = dict()
    if  request.content_type == 'application/json':
        reqMultiDictValue = json.loads(str(await request.content.read(), encoding="utf-8"))
    elif request.content_type == 'application/x-www-form-urlencoded' or request.content_type == 'multipart/form-data':
        reqMultiDictValue = await  request.post()
    for k,v in reqMultiDictValue.items():
        params[k] = v
    filters = {
        ArticleType.id == params['id']
    }  
    params['update_time'] =time.time() #更新时间
    
    res = ArticleType().edit(params, filters)
    if res==True:
        return backStatus(request, '编辑成功')
    return backStatus(request, '编辑失败', 0)
    
#修改
@aiohttp_jinja2.template('fladmin/article_type/edit.html')
async def editByGet(request, **k):
    params = request.query
    data = dict()
    filters = {
        ArticleType.id == params['id']
    }
    data['id'] = params['id'] 
    data['post'] =  ArticleType().getOne(filters, ArticleType.add_time.desc())
    return data

#删除
async def delete(request, **k):
    params = request.query
    filters = {
        ArticleType.parent_id == params['id']
    }

    
    if ArticleType().getOne(filters, ArticleType.id.desc()):
        return backStatus(request, '删除失败！请先删除子栏目', 0)
    filters = {
        ArticleType.id == params['id']
    }
    res = ArticleType().delete(filters)
    if res==True:
        filters = {
            Article.type_id== params['id']
        }
        if Article().getCount(filters)>0: #判断该分类下是否有文章，如果有把该分类下的文章也一起删除
            if Article().delete(filters):
                return backStatus(request, '删除成功')
        
            return backStatus(request, '栏目下的文章删除失败', 0)

        return backStatus(request, '删除成功')
    
    return backStatus(request, '删除失败', 0)

