from aiohttp import web
from app.Vendor.Decorator import validator
from app.Model.Menu import Menu
import aiohttp_jinja2
from aiohttp_session import get_session
from app import cache
from app.Vendor.tempDef import backStatus
import os

@aiohttp_jinja2.template('fladmin/index/index.html')
async def index(request, **k):
    data = dict()
    session = await get_session(request)
    if 'admin_info' in session.keys():
        admin_info = session['admin_info']
        data['menus'] = Menu().getPermissionsMenu(admin_info['role_id'])
        #获取当前模块名
        pathList = os.path.abspath(os.path.join(os.path.dirname(__file__),"..")).split('\\')
        data['module_name'] = pathList[len(pathList)-1]
        data['admin_info'] = admin_info
    else:
        return web.HTTPFound(str(request.app.router['adminLogin'].url_for()))
    return data

@aiohttp_jinja2.template('fladmin/index/welcome.html')
async def welcome(request, **k):
    server_name = request.scheme+'://'+ request.host
    remote_addr = request.remote
    return {'server_name': server_name, 'remote_addr': remote_addr}

async def upcache(request, **k):
    cache.clear()
    return backStatus(request, '清除成功')


@aiohttp_jinja2.template('fladmin/public/status.html')
@validator(name="msg", rules={'required': True,'type': 'string'})
@validator(name="url", rules={'required': True,'type': 'string'})
@validator(name="data", rules={'type': 'string'}, default='0')
@validator(name="wait", rules={'type': 'string'}, default='60')
@validator(name="code", rules={'type': 'string'}, default='1')
async def status(request, **k):
    params = k['params'] 
    return {
        'msg': params['msg'], 
        'url': params['url'], 
        'data': params['data'], 
        'wait': params['wait'], 
        'code': int(params['code'])
    }
