'''
@Author: hua
@Date: 2019-05-04 17:24:25
@LastEditors: hua
@LastEditTime: 2019-05-14 09:40:16
'''
from aiohttp import web
from app.Model.Menu import Menu
from app.Model.Access import Access
from app.Vendor.Decorator import validator
from app.Vendor.tempDef import sysconfig, backStatus, randomInt
from  sqlalchemy.sql.expression import func
from app.Vendor.Code import Code
import aiohttp_jinja2
import time, jieba, json


#列表
@aiohttp_jinja2.template('fladmin/menu/index.html')
async def index(request, **k):
    params = request.query
    data = dict()
    if 'page' in params.keys():
        page = int(params['page'])
    else:
        page = 0
    if 'keyword' in params.keys():
       filters = {Menu.name.like('%'+params['keyword']+'%')}
       res = Menu().getList(filters, Menu.id.desc(), (), page)
    else:
       res = Menu().getList({}, Menu.id.desc(), (), page)
    data['page'] = res['page']
    data['list'] = res['list']
    return data 

#添加
@aiohttp_jinja2.template('fladmin/menu/add.html')
async def addByPost(request, **k):
    params = dict()
    if  request.content_type == 'application/json':
        reqMultiDictValue = json.loads(str(await request.content.read(), encoding="utf-8"))
    elif request.content_type == 'application/x-www-form-urlencoded' or request.content_type == 'multipart/form-data':
        reqMultiDictValue = await  request.post()
    for k,v in reqMultiDictValue.items():
        params[k] = v
    res = Menu().add(params)   
    if res:
        #添加超级管理员权限
        Access().add({'role_id': 1, 'menu_id':res})
        return backStatus(request, '添加成功')
    return backStatus(request, '添加失败', 0)
          
#添加
@aiohttp_jinja2.template('fladmin/menu/add.html')
async def addByGet(request, **k):
    params = request.query
    data = dict()
    if 'parent_id' not in params.keys():
        parent_id = 0
    else:
        parent_id = params['parent_id']
    menu = Menu().category_tree(Menu().get_category())
       
    data['menu'] = menu
    data['parent_id'] = parent_id
    return data
    
#修改
@aiohttp_jinja2.template('fladmin/menu/edit.html')
async def editByPost(request, **k):
    params = dict()
    if  request.content_type == 'application/json':
        reqMultiDictValue = json.loads(str(await request.content.read(), encoding="utf-8"))
    elif request.content_type == 'application/x-www-form-urlencoded' or request.content_type == 'multipart/form-data':
        reqMultiDictValue = await  request.post()
    for k,v in reqMultiDictValue.items():
        params[k] = v
    filters = {
        Menu.id == params['id']
    }  
    res = Menu().edit(params, filters)
    if res==True:
        return backStatus(request, '编辑成功')
    return backStatus(request, '编辑失败', 0)
        
#修改
@aiohttp_jinja2.template('fladmin/menu/edit.html')
async def editByGet(request, **k):
    params = request.query
    data = dict()
    filters = {
        Menu.id == params['id']
    }
    data['id'] = params['id'] 
    menu = Menu().category_tree(Menu().get_category())    
    data['menu'] = menu
    data['post'] =  Menu().getOne(filters, Menu.id.desc())
    return data

#删除
async def delete(request, **k):
    params = request.query
    filters = {
        Menu.id == params['id']
    }
    res = Menu().delete(filters)
    if res==True:
        #删除权限
        filters = {
            Access.id == params['id']
        }
        Access().delete(filters)
        return backStatus(request, '删除成功') 
    return backStatus(request, '删除失败', 0)
