from aiohttp import web
from app import dBSession
from app.Model.Page import Page
from app.Model.ArticleType import ArticleType
from app.Model.Taglist import Taglist
from app.Model.Tag import Tag
from app.Service.ArticleService import ArticleService
from app.Vendor.Decorator import validator
from app.Vendor.tempDef import sysconfig, backStatus, randomInt
from  sqlalchemy.sql.expression import func
from app.Vendor.Code import Code
import aiohttp_jinja2
import time, json


#列表
@aiohttp_jinja2.template('fladmin/page/index.html')
async def index(request, **k):
    params = request.query
    data = dict()
    if 'keyword' in params.keys():
       filters = {Page.title.like('%'+params['keyword']+'%')}
       res = Page().getList(filters, Page.id.desc(), ())
    else:
       res = Page().getList({}, Page.id.desc(), ())
    data['page'] = res['page']
    data['list'] = res['list']
    return data 

#添加
@aiohttp_jinja2.template('fladmin/page/add.html')
async def addByPost(request, **k):
    params = dict()
    if  request.content_type == 'application/json':
        reqMultiDictValue = json.loads(str(await request.content.read(), encoding="utf-8"))
    elif request.content_type == 'application/x-www-form-urlencoded' or request.content_type == 'multipart/form-data':
        reqMultiDictValue = await  request.post()
    for k,v in reqMultiDictValue.items():
        params[k] = v
    
    params['update_time'] = time.time()
    params['add_time'] = params['update_time'] 
    params['click'] = randomInt(500)#点击
    res = Page().add(params)   
    if res==True:
        return backStatus(request, '添加成功')
    return backStatus(request, '添加失败', 0)
        
        
      

#添加
@aiohttp_jinja2.template('fladmin/page/add.html')
async def addByGet(request, **k):
    return {}
    
#修改
@aiohttp_jinja2.template('fladmin/page/edit.html')
async def editByPost(request, **k):
    params = dict()
    if  request.content_type == 'application/json':
        reqMultiDictValue = json.loads(str(await request.content.read(), encoding="utf-8"))
    elif request.content_type == 'application/x-www-form-urlencoded' or request.content_type == 'multipart/form-data':
        reqMultiDictValue = await  request.post()
    for k,v in reqMultiDictValue.items():
        params[k] = v
    filters = {
        Page.id == params['id']
    }  
    params['update_time'] =time.time() #更新时间
    
    res = Page().edit(params, filters)
    if res==True:
        return backStatus(request, '编辑成功')
    return backStatus(request, '编辑失败', 0)
        
#修改
@aiohttp_jinja2.template('fladmin/page/edit.html')
async def editByGet(request, **k):
    params = request.query
    data = dict()
    filters = {
        Page.id == params['id']
    }
    data['id'] = params['id'] 
    data['post'] =  Page().getOne(filters, Page.add_time.desc())
    return data

#删除
async def delete(request, **k):
    params = request.query
    filters = {
        Page.id == params['id']
    }
    res = Page().delete(filters)
    if res==True:
        return backStatus(request, '删除成功') 
    return backStatus(request, '删除失败', 0)
