'''
@Author: hua
@Date: 2019-05-05 20:03:47
@LastEditors: hua
@LastEditTime: 2019-05-20 15:06:56
'''
from aiohttp import web
from app.Model.Searchword import Searchword
from app.Vendor.Decorator import validator
from app.Vendor.tempDef import sysconfig, backStatus, randomInt
from  sqlalchemy.sql.expression import func
from app.Vendor.Code import Code
import aiohttp_jinja2
import time, jieba, json,re

#列表
@aiohttp_jinja2.template('fladmin/searchword/index.html')
async def index(request, **k):
    params = request.query
    data = dict()
    if 'keyword' in params.keys():
       filters = {Searchword.name.like('%'+params['keyword']+'%')}
       res = Searchword().getList(filters, Searchword.id.desc(), ())
    else:
       res = Searchword().getList({}, Searchword.id.desc(), ())
    data['page'] = res['page']
    data['list'] = res['list']
    return data 
	
#添加
@aiohttp_jinja2.template('fladmin/searchword/add.html')
async def addByPost(request, **k):
    params = dict()
    if  request.content_type == 'application/json':
        reqMultiDictValue = json.loads(str(await request.content.read(), encoding="utf-8"))
    elif request.content_type == 'application/x-www-form-urlencoded' or request.content_type == 'multipart/form-data':
        reqMultiDictValue = await  request.post()
    for k,v in reqMultiDictValue.items():
        params[k] = v
    params['update_time'] = time.time()
    res = Searchword().add(params)   
    if res==True:
        return backStatus(request, '添加成功')
    return backStatus(request, '添加失败', 0)
     
         
#添加
@aiohttp_jinja2.template('fladmin/searchword/add.html')
async def addByGet(request, **k):
    return {}
    
#修改
@aiohttp_jinja2.template('fladmin/searchword/edit.html')
async def editByPost(request, **k):
    params = dict()
    if  request.content_type == 'application/json':
        reqMultiDictValue = json.loads(str(await request.content.read(), encoding="utf-8"))
    elif request.content_type == 'application/x-www-form-urlencoded' or request.content_type == 'multipart/form-data':
        reqMultiDictValue = await  request.post()
    for k,v in reqMultiDictValue.items():
        params[k] = v
    filters = {
        Searchword.id == params['id']
    }
    params.pop('editorValue')
    params['update_time'] = time.time()
    res = Searchword().edit(params, filters)
    if res == True:
        return backStatus(request, '编辑成功')
    return backStatus(request, '编辑失败', 0)
    
    

@aiohttp_jinja2.template('fladmin/searchword/edit.html')
async def editByGet(request, **k):
    params = request.query
    data = dict()
    filters = {
        Searchword.id == params['id']
    }
    data['id'] = params['id']
   
    data['post'] = Searchword().getOne(filters, Searchword.id.desc())
    return data

	
#删除
async def delete(request, **k):
    params = request.query
    filters = {
        Searchword.id == params['id']
    }
    res = Searchword().delete(filters)
    if res==True:
        return backStatus(request, '删除成功') 
    return backStatus(request, '删除失败', 0)
