from app.Model.Article import Article
from app.Vendor.Decorator import validator
import aiohttp_jinja2
import time

#详情
@aiohttp_jinja2.template('index/search/detail.html')
@validator(name="keyword", rules={'required': True,'type': 'string'}, msg= {'required': u'关键字是必须的','type': u'关键字是字符串'})
async def detail(request, **k):
    keyword = k['params']['keyword']
    data = dict()
    filters = {
        Article.title.like('%'+keyword+'%'),
        Article.delete_time == 0,
        Article.status == 0,
        Article.add_time < time.time()
    }
    dataList = Article().getList(filters, Article.update_time.desc(), ())
    data['page'] = dataList['page']
    data['list'] = dataList['list']
    
    #最新
    filters = {
        Article.delete_time == 0,
        Article.status == 0,
        Article.add_time < time.time()
    }
    relate_zuixin_list = Article().getList(filters, Article.id.desc(), (), 0, 5)
    data['relate_zuixin_list'] = relate_zuixin_list['list']
    
    #推荐
    filters = {
        Article.delete_time == 0,
        Article.status == 0,
        Article.tuijian == 1,
        Article.add_time < time.time()
    }
  
    relate_tuijian_list = Article().getList(filters, Article.id.desc(), (), 0, 5)
    data['relate_tuijian_list'] = relate_tuijian_list['list']
    #搜索词
    data['keyword'] = keyword
    return data
