'''
@Author: hua
@Date: 2019-04-12 09:39:33
@LastEditors: hua
@LastEditTime: 2020-06-07 19:52:42
'''
from aiohttp import web
from functools import wraps
from app.index.Controller import Index, Article, Page, Search, Tag, GuestBook
from app.fladmin.Controller import (Login, 
Index as fladminIndex, Article as fladminArticle, 
ArticleType as fladminArticleType,Page as fladminPage,
Menu as fladminMenu, Admin as fladminAdmin,
AdminRole as fladminAdminRole, Sysconfig as fladminSysconfig,
Tag as fladminTag, Friendlink as fladminFriendlink,
AdminLog as fladminAdminLog, Keyword as fladminKeyword,
Searchword as fladminSearchword, Slide as fladminSlide,
Guestbook as fladminGuestbook)
from app.api.Controller import Article as ApiArticle
from app.api.Controller import GuestBook as ApiGuestBook
from app.Vendor.Ueditor import index as UeditorIndex
import aiohttp_cors

def setup_routes(app):
    """ app.router.add_static('/static/',
        path=str(project_root / 'static'),
        name='static') """
    #web client
    app.router.add_get('/', Index.index)
    app.router.add_get('/sitemap.xml', Index.sitemap)
    app.router.add_get('/articlelist/{key}', Article.index)
    app.router.add_get('/page/{id}', Page.detail)
    app.router.add_get('/index/search/detail', Search.detail)
    app.router.add_get('/p/{id}', Article.detail)
    app.router.add_get('/tag/{id}', Tag.detail)
    app.router.add_post('/api/article/index', ApiArticle.index)
    app.router.add_get('/guestBook/index',GuestBook.index)
    app.router.add_post('/api/guestBook/add', ApiGuestBook.add)

    #web admin
    app.router.add_get('/fladmin/Login', Login.index, name="adminLogin")
    app.router.add_post('/fladmin/Login/dologin', Login.dologin)
    app.router.add_get('/fladmin/login/loginout', Login.loginout)
    app.router.add_get('/fladmin/getCode', Login.getCode)
    app.router.add_get('/fladmin/index/index', fladminIndex.index)
    app.router.add_get('/fladmin/index/welcome', fladminIndex.welcome)
    app.router.add_get('/fladmin/index/upcache', fladminIndex.upcache)
    app.router.add_get('/fladmin/status', fladminIndex.status, name="status")

    app.router.add_get('/fladmin/article/index', fladminArticle.index)
    app.router.add_get('/fladmin/article/add', fladminArticle.addByGet)
    app.router.add_post('/fladmin/article/add', fladminArticle.addByPost)
    app.router.add_get('/fladmin/article/edit', fladminArticle.editByGet)
    app.router.add_post('/fladmin/article/edit', fladminArticle.editByPost)
    app.router.add_get('/fladmin/article/del', fladminArticle.delete)
    app.router.add_get('/fladmin/article/articleexists', fladminArticle.articleexists)
    app.router.add_get('/fladmin/article/repetarc', fladminArticle.repetarc)
    app.router.add_get('/fladmin/article/recommendarc', fladminArticle.recommendarc)

    app.router.add_get('/fladmin/articleType/index', fladminArticleType.index)
    app.router.add_get('/fladmin/articleType/add', fladminArticleType.addByGet)
    app.router.add_post('/fladmin/articleType/add', fladminArticleType.addByPost)
    app.router.add_get('/fladmin/articleType/edit', fladminArticleType.editByGet)
    app.router.add_post('/fladmin/articleType/edit', fladminArticleType.editByPost)
    app.router.add_get('/fladmin/articleType/delete', fladminArticleType.delete)

    app.router.add_get('/fladmin/page/index', fladminPage.index)
    app.router.add_post('/fladmin/page/add', fladminPage.addByPost)
    app.router.add_get('/fladmin/page/add', fladminPage.addByGet)
    app.router.add_get('/fladmin/page/edit', fladminPage.editByGet)
    app.router.add_post('/fladmin/page/edit', fladminPage.editByPost)
    app.router.add_get('/fladmin/page/delete', fladminPage.delete)

    app.router.add_get('/fladmin/menu/index', fladminMenu.index)
    app.router.add_post('/fladmin/menu/add', fladminMenu.addByPost)
    app.router.add_get('/fladmin/menu/add', fladminMenu.addByGet)
    app.router.add_get('/fladmin/menu/edit', fladminMenu.editByGet)
    app.router.add_post('/fladmin/menu/edit', fladminMenu.editByPost)
    app.router.add_get('/fladmin/menu/delete', fladminMenu.delete)

    app.router.add_get('/fladmin/admin/index', fladminAdmin.index)
    app.router.add_post('/fladmin/admin/add', fladminAdmin.addByPost)
    app.router.add_get('/fladmin/admin/add', fladminAdmin.addByGet)
    app.router.add_get('/fladmin/admin/edit', fladminAdmin.editByGet)
    app.router.add_post('/fladmin/admin/edit', fladminAdmin.editByPost)
    app.router.add_get('/fladmin/admin/delete', fladminAdmin.delete)

    app.router.add_get('/fladmin/adminrole/index', fladminAdminRole.index)
    app.router.add_post('/fladmin/adminrole/add', fladminAdminRole.addByPost)
    app.router.add_get('/fladmin/adminrole/add', fladminAdminRole.addByGet)
    app.router.add_get('/fladmin/adminrole/edit', fladminAdminRole.editByGet)
    app.router.add_post('/fladmin/adminrole/edit', fladminAdminRole.editByPost)
    app.router.add_get('/fladmin/adminrole/delete', fladminAdminRole.delete)
    app.router.add_get('/fladmin/adminrole/permissions', fladminAdminRole.permissions)
    app.router.add_post('/fladmin/adminrole/dopermissions', fladminAdminRole.dopermissions)

    app.router.add_get('/fladmin/sysconfig/index', fladminSysconfig.index)
    app.router.add_post('/fladmin/sysconfig/add', fladminSysconfig.addByPost)
    app.router.add_get('/fladmin/sysconfig/add', fladminSysconfig.addByGet)
    app.router.add_get('/fladmin/sysconfig/edit', fladminSysconfig.editByGet)
    app.router.add_post('/fladmin/sysconfig/edit', fladminSysconfig.editByPost)
    app.router.add_get('/fladmin/sysconfig/delete', fladminSysconfig.delete)

    app.router.add_get('/fladmin/tag/index', fladminTag.index)
    app.router.add_post('/fladmin/tag/add', fladminTag.addByPost)
    app.router.add_get('/fladmin/tag/add', fladminTag.addByGet)
    app.router.add_get('/fladmin/tag/edit', fladminTag.editByGet)
    app.router.add_post('/fladmin/tag/edit', fladminTag.editByPost)
    app.router.add_get('/fladmin/tag/delete', fladminTag.delete)

    app.router.add_get('/fladmin/friendlink/index', fladminFriendlink.index)
    app.router.add_post('/fladmin/friendlink/add', fladminFriendlink.addByPost)
    app.router.add_get('/fladmin/friendlink/add', fladminFriendlink.addByGet)
    app.router.add_get('/fladmin/friendlink/edit', fladminFriendlink.editByGet)
    app.router.add_post('/fladmin/friendlink/edit', fladminFriendlink.editByPost)
    app.router.add_get('/fladmin/friendlink/delete', fladminFriendlink.delete)

    app.router.add_get('/fladmin/admin_log/index', fladminAdminLog.index)
    app.router.add_post('/fladmin/admin_log/add', fladminAdminLog.addByPost)
    app.router.add_get('/fladmin/admin_log/add', fladminAdminLog.addByGet)
    app.router.add_get('/fladmin/admin_log/edit', fladminAdminLog.editByGet)
    app.router.add_post('/fladmin/admin_log/edit', fladminAdminLog.editByPost)
    app.router.add_get('/fladmin/admin_log/delete', fladminAdminLog.delete)
    app.router.add_get('/fladmin/admin_log/clear', fladminAdminLog.clear)

    app.router.add_get('/fladmin/keyword/index', fladminKeyword.index)
    app.router.add_post('/fladmin/keyword/add', fladminKeyword.addByPost)
    app.router.add_get('/fladmin/keyword/add', fladminKeyword.addByGet)
    app.router.add_get('/fladmin/keyword/edit', fladminKeyword.editByGet)
    app.router.add_post('/fladmin/keyword/edit', fladminKeyword.editByPost)
    app.router.add_get('/fladmin/keyword/delete', fladminKeyword.delete)

    app.router.add_get('/fladmin/searchword/index', fladminSearchword.index)
    app.router.add_post('/fladmin/searchword/add', fladminSearchword.addByPost)
    app.router.add_get('/fladmin/searchword/add', fladminSearchword.addByGet)
    app.router.add_get('/fladmin/searchword/edit', fladminSearchword.editByGet)
    app.router.add_post('/fladmin/searchword/edit', fladminSearchword.editByPost)
    app.router.add_get('/fladmin/searchword/delete', fladminSearchword.delete)

    app.router.add_get('/fladmin/slide/index', fladminSlide.index)
    app.router.add_post('/fladmin/slide/add', fladminSlide.addByPost)
    app.router.add_get('/fladmin/slide/add', fladminSlide.addByGet)
    app.router.add_get('/fladmin/slide/edit', fladminSlide.editByGet)
    app.router.add_post('/fladmin/slide/edit', fladminSlide.editByPost)
    app.router.add_get('/fladmin/slide/delete', fladminSlide.delete)

    app.router.add_get('/fladmin/guestbook/index', fladminGuestbook.index)
    app.router.add_get('/fladmin/guestbook/delete', fladminGuestbook.delete)

    #ueditor
    app.router.add_get('/static/other/flueditor/fladmin/ueditor', UeditorIndex)
    app.router.add_post('/static/other/flueditor/fladmin/ueditor', UeditorIndex)

    # Configure default CORS settings.
    cors = aiohttp_cors.setup(app, defaults={
        "*": aiohttp_cors.ResourceOptions(
                allow_credentials=True,
                expose_headers="*",
                allow_headers="*",
            )
    })
    # Configure CORS on all routes.
    for route in list(app.router.routes()):
        cors.add(route)

