'''
@Author: hua
@Date: 2019-04-12 09:39:33
@LastEditors: hua
@LastEditTime: 2020-06-07 19:09:04
'''
import asyncio
from aiohttp import web
from aiohttp_session import setup
from aiohttp_session.cookie_storage import EncryptedCookieStorage
from app.routes import setup_routes
from app.Middleware.AdminCheck import AdminCheck
from app.Middleware.Operation import Operation
from app.Vendor.tempDef import tuijian, randomInt, sysconfig, getArticleDetailUrl, getTagDetailUrl, date, getPageDetailUrl
from cryptography import fernet
import aiohttp_jinja2
import jinja2, os, base64


#if __name__=='__main__':

app=web.Application()   
# secret_key must be 32 url-safe base64-encoded bytes
fernet_key = fernet.Fernet.generate_key()
secret_key = base64.urlsafe_b64decode(fernet_key)
setup(app, EncryptedCookieStorage(b'\xa28\xcf\x89s\xe2\r\x08\x10\x8a\xf9\xb6t4\xf1(\x1b\xf3\xf4\n\xbc\xac\x90\x85V\xb1\x92}\xf5R\x17o'))
setup_routes(app) 
app.middlewares.append(AdminCheck)
app.middlewares.append(Operation)
""" 模板配置 """
env = aiohttp_jinja2.setup(app,
loader=jinja2.PackageLoader('app', 'templates'))
env.filters['sysconfig'] = sysconfig
env.filters['getArticleDetailUrl'] = getArticleDetailUrl
env.filters['getTagDetailUrl'] = getTagDetailUrl
env.filters['getPageDetailUrl'] = getPageDetailUrl
env.filters['randomInt'] = randomInt
env.filters['tuijian'] = tuijian
env.filters['date'] = date
app.router.add_static('/static/',
                    path=str(os.getcwd()+ '/static'),
                    name='static')
web.run_app(app)#, host='0.0.0.0', port=8080)