﻿<%
class ActionDataSqlite
	private sub Class_Initialize()
		Model__.defaultDBConf="Sqlite"
		Mo.assign "MO_METHOD",MO_METHOD
		Mo.assign "MO_ACTION",MO_ACTION
	end sub

	public sub init
		Model__.allowDebug=true
		Model__("Public").query "DROP TABLE IF EXISTS `MO_Public`"
		Model__("Public").query "DROP TABLE IF EXISTS `MO_Grade`"
		Model__("Public").query  "CREATE TABLE `MO_Public` (" &_
		"id integer NOT NULL PRIMARY KEY AUTOINCREMENT," &_
		"name varchar(64)," &_
		"age int(4)," &_
		"birthday datetime," &_
		"memo varchar(512)," &_
		"grade int)"
		Model__("Grade").query "CREATE TABLE `MO_Grade` (id integer NOT NULL PRIMARY KEY AUTOINCREMENT,name varchar(64))"
		call Model__("Grade").insert("name","一班").insert("name","二班").insert("name","三班").insert("name","四班").insert("name","五班")
		call Model__("Public").insert("name","张三","age",23,"birthday","1985-1-2 23:12:23","memo","我是张三","grade",1)
		call Model__("Public").insert("name","李四","age",41,"birthday","1988-1-6 23:12:23","memo","我是李四","grade",3)
		call Model__("Public").insert("name","王二","age",36,"birthday","1985-5-2 13:12:23","memo","我是张三王二","grade",4)
		call Model__("Public").insert("name","麻子","age",24,"birthday","1982-1-2 23:12:23","memo","我是麻子","grade",2)
		call Model__("Public").insert("name","艾恩","age",28,"birthday","1985-1-2 23:12:23","memo","我是张三","grade",5)
		call Model__("Public").insert("name","张三","age",23,"birthday","1985-1-2 23:12:23","memo","我是张三","grade",1)
		call Model__("Public").insert("name","李四","age",41,"birthday","1988-1-6 23:12:23","memo","我是李四","grade",3)
		call Model__("Public").insert("name","王二","age",36,"birthday","1985-5-2 13:12:23","memo","我是张三王二","grade",4)
		call Model__("Public").insert("name","麻子","age",24,"birthday","1982-1-2 23:12:23","memo","我是麻子","grade",2)
		call Model__("Public").insert("name","艾恩","age",28,"birthday","1985-1-2 23:12:23","memo","我是张三","grade",5)
		call Model__("Public").insert("name","艾恩","age",28,"birthday","1985-1-2 23:12:23","memo","我是张三","grade",5)
		call Model__("Public").insert("name","张三","age",23,"birthday","1985-1-2 23:12:23","memo","我是张三","grade",1)
		call Model__("Public").insert("name","李四","age",41,"birthday","1988-1-6 23:12:23","memo","我是李四","grade",3)
		call Model__("Public").insert("name","王二","age",36,"birthday","1985-5-2 13:12:23","memo","我是张三王二","grade",4)
		F.echo "数据库创建完毕。<br />"
		Model__.debug()
	end sub
	public sub list
		Call index()
	end sub
	public sub index
		'读出所有数据，并按照每页5条记录分页，最后将数据赋值到List变量
		'只选择id和name字段：Model__("Public","id").select("id,name").limit(F.get.int("page",1),5).query().assign "List"
		'.limit(F.get.int("page",1),5)
		Model__("Public").orderby("id asc").limit(F.get.int("page",1),5).query().assign "List"
		'读取要编辑的记录ID
		dim id:id = F.get.int("id",0)
		if id>0 then
			'如果id大于0，查询数据，并将首条记录作为对象（true参数）赋值到Item变量，如果assign的第二个参数省略，则将字段和值分别赋值为全局变量
			Model__("Public").where("id=" & id).query().assign "Item",True
		else
			'如果id不大于0，构造一条记录，用来新增，Record__的assign方法无其他构造
			dim item:set item = Record__()
			item.set "name",""
			item.set "age","0"
			item.set "birthday",F.formatdate(Now(),"yyyy-MM-dd")
			item.set "memo",""
			item.set "grade","0"
			item.assign "Item"
		end If
		'将id赋值为全局变量
		Mo.assign "id",id
		'将数据显示到模板，因为这里用的是Action.Data，所以需要用Home:来引用Actin.Home的模板
		Mo.display "Home:Data"
	end sub
	
	'****************************************************
	'@DESCRIPTION:	联合查询
	'****************************************************
	public sub com
		Model__("Public","id").select("`Mo_Public`.*,`Mo_Grade`.name as gname").join("Grade").on("`Mo_Public`.Grade=`Mo_Grade`.id").where("`Mo_Public`.id>=3").orderby("`Mo_Public`.id asc").limit(F.get.int("page",1),5).query().assign "List"
		Mo.display "Home:Data2"
	end sub
	
	'****************************************************
	'@DESCRIPTION:	all
	'****************************************************
	public sub all
		Mo.assign "recordcount",Model__("Public","id").orderby("id asc").query().assign("List").fetch().recordcount
		Mo.display "Home:Data3"
	end sub
	
	public sub modify
		F.post "name",F.post.safe("name")
		F.post "memo",F.post.safe("memo")
		dim FV:set FV = Mo("FormValidatee")
		FV.AddRule "id","required;numeric","ID错误"
		FV.AddRule "name","required;min-length:5;max-length:20"
		FV.AddRule "age","required;between:1,200"
		FV.AddRule "birthday","required;exp:/^(\d{4})\-(\d{1,2})\-(\d{1,2})$/"
		FV.AddRule "memo","max-length:50;"
		FV.AddRule "grade","required;numeric","级别必须为数字"
		if FV.Validate() then
			if F.post.int("id",0)=0 then
				'直接从post读数据，插入数据库，如果担心安全问题，请使用Record__构造一个字典，作为insert的参数传递
				Model__("Public","id").insert()
			else
				'直接从post读数据，更新数据库，如果担心安全问题，请使用Record__构造一个字典，作为update的参数传递
				Model__("Public","id").update()
			end if
			F.goto "?m=" & MO_METHOD,"保存成功"
		else
			F.goto "?m=" & MO_METHOD,FV.exception
		end if
	end sub
	public sub delete
		'删除记录
		Model__("Public","id").where("id=" & F.get.int("id")).delete()
		F.goto "?m=" & MO_METHOD,"删除完成"
	end sub
end class
%>