/***********************************************
*      JS - FancyCoder for JavaScript
*              version 1.0 beta
***********************************************/

//﷨壬Ӧ
//lang: Ϊ0IDֱʾҪԣдʾ
function FCCheckSyntaxDef(/*lang, ...*/) {
	//趨б
	if (arguments.length > 0) {
		var langList = {};
		for (var i = arguments.length - 1; i >= 0; i--) {
			if (FCSyntaxDef[arguments[i]] != null) langList[arguments[i]] = true;
		}
	} else {
		var langList = FCSyntaxDef;
	}
	//μ
	for (var lang in langList) {
		var syntax = FCSyntaxDef[lang];
		//ͨı
		if (syntax.color == null) syntax.color = "#000000";
		if (syntax.style == null) syntax.style = "";
		else syntax.sytle = syntax.style.toLowerCase();
		//ʶ
		var delim = syntax.delimiters;
		if (delim == null) {
			syntax.delimiters = "~!@%^&*()-+=|\\/{}[]:;\"'<>,.? \t";
		} else if (delim.indexOf(" \t") < 0) {
			syntax.delimiters += " \t";
		}
		//ע
		if (syntax.comments != null) {
			if (typeof(syntax.comments) == "string") syntax.comments = syntax.comments.split(" ");
			if (syntax.cmtcolor == null) syntax.cmtcolor = "#00ff00";
			if (syntax.cmtstyle == null) syntax.cmtstyle = "";
			else syntax.cmtsytle = syntax.cmtstyle.toLowerCase();
		} else {
			syntax.comments = [];
		}
		//
		var blocks = syntax.blocks;
		for (var classid in blocks) {
			var block = blocks[classid];
			if (block.color == null) block.color = "#00ffff";
			if (block.style == null) block.style = "";
			else block.style = block.style.toLowerCase();
			block.lines = block.lines == true;
		}
		//ؼ
		var keywords = syntax.keywords;
		for (var classid in keywords) {
			var group = keywords[classid];
			if (group.color == null) group.color = "#0000ff";
			if (group.style == null) group.style = "";
			else group.style = group.style.toLowerCase();
			group.list = (" " + (group.list instanceof Array ? group.list.join(" ")
				: group.list) + " ").replace(/  +/g, " ");
		}
	}
}
//--------------------------------------------------------------

//CSSʽ
//classid: CSSʽID
//font: 
//size: С
//color: ɫ
//style: 
function FCMakeCSSClass(classid, color, style, font, size) {
	return "." + classid + " {\r\n\tcolor: " + color + ";\r\n"
		+ (style.indexOf("b") < 0 ? "" : "\tfont-weight: bold;\r\n")
		+ (style.indexOf("i") < 0 ? "" : "\tfont-style: italic;\r\n")
		+ (style.indexOf("u") < 0 ? "" : "\ttext-decoration: underline;\r\n")
		+ (font == null ? "" : "\tfont-family: " + font + ";\r\n")
		+ (size == null ? "" : "\tfont-size: " + size + ";\r\n")
		+ "}\r\n";
}
//--------------------------------------------------------------

//ָԵCSSʽתõCSS룬Բ򷵻null
//lang: ﷨ID
//font: 壬Ϊ󣬾ÿԱӦӦclassid
//size: ĴСΪ󣬾ÿԱӦӦclassid
function FCMakeCSS(lang, font, size) {
	var syntax = FCSyntaxDef[lang];
	if (syntax == null) return null;
	var fontList = font instanceof Object;
	var sizeList = size instanceof Object;
	//ͨıʽ
	var css = FCMakeCSSClass(lang + "_Default", syntax.color, syntax.style,
		fontList ? font.comment : font, sizeList ? size.comment : size);
	//עʽ
	if (syntax.comments.length > 0) {
		css += FCMakeCSSClass(lang + "_Comments", syntax.cmtcolor, syntax.cmtstyle,
			fontList ? font.comment : font, sizeList ? size.comment : size);
	}
	//ʽ
	for (var classid in syntax.blocks) {
		var block = syntax.blocks[classid];
		css += FCMakeCSSClass(lang + "_" + classid, block.color, block.style,
			fontList ? font[classid] : font, sizeList ? size[classid] : size);
	}
	//ؼʽ
	for (var classid in syntax.keywords) {
		var group = syntax.keywords[classid];
		css += FCMakeCSSClass(lang + "_" + classid, group.color, group.style,
			fontList ? font[classid] : font, sizeList ? size[classid] : size);
	}
	return css;
}
//--------------------------------------------------------------

//׺ش׺{prefix:ǰ׺,suffix:׺}
//mode: תģʽ0<font>ģʽ1<span>ģʽ2<span>ģʽcss3:[UBB]ģʽĬ0
//classid: ID
//color: ɫ
//style: 
function FCMakeAffix(mode, classid, color, style) {
	if (mode == 1 || mode == 2) {
		return {
			prefix : "<SPAN class='" + classid + "'>",
			suffix : "</SPAN>"
		};
	} else if (mode == 3) {
		var nb = style.indexOf("b") >= 0;
		var ni = style.indexOf("i") >= 0;
		var nu = style.indexOf("u") >= 0;
		return {
			prefix : "[color=" + color + "]" + (nb?"[b]":"") + (ni?"[i]":"") + (nu?"[u]":""),
			suffix : (nu?"[/u]":"") + (ni?"[/i]":"") + (nb?"[/b]":"") + "[/color]"
		};
	} else {
		var nb = style.indexOf("b") >= 0;
		var ni = style.indexOf("i") >= 0;
		var nu = style.indexOf("u") >= 0;
		return {
			prefix : "<FONT color='" + color + "'>" + (nb?"<B>":"") + (ni?"<I>":"") + (nu?"<U>":""),
			suffix : (nu?"</U>":"") + (ni?"</I>":"") + (nb?"</B>":"") + "</FONT>"
		};
	}
}
//--------------------------------------------------------------

//ԸַHTML
//str: Ҫַ
function FCHtmlEncode(str) {
	return str.replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;");
}
//--------------------------------------------------------------

//ԸַUBB
//str: Ҫַ
function FCUbbEncode(str) {
	return str.replace(/\[/g, "[").replace(/\]/g, "]");
}
//--------------------------------------------------------------

//תԴ뵽HTML룬ת룬Բ򷵻null
//srcCode: ҪתԴ
//lang: תõ﷨ID
//mode: תģʽĬ0
function FCTranslate(srcCode, lang, mode) {
	var syntax = FCSyntaxDef[lang];
	if (syntax == null) return null;
	var src = srcCode.split("\r\n");
	var encode = mode == 3 ? FCUbbEncode : FCHtmlEncode;
	//ͨı׺
	var affix = FCMakeAffix(mode, lang + "_Default", syntax.color, syntax.style);
	var defPref = affix.prefix, defSuff = affix.suffix;
	//עͼ׺
	var comments = syntax.comments;
	if (comments.length > 0) {
		var affix = FCMakeAffix(mode, lang + "_Comments", syntax.cmtcolor, syntax.cmtstyle);
		var cmtPref = affix.prefix, cmtSuff = affix.suffix;
	}
	//׺
	var blkBegin = [], blkEnd = [], blkEsc = [], blkLines = [], blkPref = [], blkSuff = [];
	for (var classid in syntax.blocks) {
		var block = syntax.blocks[classid];
		blkBegin.push(block.begin);
		blkEnd.push(block.end);
		blkEsc.push(block.escape);
		blkLines.push(block.lines);
		var affix = FCMakeAffix(mode, lang + "_" + classid, block.color, block.style);
		blkPref.push(affix.prefix);
		blkSuff.push(affix.suffix);
	}
	//ؼʼ׺
	var keywords = [], kwPref = [], kwSuff = [];
	for (var classid in syntax.keywords) {
		var group = syntax.keywords[classid];
		keywords.push(group.list);
		var affix = FCMakeAffix(mode, lang + "_" + classid, group.color, group.style);
		kwPref.push(affix.prefix);
		kwSuff.push(affix.suffix);
	}
	//ϴת
	var delim = syntax.delimiters;
	for (var index = 0, index2 = 0; index < src.length; index++, index2++) {
		var code = src[index];
		var htmlCode = "";
		for (var pos1 = 0, pos2 = 0, ch = null, flag = 0; ch != ""; pos2++) {
			ch = code.substr(pos2, 1);
			if (ch != "" && flag == 0 && delim.indexOf(ch) < 0) continue;
			//Ϊıضϣflag0ı1ո2㣩
			if (pos2 <= pos1) {
				flag = ch.match(/s/g) ? 1 : 2;
				continue;
			}
			var word = code.substr(pos1, pos2 - pos1); //ȡ
			if (flag == 1) { //ո
				htmlCode += word;
			} else {
				if (flag == 2) { //
					//бע
					for (var i in comments) {
						if (code.substr(pos1, comments[i].length) != comments[i]) continue;
						htmlCode += cmtPref + encode(code.substr(pos1)) + cmtSuff;
						word = "";
						break;
					}
					if (word == "") break;
					//б
					for (var i in blkBegin) {
						if (code.substr(pos1, blkBegin[i].length) != blkBegin[i]) continue;
						var end = blkEnd[i], esc = blkEsc[i];
						for (pos2 = pos1 + blkBegin[i].length; pos2 = code.indexOf(end, pos2);) {
							if (pos2 < 0) {
								if (blkLines[i] && index < src.length - 1) {
									pos2 = code.length + 2;
									code += "\r\n" + src[++index];
									continue;
								}
								htmlCode += blkPref[i] + encode(code.substr(pos1)) + blkSuff[i];
								word = "";
								break;
							} else if (esc == null || code.substr(pos2 - esc.length, esc.length) != esc) {
								pos2 += end.length;
								break;
							}
							pos2 += end.length;
						}
						if (pos2 >= 0) {
							htmlCode += blkPref[i] + encode(code.substr(pos1, pos2 - pos1)) + blkSuff[i];
							flag = 0;
							pos1 = pos2;
							pos2--;
							word = "0";
						}
						break;
					}
					if (word == "") break;
					else if (word == "0") continue;
				}
				//ؼּ
				var w = encode(word);
				for (var i in keywords) {
					if (keywords[i].indexOf(" " + word + " ") < 0) continue;
					htmlCode += kwPref[i] + w + kwSuff[i];
					word = "";
					break;
				}
				if (word != "") htmlCode += w;
			}
			flag = delim.indexOf(ch) < 0 ? 0 : ch.match(/s/g) ? 1 : 2;
			pos1 = pos2;
		}
		src[index2] = htmlCode;
	}
	src.splice(index2, src.length);
	return defPref + src.join("\r\n") + defSuff;
}
//--------------------------------------------------------------

//ԭHTML뵽Դ룬ػԭĴ
//htmlCode: ҪԭHTML
function FCRevert(htmlCode) {
}
//--------------------------------------------------------------

//ԤڲĻʾ
//title: ڱ
//content: ԤHTMLı
//wndWidth: ڿȣĬ640
//wndHeight: ڸ߶ȣĬ480
function FCPreview(title, content, wndWidth, wndHeight) {
	if (!(wndWidth > 0)) wndWidth = 640;
	if (!(wndHeight > 0)) wndHeight = 480;
	var left = screen.width/2 - wndWidth/2;
	var top = screen.height/2 - wndHeight/2;
	var previewWnd = window.open("", "FCPreviewWnd", "scrollbars=yes,resizable=yes,menubar=yes,"
		+ "width=" + wndWidth + ",height=" + wndHeight + ",left=" + left + ",top=" + top
		+ ",screenX=" + left + ",screenY=" + top);
	previewWnd.document.write("<HTML><HEAD><TITLE>" + title + "</TITLE></HEAD>\r\n<BODY leftmargin='0'"
		+ " topmargin='0' marginwidth='0' marginheight='0'><TABLE width='200'><TR><TD><PRE>\r\n"
		+ content + "\r\n</PRE></TD></TR></TABLE></BODY></HTML>");
}
//--------------------------------------------------------------

//﷨ѡб
//selectLang: ĬѡеIDĬѡеһ
function FCSyntaxOptions(selectLang) {
	for (var i in FCSyntaxDef) {
		if (selectLang == null) selectLang == i;
		document.write('<OPTION value="' + i + '"' + (selectLang == i ? ' selected' : '')
			+ '>' + FCSyntaxDef[i].name + '</OPTION>');
	}
}
//--------------------------------------------------------------

//﷨弯
if (typeof(FCSyntaxDef) == "undefined") {
	FCSyntaxDef = {};
} else {
	FCCheckSyntaxDef();
}
//--------------------------------------------------------------
