window.console = window.console || (function () {
	var c = {};
	c.log = c.warn = c.debug = c.info = c.error = c.time = c.dir = c.profile = c.clear = c.exception = c.trace = c.assert = function () { };
	return c;
})();

var addEvent = function (element, type, fn) {
	if (typeof element != 'object' || typeof fn != 'function') return;
	if (document.addEventListener) {
		try {
			element.addEventListener(type, fn, false);
		} catch (error) {
			for (var i = 0; i < element.length; i++) {
				addEvent(element[i], type, fn);
			}
		}
	} else {
		if (element.length && element.nodeName !== 'SELECT') {
			for (var i = 0; i < element.length; i++) {
				addEvent(element[i], type, fn);
			}
		} else {
			element.attachEvent('on' + type,
				function () {
					return fn.call(element, window.event);
				}
			);
		}
	}
};

if (!Array.prototype.forEach) {
	Array.prototype.forEach = function forEach(callback, thisArg) {
		var T, k;
		if (this == null) {
			throw new TypeError('this is null or not defined');
		}
		var O = Object(this);
		var len = O.length >>> 0;
		if (typeof callback !== 'function') {
			throw new TypeError(callback + ' is not a function');
		}
		if (arguments.length > 1) {
			T = thisArg;
		}
		k = 0;
		while (k < len) {
			var kValue;
			if (k in O) {
				kValue = O[k];
				callback.call(T, kValue, k, O);
			}
			k++;
		}
	};
}

function tr_mouse_over(element) {
	document.getElementById(element).style.backgroundColor = '#FFFDBE';
}

function tr_mouse_out(element) {
	document.getElementById(element).style.backgroundColor = 'transparent';
}

addEvent(document.body, 'keydown', function () {
	EnableKey();
});

if (document.getElementById('pageSelect') !== null) {
	addEvent(document.getElementById('pageSelect'), 'change', function () {
		if (this.options[this.selectedIndex].value != '') {
			location = this.options[this.selectedIndex].value;
		}
	});
}

try {
	if (document.getElementById('Confirmer') !== null) {
		addEvent(document.getElementById('Confirmer'), 'click', function () {
			Confirmer();
		});
	}
} catch (error) { }

try {
	for (var i = 0; i < jsArr.length; i++) {
		(function (i) {
			var k = i + 1;
			var nowJsArr = jsArr[i].split(',');
			var changeDom = 'chageDiv_' + k;
			var delInfoDom = 'delInfo_' + k;
			var id = nowJsArr[0];
			var gbookurl = nowJsArr[1];
			var username = nowJsArr[2];
			var pagetosort = nowJsArr[3];
			if (document.getElementById(changeDom) !== null) {
				addEvent(document.getElementById(changeDom), 'click', function () {
					chageDiv(pagetosort);
				});
			}
			if (document.getElementById(delInfoDom) !== null) {
				addEvent(document.getElementById(delInfoDom), 'click', function () {
					fun_del(id, gbookurl, username);
				});
			}
			// document.getElementById(nowDom).style.cursor = 'pointer';
		})(i);
	}
} catch (error) { }

try {msg;} catch (error) {msg = '';}
if (msg !== '') {
	var speed = 200;
	var msgud = ' ' + msg;
	var chearTimes = null;
	function titleScroll() {
		clearTimeout(chearTimes);
		if (msgud.length < msg.length) msgud += ' - ' + msg;
		msgud = msgud.substring(1, msgud.length);
		document.title = msgud.substring(0, msg.length);
		chearTimes = setTimeout(function () {
			titleScroll();
		}, speed);
	}	
}

if (document.getElementById('mobbianlaniSUB') !== null) {
	addEvent(document.getElementById('mobbianlaniSUB'), 'click', function () {
		wdlf_search_by_content();
	});
}

if (document.getElementById('mobfanhuiSUB') !== null) {
	addEvent(document.getElementById('mobfanhuiSUB'), 'click', function () {
		window.history.back();
	});
}