// Copyright 2005 Netvibes

var proxyURL = 'xmlProxy.asp?url=';

var User = new Object();
User.feedsId = null;

App.moduleList = [];

var appLocation = window.location.href;
var URLDomain = appLocation.substring(0,appLocation.indexOf("/", 7));
if (!URLDomain) URLDomain = appLocation;
App.location = URLDomain;

App.Modules = new Object();

App.Modules.RssReaderInfos = {
	infos: App.Loc.defaultRssReader_infos,
	defaultObj: {status:1, share:0, title:"", moduleName:"RssReader", data:{}}
}
App.Modules.GmailInfos = {
	title: App.Loc.defaultGmail_title,
	infos: App.Loc.defaultGmail_infos,
	defaultObj:{status:1, share:0, title:App.Loc.defaultGmail_title, moduleName:"Gmail", data:{}},
	path: "modules/gmail/gmail.js?v=1"
}
App.Modules.WeatherInfos = {
	title: App.Loc.defaultWeather_title,
	infos: App.Loc.defaultWeather_infos,
	defaultObj:{status:1, share:0, title:App.Loc.defaultWeather_title, moduleName:"Weather", data:{town:"FRXX0076"}},
	path: "modules/weather/weather.js?v=1"
}
App.Modules.PriceWatchInfos = {
	title: App.Loc.defaultPriceWatch_title,
	infos: App.Loc.defaultPriceWatch_infos,
	defaultObj:{status:1, share:0, title:App.Loc.defaultPriceWatch_title, moduleName:"PriceWatch", data:{query:"psp", catId:"110001", nbOffers:"4"}},
	path: "modules/priceWatch/priceWatch.js?v=1"
}
App.Modules.WebSearchInfos = {
	title: App.Loc.defaultWebSearch_title,
	infos: App.Loc.defaultWebSearch_infos,
	defaultObj:{status:1, share:0, title:App.Loc.defaultWebSearch_title, moduleName:"WebSearch", data:{}},
	path: "modules/webSearch/webSearch.js?v=1"
}
App.Modules.MyBookmarksInfos = {
	title: App.Loc.defaultMyBookmarks_title,
	infos: App.Loc.defaultMyBookmarks_infos,
	defaultObj:{status:1, share:0, title:App.Loc.defaultMyBookmarks_title, moduleName:"MyBookmarks", data:{}}
}
App.Modules.PublicBookmarksInfos = {
	title: App.Loc.defaultPublicBookmarks_title,
	infos: App.Loc.defaultPublicBookmarks_infos,
	defaultObj:{status:1, share:0, title:App.Loc.defaultPublicBookmarks_title, moduleName:"PublicBookmarks", data:{}}
}
App.Modules.FlickrInfos = {
	title: App.Loc.defaultFlickr_title,
	infos: App.Loc.defaultFlickr_infos,
	defaultObj:{status:1, share:0, title:App.Loc.defaultFlickr_title, moduleName:"Flickr", data:{}}
}
App.Modules.PostItInfos = {
	title: App.Loc.defaultPostIt_title,
	infos: App.Loc.defaultPostIt_infos,
	defaultObj:{status:1, share:0, title:App.Loc.defaultPostIt_title, moduleName:"PostIt", data:{}},
	path: "modules/postIt/postIt.js?v=4"
}
App.Modules.TodoListInfos = {
	title: App.Loc.defaultTodoList_title,
	infos: App.Loc.defaultTodoList_infos,
	defaultObj:{status:1, share:0, title:App.Loc.defaultTodoList_title, moduleName:"TodoList", data:{}}
}
App.Modules.WritelyInfos = {
	title: App.Loc.defaultWritely_title,
	infos: App.Loc.defaultWritely_infos,
	defaultObj:{status:1, share:0, title:App.Loc.defaultWritely_title, moduleName:"Writely", data:{}},
	path: "modules/writely/writely.js?v=1"
}
App.Modules.EchosInfos = {
	title: App.Loc.defaultEchos_title,
	infos: App.Loc.defaultEchos_infos,
	defaultObj:{status:1, share:0, title:App.Loc.defaultEchos_title, moduleName:"Echos", data:{}},
	path: "modules/echos/echos.js?v=1"
}

// ========= MISC ====================================================

App.CollapseAllModules = function() {
	var ln = App.moduleList.length;
	for (var z=0; z<ln; z++) {
		App.moduleList[z].showHideModule(false, "nosave");
	}
	App.saveUserData("collapseExpand", 0);
}
App.ExpandAllModules = function() {
	var ln = App.moduleList.length;
	for (var z=0; z<ln; z++) {
		App.moduleList[z].showHideModule(true, "nosave");
	}	
	App.saveUserData("collapseExpand", 1);
}

// ========= NAVIGATION MENU ====================================================

App.Nav = new Object();
App.Nav.isOpen = false;
App.Nav.isModuleBox = false;
App.Nav.width = 220;
App.Nav.isFeedsUpdated = false;

App.Nav.openCloseSelection = function() {
	var divTree = document.getElementById("nav");
	if (divTree.hasChildNodes()) {
		var tree = document.getElementById("selectionTree");
		if (divTree.firstChild.style.display=="none") {
			divTree.firstChild.style.display = "block";
			tree.style.width = App.Nav.width+"px";
			App.Nav.isOpen = true;
		} else {
			divTree.firstChild.style.display = "none";
			tree.style.width = "9px";
			App.Nav.removeModuleBox();
			App.Nav.isOpen = false;
		}
	} else {
		divTree.style.width = App.Nav.width+"px";
		App.Nav.build();
		App.Nav.isOpen = true;
	}
	App.FeedReader.resize();
}

App.Nav.removeInfosBox = function() {
	var div = document.getElementById("navInfosBox");
	div.innerHTML = "";
	div.style.display = "none";
}

App.Nav.removeModuleBox = function() {
	var div = document.getElementById("navModuleBox");
	div.innerHTML = "";
	div.style.display = "none";
	App.Nav.isModuleBox = false;
}

App.Nav.drawModuleBox = function(node) {
	App.Nav.removeModuleBox();
	App.Nav.isModuleBox = true;
	App.Nav.removeInfosBox();
	var div = document.getElementById("navModuleBox");
	div.style.width = "350px";
	div.style.display = "block";
	div.style.left = (App.Nav.width-2)+"px";
	div.style.top = (findPosY(node)-12)+"px";

	var frame = document.createElement("div");
	frame.className = "frame";

	var frame2 = document.createElement("div");
	frame2.className = "frame2";
	frame2.id = "pickupZone";

	frame.appendChild(frame2);
	div.appendChild(frame);
}

App.Nav.displayFeedOptions = function(node) {
	App.Nav.removeModuleBox();
	var sub = (node.getAttribute("sub")==1) ? true : false;	
	
	var div = document.getElementById("navModuleBox");
	div.style.width = "auto";
	div.style.display = "block";
	div.style.borderLeft = 0;
	div.style.left = (App.Nav.width-5)+"px";
	div.style.top = (findPosY(node)-5)+"px";

	var frame = document.createElement("div");
	frame.className = "frame";
	var frame2 = document.createElement("div");
	frame2.className = "frame2";
	frame2.style.padding = 0;
	
	frame2.innerHTML = '<table cellpadding="0" cellspacing="0" class="feedOptions"><tr><td style="vertical-align:top"><div>'+App.Loc.navRename+'</div><div>'+App.Loc.navDelete+'</div><div>'+App.Loc.navMove+'</div></td><td class="content"></td></tr></table>';
	var divs = frame2.getElementsByTagName("div");
	var content = frame2.getElementsByTagName("td")[1];
	
	var editMenu = divs[0];
	var deleteMenu = divs[1];
	var moveMenu = divs[2];
	if (sub) moveMenu.style.display = "none";
	
	editMenu.onmouseover = deleteMenu.onmouseover = moveMenu.onmouseover = function() {
		this.style.backgroundColor = "#D4E4FE";
		node.lastChild.style.color = "#F60";
		node.lastChild.style.borderBottom = "1px solid #F60";
	}
	editMenu.onmouseout = deleteMenu.onmouseout = moveMenu.onmouseout = function() {
		this.style.backgroundColor = "#EFF5FF";
	}
	
	editMenu.onclick = function() {
		content.innerHTML = '<form><table cellpadding="0" cellspacing="0"><tr><td><input type="text" class="inputClean" accesskey="t" maxlength="150" style="width:120px"/><input type="submit" value=" Ok " class="buttonClean" style="margin-right:0"/></td></tr></table></form>';
		content.style.display = "block";
		var input = content.getElementsByTagName("input")[0];
		var form = content.getElementsByTagName("form")[0];
		input.value = node.lastChild.firstChild.nodeValue;
		input.focus();
		form.onsubmit = sendEdit;
		function sendEdit() {
			content.innerHTML = App.Loc.navSaving+"...";
			var value = input.value.trim();
			if (value!='') {
				function updateTitle(response) {
					switch(response.responseText) {
						case 'success':
							node.lastChild.innerHTML = '';
							node.lastChild.appendChild(document.createTextNode(value));
							App.Nav.removeModuleBox();
							break;
					}
				}
				Request.sendGET("editUserFeed.php?action=edit&id="+node.getAttribute("id")+"&title="+encodeURIComponent(value)+"&nocache="+Math.random(), updateTitle);
			}
			return false;
		}
	}
	deleteMenu.onclick = function() {
		content.innerHTML = App.Loc.navDeleteConfirm+'&nbsp;<input type="button" value=" '+App.Loc.yes+' " class="buttonClean" /><input type="button" value=" '+App.Loc.no+' " class="buttonClean" style="margin-right:0"/>';
		content.style.display = "block";
		var inputs = content.getElementsByTagName("input");
		inputs[0].onclick = sendDelete;
		inputs[1].onclick = function() {
			App.Nav.removeModuleBox();
		}
		function sendDelete() {
			content.innerHTML = App.Loc.navSaving+"...";
			function updateFeedList(response) {
				switch(response.responseText) {
					case 'success':
						node.parentNode.removeNode(true);
						App.Nav.removeModuleBox();
						break;
				}
			}
			Request.sendGET("editUserFeed.php?action=delete&id="+node.getAttribute("id")+"&nocache="+Math.random(), updateFeedList);
		}
	}
	moveMenu.onclick = function() {
		content.innerHTML = App.Loc.navMoveTo+'&nbsp;<select style="width:150px;"><option selected>'+App.Loc.loading+'...</select>&nbsp;<input type="button" value=" Ok " class="buttonClean" />';
		var selectInput = content.getElementsByTagName("select")[0];
		var okBtn = content.getElementsByTagName("input")[0];
		content.style.display = "block";
		okBtn.disabled = true;
		selectInput.disabled = true;
		okBtn.onclick = sendMove;
		
		function sendMove() {
			var selectValue = selectInput.value;
			content.innerHTML = App.Loc.navSaving+"...";
			function reloadFeedList(response) {
				switch(response.responseText) {
					case 'success':
						App.Nav.removeModuleBox();
						App.Nav.isFeedsUpdated = true;
						App.Nav.openMyFeeds();
						break;
				}
			}
			Request.sendGET("editUserFeed.php?action=move&id="+node.getAttribute("id")+"&targetId="+selectValue+"&userFeedId="+User.feedsId+"&newCatName="+encodeURIComponent(App.Loc.navMyNewCat)+"&nocache="+Math.random(), reloadFeedList);
		}
		
		function getLevel1List(response) {
			selectInput.options[0] = null;
			var root = response.responseXML.documentElement;
			var feeds = root.getElementsByTagName("feed");
			var ln = feeds.length;
			for (var z=0; z<ln; z++) {
				if (feeds[z].getAttribute("sub")==1) {
					selectInput.options[selectInput.options.length] = new Option(feeds[z].getAttribute("title"), feeds[z].getAttribute("id"));
				}
			}
			selectInput.options[selectInput.options.length] = new Option(App.Loc.navNewCat, 0);
			selectInput.disabled = false;
			okBtn.disabled = false;
		}
		Request.sendGET("getUserFeed.php?id="+User.feedsId+"&nocache="+Math.random(), getLevel1List);
	}
	
	frame.appendChild(frame2);
	div.appendChild(frame);
}

App.Nav.displayExportOption = function(node) {
	App.Nav.removeModuleBox();	
	var div = document.getElementById("navModuleBox");
	div.style.width = "auto";
	div.style.display = "block";
	div.style.borderLeft = 0;
	div.style.left = (App.Nav.width-5)+"px";
	div.style.top = (findPosY(node)-5)+"px";
	
	var frame = document.createElement("div");
	frame.className = "frame";
	var frame2 = document.createElement("div");
	frame2.className = "frame2";
	frame2.style.padding = 0;	
	frame2.innerHTML = '<table cellpadding="0" cellspacing="0"><tr><td class="link"><a href="my_netvibes_feeds" target="_blank">'+App.Loc.navExportOPML+'</a></td></tr></table>';
	var link = frame2.getElementsByTagName("td")[0];
	
	link.onmouseover = function() {
		this.style.backgroundColor = "#D4E4FE";
		/*node.lastChild.style.color = "#F60";
		node.lastChild.style.borderBottom = "1px solid #F60";*/
	}
	link.onmouseout = function() {
		this.style.backgroundColor = "#EFF5FF";
	}
	
	frame.appendChild(frame2);
	div.appendChild(frame);
}

App.Nav.openMyFeeds = function() {
	var div = document.getElementById("myFeeds");
	if (div) div.firstChild.onclick();
}

App.Nav.build = function() {
	var moduleSelection = document.createElement("div");
	moduleSelection.id = "moduleSelection";

	var selectionFrame = document.createElement("div");
	selectionFrame.id = "moduleSelectionFrame";

	var frame2 = document.createElement("div");
	frame2.id = "widgetsList";
	frame2.style.margin = "3px";

	var moduleListContent = '<div class="separator"></div>'+
				'<div mod="WebSearch" ico="./img/search.gif" class="liLike"><div class="itemLineMain"><div class="folderIcon"></div><div class="text">'+App.Modules.WebSearchInfos.title+'</div></div></div>'+
				'<div mod="Weather" ico="./img/weather.gif" class="liLike"><div class="itemLineMain"><div class="folderIcon"></div><div class="text">'+App.Modules.WeatherInfos.title+'</div></div></div>'+
				'<div mod="Gmail" ico="http://mail.google.com/favicon.ico" class="liLike"><div class="itemLineMain"><div class="folderIcon"></div><div class="text">'+App.Modules.GmailInfos.title+'</div></div></div>'+
				'<div mod="PostIt" ico="./img/postit.gif" class="liLike"><div class="itemLineMain"><div class="folderIcon"></div><div class="text">'+App.Modules.PostItInfos.title+'</div></div></div>';
				/*'<div mod="MyBookmarks" class="liLike"><div class="itemLineMain"><div class="folderIcon"></div><div class="text">'+App.Modules.MyBookmarksInfos.title+'</div></div></div>'+
				'<div mod="PublicBookmarks" class="liLike"><div class="itemLineMain"><div class="folderIcon"></div><div class="text">'+App.Modules.PublicBookmarksInfos.title+'</div></div></div>'+
				'<div mod="Flickr" ico="./img/flickr.gif" class="liLike"><div class="itemLineMain"><div class="folderIcon"></div><div class="text">'+App.Modules.FlickrInfos.title+'</div></div></div>'+
				'<div mod="TodoList" class="liLike"><div class="itemLineMain"><div class="folderIcon"></div><div class="text">'+App.Modules.TodoListInfos.title+'</div></div></div>'+*/
	/*if (App.lang=="fr")*/ moduleListContent += '<div mod="PriceWatch" class="liLike"><div class="itemLineMain"><div class="folderIcon"></div><div class="text">'+App.Modules.PriceWatchInfos.title+'</div></div></div>';
	//if (App.lang=="en") moduleListContent += '<div mod="Writely" ico="./img/writely.gif" class="liLike"><div class="itemLineMain"><div class="folderIcon"></div><div class="text">'+App.Modules.WritelyInfos.title+'</div></div></div>';
	//if (App.lang=="en") moduleListContent += '<div mod="Echos" class="liLike"><div class="itemLineMain"><div class="folderIcon"></div><div class="text">'+App.Modules.EchosInfos.title+'</div></div></div>';

	var content = '<div style="padding: 0 0 5px;height:100%;">'+
				'<div style="float:right;padding:2px"><img src="./img/closeMod.gif" /></div>'+
				'<div mod="RssReader" ico="./img/add2.gif" style="padding: 5px 2px 0 7px"><div class="itemLineMain"><div class="folderIcon"></div><div class="text">'+App.Loc.navAddFeed+'</div></div></div>'+
				'<div class="separator"></div>'+
				'<div id="myFeeds" sub="0" class="liLike"><div class="itemLineMain"><div class="showSub"></div><img class="edit" src="./img/showModBlue.gif"/><div class="text">'+App.Loc.navMyFeeds+'</div></div></div>'+
				'<div id="featuredFeeds" sub="1" class="liLike"><div class="itemLineMain"><div class="showSub"></div><div class="text">'+App.Loc.navFeaturedFeeds+'</div></div></div>'+
				'<div sub="2" class="liLike"><div class="itemLineMain"><div class="showSub"></div><div class="text">'+App.Loc.navCategories+'</div></div></div>'+
				moduleListContent+
				'</div>';
	
	var contentInFeaturedPageMode = '<div style="padding: 0 0 5px;height:100%;">'+
				'<div style="float:right;padding:2px"><img src="./img/closeMod.gif" /></div>'+
				'<div id="featuredFeeds" sub="1" style="padding: 5px 2px 0 7px"><div class="itemLineMain"><div class="showSub"></div><div class="text">'+App.Loc.navFeaturedFeeds+'</div></div></div>'+
				'</div>';

	frame2.innerHTML = (App.mode=='userPage') ? content : contentInFeaturedPageMode;
	
	var closeNode = frame2.firstChild.firstChild;
	closeNode.style.cursor = "pointer";
	closeNode.onclick = function() {
		App.Nav.openCloseSelection();
	}

	var itms = frame2.firstChild.childNodes;
	var items = [];
	for (var z=0; z<itms.length; z++) {
		if (itms[z].getAttribute("mod") || itms[z].getAttribute("sub")) {
			items.push(itms[z]);
		}
	}

	var ln = items.length;
	for (var z=0; z<ln; z++) {
		var lnk = items[z].getAttribute("sub");
		var ico = items[z].getAttribute("ico");

		items[z].firstChild.style.cursor = "pointer";
		items[z].firstChild.lastChild.style.borderBottom = "1px solid #DDD";
		if (ico) {
			items[z].firstChild.firstChild.style.backgroundImage = "url("+ico+")";
		}
		
		items[z].firstChild.onclick = function() {
			if (this.parentNode.getAttribute("sub")) {
				if (this.nextSibling && !App.Nav.isFeedsUpdated) {
					if (this.nextSibling.style.display=="none") {
						this.nextSibling.style.display = "block";
						this.firstChild.className = "hideSub";
						App.FeedReader.resize();
					} else {
						this.nextSibling.style.display = "none";
						this.firstChild.className = "showSub";
						App.FeedReader.resize();
					}
				} else {
					App.Nav.isFeedsUpdated = false;
					var span = document.createElement("span");
					span.className = "navLoading";
					span.innerHTML = App.Loc.loading;
					if (this.parentNode.childNodes.length==2) this.parentNode.lastChild.removeNode(true);
					this.parentNode.appendChild(span);
					
					switch(this.parentNode.getAttribute("sub")) {
						case "0":
							var id = User.feedsId;
							break;
						case "1":
							var id = App.Nav.featuredFeedsId;
							break;
						case "2":
							var id = App.Nav.defaultFeedsId;
							break;
					}
					if (id != null) {
						Request.sendGET("getUserFeed.php?id="+id+"&nocache="+Math.random(), displaySubCat, this);
					} else {
						span.innerHTML = "&nbsp;&nbsp;"+App.Loc.navNoFeeds;
						this.parentNode.appendChild(span);
					}
				}
			} else {
				App.Nav.drawModuleBox(this);

				var pickupZone = document.getElementById("pickupZone");
				pickupZone.style.paddingTop = "2px";

				var div = document.createElement("div");
				
				var modName = this.parentNode.getAttribute("mod");
				if (modName && modName=="RssReader") {
					div.innerHTML = '<div style="float:right; cursor:pointer"><img src="./img/closeMod.gif"/></div>'+
									'<div style="padding:10px">'+
									'<div class="formLabelUp">'+App.Loc.enterFeedURL+' :</div>'+
									'<table cellpadding="0" cellspacing="0"><tr>'+
									'<td><input type="text" class="inputClean" value="" style="width:180px"/></td>'+
									'<td><input type="submit" value="'+App.Loc.add+'" class="buttonClean"/></td>'+
									'</tr>'+
									'</table>'+
									'<div id="addNewFeedCheckMsg" style="color:#900;margin:5px 0 5px 0"></div>'+
									'<div style="height:5px"></div>'+
									'<div class="formLabelUp">'+App.Loc.orImportOPML+' :</div>'+
									'<form method="post" enctype="multipart/form-data" action="uploadOPML.php" target="target_upload">'+
										'<table cellpadding="0" cellspacing="0"><tr>'+
										'<td><input type="file" name="userfile" class="inputFileClean"/></td>'+
										'<td><input type="submit" value="'+App.Loc.importLabel+'" class="buttonClean"/></td>'+
										'</tr>'+
										'</table>'+
										'<input type="hidden" name="MAX_FILE_SIZE" value="500000" />'+
										'<input type="hidden" name="userFeedsId" value="'+User.feedsId+'" />'+
									'</form>'+
									'<iframe name="target_upload" src="" style="width:1px;height:1px;border:0;visibility:hidden;float:right"></iframe>'+
									'</div><div style="margin-top:5px"></div>';
					div.firstChild.onclick = function() {
						App.Nav.removeModuleBox();
					}
					var inputs = div.getElementsByTagName("input");
					var form = div.getElementsByTagName("form")[0];
					form.onsubmit = function() {
						if (inputs[2].value != '') {
							div.lastChild.innerHTML = '<div style="padding:0 0 10px 10px">'+App.Loc.importing+'...</div>';
							return true;
						}
					}
					App.uploadDone = function(success, feedsId) {
						if (success) {
							App.Nav.isFeedsUpdated = true;
							User.feedsId = feedsId;
							setTimeout(App.Nav.openMyFeeds,1);
							App.Nav.removeModuleBox();
						} else {
							div.lastChild.innerHTML = '<div style="padding:0 0 10px 10px">'+App.Loc.errorImport+'</div>';
						}
					}
					
					function addFeedResponse(response, feedUrl, id) {
						if (response.responseText == '' || response.responseXML.documentElement==null || response.responseXML.documentElement.nodeName=="parsererror") { // si le flux n'est pas valide
							document.getElementById("addNewFeedCheckMsg").innerHTML = App.Loc.feedNotValid;
						} else {
							App.Nav.isFeedsUpdated = true;
							setTimeout(App.Nav.openMyFeeds,1);
							var defaultDataObj = App.Modules.RssReaderInfos.defaultObj;
							var dataObj = new Object();
							for (var i in defaultDataObj) dataObj[i] = defaultDataObj[i];
							dataObj.data = new Object();
							var feed = new Feed(response);
							dataObj.title = feed.title;
							dataObj.feedUrl = feedUrl;
							dataObj.data.feedId = id;
							dataObj.container = 2;
							dataObj.admin = false;
							dataObj.isNew = true;
							var mod = new Module(dataObj);
							App.moduleList.push(mod);
							App.Nav.removeModuleBox();
							App.saveUserData('new', mod);
						}
					}
					
					var inputFeed = inputs[0];
					var inputFeedSave = inputs[1];
					var self = this;
					inputFeedSave.onclick = function() {
						if (inputFeed.value.trim() != '') {
							document.getElementById("addNewFeedCheckMsg").innerHTML = App.Loc.checkFeed;
							App.addNewFeed(inputFeed.value.trim(), addFeedResponse);
						}
					}
					
					pickupZone.appendChild(div);
				} else {
					div.style.paddingBottom = "4px";
					div.innerHTML = '<div style="float:right; cursor:pointer"><img src="./img/closeMod.gif"/></div>'+
									'<div class="addToPage"><span class="addToPageLinkOut">'+App.Loc.add2MyPage+'</span></div>'+
									'<div style="clear:both"></div><div></div>';
					div.firstChild.onclick = function() {
						App.Nav.removeModuleBox();
					}
					var linkNode = div.firstChild.nextSibling.firstChild;
					linkNode.onmouseover = function() {
						this.className = "addToPageLinkOver";
					}
					linkNode.onmouseout = function() {
						this.className = "addToPageLinkOut";
					}
					linkNode.onclick = function() {
						var defaultDataObj = div.lastChild.firstChild.dataObj;
						var dataObj = new Object();
						for (var i in defaultDataObj) dataObj[i] = defaultDataObj[i];
						dataObj.data = new Object();
						for (var i in defaultDataObj.data) dataObj.data[i] = defaultDataObj.data[i];
						dataObj.container = 2;
						dataObj.admin = false;
						dataObj.isNew = true;
						var mod = new Module(dataObj);
						App.moduleList.push(mod);
						App.Nav.removeModuleBox();
						App.saveUserData('new', mod);
					}
					pickupZone.appendChild(div);
					
					var dataObj = App.Modules[this.parentNode.getAttribute("mod")+"Infos"].defaultObj;
	
					dataObj.container = div.lastChild;
					dataObj.admin = true;
					var mod = new Module(dataObj);
				}
			}
		}
		
		if (items[z].id=="myFeeds") {
			items[z].firstChild.childNodes[1].onmouseover = function() {
				App.Nav.displayExportOption(this.parentNode);
			}
		}
		
		items[z].firstChild.onmouseover = function() {
			this.lastChild.style.color = "#F60";
			this.lastChild.style.borderBottom = "1px solid #F60";
			
			if (this.parentNode.id=="myFeeds" && User.feedsId!=null) this.childNodes[1].style.display = "block";
			
			if (!App.Nav.isModuleBox && this.parentNode.getAttribute("mod")) {
				var div = document.getElementById("navInfosBox");
				div.style.display = "block";
				div.style.left = (App.Nav.width+5)+"px";
				div.style.top = (findPosY(this)-8)+"px";
		
				var frame = document.createElement("div");
				frame.className = "frame";
		
				var frame2 = document.createElement("div");
				frame2.className = "frame2";
				frame2.style.backgroundColor = "#F1FDF3";
				
				frame2.innerHTML = App.Modules[this.parentNode.getAttribute("mod")+"Infos"].infos;
		
				frame.appendChild(frame2);
				div.appendChild(frame);
			}
		}
		items[z].firstChild.onmouseout = function() {
			this.lastChild.style.color = "#333";
			this.lastChild.style.borderBottom = "1px solid #DDD";
			
			if (this.parentNode.id=="myFeeds") this.childNodes[1].style.display = "none";
			App.Nav.removeInfosBox();
		}	

	}
	
	selectionFrame.appendChild(frame2);

	var div = document.getElementById("nav");
	var tree = document.getElementById("selectionTree");
	tree.style.width = App.Nav.width+"px";

	moduleSelection.appendChild(selectionFrame);
	div.appendChild(moduleSelection);
	
	if (User.feedsId != null) {
		document.getElementById("myFeeds").firstChild.onclick();
	} else {
		document.getElementById("featuredFeeds").firstChild.onclick();
	}

	function getFaviconUrl(url) {
		var lastIndex = url.lastIndexOf("/");
		if (lastIndex!=(url.length-1) && lastIndex!=6) {
			return url.substring(0, lastIndex);
		} else {
			if (lastIndex==(url.length-1)) {
				return url.substring(0, url.length-1);
			} else {
				return url;
			}
		}
	}

	function displaySubCat(response, node) {
		var items = response.responseXML.getElementsByTagName("feed");
		var ln = items.length;
		var divUL = document.createElement("div");
		divUL.className = "ulLike";
		
		function isMyFeeds(node) {
			while(node!=null) {
				if (node.id=="myFeeds") {
					return true
				} else {
					node = node.parentNode;
				}
			}
			return false;
		}
		
		for (var z=0; z<ln; z++) {
			var lnk = items[z].getAttribute("sub");
			var divLI = document.createElement("div");
			divLI.className = "liLike";
			var div2 = document.createElement("div");
			div2.className = "itemLine";
			div2.setAttribute("xmlUrl", items[z].getAttribute("xmlUrl"));
			if (lnk==0) {
				div2.setAttribute("feedId", items[z].getAttribute("feedId"));
			}
			div2.setAttribute("id", items[z].getAttribute("id"));
			div2.setAttribute("sub", lnk);
			
			if (lnk==1) {
				divLI.setAttribute("sub", lnk);
				div2.innerHTML = '<div class="showSub"></div><img class="edit" src="./img/showModBlue.gif"/><div class="text"></div>';
				div2.lastChild.appendChild(document.createTextNode(items[z].getAttribute("title")));
			} else {
				var favicon = getFaviconUrl(items[z].getAttribute("htmlUrl"));
				div2.innerHTML = '<div class="folderIcon"><img src="'+favicon+'/favicon.ico" height="0" width="0" /></div><img class="edit" src="./img/showModBlue.gif"/><div class="text"></div>';
				div2.lastChild.appendChild(document.createTextNode(items[z].getAttribute("title")));
				div2.firstChild.firstChild.onload = function() {
					this.style.width = "16px";
					this.style.height = "16px";
					this.parentNode.style.backgroundImage = "none";
				}
			}
			
			divLI.appendChild(div2);
			
			var isMy = isMyFeeds(node);
			
			if (isMy) {
				div2.childNodes[1].onmouseover = function() {
					if (App.Nav.itemOnOptions) { // fix some over/out miss with firefox
						App.Nav.itemOnOptions.childNodes[1].style.display = "none";
						App.Nav.itemOnOptions.lastChild.style.color = "#333";
						App.Nav.itemOnOptions.lastChild.style.borderBottom = "1px solid #DDD";
					}
					if (!App.Nav.isModuleBox && App.Nav.itemOnOptions!=this) App.Nav.displayFeedOptions(this.parentNode);
					App.Nav.itemOnOptions = this.parentNode;
				}
			}
			
			div2.style.cursor = "pointer";
			div2.lastChild.style.borderBottom = "1px solid #DDD";
			div2.onmouseover = function() {
				if (App.Nav.itemOnOptions && isMy) { // fix some over/out miss with firefox
					App.Nav.itemOnOptions.childNodes[1].style.display = "none";
					App.Nav.itemOnOptions.lastChild.style.color = "#333";
					App.Nav.itemOnOptions.lastChild.style.borderBottom = "1px solid #DDD";
				}
				this.lastChild.style.color = "#F60";
				this.lastChild.style.borderBottom = "1px solid #F60";
				if (isMy) {
					this.childNodes[1].style.display = "block";
					if (App.Nav.itemOnOptions != this && !App.Nav.isModuleBox) {
						document.getElementById("navModuleBox").style.display = "none";
					}
				}
			}
			div2.onmouseout = function() {
				this.lastChild.style.color = "#333";
				this.lastChild.style.borderBottom = "1px solid #DDD";
				if (isMyFeeds) this.childNodes[1].style.display = "none";
			}
			
			div2.onclick = function() {
				if (this.getAttribute("sub")==1) {
					if (this.nextSibling) {
						if (this.nextSibling.style.display=="none") {
							this.nextSibling.style.display = "block";
							this.firstChild.className = "hideSub";
							App.FeedReader.resize();
						} else {
							this.nextSibling.style.display = "none";
							this.firstChild.className = "showSub";
							App.FeedReader.resize();
						}
					} else {
						var span = document.createElement("span");
						span.className = "navLoading";
						span.innerHTML = App.Loc.loading;
						this.parentNode.appendChild(span);
						Request.sendGET("getUserFeed.php?id="+this.getAttribute("id")+"&nocache="+Math.random(), displaySubCat, this);
					}
				} else {
					App.Nav.drawModuleBox(this);
					var pickupZone = document.getElementById("pickupZone");
					pickupZone.style.paddingTop = "2px";

					var div = document.createElement("div");
					div.style.paddingBottom = "4px";
					div.innerHTML = '<div style="float:right; cursor:pointer"><img src="./img/closeMod.gif"/></div>'+
									'<div class="addToPage"><span class="addToPageLinkOut">'+App.Loc.add2MyPage+'</span></div>'+
									'<div style="clear:both"></div><div></div>';
					div.firstChild.onclick = function() {
						App.Nav.removeModuleBox();
					}
					var linkNode = div.firstChild.nextSibling.firstChild;
					
					if (App.mode=='userPage') {
						linkNode.onmouseover = function() {
							this.className = "addToPageLinkOver";
						}
						linkNode.onmouseout = function() {
							this.className = "addToPageLinkOut";
						}
						linkNode.onclick = function() {
							delete div.lastChild.firstChild.dataObj.currentServerRequest;
							var defaultDataObj = div.lastChild.firstChild.dataObj;
							var dataObj = new Object();
							for (var i in defaultDataObj) dataObj[i] = defaultDataObj[i];
							dataObj.data = new Object();
							//for (var i in defaultDataObj.data) dataObj.data[i] = defaultDataObj.data[i];
							dataObj.title = div.lastChild.firstChild.dataObj.title;
							dataObj.data.feedId = div.lastChild.firstChild.dataObj.data.feedId;
							dataObj.feedUrl = div.lastChild.firstChild.dataObj.feedUrl;
							dataObj.container = 2;
							dataObj.admin = false;
							dataObj.isNew = true;
							var mod = new Module(dataObj);
							App.moduleList.push(mod);
							App.Nav.removeModuleBox();
							App.saveUserData('new', mod);
						}
					} else {
						linkNode.removeNode(true);
					}
					
					pickupZone.appendChild(div);

					var dataObj = App.Modules.RssReaderInfos.defaultObj;
					dataObj.container = div.lastChild;
					dataObj.title = this.lastChild.firstChild.nodeValue;
					dataObj.feedUrl = this.getAttribute("xmlUrl");
					dataObj.data.feedId = this.getAttribute("feedId");
					dataObj.data.nbTitles = null;
					dataObj.admin = true;
					var mod = new Module(dataObj);
				}
			}
			
			divUL.appendChild(divLI);
		}

		node.parentNode.lastChild.removeNode(true);
		node.parentNode.appendChild(divUL);
		node.firstChild.className = "hideSub";
		
		App.FeedReader.resize();
	}
}


 // ============== FEED READER ==================================================================

App.FeedReader = new Object();

App.FeedReader.headlinesTD = 250;

App.FeedReader.resize = function() {
	if (document.getElementById("feedReaderContentFrame") != null) {
		var w = document.body.clientWidth-10-9-20- ((App.Nav.isOpen) ? App.Nav.width-10 : 0);
		App.FeedReader.elm.style.width = w+"px";
		App.FeedReader.elm.style.left = findPosX(document.getElementById("columns"))+"px";
		var contentSize = w-App.FeedReader.headlinesTD-28;
		var contentFrame = document.getElementById("feedReaderContentFrame");
		contentFrame.style.width = contentSize+"px";
		var h = (Browser.isOpera) ? document.body.clientHeight : document.documentElement.clientHeight;
		//var cssh = (h-App.FeedReader.posY-90)+20+"px";
		var cssh = (h-155)+"px";
		contentFrame.style.height = cssh;
		document.getElementById("feedReaderHeadlinesFrame").style.height = cssh;
	}
}
App.FeedReader.close = function() {
	var div = App.FeedReader.elm;
	div.innerHTML = "";
	div.style.display = "none";
	//document.documentElement.style.overflow = "";
	//document.body.style.overflow = ""; // opera
}

App.FeedReader.display = function(data){ //{title, moduleLocalData, moduleData, selectedItemIndex}

	var ownerURL = data.moduleLocalData.feed.htmlUrl;
	
	//scrollTo(0, 0);
	//document.documentElement.style.overflow = "hidden";
	//document.body.style.overflow = "hidden"; // opera

	var index = ownerURL.lastIndexOf("/");
	if (index!=6) ownerURL = ownerURL.substring(0, index);

	var feedSiteURLDomain = ownerURL.substring(0,ownerURL.indexOf("/", 7));
	if (!feedSiteURLDomain) feedSiteURLDomain = ownerURL;

	var div = App.FeedReader.elm;

	var readerFrame = document.createElement("div");
	readerFrame.id = "feedReaderFrame";

	var colFrame = document.getElementById("columns");
	App.FeedReader.posY = findPosY(colFrame)+5+document.documentElement.scrollTop;
	div.style.top = App.FeedReader.posY+"px";
	//alert(document.documentElement.scrollTop);

	div.style.display = "block";

	var frame = document.createElement("div");
	frame.className = "frame";

	var header = document.createElement("div");
	header.className = "header";
	header.innerHTML = '<img style="float:right;padding-right:2px" src="./img/closeMod.gif"/><div class="readAll"><div><div>'+App.Loc.readAll+'</div></div></div><div style="text-align:center;padding-top:2px"><a style="text-transform:uppercase" href="'+ownerURL+'" target="_blank">'+data.title+'</a></div>';
	
	var readAllDiv = header.firstChild.nextSibling.firstChild.firstChild;
	readAllDiv.onmouseover = function() {
		this.style.color = "#F60";
	}
	readAllDiv.onmouseout = function() {
		this.style.color = "#3169B5";
	}
	readAllDiv.onclick = function() {
		headlineSelectAll();
	}
	
	header.firstChild.style.cursor = "pointer";
	header.firstChild.onclick = function() {
		window.onresize = null;
		App.FeedReader.close();
	}

	var contentFrame = document.createElement("div");
	contentFrame.id = "feedReaderFrame2";

	contentFrame.innerHTML = '<table id="readerTable" cellpadding="0" cellspacing="0" width="100%"><tr><td></td><td></td><td></td></tr></table>';
	//contentFrame.innerHTML = '<div><div></div><div></div><div></div></div>';
	var tr = contentFrame.firstChild.firstChild.firstChild;
	//var tr = contentFrame.firstChild;
	var tdHeadlines = tr.childNodes[0];
	tdHeadlines.className = "tdHeadlines";
	tdHeadlines.style.width = App.FeedReader.headlinesTD+"px";
	var tdSeparator = tr.childNodes[1];
	tdSeparator.className = "tdSeparator";
	tdSeparator.onmouseover = function() {
		this.style.backgroundColor = "#D4E4FF";
	}
	tdSeparator.onmouseout = function() {
		this.style.backgroundColor = "transparent";
	}
	var tdContent = tr.childNodes[2];
	tdContent.className = "tdContent";
	tdContent.innerHTML = '<div id="feedReaderContentFrame"><div class="contentInsideFrame"></div></div>';


	function applyPodcastEvents(node, file, name) {
		var listenNode = node.firstChild.firstChild.firstChild.firstChild;
		var downloadNode = node.lastChild.firstChild.firstChild.firstChild;
		listenNode.onmouseover = downloadNode.onmouseover = function() {
			this.style.color = "#F60";
		}
		listenNode.onmouseout = downloadNode.onmouseout = function() {
			this.style.color = "#333";
		}
		listenNode.onclick = function() {
			var podName = name;
			
			if (!document.getElementById("podPlayer")) {
				content = '<div>'+
						'<object id="podPlayer" type="application/x-shockwave-flash" data="player/player.swf?pod='+encodeURIComponent(file)+'&podname='+encodeURIComponent(podName)+'" width="238" height="17">'+
						'<param name="movie" value="player/player.swf?pod='+encodeURIComponent(file)+'&podname='+encodeURIComponent(podName)+'" />'+
						//'<param name="bgcolor" value="#EFEFEF" />'+
						'<param name="wmode" value="transparent" />'+
						'</object>'+
						'<img style="padding:0 0 4px 6px"src="./img/closeBlue.gif"/>'+
						'</div>';
				var div = document.getElementById("player");
				div.innerHTML = content;
				div.style.display = "block";
				var imgClose = div.getElementsByTagName("img")[0];
				imgClose.style.cursor = "pointer";
				imgClose.onclick = function() {
					div.innerHTML = "";
					div.style.display = "none";
				}
			} else {
				var podPlayer = document.getElementById("podPlayer");
				podPlayer.SetVariable("/fileChange:pod", encodeURIComponent(file));
				podPlayer.SetVariable("/fileChange:podname", podName);
				podPlayer.TPlay("/fileChange");
			}
		}
		
	}

	function cleanContent(node, nodeTitle, itemNode) {

		function fixAttribute(item, a) {
			var attr = item.getAttribute(a);
			if (attr==null) return;
			if (attr.indexOf("http")==-1) {
				if (attr.substring(0,1)=="/") {
					item.setAttribute(a, feedSiteURLDomain+attr);
				} else {
					if (ownerURL.substring(0,1)=="/") {
						item.setAttribute(a, ownerURL+attr);
					} else {
						item.setAttribute(a, ownerURL+"/"+attr);
					}
				}
			} else {
				if (attr.indexOf(App.location)!=-1) {
					if (feedSiteURLDomain != App.location) {
						
						var locationHref = window.location.href.substring(0,window.location.href.lastIndexOf("/")+1);
						if (attr.indexOf(locationHref)!=-1 && attr!=(App.location+"/")) {
							var newAttr = feedSiteURLDomain + "/" + attr.substring(locationHref.length, attr.length);
							item.setAttribute(a, newAttr);
						} else if (attr.indexOf(App.location)!=-1 && attr!=(App.location+"/")) {
							var newAttr = feedSiteURLDomain + attr.substring(App.location.length, attr.length);
							item.setAttribute(a, newAttr);
						}
						
					}
				}
			}
		}

		// set sizes to images + update the urls
		var imgs = node.getElementsByTagName("img");
		var ln = imgs.length;
		for (var z=0; z<ln; z++) {
			imgs[z].onload = function() {
				this.style.width = this.currentStyle.width;
				this.style.height = this.currentStyle.height;
			}
			fixAttribute(imgs[z], "src");			
		}

		// remove the scripts
		var scripts = node.getElementsByTagName("script");
		var ln = scripts.length;
		for (var z=0; z<ln; z++) {
			scripts[z].removeNode(true);
		}
		
		// let's remove some ads + update the links
		var links = node.getElementsByTagName("a");
		var ln = links.length;
		for (var z=0; z<ln; z++) {
			/*if (links[z].getAttribute("href").indexOf("googleadservices")!=-1) {
				links[z].style.display = "none";
			} else if (links[z].getAttribute("href").indexOf("ads_by_google")!=-1) {
				links[z].style.display = "none";
			} else if (links[z].getAttribute("href").indexOf("feeds.gawker.com")!=-1) {
				links[z].style.display = "none";
			} else {*/
				var first = links[z].firstChild;
				if (first) {
					if (first.nodeType==1) {
						if (first.nodeName=="IMG" || first.nodeName=="img") {
							links[z].className = "noBottomLine";
						}
					}
				}
				fixAttribute(links[z], "href");
				links[z].setAttribute("target", "_blank");
			//}
		}
		
		var enclosures = itemNode.getElementsByTagName("enclosure");
		var ln = enclosures.length;
		for (var z=0; z<ln; z++) {
			var typ = enclosures[z].getAttribute("type");
			if (typ=="audio/mpeg" || typ=="" || typ=="enclosureType") {
				var file = enclosures[z].getAttribute("url");
				if (file.indexOf(".mp3")!=-1) {
					var div = document.createElement("div");
					div.className = "podcast";
					div.innerHTML = '<table cellpadding="0" cellspacing="0" style="float:left;margin-right:6px"><div class="listen"><div><div>'+App.Loc.listenPod+'</div></div></div></table>'+
									'<table cellpadding="0" cellspacing="0"><a href="'+file+'"><div class="download"><div><div>'+App.Loc.downloadPod+'</div></div></div></a></table>';
					applyPodcastEvents(div, file, nodeTitle.lastChild.firstChild.nodeValue);
					if (node.firstChild) {
						node.insertBefore(div, node.firstChild);
					} else {
						node.appendChild(div);
					}
				}
			}
		}

	}
	
	function displayContent(index) {
		var itemNode = data.moduleLocalData.feed.items[index];
		var contentValue = '';
		
		var content = itemNode.content;
		var desc = itemNode.description;
		
		// find a way to fix content with IE and feeds like "http://googleblog.blogspot.com/atom.xml" that doesn't have all the content encoded
		
		if (content && content.hasChildNodes()) {
			for (var n=content.firstChild; n!=null; n=n.nextSibling) {
				if (n.innerHTML) {
					contentValue += n.innerHTML;
				} else if (n.nodeValue) {
					contentValue += n.nodeValue;
				}
			}
		} else if (desc && desc.hasChildNodes()) {
			for (var n=desc.firstChild; n!=null; n=n.nextSibling) {
				if (n.innerHTML) {
					contentValue += n.innerHTML;
				} else if (n.nodeValue) {
					contentValue += n.nodeValue;
				}				
			}
		}
		
		var titleDiv = document.createElement("div");
		titleDiv.className = "title";
		titleDiv.innerHTML = '<div class="moreLink"><a href="'+itemNode.link+'" target="_blank">'+App.Loc.link+' ?</a></div><a href="'+itemNode.link+'" target="_blank">'+itemNode.title+'</a>';
		
		var contentDiv = document.createElement("div");
		contentDiv.className = "feedContent";
		contentDiv.innerHTML = contentValue;
		//contentDiv.appendChild(contentValue);
		
		cleanContent(contentDiv, titleDiv, itemNode.node);
		tdContent.firstChild.firstChild.appendChild(titleDiv);
		tdContent.firstChild.firstChild.appendChild(contentDiv);
	}

	function headlineSelect(index) {
		var ln = headlinesBorderShape.childNodes.length;
		for (var z=0; z<ln; z++) {
			headlinesBorderShape.childNodes[z].setAttribute("selected", 0);
			headlinesBorderShape.childNodes[z].style.backgroundColor = "transparent";
		}
		tdContent.firstChild.firstChild.innerHTML = "";
		displayContent(index);
		tdContent.firstChild.scrollTop = 0;
		headlinesBorderShape.childNodes[index].setAttribute("selected", 1);
		headlinesBorderShape.childNodes[index].style.backgroundColor = "#D8FED2";
	}
	
	function headlineSelectAll(index) {
		var ln = headlinesBorderShape.childNodes.length;
		tdContent.firstChild.firstChild.innerHTML = "";
		for (var z=0; z<ln; z++) {
			headlinesBorderShape.childNodes[z].setAttribute("selected", 1);
			headlinesBorderShape.childNodes[z].style.backgroundColor = "#D8FED2";
			displayContent(z);
			var divSep = document.createElement("div");
			divSep.className = "postSeparator";
			if (z==(ln-1)) divSep.style.borderBottom = "1px solid #FFF";
			tdContent.firstChild.firstChild.appendChild(divSep);
		}
		tdContent.firstChild.scrollTop = 0;
	}

	var headlinesBorderShape = document.createElement("div");
	headlinesBorderShape.id = "feedReaderHeadlinesFrame";
	
	var ln = data.moduleLocalData.feed.items.length;
	for (var z=0; z<ln; z++) {
		var itemNode = data.moduleLocalData.feed.items[z];
		
		var headlineDiv = document.createElement("div");
		headlineDiv.setAttribute("itemIndex", z);
		//headlineDiv.setAttribute("selected", 0);
		headlineDiv.className = "headline";
		
		headlineDiv.onmouseover = function() {
			this.style.backgroundColor = (this.getAttribute("selected")==0) ? "#EFF5FF" : "#CDF1C7";
		}
		headlineDiv.onmouseout = function() {
			this.style.backgroundColor = (this.getAttribute("selected")==0) ? "transparent" : "#D8FED2";
		}
		headlineDiv.onclick = function() {
			headlineSelect(this.getAttribute("itemIndex"));
		}
		headlineDiv.innerHTML = itemNode.title;
		headlinesBorderShape.appendChild(headlineDiv);
	}
	
	headlineSelect(data.selectedItemIndex);
	
	tdHeadlines.appendChild(headlinesBorderShape);
	
	frame.appendChild(header);
	frame.appendChild(contentFrame);	
	readerFrame.appendChild(frame);

	div.innerHTML = "";
	div.appendChild(readerFrame);
	App.FeedReader.resize();

	setTimeout(App.FeedReader.resize, 1);
	setTimeout(App.FeedReader.resize, 100);

	window.onresize = function() {
		App.FeedReader.resize();
	}

}

// ========== REQUEST ====================================================================================================

var Request = new Object();

Request.send = function(url, method, callback, data) {
	var req;	
	if (window.XMLHttpRequest) {
		req = new XMLHttpRequest();
	} else if (window.ActiveXObject) {
		req = new ActiveXObject("Microsoft.XMLHTTP");
	}
	req.onreadystatechange = function() {
		if (req.readyState == 4) {// only if req shows "loaded"
			if (req.status < 400) {// only if "OK"
				(method=="POST") ? callback(req) : callback(req,data);
			} else {
				alert("There was a problem loading data :\n" + req.status+ "/" + req.statusText + "\n" + url);
			}
		}
	}
	if (method=="POST") {
		req.open("POST", url, true);
		req.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
		//req.setRequestHeader('Connection','close'); //STUPID 400 FF ERROR FIX
		req.send(data);
	} else {
		req.open("GET", url, true);
		req.send(null);
	}
	
	return req;
}

Request.sendPOST = function(url, data, callback) {
	Request.send(url, "POST", callback, data);
}
Request.sendGET = function(url, callback, args) {
	return Request.send(url, "GET", callback, args);
}

// ================ SERVER  SAVE ================================================================

App.moduleObjWaitingForId = [];

App.doResponseAction = function(mode, success, args) {

	function setModuleId(tempId, newId) {
		var ln = App.moduleObjWaitingForId.length;
		for (var z=0; z<ln; z++) {
			if (App.moduleObjWaitingForId[z].tempId==tempId) {
				var mod = App.moduleObjWaitingForId[z];
				mod.dataObj.id = newId;
				App.moduleObjWaitingForId.splice(z, 1);
				break;
			}
		}
		App.saveUserData('order');
		mod.loadContent(); // ici ou attendre le retour de l'enregistrement du nouveau layout ?
	}

	if (success) {
		switch(mode) {
			case 'module':
				break;
			case 'order':
				break;
			case 'collapseExpand':
				break;
			case 'close':
				break;
			case 'new':
				setModuleId(args.tempId, args.newId);
				break;
			case 'pageTitle':
				break;
		}
	} else {
		alert(App.Loc.errorSavingUserData);
	}
}

App.saveUserDataResponse = function(response) {
	//alert(response.responseText);
	eval('App.doResponseAction('+response.responseText+')');
	App.savingStatusElm.style.backgroundColor = "transparent";
}

App.saveUserData = function(mode, obj) {
	if (App.mode=='userPage') App.saveUserDataNow(mode, obj);
}

App.saveUserDataNow = function(mode, obj) {
	App.savingStatusElm.style.backgroundColor = "#F00";
	
	function getOrder() {
		var arr = [];
		for (var z=1; z<=3; z++) {
			var col = App.columnsObj["col"+z];
			var ln = col.childNodes.length;	
			var arr2 = [];
			for (var i=0; i<ln; i++) {
				var obj = col.childNodes[i].dataObj;
				if (obj.id!=null) arr2.push(obj.id);
			}
			arr.push(arr2.join(','));
		}
		return arr.join(":");
	}

	var data = '';
	switch(mode) {
		case 'module':
			var dataObjStr = '';
			for (var n in obj.data) {
				var value = obj.data[n];
				if (typeof(value)=="string") value = Utils.htmlEncode(value);
				dataObjStr += '&arrData['+n+']='+encodeURIComponent(value);
			}			
			data = 'id='+obj.id+'&title='+encodeURIComponent(Utils.htmlEncode(obj.title))+'&status='+obj.status+'&share='+obj.share+dataObjStr;
			break;
		case 'order':
			data = 'order='+getOrder();
			break;
		case 'collapseExpand' :
			data = 'status='+obj;
			break;
		case 'close':
			data = 'order='+getOrder()+'&id='+obj.id;
			break;
		case 'new':
			var dataObj = obj.dataObj;
			var dataObjStr = '';
			for (var n in dataObj.data) {
				var value = dataObj.data[n];
				if (typeof(value)=="string") value = Utils.htmlEncode(value);
				dataObjStr += '&arrData['+n+']='+encodeURIComponent(value);
			}
			var title = (dataObj.title==null) ? '' : encodeURIComponent(Utils.htmlEncode(dataObj.title));
			var moduleRndId = Math.random()*100000;
			data = 'moduleRndId='+moduleRndId+'&title='+title+'&status='+dataObj.status+'&name='+dataObj.moduleName+'&share='+dataObj.share+dataObjStr;
			obj.tempId = moduleRndId;
			App.moduleObjWaitingForId.push(obj);
			break;
		case 'pageTitle':
			data = 'title='+encodeURIComponent(obj);
			break;
	}
	Request.sendPOST('saveUserData.asp', 'mode='+mode+'&'+data, App.saveUserDataResponse);
}

// ========================================================================================

function findPosX(obj) {
	var curleft = 0;
	if (obj.offsetParent) {
		while (obj.offsetParent) {
			curleft += obj.offsetLeft;
			obj = obj.offsetParent;
		}
	} else if (obj.x) curleft += obj.x;
	return curleft;
}

function findPosY(obj) {
	var curtop = 0;
	if (obj.offsetParent) {
		while (obj.offsetParent) {
			curtop += obj.offsetTop;
			obj = obj.offsetParent;
		}
	} else if (obj.y) curtop += obj.y;
	return curtop;
}


var moduleGhost = document.createElement("div");
moduleGhost.id = "moduleGhost";

App.hide = function() {
	document.getElementById("application").style.display = "none";
}
App.show = function() {
	document.getElementById("siteInformation").style.display = "none";
	document.getElementById("application").style.display = "block";
}

App.displaySiteInformation = function(page, node) {
	function display(response, container) {
		container.lastChild.innerHTML = response.responseText;
		node.onLoadHTML(container.lastChild);
	}	
	var infosBox = document.getElementById("siteInformation");
	infosBox.style.display = "block";
	infosBox.innerHTML = '<div style="margin-bottom:20px;text-align:center"><a id="backToPage" href="javascript:App.show()">? '+App.Loc.backToMyPage+'</a></div>'+
						'<div id="siteInformationFrame">'+App.Loc.loading+'</div>';
	Request.sendGET(page, display, infosBox);
	if (Browser.isMozilla) {
		setTimeout(App.hide, 1);
	} else {
		App.hide();
	}
	App.setBackButton();
}


App.setSignOutLink = function() {	
	var signInOutLink = document.getElementById("signInOutLink");
	signInOutLink.style.background = "url(./img/signout.gif) no-repeat 0 0";
	signInOutLink.innerHTML = App.Loc.footerLink_signOut;
	signInOutLink.onclick = function() {
		function signOutResponse() {
			window.location.reload(true);
		}
		Request.sendGET('userSignOut.php', signOutResponse);
	}
}

App.Start = function() {

	document.getElementById("addContentLink").innerHTML = (App.mode=='userPage') ? App.Loc.addContent : App.Loc.moreContent;
	/*if (App.mode=='userPage') {
		document.getElementById("appOptionsLink").innerHTML = App.Loc.appOptions;
	} else {
		document.getElementById("appOptionsLink").parentNode.style.display = 'none';
	}*/
	
	document.getElementById("collapseAllLink").innerHTML = App.Loc.collapseAll;
	document.getElementById("expandAllLink").innerHTML = App.Loc.expandAll;
	
	var footerLink_about = document.getElementById("footerLink_about");
	footerLink_about.innerHTML = App.Loc.footerLink_about;
	footerLink_about.onclick = function() {
		if (App.lang=='fr') {
			App.displaySiteInformation('loc/'+App.lang+'_'+this.getAttribute("page"), this);
		} else {
			App.displaySiteInformation('loc/en_'+this.getAttribute("page"), this);
		}
	}
	
	document.getElementById("footerLink_blog").innerHTML = App.Loc.footerLink_blog;
	document.getElementById("footerLink_feedback").innerHTML = App.Loc.footerLink_feedback;
	
	var footerLink_privacy = document.getElementById("footerLink_privacy");
	footerLink_privacy.innerHTML = App.Loc.footerLink_privacy;
	footerLink_privacy.onclick = function() {
		App.displaySiteInformation('loc/en_'+this.getAttribute("page"), this);
	}
	
	var footerLink_tos = document.getElementById("footerLink_tos");
	footerLink_tos.innerHTML = App.Loc.footerLink_tos;
	footerLink_tos.onclick = function() {
		App.displaySiteInformation('loc/en_'+this.getAttribute("page"), this);
	}
	
	var footerLink_contact = document.getElementById("footerLink_contact");
	footerLink_contact.innerHTML = App.Loc.footerLink_contact;
	footerLink_contact.onclick = function() {
		if (App.lang=='fr') {
			App.displaySiteInformation('loc/'+App.lang+'_'+this.getAttribute("page"), this);
		} else {
			App.displaySiteInformation('loc/en_'+this.getAttribute("page"), this);
		}
	}
	
	/*var footerLink_webmaster = document.getElementById("footerLink_webmaster");
	footerLink_webmaster.innerHTML = App.Loc.footerLink_webmaster;
	footerLink_webmaster.onclick = function() {
		if (App.lang=='fr') {
			App.displaySiteInformation('loc/'+App.lang+'_'+this.getAttribute("page"), this);
		} else {
			App.displaySiteInformation('loc/en_'+this.getAttribute("page"), this);
		}
	}*/
	
	if (App.registeredUser) {
		App.setSignOutLink();
	} else {
		var signInOutLink = document.getElementById("signInOutLink");
		signInOutLink.innerHTML = App.Loc.footerLink_signIn;
		signInOutLink.onLoadHTML = function(node) {
			App.applySignInEvents(node);
		}
		signInOutLink.onclick = function() {
			App.displaySiteInformation('loc/'+App.lang+'_'+this.getAttribute("page"), this);
		}
	}
	
	App.savingStatusElm = document.getElementById("savingStatus");

	function doPageTitleEvent() {
		var div = document.getElementById("pageTitle");
		div.firstChild.onmouseover = function() {
			this.style.backgroundColor = "#FAFAFA";
			this.style.border = "1px solid #EEE";
		}
		div.firstChild.onmouseout = function() {
			this.style.backgroundColor = "transparent";
			this.style.border = "none";
		}
		div.firstChild.onclick = function() {
			this.onclick = null;
			this.onmouseout();
			this.onmouseover = null;
			var titleValue = this.firstChild.nodeValue;
			var titleWidth = this.offsetWidth;
			this.innerHTML = '<input type="text" class="inputPageTitle" maxlength="80" value="'+titleValue+'" style="width:'+titleWidth+'px"/>';
			var inputElm = this.firstChild;
			inputElm.focus();
			inputElm.select();
			inputElm.attachEvent('onkeydown',onEnterDown);
			function onEnterDown() {
				if (window.event.keyCode==13) {
					inputElm.onblur();
				}
			}
			inputElm.onkeyup = function() {
				this.style.width = (this.value.length*8)+20 + "px";
			}
			inputElm.onblur = function() {
				var value = (this.value=='') ? 'MyWeb' : Utils.htmlEncode(this.value);
				this.parentNode.innerHTML = value;
				if (this.value != titleValue) {
					App.saveUserData('pageTitle', value);					
					document.title = value;
				}
				doPageTitleEvent();
			}
		}
	}
	
	if (App.mode=='userPage') doPageTitleEvent();

	var container = document.getElementById("modulesArea");
	var columns = document.createElement("div");
	App.columnsObj = {};
	columns.id = "columns";
	App.numCol = 3;

	var div1 = document.createElement("div");
	div1.style.width = Math.round(100/App.numCol) + "%";
	div1.style.minHeight = "1px";
	div1.className = "divColonne";
	div1.setAttribute("colNum", 1);
	App.columnsObj.col1 = div1;

	var div2 = document.createElement("div");
	div2.style.width = Math.round(100/App.numCol) + "%";
	div2.style.minHeight = "1px";
	div2.className = "divColonne";
	div2.setAttribute("colNum", 2);
	App.columnsObj.col2 = div2;

	var div3 = document.createElement("div");
	div3.style.width = Math.round(100/App.numCol) + "%";
	div3.style.minHeight = "1px";
	div3.className = "divColonne";
	div3.setAttribute("colNum", 3);
	App.columnsObj.col3 = div3;

	columns.appendChild(div1);
	columns.appendChild(div2);
	columns.appendChild(div3);

	var divFeedReader = document.createElement("div");
	divFeedReader.id = "feedReader";
	container.appendChild(columns);
	container.appendChild(divFeedReader);

	App.FeedReader.elm = document.getElementById("feedReader");
	
	/*function makeObject(obj) {
		return obj;
	}*/
	
	function displayModules(response) {
		var rootNode = response.responseXML.documentElement;	
		var mods = rootNode.getElementsByTagName("mod");
		
		var pageTitle = rootNode.getElementsByTagName("pageTitle")[0].firstChild;
		
		var text = document.createTextNode((pageTitle) ? pageTitle.nodeValue : App.Loc.typePageTitle);
		document.getElementById("pageTitle").firstChild.appendChild(text);		
		if (pageTitle) document.title = pageTitle.nodeValue;
		
		var feedsID = rootNode.getElementsByTagName("userFeeds")[0].firstChild;
		User.feedsId = (feedsID) ? feedsID.nodeValue : null;
		
		App.Nav.featuredFeedsId = rootNode.getElementsByTagName("featuredFeeds")[0].firstChild.nodeValue;
		App.Nav.defaultFeedsId = rootNode.getElementsByTagName("defaultFeeds")[0].firstChild.nodeValue;
		
		var ln = mods.length;
		for (var z=0; z<ln; z++) {
			var id = mods[z].getAttribute("id");
			var column = mods[z].getAttribute("column");
			var name = mods[z].getAttribute("name");
			var status = mods[z].getAttribute("status");
			var share = mods[z].getAttribute("share");			
			var title = mods[z].getElementsByTagName("title")[0];
			title = (title.firstChild) ? title.firstChild.nodeValue : '';
			var data = mods[z].getElementsByTagName("data")[0];
			ln2 = data.childNodes.length;
			var dataObj = {id:id, container:column, moduleName:name, title:title, status:status, share:share};
			var obj = new Object();
			for (var n=0; n<ln2; n++) {
				if (name=="RssReader" && data.childNodes[n].nodeName=="feedId") dataObj.feedUrl = data.childNodes[n].getAttribute("url");
				if (data.childNodes[n].firstChild) obj[data.childNodes[n].nodeName] = data.childNodes[n].firstChild.nodeValue;
			}
			dataObj.data = obj;
			App.moduleList.push(new Module(dataObj));
			//var obj = eval('makeObject('+mods[z].firstChild.firstChild.nodeValue+')');
		}		
		
		if (App.subscribeOnLoad) {
			App.subscribeOnLoad = false;
			var startMsgDiv = document.getElementById("startMsg");
			startMsgDiv.innerHTML = App.Loc.addingNewFeed+"...";
			
			/*
			function addFeedResponse(response, feedUrl, id) {
				if (response.responseText == '' || response.responseXML.documentElement==null || response.responseXML.documentElement.nodeName=="parsererror") { // si le flux n'est pas valide
					startMsgDiv.innerHTML = App.Loc.feedNotValid;
				} else {
					App.Nav.isFeedsUpdated = true;
					setTimeout(App.Nav.openMyFeeds,1);
					var defaultDataObj = App.Modules.RssReaderInfos.defaultObj;
					var dataObj = new Object();
					for (var i in defaultDataObj) dataObj[i] = defaultDataObj[i];
					dataObj.data = new Object();
					var feed = new Feed(response);
					dataObj.title = feed.title;
					dataObj.feedUrl = feedUrl;
					dataObj.data.feedId = id;
					dataObj.container = 2;
					dataObj.admin = false;
					dataObj.isNew = true;
					var mod = new Module(dataObj);
					App.moduleList.push(mod);
					App.Nav.removeModuleBox();
					App.saveUserData('new', mod);
				}
			}
			
			App.addNewFeed(inputFeed.value, addFeedResponse);*/
			
			
		} else {
			document.getElementById("startMsg").style.display = "none";
			document.getElementById("application").style.display = "block";
			document.getElementById("footer").style.display = "block";
		}
	
	}
	Request.sendGET('getUserData.php.xml', displayModules);
}


var Feed = function(feed) {	
	this.root = feed.responseXML.documentElement;
	this.type = (this.root.nodeName=="feed") ? 1 : 0;
	// htmlUrl
	var root = (this.type==1) ? this.root : this.root.getElementsByTagName("channel")[0];
	var link = Utils.getChildrenByTagName(root, "link");
	link = link[link.length-1];
	this.htmlUrl = (this.type==1) ? link.getAttribute("href") : link.firstChild.nodeValue;
	// title
	var title = this.root.getElementsByTagName("title")[0];
	this.title = (title.firstChild) ? title.firstChild.nodeValue : this.htmlUrl;
	// description
	var desc = (this.type==1) ? this.root.getElementsByTagName("tagline")[0].firstChild : this.root.getElementsByTagName("description")[0].firstChild;
	this.description = (desc) ? desc.nodeValue : '';
	
	this.items = [];
	var items = (this.type==1) ? this.root.getElementsByTagName("entry") : this.root.getElementsByTagName("item");
	var ln = items.length;		
	
	for (var z=0; z<ln; z++) {
		var obj = {};
		obj.node = items[z];
		
		var title = items[z].getElementsByTagName("title")[0];		
		if (title && title.firstChild) {
			obj.title = title.firstChild.nodeValue;
		} else {			
			if (items[z].getElementsByTagName("description")[0].firstChild) {
				obj.title = items[z].getElementsByTagName("description")[0].firstChild.nodeValue.substring(0,40)+"...";
			} else {
				obj.title = '[...]';
			}
		}		
		var link = Utils.getChildrenByTagName(items[z], "link");
		link = link[link.length-1];
		if (link) obj.link = (this.type==1) ? link.getAttribute("href") : link.firstChild.nodeValue;
		
		if (this.type==1) {
			obj.content = items[z].getElementsByTagName("content")[0];
			obj.description = items[z].getElementsByTagName("summary")[0];
		} else {
			obj.content = (Browser.isIE) ? items[z].getElementsByTagName("content:encoded")[0] : items[z].getElementsByTagName("encoded")[0];
			obj.description = items[z].getElementsByTagName("description")[0];
		}
		this.items.push(obj);
	}	
	
}
var FeedItem = function(item) {
}

App.addNewFeed = function(feedUrl, callBack) {
	if (App.mode=='userPage') App.addNewFeedNow(feedUrl, callBack);
}

App.addNewFeedNow = function(feedUrl, callBack) {
	var feedResponse;
	
	function getFeedId(response) {		
		var ids = response.responseText.split(",");
		if (User.feedsId==null) User.feedsId = ids[1];
		callBack(feedResponse, feedUrl, ids[0]);
	}

	function checkFeed(response) {		
		feedResponse = response;
		if (response.responseText == '' || response.responseXML.documentElement==null || response.responseXML.documentElement.nodeName=="parsererror") { // si le flux n'est pas valide
			callBack(feedResponse, feedUrl);
		} else {			
			var feed = new Feed(response);			
			var data = 'userFeedsId='+User.feedsId
					+'&title='+encodeURIComponent(feed.title)
					+'&xmlUrl='+encodeURIComponent(feedUrl)
					+'&htmlUrl='+encodeURIComponent(feed.htmlUrl)
					+'&description='+encodeURIComponent(feed.description);
			Request.sendPOST("addNewFeed.php", data, getFeedId);
		}
	}
	
	Request.sendGET(proxyURL+escape(feedUrl), checkFeed);
}

var Module = function(obj) {
	var self = this;
	this.dataObj = obj;
	this.editMode = false;
	this.loaded = false;
	this.adminMode = (obj.admin) ? true : false;
	this.isNew = (obj.isNew) ? true : false;

	this.build = function() {

		var divModule = document.createElement("div");
		this.elm_module = divModule;
		divModule.className = "module";
		divModule.dataObj = obj;

		var divModuleFrame = document.createElement("div");
		this.elm_moduleFrame = divModuleFrame;
		divModuleFrame.className = "moduleFrame";

		var divModuleHeader = document.createElement("div");
		this.elm_moduleHeader = divModuleHeader;
		divModuleHeader.className = "moduleHeader";
		if (this.adminMode) divModuleHeader.style.cursor = "default";
		
		divModuleHeader.onmouseover = function(){
			self.highlight();
		}
		divModuleHeader.onmouseout = function(){			
			self.unHighlight();
		}

		var divShowHide = document.createElement("div");
		this.elm_showHide = divShowHide;
		divShowHide.className = "showHide";
		divShowHide.innerHTML = (obj.status==0) ? '<img src="./img/showMod.gif"/>' : '<img src="./img/hideMod.gif"/>';
		divShowHide.style.visibility = "hidden";
		divShowHide.attachEvent('onmousedown',showHide);

		var divTitle = document.createElement("div");
		this.elm_title = divTitle;
		divTitle.className = "title";
		divTitle.appendChild(document.createTextNode(obj.title));

		var divClose = document.createElement("div");
		this.elm_close = divClose;
		divClose.className = "close";
		divClose.innerHTML = '<img src="./img/closeMod.gif"/>';
		divClose.style.display = "none";
		divClose.attachEvent('onmousedown',close);
		
		var divRefresh = document.createElement("div");
		this.elm_refresh = divRefresh;
		divRefresh.className = "refresh";
		divRefresh.innerHTML = '<img src="./img/refresh.gif"/>';
		divRefresh.style.display = "none";
		divRefresh.attachEvent('onmousedown',refresh);

		var divEdit = document.createElement("div");
		this.elm_edit = divEdit;
		divEdit.className = "edit";
		divEdit.innerHTML = '<a href="">'+App.Loc.editBtn+'</a>';
		divEdit.style.display = "none";
		divEdit.attachEvent('onmousedown',editModule);

		var divEditContent = document.createElement("div");
		this.elm_editContent = divEditContent;
		divEditContent.className = "editContent";

		var divModuleContent = document.createElement("div");
		this.elm_moduleContent = divModuleContent;
		divModuleContent.className = "moduleContent";
		divModuleContent.innerHTML = App.Loc.loading;
		if (obj.status==0) divModuleContent.style.display = "none";

		divModuleHeader.appendChild(divShowHide);
		divModuleHeader.appendChild(divClose);
		divModuleHeader.appendChild(divEdit);
		divModuleHeader.appendChild(divRefresh);
		divModuleHeader.appendChild(divTitle);

		divModuleFrame.appendChild(divModuleHeader);
		divModuleFrame.appendChild(divEditContent);
		divModuleFrame.appendChild(divModuleContent);

		divModule.appendChild(divModuleFrame);

		if (!this.adminMode) Drag.init(divModuleHeader, divModule);
		divModule.onDragStart = function(x,y,mousex, mousey) {
			var left = findPosX(this);
			var top = findPosY(this);
			
			var w = this.offsetWidth;
			this.style.width = (w-5)+"px";
			this.style.left = (left-5)+"px";
			this.style.top = (top-4)+"px";
			moduleGhost.style.height = this.offsetHeight+"px";
			this.parentNode.insertBefore(moduleGhost, this);
			this.style.position = "absolute";
			this.isDragging = true;
			moduleGhost.col=this.parentNode;
		}
		divModule.onDrag = function(x,y, mousex, mousey) {
			if ((x+this.offsetWidth/2)>=findPosX(App.columnsObj.col1)) col=App.columnsObj.col1;
			if ((x+this.offsetWidth/2)>=findPosX(App.columnsObj.col2)) col=App.columnsObj.col2;
			if ((x+this.offsetWidth/2)>=findPosX(App.columnsObj.col3)) col=App.columnsObj.col3;
			if (moduleGhost.col!=col) {
				moduleGhost.removeNode();
				moduleGhost.col = col;
				/*if (obj.container == 0) {
					if (col.hasChildNodes()) {
						col.insertBefore(moduleGhost, col.firstChild);
					} else {
						col.appendChild(moduleGhost);
					}
				} else {
					col.appendChild(moduleGhost);
				}*/
				col.appendChild(moduleGhost);
			}
			var elems = getModuleArr(col);
			var myPos = getGhostPos(elems, y);
			if (myPos!=0 && y<=findPosY(elems[myPos-1])) {
				moduleGhost.removeNode();
				col.insertBefore(moduleGhost, elems[myPos-1]);
			}
			if (myPos!=(elems.length-1) && y>=findPosY(elems[myPos+1])) {
				if (elems[myPos+2]) {
					col.insertBefore(moduleGhost, elems[myPos+2]);
				} else {
					col.appendChild(moduleGhost);
				}
			}
		}
		divModule.onDragEnd = function(x,y,el) {
			obj.container = moduleGhost.col.getAttribute("colNum");
			var col = moduleGhost.col;
			this.isDragging = false;
			col.replaceChild(this, moduleGhost);
			this.style.position = "static";
			this.style.width = "auto";
			self.unHighlight();
			App.saveUserData('order');
		}

		function getModuleArr(column) {
			var arr = [];
			var ln = column.childNodes.length;
			for (var z=0; z<ln; z++) {
				if (!column.childNodes[z].isDragging)  {
					arr.push(column.childNodes[z]);
				}
			}
			return arr;
		}

		function getGhostPos(arr, y) {
			var ln = arr.length;
			for (var z=0; z<ln; z++) {
				if (arr[z]==moduleGhost) return z;
			}
		}

		function showHide() {
			window.event.cancelBubble = true;
			self.showHideModule();
		}
		function close() {
			window.event.cancelBubble = true;
			self.close();
			delete self;
		}
		
		if(isNaN(parseInt(obj.container))) {
			obj.container.innerHTML = "";
			obj.container.appendChild(divModule);
		} else {
			if (this.isNew && App.columnsObj["col"+obj.container].hasChildNodes()) {
				App.columnsObj["col"+obj.container].insertBefore(divModule, App.columnsObj["col"+obj.container].firstChild);
			} else {
				App.columnsObj["col"+obj.container].appendChild(divModule);
			}
		}
	}

	function refresh() {
		window.event.cancelBubble = true;
		self.content.refresh();
	}

	function editModule() {
		window.event.cancelBubble = true;
		self.editMode = true;
		self.content.edit();
		self.elm_moduleFrame.style.border = "1px solid #2968B9";
		self.elm_module.style.border = "3px solid #E1E9F4";
		
		self.elm_editContent.style.display = "block";
		self.elm_edit.innerHTML = '<a href="">'+App.Loc.closeEditBtn+'</a>';
		self.elm_edit.detachEvent('onmousedown',editModule);
		self.elm_edit.attachEvent('onmousedown',closeEditModule);
		
		if (self.elm_moduleContent.style.display=='none') {
			self.showHideModule(true);
		} else {
			self.showHideModule(true, "nosave");
		}
	}

	function closeEditModule() {
		window.event.cancelBubble = true;
		self.editMode = false;
		self.elm_edit.innerHTML = '<a href="">'+App.Loc.editBtn+'</a>';
		self.elm_editContent.innerHTML = "";
		self.elm_editContent.style.display = "none";
		self.elm_edit.detachEvent('onmousedown',closeEditModule);
		self.elm_edit.attachEvent('onmousedown',editModule);
		self.elm_moduleFrame.style.border = "1px solid #79A7E2";
		self.elm_module.style.border = "3px solid #EEE";
	}

	this.save = function() {
		if(!isNaN(parseInt(obj.container))) {// si le module est en mode sélection
			App.saveUserData('module', obj);
		}
	}

	this.endEditMode = function() {
		this.editMode = false;
		this.elm_edit.innerHTML = '<a href="">'+App.Loc.editBtn+'</a>';
		this.elm_editContent.innerHTML = "";
		this.elm_editContent.style.display = "none";
		this.unHighlight();
		this.elm_module.style.border = "3px solid #EEE";
		this.elm_edit.detachEvent('onmousedown',editModule);
		this.elm_edit.detachEvent('onmousedown',closeEditModule);
		this.elm_edit.attachEvent('onmousedown',editModule);
	}

	this.onLoadModule = function() {
		this.loaded = true;
		if (this.adminMode) this.highlight();
	}
	
	this.highlight = function() {
		if (!this.editMode) {
			if (!this.adminMode) {
				this.elm_showHide.style.visibility = "visible";
				this.elm_close.style.display = "block";
				if (this.loaded && this.refreshMode) this.elm_refresh.style.display = "block";
			}
			if (this.loaded) this.elm_edit.style.display = "block";
		}
	}
	this.unHighlight = function() {
		if (!this.editMode) {
			this.elm_moduleFrame.style.border = "1px solid #79A7E2";
			this.elm_showHide.style.visibility = "hidden";
			this.elm_close.style.display = "none";
			this.elm_refresh.style.display = "none";
			if (!this.adminMode) this.elm_edit.style.display = "none";
		}
	}
	this.showHideModule = function() {
		if (arguments[0] != undefined) {
			arguments[0] ? this.show() : this.hide();
		} else {
			this.elm_moduleContent.style.display=='none' ? this.show() : this.hide();
		}
		if (arguments[1] == undefined) {
			App.saveUserData('module', obj);
		}
	}
	this.close = function() {
		this.elm_module.removeNode(true);
		App.saveUserData("close", obj);
	}
	this.show = function() {
		this.elm_moduleContent.style.display = 'block';
		this.elm_showHide.firstChild.setAttribute("src", "./img/hideMod.gif");
		if (this.editMode) this.elm_editContent.style.display = "block";
		obj.status = 1;
	}
	this.hide = function() {
		this.elm_moduleContent.style.display = 'none';
		this.elm_showHide.firstChild.setAttribute("src", "./img/showMod.gif");
		this.elm_editContent.style.display = "none";
		obj.status = 0;
	}

	this.attachContent = function() {
		if (App.Modules[obj.moduleName]) { // already loaded
			this.content = new App.Modules[obj.moduleName](this);
		} else {
			var oHead = document.getElementsByTagName("head")[0];
			var oScript = document.createElement('script');
			oScript.setAttribute('src', App.Modules[obj.moduleName+"Infos"].path);
			oScript.setAttribute('type', 'text/javascript');
			if (Browser.isFirefox) {
				oScript.onload = function() {
					self.content = new App.Modules[obj.moduleName](self);
				}
				oHead.appendChild(oScript);
			} else {
				oHead.appendChild(oScript);
				waitForExistence();
			}
		}

		function waitForExistence() {
			if (App.Modules[obj.moduleName]) { // if loaded
				self.content = new App.Modules[obj.moduleName](self);
			} else {
				setTimeout(waitForExistence,1);
			}
		}
	}

	this.loadContent = function() {
		if (obj.moduleName == "RssReader") {
			this.content = new App.Modules[obj.moduleName](this);
		} else {
			this.attachContent();
		}
	}

	this.build();
	if (this.dataObj.id!=null || this.dataObj.admin) this.loadContent();
}


var Tab = function(tabArray, index) {
	var self = this;
	this.selectedIndex = index;
	
	this.getElement = function() {
		return this.tab_elm;
	}
	this.getSelectedIndex = function() {
		return this.selectedIndex;
	}	
	
	function cleanTabs() {
		var ln = tabArray.length;
		for (var z=0; z<ln; z++) {
			var tab = self.tabsDiv.firstChild.firstChild.firstChild.childNodes[z];
			tab.style.backgroundColor = "#FCFCFC";
			tab.style.color = "#888";
		}
	}
	
	function build() {
		var container = document.createElement("div");
		self.tabsDiv = document.createElement("div");
		
		self.tabsDiv.innerHTML = '<table cellpadding="0" cellspacing="0"><tr></tr></table>';
			
		var ln = tabArray.length;
		for (var z=0; z<ln; z++) {
			var div = document.createElement("td");
				
			div.className = "tabtab";
			div.setAttribute("tabIndex", z);
			div.innerHTML = tabArray[z].title;
			div.onclick = function() {
				self.onBeforeChange(tabArray[self.selectedIndex]);
				var tabIndex = this.getAttribute("tabIndex");
				cleanTabs();
				this.style.backgroundColor = "#EFF5FF";
				this.style.color = "#333";
				contentDiv.firstChild.removeNode(true);
				contentDiv.appendChild(tabArray[tabIndex].content);
				
				if (tabIndex != self.selectedIndex) {
					self.selectedIndex = tabIndex;
					self.onChange(tabArray[tabIndex]);
				}
			}
			div.onmouseover = function() {
				if (self.selectedIndex != this.getAttribute("tabIndex")) this.style.backgroundColor = "#F1F1F1";
			}
			div.onmouseout = function() {
				if (self.selectedIndex != this.getAttribute("tabIndex")) this.style.backgroundColor = "#FCFCFC";
			}
			
			self.tabsDiv.firstChild.firstChild.firstChild.appendChild(div);
		}
		
		var tabSelected = self.tabsDiv.firstChild.firstChild.firstChild.childNodes[self.selectedIndex];
		tabSelected.style.backgroundColor = "#EFF5FF";
		tabSelected.style.color = "#333";
		
		var contentDiv = document.createElement("div");
		contentDiv.className = "tabContent";
		contentDiv.appendChild(tabArray[self.selectedIndex].content);
		
		container.appendChild(self.tabsDiv);
		container.appendChild(contentDiv);
		self.tab_elm = container;
	}
	
	build();
}

App.setBackButton = function() {
	var sessionFrame = document.getElementById("sessionFrame");
	var doc = sessionFrame.contentDocument;
	if (doc == undefined) { // IE
		doc = sessionFrame.contentWindow.document;
	}
	doc.open();
	doc.write("<html><body></body></html>");
	doc.close();
}

App.swapLang = function(lang) {
	function signOutResponse() {
		window.location.reload(true);
	}
	Request.sendGET('swapLang.php?lang='+lang, signOutResponse);
}

App.applySignInEvents = function(node) {
	var inputs = node.getElementsByTagName("input");
	var signupDiv = document.getElementById("signupDiv");
	var loginForm = document.getElementById("loginForm");
		
	var signinForm = loginForm.getElementsByTagName("form")[0];
	var signinInputs = loginForm.getElementsByTagName("input");
	signinInputs[0].focus();
	
	function signinResponse(response) {
		//alert(response.responseText);
		switch(response.responseText) {
			case "success":
				window.location.reload(true);
				break;
			case "nomatch":
				document.getElementById("signinErrorMsg").innerHTML = App.Loc.signinNoMatch;
				signinInputs[2].disabled = false;
				break;
		}	
	}
	
	signinForm.onsubmit = function() {
		var signinEmail = signinInputs[0];
		var signinPassword = signinInputs[1];		
		if (signinEmail.value !="" && signinPassword.value != "") {
			var data = "email="+encodeURIComponent(signinEmail.value)+"&password="+encodeURIComponent(signinPassword.value);
			signinInputs[2].disabled = true;
			var msg = document.getElementById("signinErrorMsg");
			msg.innerHTML = App.Loc.checking+"...";
			msg.style.marginTop = "5px";
			Request.sendPOST('userSignIn.php', data, signinResponse);
		}
		return false;
	}
	
	var signupInput = inputs[inputs.length-1];
	signupInput.onclick = function() {		
		var signupTeaser = document.getElementById("signupTeaser");
		signupDiv.style.display = "block";
		signupTeaser.style.display = "none";
		loginForm.style.display = "none";
		
		var signupForm = signupDiv.getElementsByTagName("form")[0];
		var signupInputs = signupForm.getElementsByTagName("input");
		
		var signupEmail = signupInputs[0];
		signupEmail.focus();
		signupEmail.onkeyup = signupEmail.onblur= function() {			
			this.style.border = (isEmailValid(this.value)) ? "1px solid #549B3F" : "1px solid #F00";
			this.style.padding = "2px 2px 2px 4px";
		}
		
		var signupPass1 = signupInputs[1];
		signupPass1.onkeyup = signupPass1.onblur= function() {
			//this.value = this.value.replace(/([^0-9a-zA-Z])/g,"");
			this.style.border = (this.value.length>=6) ? "1px solid #549B3F" : "1px solid #F00";
			this.style.padding = "2px 2px 2px 4px";
		}
		
		var signupPass2 = signupInputs[2];
		signupPass2.onkeyup = signupPass2.onblur= function() {
			//this.value = this.value.replace(/([^0-9a-zA-Z])/g,"");
			this.style.border = (this.value.length>=6 && this.value==signupPass1.value) ? "1px solid #549B3F" : "1px solid #F00";
			this.style.padding = "2px 2px 2px 4px";
		}
		
		function signupResponse(response) {			
			switch(response.responseText) {
				case "success":
					signupDiv.innerHTML = App.Loc.signupSuccess;
					App.setSignOutLink();
					break;
				case "error":
					document.getElementById("signupErrorMsg").innerHTML = App.Loc.error;
					signupInputs[3].disabled = false;
					break;
				case "inuse":
					document.getElementById("signupErrorMsg").innerHTML = App.Loc.signupEmailInUse;
					signupInputs[3].disabled = false;
					break;
			}
		}
		
		signupForm.onsubmit = function() {
			if (isEmailValid(signupEmail.value) && signupPass1.value.length>=6 && signupPass1.value==signupPass2.value) {
				var data = "email="+encodeURIComponent(signupEmail.value)+"&password="+encodeURIComponent(signupPass1.value);
				signupInputs[3].disabled = true;
				document.getElementById("signupErrorMsg").innerHTML = App.Loc.checking+"...";
				Request.sendPOST('userSignUp.php', data, signupResponse);
			}
			return false;
		}
	}
}

window.onload = function() {	
	App.setBackButton();
	App.Start();	
}

window.onunload = function() {
	try {
		var ln = App.moduleList.length;
		for (var z=0; z<ln; z++) {
			delete App.moduleList[z];
			App.moduleList[z] = null;
		}
		delete App;
		App = null;
	}
	catch (e) {}
}
