﻿// Copyright 2005 Netvibes

var Utils = new Object();

document.getElementsByClassName = function(className) {
	var children = document.getElementsByTagName('*') || document.all;
	var elements = new Array();
  
	for (var i = 0; i < children.length; i++) {
		var child = children[i];
		var classNames = child.className.split(' ');
		for (var j = 0; j < classNames.length; j++) {
			if (classNames[j] == className) {
				elements.push(child);
				break;
			}
		}
	}
	return elements;
}

function getNodeID(parent, id) {
	var ln = parent.childNodes.length;
	for (var z=0; z<ln; z++) {
		if (parent.childNodes[z].id == id) return parent.childNodes[z];
	}
	return null;
}


Utils.getChildrenByTagName = function(node, tagName) {	
	var ln = node.childNodes.length;
	var arr = [];	
	for (var z=0; z<ln; z++) {
		if (node.childNodes[z].nodeName==tagName) arr.push(node.childNodes[z]);
	}
	return arr;
}


var Browser = new Object();

Browser.isMozilla = (typeof document.implementation != 'undefined') && (typeof document.implementation.createDocument != 'undefined') && (typeof HTMLDocument!='undefined');
Browser.isIE = window.ActiveXObject ? true : false;
Browser.isFirefox = (navigator.userAgent.toLowerCase().indexOf("firefox")!=-1);
Browser.isOpera = (navigator.userAgent.toLowerCase().indexOf("opera")!=-1);

if (Browser.isMozilla) {
	HTMLElement.prototype.removeNode = function() {
		this.parentNode.removeChild(this);
	}
}

Utils.htmlEncode = function(text) {
	return text.replace(/&/g, '&amp;').replace(/"/g, '&quot;').replace(/</g, '&lt;').replace(/>/g, '&gt;');
}

/*
<!--[if IE]>
	<a href onClick="this.style.behavior='url(#default#homepage)';this.setHomePage('http://www.netvibes.com');">Make Netvibes your homepage</a>
<![endif]-->
*/

function isEmailValid(e) {
	var ok = "1234567890qwertyuiop[]asdfghjklzxcvbnm.+@-_QWERTYUIOPASDFGHJKLZXCVBNM";
	for(var i=0; i<e.length; i++){
		if (ok.indexOf(e.charAt(i))<0) {
			return false;
		}
	}
	if (document.images) {
		var re = /(@.*@)|(\.\.)|(^\.)|(^@)|(@$)|(\.$)|(@\.)/;
		var re_two = /^.+\@(\[?)[a-zA-Z0-9\-\.]+\.([a-zA-Z]{2,8}|[0-9]{1,3})(\]?)$/;
		if (!e.match(re) && e.match(re_two)) {
			return -1;
		}
	}
}


var notspace = /\S/;
Utils.cleanWhitespace = function(node){
	for (var x=0; x<node.childNodes.length; x++) {
		var child = node.childNodes[x];
		//if it's a whitespace text node
		if ((child.nodeType == 3) && (!notspace.test(child.nodeValue)))	{
			node.removeChild(node.childNodes[x]);
			//node.childNodes[x].removeNode();
			x--;
		}
		//elements can have text child nodes of their own
		if(child.nodeType == 1) {
			Utils.cleanWhitespace(child);
		}
	}
}


String.prototype.trim = function() {
	return this.replace(/^\s*|\s*$/g,"");
}


