App.Modules.PriceWatch = function(obj) {
	var data = obj.dataObj.data;
	var localData = new Object();
	var el = obj.elm_moduleContent;
	data.nbOffers = parseInt(data.nbOffers);
	var tradeDoublerURL = 'http://tracker.tradedoubler.com/click?p=17928&a=1028692&g=675185&url=';
	
	this.edit = function() {
		var editContent = obj.elm_editContent;
		
		if (App.lang=='fr') {		
			var cats = [
				{name:"Appareil photo numérique", id:"124901"},
				{name:"Auto / Moto", id:"172601"},	
				{name:"Electroménager", id:"144601"},
				{name:"Fleurs & Cadeaux", id:"100007413"},
				{name:"Hifi, Photo & Vidéo", id:"120501"},
				{name:"Informatique", id:"110001"},
				{name:"Ordinateur / PDA", id:"100326223"},
				{name:"Livres, Musique, Film", id:"150401"},
				{name:"Maison & Jardin", id:"134301"},
				{name:"Mode & Accessoires", id:"107301"},
				{name:"Santé - Beauté", id:"132801"},
				{name:"Sport & Loisirs", id:"163601"},
				{name:"Vin & Alimentation", id:"125301"},
				{name:"Téléphonie & ADSL", id:"129801"},
				{name:"Voyages", id:"169901"}
			]		
		} else {		
			var cats = [
				{name:"Digital Cameras", id:"124901"},
				{name:"Cars & Accessories", id:"172601"},
				{name:"Household Appliances", id:"144601"},
				{name:"Gifts & Gadgets", id:"100007413"},
				{name:"Electronics", id:"120501"},
				{name:"High-Tech", id:"110001"},
				{name:"Computers & PDA", id:"100326223"},
				{name:"Books, Music & Video", id:"150401"},
				{name:"Home & Garden", id:"134301"},
				{name:"Fashion & Lingerie", id:"107301"},
				{name:"Health & Beauty", id:"132801"},
				{name:"Sport & Fitness", id:"163601"},
				{name:"Mobiles, Phones & Internet", id:"129801"},
				{name:"Travel", id:"169901"}
			]		
		}
		
		var content = '<table cellpadding="0" cellspacing="0" class="formTable">'+
					'<tr>'+
					'<td><span class="formLabel">'+App.Loc.PriceWatch_edit_watch+' :</span></td>'+
					'<td><input type="text" name="town" class="inputClean" accesskey="t" maxlength="150" value="'+data.query+'" style="width:120px"/></td>'+
					'<td><input type="submit" value="'+App.Loc.editSave+'" class="buttonClean"/></td>'+
					'</tr>'+
					'<tr>'+
					'<td><span class="formLabel">'+App.Loc.PriceWatch_edit_category+' :</span></td>'+
					'<td>'+
						'<select style="width:150px;margin-right:5px">'+getCatList()+'</select>'+
					'</td>'+
					'<td><input type="submit" value="'+App.Loc.editSave+'" class="buttonClean"/></td>'+
					'</tr>'+
					'<tr>'+
					'<td><span class="formLabel">'+App.Loc.PriceWatch_edit_nbOffers+' :</span></td>'+
					'<td>'+
						'<select style="width:45px">'+getNbList()+'</select>'+
					'</td>'+
					'<td></td>'+
					'</tr>'+
				'</table>';
		
		editContent.innerHTML = content;		
		
		var table = editContent.firstChild.firstChild;
		var tr1 = table.childNodes[0];
		var tr2 = table.childNodes[1];
		var tr3 = table.childNodes[2];
		var input1 = tr1.childNodes[1].firstChild;
		var inputButton1 = tr1.childNodes[2].firstChild;
		var input2 = tr2.childNodes[1].firstChild;
		var inputButton2 = tr2.childNodes[2].firstChild;
		var input3 = tr3.childNodes[1].firstChild;
		
		inputButton1.onclick = function() {
			obj.elm_title.innerHTML = App.Loc.defaultPriceWatch_title + ' : <span style="color:#36C">'+App.Loc.loading+'</span>';
			
			localData.query = input1.value;
			localData.catId = input2.value;
			
			input2.disabled = true;
			inputButton2.disabled = true;
			input3.disabled = true;
			
			el.innerHTML = App.Loc.loading;
			var url = 'http://export.kelkoo.fr/ctl/exportSearch?partner=generationmp3&siteSearchQuery='+encodeURIComponent(localData.query)+'&partnerId=8916225&partner=kelkoo&catId='+localData.catId;
			Request.sendGET(proxyURL+encodeURIComponent(url), updateQuery);
		}
		inputButton2.onclick = function() {
			localData.query = input1.value;
			localData.catId = input2.value;
			
			input1.disabled = true;
			inputButton1.disabled = true;
			input3.disabled = true;
			
			el.innerHTML = App.Loc.loading;
			var url = 'http://export.kelkoo.fr/ctl/exportSearch?partner=generationmp3&siteSearchQuery='+encodeURIComponent(localData.query)+'&partnerId=8916225&partner=kelkoo&catId='+localData.catId;
			Request.sendGET(proxyURL+encodeURIComponent(url), updateCat);
		}
		
		input3.onchange = function() {
			data.nbOffers = this.value;
			displayItems();			
			App.saveUserData('module', obj.dataObj);
		}
		
		function getCatList() {
			var c='';
			var ln = cats.length;
			for (var z=0; z<ln; z++) {
				if (cats[z].id == data.catId) {
					c+='<option value="'+cats[z].id+'" selected>'+cats[z].name;
				} else {
					c+='<option value="'+cats[z].id+'">'+cats[z].name;
				}
			}
			return c;
		}
		
		function getNbList() {
			var c='';
			var ln = localData.items.length;
			for (var z=0; z<ln; z++) {
				if ((z+1)==data.nbOffers) {
					c+='<option value="'+(z+1)+'" selected>'+(z+1);
				} else {
					c+='<option value="'+(z+1)+'">'+(z+1);
				}
			}
			return c;
		}
		
		function updateQuery(response) {
			data.query = localData.query;
			data.catId = localData.catId;
		
			input2.disabled = false;
			inputButton2.disabled = false;
			
			display(response);
			App.saveUserData('module', obj.dataObj);
			
			var td = input3.parentNode;
			var c = '<select style="width:45px">'+getNbList()+'</select>';
			td.innerHTML = c;
			input3 = td.firstChild;
			input3.onchange = function() {
				data.nbOffers = this.value;
				displayItems();
				App.saveUserData('module', obj.dataObj);
			}
			var rootNode = response.responseXML.documentElement;
			if (rootNode.getElementsByTagName("resultList")[0].getAttribute("nbResults")=="0") {
				input3.disabled = true;
				obj.elm_title.innerHTML = App.Loc.defaultPriceWatch_title;
			} else {
				obj.elm_title.innerHTML = App.Loc.defaultPriceWatch_title + ' : <span style="color:#36C">'+data.query+'</span>';
			}
			
		}
		
		function updateCat(response) {
			data.query = localData.query;
			data.catId = localData.catId;
		
			input1.disabled = false;
			inputButton1.disabled = false;
			
			display(response);
			App.saveUserData('module', obj.dataObj);
			
			var td = input3.parentNode;
			var c = '<select style="width:45px">'+getNbList()+'</select>';
			td.innerHTML = c;
			input3 = td.firstChild;
			input3.onchange = function() {
				data.nbOffers = this.value;
				displayItems();
				App.saveUserData('module', obj.dataObj);
			}
			var rootNode = response.responseXML.documentElement;
			if (rootNode.getElementsByTagName("resultList")[0].getAttribute("nbResults")=="0") {
				input3.disabled = true;
			}
		}
		
	}
	
	function displayItems() {
		var offers = document.createElement("div");
		offers.className = "product";
		for (var z=0; z<data.nbOffers; z++) {
			var url = tradeDoublerURL+localData.items[z].getElementsByTagName("merchantURL")[0].firstChild.nodeValue;
			var img = localData.items[z].getElementsByTagName("smallImage")[0].firstChild.nodeValue;
			var price = localData.items[z].getElementsByTagName("price")[0].firstChild.nodeValue;
			var titre = localData.items[z].getElementsByTagName("offerTitle")[0].firstChild.nodeValue;
			var marchand = localData.items[z].getElementsByTagName("merchantName")[0];
			marchand = (marchand.firstChild) ? marchand.firstChild.nodeValue : "";
			
			var imgContent = '<a href="'+url+'" target="_blank"><img src="'+img+'" width="50" height="50"/></a>';
			var priceContent = '<a href="'+url+'" target="_blank"><div class="productPrice">'+price+' &#8364;</div>'+
						'<div class="productTitle">'+titre+'</div>'+
						'<div class="productMerchant">'+App.Loc.PriceWatch_at+' '+marchand+'</div></a>';
			var offerContent = '<div><a href="'+url+'" target="_blank">'+App.Loc.PriceWatch_seeOffer+'</a></div>';
						//'<div>[desc]</div>';
			var content = '<table cellpadding="0" cellspacing="0" width="100%"><tr style="vertical-align:top"><td style="width:50px"></td><td class="productDesc"></td><td class="productOffer"></td></tr></table>';
			var div = document.createElement("div");
			div.className = "productTable";
			div.innerHTML = content;
			var tr = div.firstChild.firstChild.firstChild;
			tr.childNodes[0].innerHTML = imgContent;
			tr.childNodes[1].innerHTML = priceContent;
			tr.childNodes[2].innerHTML = offerContent;
			/*tr.childNodes[2].lastChild.setAttribute("offerNum", z);
			tr.childNodes[2].lastChild.onmouseover = function() {
				var num = this.getAttribute("offerNum");
				//showtip(this, localData.items[num].getElementsByTagName("description")[0].firstChild.nodeValue, 250, "left");
			}*/
			offers.appendChild(div);
		}
		el.innerHTML = "";
		el.appendChild(offers);
	}
	
	function display(response) {
		var rootNode = response.responseXML.documentElement;
		
		if (rootNode.getElementsByTagName("resultList")[0].getAttribute("nbResults")=="0") {
			el.innerHTML = App.Loc.PriceWatch_noResults;
		} else {
			localData.items = rootNode.getElementsByTagName("result");
			if (localData.items.length<data.nbOffers) {
				data.nbOffers = localData.items.length;
				App.saveUserData('module', obj.dataObj);
			}
			displayItems();
		}
		obj.elm_title.innerHTML = App.Loc.defaultPriceWatch_title + ' : <span style="color:#36C">'+data.query+'</span>';
		obj.onLoadModule();
	}
	
	var url = 'http://export.kelkoo.fr/ctl/exportSearch?partner=generationmp3&siteSearchQuery='+encodeURIComponent(data.query)+'&partnerId=8916225&partner=kelkoo&catId='+data.catId;
	Request.sendGET(proxyURL+encodeURIComponent(url), display);
	
	obj.elm_title.innerHTML = App.Loc.defaultPriceWatch_title + ' : <span style="color:#36C">'+data.query+'</span>';
}