
App.Modules.RssReader = function(obj){
	var data = obj.dataObj.data;
	var localData = new Object();
	var el = obj.elm_moduleContent;
		
	this.edit = function() {
		var editContent = obj.elm_editContent;
		var rndChkBox = Math.round(Math.random()*1000);		
		var content = '<table cellpadding="0" cellspacing="0" class="formTable">'+
					'<tr>'+
					'<td><span class="formLabel">'+App.Loc.RssReader_edit_title+' :</span></td>'+
					'<td><input type="text" class="inputClean" accesskey="t" maxlength="100" value="'+obj.dataObj.title+'" style="width:120px"/></td>'+
					'<td><input type="submit" value="'+App.Loc.editSave+'" class="buttonClean"/></td>'+
					'</tr>'+
					'<tr>'+
					'<td><span class="formLabel">'+App.Loc.RssReader_edit_feed+' :</span></td>'+
					'<td><input type="text" class="inputClean" accesskey="t" maxlength="150" value="'+obj.dataObj.feedUrl+'" style="width:120px"/></td>'+
					'<td><input type="submit" value="'+App.Loc.editSave+'" class="buttonClean"/></td>'+
					'</tr>'+
					'<tr>'+
					'<td><span class="formLabel">'+App.Loc.RssReader_edit_nbItems+' :</span></td>'+
					'<td>'+
						'<select style="width:45px">'+getOptionList()+'</select>'+
					'</td>'+
					'<td></td>'+
					'</tr>'+
					'<tr>'+
					'<td><span class="formLabel">'+App.Loc.RssReader_edit_links+' :</span></td>'+
					'<td colspan="2">'+
						'<input id="openLinks_'+rndChkBox+'" type="checkbox"/><label for="openLinks_'+rndChkBox+'" style="margin-left:5px">'+App.Loc.RssReader_edit_openLinks+'</label>'+
					'</td>'+
					'</tr>'+
					/*'<tr>'+
					'<td><span class="formLabel">Date :</span></td>'+
					'<td>'+
						'<input type="checkbox">'+
					'</td>'+
					'<td></td>'+
					'</tr>'+*/
				'</table>';
		editContent.innerHTML = content;
		
		var table = editContent.firstChild.firstChild;
		var tr1 = table.childNodes[0];
		var tr2 = table.childNodes[1];
		
		if (App.mode=='featuredPage') {
			tr1.style.display = "none";
			tr2.style.display = "none";
		}
		
		var tr3 = table.childNodes[2];
		var tr4 = table.childNodes[3];
		var input4 = tr4.childNodes[1].firstChild;
		input4.checked = (data.openOutside==0 || !data.openOutside) ? false : true;
		input4.onclick = function() {
			data.openOutside = (this.checked) ? 1 : 0;
			obj.save();
		}
		
		var input1 = tr1.childNodes[1].firstChild;
		var inputButton1 = tr1.childNodes[2].firstChild;
		var input2 = tr2.childNodes[1].firstChild;
		var inputButton2 = tr2.childNodes[2].firstChild;
		var input3 = tr3.childNodes[1].firstChild;
		
		inputButton1.onclick = function() {
			obj.dataObj.title = input1.value;
			obj.elm_title.innerHTML = '';
			obj.elm_title.appendChild(document.createTextNode(obj.dataObj.title));
			obj.save();
		}
		inputButton2.onclick = function() {
			if (input2.value.trim()!=obj.dataObj.feedUrl && input2.value.trim()!='') {
				obj.dataObj.title = '';
				obj.elm_title.innerHTML = App.Loc.loading;
				
				input1.disabled = true;
				inputButton1.disabled = true;
				input3.disabled = true;
				input4.disabled = true;
				
				el.innerHTML = App.Loc.loading;
				App.addNewFeed(input2.value.trim(), addFeedResponse);
			}
		}
		input3.onchange = function() {
			data.nbTitles = this.value;
			displayItems();
			obj.save();
		}
		
		function getOptionList() {
			if (localData.feed) {
				var c='';
				var ln = localData.feed.items.length;
				for (var z=0; z<ln; z++) {
					if ((z+1)==data.nbTitles) {
						c+='<option value="'+(z+1)+'" selected>'+(z+1);
					} else {
						c+='<option value="'+(z+1)+'">'+(z+1);
					}
				}
				return c;
			}
		}
		
		function addFeedResponse(response, feedUrl, id) {
			if (response.responseText == '' || response.responseXML.documentElement==null || response.responseXML.documentElement.nodeName=="parsererror") { // si le flux n'est pas valide
				obj.elm_title.innerHTML = App.Loc.error;
				el.innerHTML = App.Loc.feedNotValid;
			} else {
				App.Nav.isFeedsUpdated = true;
				setTimeout(App.Nav.openMyFeeds,1);
			
				data.feedId = id;
				obj.dataObj.feedUrl = feedUrl;
				updateRSSFeed(response);
			}
		}
		
		function updateRSSFeed(response) {
			input1.disabled = false;
			inputButton1.disabled = false;
			input3.disabled = false;
			input4.disabled = false;
			displayRSSFeed(response);
			obj.save();
			input1.value = obj.dataObj.title;
			
			var td = input3.parentNode;
			var c = '<select style="width:45px">'+getOptionList()+'</select>';
			td.innerHTML = c;
			input3 = td.firstChild;
			input3.onchange = function() {
				data.nbTitles = this.value;
				displayItems();
				obj.save();
			}
		}
	}
	
	function displayItems() {
		var divUL = document.createElement("ul");
		divUL.className = "rssItemList";
		
		for (var z=0; z<data.nbTitles; z++) {
			var divLI = document.createElement("li");
			divLI.setAttribute("itemNum", z);
			divLI.setAttribute("url", localData.feed.items[z].link);
			divLI.innerHTML = '<a href="'+localData.feed.items[z].link+'" target="_blank">'+localData.feed.items[z].title+'</a>';
			
			divLI.firstChild.onclick = function() {
				if (data.openOutside==0 || !data.openOutside || localData.feed.items[this.parentNode.getAttribute("itemNum")].link==null) {
					var selectedItemNum = this.parentNode.getAttribute("itemNum");
					App.FeedReader.display({title: obj.dataObj.title, moduleLocalData:localData, moduleData:data, selectedItemIndex:selectedItemNum});
					return false;
				} else {
					return true;
				}
			}
			divLI.firstChild.style.cursor = "pointer";
			divLI.firstChild.onmouseover = function() {
				this.style.color = "#F60";
				/*this.style.borderBottom = "1px solid #F60";*/
				this.style.textDecoration = "underline";
			}
			divLI.firstChild.onmouseout = function() {
				this.style.color = "#333";
				/*this.style.borderBottom = "none";*/
				this.style.textDecoration = "none";
			}
			divUL.appendChild(divLI);
		}
		el.innerHTML = "";
		el.appendChild(divUL);
	}
	
	
	function displayRSSFeed(response) {
		if (response.responseText == '' || response.responseXML.documentElement==null || response.responseXML.documentElement.nodeName=="parsererror") { // si le flux n'est pas valide			
			obj.elm_title.innerHTML = App.Loc.error;
			el.innerHTML = App.Loc.feedNotValid;			
			obj.onLoadModule();
		} else {
			Utils.cleanWhitespace(response.responseXML.documentElement);
			obj.dataObj.currentServerRequest = null;
		
			localData.feed = new Feed(response);
			
			if (data.nbTitles==null) data.nbTitles=7;
			data.nbTitles = (localData.feed.items.length>data.nbTitles) ? data.nbTitles : localData.feed.items.length;
			
			if (obj.dataObj.title=='')  obj.dataObj.title = localData.feed.title;
			obj.elm_title.innerHTML = obj.dataObj.title;
			
			displayItems();
			obj.onLoadModule();
		}
	}
	
	obj.refreshMode = true;
	
	if (obj.dataObj.title == "") obj.elm_title.innerHTML = App.Loc.loading;
	obj.dataObj.currentServerRequest = Request.sendGET(proxyURL+escape(obj.dataObj.feedUrl), displayRSSFeed);
	
	function updateFeed(nocache) {
		obj.elm_title.innerHTML = '<span style="color:#36C">'+App.Loc.updating+'...</span>';
		if (nocache) {
			Request.sendGET(proxyURL+escape(obj.dataObj.feedUrl)+"&nocache=1&rnd="+Math.random(), displayRSSFeed);
		} else {
			Request.sendGET(proxyURL+escape(obj.dataObj.feedUrl)+"&rnd="+Math.random(), displayRSSFeed);
		}
	}
	
	this.refresh = function() {
		updateFeed(true);
	}
	
	var rndUpdateTime = Math.round(60*1000*Math.random());
	setInterval(updateFeed, 1000*60*20+rndUpdateTime);
}