﻿App.Modules.Weather = function(obj){
	var data = obj.dataObj.data;
	var localData = new Object();
	var el = obj.elm_moduleContent;
		//Download by http://www.jb51.net
	this.edit = function() {
		var editContent = obj.elm_editContent;
			
		var form = document.createElement("form");
		form.onsubmit = ajaxCall;
			
		function ajaxCall() {
			var input = form.firstChild.firstChild.firstChild.firstChild.nextSibling.firstChild;
			resultDiv.innerHTML = App.Loc.loading;
			resultDiv.style.display = "block";
			Request.sendGET(proxyURL+escape("http://xoap.weather.com/search/search?where="+escape(input.value)), displayResultList);
			return false;
		}
		
		function displayResultList(response) {
			var rootNode = response.responseXML.documentElement;
			var r = rootNode.getElementsByTagName("loc");
			var ln = r.length;
			if (ln==1) {
				data.town= r[0].getAttribute("id");
				obj.save();
				Request.sendGET(proxyURL+escape("http://xoap.weather.com/weather/local/"+data.town+"?cc=*&unit=d&dayf=4"), displayWeather);
			} else if (ln==0) {
				resultDiv.innerHTML = '<span style="color:#900">'+App.Loc.Weather_edit_noInfos+'</span>';
				resultDiv.style.display = "block";
			} else {				
				var ul = document.createElement("ul");
				for (var z=0; z<ln; z++) {
					var li = document.createElement("li");
					li.style.cursor = "pointer";
					li.onclick = function() {
						resultDiv.innerHTML = App.Loc.loading;
						data.town= this.getAttribute("idTown");
						obj.save();
						Request.sendGET(proxyURL+escape("http://xoap.weather.com/weather/local/"+data.town+"?cc=*&unit=d&dayf=4"), displayWeather);
					}
					li.setAttribute("idTown", r[z].getAttribute("id"));
					li.innerHTML = '<a href="javascript:void(0)">'+r[z].firstChild.nodeValue+'</a>';
					ul.appendChild(li);
				}
				resultDiv.innerHTML = "";
				resultDiv.appendChild(ul);
				resultDiv.style.display = "block";
			}
		}
		
		if (data.unit==null) {
			var unitSelected = (App.lang=="fr" || App.lang=="ru") ? 1 : 0;
		} else {
			var unitSelected = data.unit;
		}
		
		var content = '<table cellpadding="0" cellspacing="0" class="formTable"><tr>'+
						'<td><span class="formLabel">'+App.Loc.Weather_edit_town+' :</span></td>'+
						'<td><input type="text" class="inputClean" accesskey="t" maxlength="150" style="width:75px"/><input type="submit" value="'+App.Loc.editSave+'" class="buttonClean"/></td>'+
					'</tr>'+
					'<tr>'+
						'<td><span class="formLabel">'+App.Loc.Weather_edit_unit+' :</span></td>'+
						'<td>'+
							'<select style="width:100px">'+
								'<option value="0" '+((unitSelected==0) ? 'selected' : '')+'>'+App.Loc.Weather_edit_fahrenheit+
								'<option value="1" '+((unitSelected==1) ? 'selected' : '')+'>'+App.Loc.Weather_edit_celsius+
							'</select>'+
						'</td>'+
					'</tr>'+
					'</table>';
		form.innerHTML = content;
		editContent.appendChild(form);
		
		var selectInput = form.getElementsByTagName("select")[0];
		selectInput.onchange = function() {
			data.unit = this.value;
			el.innerHTML = '';
			displayContent();
			obj.save();
		}
		
		var resultDiv = document.createElement("div");
		resultDiv.className = "weatherEditInfos";
		editContent.appendChild(resultDiv);
	}
	
	function getImgCode(fileName) {
		if (fileName=="N/A") fileName = "NA";
		if (fileName.length==1) fileName = "0"+fileName;
		if (Browser.isIE) {
			var c = '<div style="height:51px; width:51px; filter:progid:DXImageTransform.Microsoft.AlphaImageLoader (src=\'modules/weather/img/'+fileName+'.png\', sizingMethod=\'scale\');"></div>';
		} else {
			var c = '<div style="height:51px"><img src="modules/weather/img/'+fileName+'.png"/></div>';
		}
		return c;
	}
	
	function toCelcius(n) {
		var calc = Math.round((n-32)*5/9);
		return (isNaN(calc)) ? "N/A" : calc;
	}
	
	function getTemp(node) {
		var hi = node.getElementsByTagName("hi")[0].firstChild.nodeValue;
		var low = node.getElementsByTagName("low")[0].firstChild.nodeValue;
		
		if (data.unit==null) {
			if (App.lang=="fr" || App.lang=="ru") {
				hi = toCelcius(hi);
				low = toCelcius(low);
			}
		} else if (data.unit==1) {
			hi = toCelcius(hi);
			low = toCelcius(low);
		}
		
		return low+"°/"+hi+"°";
	}
	
	function displayContent() {
		content = '<table cellpadding="0" cellspacing="0" width="100%"><tr>';
		var days = localData.rootNode.getElementsByTagName("day");
		var ln = days.length;
		for (var z=0; z<ln; z++) {
			content += '<td class="weatherBox">'+
					'<div class="weatherDay">'+App.Loc.Weather_days[days[z].getAttribute("t")]+'</div>'+
					'<div class="weatherIcon">'+getImgCode(days[z].getElementsByTagName("icon")[0].firstChild.nodeValue)+'</div>'+
					'<div>'+getTemp(days[z])+'</div>'+
					'</td>';
		}		
		content += '</tr></table><div style="font-size: 9px;color: #CCC;margin:4px 0;text-align:center">Powered by: The Weather Channel ®</div>';
		el.innerHTML = content;
	}
	
	function displayWeather(response) {
		obj.endEditMode();
		localData.rootNode = response.responseXML.documentElement;
		
		obj.elm_title.innerHTML = App.Loc.defaultWeather_title+' : <span style="color:#36C">'+localData.rootNode.getElementsByTagName("dnam")[0].firstChild.nodeValue+'</span>';		
		displayContent();
		el.style.paddingBottom = "0";
		
		obj.onLoadModule();
	}	
	
	Request.sendGET(proxyURL+escape("http://xoap.weather.com/weather/local/"+data.town+"?cc=*&unit=d&dayf=4"), displayWeather);
	
}
