//带有修改用户信息的UserJs
//全局设置
/*--------------------------------------设定占位符--------------------------------------*/
Ext.BLANK_IMAGE_URL = 'resources/images/default/s.gif';
/*--------------------------------------设定验证提示--------------------------------------*/
Ext.QuickTips.init();
/*--------------------------------------设定验证提示样式--------------------------------------*/
Ext.form.Field.prototype.msgTarget = 'qtip';
//定义省的数据源
var store=new Ext.data.Store({
        autoLoad:true,
        proxy:new Ext.data.HttpProxy({
            url:'city.asp?cmd=cityn&a='+new Date().getTime()+''
        }),
        reader:new Ext.data.JsonReader({
            id:'ID',
            fields:['name','code']
        }),
        remoteSort:true
    });
//定义市的数据源
    var comstore =new Ext.data.Store({
        autoLoad:false,
        proxy:new Ext.data.HttpProxy({
            url:'city.asp?cmd=cityt&a='+new Date().getTime()+'',
            method:'post'
        }),
        reader:new Ext.data.JsonReader({
            id:'ID',
            fields:['name','code']
        }),
            remote:true
    });
//定义区的数据源数据源
var Threestore =new Ext.data.Store({
        autoLoad:false,
        proxy:new Ext.data.HttpProxy({
            url:'city.asp?cmd=citys&a='+new Date().getTime()+'',
            method:'post'
        }),
        reader:new Ext.data.JsonReader({
            id:'ID',
            fields:['name','code']
        }),
            remote:true
    });
//用户注册窗口
UserRegWindow = Ext.extend(Ext.Window,{
	title : '新用户注册', 
	width : 500, 
	iconCls:"icon-AddUser", 
	modal:true,										//启用遮罩
	height : 400, 
	defaults : { border : false }, 
	buttonAlign : 'center', 
	createFormPanel :function() {					//创建FormPanel
		return new Ext.form.FormPanel({
			bodyStyle : 'padding-top:6px', 
			defaultType : 'textfield', 
			labelAlign : 'right', 
			labelWidth : 100, 
			labelPad : 0, 
			frame : true, 
			defaults : { 
				allowBlank : false, 
				width : 300, 
				selectOnFocus:true 
			}, 
			items : [{
				xtype:"combo",
				name:'UserType',
				fieldLabel:'会员类型',
				displayField:'name',
				valueField:'code',
				store:new Ext.data.SimpleStore({
				fields:['name','code'],	
				data:[["机构",0],["企业",1],["专家",2],["医生",3],["个人",4],["记者",5]]
				}),
				triggerAction:'all',
				mode:'local',
				selectOnFocus:true,
				forceSelection: true,
				allowBlank:false,
				//editable: false,
				hiddenName:'UserType',
				emptyText:'请选择会员类型',
				blankText : '请选择会员类型'
			},
			{
				xtype:"textfield",
				name:'UserName',
				fieldLabel:'用户名',
				emptyText:'填写用户名',
				blankText : '用户名不能为空' 
				//readOnly:true 		//设置input属性为只读
			},
			{
				xtype:"textfield",
				name : 'RealName', 
				fieldLabel : '姓名', 
				emptyText:'填写真实姓名',
				blankText : '姓名不能为空'
				
			}, 
			{ 
				name : 'PaddWord', 
				fieldLabel : '用户密码', 
				blankText : '密码不能为空', 
				//emptyText:'填写用户密码',
				inputType : 'password' 
			}, 
			{
				xtype:"combo",
				name : 'UserAdd', 
				id:'sheng',
				fieldLabel : '选择省',
				displayField:'name',
				valueField:'code',
				store:store,
				triggerAction:'all',
				mode:'local',
				selectOnFocus:true,
				forceSelection: true,
				allowBlank:false,
				editable: false,
				hiddenName:'UserAdd',
				emptyText:'请选择省',
				blankText : '请选择省',
				listeners:{   
           			select:function(){
					 try{
						 var parent=Ext.getCmp('shi');
						 parent.clearValue();
						 parent.store.reload({params:{action:this.value}});
					 }
					 catch(ex)
					 {
						 Ext.MessageBox.alert(ex);
					 }
				 	}
				}
			}, 
			{
				xtype:"combo",
				name : 'shi1',
				id : 'shi',
				fieldLabel : '选择市',
				displayField:'name',
				valueField:'code',
				triggerAction:'all',
				store:comstore,
				mode:'local',
				selectOnFocus:true,
				forceSelection: true,
				allowBlank:false,
				editable: false,
				hiddenName:'shi1',
				emptyText:'请选择市',
				blankText : '请选择市',
				listeners:{   
           			select:function(){
                 	try{
						 var parent=Ext.getCmp('qu');
						 parent.clearValue();
						 //alert(this.value);
						 parent.store.reload({params:{action:this.value}});
                 	}
                 	catch(ex)
                 	{
                     	Ext.MessageBox.alert(ex);
                 	}
             		}
				}
			}, 
			{
				xtype:"combo",
				name : 'qu1',
				id : 'qu',
				fieldLabel : '选择区',
				displayField:'name',
				valueField:'code',
				triggerAction:'all',
				store:Threestore,
				mode:'local',
				selectOnFocus:true,
				forceSelection: true,
				allowBlank:false,
				editable: false,
				hiddenName:'qu1',
				emptyText:'请选择区',
				blankText : '请选择区',
				listeners:{   
           			select:function(combo, record,index){
						Ext.getCmp("Usertxdz").setValue(record.data.name);
           			}   
       			}
			}, 
			{
				xtype:"textfield",
				name : 'UserUnits', 
				fieldLabel : '单位', 
				emptyText:'填写您的单位名称',
				blankText : '单位名称不能为空'
			}, 
			{
				xtype:"textfield",
				name : 'UserDuty', 
				fieldLabel : '职务', 
				emptyText:'填写您的职务名称',
				blankText : '职务不能为空'
			}, 
			{
				xtype:"textfield",
				name : 'UserTitle', 
				fieldLabel : '职称', 
				emptyText:'填写您的职称',
				blankText : '职称不能为空'
			}, 
			{
				xtype:"textfield",
				id:'Usertxdz',
				name : 'Usertxdz', 
				fieldLabel : '通讯地址', 
				emptyText:'选择省市地区后，会自动添加相应的通讯地址',
				readOnly:true,
				blankText : '通讯地址不能为空'
			}, 
			{
				xtype:"datefield",
				name : 'JoinTime', 
				fieldLabel : '添加时间',
				format:"Y-n-j",
				emptyText:'选择您的加入时间',
				blankText : '添加时间不能为空'
			}] }); }, 
	save:function() { 
		if(this.fp.form.isValid()){
		this.fp.form.submit({
			waitTitle:"请稍候", 
			waitMsg : "正在保存...", 
			url : 'service.asp?cmd=save', 
			success : function(form, action) {
				var Result = action.result.success; 
				if(Result == false){
					alert(action.result.message);
                    } else if(Result == true){
						Ext.Msg.alert("提示！","新用户注册成功！");
                    } 
			}, 
			failure : function(form, action) { 
				Ext.MessageBox.alert('提示', action.result.message);
			}, scope:this }); }}, 
	initComponent : function(){ 
		this.keys={ key: Ext.EventObject.ENTER, fn: this.save, scope: this}; 
		UserRegWindow.superclass.initComponent.call(this); 
		this.fp=this.createFormPanel(); 
		this.add(this.fp); 
		this.addButton('提交',this.save,this); 
		this.addButton('取消', function(){this.close();},this); this.on("close",function(){}) } }); 

//弹出用户注册的层
function UserReg()
{
	var UserRegWin = new UserRegWindow();
	UserRegWin.show();
}
//修改信息
function EditUser(id)
{
		var EditUserWin = new Ext.Window({
			title : '修改注册信息', 
			width : 500, 
			iconCls:"icon-AddUser", 
			modal:true,
			height : 350, 
			defaults : { border : false }, 
			buttonAlign : 'center', 
			createFormPanel :function() {
				return new Ext.form.FormPanel({
					bodyStyle : 'padding-top:6px', 
					defaultType : 'textfield', 
					labelAlign : 'right', 
					labelWidth : 100, 
					labelPad : 0, 
					frame : true, 
					defaults : { 
						allowBlank : false, 
						width : 300, 
						selectOnFocus:true 
					}, 
					items : [{
						xtype:"combo",
						name:'UserType',
						fieldLabel:'会员类型',
						displayField:'name',
						valueField:'code',
						store:new Ext.data.SimpleStore({
						fields:['name','code'],	
						data:[["机构",0],["企业",1],["专家",2],["医生",3],["个人",4],["记者",5]]
						}),
						triggerAction:'all',
						mode:'local',
						selectOnFocus:true,
						forceSelection: true,
						allowBlank:false,
						//editable: false,
						hiddenName:'UserType',
						emptyText:'请选择会员类型',
						blankText : '请选择会员类型'
					},
					{
						xtype:"textfield",
						name:'UserName',
						fieldLabel:'用户名',
						emptyText:'填写用户名',
						blankText : '用户名不能为空' 
						//readOnly:true 		//设置input属性为只读
					},
					{
						xtype:"textfield",
						name : 'RealName', 
						fieldLabel : '姓名', 
						emptyText:'填写真实姓名',
						blankText : '姓名不能为空'
						
					}, 
					{ 
						name : 'PaddWord', 
						fieldLabel : '用户密码', 
						blankText : '密码不能为空', 
						//emptyText:'填写用户密码',
						inputType : 'password' 
					}, 
					{
						xtype:"textfield",
						name : 'UserAdd', 
						fieldLabel : '省市地区', 
						emptyText:'请选择省市',
						blankText : '请选择省市'
					}, 
					{
						xtype:"textfield",
						name : 'UserUnits', 
						fieldLabel : '单位', 
						emptyText:'填写您的单位名称',
						blankText : '单位名称不能为空'
					}, 
					{
						xtype:"textfield",
						name : 'UserDuty', 
						fieldLabel : '职务', 
						emptyText:'填写您的职务名称',
						blankText : '职务不能为空'
					}, 
					{
						xtype:"textfield",
						name : 'UserTitle', 
						fieldLabel : '职称', 
						emptyText:'填写您的职称',
						blankText : '职称不能为空'
					}, 
					{
						xtype:"textfield",
						id:'Usertxdz',
						name : 'Usertxdz', 
						fieldLabel : '通讯地址', 
						emptyText:'选择省市地区后，会自动添加相应的通讯地址',
						readOnly:true,
						blankText : '通讯地址不能为空'
					}, 
					{
						xtype:"datefield",
						name : 'JoinTime', 
						fieldLabel : '添加时间',
						format:"Y-n-j",
						emptyText:'选择您的加入时间',
						blankText : '添加时间不能为空'
					}] }); }, 
			save:function() { 
				if(this.fp.form.isValid()){
				this.fp.form.submit({
					waitTitle:"请稍候", 
					waitMsg : "正在保存...", 
					url : 'service.asp?cmd=Update', 
					success : function(form, action) {
						var Result = action.result.success; 
						if(Result == false){
							alert(action.result.message);
							} else if(Result == true){
								Ext.Msg.alert("提示！","用户信息修改成功！");
							} 
					}, 
					failure : function(form, action) { 
						Ext.MessageBox.alert('提示', action.result.message);
					}, scope:this }); }}, 
			initComponent : function(){ 
				this.keys={ key: Ext.EventObject.ENTER, fn: this.save, scope: this}; 
				UserRegWindow.superclass.initComponent.call(this); 
				this.fp=this.createFormPanel();
				this.fp.form.load({
					url : 'service.asp?cmd=UserInfo&id='+id+'',
					success : function(form,action) {},
					failure : function(form,action) {
						Ext.Msg.alert("提示！","用户信息加载失败，请检查数据！",function(btn){
							if(btn=='ok')
							{
								EditUserWin.close();
							}
						});
					}
				});
				this.add(this.fp); 
				this.addButton('提交',this.save,this); 
				this.addButton('取消', function(){this.close();},this); this.on("close",function(){}) } });
		EditUserWin.show();
}