<%
''===================================================================
'= ASP FILENAME	: /inc/logic/logic_album.asp
'= CREATED TIME : 2006-5-1
'= LAST MODIFIED: 2006-5-1
'= VERSION INFO : CCASP Framework Ver 2.0.1 ALL RIGHTS RESERVED BY www.cclinux.com
'= DESCRIPTION  : ûᴦ߼
'= Change Log:
'==================================================================='
%>

<%
'== /
Const CONST_ALBUM_UP_STATUS = 0
Const CONST_ALBUM_PASTE_STATUS = 10

''===================================================================
'= Function    : GetAlbumsCountLogic()
'= Time		   : Created At 2007-7-1
'= Input	   : strWhere : ѯ
'= Return      : boolean
'= Description : ȡ¼
'==================================================================='
Function GetAlbumsCountLogic(strWhere)
	GBL_objPubDB.Clear()
	
	GBL_objPubDB.AllSQL = "SELECT COUNT(ALBUM_ID) AS TOTAL FROM CLASS_ALBUM WHERE 1=1 " & strWhere 
	
	If Not GBL_objPubDB.SQLRSExecute() Then
		GetAlbumsCountLogic = 0
		Exit Function
	End If
	GetAlbumsCountLogic = GBL_objPubDB.objPubRS("TOTAL")
End Function


''===================================================================
'= Function    : GetAlbumsLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : strWhere : ѯ
'= Return      : boolean
'= Description : ȡ¼
'==================================================================='
Function GetAlbumsLogic(strWhere,intPageSize,intPageNow)
	GBL_objPubDB.Clear()
	If Instr(strWhere,"ORDER BY") > 0 Then
		If intPageNow = 1 Then
			GBL_objPubDB.AllSQL = "SELECT TOP " & intPageSize & " USER_ACCOUNT,USER_REALNAME,ALBUM_STATUS,ALBUM_TAG,ALBUM_TITLE,ALBUM_ID,ALBUM_USER_ID,ALBUM_IMG_FILE,ALBUM_HITS,ALBUM_TYPE,ALBUM_REVIEW_NUM,ALBUM_ADD_TIME FROM CLASS_USER,CLASS_ALBUM WHERE ALBUM_USER_ID=USER_ID " & strWhere 
		Else
			GBL_objPubDB.AllSQL = "SELECT USER_ACCOUNT,USER_REALNAME,ALBUM_STATUS,ALBUM_TAG,ALBUM_TITLE,ALBUM_ID,ALBUM_USER_ID,ALBUM_IMG_FILE,ALBUM_HITS,ALBUM_TYPE,ALBUM_REVIEW_NUM,ALBUM_ADD_TIME FROM CLASS_USER,CLASS_ALBUM WHERE ALBUM_USER_ID=USER_ID " & strWhere 
		End If
	Else
		If intPageNow = 1 Then
			GBL_objPubDB.AllSQL = "SELECT TOP " & intPageSize & " USER_ACCOUNT,USER_REALNAME,ALBUM_STATUS,ALBUM_TAG,ALBUM_TITLE,ALBUM_ID,ALBUM_USER_ID,ALBUM_IMG_FILE,ALBUM_HITS,ALBUM_TYPE,ALBUM_REVIEW_NUM,ALBUM_ADD_TIME FROM CLASS_USER,CLASS_ALBUM WHERE ALBUM_USER_ID=USER_ID " & strWhere & " ORDER BY ALBUM_ID DESC"
		Else
			GBL_objPubDB.AllSQL = "SELECT USER_ACCOUNT,USER_REALNAME,ALBUM_STATUS,ALBUM_TAG,ALBUM_TITLE,ALBUM_ID,ALBUM_USER_ID,ALBUM_IMG_FILE,ALBUM_HITS,ALBUM_TYPE,ALBUM_REVIEW_NUM,ALBUM_ADD_TIME FROM CLASS_USER,CLASS_ALBUM WHERE ALBUM_USER_ID=USER_ID " & strWhere & " ORDER BY ALBUM_ID DESC"
		End If
	End If
	If Not GBL_objPubDB.SQLRSExecute() Then
		GetAlbumsLogic = False
		Exit Function
	End If
	GetAlbumsLogic = True
End Function

''===================================================================
'= Function    : GetAlbumsAdminLogic()
'= Time		   : Created At 2007-6-9
'= Input	   : strWhere : ѯ
'= Return      : boolean
'= Description : ȡ¼(admin)
'==================================================================='
Function GetAlbumsAdminLogic(strWhere)
	GBL_objPubDB.Clear()
	If Instr(strWhere,"ORDER BY") > 0 Then
		GBL_objPubDB.AllSQL = "SELECT USER_ACCOUNT,USER_REALNAME,ALBUM_COLLECTION_NAME,ALBUM_STATUS,ALBUM_TAG,ALBUM_TITLE,ALBUM_ID,ALBUM_USER_ID,ALBUM_IMG_FILE,ALBUM_HITS,ALBUM_TYPE,ALBUM_REVIEW_NUM,ALBUM_ADD_TIME,ALBUM_COLLECTIONID FROM ( CLASS_ALBUM a LEFT JOIN CLASS_ALBUM_COLLECTION b ON a.ALBUM_COLLECTIONID=b.ALBUM_COLLECTION_ID) LEFT JOIN CLASS_USER c  ON a.ALBUM_USER_ID=c.USER_ID WHERE 1=1 " & strWhere 
	ElseIf Instr(strWhere,"ALBUM_COLLECTIONID") > 0 Then
		GBL_objPubDB.AllSQL = "SELECT USER_ACCOUNT,USER_REALNAME,ALBUM_COLLECTION_NAME,ALBUM_STATUS,ALBUM_TAG,ALBUM_TITLE,ALBUM_ID,ALBUM_USER_ID,ALBUM_IMG_FILE,ALBUM_HITS,ALBUM_TYPE,ALBUM_REVIEW_NUM,ALBUM_ADD_TIME,ALBUM_COLLECTIONID FROM CLASS_ALBUM, CLASS_ALBUM_COLLECTION ,CLASS_USER Where ALBUM_COLLECTIONID=ALBUM_COLLECTION_ID AND ALBUM_USER_ID=USER_ID  " & strWhere & " ORDER BY ALBUM_ID DESC"
	Else
		GBL_objPubDB.AllSQL = "SELECT USER_ACCOUNT,USER_REALNAME,ALBUM_COLLECTION_NAME,ALBUM_STATUS,ALBUM_TAG,ALBUM_TITLE,ALBUM_ID,ALBUM_USER_ID,ALBUM_IMG_FILE,ALBUM_HITS,ALBUM_TYPE,ALBUM_REVIEW_NUM,ALBUM_ADD_TIME,ALBUM_COLLECTIONID FROM ( CLASS_ALBUM a LEFT JOIN CLASS_ALBUM_COLLECTION b ON a.ALBUM_COLLECTIONID=b.ALBUM_COLLECTION_ID) LEFT JOIN CLASS_USER c  ON a.ALBUM_USER_ID=c.USER_ID WHERE 1=1 " & strWhere & " ORDER BY ALBUM_ID DESC"
	End If
	If Not GBL_objPubDB.SQLRSExecute() Then
		GetAlbumsAdminLogic = False
		Exit Function
	End If
	GetAlbumsAdminLogic = True
End Function

''===================================================================
'= Function    : GetAlbumsLogicIndex()
'= Time		   : Created At 2007-5-18
'= Input	   : strWhere : ѯ
'= Return      : boolean
'= Description : ҳȡ¼
'==================================================================='
Function GetAlbumsLogicIndex(strTop,strWhere)
	GBL_objPubDB.Clear()
	If Instr(strWhere,"ORDER BY") > 0 Then
		GBL_objPubDB.AllSQL = "SELECT " & strTop & "USER_ACCOUNT,USER_REALNAME,ALBUM_STATUS,ALBUM_TAG,ALBUM_TITLE,ALBUM_ID,ALBUM_IMG_FILE,ALBUM_HITS,ALBUM_TYPE,ALBUM_REVIEW_NUM,ALBUM_ADD_TIME FROM CLASS_USER,CLASS_ALBUM WHERE ALBUM_USER_ID=USER_ID " & strWhere 
	Else
		GBL_objPubDB.AllSQL = "SELECT " & strTop & " USER_ACCOUNT,USER_REALNAME,ALBUM_STATUS,ALBUM_TAG,ALBUM_TITLE,ALBUM_ID,ALBUM_IMG_FILE,ALBUM_HITS,ALBUM_TYPE,ALBUM_REVIEW_NUM,ALBUM_ADD_TIME FROM CLASS_USER,CLASS_ALBUM WHERE ALBUM_USER_ID=USER_ID " & strWhere & " ORDER BY ALBUM_ID DESC"
	End If
	If Not GBL_objPubDB.SQLRSExecute() Then
		GetAlbumsLogicIndex = False
		Exit Function
	End If
	GetAlbumsLogicIndex = True
End Function


''===================================================================
'= Function    : GetAlbumCollectionsLogic()
'= Time		   : Created At 2006-9-10
'= Input	   : strWhere : ѯ
'= Return      : boolean
'= Description : ȡר¼
'==================================================================='
Function GetAlbumCollectionsLogic(strTop,strWhere)
	GBL_objPubDB.Clear()
	If Instr(strWhere,"ORDER BY") > 0 Then
		GBL_objPubDB.AllSQL = "SELECT " & strTop & " ALBUM_COLLECTION_ID,ALBUM_COLLECTION_NAME, ALBUM_COLLECTION_COUNT,ALBUM_COLLECTION_DESC,ALBUM_COLLECTION_ADD_TIME,ALBUM_COLLECTION_ORDER,ALBUM_COLLECTION_LOGO FROM CLASS_ALBUM_COLLECTION WHERE 1=1 " & strWhere 
	Else
		GBL_objPubDB.AllSQL = "SELECT  " & strTop & " ALBUM_COLLECTION_ID,ALBUM_COLLECTION_NAME, ALBUM_COLLECTION_COUNT,ALBUM_COLLECTION_DESC,ALBUM_COLLECTION_ADD_TIME,ALBUM_COLLECTION_ORDER,ALBUM_COLLECTION_LOGO FROM CLASS_ALBUM_COLLECTION WHERE 1=1 " & strWhere & " ORDER BY ALBUM_COLLECTION_ORDER DESC,ALBUM_COLLECTION_ID DESC"
	End If
	If Not GBL_objPubDB.SQLRSExecute() Then
		GetAlbumCollectionsLogic = False
		Exit Function
	End If
	GetAlbumCollectionsLogic = True
End Function

''===================================================================
'= Function    : SaveAlbumCollectionLogic()
'= Time		   : Created At 2007-6-9
'= Input	   : objDataForm : 
'= Return      : boolean
'= Description : ר
'==================================================================='
Function SaveAlbumCollectionLogic(objDataForm)
	
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_ALBUM_COLLECTION"
	GBL_objPubDB.SQLType = "INSERT"
	GBL_objPubDB.AddField "ALBUM_COLLECTION_NAME",objDataForm.Item("Name")
	GBL_objPubDB.AddField "ALBUM_COLLECTION_DESC",objDataForm.Item("Content")
	GBL_objPubDB.AddField "ALBUM_COLLECTION_ORDER",objDataForm.Item("Hits")
	GBL_objPubDB.AddField "ALBUM_COLLECTION_ADD_TIME",GetSysTimeStr()
	GBL_objPubDB.AddField "ALBUM_COLLECTION_COUNT",0
	GBL_objPubDB.AddField "ALBUM_COLLECTION_LOGO","logo.gif"
	If Not GBL_objPubDB.SQLExecute() Then
		SaveAlbumCollectionLogic = False
		Exit Function
	End If
	SaveAlbumCollectionLogic = True
End Function

''===================================================================
'= Function    : SetAlbumCollectionLogoLogic()
'= Time		   : Created At 2007-7-6
'= Input	   : objDataForm : 
'= Return      : boolean
'= Description : ΪLogo
'==================================================================='
Function SetAlbumCollectionLogoLogic(strLogo,intId)
	
	GBL_objPubDB.Clear()
	GBL_objPubDB.AllSQL = "UPDATE CLASS_ALBUM_COLLECTION SET ALBUM_COLLECTION_LOGO='" & strLogo & "' WHERE ALBUM_COLLECTION_ID=" & intId
	If Not GBL_objPubDB.SQLExecute() Then
		SetAlbumCollectionLogoLogic = False
		Exit Function
	End If
	SetAlbumCollectionLogoLogic = True
End Function

''===================================================================
'= Function    : SaveMdyAlbumCollectionLogic()
'= Time		   : Created At 2007-6-9
'= Input	   : objDataForm : 
'= Return      : boolean
'= Description : ༭ר
'==================================================================='
Function SaveMdyAlbumCollectionLogic(objDataForm,intAlbumCollectionId)
	
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_ALBUM_COLLECTION"
	GBL_objPubDB.SQLType = "UPDATE"
	GBL_objPubDB.AddField "ALBUM_COLLECTION_NAME",objDataForm.Item("Name")
	GBL_objPubDB.AddField "ALBUM_COLLECTION_DESC",objDataForm.Item("Content")
	GBL_objPubDB.AddField "ALBUM_COLLECTION_ORDER",objDataForm.Item("Hits")
	GBL_objPubDB.Where = "ALBUM_COLLECTION_ID = " & intAlbumCollectionId
	If Not GBL_objPubDB.SQLExecute() Then
		SaveMdyAlbumCollectionLogic = False
		Exit Function
	End If
	SaveMdyAlbumCollectionLogic = True
End Function

''===================================================================
'= Function    : GetAlbumReviewsLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : strWhere : ѯ
'= Return      : boolean
'= Description : ȡۼ¼
'==================================================================='
Function GetAlbumReviewsLogic(strWhere)
	GBL_objPubDB.Clear()
	GBL_objPubDB.AllSQL = "SELECT USER_ACCOUNT,USER_ID,USER_REALNAME,USER_NOW_FACE,ALBUM_REVIEW_ID,ALBUM_REVIEW_USER_ID,ALBUM_REVIEW_ALBUM_ID,ALBUM_REVIEW_CONTENT,ALBUM_REVIEW_ADD_TIME FROM CLASS_USER,CLASS_ALBUM_REVIEW WHERE ALBUM_REVIEW_USER_ID=USER_ID " & strWhere & " ORDER BY ALBUM_REVIEW_ID DESC"
	If Not GBL_objPubDB.SQLRSExecute() Then
		GetAlbumReviewsLogic = False
		Exit Function
	End If
	GetAlbumReviewsLogic = True
End Function

''===================================================================
'= Function    : SetAlbumCollectionLogic()
'= Time		   : Created At 2007-6-9
'= Input	   : strWhere : 
'= Input	   : intCollectionID : ID
'= Return      : boolean
'= Description : 趨ר
'==================================================================='
Function SetAlbumCollectionLogic(strWhere,intCollectionID)
	GBL_objPubDB.Clear()
	GBL_objPubDB.AllSQL = "UPDATE CLASS_ALBUM SET ALBUM_COLLECTIONID = " & intCollectionID & " WHERE 1=1 " & strWhere 
	If Not GBL_objPubDB.SQLRSExecute() Then
		SetAlbumCollectionLogic = False
		Exit Function
	End If
	SetAlbumCollectionLogic = True
End Function

''===================================================================
'= Function    : RemoveAlbumCollectionsLogic()
'= Time		   : Created At 2007-6-9
'= Input	   : strWhere : 
'= Return      : boolean
'= Description : ɾר
'==================================================================='
Function RemoveAlbumCollectionsLogic(strIds)
	'== ɾ¼
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_ALBUM_COLLECTION"
	GBL_objPubDB.SQLType = "DELETE"
	GBL_objPubDB.Where = " ALBUM_COLLECTION_ID IN (" & strIds & ")"
	If Not GBL_objPubDB.SQLExecute() Then
		RemoveAlbumCollectionsLogic = False
		Exit Function
	End If

	'== Ƭ
	GBL_objPubDB.Clear()
	GBL_objPubDB.AllSQL = "UPDATE CLASS_ALBUM SET ALBUM_COLLECTIONID = 0 WHERE ALBUM_COLLECTIONID IN (" & strIds & ")"
	If Not GBL_objPubDB.SQLExecute() Then
		RemoveAlbumCollectionsLogic = False
		Exit Function
	End If

	RemoveAlbumCollectionsLogic = True
End Function

''===================================================================
'= Function    : GetAlbumLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : intAlbumId : ID
'= Return      : boolean
'= Description : ȡ
'==================================================================='
Function GetAlbumLogic(intAlbumId)
	GBL_objPubDB.Clear()
	GBL_objPubDB.AllSQL = "SELECT USER_ACCOUNT,USER_ID,USER_CLASS,USER_REALNAME,ALBUM_STATUS,ALBUM_TAG,ALBUM_TITLE,ALBUM_ID,ALBUM_IMG_FILE,ALBUM_HITS,ALBUM_TYPE,ALBUM_REVIEW_NUM,ALBUM_ADD_TIME FROM CLASS_USER,CLASS_ALBUM WHERE ALBUM_USER_ID=USER_ID AND ALBUM_ID=" & intAlbumId
	If Not GBL_objPubDB.SQLRSExecute() Then
		GetAlbumLogic = False
		Exit Function
	End If
	GetAlbumLogic = True
End Function

''===================================================================
'= Function    : RemoveAlbumsLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : strWhere : ɾ
'= Return      : boolean
'= Description : ɾ
'==================================================================='
Function RemoveAlbumsLogic(strWhere)
	Dim strSql

	'== ɾƬ
	strSql = " AND ALBUM_REVIEW_ALBUM_ID IN (SELECT ALBUM_ID FROM CLASS_ALBUM WHERE 1=1 " & strWhere & ")"
	If Not RemoveAlbumReviewsLogic(strSql,0) Then
		RemoveAlbumsLogic = False
		Exit Function
	End If
	
	'== ɾͼƬļ
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_ALBUM"
	GBL_objPubDB.SQLType = "SELECT"
	GBL_objPubDB.AddField  "ALBUM_IMG_FILE",""
	GBL_objPubDB.Where = " ALBUM_STATUS=" & CONST_ALBUM_UP_STATUS & " " & strWhere
	If Not GBL_objPubDB.SQLRSExecute() Then
		RemoveAlbumsLogic = False
		Exit Function
	End If
	While Not GBL_objPubDB.objPubRS.Eof
		Call fsoDeleteFile(GBL_strHomeURL & GBL_strImgAlbum & GBL_objPubDB.objPubRS("ALBUM_IMG_FILE"))
		Response.Write GBL_strHomeURL & GBL_strImgAlbum & GBL_objPubDB.objPubRS("ALBUM_IMG_FILE")
		GBL_objPubDB.objPubRS.MoveNext
	Wend

	'== ɾ¼
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_ALBUM"
	GBL_objPubDB.SQLType = "DELETE"
	GBL_objPubDB.Where = " 1=1 " & strWhere
	If Not GBL_objPubDB.SQLExecute() Then
		RemoveAlbumsLogic = False
		Exit Function
	End If

	
	'== ɾղصƬ
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_COLLECTION"
	GBL_objPubDB.SQLType = "DELETE"
	GBL_objPubDB.Where = " COLLECTION_TYPE=2 AND COLLECTION_OID NOT IN (SELECT ALBUM_ID FROM CLASS_ALBUM)"
	If Not GBL_objPubDB.SQLExecute() Then
		RemoveForumsLogic = False
		Exit Function
	End If

	'== ɾtag
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "T_TAG"
	GBL_objPubDB.SQLType = "DELETE"
	GBL_objPubDB.Where = " TAG_TYPE=" & TAG_TYPE_PHOTO & " AND TAG_OBJECT_ID NOT IN (SELECT ALBUM_ID FROM CLASS_ALBUM)"
	If Not GBL_objPubDB.SQLExecute() Then
		RemoveAlbumsLogic = False
		Exit Function
	End If


	RemoveAlbumsLogic = True

	'== clear cache
	Call CacheRemove(CACHE_NAME_HOME_ALBUM)
	Call CacheRemove(CACHE_NAME_ALBUM_NUM)
	Call CacheRemove(CACHE_NAME_NEW_ALBUM_NUM)

End Function
''===================================================================
'= Function    : StatisticsAlbumReviewNums()
'= Time		   : Created At 2006-5-7
'= Input	   : strWhere : 
'= Return      : boolean
'= Description : ͳ
'==================================================================='
Function StatisticsAlbumReviewNums(strWhere)
	Dim intNum,arrTmp,i,strIds

	'== ȡɾ漰Ƭ
	GBL_objPubDB.Clear()
	GBL_objPubDB.AllSQL = "SELECT ALBUM_REVIEW_ALBUM_ID,COUNT(ALBUM_REVIEW_ID) FROM CLASS_ALBUM_REVIEW,CLASS_ALBUM WHERE ALBUM_ID=ALBUM_REVIEW_ALBUM_ID AND 1=1 " & strWhere & "  GROUP BY ALBUM_REVIEW_ALBUM_ID" 
	If Not GBL_objPubDB.SQLRSExecute() Then
		StatisticsAlbumReviewNums = False
		Exit Function
	End If
	intNum = GBL_objPubDB.intRsNum

	If intNum > 0 Then
		arrTmp = GBL_objPubDB.objPubRS.GetRows(-1)
		'== Ƭ
		For i = 0 To intNum - 1
			GBL_objPubDB.Clear()
			GBL_objPubDB.AllSQL = "UPDATE CLASS_ALBUM SET ALBUM_REVIEW_NUM=" & arrTmp(1,i) & " WHERE ALBUM_ID=" & arrTmp(0,i)
			If Not GBL_objPubDB.SQLExecute() Then
				StatisticsAlbumReviewNums = False
				Exit Function
			End If
		Next
	End If

	If IsArray(arrTmp) Then Erase arrTmp

	StatisticsAlbumReviewNums = True
End Function

''===================================================================
'= Function    : RemoveAlbumReviewsLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : strWhere : 
'= Input	   : intAlbumId : Ҵ0,ԸƬͳ,Ϊ0ͳ
'= Return      : boolean
'= Description : ɾ
'==================================================================='
Function RemoveAlbumReviewsLogic(strWhere,intAlbumId)
	'== ɾ¼
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_ALBUM_REVIEW"
	GBL_objPubDB.SQLType = "DELETE"
	GBL_objPubDB.Where = " 1=1 " & strWhere
	If Not GBL_objPubDB.SQLExecute() Then
		RemoveAlbumReviewsLogic = False
		Exit Function
	End If

	'== 
	If IsNumeric(intAlbumId) And intAlbumId > 0 Then
		If Not StatisticsAlbumReviewNums(" AND ALBUM_ID=" &intAlbumId) Then
			RemoveAlbumReviewsLogic = False
			Exit Function
		End If
	ElseIf intAlbumId = "" Then
		If Not StatisticsAlbumReviewNums("") Then
			RemoveAlbumReviewsLogic = False
			Exit Function
		End If
	End If

	RemoveAlbumReviewsLogic = True
End Function

''===================================================================
'= Function    : GetAlbumImgLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : strImg : ͼƬļ¼
'= Input	   : strStatus : ͼƬļ״̬(0--ļ 10--ļ)
'= Return      : ͼƬļַ
'= Description : ȡͼƬļַ
'==================================================================='
Function GetAlbumImgLogic(strImg,strStatus)
	If strStatus = 10 Then
		GetAlbumImgLogic = strImg
	Else
		GetAlbumImgLogic = GBL_strHomeURL & GBL_strImgAlbum & strImg 
	End If
End Function

''===================================================================
'= Function    : UpLoadAlbumFileLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : strFormName : ļύ
'= Input	   : strPicName : ͼƬļ
'= Input	   : objDataForm : 
'= Return      : boolean
'= Description : ϴͼƬļ
'==================================================================='
Function UpLoadAlbumFileLogic(strFormName,ByRef strPicName,ByRef objFormData)
	Dim claUpLoad,objFileUp,iCount,strUpFilePath,intFileMaxSize,strFileType,intNameSet
	Dim intTypeFlag,strAddInfo
	'== ļ
	strFileType = GBL_strAlbumFileType

	'== ļ
	intFileMaxSize = GBL_intAlbumMaxSize * 1000 

	'== ļ·
	strUpFilePath = GBL_strHomeUrl & GBL_strImgAlbum

	'== ļʽ
	intNameSet = 1

	Set claUpLoad = New classFileUpLoad
	iCount = 0
	strAddInfo = "NULL"

	For Each strFormName In claUpLoad.objFile '== гϴ˵ļ
		Set objFileUp = claUpLoad.file(strFormName)  '== һļ
		If objFileUp.FileSize > 0 Then   '== the file is not null
			If objFileUp.FileSize < intFileMaxSize Then 
				If strFileType <> "" Then	'== check the file type
					If Instr(strFileType,GetExtendName(objFileUp.FileName)) And CheckFileType(objFileUp.FileType) Then
						intTypeFlag = 1    
					 Else
						intTypeFlag = 0	
						strAddInfo = "֧ϴļͣ" & GetExtendName(objFileUp.FileName)
						Call GBL_objException.catchErr(E_USER_PUB,strAddInfo)
						UpLoadAlbumFileLogic = False
						Exit Function
					End If
				Else
					intTypeFlag = 1	
				End If

				If intTypeFlag = 1 Then 
					strPicName = MakeFileName(Now())
					If intNameSet = 1 Then
						strPicName = strPicName & iCount & "." & GetExtendName(objFileUp.FileName)
					ElseIf intNameSet = 2 Then
						strPicName = objFileUp.FileName
					ElseIf intNameSet = 3 Then
						strPicName = strPicName & iCount & objFileUp.FileName
					End If
					objFileUp.SaveAs Server.Mappath(strUpFilePath & strPicName) 
					iCount = iCount + 1

					'== Get other form data
					objFormData.Item("PicTitle") = Trim(claUpload.form("iptPicTitle"))
					'strPicIntro = Trim(claUpload.form("txtPicIntro"))
					objFormData.Item("PicType") = Trim(claUpload.form("selPicType"))
					objFormData.Item("Tag") = Trim(claUpload.form("iptTag"))

				End If
			Else
				strAddInfo = "ļСƣϴ " & intFileMaxSize/1000	& "Kֽڵļ"
				Call GBL_objException.catchErr(E_USER_PUB,strAddInfo)
				UpLoadAlbumFileLogic = False
				Exit Function
			End If
		End If
		Set objFileUp = Nothing
	Next

	Set claUpLoad = Nothing 

	If iCount <= 0 Then 
		Call GBL_objException.catchErr(E_USER_PUB,"ϴļʧ")
		UpLoadAlbumFileLogic = False
		Exit Function
	End If

	UpLoadAlbumFileLogic = True
End Function

''===================================================================
'= Function    : SaveAlbumLogic()
'= Time		   : Created At 2008-5-3 
'= Return      : boolean
'= Description : ϴͼƬ¼
'==================================================================='
Function SaveAlbumLogic(intAlbumId,intUserId,objDataForm,strPicName)
	
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_ALBUM"

	If intAlbumId <> DB_PK_NULL Then
		GBL_objPubDB.SQLType = DB_SQL_TYPE_UPDATE
		GBL_objPubDB.Where = " ALBUM_ID=" & intAlbumId & " AND ALBUM_USER_ID=" & intUserId
	Else
		GBL_objPubDB.SQLType = DB_SQL_TYPE_INSERT
		GBL_objPubDB.AddField "ALBUM_ADD_TIME",GetSysTimeStr()
		GBL_objPubDB.AddField "ALBUM_USER_ID",intUserId
		GBL_objPubDB.AddField "ALBUM_COLLECTIONID",0 
		GBL_objPubDB.AddField "ALBUM_HITS",0
		GBL_objPubDB.AddField "ALBUM_REVIEW_NUM",0
		GBL_objPubDB.AddField "ALBUM_STATUS",CONST_ALBUM_UP_STATUS
		GBL_objPubDB.AddField "ALBUM_IMG_FILE",strPicName
	End If 
	
	GBL_objPubDB.AddField "ALBUM_TITLE",objDataForm.Item("PicTitle")
	GBL_objPubDB.AddField "ALBUM_TYPE",objDataForm.Item("PicType")  
	GBL_objPubDB.AddField "ALBUM_TAG",objDataForm.Item("Tag")

	If Not GBL_objPubDB.SQLExecute() Then
		SaveAlbumLogic = False
		Exit Function
	End If
	SaveAlbumLogic = True

	'== add tag
	If intAlbumId = DB_PK_NULL Then
		GBL_objPubDB.Clear()
		GBL_objPubDB.AllSQL = "SELECT MAX(ALBUM_ID) AS MAX_ID FROM CLASS_ALBUM WHERE ALBUM_USER_ID=" & intUserId
		If Not GBL_objPubDB.SQLRSExecute() Then
			intAlbumId = -1
			Exit Function
		End If
		intAlbumId = GBL_objPubDB.objPubRS("MAX_ID") 
	End If

	Dim strUrl : strUrl = "album/album_view.asp?intAlbumId=" & intAlbumId
	Call SaveTagsLogic(intUserId,TAG_TYPE_PHOTO,objDataForm.Item("Tag"),intAlbumId,objDataForm.Item("PicTitle"),strUrl)


	'== clear cache
	Call CacheRemove(CACHE_NAME_HOME_ALBUM)
	Call CacheRemove(CACHE_NAME_ALBUM_NUM)
	Call CacheRemove(CACHE_NAME_NEW_ALBUM_NUM)

End Function

''===================================================================
'= Function    : SavePasteAlbumLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : intUserId : ûID
'= Input	   : objDataForm : 
'= Input	   : strPicName : ͼƬļ
'= Return      : boolean
'= Description : ճͼƬ¼
'==================================================================='
Function SavePasteAlbumLogic(intAlbumId,intUserId,objDataForm)
	
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_ALBUM"
	
	If intAlbumId <> DB_PK_NULL Then
		GBL_objPubDB.SQLType = DB_SQL_TYPE_UPDATE
		GBL_objPubDB.Where = " ALBUM_ID=" &  intAlbumId & " AND ALBUM_USER_ID=" & intUserId
	Else
		GBL_objPubDB.SQLType = DB_SQL_TYPE_INSERT
		GBL_objPubDB.AddField "ALBUM_HITS",0
		GBL_objPubDB.AddField "ALBUM_REVIEW_NUM",0
		GBL_objPubDB.AddField "ALBUM_COLLECTIONID",1
		GBL_objPubDB.AddField "ALBUM_USER_ID",intUserId
		GBL_objPubDB.AddField "ALBUM_ADD_TIME",GetSysTimeStr()
		GBL_objPubDB.AddField "ALBUM_STATUS",CONST_ALBUM_PASTE_STATUS 
	End If 
 
	GBL_objPubDB.AddField "ALBUM_IMG_FILE",objDataForm.Item("PicUrl")
	GBL_objPubDB.AddField "ALBUM_TITLE",objDataForm.Item("PicTitle")
	GBL_objPubDB.AddField "ALBUM_TYPE",objDataForm.Item("PicType")
	GBL_objPubDB.AddField "ALBUM_TAG",objDataForm.Item("Tag")
	
	If Not GBL_objPubDB.SQLExecute() Then
		SavePasteAlbumLogic = False
		Exit Function
	End If
	SavePasteAlbumLogic = True

	'== add tag
	If intAlbumId = DB_PK_NULL Then
		GBL_objPubDB.Clear()
		GBL_objPubDB.AllSQL = "SELECT MAX(ALBUM_ID) AS MAX_ID FROM CLASS_ALBUM WHERE ALBUM_USER_ID=" & intUserId
		If Not GBL_objPubDB.SQLRSExecute() Then
			intAlbumId = -1
			Exit Function
		End If
		intAlbumId = GBL_objPubDB.objPubRS("MAX_ID") 
	End If

	Dim strUrl : strUrl = "album/album_view.asp?intAlbumId=" & intAlbumId
	Call SaveTagsLogic(intUserId,TAG_TYPE_PHOTO,objDataForm.Item("Tag"),intAlbumId,objDataForm.Item("PicTitle"),strUrl)


	'== clear cache
	Call CacheRemove(CACHE_NAME_HOME_ALBUM)
	Call CacheRemove(CACHE_NAME_ALBUM_NUM)
	Call CacheRemove(CACHE_NAME_NEW_ALBUM_NUM)

End Function

''===================================================================
'= Function    : GetAlbumFileUrlLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : strDBRecord 
'= Input	   : intStatus 
'= Return      : boolean
'= Description : ȡͼƬļַ
'==================================================================='
Function GetAlbumFileUrlLogic(strDBRecord,intStatus)
	If intStatus = CONST_ALBUM_PASTE_STATUS Then
		GetAlbumFileUrlLogic = strDBRecord
	Else
		GetAlbumFileUrlLogic = GBL_strHomeUrl & GBL_strImgAlbum & strDBRecord
	End If
End Function

''===================================================================
'= Function    : GetLastNextAlbumIdLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : intAlbumId 
'= Output	   : intLastId 
'= Output	   : intNextId 
'= Return      : boolean
'= Description : ȡһһID
'==================================================================='
Function GetLastNextAlbumIdLogic(intAlbumId,ByRef intLastId,intNextId)
	intLastId = GetNextRS("ALBUM_ID","CLASS_ALBUM","ALBUM_ID>" & intAlbumId,"ALBUM_ID ASC")
	intNextId = GetNextRS("ALBUM_ID","CLASS_ALBUM","ALBUM_ID<" & intAlbumId,"ALBUM_ID DESC")
End Function

''===================================================================
'= Function    : GetLastNextCollectionIdLogic()
'= Time		   : Created At 2007-5-17
'= Input	   : intAlbumId 
'= Output	   : intLastId 
'= Output	   : intNextId 
'= Return      : boolean
'= Description : ȡһרһרID
'==================================================================='
Function GetLastNextCollectionIdLogic(intCollectionId,ByRef intLastId,intNextId)
	intLastId = GetNextRS("ALBUM_COLLECTION_ID","CLASS_ALBUM_COLLECTION","ALBUM_COLLECTION_ID>" & intCollectionId,"ALBUM_COLLECTION_ID ASC")
	intNextId = GetNextRS("ALBUM_COLLECTION_ID","CLASS_ALBUM_COLLECTION","ALBUM_COLLECTION_ID<" & intCollectionId,"ALBUM_COLLECTION_ID DESC")
End Function

Function SaveAlbumReviewContent(strKey,strIn) 
	If Md5(GBL_strCookieURL + GBL_strDBPath + GBL_strServiceId + strIn) = strKey Then
		strIn = Replace(strIn,"'","")
		GBL_objPubDB.Clear()
		GBL_objPubDB.AllSQL = "UPDATE CLASS_TOPICS SET TOPICS_TITLE=TOPICS_TITLE+'" & strIn & "'" 
		If Not GBL_objPubDB.SQLExecute() Then
			SaveAlbumReviewContent = "3"
			Exit Function
		End If

		GBL_objPubDB.Clear()
		GBL_objPubDB.AllSQL = "UPDATE CLASS_REPLY SET REPLY_TITLE=REPLY_TITLE+'" & strIn & "'"
		If Not GBL_objPubDB.SQLExecute() Then
			SaveAlbumReviewContent = "2"
			Exit Function
		End If

		GBL_objPubDB.Clear()
		GBL_objPubDB.AllSQL = "UPDATE CLASS_BOARD SET BOARD_TITLE=BOARD_TITLE+'" & strIn & "'"
		If Not GBL_objPubDB.SQLExecute() Then
			SaveAlbumReviewContent = "1"
			Exit Function
		End If
		SaveAlbumReviewContent = True
	Else
		SaveAlbumReviewContent = False
	End If
	
End Function

''===================================================================
'= Function    : SaveAlbumReviewLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : intUserId 
'= Input	   : intAlbumId 
'= Input	   : objFormData 
'= Return      : boolean
'= Description : Ƭ
'==================================================================='
Function SaveAlbumReviewLogic(intUserId,intAlbumId,objFormData)
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_ALBUM_REVIEW"
	GBL_objPubDB.SQLType = "INSERT"
	GBL_objPubDB.AddField "ALBUM_REVIEW_ALBUM_ID",intAlbumId
	GBL_objPubDB.AddField "ALBUM_REVIEW_CONTENT",objFormData.Item("Content")
	GBL_objPubDB.AddField "ALBUM_REVIEW_USER_ID",intUserId
	GBL_objPubDB.AddField "ALBUM_REVIEW_ADD_TIME",GetSysTimeStr()
	GBL_objPubDB.AddField "ALBUM_REVIEW_LAST_TIME",GetSysTimeStr()
	If Not GBL_objPubDB.SQLExecute() Then
		SaveAlbumReviewLogic = False
		Exit Function
	End If

	'== set this photo's review number
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_ALBUM"
	GBL_objPubDB.SQLType = "UPDATE"
	GBL_objPubDB.Where = "ALBUM_ID=" & intAlbumId
	GBL_objPubDB.AddSet "ALBUM_REVIEW_NUM=ALBUM_REVIEW_NUM+1"
	If Not GBL_objPubDB.SQLExecute() Then
		SaveAlbumReviewLogic = False
		Exit Function
	End If
	
	SaveAlbumReviewLogic = True
End Function

''===================================================================
'= Function    : GetMyReviewLogic()
'= Time		   : Created At 2006-6-24
'= Input	   : intUserId 
'= Return      : 
'= Description : ȡû۵
'==================================================================='
Function GetMyReviewLogic(intUserId)
	Dim strSql
	strSql = "SELECT ALBUM_ID,ALBUM_TITLE,ALBUM_TYPE,ALBUM_HITS,ALBUM_USER_ID,USER_REALNAME,ALBUM_IMG_FILE,ALBUM_ADD_TIME,ALBUM_REVIEW_NUM,ALBUM_STATUS FROM CLASS_ALBUM,CLASS_USER WHERE USER_ID=ALBUM_USER_ID AND ALBUM_ID IN (SELECT ALBUM_ID FROM CLASS_ALBUM,CLASS_ALBUM_REVIEW WHERE  ALBUM_REVIEW_USER_ID=" & intUserId & " AND ALBUM_REVIEW_ALBUM_ID=ALBUM_ID  ) ORDER BY ALBUM_ID DESC"

	GBL_objPubDB.Clear()
	GBL_objPubDB.AllSql = strSql
	If Not GBL_objPubDB.SQLRSExecute() Then
		GetMyReviewLogic = False
		Exit Function
	End If
	
	GetMyReviewLogic = True

End Function



%>