<%
''===================================================================
'= ASP FILENAME	: /inc/logic/logic_tag.asp
'= CREATED TIME : 2007-11-11
'= LAST MODIFIED: 2007-11-11
'= VERSION INFO : CCASP Framework Ver 2.0.1 ALL RIGHTS RESERVED BY www.cclinux.com
'= DESCRIPTION  : tag logic function
'= Change Log:
'==================================================================='


''===================================================================
'= Function    : GetTagsLogic()
'= Time		   : Created At 2007-11-11
'= Input	   : strWhere : 
'= Return      : boolean
'= Description : get tag
'==================================================================='
Function GetTagsLogic(strWhere,intPageSize,intPageNow)
	GBL_objPubDB.Clear()
	If intPageNow = 1 Then
		GBL_objPubDB.AllSQL = "SELECT TOP " & intPageSize & " TAG_NAME,TAG_URL,TAG_ADD_TIME,TAG_TITLE,TAG_ID,TAG_TYPE,TAG_OBJECT_ID FROM T_TAG WHERE 1=1 " & strWhere & " ORDER BY TAG_ID DESC"
	Else
		GBL_objPubDB.AllSQL = "SELECT TAG_NAME,TAG_URL,TAG_ADD_TIME,TAG_TITLE,TAG_ID,TAG_TYPE,TAG_OBJECT_ID FROM T_TAG WHERE 1=1 " & strWhere & " ORDER BY TAG_ID DESC"
	End If
	If Not GBL_objPubDB.SQLRSExecute() Then
		GetTagsLogic = False
		Exit Function
	End If
	GetTagsLogic = True
End Function

''===================================================================
'= Function    : GetNewTagsLogic()
'= Time		   : Created At 2007-11-11
'= Input	   : strWhere : 
'= Return      : boolean
'= Description : get tag
'==================================================================='
Function GetNewTagsLogic(strWhere,intPageSize)
	 
	GBL_objPubDB.AllSQL = "SELECT TOP " & intPageSize & " *  FROM (SELECT DISTINCT(TAG_NAME) FROM (SELECT TOP 100 TAG_NAME FROM T_TAG ORDER BY TAG_ID DESC) t) c"

	If Not GBL_objPubDB.SQLRSExecute() Then
		GetNewTagsLogic = False
		Exit Function
	End If
	GetNewTagsLogic = True
End Function

''===================================================================
'= Function    : GetHotTags()
'= Time		   : Created At 2007-11-11
'= Input	   : strWhere : 
'= Return      : boolean
'= Description : get hot tag
'==================================================================='
Function GetHotTagsLogic(strWhere,intTop)
	GBL_objPubDB.AllSQL = "SELECT TOP " & intTop & " * FROM (SELECT COUNT(TAG_ID) AS CNT,TAG_NAME FROM T_TAG GROUP BY TAG_NAME) t  ORDER BY CNT DESC ,TAG_NAME DESC"

	If Not GBL_objPubDB.SQLRSExecute() Then
		GetHotTagsLogic = False
		Exit Function
	End If

	GetHotTagsLogic = True

End Function

''===================================================================
'= Function    : GetTagsArrayLogic()
'= Time		   : Created At 2008-1-10
'= Input	   : strWhere :  
'= Return      : boolean
'= Description :  for autocomplete
'==================================================================='
Function GetTagsArrayLogic(strWhere)
	Dim strHtml
	Dim strCacheName : strCacheName = CACHE_NAME_TAG_ARRAY
	If Not CacheExist(strCacheName) Then
		GBL_objPubDB.AllSQL = "SELECT * FROM (SELECT TOP 20 * FROM (SELECT DISTINCT(TAG_NAME) ,COUNT(1) AS TOTAL FROM T_TAG WHERE 1=1" & strWhere & " GROUP BY TAG_NAME) a ORDER BY TOTAL DESC) b ORDER BY TOTAL ASC"

		If Not GBL_objPubDB.SQLRSExecute() Then
			GetTagsArrayLogic = False
			Exit Function
		End If

		While Not GBL_objPubDB.objPubRS.Eof 
			strHtml = strHtml & "[""" & GBL_objPubDB.objPubRS("TAG_NAME") & """,""" &  GBL_objPubDB.objPubRS("TAG_NAME") & """,""" & GBL_objPubDB.objPubRS("TAG_NAME") & """,""" & GBL_objPubDB.objPubRS("TAG_NAME") & """],"
			GBL_objPubDB.objPubRS.MoveNext
		Wend

		GetTagsArrayLogic = strHtml
		Call CacheInsert(strCacheName,strHtml,CACHE_TIME_TAG)
	Else
		GetTagsArrayLogic = CacheGet(strCacheName)
	End If

End Function

''===================================================================
'= Function    : SaveTagsLogic()
'= Time		   : Created At 2008-1-10
'= Input	   : intVal :  
'= Return      : str
'= Description :  
'==================================================================='
Function SaveTagsLogic(intUserId,intType,strTags,intObjectId,strTitle,strUrl)
	Dim i,arrTags
	strTags = Replace(strTags,"",";")
	If Right(strTags,1) = ";" Then
		strTags = Left(strTags,Len(strTags) - 1)
	End If

	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "T_TAG"
	GBL_objPubDB.SQLType = "DELETE"
	GBL_objPubDB.Where = " TAG_OBJECT_ID=" & intObjectId & " AND TAG_TYPE=" & intType 
	If Not GBL_objPubDB.SQLExecute() Then
		SaveTagsLogic = False
		Exit Function
	End If

	If Trim(strTags) = "" Then
		SaveTagsLogic = True
		Exit Function
	End If

	arrTags = Split(strTags,";")  

	For i = Lbound(arrTags) To UBound(arrTags)
		If Trim(arrTags(i)) <> "" Then 

			GBL_objPubDB.Clear()
			GBL_objPubDB.TableName = "T_TAG"
			GBL_objPubDB.SQLType = "DELETE"
			GBL_objPubDB.Where = " TAG_OBJECT_ID=" & intObjectId & " AND TAG_TYPE=" & intType & " AND TAG_NAME='" & Trim(Replace(arrTags(i),";","")) & "'"
			If Not GBL_objPubDB.SQLExecute() Then
				SaveTagsLogic = False
				Exit Function
			End If

			GBL_objPubDB.Clear()
			GBL_objPubDB.TableName = "T_TAG"
			GBL_objPubDB.SQLType = DB_SQL_TYPE_INSERT
			GBL_objPubDB.AddField "TAG_USER_ID",intUserId
			GBL_objPubDB.AddField "TAG_TYPE",intType
			GBL_objPubDB.AddField "TAG_NAME",Trim(Replace(arrTags(i),";",""))
			GBL_objPubDB.AddField "TAG_OBJECT_ID",intObjectId
			GBL_objPubDB.AddField "TAG_URL",strUrl
			GBL_objPubDB.AddField "TAG_TITLE",strTitle
			GBL_objPubDB.AddField "TAG_ADD_TIME",GetSysTimeStr()
			If Not GBL_objPubDB.SQLExecute() Then
				SaveTagsLogic = False
				Exit Function
			End If
		End If
	Next 
	SaveTagsLogic = True

	'== Clear cache
	Call CacheRemove(CACHE_NAME_TAG_ARRAY)

End Function

''===================================================================
'= Function    : RemoveTagsLogic()
'= Time		   : Created At 2008-1-10
'= Input	   : strWhere :  
'= Return      : boolean
'= Description :  
'==================================================================='
Function RemoveTagsLogic(strWhere)
	Dim strSql

	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "T_TAG"
	GBL_objPubDB.SQLType = "DELETE"
	GBL_objPubDB.Where = " 1=1 " & strWhere
	If Not GBL_objPubDB.SQLExecute() Then
		RemoveTagsLogic = False
		Exit Function
	End If

	RemoveTagsLogic = True

	'== Clear cache
	Call CacheRemove(CACHE_NAME_TAG_ARRAY)

End Function

''===================================================================
'= Function    : GetTagType()
'= Time		   : Created At 2008-1-11
'= Input	   : intVal :  
'= Return      : str
'= Description :  
'==================================================================='
Function GetTagType(intVal)
	Select Case intVal
		Case 0: GetTagType = "༶" 
		Case 1: GetTagType = "" 
		Case 2: GetTagType = ""
		Case 3: GetTagType = "Ƭ" 
		Case 4: GetTagType = "" 
		Case 5: GetTagType = "ʦר" 
		Case 6: GetTagType = "վר" 
		Case 7: GetTagType = "ҳ"  
	End Select
End Function
%>
