<%
''===================================================================
'= ASP FILENAME	: /inc/logic/logic_user.asp
'= CREATED TIME : Feb,08,2004
'= LAST MODIFIED: Feb,08,2004
'= VERSION INFO : CCASP Framework Ver 2.0.1 ALL RIGHTS RESERVED BY www.cclinux.com
'= DESCRIPTION  : û߼
'= Change Log:
'==================================================================='
%>

<%
''===================================================================
'= Function    : GetUsersLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : strWhere : 
'= Return      : boolean
'= Description : ȡû¼
'==================================================================='
Function GetUsersLogic(strWhere,intPageSize,intNowPage)
	GBL_objPubDB.Clear()
	If Instr(strWhere,"ORDER BY") > 0 Then
		If intNowPage = 1 Then
			GBL_objPubDB.AllSQL = "SELECT TOP " & intPageSize & " * FROM CLASS_USER WHERE 1=1 " & strWhere
		Else
			GBL_objPubDB.AllSQL = "SELECT * FROM CLASS_USER WHERE 1=1 " & strWhere
		End If
	Else
		If intNowPage = 1 Then
			GBL_objPubDB.AllSQL = "SELECT TOP " & intPageSize & " * FROM CLASS_USER WHERE 1=1 " & strWhere & "ORDER BY USER_ID DESC"
		Else
			GBL_objPubDB.AllSQL = "SELECT * FROM CLASS_USER WHERE 1=1 " & strWhere & "ORDER BY USER_ID DESC"
		End If
	End If
	If Not GBL_objPubDB.SQLRSExecute() Then
		GetUsersLogic = False
		Exit Function
	End If
	GetUsersLogic = True
End Function

''===================================================================
'= Function    : GetUsersCountLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : strWhere : 
'= Return      : boolean
'= Description : ȡû¼Ŀ
'==================================================================='
Function GetUsersCountLogic(strWhere)
	GBL_objPubDB.Clear()
	GBL_objPubDB.AllSQL = "SELECT COUNT(USER_ID) AS TOTAL FROM CLASS_USER WHERE 1=1 " & strWhere
	If Not GBL_objPubDB.SQLRSExecute() Then
		GetUsersCountLogic = 0
		Exit Function
	End If
	GetUsersCountLogic = Cint(GBL_objPubDB.objPubRS("TOTAL"))
End Function

''===================================================================
'= Function    : ȡû¼()
'= Time		   : Created At 2007-5-19
'= Input	   : strWhere : 
'= Return      : boolean
'= Description : ȡûм¼
'==================================================================='
Function GetTopUsersLogic(strFlag,strTop,strWhere)
	GBL_objPubDB.Clear()
	
	If strFlag = "album" Then
		GBL_objPubDB.AllSQL = "SELECT " & strTop & " * FROM CLASS_USER WHERE 1=1 AND USER_AUTHEN<=2 " & strWhere & "ORDER BY USER_PHOTO_COUNT DESC "
	ElseIf strFlag = "reg" Then
		GBL_objPubDB.AllSQL = "SELECT " & strTop & " * FROM CLASS_USER WHERE 1=1 AND USER_AUTHEN<=2 " & strWhere & "ORDER BY USER_ID DESC "
	ElseIf strFlag = "login" Then
		GBL_objPubDB.AllSQL = "SELECT " & strTop & " * FROM CLASS_USER WHERE 1=1 AND USER_AUTHEN<=2 " & strWhere & "ORDER BY USER_LAST_TIME DESC "
	ElseIf strFlag = "visit" Then
		GBL_objPubDB.AllSQL = "SELECT " & strTop & " * FROM CLASS_USER WHERE 1=1 AND USER_AUTHEN<=2 " & strWhere & "ORDER BY USER_LOGIN_COUNT DESC "
	ElseIf strFlag = "bbs" Then
		GBL_objPubDB.AllSQL = "SELECT " & strTop & " * FROM CLASS_USER WHERE 1=1 AND USER_AUTHEN<=2 " & strWhere & "ORDER BY USER_TOPICS_COUNT DESC "
	Else
		If Instr(strWhere,"ORDER BY") > 0 Then
			GBL_objPubDB.AllSQL = "SELECT * FROM CLASS_USER WHERE 1=1 " & strWhere
		Else
			GBL_objPubDB.AllSQL = "SELECT * FROM CLASS_USER WHERE 1=1 " & strWhere & "ORDER BY USER_ID DESC"
		End If
	End If
	If Not GBL_objPubDB.SQLRSExecute() Then
		GetTopUsersLogic = False
		Exit Function
	End If
	GetTopUsersLogic = True
End Function

''===================================================================
'= Function    : GetUserLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : strWhere : 
'= Return      : boolean
'= Description : ȡû¼
'==================================================================='
Function GetUserLogic(strWhere)
	GBL_objPubDB.Clear()
	GBL_objPubDB.AllSQL = "SELECT USER_QQ,USER_AUTHEN,USER_CLASS,USER_SKIN,USER_QUESTION,USER_ANSWER,USER_WORK,USER_SEX,USER_LEVEL,USER_BOARD_COUNT,USER_INFO,USER_TOPICS_COUNT,USER_PHOTO_COUNT,USER_REPLY_COUNT,USER_REVIEW_COUNT,USER_LOGIN_COUNT,USER_ENROLL,USER_LAST_IP,USER_WORKSHOP,USER_ADDRESS,USER_GRAD,USER_EMAIL,USER_TELE,USER_ADD_DATE,USER_LAST_TIME,USER_BIRTH,USER_REALNAME,USER_NOW_FACE,USER_FACE_SELECT,USER_ACCOUNT,USER_ID,USER_VIP_OPEN,USER_HIGH_OPEN,USER_WORK_STATUS,USER_DUTY,USER_EDU,USER_MSN,USER_PROVINCE,USER_CITY,USER_AREA,USER_WORK_ZONE,USER_WORK_PROVINCE,USER_WORK_CITY,USER_WORK_AREA,USER_COMPANY,USER_WORK_DEGREE FROM CLASS_USER WHERE 1=1" & strWhere
	If Not GBL_objPubDB.SQLRSExecute() Then
		GetUserLogic = False
		Exit Function
	End If
	GetUserLogic = True
End Function

''===================================================================
'= Function    : GetUserFaceSetLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : intUserId : ûID
'= Return      : boolean
'= Description : ȡûǩͼ
'==================================================================='
Function GetUserFaceSetLogic(intUserId)
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_USER"
	GBL_objPubDB.SQLType = "SELECT"
	GBL_objPubDB.AddField "USER_FACE_SELECT",""
	GBL_objPubDB.Where = "USER_ID=" & intUserId
	If Not GBL_objPubDB.SQLRSExecute() Then
		GetUserFaceSetLogic = False
		Exit Function
	End If
	GetUserFaceSetLogic = True
End Function

''===================================================================
'= Function    : SaveUserFaceSetLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : intUserId : ûID
'= Input	   : objFormData : 
'= Return      : boolean
'= Description : ûѡǩͼ
'==================================================================='
Function SaveUserFaceSetLogic(intUserId,objFormData)
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_USER"
	GBL_objPubDB.SQLType = "UPDATE"
	GBL_objPubDB.AddField "USER_FACE_SELECT",objFormData.Item("FaceSet")
	GBL_objPubDB.Where = "USER_ID=" & intUserId
	If Not GBL_objPubDB.SQLExecute() Then
		SaveUserFaceSetLogic = False
		Exit Function
	End If
	If Not ChgUserFaceLogic(intUserId) Then
		SaveUserFaceSetLogic = False
		Exit Function
	End If
	SaveUserFaceSetLogic = True
End Function

''===================================================================
'= Function    : SaveUserCartoonLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : intUserId : ûID
'= Input	   : objFormData : 
'= Return      : boolean
'= Description : ûͨǩ
'==================================================================='
Function SaveUserCartoonLogic(intUserId,objFormData)
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_USER"
	GBL_objPubDB.SQLType = "UPDATE"
	GBL_objPubDB.AddField "USER_CARTOON_FACE",objFormData.Item("CartoonFace")
	GBL_objPubDB.Where = "USER_ID=" & intUserId
	If Not GBL_objPubDB.SQLExecute() Then
		SaveUserCartoonLogic = False
		Exit Function
	End If
	If Not ChgUserFaceLogic(intUserId) Then
		SaveUserCartoonLogic = False
		Exit Function
	End If
	SaveUserCartoonLogic = True
End Function

''===================================================================
'= Function    : GetUserCartoonLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : intUserId : ûID
'= Return      : boolean
'= Description : ȡûǩͼqq
'==================================================================='
Function GetUserCartoonLogic(intUserId)
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_USER"
	GBL_objPubDB.SQLType = "SELECT"
	GBL_objPubDB.AddField "USER_CARTOON_FACE,USER_QQ",""
	GBL_objPubDB.Where = "USER_ID=" & intUserId
	If Not GBL_objPubDB.SQLRSExecute() Then
		GetUserCartoonLogic = False
		Exit Function
	End If
	GetUserCartoonLogic = True
End Function

''===================================================================
'= Function    : ChgUserFaceLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : intUserId : ûID
'= Return      : boolean
'= Description : ޸ûǩͼ
'==================================================================='
Function ChgUserFaceLogic(intUserId)
	Dim strNowFace,strFaceSet

	ChgUserFaceLogic = True
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_USER"
	GBL_objPubDB.SQLType = "SELECT"
	GBL_objPubDB.AddField "USER_FACE_SELECT,USER_QQ,USER_CARTOON_FACE,USER_UP_FACE",""
	GBL_objPubDB.Where = "USER_ID=" & intUserId 
	If Not GBL_objPubDB.SQLRSExecute() Then		
		ChgUserFaceLogic = False
		Exit Function
	End If

	strFaceSet = GBL_objPubDB.objPubRS("USER_FACE_SELECT")
	If strFaceSet = "ͷ" Then
		strNowFace =_
			GBL_strUserUpFace & GBL_objPubDB.objPubRS("USER_UP_FACE")
	ElseIf strFaceSet = "QQ" Then
		strNowFace =_
			MakeQQShow(GBL_objPubDB.objPubRS("USER_QQ"))
	Else
		strNowFace =_
			GBL_strCartoonFacePath & GBL_objPubDB.objPubRS("USER_CARTOON_FACE") & ".gif"
	End If

	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_USER"
	GBL_objPubDB.SQLType = "UPDATE"
	GBL_objPubDB.Where = "USER_ID=" & intUserId
	GBL_objPubDB.AddField "USER_NOW_FACE",strNowFace
	If Not GBL_objPubDB.SQLExecute() Then
		ChgUserFaceLogic = False
		Exit Function
	End If
	ChgUserFaceLogic = True
End Function

''===================================================================
'= Function    : GetUserAuthLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : intAuth : 
'= Return      : ûݵĺ
'= Description : ȡû
'==================================================================='
Function GetUserAuthLogic(intAuth)
	Dim strTmp
	Select Case Cint(intAuth)
		Case	0	: strTmp = "ͨԱ"
		Case	1	: strTmp = "Ա"
		Case	2	: strTmp = "Ա"
		Case	3	: strTmp = "δ֤ͨû"
		Case	4	: strTmp = "û"
		Case	Else : strTmp = "û"
	End Select
	GetUserAuthLogic = strTmp
End Function

''===================================================================
'= Function    : RemoveUsersLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : strIds : 
'= Return      : ûݵĺ
'= Description : ɾû
'==================================================================='
Function RemoveUsersLogic(strIds)
	'== Delete this user's board
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_BOARD"
	GBL_objPubDB.SQLType = "DELETE"
	GBL_objPubDB.Where = "BOARD_USER_ID IN (" & strIds & ")"
	If Not GBL_objPubDB.SQLRSExecute() Then
		RemoveUsersLogic = False
		Exit Function
	End If

	'== Delete this user's review
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_ALBUM_REVIEW"
	GBL_objPubDB.SQLType = "DELETE"
	GBL_objPubDB.Where = "ALBUM_REVIEW_USER_ID IN (" & strIds & ")"
	If Not GBL_objPubDB.SQLRSExecute() Then
		RemoveUsersLogic = False
		Exit Function
	End If

	'== Delete this user's album
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_ALBUM"
	GBL_objPubDB.SQLType = "DELETE"
	GBL_objPubDB.Where = "ALBUM_USER_ID IN (" & strIds & ")"
	If Not GBL_objPubDB.SQLRSExecute() Then
		RemoveUsersLogic = False
		Exit Function
	End If

	'== Delete this user's bbs reply
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_REPLY"
	GBL_objPubDB.SQLType = "DELETE"
	GBL_objPubDB.Where = "REPLY_USER_ID IN (" & strIds & ")"
	If Not GBL_objPubDB.SQLRSExecute() Then
		RemoveUsersLogic = False
		Exit Function
	End If

	'== Delete this user's bbs topics
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_TOPICS"
	GBL_objPubDB.SQLType = "DELETE"
	GBL_objPubDB.Where = "TOPICS_USER_ID IN (" & strIds & ")"
	If Not GBL_objPubDB.SQLRSExecute() Then
		RemoveUsersLogic = False
		Exit Function
	End If

	'== Delete this user's meeting
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_MEET"
	GBL_objPubDB.SQLType = "DELETE"
	GBL_objPubDB.Where = "MEET_USER_ID IN (" & strIds & ")"
	If Not GBL_objPubDB.SQLRSExecute() Then
		RemoveUsersLogic = False
		Exit Function
	End If

	'== Delete this user's meeting bbs
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_MEET_BBS"
	GBL_objPubDB.SQLType = "DELETE"
	GBL_objPubDB.Where = "MEET_BBS_USER_ID IN (" & strIds & ")"
	If Not GBL_objPubDB.SQLRSExecute() Then
		RemoveUsersLogic = False
		Exit Function
	End If

	'== Delete this meet join
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_MEET_JOIN"
	GBL_objPubDB.SQLType = "DELETE"
	GBL_objPubDB.Where = "MEET_JOIN_USER_ID IN (" & strIds & ")"
	If Not GBL_objPubDB.SQLRSExecute() Then
		RemoveUsersLogic = False
		Exit Function
	End If

	'== Delete this user's sms
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_SMS"
	GBL_objPubDB.SQLType = "DELETE"
	GBL_objPubDB.Where = "SMS_INCEPTER_ID IN (" & strIds  & ") OR SMS_SENDER_ID IN (" & strIds & ")"
	If Not GBL_objPubDB.SQLRSExecute() Then
		RemoveUsersLogic = False
		Exit Function
	End If
	
	'== ɾû
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_USER"
	GBL_objPubDB.SQLType = "DELETE"
	GBL_objPubDB.Where = "USER_ID In (" & strIds & ")"
	If Not GBL_objPubDB.SQLRSExecute() Then
		RemoveUsersLogic = False
		Exit Function
	End If

	'== clear cache
	CacheRemove(CACHE_NAME_USER_NUM)
	CacheRemove(CACHE_NAME_NEW_USER_NUM)
	CacheRemove(CACHE_NAME_HOME_NEW_USER_HTML)
	CacheRemove(CACHE_NAME_BOARD_NUM)
	CacheRemove(CACHE_NAME_NEW_BOARD_NUM)
	CacheRemove(CACHE_NAME_TOPICS_NUM)
	CacheRemove(CACHE_NAME_NEW_TOPICS_NUM)
	CacheRemove(CACHE_NAME_REPLY_NUM)
	CacheRemove(CACHE_NAME_NEW_REPLY_NUM)
	CacheRemove(CACHE_NAME_ALBUM_NUM)
	CacheRemove(CACHE_NAME_NEW_ALBUM_NUM)

	RemoveUsersLogic = True

End Function

''===================================================================
'= Function    : AccUsersLogic()
'= Time		   : Created At 2006-7-1
'= Input	   : strIds : 
'= Return      : boolean
'= Description : ׼û
'==================================================================='
Function AccUsersLogic(strIds)
	
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_USER"
	GBL_objPubDB.SQLType = "UPDATE"
	GBL_objPubDB.AddField "USER_AUTHEN",0
	GBL_objPubDB.Where = "USER_ID In (" & strIds & ") AND USER_AUTHEN=8 "
	If Not GBL_objPubDB.SQLRSExecute() Then
		AccUsersLogic = False
		Exit Function
	End If

	AccUsersLogic = True

	'== clear cache
	Call CacheRemove(CACHE_NAME_HOME_NEW_USER_HTML)

End Function

''===================================================================
'= Function    : MasterUsersLogic()
'= Time		   : Created At 2006-7-1
'= Input	   : strIds : 
'= Return      : boolean
'= Description : ûΪ̳ܰ
'==================================================================='
Function MasterUsersLogic(strIds)
	
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_USER"
	GBL_objPubDB.SQLType = "UPDATE"
	GBL_objPubDB.AddField "USER_AUTHEN",1
	GBL_objPubDB.Where = "USER_ID In (" & strIds & ") AND USER_AUTHEN=0 "
	If Not GBL_objPubDB.SQLRSExecute() Then
		MasterUsersLogic = False
		Exit Function
	End If

	MasterUsersLogic = True
End Function

''===================================================================
'= Function    : UnMasterUsersLogic()
'= Time		   : Created At 2006-7-1
'= Input	   : strIds : 
'= Return      : boolean
'= Description : ûΪ̳ܰ
'==================================================================='
Function UnMasterUsersLogic(strIds)
	
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_USER"
	GBL_objPubDB.SQLType = "UPDATE"
	GBL_objPubDB.AddField "USER_AUTHEN",0
	GBL_objPubDB.Where = "USER_ID In (" & strIds & ") AND USER_AUTHEN=1 "
	If Not GBL_objPubDB.SQLRSExecute() Then
		UnMasterUsersLogic = False
		Exit Function
	End If

	UnMasterUsersLogic = True
End Function

''===================================================================
'= Function    : VipUsersLogic()
'= Time		   : Created At 2007-8-12
'= Input	   : strIds : 
'= Return      : boolean
'= Description : ûΪVIP
'==================================================================='
Function VipUsersLogic(strIds)
	
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_USER"
	GBL_objPubDB.SQLType = "UPDATE"
	GBL_objPubDB.AddField "USER_DEGREE",1
	GBL_objPubDB.Where = "USER_ID In (" & strIds & ") AND USER_AUTHEN<>8 AND USER_DEGREE <> 1"
	If Not GBL_objPubDB.SQLExecute() Then
		VipUsersLogic = False
		Exit Function
	End If

	VipUsersLogic = True
End Function

''===================================================================
'= Function    : NoVipUsersLogic()
'= Time		   : Created At 2007-8-12
'= Input	   : strIds : 
'= Return      : boolean
'= Description : ûΪVIP
'==================================================================='
Function NoVipUsersLogic(strIds)
	
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_USER"
	GBL_objPubDB.SQLType = "UPDATE"
	GBL_objPubDB.AddField "USER_DEGREE",0
	GBL_objPubDB.Where = "USER_ID In (" & strIds & ") AND USER_AUTHEN<>8 AND USER_DEGREE <> 0"
	If Not GBL_objPubDB.SQLExecute() Then
		NoVipUsersLogic = False
		Exit Function
	End If

	NoVipUsersLogic = True
End Function

''===================================================================
'= Function    : GetUserSmsNumLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : intUserId : 
'= Output	   : intSms : վϢ
'= Return      : boolean
'= Description : ûվϢ
'==================================================================='
Function GetUserSmsNumLogic(intUserId,ByRef intSms)
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_SMS"
	GBL_objPubDB.SQLType = "SELECT"
	GBL_objPubDB.Where = "SMS_INCEPTER_ID=" & intUserId & " AND SMS_SEND_FLAG=1 AND SMS_DEL_INCEPT=0"
	GBL_objPubDB.AddField "SMS_ID",""
	If Not GBL_objPubDB.SQLRSExecute() Then
		GetUserSmsNumLogic = False
		Exit Function
	End If
	intSms = GBL_objPubDB.intRSNum 
	GetUserSmsNumLogic = True
End Function

''===================================================================
'= Function    : GetUserNewSmsNumLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : intUserId : 
'= Output	   : intNewSms : վϢ
'= Return      : boolean
'= Description : ûվϢ
'==================================================================='
Function GetUserNewSmsNumLogic(intUserId,ByRef intNewSms)
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_SMS"
	GBL_objPubDB.SQLType = "SELECT"
	GBL_objPubDB.Where = "SMS_INCEPTER_ID=" & intUserId & " AND SMS_SEND_FLAG=1 AND SMS_DEL_INCEPT=0 AND SMS_VIEW_FLAG=0"
	GBL_objPubDB.AddField "SMS_ID",""
	If Not GBL_objPubDB.SQLRSExecute() Then
		GetUserNewSmsNumLogic = False
		Exit Function
	End If
	intNewSms = GBL_objPubDB.intRSNum 
	GetUserNewSmsNumLogic = True
End Function 

''===================================================================
'= Function    : SaveUserLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : intUserId : 
'= Output	   : objFormData : 
'= Return      : boolean
'= Description : ûϢ
'==================================================================='
Function SaveUserLogic(intUserId,ByRef objFormData)
	Dim strBirth,strBirthYear,strBirthMon,strBirthDay

	If objFormData.Item("Grad") < objFormData.Item("Enroll") Then
		Call GBL_objException.catchErr(E_USER_PUB,"ȷıҵѧ")
		SaveUserLogic = False
		Exit Function
	End If

	strBirthYear = objFormData.Item("BirthYear")
	strBirthMon = objFormData.Item("BirthMon")
	strBirthDay = objFormData.Item("BirthDay")
	strBirth = strBirthYear & "-" & strBirthMon & "-" & strBirthDay

	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_USER"
	GBL_objPubDB.SQLType = "SELECT"
	GBL_objPubDB.AddField "USER_ID",""
	GBL_objPubDB.Where = "USER_EMAIL='" & objFormData.Item("Email") & "' AND USER_ID<>" & intUserId 
	If Not GBL_objPubDB.SQLRSExecute() Then
		Exit Function
	End If

	If GBL_objPubDB.intRSNum <> 0 Then
		SaveUserLogic = False
		Call GBL_objException.catchErr(E_USER_PUB,"ʼַѱʹ")
		Exit Function
	End If

	objFormData.Item("Class") = Replace(objFormData.Item("Class"),"",";")
	If Right(objFormData.Item("Class"),1) <> ";" Then
		objFormData.Item("Class") = objFormData.Item("Class") & ";"
	End If
 
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_USER"
	GBL_objPubDB.SQLType = "UPDATE"
	GBL_objPubDB.Where = "USER_ID=" & intUserId
	GBL_objPubDB.AddField "USER_EMAIL", objFormData.Item("Email")
	GBL_objPubDB.AddField "USER_REALNAME", objFormData.Item("RealName")
	GBL_objPubDB.AddField "USER_QUESTION", objFormData.Item("Question")
	GBL_objPubDB.AddField "USER_ANSWER", objFormData.Item("Answer")
	GBL_objPubDB.AddField "USER_QQ", objFormData.Item("Qq")
	GBL_objPubDB.AddField "USER_WORKSHOP", objFormData.Item("WorkShop")
	GBL_objPubDB.AddField "USER_TELE", objFormData.Item("Tele")
	GBL_objPubDB.AddField "USER_ADDRESS", objFormData.Item("Address")
	GBL_objPubDB.AddField "USER_CLASS", objFormData.Item("Class")
	GBL_objPubDB.AddField "USER_SEX", objFormData.Item("Sex")
	GBL_objPubDB.AddField "USER_BIRTH", strBirth
	GBL_objPubDB.AddField "USER_GRAD", objFormData.Item("Grad")
	GBL_objPubDB.AddField "USER_ENROLL", objFormData.Item("Enroll")
	GBL_objPubDB.AddField "USER_WORK", objFormData.Item("Work")

	GBL_objPubDB.AddField "USER_EDU", objFormData.Item("Edu")
	GBL_objPubDB.AddField "USER_PROVINCE", objFormData.Item("Province")
	GBL_objPubDB.AddField "USER_CITY", objFormData.Item("City")
	GBL_objPubDB.AddField "USER_AREA", objFormData.Item("Area")
	GBL_objPubDB.AddField "USER_WORK_PROVINCE", objFormData.Item("WorkProvince")
	GBL_objPubDB.AddField "USER_WORK_CITY", objFormData.Item("WorkCity")
	GBL_objPubDB.AddField "USER_WORK_AREA", objFormData.Item("WorkArea")
	GBL_objPubDB.AddField "USER_WORK_ZONE", objFormData.Item("WorkZone")
	GBL_objPubDB.AddField "USER_WORK_STATUS", objFormData.Item("WorkStatus")
	GBL_objPubDB.AddField "USER_COMPANY", objFormData.Item("Company")
	GBL_objPubDB.AddField "USER_DUTY", objFormData.Item("Duty")
	GBL_objPubDB.AddField "USER_MSN", objFormData.Item("Msn")
	GBL_objPubDB.AddField "USER_VIP_OPEN", objFormData.Item("VipOpen")
	GBL_objPubDB.AddField "USER_HIGH_OPEN", objFormData.Item("HighOpen")
	GBL_objPubDB.AddField "USER_WORK_DEGREE", objFormData.Item("WorkDegree")

	GBL_objPubDB.AddField "USER_INFO",htmlencode2(objFormData.Item("Content"))
	If Not GBL_objPubDB.SQLExecute() Then
		SaveUserLogic = False
		Exit Function
	End If

	'== update realname rong yu
	GBL_objPubDB.Clear()
	GBL_objPubDB.AllSQL = "UPDATE CLASS_TOPICS SET TOPICS_LAST_POSTER='" & objFormData.Item("RealName") & "' WHERE TOPICS_LAST_POSTER_ID='" & intUserId & "'"
	If Not GBL_objPubDB.SQLExecute() Then
		SaveUserLogic = False
		Exit Function
	End If

	GBL_objPubDB.Clear()
	GBL_objPubDB.AllSQL = "UPDATE CLASS_SMS SET SMS_SENDER='" & objFormData.Item("RealName") & "' WHERE SMS_SENDER_ID=" & intUserId
	If Not GBL_objPubDB.SQLExecute() Then
		SaveUserLogic = False
		Exit Function
	End If

	GBL_objPubDB.Clear()
	GBL_objPubDB.AllSQL = "UPDATE CLASS_SMS SET SMS_INCEPTER='" & objFormData.Item("RealName") & "' WHERE SMS_INCEPTER_ID=" & intUserId
	If Not GBL_objPubDB.SQLExecute() Then
		SaveUserLogic = False
		Exit Function
	End If

	SaveUserLogic = True

	'== clear cache
	Call CacheRemove(CACHE_NAME_HOME_NEW_USER_HTML)

End Function

''===================================================================
'= Function    : CheckUserPwdLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : intUserId : 
'= Output	   : objFormData : 
'= Return      : boolean
'= Description : 뵱ǰǷȷ
'==================================================================='
Function CheckUserPwdLogic(intUserId,objFormData)
	Dim strOldPwd
	strOldPwd = objFormData.Item("OldPwd")
	strOldPwd = Md5(strOldPwd) 

	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_USER"
	GBL_objPubDB.SQLType = "SELECT"
	GBL_objPubDB.Where = "USER_ID=" & intUserId
	GBL_objPubDB.AddField "USER_PASSWORD", ""
	If Not GBL_objPubDB.SQLRSExecute() Then
		Exit Function
	End If
	If GBL_objPubDB.objPubRS("USER_PASSWORD") <> strOldPwd Then
		CheckUserPwdLogic = False
		Exit Function
	End If
	CheckUserPwdLogic = True
End Function

''===================================================================
'= Function    : SaveUserPwdLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : intUserId : 
'= Output	   : objFormData : 
'= Return      : boolean
'= Description : ޸û
'==================================================================='
Function SaveUserPwdLogic(intUserId,objFormData)
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_USER"
	GBL_objPubDB.SQLType = "UPDATE"
	GBL_objPubDB.Where = "USER_ID=" & intUserId
	GBL_objPubDB.AddField "USER_PASSWORD", Md5(objFormData.Item("NewPwd"))
	If Not GBL_objPubDB.SQLExecute() Then
		SaveUserPwdLogic = False
		Exit Function
	End If
	SaveUserPwdLogic = True
End Function

''===================================================================
'= Function    : SaveUserTempLogic()
'= Time		   : Created At 2007-7-14
'= Input	   : intUserId : 
'= Output	   : objFormData : 
'= Return      : boolean
'= Description : 趨ģ
'==================================================================='
Function SaveUserTempLogic(intUserId,objFormData)
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_USER"
	GBL_objPubDB.SQLType = "UPDATE"
	GBL_objPubDB.Where = "USER_ID=" & intUserId
	GBL_objPubDB.AddField "USER_SKIN", objFormData.Item("Temp")
	If Not GBL_objPubDB.SQLExecute() Then
		SaveUserTempLogic = False
		Exit Function
	End If
	SaveUserTempLogic = True
End Function

''===================================================================
'= Function    : MakeHtmlUserOptionLogic()
'= Time		   : Created At 2006-5-8
'= Input	   : strWhere 
'= Input	   : strFile  ļַ
'= Return      : boolean
'= Description : ûselectoption htmlļ
'==================================================================='
Function MakeHtmlUserOptionLogic(strWhere,strFile)
	Dim strFileContent
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_USER"
	GBL_objPubDB.SQLType = "SELECT"
	GBL_objPubDB.Where = "1=1 AND USER_AUTHEN<>8 " & strWhere
	GBL_objPubDB.AddField "USER_REALNAME", ""
	GBL_objPubDB.AddField "USER_CLASS", ""
	GBL_objPubDB.AddField "USER_ID", ""
	GBL_objPubDB.ORDER = "USER_ID DESC"
	If Not GBL_objPubDB.SQLRSExecute() Then
		MakeHtmlUserOptionLogic = False
		Exit Function
	End If
	While Not GBL_objPubDB.objPubRS.Eof 
		strFileContent = strFileContent & "<option value=""" & GBL_objPubDB.objPubRS("USER_ID") & """>" & GBL_objPubDB.objPubRS("USER_REALNAME") & "(" & GBL_objPubDB.objPubRS("USER_CLASS") & ")</option>" & chr(13) & chr(10)
		GBL_objPubDB.objPubRS.MoveNext
	Wend
	
	Call fsoWriteToFile(strFileContent,strFile,10)

	MakeHtmlUserOptionLogic = True
End Function

''===================================================================
'= Function    : MakeQQShow()
'= Time		   : Created At 2006-6-24
'= Input	   : intQQ
'= Return      : string
'= Description : qq url
'==================================================================='
Function MakeQQShow(intQQ)

	MakeQQShow = "http://qqshow-user.tencent.com/" & intQQ & "/10/00/"

End Function

''===================================================================
'= Function    : GetFriendLogic(strWhere)
'= Time		   : Created At 2006-6-24
'= Input	   : strWhere
'= Return      : string
'= Description : 
'==================================================================='
Function GetFriendLogic(strWhere)
	Dim strFileContent
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_USER"
	GBL_objPubDB.SQLType = "SELECT"
	GBL_objPubDB.Where = "1=1 " & strWhere
	GBL_objPubDB.AddField "USER_REALNAME", ""
	GBL_objPubDB.AddField "USER_ID", ""
	If Not GBL_objPubDB.SQLRSExecute() Then
		GetFriendLogic = False
		Exit Function
	End If
	While Not GBL_objPubDB.objPubRS.Eof 
		strFileContent = strFileContent & "<option value=""" & GBL_objPubDB.objPubRS("USER_ID") & """>" & GBL_objPubDB.objPubRS("USER_REALNAME") & "</option>" & chr(13) & chr(10)
		GBL_objPubDB.objPubRS.MoveNext
	Wend
	
	Call fsoWriteToFile(strFileContent,strFile,10)

	GetFriendLogic = True
End Function

''===================================================================
'= Function    : SaveUserSignLogic(intUserId,strImg)
'= Time		   : Created At 2006-6-24
'= Input	   : intUserId
'= Input	   : strImg
'= Return      : boolean
'= Description : ûǩͼָ
'==================================================================='
Function SaveUserSignLogic(intUserId,strImg)
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_USER"
	GBL_objPubDB.SQLType = "UPDATE"
	GBL_objPubDB.AddField "USER_UP_FACE", GBL_objFormData.Item("UpFace")
	GBL_objPubDB.Where = "USER_ID=" & intUserId
	If Not GBL_objPubDB.SQLExecute() Then
		SaveUserSignLogic = False
		Exit Function
	End If

	If Not ChgUserFaceLogic(intUserId) Then
		SaveUserSignLogic = False
		Exit Function
	End If

	SaveUserSignLogic = True
End Function

''===================================================================
'= Function    : GetUserSignLogic(intUserId)
'= Time		   : Created At 2006-6-24
'= Input	   : intUserId
'= Input	   : strImg
'= Return      : boolean
'= Description : ûǩͼָ
'==================================================================='
Function GetUserSignLogic(intUserId,ByRef strUserSign)
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_USER"
	GBL_objPubDB.SQLType = "SELECT"
	GBL_objPubDB.AddField "USER_UP_FACE", ""
	GBL_objPubDB.Where = "USER_ID=" & intUserId
	If Not GBL_objPubDB.SQLRSExecute() Then
		GetUserSignLogic = False
		Exit Function
	End If
	strUserSign = GBL_objPubDB.objPubRS("USER_UP_FACE")
	GetUserSignLogic = True
End Function

''===================================================================
'= Function    : SaveUserPassLogic(intUserId)
'= Time		   : Created At 2006-6-24
'= Input	   : intUserId
'= Input	   : strImg
'= Return      : boolean
'= Description : ޸ĹԱû
'==================================================================='
Function SaveUserPassLogic(intUserId,strPass)
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_USER"
	GBL_objPubDB.SQLType = "UPDATE"
	GBL_objPubDB.AddField "USER_PASSWORD", Md5(strPass)
	GBL_objPubDB.Where = "USER_ID=" & intUserId
	If Not GBL_objPubDB.SQLExecute() Then
		SaveUserPassLogic = False
		Exit Function
	End If
	SaveUserPassLogic = True
End Function

''===================================================================
'= Function    : MakeHtmlByWork()
'= Time		   : Created At 2007-5-20
'= Input	   : strWhere 
'= Input	   : strFile  ļַ
'= Return      : boolean
'= Description : ûҵļ
'==================================================================='
Function MakeHtmlByWork(strWhere,strFile)
	Dim strFileContent,i,strClass
	GBL_objPubDB.Clear()
	GBL_objPubDB.AllSQL = "SELECT USER_WORK,COUNT(USER_WORK) AS TOTAL FROM CLASS_USER WHERE USER_WORK IS NOT NULL AND  USER_WORK <> '' GROUP BY USER_WORK"
	If Not GBL_objPubDB.SQLRSExecute() Then
		MakeHtmlByWork = False
		Exit Function
	End If
	i = 0
	While Not GBL_objPubDB.objPubRS.Eof 
		i = i + 1
		

		IF GBL_objPubDB.objPubRS("TOTAL") > 120 Then
			strClass = "6"
		ElseIf GBL_objPubDB.objPubRS("TOTAL") > 80 Then
			strClass = "5"
		ElseIf GBL_objPubDB.objPubRS("TOTAL") > 50 Then
			strClass = "4"
		ElseIf GBL_objPubDB.objPubRS("TOTAL") > 35 Then
			strClass = "3"
		ElseIf GBL_objPubDB.objPubRS("TOTAL") > 20 Then
			strClass = "2"
		ElseIf GBL_objPubDB.objPubRS("TOTAL") > 10 Then
			strClass = "1"
		Else  
			strClass = "0"
		End If

		strFileContent = strFileContent & "<a class='tlv" & strClass & "' title='' href='address_search_result.asp?iptWork=" & GBL_objPubDB.objPubRS("USER_WORK") & "'>" & GBL_objPubDB.objPubRS("USER_WORK") & "[" & GBL_objPubDB.objPubRS("TOTAL") & "]</a>&nbsp;&nbsp;&nbsp;"
		GBL_objPubDB.objPubRS.MoveNext
	Wend
	
	Call fsoWriteToFile(strFileContent,strFile,10)

	MakeHtmlByWork = True
End Function

''===================================================================
'= Function    : MakeHtmlByEnroll()
'= Time		   : Created At 2007-5-20
'= Input	   : strWhere 
'= Input	   : strFile  ļַ
'= Return      : boolean
'= Description : ûѧļ
'==================================================================='
Function MakeHtmlByEnroll(strWhere,strFile)
	Dim strFileContent,i,strClass
	GBL_objPubDB.Clear()
	GBL_objPubDB.AllSQL = "SELECT USER_ENROLL,COUNT(USER_ENROLL) AS TOTAL FROM CLASS_USER WHERE USER_ENROLL IS NOT NULL AND  USER_ENROLL >0 GROUP BY USER_ENROLL"
	If Not GBL_objPubDB.SQLRSExecute() Then
		MakeHtmlByEnroll = False
		Exit Function
	End If
	i = 0
	While Not GBL_objPubDB.objPubRS.Eof 
		i = i + 1
		

		IF GBL_objPubDB.objPubRS("TOTAL") > 120 Then
			strClass = "6"
		ElseIf GBL_objPubDB.objPubRS("TOTAL") > 80 Then
			strClass = "5"
		ElseIf GBL_objPubDB.objPubRS("TOTAL") > 50 Then
			strClass = "4"
		ElseIf GBL_objPubDB.objPubRS("TOTAL") > 35 Then
			strClass = "3"
		ElseIf GBL_objPubDB.objPubRS("TOTAL") > 20 Then
			strClass = "2"
		ElseIf GBL_objPubDB.objPubRS("TOTAL") > 10 Then
			strClass = "1"
		Else  
			strClass = "0"
		End If

		strFileContent = strFileContent & "<a class='tlv" & strClass & "' title='' href='address_search_result.asp?iptEnroll=" & GBL_objPubDB.objPubRS("USER_ENROLL") & "'>" & GBL_objPubDB.objPubRS("USER_ENROLL") & "[" & GBL_objPubDB.objPubRS("TOTAL") & "]</a>&nbsp;&nbsp;&nbsp;"
		GBL_objPubDB.objPubRS.MoveNext
	Wend
	
	Call fsoWriteToFile(strFileContent,strFile,10)

	MakeHtmlByEnroll = True
End Function

''===================================================================
'= Function    : MakeHtmlByEnroll()
'= Time		   : Created At 2007-5-20
'= Input	   : strWhere 
'= Input	   : strFile  ļַ
'= Return      : boolean
'= Description : ûҵļ
'==================================================================='
Function MakeHtmlByGrad(strWhere,strFile)
	Dim strFileContent,i,strClass
	GBL_objPubDB.Clear()
	GBL_objPubDB.AllSQL = "SELECT USER_GRAD,COUNT(USER_GRAD) AS TOTAL FROM CLASS_USER WHERE USER_GRAD IS NOT NULL AND  USER_GRAD >0 GROUP BY USER_GRAD"
	If Not GBL_objPubDB.SQLRSExecute() Then
		MakeHtmlByGrad = False
		Exit Function
	End If
	i = 0
	While Not GBL_objPubDB.objPubRS.Eof 
		i = i + 1
		

		IF GBL_objPubDB.objPubRS("TOTAL") > 120 Then
			strClass = "6"
		ElseIf GBL_objPubDB.objPubRS("TOTAL") > 80 Then
			strClass = "5"
		ElseIf GBL_objPubDB.objPubRS("TOTAL") > 50 Then
			strClass = "4"
		ElseIf GBL_objPubDB.objPubRS("TOTAL") > 35 Then
			strClass = "3"
		ElseIf GBL_objPubDB.objPubRS("TOTAL") > 20 Then
			strClass = "2"
		ElseIf GBL_objPubDB.objPubRS("TOTAL") > 10 Then
			strClass = "1"
		Else  
			strClass = "0"
		End If

		strFileContent = strFileContent & "<a class='tlv" & strClass & "' title='' href='address_search_result.asp?iptGrad=" & GBL_objPubDB.objPubRS("USER_GRAD") & "'>" & GBL_objPubDB.objPubRS("USER_GRAD") & "[" & GBL_objPubDB.objPubRS("TOTAL") & "]</a>&nbsp;&nbsp;&nbsp;"
		GBL_objPubDB.objPubRS.MoveNext
	Wend
	
	Call fsoWriteToFile(strFileContent,strFile,10)

	MakeHtmlByGrad = True
End Function

''===================================================================
'= Function    : GetUserDegree()
'= Time		   : Created At 2007-8-12
'= Input	   : intVal :  
'= Return      : str
'= Description :  
'==================================================================='
Function GetUserDegree(intVal)
	Select Case intVal
		Case 0: GetUserDegree = "VIPû" 
		Case 1: GetUserDegree = "VIPû" 
	End Select
End Function

''===================================================================
'= Function    : GetIsOpen()
'= Time		   : Created At 2007-12-20
'= Input	   : intVal :  
'= Return      : str
'= Description :   
'==================================================================='
Function GetUserIsOpen(str)
	If str = 0 Then
		GetUserIsOpen = "û"
	ElseIf str = 1 Then
		GetUserIsOpen = "עû"
	ElseIf str = 2 Then
		GetUserIsOpen = "VIPû"
	ElseIf str = 5 Then
		GetUserIsOpen = "Ա"
	End If
End Function
%>