var SWFUpload;
if (SWFUpload == undefined) {
    SWFUpload = function(settings){
        this.initSWFUpload(settings);
    };
}
SWFUpload.prototype.initSWFUpload = function(settings){
    try {
        this.customSettings = {};
        this.settings = settings;
        this.eventQueue = [];
        this.movieName = "SWFUpload_" + SWFUpload.movieCount++;
        this.movieElement = null;
        SWFUpload.instances[this.movieName] = this;
        this.initSettings();
        this.loadFlash();
        this.displayDebugInfo();
    } 
    catch (ex) {
        delete SWFUpload.instances[this.movieName];
        throw ex;
    }
};
/* Static Members  */
SWFUpload.instances = {};
SWFUpload.movieCount = 0;
SWFUpload.version = "2.2.0 2009-03-25";
SWFUpload.QUEUE_ERROR = {
    QUEUE_LIMIT_EXCEEDED: -100,
    FILE_EXCEEDS_SIZE_LIMIT: -110,
    ZERO_BYTE_FILE: -120,
    INVALID_FILETYPE: -130
};
SWFUpload.UPLOAD_ERROR = {
    HTTP_ERROR: -200,
    MISSING_UPLOAD_URL: -210,
    IO_ERROR: -220,
    SECURITY_ERROR: -230,
    UPLOAD_LIMIT_EXCEEDED: -240,
    UPLOAD_FAILED: -250,
    SPECIFIED_FILE_ID_NOT_FOUND: -260,
    FILE_VALIDATION_FAILED: -270,
    FILE_CANCELLED: -280,
    UPLOAD_STOPPED: -290
};
SWFUpload.FILE_STATUS = {
    QUEUED: -1,
    IN_PROGRESS: -2,
    ERROR: -3,
    COMPLETE: -4,
    CANCELLED: -5
};
SWFUpload.BUTTON_ACTION = {
    SELECT_FILE: -100,
    SELECT_FILES: -110,
    START_UPLOAD: -120
};
SWFUpload.CURSOR = {
    ARROW: -1,
    HAND: -2
};
SWFUpload.WINDOW_MODE = {
    WINDOW: "window",
    TRANSPARENT: "transparent",
    OPAQUE: "opaque"
};
SWFUpload.completeURL = function(url){
    if (typeof(url) !== "string" || url.match(/^https?:\/\//i) || url.match(/^\//)) {
        return url;
    }
    var currentURL = window.location.protocol + "//" + window.location.hostname + (window.location.port ? ":" + window.location.port : "");
    var indexSlash = window.location.pathname.lastIndexOf("/");
    if (indexSlash <= 0) {
        path = "/";
    }
    else {
        path = window.location.pathname.substr(0, indexSlash) + "/";
    }
    return /*currentURL +*/ path + url;
};
SWFUpload.prototype.initSettings = function(){
    this.ensureDefault = function(settingName, defaultValue){
        this.settings[settingName] = (this.settings[settingName] == undefined) ? defaultValue : this.settings[settingName];
    };
    this.ensureDefault("upload_url", "");
    this.ensureDefault("preserve_relative_urls", false);
    this.ensureDefault("file_post_name", "Filedata");
    this.ensureDefault("post_params", {});
    this.ensureDefault("use_query_string", false);
    this.ensureDefault("requeue_on_error", false);
    this.ensureDefault("http_success", []);
    this.ensureDefault("assume_success_timeout", 0);
    this.ensureDefault("file_types", "*.*");
    this.ensureDefault("file_types_description", "All Files");
    this.ensureDefault("file_size_limit", 0); // Default zero means "unlimited"
    this.ensureDefault("file_upload_limit", 0);
    this.ensureDefault("file_queue_limit", 0);
    this.ensureDefault("flash_url", "swfupload.swf");
    this.ensureDefault("prevent_swf_caching", true);
    this.ensureDefault("button_image_url", "");
    this.ensureDefault("button_width", 1);
    this.ensureDefault("button_height", 1);
    this.ensureDefault("button_text", "");
    this.ensureDefault("button_text_style", "color: #000000; font-size: 16pt;");
    this.ensureDefault("button_text_top_padding", 0);
    this.ensureDefault("button_text_left_padding", 0);
    this.ensureDefault("button_action", SWFUpload.BUTTON_ACTION.SELECT_FILES);
    this.ensureDefault("button_disabled", false);
    this.ensureDefault("button_placeholder_id", "");
    this.ensureDefault("button_placeholder", null);
    this.ensureDefault("button_cursor", SWFUpload.CURSOR.ARROW);
    this.ensureDefault("button_window_mode", SWFUpload.WINDOW_MODE.WINDOW);
    this.ensureDefault("debug", false);
    this.settings.debug_enabled = this.settings.debug; // Here to maintain v2 API
    this.settings.return_upload_start_handler = this.returnUploadStart;
    this.ensureDefault("swfupload_loaded_handler", null);
    this.ensureDefault("file_dialog_start_handler", null);
    this.ensureDefault("file_queued_handler", null);
    this.ensureDefault("file_queue_error_handler", null);
    this.ensureDefault("file_dialog_complete_handler", null);
    this.ensureDefault("upload_start_handler", null);
    this.ensureDefault("upload_progress_handler", null);
    this.ensureDefault("upload_error_handler", null);
    this.ensureDefault("upload_success_handler", null);
    this.ensureDefault("upload_complete_handler", null);
    this.ensureDefault("debug_handler", this.debugMessage);
    this.ensureDefault("custom_settings", {});
    this.customSettings = this.settings.custom_settings;
    if (!!this.settings.prevent_swf_caching) {
        this.settings.flash_url = this.settings.flash_url + (this.settings.flash_url.indexOf("?") < 0 ? "?" : "&") + "preventswfcaching=" + new Date().getTime();
    }
    if (!this.settings.preserve_relative_urls) {
        this.settings.upload_url = SWFUpload.completeURL(this.settings.upload_url);
        this.settings.button_image_url = SWFUpload.completeURL(this.settings.button_image_url);
    }
    delete this.ensureDefault;
};
SWFUpload.prototype.loadFlash = function(){
    var targetElement, tempParent;
    if (document.getElementById(this.movieName) !== null) {
        throw "ID " + this.movieName + " is already in use. The Flash Object could not be added";
    }
    targetElement = document.getElementById(this.settings.button_placeholder_id) || this.settings.button_placeholder;
    
    if (targetElement == undefined) {
        throw "Could not find the placeholder element: " + this.settings.button_placeholder_id;
    }
    tempParent = document.createElement("div");
    tempParent.innerHTML = this.getFlashHTML(); // Using innerHTML is non-standard but the only sensible way to dynamically add Flash in IE (and maybe other browsers)
    targetElement.parentNode.replaceChild(tempParent.firstChild, targetElement);
    if (window[this.movieName] == undefined) {
        window[this.movieName] = this.getMovieElement();
    }
    
};
SWFUpload.prototype.getFlashHTML = function(){
    // Flash Satay object syntax: http://www.alistapart.com/articles/flashsatay
    //var flashHtml = ['<object  classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000"  codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=9,0,28,0"  '];
    //flashHtml.push('id="', this.movieName, '" type="application/x-shockwave-flash" data="', this.settings.flash_url, '" width="', this.settings.button_width, '" height="', this.settings.button_height, '" class="swfupload">', '<param name="wmode" value="', this.settings.button_window_mode, '" />', '<param name="movie" value="', this.settings.flash_url, '" />', '<param name="quality" value="high" />');
    //flashHtml.push('<param name="menu" value="false" />', '<param name="allowScriptAccess" value="always" />', '<param name="flashvars" value="' + this.getFlashVars() + '" />');
    //flashHtml.push('<embed name="', this.movieName, '" id="', this.movieName, '"  src="',this.settings.flash_url,'"  quality="high" menu="false"  allowScriptAccess="always" width="', this.settings.button_width, '" flashvars="' + this.getFlashVars() + '"   height="', this.settings.button_height, '"  class="swfupload" type="application/x-shockwave-flash"  pluginspage="http://www.macromedia.com/go/getflashplayer"></embed></object>');
    //return flashHtml.join('');
    return ['<object id="', this.movieName, '" type="application/x-shockwave-flash" data="', this.settings.flash_url, '" width="', this.settings.button_width, '" height="', this.settings.button_height, '" class="swfupload">', '<param name="wmode" value="', this.settings.button_window_mode, '" />', '<param name="movie" value="', this.settings.flash_url, '" />', '<param name="quality" value="high" />', '<param name="menu" value="false" />', '<param name="allowScriptAccess" value="always" />', '<param name="flashvars" value="' + this.getFlashVars() + '" />', '</object>'].join("");
};
SWFUpload.prototype.getFlashVars = function(){
    var paramString = this.buildParamString();
    var httpSuccessString = this.settings.http_success.join(",");
    return ["movieName=", encodeURIComponent(this.movieName), "&amp;uploadURL=", encodeURIComponent(this.settings.upload_url), "&amp;useQueryString=", encodeURIComponent(this.settings.use_query_string), "&amp;requeueOnError=", encodeURIComponent(this.settings.requeue_on_error), "&amp;httpSuccess=", encodeURIComponent(httpSuccessString), "&amp;assumeSuccessTimeout=", encodeURIComponent(this.settings.assume_success_timeout), "&amp;params=", encodeURIComponent(paramString), "&amp;filePostName=", encodeURIComponent(this.settings.file_post_name), "&amp;fileTypes=", encodeURIComponent(this.settings.file_types), "&amp;fileTypesDescription=", encodeURIComponent(this.settings.file_types_description), "&amp;fileSizeLimit=", encodeURIComponent(this.settings.file_size_limit), "&amp;fileUploadLimit=", encodeURIComponent(this.settings.file_upload_limit), "&amp;fileQueueLimit=", encodeURIComponent(this.settings.file_queue_limit), "&amp;debugEnabled=", encodeURIComponent(this.settings.debug_enabled), "&amp;buttonImageURL=", encodeURIComponent(this.settings.button_image_url), "&amp;buttonWidth=", encodeURIComponent(this.settings.button_width), "&amp;buttonHeight=", encodeURIComponent(this.settings.button_height), "&amp;buttonText=", encodeURIComponent(this.settings.button_text), "&amp;buttonTextTopPadding=", encodeURIComponent(this.settings.button_text_top_padding), "&amp;buttonTextLeftPadding=", encodeURIComponent(this.settings.button_text_left_padding), "&amp;buttonTextStyle=", encodeURIComponent(this.settings.button_text_style), "&amp;buttonAction=", encodeURIComponent(this.settings.button_action), "&amp;buttonDisabled=", encodeURIComponent(this.settings.button_disabled), "&amp;buttonCursor=", encodeURIComponent(this.settings.button_cursor)].join("");
};
SWFUpload.prototype.getMovieElement = function(){
    if (this.movieElement == undefined) {
        this.movieElement = document.getElementById(this.movieName);
    }
    if (this.movieElement === null) {
        throw "Could not find Flash element";
    }
    return this.movieElement;
};
SWFUpload.prototype.buildParamString = function(){
    var postParams = this.settings.post_params;
    var paramStringPairs = [];
    
    if (typeof(postParams) === "object") {
        for (var name in postParams) {
            if (postParams.hasOwnProperty(name)) {
                paramStringPairs.push(encodeURIComponent(name.toString()) + "=" + encodeURIComponent(postParams[name].toString()));
            }
        }
    }
    return paramStringPairs.join("&amp;");
};
SWFUpload.prototype.destroy = function(){
    try {
        this.cancelUpload(null, false);
        var movieElement = null;
        movieElement = this.getMovieElement();
        if (movieElement && typeof(movieElement.CallFunction) === "unknown") { // We only want to do this in IE
            // Loop through all the movie's properties and remove all function references (DOM/JS IE 6/7 memory leak workaround)
            for (var i in movieElement) {
                try {
                    if (typeof(movieElement[i]) === "function") {
                        movieElement[i] = null;
                    }
                } 
                catch (ex1) {
                }
            }
            try {
                movieElement.parentNode.removeChild(movieElement);
            } 
            catch (ex) {
            }
        }
        window[this.movieName] = null;
        SWFUpload.instances[this.movieName] = null;
        delete SWFUpload.instances[this.movieName];
        this.movieElement = null;
        this.settings = null;
        this.customSettings = null;
        this.eventQueue = null;
        this.movieName = null;
        return true;
    } 
    catch (ex2) {
        return false;
    }
};
SWFUpload.prototype.displayDebugInfo = function(){
    this.debug(["---SWFUpload Instance Info---\n", "Version: ", SWFUpload.version, "\n", "Movie Name: ", this.movieName, "\n", "Settings:\n", "\t", "upload_url:               ", this.settings.upload_url, "\n", "\t", "flash_url:                ", this.settings.flash_url, "\n", "\t", "use_query_string:         ", this.settings.use_query_string.toString(), "\n", "\t", "requeue_on_error:         ", this.settings.requeue_on_error.toString(), "\n", "\t", "http_success:             ", this.settings.http_success.join(", "), "\n", "\t", "assume_success_timeout:   ", this.settings.assume_success_timeout, "\n", "\t", "file_post_name:           ", this.settings.file_post_name, "\n", "\t", "post_params:              ", this.settings.post_params.toString(), "\n", "\t", "file_types:               ", this.settings.file_types, "\n", "\t", "file_types_description:   ", this.settings.file_types_description, "\n", "\t", "file_size_limit:          ", this.settings.file_size_limit, "\n", "\t", "file_upload_limit:        ", this.settings.file_upload_limit, "\n", "\t", "file_queue_limit:         ", this.settings.file_queue_limit, "\n", "\t", "debug:                    ", this.settings.debug.toString(), "\n", "\t", "prevent_swf_caching:      ", this.settings.prevent_swf_caching.toString(), "\n", "\t", "button_placeholder_id:    ", this.settings.button_placeholder_id.toString(), "\n", "\t", "button_placeholder:       ", (this.settings.button_placeholder ? "Set" : "Not Set"), "\n", "\t", "button_image_url:         ", this.settings.button_image_url.toString(), "\n", "\t", "button_width:             ", this.settings.button_width.toString(), "\n", "\t", "button_height:            ", this.settings.button_height.toString(), "\n", "\t", "button_text:              ", this.settings.button_text.toString(), "\n", "\t", "button_text_style:        ", this.settings.button_text_style.toString(), "\n", "\t", "button_text_top_padding:  ", this.settings.button_text_top_padding.toString(), "\n", "\t", "button_text_left_padding: ", this.settings.button_text_left_padding.toString(), "\n", "\t", "button_action:            ", this.settings.button_action.toString(), "\n", "\t", "button_disabled:          ", this.settings.button_disabled.toString(), "\n", "\t", "custom_settings:          ", this.settings.custom_settings.toString(), "\n", "Event Handlers:\n", "\t", "swfupload_loaded_handler assigned:  ", (typeof this.settings.swfupload_loaded_handler === "function").toString(), "\n", "\t", "file_dialog_start_handler assigned: ", (typeof this.settings.file_dialog_start_handler === "function").toString(), "\n", "\t", "file_queued_handler assigned:       ", (typeof this.settings.file_queued_handler === "function").toString(), "\n", "\t", "file_queue_error_handler assigned:  ", (typeof this.settings.file_queue_error_handler === "function").toString(), "\n", "\t", "upload_start_handler assigned:      ", (typeof this.settings.upload_start_handler === "function").toString(), "\n", "\t", "upload_progress_handler assigned:   ", (typeof this.settings.upload_progress_handler === "function").toString(), "\n", "\t", "upload_error_handler assigned:      ", (typeof this.settings.upload_error_handler === "function").toString(), "\n", "\t", "upload_success_handler assigned:    ", (typeof this.settings.upload_success_handler === "function").toString(), "\n", "\t", "upload_complete_handler assigned:   ", (typeof this.settings.upload_complete_handler === "function").toString(), "\n", "\t", "debug_handler assigned:             ", (typeof this.settings.debug_handler === "function").toString(), "\n"].join(""));
};
SWFUpload.prototype.addSetting = function(name, value, default_value){
    if (value == undefined) {
        return (this.settings[name] = default_value);
    }
    else {
        return (this.settings[name] = value);
    }
};
SWFUpload.prototype.getSetting = function(name){
    if (this.settings[name] != undefined) {
        return this.settings[name];
    }
    
    return "";
};
SWFUpload.prototype.callFlash = function(functionName, argumentArray){
    argumentArray = argumentArray || [];
    var movieElement = this.getMovieElement();
    var returnValue, returnString;
    try {
        returnString = movieElement.CallFunction('<invoke name="' + functionName + '" returntype="javascript">' + __flash__argumentsToXML(argumentArray, 0) + '</invoke>');
        returnValue = eval(returnString);
    } 
    catch (ex) {
        throw "Call to " + functionName + " failed";
    }
    if (returnValue != undefined && typeof returnValue.post === "object") {
        returnValue = this.unescapeFilePostParams(returnValue);
    }
    return returnValue;
};
//Flash control methods --
SWFUpload.prototype.selectFile = function(){
    this.callFlash("SelectFile");
};
SWFUpload.prototype.selectFiles = function(){
    this.callFlash("SelectFiles");
};
SWFUpload.prototype.startUpload = function(fileID){
    this.callFlash("StartUpload", [fileID]);
};
SWFUpload.prototype.cancelUpload = function(fileID, triggerErrorEvent){
    if (triggerErrorEvent !== false) {
        triggerErrorEvent = true;
    }
    this.callFlash("CancelUpload", [fileID, triggerErrorEvent]);
};
SWFUpload.prototype.stopUpload = function(){
    this.callFlash("StopUpload");
};
SWFUpload.prototype.getStats = function(){
    return this.callFlash("GetStats");
};
SWFUpload.prototype.setStats = function(statsObject){
    this.callFlash("SetStats", [statsObject]);
};
SWFUpload.prototype.getFile = function(fileID){
    if (typeof(fileID) === "number") {
        return this.callFlash("GetFileByIndex", [fileID]);
    }
    else {
        return this.callFlash("GetFile", [fileID]);
    }
};
SWFUpload.prototype.addFileParam = function(fileID, name, value){
    return this.callFlash("AddFileParam", [fileID, name, value]);
};
SWFUpload.prototype.removeFileParam = function(fileID, name){
    this.callFlash("RemoveFileParam", [fileID, name]);
};
SWFUpload.prototype.setUploadURL = function(url){
    this.settings.upload_url = url.toString();
    this.callFlash("SetUploadURL", [url]);
};
SWFUpload.prototype.setPostParams = function(paramsObject){
    this.settings.post_params = paramsObject;
    this.callFlash("SetPostParams", [paramsObject]);
};
SWFUpload.prototype.addPostParam = function(name, value){
    this.settings.post_params[name] = value;
    this.callFlash("SetPostParams", [this.settings.post_params]);
};
SWFUpload.prototype.removePostParam = function(name){
    delete this.settings.post_params[name];
    this.callFlash("SetPostParams", [this.settings.post_params]);
};
SWFUpload.prototype.setFileTypes = function(types, description){
    this.settings.file_types = types;
    this.settings.file_types_description = description;
    this.callFlash("SetFileTypes", [types, description]);
};
SWFUpload.prototype.setFileSizeLimit = function(fileSizeLimit){
    this.settings.file_size_limit = fileSizeLimit;
    this.callFlash("SetFileSizeLimit", [fileSizeLimit]);
};
SWFUpload.prototype.setFileUploadLimit = function(fileUploadLimit){
    this.settings.file_upload_limit = fileUploadLimit;
    this.callFlash("SetFileUploadLimit", [fileUploadLimit]);
};
SWFUpload.prototype.setFileQueueLimit = function(fileQueueLimit){
    this.settings.file_queue_limit = fileQueueLimit;
    this.callFlash("SetFileQueueLimit", [fileQueueLimit]);
};
SWFUpload.prototype.setFilePostName = function(filePostName){
    this.settings.file_post_name = filePostName;
    this.callFlash("SetFilePostName", [filePostName]);
};
SWFUpload.prototype.setUseQueryString = function(useQueryString){
    this.settings.use_query_string = useQueryString;
    this.callFlash("SetUseQueryString", [useQueryString]);
};
SWFUpload.prototype.setRequeueOnError = function(requeueOnError){
    this.settings.requeue_on_error = requeueOnError;
    this.callFlash("SetRequeueOnError", [requeueOnError]);
};
SWFUpload.prototype.setHTTPSuccess = function(http_status_codes){
    if (typeof http_status_codes === "string") {
        http_status_codes = http_status_codes.replace(" ", "").split(",");
    }
    this.settings.http_success = http_status_codes;
    this.callFlash("SetHTTPSuccess", [http_status_codes]);
};
SWFUpload.prototype.setAssumeSuccessTimeout = function(timeout_seconds){
    this.settings.assume_success_timeout = timeout_seconds;
    this.callFlash("SetAssumeSuccessTimeout", [timeout_seconds]);
};
SWFUpload.prototype.setDebugEnabled = function(debugEnabled){
    this.settings.debug_enabled = debugEnabled;
    this.callFlash("SetDebugEnabled", [debugEnabled]);
};
SWFUpload.prototype.setButtonImageURL = function(buttonImageURL){
    if (buttonImageURL == undefined) {
        buttonImageURL = "";
    }
    this.settings.button_image_url = buttonImageURL;
    this.callFlash("SetButtonImageURL", [buttonImageURL]);
};
SWFUpload.prototype.setButtonDimensions = function(width, height){
    this.settings.button_width = width;
    this.settings.button_height = height;
    var movie = this.getMovieElement();
    if (movie != undefined) {
        movie.style.width = width + "px";
        movie.style.height = height + "px";
    }
    this.callFlash("SetButtonDimensions", [width, height]);
};
SWFUpload.prototype.setButtonText = function(html){
    this.settings.button_text = html;
    this.callFlash("SetButtonText", [html]);
};
SWFUpload.prototype.setButtonTextPadding = function(left, top){
    this.settings.button_text_top_padding = top;
    this.settings.button_text_left_padding = left;
    this.callFlash("SetButtonTextPadding", [left, top]);
};
SWFUpload.prototype.setButtonTextStyle = function(css){
    this.settings.button_text_style = css;
    this.callFlash("SetButtonTextStyle", [css]);
};
SWFUpload.prototype.setButtonDisabled = function(isDisabled){
    this.settings.button_disabled = isDisabled;
    this.callFlash("SetButtonDisabled", [isDisabled]);
};
SWFUpload.prototype.setButtonAction = function(buttonAction){
    this.settings.button_action = buttonAction;
    this.callFlash("SetButtonAction", [buttonAction]);
};
SWFUpload.prototype.setButtonCursor = function(cursor){
    this.settings.button_cursor = cursor;
    this.callFlash("SetButtonCursor", [cursor]);
};
//Flash Event Interfaces
SWFUpload.prototype.queueEvent = function(handlerName, argumentArray){
    if (argumentArray == undefined) {
        argumentArray = [];
    }
    else 
        if (!(argumentArray instanceof Array)) {
            argumentArray = [argumentArray];
        }
    var self = this;
    if (typeof this.settings[handlerName] === "function") {
        this.eventQueue.push(function(){
            this.settings[handlerName].apply(this, argumentArray);
        });
        setTimeout(function(){
            self.executeNextEvent();
        }, 0);
    }
    else 
        if (this.settings[handlerName] !== null) {
            throw "Event handler " + handlerName + " is unknown or is not a function";
        }
};
SWFUpload.prototype.executeNextEvent = function(){
    var f = this.eventQueue ? this.eventQueue.shift() : null;
    if (typeof(f) === "function") {
        f.apply(this);
    }
};
SWFUpload.prototype.unescapeFilePostParams = function(file){
    var reg = /[$]([0-9a-f]{4})/i;
    var unescapedPost = {};
    var uk;
    if (file != undefined) {
        for (var k in file.post) {
            if (file.post.hasOwnProperty(k)) {
                uk = k;
                var match;
                while ((match = reg.exec(uk)) !== null) {
                    uk = uk.replace(match[0], String.fromCharCode(parseInt("0x" + match[1], 16)));
                }
                unescapedPost[uk] = file.post[k];
            }
        }
        file.post = unescapedPost;
    }
    return file;
};
SWFUpload.prototype.testExternalInterface = function(){
    try {
        return this.callFlash("TestExternalInterface");
    } 
    catch (ex) {
        return false;
    }
};
SWFUpload.prototype.flashReady = function(){
    var movieElement = this.getMovieElement();
    if (!movieElement) {
        this.debug("Flash called back ready but the flash movie can't be found.");
        return;
    }
    this.cleanUp(movieElement);
    this.queueEvent("swfupload_loaded_handler");
};
SWFUpload.prototype.cleanUp = function(movieElement){
    try {
        if (this.movieElement && typeof(movieElement.CallFunction) === "unknown") { // We only want to do this in IE
            this.debug("Removing Flash functions hooks (this should only run in IE and should prevent memory leaks)");
            for (var key in movieElement) {
                try {
                    if (typeof(movieElement[key]) === "function") {
                        movieElement[key] = null;
                    }
                } 
                catch (ex) {
                }
            }
        }
    } 
    catch (ex1) {
    }
    window["__flash__removeCallback"] = function(instance, name){
        try {
            if (instance) {
                instance[name] = null;
            }
        } 
        catch (flashEx) {
        }
    };
    
};
SWFUpload.prototype.fileDialogStart = function(){
    this.queueEvent("file_dialog_start_handler");
};
SWFUpload.prototype.fileQueued = function(file){
    file = this.unescapeFilePostParams(file);
    this.queueEvent("file_queued_handler", file);
};
SWFUpload.prototype.fileQueueError = function(file, errorCode, message){
    file = this.unescapeFilePostParams(file);
    this.queueEvent("file_queue_error_handler", [file, errorCode, message]);
};
SWFUpload.prototype.fileDialogComplete = function(numFilesSelected, numFilesQueued, numFilesInQueue){
    this.queueEvent("file_dialog_complete_handler", [numFilesSelected, numFilesQueued, numFilesInQueue]);
};
SWFUpload.prototype.uploadStart = function(file){
    file = this.unescapeFilePostParams(file);
    this.queueEvent("return_upload_start_handler", file);
};
SWFUpload.prototype.returnUploadStart = function(file){
    var _this = this;
    if (typeof this.settings.upload_start_handler === "function") {
        file = this.unescapeFilePostParams(file);
        file.callBack = function(returnValue){
            if (returnValue === undefined) {
                returnValue = true;
            }
            returnValue = !!returnValue;
            _this.callFlash("ReturnUploadStart", [returnValue]);
        }
        this.settings.upload_start_handler.call(this, file);
    }
    else 
        if (this.settings.upload_start_handler != undefined) {
            throw "upload_start_handler must be a function";
        }
};
SWFUpload.prototype.uploadProgress = function(file, bytesComplete, bytesTotal){
    file = this.unescapeFilePostParams(file);
    this.queueEvent("upload_progress_handler", [file, bytesComplete, bytesTotal]);
};
SWFUpload.prototype.uploadError = function(file, errorCode, message){
    file = this.unescapeFilePostParams(file);
    this.queueEvent("upload_error_handler", [file, errorCode, message]);
};
SWFUpload.prototype.uploadSuccess = function(file, serverData, responseReceived){
    file = this.unescapeFilePostParams(file);
    this.queueEvent("upload_success_handler", [file, serverData, responseReceived]);
};
SWFUpload.prototype.uploadComplete = function(file){
    file = this.unescapeFilePostParams(file);
    this.queueEvent("upload_complete_handler", file);
};
SWFUpload.prototype.debug = function(message){
    this.queueEvent("debug_handler", message);
};
SWFUpload.prototype.debugMessage = function(message){
    if (this.settings.debug) {
        var exceptionMessage, exceptionValues = [];
        if (typeof message === "object" && typeof message.name === "string" && typeof message.message === "string") {
            for (var key in message) {
                if (message.hasOwnProperty(key)) {
                    exceptionValues.push(key + ": " + message[key]);
                }
            }
            exceptionMessage = exceptionValues.join("\n") || "";
            exceptionValues = exceptionMessage.split("\n");
            exceptionMessage = "EXCEPTION: " + exceptionValues.join("\nEXCEPTION: ");
            SWFUpload.Console.writeLine(exceptionMessage);
        }
        else {
            SWFUpload.Console.writeLine(message);
        }
    }
};
SWFUpload.Console = {};
SWFUpload.Console.writeLine = function(message){
    var console, documentForm;
    try {
        console = document.getElementById("SWFUpload_Console");
        if (!console) {
            documentForm = document.createElement("form");
            document.getElementsByTagName("body")[0].appendChild(documentForm);
            console = document.createElement("textarea");
            console.id = "SWFUpload_Console";
            console.style.fontFamily = "monospace";
            console.setAttribute("wrap", "off");
            console.wrap = "off";
            console.style.overflow = "auto";
            console.style.width = "700px";
            console.style.height = "350px";
            console.style.margin = "5px";
            documentForm.appendChild(console);
        }
        console.value += message + "\n";
        console.scrollTop = console.scrollHeight - console.clientHeight;
    } 
    catch (ex) {
        alert("Exception: " + ex.name + " Message: " + ex.message);
    }
};

//swfupload.queue.js
var SWFUpload;
if (typeof(SWFUpload) === "function") {
    SWFUpload.queue = {};
    SWFUpload.prototype.initSettings = (function(oldInitSettings){
        return function(){
            if (typeof(oldInitSettings) === "function") {
                oldInitSettings.call(this);
            }
            this.queueSettings = {};
            this.queueSettings.queue_cancelled_flag = false;
            this.queueSettings.queue_upload_count = 0;
            this.queueSettings.user_upload_complete_handler = this.settings.upload_complete_handler;
            this.queueSettings.user_upload_start_handler = this.settings.upload_start_handler;
            this.settings.upload_complete_handler = SWFUpload.queue.uploadCompleteHandler;
            this.settings.upload_start_handler = SWFUpload.queue.uploadStartHandler;
            this.settings.queue_complete_handler = this.settings.queue_complete_handler || null;
        };
    })(SWFUpload.prototype.initSettings);
    SWFUpload.prototype.startUpload = function(fileID){
        this.queueSettings.queue_cancelled_flag = false;
        this.callFlash("StartUpload", [fileID]);
    };
    SWFUpload.prototype.cancelQueue = function(){
        this.queueSettings.queue_cancelled_flag = true;
        this.stopUpload();
        
        var stats = this.getStats();
        while (stats.files_queued > 0) {
            this.cancelUpload();
            stats = this.getStats();
        }
    };
    SWFUpload.queue.uploadStartHandler = function(file){
        var returnValue;
        if (typeof(this.queueSettings.user_upload_start_handler) === "function") {
            returnValue = this.queueSettings.user_upload_start_handler.call(this, file);
        }
        returnValue = (returnValue === false) ? false : true;
        this.queueSettings.queue_cancelled_flag = !returnValue;
        return returnValue;
    };
    SWFUpload.queue.uploadCompleteHandler = function(file){
        var user_upload_complete_handler = this.queueSettings.user_upload_complete_handler;
        var continueUpload;
        if (file.filestatus === SWFUpload.FILE_STATUS.COMPLETE) {
            this.queueSettings.queue_upload_count++;
        }
        if (typeof(user_upload_complete_handler) === "function") {
            continueUpload = (user_upload_complete_handler.call(this, file) === false) ? false : true;
        }
        else 
            if (file.filestatus === SWFUpload.FILE_STATUS.QUEUED) {
                // If the file was stopped and re-queued don't restart the upload
                continueUpload = false;
            }
            else {
                continueUpload = true;
            }
        if (continueUpload) {
            var stats = this.getStats();
            if (stats.files_queued > 0 && this.queueSettings.queue_cancelled_flag === false) {
                this.startUpload();
            }
            else 
                if (this.queueSettings.queue_cancelled_flag === false) {
                    this.queueEvent("queue_complete_handler", [this.queueSettings.queue_upload_count]);
                    this.queueSettings.queue_upload_count = 0;
                }
                else {
                    this.queueSettings.queue_cancelled_flag = false;
                    this.queueSettings.queue_upload_count = 0;
                }
        }
    };
}
//fileprogress.js
function FileProgress(file, targetID){
    this.fileProgressID = file.id;
    this.fileSize = file.size;
    this.opacity = 100;
    this.height = 0;
    this.fileProgressWrapper = document.getElementById(this.fileProgressID);
    if (!this.fileProgressWrapper) {
        this.fileProgressWrapper = document.createElement("div");
        this.fileProgressWrapper.className = "progressWrapper";
        this.fileProgressWrapper.id = this.fileProgressID;
        this.fileProgressElement = document.createElement("div");
        this.fileProgressElement.className = "progressContainer";
        var progressCancel = document.createElement("a");
        progressCancel.className = "progressCancel";
        progressCancel.href = "#";
        progressCancel.style.display = "none";
        progressCancel.appendChild(document.createTextNode(" "));
        var progressText = document.createElement("div");
        progressText.className = "progressName";
        progressText.appendChild(document.createTextNode(file.name));
        
        var progressFileSize = document.createElement("div");
        progressFileSize.className = "progressFileSize";
        var progressClear = document.createElement("div");
        progressClear.className = 'cl';
        var pClear2 = document.createElement("div");
        pClear2.className = 'cl';
        
        var progressBar = document.createElement("div");
        progressBar.className = "progressBarInProgress";
        var progressStatus = document.createElement("div");
        progressStatus.className = "progressBarStatus";
        progressStatus.innerHTML = "&nbsp;";
        var uploadPercent = document.createElement("span");
        uploadPercent.className = 'progressPercent';
        this.fileProgressElement.appendChild(progressCancel);
        this.fileProgressElement.appendChild(progressText);
        this.fileProgressElement.appendChild(progressFileSize);
        this.fileProgressElement.appendChild(pClear2);
        this.fileProgressElement.appendChild(progressBar);
        this.fileProgressElement.appendChild(uploadPercent);
        this.fileProgressElement.appendChild(progressClear);
        this.fileProgressElement.appendChild(progressStatus);
        this.fileProgressWrapper.appendChild(this.fileProgressElement);
        document.getElementById(targetID).appendChild(this.fileProgressWrapper);
    }
    else {
        this.fileProgressElement = this.fileProgressWrapper.firstChild;
        this.reset();
    }
    this.height = this.fileProgressWrapper.offsetHeight;
    this.setTimer(null);
}

FileProgress.prototype.setTimer = function(timer){
    this.fileProgressElement["FP_TIMER"] = timer;
};
FileProgress.prototype.getTimer = function(timer){
    return this.fileProgressElement["FP_TIMER"] || null;
};
FileProgress.prototype.reset = function(){
    /*
     this.fileProgressElement.className = "progressContainer";
     this.fileProgressElement.childNodes[2].innerHTML = "&nbsp;";
     this.fileProgressElement.childNodes[2].className = "progressBarStatus";
     this.fileProgressElement.childNodes[3].className = "progressBarInProgress";
     this.fileProgressElement.childNodes[3].style.width = "0%";
     */
    this.fileProgressElement.className = "progressContainer";
    this.fileProgressElement.childNodes[7].innerHTML = "&nbsp;";
    this.fileProgressElement.childNodes[7].className = "progressBarStatus";
    this.fileProgressElement.childNodes[4].className = "progressBarInProgress";
    this.fileProgressElement.childNodes[4].style.width = "0%";
    this.appear();
};
FileProgress.prototype.setProgress = function(percentage){
    /*
     this.fileProgressElement.className = "progressContainer green";
     this.fileProgressElement.childNodes[3].className = "progressBarInProgress";
     this.fileProgressElement.childNodes[3].style.width = percentage + "%";
     this.fileProgressElement.childNodes[4].innerHTML = percentage + "%";
     this.fileProgressElement.childNodes[5].innerHTML = this.fileSize;
     */
    this.fileProgressElement.className = "progressContainer green";
    this.fileProgressElement.childNodes[4].className = "progressBarInProgress";
    this.fileProgressElement.childNodes[4].style.width = (percentage / 100 * 381) + "px";
    this.fileProgressElement.childNodes[5].innerHTML = (percentage == 100) ? ('99%') : (percentage + "%");
    var showFileSize = (this.fileSize / 1024);
    if (showFileSize >= 1024) {
        showFileSize = roundNumber(((this.fileSize / 1024) / 1024), 2) + 'MB';
    }
    else {
        showFileSize = roundNumber((this.fileSize / 1024), 2) + 'KB';
    }
    this.fileProgressElement.childNodes[2].innerHTML = showFileSize;
    
    this.appear();
};
FileProgress.prototype.setComplete = function(){
    this.fileProgressElement.className = "progressContainer blue";
    /*
     this.fileProgressElement.childNodes[3].className = "progressBarComplete";
     this.fileProgressElement.childNodes[3].style.width = "";
     */
    this.fileProgressElement.childNodes[4].className = "progressBarComplete";
    this.fileProgressElement.childNodes[4].style.width = "";
    if (this.fileProgressElement.childNodes[5].innerHTML == '99%') {
        this.fileProgressElement.childNodes[5].innerHTML = '100%';
    }
    var oSelf = this;
    this.setTimer(setTimeout(function(){
        oSelf.disappear();
    }, 5000));
};
FileProgress.prototype.setError = function(){
    this.fileProgressElement.className = "progressContainer red";
    /*
     this.fileProgressElement.childNodes[3].className = "progressBarError";
     this.fileProgressElement.childNodes[3].style.width = "";
     */
    this.fileProgressElement.childNodes[4].className = "progressBarError";
    this.fileProgressElement.childNodes[4].style.width = "";
    this.fileProgressElement.childNodes[5].innerHTML = '';
    /*
     var oSelf = this;
     this.setTimer(setTimeout(function(){
     oSelf.disappear();
     }, 3000));
     */
};
FileProgress.prototype.setCancelled = function(){
    this.fileProgressElement.className = "progressContainer";
    /*
     this.fileProgressElement.childNodes[3].className = "progressBarError";
     this.fileProgressElement.childNodes[3].style.width = "";
     */
    this.fileProgressElement.childNodes[4].className = "progressBarError";
    this.fileProgressElement.childNodes[4].style.width = "";
    this.fileProgressElement.childNodes[5].innerHTML = "";
    var oSelf = this;
    this.setTimer(setTimeout(function(){
        oSelf.disappear();
    }, 2000));
};
FileProgress.prototype.setStatus = function(status){
    // this.fileProgressElement.childNodes[2].innerHTML = status;
    this.fileProgressElement.childNodes[7].innerHTML = status;
};
// Show/Hide the cancel button
FileProgress.prototype.toggleCancel = function(show, swfUploadInstance){
    this.fileProgressElement.childNodes[0].style.display = show ? "block" : "none";
    if (swfUploadInstance) {
        var fileID = this.fileProgressID;
        this.fileProgressElement.childNodes[0].onclick = function(){
            swfUploadInstance.cancelUpload(fileID);
            return false;
        };
    }
};
FileProgress.prototype.closeError = function(show){
    this.fileProgressElement.childNodes[0].style.display = show ? "block" : "none";
    var fileID = this.fileProgressID;
    var oSelf = this;
    this.fileProgressElement.childNodes[0].onclick = function(){
        oSelf.disappear();
        return false;
    };
};
FileProgress.prototype.appear = function(){
    if (this.getTimer() !== null) {
        clearTimeout(this.getTimer());
        this.setTimer(null);
    }
    if (this.fileProgressWrapper.filters) {
        try {
            this.fileProgressWrapper.filters.item("DXImageTransform.Microsoft.Alpha").opacity = 100;
        } 
        catch (e) {
            // If it is not set initially, the browser will throw an error.  This will set it if it is not set yet.
            this.fileProgressWrapper.style.filter = "progid:DXImageTransform.Microsoft.Alpha(opacity=100)";
        }
    }
    else {
        this.fileProgressWrapper.style.opacity = 1;
    }
    this.fileProgressWrapper.style.height = "";
    this.height = this.fileProgressWrapper.offsetHeight;
    this.opacity = 100;
    this.fileProgressWrapper.style.display = "";
};
// Fades out and clips away the FileProgress box.
FileProgress.prototype.disappear = function(){
    var reduceOpacityBy = 15;
    var reduceHeightBy = 4;
    var rate = 30; // 15 fps
    if (this.opacity > 0) {
        this.opacity -= reduceOpacityBy;
        if (this.opacity < 0) {
            this.opacity = 0;
        }
        if (this.fileProgressWrapper.filters) {
            try {
                this.fileProgressWrapper.filters.item("DXImageTransform.Microsoft.Alpha").opacity = this.opacity;
            } 
            catch (e) {
                // If it is not set initially, the browser will throw an error.  This will set it if it is not set yet.
                this.fileProgressWrapper.style.filter = "progid:DXImageTransform.Microsoft.Alpha(opacity=" + this.opacity + ")";
            }
        }
        else {
            this.fileProgressWrapper.style.opacity = this.opacity / 100;
        }
    }
    if (this.height > 0) {
        this.height -= reduceHeightBy;
        if (this.height < 0) {
            this.height = 0;
        }
        this.fileProgressWrapper.style.height = this.height + "px";
    }
    if (this.height > 0 || this.opacity > 0) {
        var oSelf = this;
        this.setTimer(setTimeout(function(){
            oSelf.disappear();
        }, rate));
    }
    else {
        this.fileProgressWrapper.style.display = "none";
        this.setTimer(null);
    }
};

//handler.js
function fileQueued(file){
    //console.info(file);
    currentUpload.totalSize += file.size;
    currentUpload.uploaded = 0;
    currentUpload.oneFileUpload.tempUpload = 0;
   // currentUpload.parentId = KliveTree.parentId;
   currentUpload.parentId = '';
   setUploadWinTitle('<span class="pcnt" id="minpercent">0%</span><span class="upl_line"></span><span class="speed" id="minspeed">0M/0M</span>');
    //$('#showup').html('<span class="pcnt" id="minpercent">0%</span><span class="upl_line"></span><span class="speed" id="minspeed">0M/0M</span>');
    try {
        var progress = new FileProgress(file, this.customSettings.progressTarget);
        progress.setStatus("等待中...");//Pending...
        progress.toggleCancel(true, this);
        
    } 
    catch (ex) {
        this.debug(ex);
    }
    
}

function fileQueueError(file, errorCode, message){
    try {
        if (errorCode === SWFUpload.QUEUE_ERROR.QUEUE_LIMIT_EXCEEDED) {
            alert("对不起,您上传的文件数量超过总限定个数.\n" + (message === 0 ? "" : "您还可以选择 " + (message > 1 ? message + " 个文件." : "1个文件.")));
            return;
        }
        var progress = new FileProgress(file, this.customSettings.progressTarget);
        progress.setError();
        //progress.toggleCancel(false);
        progress.closeError(true);
        switch (errorCode) {
            case SWFUpload.QUEUE_ERROR.FILE_EXCEEDS_SIZE_LIMIT:
                progress.setStatus("对不起,上传文件超过限制大小300MB.");//File is too big
                this.debug("Error Code: File too big, File name: " + file.name + ", File size: " + file.size + ", Message: " + message);
                break;
            case SWFUpload.QUEUE_ERROR.ZERO_BYTE_FILE:
                progress.setStatus("对不起,不能上传0字节的文件.");//Cannot upload Zero Byte files
                this.debug("Error Code: Zero byte file, File name: " + file.name + ", File size: " + file.size + ", Message: " + message);
                break;
            case SWFUpload.QUEUE_ERROR.INVALID_FILETYPE:
                progress.setStatus("无效的文件类型.");//Invalid File Type
                this.debug("Error Code: Invalid File Type, File name: " + file.name + ", File size: " + file.size + ", Message: " + message);
                break;
            default:
                if (file !== null) {
                    progress.setStatus("未知错误");//Unhandled Error
                }
                this.debug("Error Code: " + errorCode + ", File name: " + file.name + ", File size: " + file.size + ", Message: " + message);
                break;
        }
    } 
    catch (ex) {
        this.debug(ex);
    }
}

function fileDialogComplete(numFilesSelected, numFilesQueued){

    try {
        if (numFilesSelected > 0) {
            //document.getElementById(this.customSettings.cancelButtonId).disabled = false;
           // $("#uploadpanel").find('.dialog-button a').first().show();
		   hideCancelButton(false);
        }
        /* I want auto start the upload and I can do that here */
        //if (KliveConfig.popFirstUpload == 2) {
        //    uploadControl.doUpload();
        //    $("#simplemodal-container").css('visibility', 'hidden');
        //    $("#simplemodal-overlay").hide();
        //    firstUpload.startUpload();
        //}
        //else {
            this.startUpload();
        //}
    } 
    catch (ex) {
        this.debug(ex);
    }
    
}

function getNowDateTime(){
    var d, s = "";
    d = new Date();
    s += d.getFullYear();
    s += (d.getMonth() + 1);
    s += d.getDate();
    s += d.getHours();
    s += d.getMinutes();
    s += d.getSeconds();
    return (s);
}


var iTime = ""; //intial time
var Timeleft = ""; //time left
var currentUpload = {
    parentId: '',
    uploaded: 0,
    totalSize: 0,
    oneFileUpload: {
        tempUpload: 0,
        fileId: ''
    }
}
//roundNumber found via google
function roundNumber(num, dec){
    var result = Math.round(num * Math.pow(10, dec)) / Math.pow(10, dec);
    return result;
}

//minsec created by Daem0nX (03.29.08)
function minsec(time, tempTime){
    var ztime;
    if (time == "m") {
        ztime = Math.floor(tempTime / 60);
        if (ztime < 10) {
            ztime = "0" + ztime;
        }
    }
    else 
        if (time == "s") {
            ztime = Math.ceil(tempTime % 60);
            if (ztime < 10) {
                ztime = "0" + ztime;
            }
        }
        else {
            ztime = "minsec error...";
        }
    return ztime;
}

function uploadStart(file){
    var _this = this;
	var url = ufaServer+"/getServer/?callback=?"
	if(typeof newuploaddown_enable!='undefined'&&1==newuploaddown_enable){
		url = ufaServer+"/cdlsched/upload_locate/?callback=?"
	}
    $.getJSON(url, function(resData){
        //loging start
        if (resData && resData.url) {
            var currentTime = new Date();
            iTime = currentTime;
            Timeleft = "计算中...";
            currentUpload.oneFileUpload.fileId = file.id;
            //var fileList = KliveConfig.fileData.file;
			var fileList = parent.MainPanelObj.getAllFiles();
			//var fileList = [];
            var name = file.name;
            var realName = file.name;
            var fileType = file.type;
            var dotPos = name.lastIndexOf('.');
            if (dotPos != -1) {
                realName = name.substr(0, dotPos);
            }
            else {
                fileType = '';
            }
            for (var i = 0, len = fileList.length; i < len; i++) {
                if (fileList[i].fileName != undefined) {
                    if (name.toLowerCase() == fileList[i].fileName.toLowerCase()) {
                        var randomNum = Math.random() * 100;
                        name = realName + '(' + getNowDateTime() + parseInt(randomNum) + ')' + fileType;
                    }
                }
            }
            //loging end
            //var parentId = currentUpload.parentId;
            //parentId = (parentId == 'root') ? '' : parentId;
			if(typeof newuploaddown_enable!='undefined'&&1==newuploaddown_enable){
				var getparams = $.param({
					'parentId': parentId,
					'name': name
				});
				_this.setUploadURL(resData.url + 'ul/?' + getparams);
			}else{
				var getparams = $.param({
					'size': file.size,
					'dataType': 'CompressedEncrypted',
					'parentId': parentId,
					'name': name
				});
				_this.setUploadURL(resData.url + '/upload2/?' + getparams);
			}
            _this.addPostParam('token', userSid);
            var progress = new FileProgress(file, _this.customSettings.progressTarget);
            progress.setStatus("开始上传...");//Uploading
            progress.toggleCancel(true, _this);
            file.callBack(true);
        }
        else {
            var progress = new FileProgress(file, _this.customSettings.progressTarget);
            progress.setError();
            progress.setStatus("获取上传地址失败");//Uploading
            //progress.toggleCancel(true);
            progress.closeError(true);
            progress.toggleCancel(true, _this);
            file.callBack(true);
        }
    });
}

function uploadProgress(file, bytesLoaded, bytesTotal){
    try {
        var currentTime = new Date();
        var percent = Math.ceil((bytesLoaded / bytesTotal) * 100);
        var progress = new FileProgress(file, this.customSettings.progressTarget);
        progress.setProgress(percent);
        var tempTime = 0;
        var rndfilesize = roundNumber(((file.size / 1024) / 1024), 1);
        var uploaded = roundNumber(((bytesLoaded / 1024) / 1024), 1);
        var uTime = (Math.ceil(currentTime - iTime) / 1000);
        var uSpeed = Math.floor(roundNumber(((bytesLoaded / uTime) / 1024), 2));
        var tempTime = uTime;
        uTime = "用时" + minsec("m", tempTime) + "分:" + minsec("s", tempTime) + "秒";
        tempTime = roundNumber(((((bytesTotal - bytesLoaded) / uSpeed) / 60) / 10), 2);
        if (tempTime != "Infinity") {
            if (tempTime > 0) {
                Timeleft = minsec("m", tempTime) + "分:" + minsec("s", tempTime) + '秒';
            }
            else {
                Timeleft = "计算中...";
            }
        }
        else {
            Timeleft = "计算中...";
        }
        currentUpload.oneFileUpload.tempUpload = bytesLoaded;
        var uploadedTotalFileSize = bytesLoaded + currentUpload.uploaded;
        var showUploaded = roundNumber(((uploadedTotalFileSize / 1024) / 1024), 1);
        var showTotalSize = roundNumber(((currentUpload.totalSize / 1024) / 1024), 1);
        var showPercent = 0;
        if (showTotalSize != 0) {
            showPercent = Math.ceil((showUploaded / showTotalSize) * 100);
        }
        $("#minpercent").html(showPercent + '%');
        $("#minspeed").html(showUploaded + 'M / ' + showTotalSize + 'M');
		setUploadWinTitle(showUploaded + 'M / ' + showTotalSize + 'M'+'&nbsp;&nbsp;&nbsp;&nbsp;'+uSpeed+'KB/秒');
        //$("#showup").html('<span class="pcnt" id="minpercent">' + showPercent + '%</span><span class="upl_line"></span><span class="speed">' + showUploaded + 'M / ' + showTotalSize + 'M</span>');
        if (percent == 100) {
            progress.setStatus("正在加密存储中...");//Uploading...
        }
        else {
            //  progress.setStatus("上传处理中..." + percent + '%');//Uploading...
            //<span style="display:block;width=70px;float:left;">' + percent + '%</span>
            //rndfilesize
            progress.setStatus('<span style="width=100px; float:left; margin-right:20px; ">已上传：' + uploaded + ' MB </span><span style="float:left;"> 速度：</span><span style="width=40px;float:left;">' + uSpeed + '</span><span style="float:left;"> KB/秒; </span><span style="width=200px;float:right; margin-right:10px;">剩余时间: ' + Timeleft + '</span><div style="clear:both;"><div>');
        }
    } 
    catch (ex) {
        this.debug(ex);
    }
}



function uploadSuccess(file, serverData){
    try {
        currentUpload.uploaded += file.size;
        var currentTime = new Date();
        var cTime = (Math.ceil(currentTime - iTime) / 1000);
        var zmin = 0;
        var zsec = 0;
        zmin = Math.floor(cTime / 60);
        if (zmin < 10) {
            zmin = "0" + zmin;
        }
        zsec = Math.ceil(cTime % 60);
        if (zsec < 10) {
            zsec = "0" + zsec;
        }
        //Show how long the upload took
        var returnData = eval('(' + serverData + ')');
        var progress = new FileProgress(file, this.customSettings.progressTarget);
        if (returnData != undefined && returnData.code == 'ok') {
            progress.setComplete();
            //  progress.setStatus("上传成功.");//Complete
            progress.setStatus("上传成功，用时: " + zmin + "分:" + zsec + '秒');
            progress.toggleCancel(false);
			var _parent = parent;
			$.ajax({
				url:'index.php?ac=fileview_handler&op=formatfilehtml',
				dataType:'html',
				data:{'fileId':returnData.fileId},
				success:function(res)
				{
					_parent.MainPanelObj.refreshFilePanel('upload',res);
					$(_parent.document.getElementById('nofilewrap')).remove();
				}
			})
        }
        else {
            progress.setError();
            //var info = returnData.result.value;
            var info = returnData.code;
            info = (info == undefined) ? returnData.result : info;
            progress.setStatus("上传失败:" + info);//Uploading
            // progress.toggleCancel(false);
            progress.closeError(true);
        }
    } 
    catch (ex) {
        this.debug(ex);
    }
}

function uploadError(file, errorCode, message){
    try {
        if (currentUpload.totalSize > 0) {
            currentUpload.totalSize = currentUpload.totalSize - file.size;
        }
        else {
            currentUpload.totalSize = 0;
        }
        // alert(message);
        var progress = new FileProgress(file, this.customSettings.progressTarget);
        progress.setError();
        // progress.toggleCancel(false);
        progress.closeError(true);
        switch (errorCode) {
            case SWFUpload.UPLOAD_ERROR.HTTP_ERROR:
				if(413==message)
				{
					progress.setStatus("上传错误: 文件名太长或者超过限制上传大小300MB；错误编码：" + message);//Upload Error: " + message
				}else
				{
					progress.setStatus("上传错误: " + message);//Upload Error: " + message
				}
                this.debug("Error Code: HTTP Error, File name: " + file.name + ", Message: " + message);
                break;
            case SWFUpload.UPLOAD_ERROR.UPLOAD_FAILED:
                progress.setStatus("上传失败.");//Upload Failed
                this.debug("Error Code: Upload Failed, File name: " + file.name + ", File size: " + file.size + ", Message: " + message);
                break;
            case SWFUpload.UPLOAD_ERROR.IO_ERROR:
                progress.setStatus("上传失败，遇到网络问题");//Server (IO) Error
                this.debug("Error Code: IO Error, File name: " + file.name + ", Message: " + message);
                break;
            case SWFUpload.UPLOAD_ERROR.SECURITY_ERROR:
                progress.setStatus("权限错误");//Security Error
                this.debug("Error Code: Security Error, File name: " + file.name + ", Message: " + message);
                break;
            case SWFUpload.UPLOAD_ERROR.UPLOAD_LIMIT_EXCEEDED:
                progress.setStatus("超过上传限制");//Upload limit exceeded.
                this.debug("Error Code: Upload Limit Exceeded, File name: " + file.name + ", File size: " + file.size + ", Message: " + message);
                break;
            case SWFUpload.UPLOAD_ERROR.FILE_VALIDATION_FAILED:
                progress.setStatus("验证出错.");//Failed Validation.  Upload skipped.
                this.debug("Error Code: File Validation Failed, File name: " + file.name + ", File size: " + file.size + ", Message: " + message);
                break;
            case SWFUpload.UPLOAD_ERROR.FILE_CANCELLED:
                // If there aren't any files left (they were all cancelled) disable the cancel button
                if (this.getStats().files_queued === 0) {
                    //document.getElementById(this.customSettings.cancelButtonId).disabled = true;
                }
                progress.setStatus("已经取消上传");//Cancelled
                progress.setCancelled();
                break;
            case SWFUpload.UPLOAD_ERROR.UPLOAD_STOPPED:
                progress.setStatus("上传停止");//停止
                break;
            default:
                progress.setStatus("未知错误: " + errorCode);//Unhandled Error
                this.debug("Error Code: " + errorCode + ", File name: " + file.name + ", File size: " + file.size + ", Message: " + message);
                break;
        }
    } 
    catch (ex) {
        this.debug(ex);
    }
}

function uploadComplete(file){
    if (this.getStats().files_queued === 0) {
        currentUpload.totalSize = 0;
        currentUpload.uploaded = 0;
        currentUpload.oneFileUpload.tempUpload = 0;
        //document.getElementById(this.customSettings.cancelButtonId).disabled = true;
       // $("#uploadpanel").find('.dialog-button a').first().hide();
	   hideCancelButton(true);
    }
}

// This event comes from the Queue Plugin
function queueComplete(numFilesUploaded){
    currentUpload.totalSize = 0;
    currentUpload.uploaded = 0;
    currentUpload.oneFileUpload.tempUpload = 0;
    //$("#uploadpanel").find('.dialog-button a').first().hide();
	setUploadWinTitle("");
	hideCancelButton(true);
   // DoAction.reLoad();
	/*
    if (KliveConfig.popFirstUpload == 2) {
        $.modal.close();
        window.setTimeout(function(){
            try {
                if (firstUpload.getStats().files_queued == 0) {
                    $('#showup').html('上传文件')
                }
            } 
            catch (e) {
            
            }
            $("#wishuser").modal(); // HTML
            KliveConfig.popFirstUpload = 3;
            $('#showup').show();
            $("#uploadpanel").parent('div').css('visibility', 'hidden');
            
        }, 1000);
    }
    */
    // var status = document.getElementById("divStatus");
    // status.innerHTML = numFilesUploaded + " 个文件已经上传.";
}
