<%

'==============================================================================
'ļ:Cls_DrpChart.asp
'ժ  Ҫ:
'==============================================================================

Class DrpChart
 	'// Start Properties:
 	Public pbChartType			'// [number] 1:Pie, 2:Bar, 3:Line
 	Public pbChartWidth		'// [number] Width of Chart
 	Public pbChartHeight		'// [number] Height of Chart
 	Public pbChartShadow		'// [booleen] 0:No shadow, 1:Shadow
 	Public pbChartTitle			'// [string] Title Name of Chart
 	Public pbChartBgColor		'// [string RGB] Background Chart
 	
 	Public pbLegendFontSize	'// [number] Legend font size
 	Public pbLegendFontName	'// [string] Legend font name
 	
 	Public pbTitleBgColor		'// [string RGB] Title BgColor
 	Public pbTitleFontName		'// [string] Title Font name
 	Public pbTitleFontSize		'// [number] Title Font size
 	Public pbTitleBorderWidth	'// [number] Title Border width
 	Public pbTitleShadow		'// [booleen] 0:NotShow, 1:Show
 	
 	Public pbRowMember		'// [number] How many row of array
 	Public pbArrMember		'// [array] Data Array(n, 3) {FORMAT: (LegendCode[n,0], LegendName[n,1], value[n,2], url[n,3])}
 	'______________________________________________________
 	'// Start my private:
 	
	Private p_strChart, p_strFooter, p_btnChartShadow, p_strChartBgColor, p_strTitleBgColor
	Private p_TotalValue, p_RowMember
	'______________________________________________________
	
  	'//This fires when an instance of the class is created
       Private Sub Class_Initialize()
		pbChartType 		= 1
      		pbChartWidth 		= 400
     	 	pbChartHeight 	= 300
      		pbChartShadow 	= 1
      		pbChartTitle 		= "drp Chart"
      		pbChartBgColor 	= "#FFFFFF"
      		'======================
      		pbLegendFontSize 	= 8
      		pbLegendFontName= "Tahoma"
      		'======================
      		pbTitleBgColor 	= "#ECE9D8"
      		pbTitleFontName 	= "Vernada"
      		pbTitleFontSize 	= 12
       End Sub
       '______________________________________________________
       
       '//This fires when the instance of the class is destroyed
       Private Sub Class_Terminate()
       	'//nothing
	End Sub
	'______________________________________________________
	
       '//Method: innitial properties before send value to Method GenVML
       Private Sub PropInit()
       	
		'// Legend Font size    -------------------------------------------------------------
      		If IsEmpty(pbLegendFontSize) Then
            		p_LegendFontSize = 8
      		Else
            		p_LegendFontSize = pbLegendFontSize
      		End If
      
      		'// Legend Font Name    -------------------------------------------------------------
      		If IsEmpty(pbLegendFontName) Then
            		p_LegendFontName = "Tahoma"
      		Else
            		p_LegendFontName = pbLegendFontName
      		End If
      
    		'//Chart Shadow    -------------------------------------------------------------
    		If IsEmpty(pbChartShadow) Then
        		p_btnChartShadow = "True"
    		Else
        		p_btnChartShadow = pbChartShadow
    		End If
        
    		'// Chart BGColor   -------------------------------------------------------------
    		If IsNull(pbChartBgColor) Then
        		p_strChartBgColor = "#FFFFFF"
    		Else
        		p_strChartBgColor = pbChartBgColor
    		End If
      
    		'// Title BGColor   -------------------------------------------------------------
    		If IsEmpty(pbTitleBgColor) Then
        		p_strTitleBgColor = "#D1D1E9"
    		Else
        		p_strTitleBgColor = pbTitleBgColor
    		End If
    
    		'// get row of array      -------------------------------------------------------------
    		p_RowMember = UBound(pbArrMember) + 1	
    
	End Sub
       '______________________________________________________
       
       Private Sub CalcTotal()
       Dim mTotalTemp
		mTotalTemp = 0
		For i =1 To UBound(pbArrMember)+1
			mTotalTemp = mTotalTemp + pbArrMember(i-1, 2)
		Next
		p_TotalValue = mTotalTemp
    	End Sub
       '______________________________________________________
       
	Public Sub GenVML()
	Dim mStrColor(9)	'// Hold color 10
		mStrColor(0)	= "#330099"
		mStrColor(1)	= "#00CC33"
		mStrColor(2)	= "#CC0033"
		mStrColor(3)	= "#FF9900"
		mStrColor(4)	= "#999966"
		mStrColor(5)	= "#FF0033"
		mStrColor(6)	= "#660033"
		mStrColor(7)  	= "#2E98D1"
		mStrColor(8)	= "#FF80FF"
		mStrColor(9)	= "#330066"
		
		Call PropInit()		'// Check properties
		Call CalcTotal()	'// collect total value of array
		
       	Select Case Cint(pbChartType)
       	Case 1
			Const mPie = 3.141592		'// Pie value
			Dim mIndentTitle, mIndentLeft, mPieSize, mMoveToX, mMoveToY, mIndentToLegend
			
			mIndentTitle		= 30		'// indent from Top of Border
			mIndentUnderTitle = 50		'// indent from under Title 
			mIndentLeft 		= 70		'// indent from left border for render label

			'// Check Width, Height of Chart for indent from left(X), top(Y)
       		If  pbChartHeight < 300 Then
				mIndentTitle 	= 60
				mIndentLeft 	= 50
			End If

			'// If pbChartWidth > pbChartHeight, resize Pie size
			If pbChartWidth > pbChartHeight Then
				mPieSize	= pbChartHeight * 0.2
			Else
				mPieSize	= pbChartWidth * 0.2
			End If

			'// retrive mPieSize and plus align left(X), top(Y)
			mMoveToX	= mPieSize + mIndentLeft
			mMoveToY	= mPieSize + (mIndentTitle + mIndentUnderTitle)
		
			'// create area by v:group
			p_strChart = p_strChart & "<v:group style='antialias:true; position:relative; width:" & pbChartWidth & _
									"px; height:" & pbChartHeight& "px; left:0px; top:0px;' " & _
									"coordsize='" & pbChartWidth& ", " & pbChartHeight & "'>" & vbcrlf
			'// draw border of chart
			p_strChart = p_strChart & "<v:roundrect style='width:" & pbChartWidth& "; height:" & _
									pbChartHeight & ";' fillcolor='" & p_strChartBgColor & "'>" &  vbcrlf
			p_strChart = p_strChart & "<v:shadow on=" & p_btnChartShadow& " offset='3pt,3pt' color='silver' />" &  vbcrlf
			p_strChart = p_strChart & "</v:roundrect>"

			'// draw Title of Chart
			p_strChart = p_strChart & "<v:rect style='position:absolute; left:0px; top:0px; width:" & pbChartWidth& "px; " & _
									"height:30px' strokewidth='0.5' strokecolor='#000000' fillcolor='" & p_strTitleBgColor & "'>" &  vbcrlf
			p_strChart = p_strChart & "<v:textbox style='font-family:" & pbTitleFontName & "; font-size:" & pbTitleFontSize& "pt;" & _
									"font-weight:bold; text-align:center'>" & pbChartTitle & "</v:textbox>"
			p_strChart = p_strChart & "</v:rect>" &  vbcrlf

			Dim mRunning, mStartAngle, mEndAngle, mAngleCenter, mStartValue, mEndValue
			Dim mLineNavPx		'// value of Navigator Line that point to each slice (pixel)
			
			mLineNavPx	= 30
			mRunning = 0

			'// Loop through all values
			For i = 1 To p_RowMember
			
				'//Get start and end angle
				mStartAngle	= 360*(mRunning / p_TotalValue)
				mRunning	= mRunning + pbArrMember(i-1, 2)
				mEndAngle	= (360 * (mRunning / p_TotalValue)) - mStartAngle
	
				'// Get the center angle for this slice.  This is the angle the label line
				mAngleCenter	= mStartAngle + ((mEndAngle) / 2)
	
				'// Convert the angles to vector values
				mStartValue	= CLng(mStartAngle * (2^16))
				mEndValue	= CLng(mEndAngle * (2^16))
	
				p_strChart = p_strChart & "<v:shape onMouseOver=""this.strokecolor='#FF0000'; this.strokeweight='2px';"" " & _
										"OnMouseOut=""this.strokecolor='White';this.strokeweight='0.25px';"" "  & vbcrlf
				If pbArrMember(i-1, 3) <> "" Then p_strChart = p_strChart & "OnClick=""alert(this.title);"" "
				
				p_strChart = p_strChart & "title='" & pbArrMember(i-1, 0) & ", value=" & FormatNumber(pbArrMember(i-1, 2),2,-1) & _
										" [" & FormatNumber(100*(pbArrMember(i-1, 2)/p_TotalValue), 2) & "%]' " & _
										"id='" & pbArrMember(i-1, 0) & "' style='cursor:hand; width:" & pbChartWidth & _
										"px; height:" & pbChartHeight & "px;' strokecolor='white' strokeweight='.25px' " & _
										"path='M " & mMoveToX & " " & mMoveToY& " AE " & mMoveToX& " " & mMoveToY & _
										" " & mPieSize & " " & mPieSize& " " &  mStartValue& " " & mEndValue& " X E'>" &  vbcrlf
				p_strChart = p_strChart & "<v:fill type='gradient' color='" & mStrColor(i-1) & "' color2='" & _
										mStrColor(i-1) & "' angel='20' opacity='50%' />" &  vbcrlf
				p_strChart = p_strChart & "</v:shape>" &  vbcrlf
	
				'// Show Legend
				p_strChart = p_strChart & "<v:roundrect arcsize='0.2' style='position:absolute; left:" & _
										(mMoveToX + (mPieSize*2)) & "px; top:" & mIndentUnderTitle + ((i-1) * 25) & "px; " & _		
										"width:20px; height:12px;' strokecolor='white' fillColor='" & mStrColor(i-1) & "'>" &  vbcrlf
				p_strChart = p_strChart & "<v:shadow on=" & p_btnChartShadow & " offset='1pt,1pt' color='silver' />" &  vbcrlf
				p_strChart = p_strChart & "</v:roundrect>" &  vbcrlf
				p_strChart = p_strChart & "<v:textbox style='position:absolute; left:" &  35 +(mMoveToX + (mPieSize*2))  & _
										"px; top:" &  mIndentUnderTitle + ((i-1) * 25) + 2 & "px; " & _
										"width:200px; height:12px; color:black; font-family:" & pbLegendFontName & _
										"; font-size:" & pbLegendFontSize & "pt; font-weight:normal; " & _
										"text-align:left; v-text-wrapping:true;'>" & pbArrMember(i-1, 1) & "</v:textbox>" &  vbcrlf
				
				If mAngleCenter >=0 And mAngleCenter <=90 Then
					'// Top Right quadrant
					iStartY	= -1 * (mPieSize * Sin(mAngleCenter * (mPie / 180)))
					iStartX	= 1 * (mPieSize * Cos(mAngleCenter * (mPie / 180)))
					iEndY 	= -1 * ((mPieSize+mLineNavPx) * Sin(mAngleCenter * (mPie / 180)))
					iEndX 	= 1 * ((mPieSize+mLineNavPx) * Cos(mAngleCenter * (mPie / 180)))
					sBoxPos 	= "position:absolute;left:" & (mMoveToX + iEndX) - 5 & ";top:" & _
								(mMoveToY + iEndY) - 10  & ";text-align:left;width:120;height:20;" & vbcrlf
				ElseIf mAngleCenter > 90 And mAngleCenter <= 180 Then
					'// Top Left quadrant
					mAngleCenter = 180 - mAngleCenter
					iStartY 	= -1 * (mPieSize * Sin(mAngleCenter * (mPie / 180)))
					iStartX 	= -1 * (mPieSize * Cos(mAngleCenter * (mPie / 180)))
					iEndY 	= -1 * ((mPieSize+mLineNavPx) * Sin(mAngleCenter * (mPie / 180)))
					iEndX 	= -1 * ((mPieSize+mLineNavPx) * Cos(mAngleCenter * (mPie / 180)))
					'// minus 120 is Width of the Text Box Because we align rigth the text
					sBoxPos 	= "position:absolute;left:" &(mMoveToX + iEndX) - 120 & ";top:" & _
								(mMoveToY + iEndY) - 10  & ";text-align:right;width:120;height:20;" & vbcrlf
				ElseIf mAngleCenter > 180 And mAngleCenter <= 270 Then
					'// Bottom Left quadrant
					mAngleCenter = 180 + mAngleCenter
					iStartY 	= 1 * (mPieSize * Sin(mAngleCenter * (mPie / 180)))
					iStartX 	= -1 * (mPieSize * Cos(mAngleCenter * (mPie / 180)))
					iEndY 	= 1 * ((mPieSize+mLineNavPx) * Sin(mAngleCenter * (mPie / 180)))
					iEndX 	= -1 * ((mPieSize+mLineNavPx) * Cos(mAngleCenter * (mPie / 180)))
					'// minus 120 is Width of the Text Box Because we align rigth the text
					sBoxPos 	= "position:absolute;left:" & (mMoveToX + iEndX) - 120 & ";top:" & _
								(mMoveToY + iEndY) + 5  & ";text-align:right;width:120;height:20;" & vbcrlf
				ElseIf mAngleCenter > 270 And mAngleCenter <= 360 Then
					'// Bottom Right quadrant
					mAngleCenter = 360 - mAngleCenter
					iStartY 	= 1 * (mPieSize * Sin(mAngleCenter * (mPie / 180)))
					iStartX 	= 1 * (mPieSize * Cos(mAngleCenter * (mPie / 180)))
					iEndY 	= 1 * ((mPieSize+mLineNavPx) * Sin(mAngleCenter * (mPie / 180)))
					iEndX 	= 1 * ((mPieSize+mLineNavPx) * Cos(mAngleCenter * (mPie / 180)))
					sBoxPos 	= "position:absolute;left:" & (mMoveToX + iEndX) & ";top:" & _
								(mMoveToY + iEndY) + 5  & ";text-align:left;width:120;height:20;" & vbcrlf
				End If
		
				'// If we want to display the labels, draw the line
				'//sLabel = pbArrMember(i-1, 0)
				sLabel = FormatNumber(100*(pbArrMember(i-1, 2)/p_TotalValue),2, -1, -1) & "%"
		
				p_strChart = p_strChart & "<v:line style='position:absolute; left:0px; top:0px;' " & _
										"from='" & mMoveToX+iStartX & " " & mMoveToY+iStartY & "' " & _
										"to='" & mMoveToX+iEndX & " " & mMoveToY+iEndY & "' strokecolor='black'>" & vbcrlf
				p_strChart = p_strChart & "<v:stroke startarrow='oval' startarrowlength='short' startarrowwidth='short' />"
				p_strChart = p_strChart & "</v:line>"
				p_strChart = p_strChart & "<v:textbox style='" & sBoxPos & " font-family:Tahoma; font-size:7pt;'>" & sLabel & "</v:textbox>"

			Next
       		'=====================================================
       		
       		Case Else
       			p_strChart = p_strChart & "Case Else"
       	End Select
       	
       	p_strChart = p_strChart & "</v:group>"
       	
       	Response.write p_strChart
       	Call ClearValue()	'/// Clear data
    	End Sub
    	'_____________________________________________________
    	
	Private Sub ClearValue()
    		p_strChart = ""
    		Erase pbArrMember
	End Sub
	'_____________________________________________________
    	
End Class
%>