# [2.2.0](https://github.com/lc-soft/LCUI/compare/v2.1.0...v2.2.0) (2021-05-30)


### 问题修复

* conditional jump or move depends on uninitialised value(s) ([7174868](https://github.com/lc-soft/LCUI/commit/717486861541b93e5ab95a246dfce90650d4273c))
* **gui:** 水平滚动条未起作用 ([#219](https://github.com/lc-soft/LCUI/issues/219)) ([31dee24](https://github.com/lc-soft/LCUI/commit/31dee2494d7e5c88af02052084f962cf71797141))
* **gui:** 当部件的定位为绝对定位时，尺寸计算错误 ([35bfa3f](https://github.com/lc-soft/LCUI/commit/35bfa3f0e7d92c53f95fa9825217d115df8c74c0))
* **gui:** 组件在隐藏后未更新样式 ([f0a6e30](https://github.com/lc-soft/LCUI/commit/f0a6e30a6d85d466cbfffc5fd0c2e91aacb574c9))
* **image:** 图片后缀名检测方式错误 ([46095e7](https://github.com/lc-soft/LCUI/commit/46095e70e39e5f1440fb1b5b9effaa35b76c6bbe))
* **util:** 当 dict 的操作函数被编译器内联时会报错 ‘NULL’ 未声明 ([c9c9901](https://github.com/lc-soft/LCUI/commit/c9c990167d44da9ca54fd3fed5753567aade1825))
* 移除错误的 `CSSParser_GetRuleParser()` 宏 ([3bd6b71](https://github.com/lc-soft/LCUI/commit/3bd6b715729255607760abadbf72c22d8c2681c8))
* LCUI_PostSimpleTask() 中的变量命名冲突 ([f0382d4](https://github.com/lc-soft/LCUI/commit/f0382d435a5b0d19a14165101605e7f021191e8a))

### 新功能

* **font:** 添加 TextStyle 的操作函数 ([c0ccdf8](https://github.com/lc-soft/LCUI/commit/c0ccdf81e5404fc21cd804ec95e0a030800a75fc))


# [2.1.0](https://github.com/lc-soft/LCUI/compare/v2.0.0...v2.1.0) (2020-07-05)


### 问题修复

* wasm-ld: error: duplicate symbol: self ([2b0424c](https://github.com/lc-soft/LCUI/commit/2b0424c))
* **display:** rect_array 未被释放 ([224c433](https://github.com/lc-soft/LCUI/commit/224c433))
* **gui:** 部件销毁后未标记无效区域 ([8e1f136](https://github.com/lc-soft/LCUI/commit/8e1f136))
* **gui:** TextView_SetTextW() 段错误 ([#195](https://github.com/lc-soft/LCUI/issues/195)) ([a10df88](https://github.com/lc-soft/LCUI/commit/a10df88))
* **ime:** 设置输入框文本光标时段错误 ([0b644e1](https://github.com/lc-soft/LCUI/commit/0b644e1))
* **linux:** 在窗口处于最小尺寸时渲染会出现段错误 ([#200](https://github.com/lc-soft/LCUI/issues/200)) ([#201](https://github.com/lc-soft/LCUI/issues/201)) ([fa23f89](https://github.com/lc-soft/LCUI/commit/fa23f89))
* **mainloop:** 将事件触发器从 OpenMP 并行循环中移出以解决主线程阻塞问题 ([#204](https://github.com/lc-soft/LCUI/issues/204)) ([#205](https://github.com/lc-soft/LCUI/issues/205)) ([6978f46](https://github.com/lc-soft/LCUI/commit/6978f46))


### 新功能

* 添加 settings 接口 ([#191](https://github.com/lc-soft/LCUI/issues/191)) ([#211](https://github.com/lc-soft/LCUI/issues/211)) ([#212](https://github.com/lc-soft/LCUI/issues/212)) ([1b8c6e6](https://github.com/lc-soft/LCUI/commit/1b8c6e6))


# [2.0.0](https://github.com/lc-soft/LCUI/compare/v1.3.0...v2.0.0) (2020-03-01)

### 问题修复

* **builder:** 注释结点应该被忽略 ([460ee00](https://github.com/lc-soft/LCUI/commit/460ee00))
* **css:** 使用了未初始化的值 ([44486f1](https://github.com/lc-soft/LCUI/commit/44486f1))
* **font:** 字体路径获取错误 ([#187](https://github.com/lc-soft/LCUI/issues/187)) ([6d54685](https://github.com/lc-soft/LCUI/commit/6d54685))
* **font:** FontBitmap_Free() 内存泄露 ([c47a6c0](https://github.com/lc-soft/LCUI/commit/c47a6c0))
* **gui:** 根部件缺少 hover 和 active 状态 ([02c03c7](https://github.com/lc-soft/LCUI/commit/02c03c7))
* **gui:** 调整空窗口的尺寸时出现段错误 ([#199](https://github.com/lc-soft/LCUI/issues/199)) ([56ce0b5](https://github.com/lc-soft/LCUI/commit/56ce0b5))
* **gui:** TextCaret 应该在销毁后移除定时器 ([a58b12d](https://github.com/lc-soft/LCUI/commit/a58b12d))
* **linux:** InitLinuxKeybord() 内存泄漏 ([61cadc8](https://github.com/lc-soft/LCUI/commit/61cadc8))
* **timer:** 在移除定时器后，其回调依然会被执行 ([43233b3](https://github.com/lc-soft/LCUI/commit/43233b3))
* **util:** dict 类型未正确导出 ([20abb19](https://github.com/lc-soft/LCUI/commit/20abb19))
* **windows:** 未默认启用触控支持 ([bc7710a](https://github.com/lc-soft/LCUI/commit/bc7710a))
* 纠正变量的使用 ([513b3b9](https://github.com/lc-soft/LCUI/commit/513b3b9))
* 光标的位置应该在处理部件事件之前更新 ([83fc949](https://github.com/lc-soft/LCUI/commit/83fc949))

### 代码重构

* **gui:** 添加 widget_background.h ([d69fbb0](https://github.com/lc-soft/LCUI/commit/d69fbb0))
* **gui:** 添加 widget_border.h ([843232e](https://github.com/lc-soft/LCUI/commit/843232e))
* **gui:** 添加 widget_shadow.h ([08ed51c](https://github.com/lc-soft/LCUI/commit/08ed51c))
* **gui:** 改进部件更新流程 ([1a50aec](https://github.com/lc-soft/LCUI/commit/1a50aec))

### 新功能

* **builder:** 在出错时输出详细内容 ([f7ed3b8](https://github.com/lc-soft/LCUI/commit/f7ed3b8))
* **css:** 添加 flexbox 相关属性解析器 ([07d2911](https://github.com/lc-soft/LCUI/commit/07d2911))
* **display:** 添加 LCUIDisplay_EnablePaintFlashing() ([298ffa4](https://github.com/lc-soft/LCUI/commit/298ffa4))
* **display:** 闪烁已渲染的矩形区域 ([#180](https://github.com/lc-soft/LCUI/issues/180)) ([#190](https://github.com/lc-soft/LCUI/issues/190)) ([5ad4fec](https://github.com/lc-soft/LCUI/commit/5ad4fec))
* **display:** 设置最小屏幕尺寸为 320x240 ([317df70](https://github.com/lc-soft/LCUI/commit/317df70))
* **gui:** 添加 CSSFontStyle_IsEquals() ([80d4149](https://github.com/lc-soft/LCUI/commit/80d4149))
* **gui:** 添加弹性盒子布局 ([3cbb246](https://github.com/lc-soft/LCUI/commit/3cbb246))
* **gui:** 更改部件原型上的 runtask() 方法的参数和调用时机 ([f058916](https://github.com/lc-soft/LCUI/commit/f058916))
* **gui:** 重写部件布局系统 ([24e89aa](https://github.com/lc-soft/LCUI/commit/24e89aa))
* **gui:** 滚动条部件将会在容器销毁后重置 ([61e0f2c](https://github.com/lc-soft/LCUI/commit/61e0f2c))
* **gui:** 在滚动条可见时设置容器的内间距 ([a436f41](https://github.com/lc-soft/LCUI/commit/a436f41))
* **gui:** unwrap() 将会为没给子部件触发 link 和 unlink 事件 ([48344bc](https://github.com/lc-soft/LCUI/commit/48344bc))
* **gui:** 更新TextView 尺寸变动规则 ([ea7e9d2](https://github.com/lc-soft/LCUI/commit/ea7e9d2))
* **util:** 使用内联函数代替全局变量 ([0991d14](https://github.com/lc-soft/LCUI/commit/0991d14))

### 性能改进

* **display:** 主窗口尺寸改变后无需添加无效区域 ([b0985a2](https://github.com/lc-soft/LCUI/commit/b0985a2))
* **display:** OpenMP 将只在渲染区域较大时启用 ([1e57d9d](https://github.com/lc-soft/LCUI/commit/1e57d9d))
* **gui:** 改进部件的无效区域收集方式 ([e9ea262](https://github.com/lc-soft/LCUI/commit/e9ea262))
* **gui:** 改进 TextEdit 部件的更新流程 ([bbb7cbc](https://github.com/lc-soft/LCUI/commit/bbb7cbc))
* **gui:** 改进 TextView 部件的更新流程 ([6824735](https://github.com/lc-soft/LCUI/commit/6824735))
* 为部件渲染添加 OpenMP 支持 ([#118](https://github.com/lc-soft/LCUI/issues/118)) ([#189](https://github.com/lc-soft/LCUI/issues/189)) ([d858333](https://github.com/lc-soft/LCUI/commit/d858333))
* 改进表面 (Surface) 的无效区域的收集方式 ([c81da29](https://github.com/lc-soft/LCUI/commit/c81da29))

### 不兼容变动

* **util:** `DictType_StringKey` and `DictType_StringCopyKey` 已改用内联函数代替
* **display:** 已移除 `LCUIDisplay_ShowRectBorder()` 和 `LCUIDisplay_HideRectBorder()`
* **gui:** 部件的阴影操作接口已改为私有
* **gui:** 部件的背景操作接口已改为私有
* **gui:** 部件的边框操作接口已改为私有
* **gui:** TextView 部件必须在 UI 线程中操作
* **gui:** 部件原型上的 runtask() 方法接受两个参数，并且会在每个任务被处理后调用
* **gui:** 一些部件操作接口已重命名或已移除

# [1.3.0](https://github.com/lc-soft/LCUI/compare/v1.2.0-beta...v1.3.0) (2019-10-07)

### 问题修复

* C++ "operator" 关键字冲突 ([5a5ba8c](https://github.com/lc-soft/LCUI/commit/5a5ba8c))
* **css:** 设置字体样式解析器的 style_handler 后未起作用 ([6869683](https://github.com/lc-soft/LCUI/commit/6869683))
* **display:** X11Surface_SetCaptionW() 内存泄漏 ([484c3d7](https://github.com/lc-soft/LCUI/commit/484c3d7))
* **font:** 当 font_size > 18 时字体位图获取失败 ([d6315c5](https://github.com/lc-soft/LCUI/commit/d6315c5))
* **gui:** 部件的默认边框颜色应为透明 (transparent) ([5164955](https://github.com/lc-soft/LCUI/commit/5164955))
* **gui:** 当部件 pointer-events 为 none 时的事件目标选择问题 ([0f26c8b](https://github.com/lc-soft/LCUI/commit/0f26c8b))
* **gui:** TextEdit 占位符未起作用 ([d827767](https://github.com/lc-soft/LCUI/commit/d827767))
* **gui:** mousemove 事件应在 mouseout 事件前触发 ([5020b91](https://github.com/lc-soft/LCUI/commit/5020b91))
* **gui:** 部件属性值应始终有效 ([4b0a2ed](https://github.com/lc-soft/LCUI/commit/4b0a2ed))
* **ime:** 输入法候选词窗口定位问题 ([#36](https://github.com/lc-soft/LCUI/issues/36), [#175](https://github.com/lc-soft/LCUI/issues/175)) ([1107f91](https://github.com/lc-soft/LCUI/commit/1107f91))
* **renderer:** 部件内容区渲染不正确 ([f8b0f8b](https://github.com/lc-soft/LCUI/commit/f8b0f8b))
* **util:** Object_Operate() 中的对象类型判断不正确 ([a326e8c](https://github.com/lc-soft/LCUI/commit/a326e8c))
* **util:** ParseUrl() 解析结果不正确 ([3f9450c](https://github.com/lc-soft/LCUI/commit/3f9450c))

### 新功能

* 添加 LCUI_GetVersion() ([de40c7c](https://github.com/lc-soft/LCUI/commit/de40c7c))
* 添加圆角边框渲染，改进盒阴影渲染 ([#174](https://github.com/lc-soft/LCUI/issues/174)) ([f36d071](https://github.com/lc-soft/LCUI/commit/f36d071))
* 添加 include/LCUI.h 文件 ([#173](https://github.com/lc-soft/LCUI/issues/173)) ([113af6a](https://github.com/lc-soft/LCUI/commit/113af6a))
* **builder:** 标签名称可以是一个已存在的部件类型名称 ([4f6a01c](https://github.com/lc-soft/LCUI/commit/4f6a01c))
* **css:** 将 CSSFontStyle_* 系列函数改为公共函数 ([568c915](https://github.com/lc-soft/LCUI/commit/568c915))
* **graph:** 添加 LCUI_OverPixel() ([d8075d9](https://github.com/lc-soft/LCUI/commit/d8075d9))
* **gui:** 添加 canvas 部件 ([e246843](https://github.com/lc-soft/LCUI/commit/e246843))
* **gui:** 添加 Widget_CollectReferences() ([811585b](https://github.com/lc-soft/LCUI/commit/811585b))
* **gui:** 添加 Widget_Each() ([2d7d1ee](https://github.com/lc-soft/LCUI/commit/2d7d1ee))
* **logger:** 支持设置日志等级 ([173b92f](https://github.com/lc-soft/LCUI/commit/173b92f))
* **scrollbar:** 从容器捕获 touch 和 mousewheel 事件 ([f2f9162](https://github.com/lc-soft/LCUI/commit/f2f9162))

# [1.2.0-beta](https://github.com/lc-soft/LCUI/compare/v1.1.0-beta...v1.2.0-beta) (2019-06-17)

### 问题修复

* **textlayer:** 纠正文本行高计算 ([#169](https://github.com/lc-soft/LCUI/issues/169)) ([a4d2f0a](https://github.com/lc-soft/LCUI/commit/a4d2f0a))

### 新功能

* **gui:** 为部件原型设置默认方法 ([e68e8e5](https://github.com/lc-soft/LCUI/commit/e68e8e5))
* **gui:** 添加 TextEdit_BindProperty() ([c9d8ded](https://github.com/lc-soft/LCUI/commit/c9d8ded))
* **gui:** 添加 Widget_BindProperty() ([0d3fb68](https://github.com/lc-soft/LCUI/commit/0d3fb68))
* **gui:** 添加 Widget_SetStyleString() ([5163363](https://github.com/lc-soft/LCUI/commit/5163363))
* **gui:** 添加 Widget_SetText() ([02714bf](https://github.com/lc-soft/LCUI/commit/02714bf))
* **textedit:** 添加 TextEdit_GetProperty() ([512706e](https://github.com/lc-soft/LCUI/commit/512706e))
* **util:** 添加对象包装和操作集 ([241c652](https://github.com/lc-soft/LCUI/commit/241c652))
* **util:** 添加 Object_ToString() ([13465c7](https://github.com/lc-soft/LCUI/commit/13465c7))

# [1.1.0-beta](https://github.com/lc-soft/LCUI/compare/v1.0.0-beta.4...v1.1.0-beta) (2019-03-09)


### 问题修复

* **builder:** 在追加部件前应该将其初始化 ([f12e00b](https://github.com/lc-soft/LCUI/commit/f12e00b))
* **gui:** focus 事件和 "focusable" 属性解析问题 ([d9a39a5](https://github.com/lc-soft/LCUI/commit/d9a39a5))
* **gui:** 当 pointer-events 为 none 时应该忽略鼠标事件 ([fc54a64](https://github.com/lc-soft/LCUI/commit/fc54a64))
* **gui:** TextEdit 应该在失去焦点后重置光标的位置 ([8de4e71](https://github.com/lc-soft/LCUI/commit/8de4e71))
* **gui:** TextEdit_SetTextW() 未清空之前的内容 ([51eef68](https://github.com/lc-soft/LCUI/commit/51eef68))
* **gui:** Button 的高度与 TextEdit 不一致 ([5a918da](https://github.com/lc-soft/LCUI/commit/5a918da))
* **gui:** 设置部件外边距时会导致宽度计算错误 ([#167](https://github.com/lc-soft/LCUI/issues/167)) ([d14023e](https://github.com/lc-soft/LCUI/commit/d14023e))
* **thread:** LCUIThread_Join() 未等待线程退出 ([4ddb833](https://github.com/lc-soft/LCUI/commit/4ddb833))
* **util:** 解码后的字符串长度不应将结束符计算在内 ([93f3d77](https://github.com/lc-soft/LCUI/commit/93f3d77))
* **worker:** 运行任务时不应阻塞任务队列 ([2b41f54](https://github.com/lc-soft/LCUI/commit/2b41f54))


### 新功能

* **gui:** 添加支持自定义部件更新规则 ([bdd1d1c](https://github.com/lc-soft/LCUI/commit/bdd1d1c))
* **gui:** 添加支持限制最大的子部件渲染数量 ([ec5e0d6](https://github.com/lc-soft/LCUI/commit/ec5e0d6))
* **gui:** 添加 `only_on_visible ` 规则，用于允许仅在部件可见时更新它 ([93049c4](https://github.com/lc-soft/LCUI/commit/93049c4))
* **gui:** 添加 `cache_children_style` 规则，用于缓存子部件样式 ([50cc6b2](https://github.com/lc-soft/LCUI/commit/50cc6b2))
* **gui:** 添加 `first_update_visible_children` 规则，用于优先更新可见的子部件 ([4cd6fdc](https://github.com/lc-soft/LCUI/commit/4cd6fdc))
* **gui:** 添加部件边框样式相关操作接口 ([e8d52df](https://github.com/lc-soft/LCUI/commit/e8d52df))
* **gui:** 添加 Widget_GetClosest() ([e740138](https://github.com/lc-soft/LCUI/commit/e740138))
* **gui:** 添加 Widget_SetHashList() ([f466dee](https://github.com/lc-soft/LCUI/commit/f466dee))
* **gui:** 自动为事件名生成 id ([fee31b0](https://github.com/lc-soft/LCUI/commit/fee31b0))
* **gui:** Widget_SetAttribute() 将会调用 proto->setattr() ([19992d1](https://github.com/lc-soft/LCUI/commit/19992d1))
* **textview:** 添加 TextView_SetColor() ([3a7b53f](https://github.com/lc-soft/LCUI/commit/3a7b53f))
* **util:** 为 LCUIRect_ValidateArea() 添加返回值 ([2fa6cf3](https://github.com/lc-soft/LCUI/commit/2fa6cf3))
* **util:** 添加 strhash() ([ebf843f](https://github.com/lc-soft/LCUI/commit/ebf843f))
* **util:** 添加 strpool ([c843df1](https://github.com/lc-soft/LCUI/commit/c843df1))
* **util:** 添加 strreplace() ([409395d](https://github.com/lc-soft/LCUI/commit/409395d))
* **util:** 在 Windows 上默认使用 OutputDebugString() 输出日志 ([79ec21b](https://github.com/lc-soft/LCUI/commit/79ec21b))


### 性能改进

* **css:** 更改样式表存储结构以减少内存占用 ([9cc2957](https://github.com/lc-soft/LCUI/commit/9cc2957))
* **css:** 减少重复的 DictType 内存分配 ([01fd3f6](https://github.com/lc-soft/LCUI/commit/01fd3f6))
* **gui:** 改进部件销毁性能 ([87aff87](https://github.com/lc-soft/LCUI/commit/87aff87))
* **gui:** 改进 Widget_Empty() 性能 ([1654963](https://github.com/lc-soft/LCUI/commit/1654963))
* **gui:** 减少部件的样式表的内存占用 ([3790fbd](https://github.com/lc-soft/LCUI/commit/3790fbd))
* **gui:** 移除 TextView 部件中的互斥锁 ([6340d60](https://github.com/lc-soft/LCUI/commit/6340d60))
* **gui:** 使用 strlist 保存 classes 和 status ([f611936](https://github.com/lc-soft/LCUI/commit/f611936))
* **gui:** 更新部件列表的排序方法 ([e9dbcea](https://github.com/lc-soft/LCUI/commit/e9dbcea))
* **gui:** 改用 LCUI_STYPE_INT 代替 LCUI_STYPE_VALUE ([23090eb](https://github.com/lc-soft/LCUI/commit/23090eb))
* **renderer:** 改进渲染目标的选择方法 ([1df08b6](https://github.com/lc-soft/LCUI/commit/1df08b6))



# [1.0.0-beta.4](https://github.com/lc-soft/LCUI/compare/v1.0.0-beta.3...v1.0.0-beta.4) (2018-11-19)

### 问题修复

* **dirent:** LCUI_ReadDirW() UNINITIALIZED READ ([dd610ad](https://github.com/lc-soft/LCUI/commit/dd610ad))
* **display:** 调整窗口尺寸时会暂停渲染 ([#164](https://github.com/lc-soft/LCUI/issues/164)) ([8ad667a](https://github.com/lc-soft/LCUI/commit/8ad667a))
* **display:** 一帧内有过多的重复的脏矩形 ([b5d9040](https://github.com/lc-soft/LCUI/commit/b5d9040))
* **font:** 在加载完字体文件后设置默认字体会失败 ([9b4c005](https://github.com/lc-soft/LCUI/commit/9b4c005))
* **font:** 在模块被重新初始化后，字体编号未重置 ([d75b4ca](https://github.com/lc-soft/LCUI/commit/d75b4ca))
* **gui:** 当部件的显示角色改变后应该更新布局 ([96c1cef](https://github.com/lc-soft/LCUI/commit/96c1cef))
* **gui:** 当模块被销毁时应该清空废弃的部件 ([1ad6be1](https://github.com/lc-soft/LCUI/commit/1ad6be1))
* **gui:** 块级元素的默认宽度应该为 100% ([adcb9e7](https://github.com/lc-soft/LCUI/commit/adcb9e7))
* **gui:** 在销毁部件前应该解除结点 ([3249490](https://github.com/lc-soft/LCUI/commit/3249490))
* **gui:** unlink 事件被重复触发 ([89faa5d](https://github.com/lc-soft/LCUI/commit/89faa5d))
* **gui:** 部件背景图未渲染 ([e76f3f9](https://github.com/lc-soft/LCUI/commit/e76f3f9))
* **gui:** Widget_AutoSize() 不应该改变静态的宽度或高度 ([8bee9c2](https://github.com/lc-soft/LCUI/commit/8bee9c2))
* **ime:** 无法正确识别非 qwerty 键盘布局的按键输入 ([#147](https://github.com/lc-soft/LCUI/issues/147)) ([4b1f050](https://github.com/lc-soft/LCUI/commit/4b1f050))
* **layout:** "left: auto" 被计算为 "left: 0" ([f4990da](https://github.com/lc-soft/LCUI/commit/f4990da))
* **platform:** linux 帧缓存驱动未被销毁 ([#157](https://github.com/lc-soft/LCUI/issues/157)) ([87f79f0](https://github.com/lc-soft/LCUI/commit/87f79f0))
* **renderer:** 当部件整体透明时，子级部件未正确渲染 ([#160](https://github.com/lc-soft/LCUI/issues/160)) ([d13b554](https://github.com/lc-soft/LCUI/commit/d13b554))
* **renderer:** 有透明效果的部件，渲染不正确 ([6668165](https://github.com/lc-soft/LCUI/commit/6668165))
* **textlayer:** 中文文本断行错误 ([1e5a262](https://github.com/lc-soft/LCUI/commit/1e5a262))
* **textlayer:** isalpha() 断言失败 ([cd39a46](https://github.com/lc-soft/LCUI/commit/cd39a46))
* **textview:** 在改变 "content" 属性后没有效果 ([d1ab50d](https://github.com/lc-soft/LCUI/commit/d1ab50d))
* **textview:** 设置文本后未更新自身尺寸 ([31e0582](https://github.com/lc-soft/LCUI/commit/31e0582))
* **util:** LCUI_DirEntry::name 的值不正确 ([367febe](https://github.com/lc-soft/LCUI/commit/367febe))
* **worker:** 工作线程内存访问越界 ([5a7e2c0](https://github.com/lc-soft/LCUI/commit/5a7e2c0))
* 当不支持 jpeg 和 png 时连接器会报错 ([2bbabe1](https://github.com/lc-soft/LCUI/commit/2bbabe1))
* PACKAGE_VERSION 未定义 ([70660de](https://github.com/lc-soft/LCUI/commit/70660de))
* 当系统中存在窗口管理系统时应该隐藏鼠标指针 ([acf9454](https://github.com/lc-soft/LCUI/commit/acf9454))
* LCUI_GetAppId() 返回值不正确 ([46ec607](https://github.com/lc-soft/LCUI/commit/46ec607))
* 在 FreeBSD 上编译时，"linux/input.h" 文件不存在 ([7d95f3f](https://github.com/lc-soft/LCUI/commit/7d95f3f))
* 在 FreeBSD 上编译时，ENODATA 未定义 ([2cd0b27](https://github.com/lc-soft/LCUI/commit/2cd0b27))
* 未解析的外部符号 _Graph_IsValid ([1328a2d](https://github.com/lc-soft/LCUI/commit/1328a2d))

### 新特性

* **builder:** `<resource>` 支持加载 xml 文件 ([d5e162c](https://github.com/lc-soft/LCUI/commit/d5e162c))
* **display:** 自动禁用窗口最大化按钮 ([#164](https://github.com/lc-soft/LCUI/issues/164)) ([82fad1b](https://github.com/lc-soft/LCUI/commit/82fad1b))
* **event:** 添加 ctrl_key 和 shift_key 成员至 LCUI_KeyboardEvent ([6f5f17c](https://github.com/lc-soft/LCUI/commit/6f5f17c))
* **gui:** 添加 Widget_SetOpacity() ([e6ad163](https://github.com/lc-soft/LCUI/commit/e6ad163))
* **gui:** 添加 Widget_SetVisibility() ([145d9ee](https://github.com/lc-soft/LCUI/commit/145d9ee))
* **gui:** 添加 Widget_SetVisible() 和 Widget_SetHidden() ([2f581b8](https://github.com/lc-soft/LCUI/commit/2f581b8))
* **gui:** LCUIWidget_ClearTrash() 返回值为实际销毁的部件数量 ([6262f20](https://github.com/lc-soft/LCUI/commit/6262f20))
* **linux:** 为 x11 系统添加鼠标滚轮事件处理 ([#54](https://github.com/lc-soft/LCUI/issues/54)) ([1061592](https://github.com/lc-soft/LCUI/commit/1061592))
* **linux:** 使用 fontconfig 定位字体文件路径 ([2932246](https://github.com/lc-soft/LCUI/commit/2932246))
* **textview:** 在加载新的字体文件后刷新所有 textview 部件 ([3fcfa99](https://github.com/lc-soft/LCUI/commit/3fcfa99))
* **util:** 添加 OpenUri() ([ec20c99](https://github.com/lc-soft/LCUI/commit/ec20c99))
* 添加 LCUI_MAX_FRAMES_PER_SEC 宏定义 ([6fa2995](https://github.com/lc-soft/LCUI/commit/6fa2995))
* 添加 LCUI_MAX_FRAME_MSEC 宏定义 ([7abc901](https://github.com/lc-soft/LCUI/commit/7abc901))

### 改进

* **charset:** 改进 utf-8 和 unicode 字符串转换 ([1efd856](https://github.com/lc-soft/LCUI/commit/1efd856))
* **graph:** 添加新的图片缩放方式 (issue [#39](https://github.com/lc-soft/LCUI/issues/39)) ([bbfb9af](https://github.com/lc-soft/LCUI/commit/bbfb9af))

## 1.0.0 Beta 3 (2018-05-08)

### 问题修复

* **font:** 因字体缓存位置计算错误而导致的 DeleteFont() 段错误 ([5465c6b](https://github.com/lc-soft/LCUI/commit/5465c6b))
* **timer:** 定时器线程在被创建后可能会立刻退出 ([0b01f88](https://github.com/lc-soft/LCUI/commit/0b01f88))
* **util:** 在 Unix 系统下编译会报错：'struct dirent' has no member named 'd_reclen' ([#141](https://github.com/lc-soft/LCUI/issues/141)) ([0416c42](https://github.com/lc-soft/LCUI/commit/0416c42))

### 新特性

* **platform:** 添加 linux 平台的帧缓存（FrameBuffer）驱动 ([6015838](https://github.com/lc-soft/LCUI/commit/6015838))
* **platform:** 添加 linux 平台的键盘驱动 ([ad3348e](https://github.com/lc-soft/LCUI/commit/ad3348e))
* **platform:** 添加 linux 平台的鼠标驱动 ([0ff7b70](https://github.com/lc-soft/LCUI/commit/0ff7b70))

## 1.0.0 Beta 2 (2018-03-18)

### 问题修复

* 一些内存泄露问题 ([#135](https://github.com/lc-soft/LCUI/issues/135)) ([9995b23](https://github.com/lc-soft/LCUI/commit/9995b23))
* **gui:** 部件大小计算错误 ([095f4b8](https://github.com/lc-soft/LCUI/commit/095f4b8))
* **renderer:** 部件内容区域计算错误 ([#122](https://github.com/lc-soft/LCUI/issues/122),[#123](https://github.com/lc-soft/LCUI/issues/123)) ([0f81863](https://github.com/lc-soft/LCUI/commit/0f81863))
* **renderer:** 部件内容溢出 ([#144](https://github.com/lc-soft/LCUI/issues/144)) ([2a923a6](https://github.com/lc-soft/LCUI/commit/2a923a6))
* **thread:** 线程在退出后未释放之前申请的内存资源 ([402bc03](https://github.com/lc-soft/LCUI/commit/402bc03))
* **widget:** 滚动条未取消事件冒泡 ([#145](https://github.com/lc-soft/LCUI/issues/145)) ([7dd60ac](https://github.com/lc-soft/LCUI/commit/7dd60ac))
* **widget:** Scrollbar_BindBox() 在滚动条初始化后未能正常工作 ([196f47c](https://github.com/lc-soft/LCUI/commit/196f47c))
* **widget:** Widget_GetOffset() 返回的结果未包含内间距 ([0a893f4](https://github.com/lc-soft/LCUI/commit/0a893f4))
* **widget-event:** 部件触控事件中的触点坐标未根据全局缩放比例进行转换 ([a40eda2](https://github.com/lc-soft/LCUI/commit/a40eda2))
* **worker:** 工作线程获取新任务前未进入阻塞状态 ([#134](https://github.com/lc-soft/LCUI/issues/134)) ([8dae96f](https://github.com/lc-soft/LCUI/commit/8dae96f))

### 新特性

* **css:** 添加支持解析 "border-left: 0;" ([30de5b8](https://github.com/lc-soft/LCUI/commit/30de5b8))
* **timer:** 添加更具语义的 LCUITimer_SetTimeout() 和 LCUITimer_SetInterval() ([f032f6f](https://github.com/lc-soft/LCUI/commit/f032f6f))
* **widget-event:** 添加 "link" 事件, 重命名 "remove" 事件为 "unlink" ([8c1d105](https://github.com/lc-soft/LCUI/commit/8c1d105))

### 改进

* **widget:** 重命名滚动条的属性名称和 CSS 选择符 ([d397914](https://github.com/lc-soft/LCUI/commit/d397914))

## 1.0 Beta (2018-02-07)

### 新特性

- **font:** 添加支持按字重（font-weight）和风格（font-style）选择字体
- **textlayer:** 添加 `[bgcolor]` 标签支持，用于设置文本背景色 (#110)
- **textlayer:** 添加 `[i]` 标签支持，用于设置文本为斜体 (#115)
- **textlayer:** 添加 `[b]` 标签支持，用于设置文本为粗体 (#112)
- **textlayer:** 使用 FreeType 字体引擎默认的方式获取空格宽度
- **widget:** 为 textview 添加内容修剪支持，启用后会去除文本首尾空白符 (#97)
- **widget:** 添加锚点（anchor）组件 (#105)
- **widget:** 为 textview 添加 word-break 属性支持，用于设置单词断行方式 (#71)
- **widget:** 添加 `WTT_RESIZE_WITH_SURFACE` 任务类型，用于将表面（surface）大小与部件同步 (#104)
- **widget:** 添加 Widget_UnbindEventByHandlerId() 函数，用于根据事件处理器标识号取消事件绑定
- **css:** 添加 font-face 规则解析器，可用于在 css 代码中定义字体信息 (#95)
- **css:** 为 url() 的解析器添加支持处理相对路径 (#98)
- **css:** 添加针对 justify-content 的属性解析器 (#117)
- **css:** 为 border 的属性解析器添加支持解析 "border: 0"
- **css:** 为 line-height 的属性解析器添加支持解析 "line-height: 1"
- **layout:** 添加简单的 flex 显示方式和 justify-content 属性支持 (#117)
- **bulder:** 为 `<widget>` 添加短名称 `<w>` (#103)
- **core:** 添加 LCUIWorker 用于处理异步任务 (#106)

### 问题修复

- **textlayer:** 文本没有垂直居中对齐 (#100)
- **widget:** textview 的高度计算错误 (#111)
- **css:** 样式表选取问题，同名选择器会共用同一优先级 (#113)
- **graphic:** Graph_FillRectARGB() 段错误 (#110)
- **linux:** 设置 "--enable-video-ouput=no" 选项后会导致链接器报错
- **renderer:** 部件位置为非整数时，在渲染时边框会时有时无 (#108)

### 改进

- **layout:** 改进部件尺寸计算
- **layout:** 改进块（block）和内联块（inline-block）元素的布局处理
- **font:** 改进字体数据的存储和操作方式
- **mainloop:** 设置每帧运行任务队列中的所有任务
- **mainloop:** 设置每帧至少更新一次部件树

你可以查看此[拉取请求](https://github.com/lc-soft/LCUI/pull/120)来了解详细的代码变更记录。

## 1.0 alpha 和 1.0 alpha2 之间的变化

- 调整代码结构
- 改进 TextView 部件
- 改进 TextEdit 部件的光标定位与文本渲染
- 改进部件的盒形阴影（box-shadow）绘制
- 添加适用于 UWP 应用的驱动支持，示例应用代码[在这里](https://github.com/lc-soft/LCUI/blob/develop/build/windows/LCUIApp/App.cpp)。
- 改进对高分屏的支持
  - 添加 dp、sp 度量单位，功能与 Android 中的同名单位相似
  - 添加缩放支持，可根据屏幕像素密度设置合适的缩放比例
- 完善自动化构建和测试
  - 添加单元测试
  - 添加代码覆盖率测试
  - 引入 valgrind 内存检查工具
- 解决所有内存泄露和内存访问越界问题
- 解决部件布局功能中存在的一些问题
- 解决 jpeg 图像读取器有时会读取失败的问题
- 其它已知 BUG 修复

你可以查看此[拉取请求](https://github.com/lc-soft/LCUI/pull/83)来了解详细的代码变更记录。

## 0.15.0 和 1.0 alpha 之间的变化

- 改进 bmp、jpeg、png 图片的读取接口
- 添加滚动条（Scrollbar）部件
- 改进按钮（Button）部件
- 改进文本显示（TextView）部件
- 改进文本编辑（TextEdit）部件
- 改进部件的类型、事件、布局及样式处理
- 改进图形界面的性能
- 添加触控支持
- 添加 CSS 和 XML 支持
- 移除 Linux 的帧缓冲（FrameBuffer）支持
- 添加对 Linux 的 XWindow 的支持
- 添加对 Windows 通用应用平台（UWP）的简单支持
- 改进对 Windows 的支持
- 添加部分文档
- 修复部分已知BUG

## 0.14.0 和 0.15.0 之间的变化

- 限制每秒图形更新帧数最大为100，减少CPU占用。
- 调整事件处理模块，添加事件连接的解除功能，部分函数接口做了修改。
- 更新定时器功能模块，修复已知的BUG。
- 更新TextBox和Label部件，优化文本绘制速度，修复部分已知BUG。
- 添加文本的自动换行功能，但仅适用于静态文本显示，若在已启用自动换行功能的TextBox部件中进行文本编辑，可能会出现问题。
- 解决多线程进行文本渲染时导致的文本位图异常、程序崩溃等的问题，现已将文本渲染任务转由主线程单独执行。
- 修复GUI部件的堆叠顺序处理功能中的已知BUG。
- 解决在每次处理GUI部件消息时未完全处理掉全部消息的问题。

本次更新主要针对作者应用LCUI开发的2D格斗游戏，LCUI中的部分已知BUG并未解决，作者计划会在后续版本中修复这些BUG。由于该游戏主要在windows平台上进行开发和测试，因此，虽然部分功能模块对windows平台支持良好，但并不保证也能正常支持GNU/Linux平台。


## 0.13.0 和 0.14.0 之间的变化

- 改进对windows平台的支持，优化了图形输出，改善了对键盘和鼠标的输入支持。
- 可设置视频输出模式，仅在windows平台下有效。
- 解决部分模块的线程安全问题。
- 优化部件图形资源的内存占用。
- 改进部件的消息处理。
- 完善部件的堆叠顺序处理。
- 调整部件的点击事件和拖动事件的处理。
- 部件支持通过设置z-index值来调整堆叠顺序。
- 修改window部件和button部件的风格。
- 添加输入法框架和默认的输入法，目前只支持输入英文字母、数字、符号。
- 对于内置点阵位图的字体文件（例如：宋体），现已能够正常显示字体的点阵位图。
- 解决其它的细节问题。


## 0.12.6 和 0.13.0 之间的变化

- 修改大部分模块的函数命名风格。
- 解决多窗口显示顺序异常的问题。
- 完善GUI部件处理模块。
- 添加事件循环，完善GUI部件的事件机制。
- 完善线程管理模块，封装了linux和win32中常用的线程管理及互斥锁相关的函数。
- 添加win32下的图形输出模块，由于水平有限，目前只能在窗口客户区内输出图形，有待完善。
- 添加字体管理模块，完善字体位图处理模块，优化字体位图的载入速度，减少内存开销。
- 新增GraphLayer模块，用于管理每个部件的图层，LCUI输出的图像主要由该模块处理生成。
- TextBox部件添加占位符功能。
- 添加MessageBox。
- 解决其它的细节问题。

目前已初步实现在windows系统上运行，可直接使用Visual Studio 2012编译此项目，但存在一些问题，有待完善。


## 0.12.5 和 0.12.6 之间的变化

- LCUI类改为LCUIApp类，部分部件的C++类继承自LCUIWidget类，取消之前的类嵌套。
- 重新规划项目源代码，为以后的跨平台、适应不同环境而做准备。
- 新增文本框和滚动条部件，文本框还只具备基本功能，有待继续完善。
- 新增TextLayer模块，用于处理文字位图的绘制。
- 修改label部件代码，label部件和文本框部件的文本位图的绘制都由TextLayer模块实现。
- 修改window部件的默认风格。
- 添加定时器，ActvieBox部件的动画每帧图像的定时更新，改用定时器实现。
- 部件能够获得焦点，可关联FocusIn和FocusOut事件，以在部件获得/失去焦点时作出响应。
- 修改按键输入事件机制，当用键盘输入内容时，按键事件默认发送至已获得焦点的部件。
- 重新规划部件的属性，修改部件的更新处理功能。
- 部件添加padding属性，可调整部件的内边距。
- 部件添加STATIC定位类型，该定位类型的部件将根据显示顺序，自动排列。
- 部件添加dock属性，可设置部件的停靠类型。
- 部件尺寸支持百分比表示，当容器尺寸改变后，该部件的尺寸会随着改变。
	

## 0.12.4 和 0.12.5 之间的变化

- 部分功能模块添加C++类，可使用C++的方式调用，具体请参考helloworld2.cpp的内容。
- 添加ActiveBox部件，用它可实现简单的多帧图像的连贯切换显示。
- 完善了屏幕图形的刷新方法。
- 纠正在嵌套多层窗口时，拖动子窗口消失的问题，原因是子窗口位置计算错误。
- 优化了图形的Alpha混合处理，效率有所提升。
- 解决图像处理的一些问题。
- 图像支持“引用”功能，可引用一个图像中的指定区域的图形数据，无需从图像中裁剪。
- 解决了在PictureBox部件尺寸不大于0时所出现的一些问题。
- 在PictureBox部件未设定图像的情况下，对其设置尺寸模式时不会再出现段错误。
- 完善多部件嵌套时的图形显示处理。
- 完善部件移动时的区域刷新处理。
- 字体文件位置、FrameBuffer设备、等支持用环境变量设置。
- 解决线程阻塞等待自己解锁读写锁的问题，该问题在LCUI退出时出现。
	

## 0.12.3 和 0.12.4 之间的变化

- 纠正了嵌套多个部件所产生的图形显示上的问题。 
- 更改了图形显示处理方式，理论上图形刷新速度会有所提升。
- 部分函数以及数据结构做了修改。
- 新增RadioButton部件和CheckBox部件。
- 事件机制做了修改，添加 鼠标移动/点击事件 和 部件拖动事件 的关联功能。
- 图形数据添加了读写锁功能，以保护数据，避免多个线程对其同时进行读/写。
- 头文件做了修改，使用LCUI库的函数时，可能需要包含相应的头文件。
- 图形输出功能做了修改，支持在非24和32位色的显示器上显示图形。
- 合并了部分源码文件中的源代码。
- configure.ac以及README文件做了修改。

