# LCUI 代码风格

本文档只是描述一些附加的代码风格，主要代码风格可以参考Linux内核的CodingStyle文档：https://github.com/torvalds/linux/blob/master/Documentation/zh_CN/CodingStyle

## 缩进 & 每行字符数限制

代码缩进宽度应设置为8个字符，每一行的代码长度也应限制在80列以内，8个字符的缩进可以让代码更容易阅读，再加上每行字符数的限制，当你的代码缩进层次太深的时候可以给你警告，以提醒你去考虑是否需要调整代码。

限制代码的列数的主要目的不是为了适应那种显示空间有限的终端屏幕，现在的计算机显示屏的分辨率都比较高（但这并不是说你可以把代码写到和屏幕一样宽），有的代码编辑器支持多窗口编辑，通常是两个，左右各一个代码编辑窗口，为了能让代码能够在代码编辑框里完整呈现，减少多余的横向滚动条滚动操作，有必要限制每行代码的列数，因此，决定限制为80列。

由于LCUI项目是一个函数库，其代码处于用户代码的底层，作为底层代码，并且用的是C，不会出现其他编程语言中那种冗长的函数名和很深的代码缩进，因此，LCUI中的代码不应该写得那么冗长、拥挤和臃肿，上述要求对实际编码不会有很大负面影响。

## 标识符的定义

如果你定义的全局变量和函数仅在当前源文件中使用，那么在定义时需在前面加上 static 修饰符，以表示其只用在当前源文件内。

对于宏(#define)、类型定义(typedef)、结构体定义(struct)、枚举(enum)等，如果仅在当前源文件中使用，那么就不应当写在头文件中。

## 函数

一个函数的最大长度是和该函数的复杂度和缩进级数成反比的，如果你的函数中的代码很简单、而且缩进层次较少，那么，这样的函数尽管很长，也是可以的。否则，你应该先重新考虑你的函数是否干了太多的事，然后把它拆分成若干个小函数。

函数中的局部变量的数量不应超过5－10个，否则你的函数就有问题了，你需要做的和上述的一样，对函数代码进行拆分。

在源文件里，使用空行隔开不同的函数。

## 命名规范

### 类型命名

每个单词首字母大写，除去链表、哈希表等基础数据类型外，公共数据类型名称前都必须有 LCUI_ 前缀。

几乎所有的对象类型或类都有相应的**结构类型**和相应的**结构指针类型**，后者被称为类型或类的**句柄类型**。假设有一个名为 `Foo` 的对象类型，那么需要按照如下的方式定义它：

``` c
typedef struct LCUI_FooRec_* LCUI_Foo;
typedef struct LCUI_FooRec_ {
    int number;
    char *string;
} LCUI_FooRec;
```

按照惯例，句柄类型使用简单但有意义的以 `LCUI_` 开头的标识符，如：`LCUI_Foo`，而结构体则使用相同名称并附加一个 Rec 后缀（Rec 是 record 的简写）。

### 变量命名

全小写字母，使用下划线分割。

``` c
int font_family_id;
```

### 函数命名

基础工具类函数，例如字符串拼接、大小写转换等功能，可以使用小写命名，与标准库函数命名风格相近。

对于单个模块内的函数集合，假设模块名为 Foo，如果这个模块内的函数都共用同一全局变量，仅存在一个实例，则需要为所有公共函数的名称加上 `LCUIFoo_` 前缀，格式大致如下：

``` c
void LCUIFoo_Init();
void LCUIFoo_Free();
void LCUIFoo_GetObject();
void LCUIFoo_SetObject();
...
```

如果该模块内的函数都是针对单个对象，且对象可存在多个实例，则命名格式如下：

``` c
LCUI_Foo Foo( int bar );
void Foo_Delete( LCUI_Foo foo );
int Foo_GetName( LCUI_Foo foo );
```

构造函数与对象类型名称相同，返回该对象的句柄引用。对象的析构函数名称则是类型名称附加 `_Delete` 后缀。其它与该对象相关的操作函数名则都以 `Foo_` 开头。

## 注释

**函数注释：** 如果是在头文件中有声明的公用函数，那么函数注释只需要在头文件的函数声明中写上，而源文件中可以不用重复写注释，这样可以省去同时维护两个注释的麻烦。

**代码中的注释：** 注释不应该太多，注释内容简单明了即可，没必要每行代码都加注释，毕竟不是给初学者看的。

**数据定义时的注释：** 在定义结构体时，应该在每行的成员声明后面加上注释。
