﻿/*
 * font_inconsolata.c-- bitmap data of the inconsolata font.
 *
 * Copyright (c) 2018, Liu chao <lc-soft@live.cn> All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *   * Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 *   * Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *   * Neither the name of LCUI nor the names of its contributors may be used
 *     to endorse or promote products derived from this software without
 *     specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>
#include <string.h>
#include <LCUI_Build.h>
#include <LCUI/LCUI.h>
#include <LCUI/font.h>

enum font_index {
	SIZE_12_PX,
	SIZE_13_PX,
	SIZE_14_PX,
	SIZE_15_PX,
	SIZE_16_PX,
	SIZE_17_PX,
	SIZE_18_PX,
	SIZE_TOTAL
};

/* inconsolata 字体数据索引 */
static const LCUI_FontBitmap font_info_index[SIZE_TOTAL][95] = {
	{
		{ 16, 0, 0, 0, 0, (uchar_t*)0x00000000, 8, 0, { 6, 12 } },
		{ 11, 1, 3, 9, 9, (uchar_t*)0x00000000, 8, 0, { 6, 12 } },
		{ 11, 1, 4, 3, 3, (uchar_t*)0x0000001B, 8, 0, { 6, 12 } },
		{ 11, 0, 6, 8, 8, (uchar_t*)0x00000027, 8, 0, { 6, 12 } },
		{ 11, 0, 6, 9, 9, (uchar_t*)0x00000057, 8, 0, { 6, 12 } },
		{ 11, 0, 6, 9, 9, (uchar_t*)0x0000008D, 8, 0, { 6, 12 } },
		{ 11, 0, 6, 9, 9, (uchar_t*)0x000000C3, 8, 0, { 6, 12 } },
		{ 11, 2, 2, 3, 3, (uchar_t*)0x000000F9, 8, 0, { 6, 12 } },
		{ 11, 2, 3, 10, 10, (uchar_t*)0x000000FF, 8, 0, { 6, 12 } },
		{ 11, 0, 3, 10, 10, (uchar_t*)0x0000011D, 8, 0, { 6, 12 } },
		{ 10, 0, 6, 6, 6, (uchar_t*)0x0000013B, 8, 0, { 6, 12 } },
		{ 10, 0, 6, 6, 6, (uchar_t*)0x0000015F, 8, 0, { 6, 12 } },
		{ 5, 1, 3, 4, 4, (uchar_t*)0x00000183, 8, 0, { 6, 12 } },
		{ 8, 0, 6, 2, 2, (uchar_t*)0x0000018F, 8, 0, { 6, 12 } },
		{ 5, 1, 3, 3, 3, (uchar_t*)0x0000019B, 8, 0, { 6, 12 } },
		{ 11, 3, 3, 9, 9, (uchar_t*)0x000001A4, 8, 0, { 6, 12 } },
		{ 11, 0, 6, 9, 9, (uchar_t*)0x000001BF, 8, 0, { 6, 12 } },
		{ 11, 0, 4, 8, 8, (uchar_t*)0x000001F5, 8, 0, { 6, 12 } },
		{ 11, 0, 6, 8, 8, (uchar_t*)0x00000215, 8, 0, { 6, 12 } },
		{ 11, 0, 6, 9, 9, (uchar_t*)0x00000245, 8, 0, { 6, 12 } },
		{ 11, 0, 6, 8, 8, (uchar_t*)0x0000027B, 8, 0, { 6, 12 } },
		{ 11, 0, 6, 9, 9, (uchar_t*)0x000002AB, 8, 0, { 6, 12 } },
		{ 11, 0, 6, 9, 9, (uchar_t*)0x000002E1, 8, 0, { 6, 12 } },
		{ 11, 0, 6, 8, 8, (uchar_t*)0x00000317, 8, 0, { 6, 12 } },
		{ 11, 0, 6, 9, 9, (uchar_t*)0x00000347, 8, 0, { 6, 12 } },
		{ 11, 0, 6, 9, 9, (uchar_t*)0x0000037D, 8, 0, { 6, 12 } },
		{ 8, 1, 3, 6, 6, (uchar_t*)0x000003B3, 8, 0, { 6, 12 } },
		{ 8, 1, 3, 7, 7, (uchar_t*)0x000003C5, 8, 0, { 6, 12 } },
		{ 10, 2, 4, 7, 7, (uchar_t*)0x000003DA, 8, 0, { 6, 12 } },
		{ 9, 0, 6, 4, 4, (uchar_t*)0x000003F6, 8, 0, { 6, 12 } },
		{ 10, 0, 4, 7, 7, (uchar_t*)0x0000040E, 8, 0, { 6, 12 } },
		{ 11, 0, 6, 9, 9, (uchar_t*)0x0000042A, 8, 0, { 6, 12 } },
		{ 11, 0, 6, 9, 9, (uchar_t*)0x00000460, 8, 0, { 6, 12 } },
		{ 11, 0, 6, 8, 8, (uchar_t*)0x00000496, 8, 0, { 6, 12 } },
		{ 11, 0, 6, 8, 8, (uchar_t*)0x000004C6, 8, 0, { 6, 12 } },
		{ 11, 0, 6, 9, 9, (uchar_t*)0x000004F6, 8, 0, { 6, 12 } },
		{ 11, 0, 6, 8, 8, (uchar_t*)0x0000052C, 8, 0, { 6, 12 } },
		{ 11, 0, 6, 8, 8, (uchar_t*)0x0000055C, 8, 0, { 6, 12 } },
		{ 11, 0, 6, 8, 8, (uchar_t*)0x0000058C, 8, 0, { 6, 12 } },
		{ 11, 0, 6, 9, 9, (uchar_t*)0x000005BC, 8, 0, { 6, 12 } },
		{ 11, 0, 6, 8, 8, (uchar_t*)0x000005F2, 8, 0, { 6, 12 } },
		{ 11, 0, 5, 8, 8, (uchar_t*)0x00000622, 8, 0, { 6, 12 } },
		{ 11, 1, 5, 9, 9, (uchar_t*)0x0000064A, 8, 0, { 6, 12 } },
		{ 11, 0, 6, 8, 8, (uchar_t*)0x00000677, 8, 0, { 6, 12 } },
		{ 11, 0, 6, 8, 8, (uchar_t*)0x000006A7, 8, 0, { 6, 12 } },
		{ 11, 0, 6, 8, 8, (uchar_t*)0x000006D7, 8, 0, { 6, 12 } },
		{ 11, 0, 6, 8, 8, (uchar_t*)0x00000707, 8, 0, { 6, 12 } },
		{ 11, 0, 6, 9, 9, (uchar_t*)0x00000737, 8, 0, { 6, 12 } },
		{ 11, 0, 6, 8, 8, (uchar_t*)0x0000076D, 8, 0, { 6, 12 } },
		{ 11, 0, 6, 10, 10, (uchar_t*)0x0000079D, 8, 0, { 6, 12 } },
		{ 11, 0, 6, 8, 8, (uchar_t*)0x000007D9, 8, 0, { 6, 12 } },
		{ 11, 0, 6, 9, 9, (uchar_t*)0x00000809, 8, 0, { 6, 12 } },
		{ 11, 0, 6, 8, 8, (uchar_t*)0x0000083F, 8, 0, { 6, 12 } },
		{ 11, 0, 6, 9, 9, (uchar_t*)0x0000086F, 8, 0, { 6, 12 } },
		{ 11, 0, 6, 8, 8, (uchar_t*)0x000008A5, 8, 0, { 6, 12 } },
		{ 11, 0, 6, 8, 8, (uchar_t*)0x000008D5, 8, 0, { 6, 12 } },
		{ 11, 0, 6, 8, 8, (uchar_t*)0x00000905, 8, 0, { 6, 12 } },
		{ 11, 0, 6, 8, 8, (uchar_t*)0x00000935, 8, 0, { 6, 12 } },
		{ 11, 0, 6, 8, 8, (uchar_t*)0x00000965, 8, 0, { 6, 12 } },
		{ 11, 1, 5, 9, 9, (uchar_t*)0x00000995, 8, 0, { 6, 12 } },
		{ 11, 0, 3, 9, 9, (uchar_t*)0x000009C2, 8, 0, { 6, 12 } },
		{ 11, 0, 5, 9, 9, (uchar_t*)0x000009DD, 8, 0, { 6, 12 } },
		{ 11, 0, 5, 4, 4, (uchar_t*)0x00000A0A, 8, 0, { 6, 12 } },
		{ 16, 0, 6, 0, 0, (uchar_t*)0x00000A1E, 8, 0, { 6, 12 } },
		{ 11, 1, 3, 3, 3, (uchar_t*)0x00000A1E, 8, 0, { 6, 12 } },
		{ 9, 0, 6, 7, 7, (uchar_t*)0x00000A27, 8, 0, { 6, 12 } },
		{ 11, 0, 6, 9, 9, (uchar_t*)0x00000A51, 8, 0, { 6, 12 } },
		{ 9, 0, 6, 7, 7, (uchar_t*)0x00000A87, 8, 0, { 6, 12 } },
		{ 11, 0, 6, 9, 9, (uchar_t*)0x00000AB1, 8, 0, { 6, 12 } },
		{ 9, 0, 6, 7, 7, (uchar_t*)0x00000AE7, 8, 0, { 6, 12 } },
		{ 11, 1, 5, 8, 8, (uchar_t*)0x00000B11, 8, 0, { 6, 12 } },
		{ 9, 0, 6, 8, 8, (uchar_t*)0x00000B39, 8, 0, { 6, 12 } },
		{ 11, 0, 6, 8, 8, (uchar_t*)0x00000B69, 8, 0, { 6, 12 } },
		{ 11, 0, 5, 8, 8, (uchar_t*)0x00000B99, 8, 0, { 6, 12 } },
		{ 11, 0, 5, 10, 10, (uchar_t*)0x00000BC1, 8, 0, { 6, 12 } },
		{ 11, 0, 6, 8, 8, (uchar_t*)0x00000BF3, 8, 0, { 6, 12 } },
		{ 11, 0, 5, 8, 8, (uchar_t*)0x00000C23, 8, 0, { 6, 12 } },
		{ 9, 0, 6, 6, 6, (uchar_t*)0x00000C4B, 8, 0, { 6, 12 } },
		{ 9, 0, 6, 6, 6, (uchar_t*)0x00000C6F, 8, 0, { 6, 12 } },
		{ 9, 0, 6, 7, 7, (uchar_t*)0x00000C93, 8, 0, { 6, 12 } },
		{ 9, 0, 6, 8, 8, (uchar_t*)0x00000CBD, 8, 0, { 6, 12 } },
		{ 9, 0, 6, 8, 8, (uchar_t*)0x00000CED, 8, 0, { 6, 12 } },
		{ 9, 0, 6, 6, 6, (uchar_t*)0x00000D1D, 8, 0, { 6, 12 } },
		{ 9, 0, 6, 7, 7, (uchar_t*)0x00000D41, 8, 0, { 6, 12 } },
		{ 11, 0, 5, 9, 9, (uchar_t*)0x00000D6B, 8, 0, { 6, 12 } },
		{ 9, 0, 6, 7, 7, (uchar_t*)0x00000D98, 8, 0, { 6, 12 } },
		{ 9, 0, 6, 6, 6, (uchar_t*)0x00000DC2, 8, 0, { 6, 12 } },
		{ 9, 0, 6, 6, 6, (uchar_t*)0x00000DE6, 8, 0, { 6, 12 } },
		{ 9, 0, 6, 6, 6, (uchar_t*)0x00000E0A, 8, 0, { 6, 12 } },
		{ 9, 0, 6, 8, 8, (uchar_t*)0x00000E2E, 8, 0, { 6, 12 } },
		{ 9, 0, 6, 6, 6, (uchar_t*)0x00000E5E, 8, 0, { 6, 12 } },
		{ 11, 1, 4, 10, 10, (uchar_t*)0x00000E82, 8, 0, { 6, 12 } },
		{ 11, 2, 2, 10, 10, (uchar_t*)0x00000EAA, 8, 0, { 6, 12 } },
		{ 11, 0, 4, 10, 10, (uchar_t*)0x00000EBE, 8, 0, { 6, 12 } },
		{ 9, 0, 6, 3, 3, (uchar_t*)0x00000EE6, 8, 0, { 6, 12 } }
	}, {
		{ 16, 0, 0, 0, 0, (uchar_t*)0x00000000, 8, 0, { 7, 13 } },
		{ 11, 2, 2, 10, 10, (uchar_t*)0x00000000, 8, 0, { 7, 13 } },
		{ 11, 1, 5, 4, 4, (uchar_t*)0x00000014, 8, 0, { 7, 13 } },
		{ 11, 0, 7, 9, 9, (uchar_t*)0x00000028, 8, 0, { 7, 13 } },
		{ 11, 0, 6, 10, 10, (uchar_t*)0x00000067, 8, 0, { 7, 13 } },
		{ 11, 0, 7, 10, 10, (uchar_t*)0x000000A3, 8, 0, { 7, 13 } },
		{ 11, 0, 7, 10, 10, (uchar_t*)0x000000E9, 8, 0, { 7, 13 } },
		{ 11, 2, 3, 4, 4, (uchar_t*)0x0000012F, 8, 0, { 7, 13 } },
		{ 11, 2, 4, 12, 12, (uchar_t*)0x0000013B, 8, 0, { 7, 13 } },
		{ 11, 0, 4, 12, 12, (uchar_t*)0x0000016B, 8, 0, { 7, 13 } },
		{ 9, 0, 6, 6, 6, (uchar_t*)0x0000019B, 8, 0, { 7, 13 } },
		{ 9, 0, 7, 6, 6, (uchar_t*)0x000001BF, 8, 0, { 7, 13 } },
		{ 4, 1, 3, 5, 5, (uchar_t*)0x000001E9, 8, 0, { 7, 13 } },
		{ 7, 0, 6, 2, 2, (uchar_t*)0x000001F8, 8, 0, { 7, 13 } },
		{ 4, 2, 2, 3, 3, (uchar_t*)0x00000204, 8, 0, { 7, 13 } },
		{ 11, 3, 3, 10, 10, (uchar_t*)0x0000020A, 8, 0, { 7, 13 } },
		{ 11, 0, 6, 10, 10, (uchar_t*)0x00000228, 8, 0, { 7, 13 } },
		{ 11, 0, 4, 9, 9, (uchar_t*)0x00000264, 8, 0, { 7, 13 } },
		{ 11, 0, 6, 9, 9, (uchar_t*)0x00000288, 8, 0, { 7, 13 } },
		{ 11, 0, 6, 10, 10, (uchar_t*)0x000002BE, 8, 0, { 7, 13 } },
		{ 11, 0, 6, 9, 9, (uchar_t*)0x000002FA, 8, 0, { 7, 13 } },
		{ 11, 0, 6, 10, 10, (uchar_t*)0x00000330, 8, 0, { 7, 13 } },
		{ 11, 0, 6, 10, 10, (uchar_t*)0x0000036C, 8, 0, { 7, 13 } },
		{ 11, 0, 6, 9, 9, (uchar_t*)0x000003A8, 8, 0, { 7, 13 } },
		{ 11, 0, 6, 10, 10, (uchar_t*)0x000003DE, 8, 0, { 7, 13 } },
		{ 11, 0, 6, 10, 10, (uchar_t*)0x0000041A, 8, 0, { 7, 13 } },
		{ 8, 2, 2, 7, 7, (uchar_t*)0x00000456, 8, 0, { 7, 13 } },
		{ 8, 1, 3, 9, 9, (uchar_t*)0x00000464, 8, 0, { 7, 13 } },
		{ 10, 1, 5, 8, 8, (uchar_t*)0x0000047F, 8, 0, { 7, 13 } },
		{ 8, 0, 7, 4, 4, (uchar_t*)0x000004A7, 8, 0, { 7, 13 } },
		{ 10, 2, 5, 8, 8, (uchar_t*)0x000004C3, 8, 0, { 7, 13 } },
		{ 11, 0, 6, 10, 10, (uchar_t*)0x000004EB, 8, 0, { 7, 13 } },
		{ 11, 0, 7, 10, 10, (uchar_t*)0x00000527, 8, 0, { 7, 13 } },
		{ 11, 0, 7, 9, 9, (uchar_t*)0x0000056D, 8, 0, { 7, 13 } },
		{ 11, 0, 6, 9, 9, (uchar_t*)0x000005AC, 8, 0, { 7, 13 } },
		{ 11, 0, 7, 10, 10, (uchar_t*)0x000005E2, 8, 0, { 7, 13 } },
		{ 11, 0, 7, 9, 9, (uchar_t*)0x00000628, 8, 0, { 7, 13 } },
		{ 11, 0, 6, 9, 9, (uchar_t*)0x00000667, 8, 0, { 7, 13 } },
		{ 11, 0, 6, 9, 9, (uchar_t*)0x0000069D, 8, 0, { 7, 13 } },
		{ 11, 0, 7, 10, 10, (uchar_t*)0x000006D3, 8, 0, { 7, 13 } },
		{ 11, 0, 6, 9, 9, (uchar_t*)0x00000719, 8, 0, { 7, 13 } },
		{ 11, 0, 6, 9, 9, (uchar_t*)0x0000074F, 8, 0, { 7, 13 } },
		{ 11, 1, 6, 10, 10, (uchar_t*)0x00000785, 8, 0, { 7, 13 } },
		{ 11, 0, 7, 9, 9, (uchar_t*)0x000007C1, 8, 0, { 7, 13 } },
		{ 11, 0, 6, 9, 9, (uchar_t*)0x00000800, 8, 0, { 7, 13 } },
		{ 11, 0, 7, 9, 9, (uchar_t*)0x00000836, 8, 0, { 7, 13 } },
		{ 11, 0, 6, 9, 9, (uchar_t*)0x00000875, 8, 0, { 7, 13 } },
		{ 11, 0, 7, 10, 10, (uchar_t*)0x000008AB, 8, 0, { 7, 13 } },
		{ 11, 0, 7, 9, 9, (uchar_t*)0x000008F1, 8, 0, { 7, 13 } },
		{ 11, 0, 7, 11, 11, (uchar_t*)0x00000930, 8, 0, { 7, 13 } },
		{ 11, 0, 6, 9, 9, (uchar_t*)0x0000097D, 8, 0, { 7, 13 } },
		{ 11, 0, 6, 10, 10, (uchar_t*)0x000009B3, 8, 0, { 7, 13 } },
		{ 11, 0, 7, 9, 9, (uchar_t*)0x000009EF, 8, 0, { 7, 13 } },
		{ 11, 0, 6, 10, 10, (uchar_t*)0x00000A2E, 8, 0, { 7, 13 } },
		{ 11, 0, 7, 9, 9, (uchar_t*)0x00000A6A, 8, 0, { 7, 13 } },
		{ 11, 0, 7, 9, 9, (uchar_t*)0x00000AA9, 8, 0, { 7, 13 } },
		{ 11, 0, 6, 9, 9, (uchar_t*)0x00000AE8, 8, 0, { 7, 13 } },
		{ 11, 0, 7, 9, 9, (uchar_t*)0x00000B1E, 8, 0, { 7, 13 } },
		{ 11, 0, 6, 9, 9, (uchar_t*)0x00000B5D, 8, 0, { 7, 13 } },
		{ 11, 1, 5, 11, 11, (uchar_t*)0x00000B93, 8, 0, { 7, 13 } },
		{ 11, 0, 3, 10, 10, (uchar_t*)0x00000BCA, 8, 0, { 7, 13 } },
		{ 11, 0, 5, 11, 11, (uchar_t*)0x00000BE8, 8, 0, { 7, 13 } },
		{ 11, 0, 6, 5, 5, (uchar_t*)0x00000C1F, 8, 0, { 7, 13 } },
		{ 16, 0, 6, 0, 0, (uchar_t*)0x00000C3D, 8, 0, { 7, 13 } },
		{ 11, 1, 3, 4, 4, (uchar_t*)0x00000C3D, 8, 0, { 7, 13 } },
		{ 8, 0, 6, 7, 7, (uchar_t*)0x00000C49, 8, 0, { 7, 13 } },
		{ 11, 0, 7, 10, 10, (uchar_t*)0x00000C73, 8, 0, { 7, 13 } },
		{ 8, 0, 7, 7, 7, (uchar_t*)0x00000CB9, 8, 0, { 7, 13 } },
		{ 11, 0, 6, 10, 10, (uchar_t*)0x00000CEA, 8, 0, { 7, 13 } },
		{ 8, 0, 6, 7, 7, (uchar_t*)0x00000D26, 8, 0, { 7, 13 } },
		{ 11, 1, 6, 9, 9, (uchar_t*)0x00000D50, 8, 0, { 7, 13 } },
		{ 9, 0, 7, 10, 10, (uchar_t*)0x00000D86, 8, 0, { 7, 13 } },
		{ 11, 0, 6, 9, 9, (uchar_t*)0x00000DCC, 8, 0, { 7, 13 } },
		{ 11, 1, 5, 9, 9, (uchar_t*)0x00000E02, 8, 0, { 7, 13 } },
		{ 11, 0, 5, 12, 12, (uchar_t*)0x00000E2F, 8, 0, { 7, 13 } },
		{ 11, 0, 7, 9, 9, (uchar_t*)0x00000E6B, 8, 0, { 7, 13 } },
		{ 11, 0, 6, 9, 9, (uchar_t*)0x00000EAA, 8, 0, { 7, 13 } },
		{ 8, 0, 7, 6, 6, (uchar_t*)0x00000EE0, 8, 0, { 7, 13 } },
		{ 8, 0, 6, 6, 6, (uchar_t*)0x00000F0A, 8, 0, { 7, 13 } },
		{ 8, 0, 7, 7, 7, (uchar_t*)0x00000F2E, 8, 0, { 7, 13 } },
		{ 8, 0, 7, 9, 9, (uchar_t*)0x00000F5F, 8, 0, { 7, 13 } },
		{ 8, 0, 6, 9, 9, (uchar_t*)0x00000F9E, 8, 0, { 7, 13 } },
		{ 8, 1, 5, 6, 6, (uchar_t*)0x00000FD4, 8, 0, { 7, 13 } },
		{ 8, 0, 6, 7, 7, (uchar_t*)0x00000FF2, 8, 0, { 7, 13 } },
		{ 10, 0, 6, 9, 9, (uchar_t*)0x0000101C, 8, 0, { 7, 13 } },
		{ 8, 0, 6, 7, 7, (uchar_t*)0x00001052, 8, 0, { 7, 13 } },
		{ 8, 0, 7, 6, 6, (uchar_t*)0x0000107C, 8, 0, { 7, 13 } },
		{ 8, 0, 7, 6, 6, (uchar_t*)0x000010A6, 8, 0, { 7, 13 } },
		{ 8, 0, 6, 6, 6, (uchar_t*)0x000010D0, 8, 0, { 7, 13 } },
		{ 8, 0, 7, 9, 9, (uchar_t*)0x000010F4, 8, 0, { 7, 13 } },
		{ 8, 0, 6, 6, 6, (uchar_t*)0x00001133, 8, 0, { 7, 13 } },
		{ 11, 2, 4, 11, 11, (uchar_t*)0x00001157, 8, 0, { 7, 13 } },
		{ 11, 2, 2, 11, 11, (uchar_t*)0x00001183, 8, 0, { 7, 13 } },
		{ 11, 0, 5, 11, 11, (uchar_t*)0x00001199, 8, 0, { 7, 13 } },
		{ 8, 0, 7, 2, 2, (uchar_t*)0x000011D0, 8, 0, { 7, 13 } }
	}, {
		{ 16, 0, 0, 0, 0, (uchar_t*)0x00000000, 8, 0, { 7, 14 } },
		{ 12, 2, 3, 11, 11, (uchar_t*)0x00000000, 8, 0, { 7, 14 } },
		{ 12, 1, 5, 5, 5, (uchar_t*)0x00000021, 8, 0, { 7, 14 } },
		{ 11, 0, 7, 9, 9, (uchar_t*)0x0000003A, 8, 0, { 7, 14 } },
		{ 12, 0, 7, 11, 11, (uchar_t*)0x00000079, 8, 0, { 7, 14 } },
		{ 11, 0, 7, 10, 10, (uchar_t*)0x000000C6, 8, 0, { 7, 14 } },
		{ 11, 0, 7, 10, 10, (uchar_t*)0x0000010C, 8, 0, { 7, 14 } },
		{ 12, 2, 3, 5, 5, (uchar_t*)0x00000152, 8, 0, { 7, 14 } },
		{ 12, 3, 3, 13, 13, (uchar_t*)0x00000161, 8, 0, { 7, 14 } },
		{ 12, 0, 4, 13, 13, (uchar_t*)0x00000188, 8, 0, { 7, 14 } },
		{ 10, 0, 7, 7, 7, (uchar_t*)0x000001BC, 8, 0, { 7, 14 } },
		{ 10, 0, 7, 7, 7, (uchar_t*)0x000001ED, 8, 0, { 7, 14 } },
		{ 4, 2, 3, 5, 5, (uchar_t*)0x0000021E, 8, 0, { 7, 14 } },
		{ 16, 0, 6, 0, 0, (uchar_t*)0x0000022D, 8, 0, { 7, 14 } },
		{ 4, 2, 3, 3, 3, (uchar_t*)0x0000022D, 8, 0, { 7, 14 } },
		{ 12, 4, 3, 11, 11, (uchar_t*)0x00000236, 8, 0, { 7, 14 } },
		{ 11, 0, 7, 10, 10, (uchar_t*)0x00000257, 8, 0, { 7, 14 } },
		{ 11, 0, 5, 9, 9, (uchar_t*)0x0000029D, 8, 0, { 7, 14 } },
		{ 11, 0, 7, 9, 9, (uchar_t*)0x000002CA, 8, 0, { 7, 14 } },
		{ 11, 0, 6, 10, 10, (uchar_t*)0x00000309, 8, 0, { 7, 14 } },
		{ 11, 0, 7, 9, 9, (uchar_t*)0x00000345, 8, 0, { 7, 14 } },
		{ 11, 0, 7, 10, 10, (uchar_t*)0x00000384, 8, 0, { 7, 14 } },
		{ 11, 0, 7, 10, 10, (uchar_t*)0x000003CA, 8, 0, { 7, 14 } },
		{ 11, 0, 7, 9, 9, (uchar_t*)0x00000410, 8, 0, { 7, 14 } },
		{ 11, 0, 7, 10, 10, (uchar_t*)0x0000044F, 8, 0, { 7, 14 } },
		{ 11, 0, 7, 10, 10, (uchar_t*)0x00000495, 8, 0, { 7, 14 } },
		{ 8, 2, 3, 7, 7, (uchar_t*)0x000004DB, 8, 0, { 7, 14 } },
		{ 8, 2, 3, 9, 9, (uchar_t*)0x000004F0, 8, 0, { 7, 14 } },
		{ 10, 2, 5, 8, 8, (uchar_t*)0x0000050B, 8, 0, { 7, 14 } },
		{ 9, 0, 7, 5, 5, (uchar_t*)0x00000533, 8, 0, { 7, 14 } },
		{ 10, 0, 5, 8, 8, (uchar_t*)0x00000556, 8, 0, { 7, 14 } },
		{ 12, 0, 6, 11, 11, (uchar_t*)0x0000057E, 8, 0, { 7, 14 } },
		{ 11, 0, 7, 10, 10, (uchar_t*)0x000005C0, 8, 0, { 7, 14 } },
		{ 11, 0, 7, 9, 9, (uchar_t*)0x00000606, 8, 0, { 7, 14 } },
		{ 11, 0, 7, 9, 9, (uchar_t*)0x00000645, 8, 0, { 7, 14 } },
		{ 11, 0, 7, 10, 10, (uchar_t*)0x00000684, 8, 0, { 7, 14 } },
		{ 11, 0, 7, 9, 9, (uchar_t*)0x000006CA, 8, 0, { 7, 14 } },
		{ 11, 0, 7, 9, 9, (uchar_t*)0x00000709, 8, 0, { 7, 14 } },
		{ 11, 0, 7, 9, 9, (uchar_t*)0x00000748, 8, 0, { 7, 14 } },
		{ 11, 0, 7, 10, 10, (uchar_t*)0x00000787, 8, 0, { 7, 14 } },
		{ 11, 0, 7, 9, 9, (uchar_t*)0x000007CD, 8, 0, { 7, 14 } },
		{ 11, 0, 6, 9, 9, (uchar_t*)0x0000080C, 8, 0, { 7, 14 } },
		{ 11, 0, 6, 10, 10, (uchar_t*)0x00000842, 8, 0, { 7, 14 } },
		{ 11, 0, 7, 10, 10, (uchar_t*)0x0000087E, 8, 0, { 7, 14 } },
		{ 11, 0, 7, 9, 9, (uchar_t*)0x000008C4, 8, 0, { 7, 14 } },
		{ 11, 0, 7, 9, 9, (uchar_t*)0x00000903, 8, 0, { 7, 14 } },
		{ 11, 0, 7, 9, 9, (uchar_t*)0x00000942, 8, 0, { 7, 14 } },
		{ 11, 0, 7, 10, 10, (uchar_t*)0x00000981, 8, 0, { 7, 14 } },
		{ 11, 0, 7, 9, 9, (uchar_t*)0x000009C7, 8, 0, { 7, 14 } },
		{ 11, 0, 7, 11, 11, (uchar_t*)0x00000A06, 8, 0, { 7, 14 } },
		{ 11, 0, 7, 9, 9, (uchar_t*)0x00000A53, 8, 0, { 7, 14 } },
		{ 11, 0, 7, 10, 10, (uchar_t*)0x00000A92, 8, 0, { 7, 14 } },
		{ 11, 0, 7, 9, 9, (uchar_t*)0x00000AD8, 8, 0, { 7, 14 } },
		{ 11, 0, 7, 10, 10, (uchar_t*)0x00000B17, 8, 0, { 7, 14 } },
		{ 11, 0, 7, 9, 9, (uchar_t*)0x00000B5D, 8, 0, { 7, 14 } },
		{ 11, 0, 7, 9, 9, (uchar_t*)0x00000B9C, 8, 0, { 7, 14 } },
		{ 11, 0, 7, 9, 9, (uchar_t*)0x00000BDB, 8, 0, { 7, 14 } },
		{ 11, 0, 7, 9, 9, (uchar_t*)0x00000C1A, 8, 0, { 7, 14 } },
		{ 11, 0, 7, 9, 9, (uchar_t*)0x00000C59, 8, 0, { 7, 14 } },
		{ 12, 1, 5, 12, 12, (uchar_t*)0x00000C98, 8, 0, { 7, 14 } },
		{ 12, 0, 3, 11, 11, (uchar_t*)0x00000CD4, 8, 0, { 7, 14 } },
		{ 12, 0, 6, 12, 12, (uchar_t*)0x00000CF5, 8, 0, { 7, 14 } },
		{ 11, 1, 5, 5, 5, (uchar_t*)0x00000D3D, 8, 0, { 7, 14 } },
		{ 2, 0, 7, 2, 2, (uchar_t*)0x00000D56, 8, 0, { 7, 14 } },
		{ 12, 1, 3, 4, 4, (uchar_t*)0x00000D64, 8, 0, { 7, 14 } },
		{ 9, 0, 7, 8, 8, (uchar_t*)0x00000D70, 8, 0, { 7, 14 } },
		{ 12, 0, 7, 11, 11, (uchar_t*)0x00000DA8, 8, 0, { 7, 14 } },
		{ 9, 0, 7, 8, 8, (uchar_t*)0x00000DF5, 8, 0, { 7, 14 } },
		{ 12, 0, 7, 11, 11, (uchar_t*)0x00000E2D, 8, 0, { 7, 14 } },
		{ 9, 0, 7, 8, 8, (uchar_t*)0x00000E7A, 8, 0, { 7, 14 } },
		{ 12, 0, 6, 10, 10, (uchar_t*)0x00000EB2, 8, 0, { 7, 14 } },
		{ 9, 0, 7, 10, 10, (uchar_t*)0x00000EEE, 8, 0, { 7, 14 } },
		{ 12, 0, 7, 10, 10, (uchar_t*)0x00000F34, 8, 0, { 7, 14 } },
		{ 12, 1, 5, 10, 10, (uchar_t*)0x00000F7A, 8, 0, { 7, 14 } },
		{ 12, 0, 6, 13, 13, (uchar_t*)0x00000FAC, 8, 0, { 7, 14 } },
		{ 12, 0, 7, 10, 10, (uchar_t*)0x00000FFA, 8, 0, { 7, 14 } },
		{ 12, 0, 6, 10, 10, (uchar_t*)0x00001040, 8, 0, { 7, 14 } },
		{ 9, 0, 7, 7, 7, (uchar_t*)0x0000107C, 8, 0, { 7, 14 } },
		{ 9, 0, 7, 7, 7, (uchar_t*)0x000010AD, 8, 0, { 7, 14 } },
		{ 9, 0, 7, 8, 8, (uchar_t*)0x000010DE, 8, 0, { 7, 14 } },
		{ 9, 0, 7, 10, 10, (uchar_t*)0x00001116, 8, 0, { 7, 14 } },
		{ 9, 0, 7, 10, 10, (uchar_t*)0x0000115C, 8, 0, { 7, 14 } },
		{ 9, 1, 6, 7, 7, (uchar_t*)0x000011A2, 8, 0, { 7, 14 } },
		{ 9, 0, 7, 8, 8, (uchar_t*)0x000011CC, 8, 0, { 7, 14 } },
		{ 11, 0, 6, 10, 10, (uchar_t*)0x00001204, 8, 0, { 7, 14 } },
		{ 9, 0, 7, 8, 8, (uchar_t*)0x00001240, 8, 0, { 7, 14 } },
		{ 9, 0, 7, 7, 7, (uchar_t*)0x00001278, 8, 0, { 7, 14 } },
		{ 9, 0, 7, 7, 7, (uchar_t*)0x000012A9, 8, 0, { 7, 14 } },
		{ 9, 0, 7, 7, 7, (uchar_t*)0x000012DA, 8, 0, { 7, 14 } },
		{ 9, 0, 7, 10, 10, (uchar_t*)0x0000130B, 8, 0, { 7, 14 } },
		{ 9, 0, 7, 7, 7, (uchar_t*)0x00001351, 8, 0, { 7, 14 } },
		{ 11, 2, 4, 12, 12, (uchar_t*)0x00001382, 8, 0, { 7, 14 } },
		{ 12, 2, 3, 13, 13, (uchar_t*)0x000013B2, 8, 0, { 7, 14 } },
		{ 11, 1, 4, 12, 12, (uchar_t*)0x000013D9, 8, 0, { 7, 14 } },
		{ 9, 0, 7, 3, 3, (uchar_t*)0x00001409, 8, 0, { 7, 14 } }
	}, {
		{ 17, 0, 0, 0, 0, (uchar_t*)0x00000000, 8, 0, { 8, 15 } },
		{ 12, 2, 3, 11, 11, (uchar_t*)0x00000000, 8, 0, { 8, 15 } },
		{ 12, 1, 5, 4, 4, (uchar_t*)0x00000021, 8, 0, { 8, 15 } },
		{ 12, 0, 8, 10, 10, (uchar_t*)0x00000035, 8, 0, { 8, 15 } },
		{ 12, 0, 7, 11, 11, (uchar_t*)0x00000085, 8, 0, { 8, 15 } },
		{ 12, 0, 7, 11, 11, (uchar_t*)0x000000D2, 8, 0, { 8, 15 } },
		{ 12, 0, 8, 11, 11, (uchar_t*)0x0000011F, 8, 0, { 8, 15 } },
		{ 12, 2, 3, 4, 4, (uchar_t*)0x00000177, 8, 0, { 8, 15 } },
		{ 12, 2, 4, 13, 13, (uchar_t*)0x00000183, 8, 0, { 8, 15 } },
		{ 12, 1, 4, 13, 13, (uchar_t*)0x000001B7, 8, 0, { 8, 15 } },
		{ 10, 0, 7, 7, 7, (uchar_t*)0x000001EB, 8, 0, { 8, 15 } },
		{ 10, 0, 7, 7, 7, (uchar_t*)0x0000021C, 8, 0, { 8, 15 } },
		{ 4, 2, 3, 5, 5, (uchar_t*)0x0000024D, 8, 0, { 8, 15 } },
		{ 8, 0, 7, 2, 2, (uchar_t*)0x0000025C, 8, 0, { 8, 15 } },
		{ 4, 2, 3, 3, 3, (uchar_t*)0x0000026A, 8, 0, { 8, 15 } },
		{ 12, 4, 3, 11, 11, (uchar_t*)0x00000273, 8, 0, { 8, 15 } },
		{ 12, 0, 7, 11, 11, (uchar_t*)0x00000294, 8, 0, { 8, 15 } },
		{ 12, 1, 4, 10, 10, (uchar_t*)0x000002E1, 8, 0, { 8, 15 } },
		{ 12, 0, 7, 10, 10, (uchar_t*)0x00000309, 8, 0, { 8, 15 } },
		{ 12, 0, 7, 11, 11, (uchar_t*)0x0000034F, 8, 0, { 8, 15 } },
		{ 12, 0, 7, 10, 10, (uchar_t*)0x0000039C, 8, 0, { 8, 15 } },
		{ 12, 0, 7, 11, 11, (uchar_t*)0x000003E2, 8, 0, { 8, 15 } },
		{ 12, 0, 7, 11, 11, (uchar_t*)0x0000042F, 8, 0, { 8, 15 } },
		{ 12, 0, 7, 10, 10, (uchar_t*)0x0000047C, 8, 0, { 8, 15 } },
		{ 12, 0, 7, 11, 11, (uchar_t*)0x000004C2, 8, 0, { 8, 15 } },
		{ 12, 0, 7, 11, 11, (uchar_t*)0x0000050F, 8, 0, { 8, 15 } },
		{ 9, 2, 3, 8, 8, (uchar_t*)0x0000055C, 8, 0, { 8, 15 } },
		{ 9, 2, 3, 10, 10, (uchar_t*)0x00000574, 8, 0, { 8, 15 } },
		{ 11, 2, 5, 9, 9, (uchar_t*)0x00000592, 8, 0, { 8, 15 } },
		{ 9, 0, 7, 5, 5, (uchar_t*)0x000005BF, 8, 0, { 8, 15 } },
		{ 11, 1, 5, 9, 9, (uchar_t*)0x000005E2, 8, 0, { 8, 15 } },
		{ 12, 0, 7, 11, 11, (uchar_t*)0x0000060F, 8, 0, { 8, 15 } },
		{ 12, 0, 7, 11, 11, (uchar_t*)0x0000065C, 8, 0, { 8, 15 } },
		{ 12, 0, 8, 10, 10, (uchar_t*)0x000006A9, 8, 0, { 8, 15 } },
		{ 12, 0, 7, 10, 10, (uchar_t*)0x000006F9, 8, 0, { 8, 15 } },
		{ 12, 0, 7, 11, 11, (uchar_t*)0x0000073F, 8, 0, { 8, 15 } },
		{ 12, 0, 7, 10, 10, (uchar_t*)0x0000078C, 8, 0, { 8, 15 } },
		{ 12, 0, 7, 10, 10, (uchar_t*)0x000007D2, 8, 0, { 8, 15 } },
		{ 12, 0, 7, 10, 10, (uchar_t*)0x00000818, 8, 0, { 8, 15 } },
		{ 12, 0, 7, 11, 11, (uchar_t*)0x0000085E, 8, 0, { 8, 15 } },
		{ 12, 0, 7, 10, 10, (uchar_t*)0x000008AB, 8, 0, { 8, 15 } },
		{ 12, 0, 6, 10, 10, (uchar_t*)0x000008F1, 8, 0, { 8, 15 } },
		{ 12, 0, 6, 11, 11, (uchar_t*)0x0000092D, 8, 0, { 8, 15 } },
		{ 12, 0, 7, 10, 10, (uchar_t*)0x0000096F, 8, 0, { 8, 15 } },
		{ 12, 0, 7, 10, 10, (uchar_t*)0x000009B5, 8, 0, { 8, 15 } },
		{ 12, 0, 7, 10, 10, (uchar_t*)0x000009FB, 8, 0, { 8, 15 } },
		{ 12, 0, 7, 10, 10, (uchar_t*)0x00000A41, 8, 0, { 8, 15 } },
		{ 12, 0, 7, 11, 11, (uchar_t*)0x00000A87, 8, 0, { 8, 15 } },
		{ 12, 0, 7, 10, 10, (uchar_t*)0x00000AD4, 8, 0, { 8, 15 } },
		{ 12, 0, 7, 13, 13, (uchar_t*)0x00000B1A, 8, 0, { 8, 15 } },
		{ 12, 0, 7, 10, 10, (uchar_t*)0x00000B75, 8, 0, { 8, 15 } },
		{ 12, 0, 7, 11, 11, (uchar_t*)0x00000BBB, 8, 0, { 8, 15 } },
		{ 12, 0, 7, 10, 10, (uchar_t*)0x00000C08, 8, 0, { 8, 15 } },
		{ 12, 0, 7, 11, 11, (uchar_t*)0x00000C4E, 8, 0, { 8, 15 } },
		{ 12, 0, 8, 10, 10, (uchar_t*)0x00000C9B, 8, 0, { 8, 15 } },
		{ 12, 0, 8, 10, 10, (uchar_t*)0x00000CEB, 8, 0, { 8, 15 } },
		{ 12, 0, 7, 10, 10, (uchar_t*)0x00000D3B, 8, 0, { 8, 15 } },
		{ 12, 0, 8, 10, 10, (uchar_t*)0x00000D81, 8, 0, { 8, 15 } },
		{ 12, 0, 7, 10, 10, (uchar_t*)0x00000DD1, 8, 0, { 8, 15 } },
		{ 12, 1, 6, 12, 12, (uchar_t*)0x00000E17, 8, 0, { 8, 15 } },
		{ 12, 0, 3, 11, 11, (uchar_t*)0x00000E5F, 8, 0, { 8, 15 } },
		{ 12, 0, 6, 12, 12, (uchar_t*)0x00000E80, 8, 0, { 8, 15 } },
		{ 12, 1, 5, 5, 5, (uchar_t*)0x00000EC8, 8, 0, { 8, 15 } },
		{ 2, 0, 7, 2, 2, (uchar_t*)0x00000EE1, 8, 0, { 8, 15 } },
		{ 12, 1, 3, 4, 4, (uchar_t*)0x00000EEF, 8, 0, { 8, 15 } },
		{ 9, 0, 7, 8, 8, (uchar_t*)0x00000EFB, 8, 0, { 8, 15 } },
		{ 12, 0, 7, 11, 11, (uchar_t*)0x00000F33, 8, 0, { 8, 15 } },
		{ 9, 0, 7, 8, 8, (uchar_t*)0x00000F80, 8, 0, { 8, 15 } },
		{ 12, 0, 7, 11, 11, (uchar_t*)0x00000FB8, 8, 0, { 8, 15 } },
		{ 9, 0, 7, 8, 8, (uchar_t*)0x00001005, 8, 0, { 8, 15 } },
		{ 12, 2, 6, 10, 10, (uchar_t*)0x0000103D, 8, 0, { 8, 15 } },
		{ 9, 1, 7, 10, 10, (uchar_t*)0x00001079, 8, 0, { 8, 15 } },
		{ 12, 0, 7, 10, 10, (uchar_t*)0x000010BF, 8, 0, { 8, 15 } },
		{ 12, 1, 5, 10, 10, (uchar_t*)0x00001105, 8, 0, { 8, 15 } },
		{ 12, 0, 6, 13, 13, (uchar_t*)0x00001137, 8, 0, { 8, 15 } },
		{ 12, 0, 8, 10, 10, (uchar_t*)0x00001185, 8, 0, { 8, 15 } },
		{ 12, 0, 7, 10, 10, (uchar_t*)0x000011D5, 8, 0, { 8, 15 } },
		{ 9, 0, 7, 7, 7, (uchar_t*)0x0000121B, 8, 0, { 8, 15 } },
		{ 9, 0, 7, 7, 7, (uchar_t*)0x0000124C, 8, 0, { 8, 15 } },
		{ 9, 0, 7, 8, 8, (uchar_t*)0x0000127D, 8, 0, { 8, 15 } },
		{ 9, 0, 7, 10, 10, (uchar_t*)0x000012B5, 8, 0, { 8, 15 } },
		{ 9, 0, 7, 10, 10, (uchar_t*)0x000012FB, 8, 0, { 8, 15 } },
		{ 9, 1, 6, 7, 7, (uchar_t*)0x00001341, 8, 0, { 8, 15 } },
		{ 9, 0, 7, 8, 8, (uchar_t*)0x0000136B, 8, 0, { 8, 15 } },
		{ 11, 0, 6, 10, 10, (uchar_t*)0x000013A3, 8, 0, { 8, 15 } },
		{ 9, 0, 7, 8, 8, (uchar_t*)0x000013DF, 8, 0, { 8, 15 } },
		{ 9, 0, 7, 7, 7, (uchar_t*)0x00001417, 8, 0, { 8, 15 } },
		{ 9, 0, 8, 7, 7, (uchar_t*)0x00001448, 8, 0, { 8, 15 } },
		{ 9, 0, 7, 7, 7, (uchar_t*)0x00001480, 8, 0, { 8, 15 } },
		{ 9, 0, 7, 10, 10, (uchar_t*)0x000014B1, 8, 0, { 8, 15 } },
		{ 9, 0, 7, 7, 7, (uchar_t*)0x000014F7, 8, 0, { 8, 15 } },
		{ 12, 2, 5, 13, 13, (uchar_t*)0x00001528, 8, 0, { 8, 15 } },
		{ 12, 2, 3, 13, 13, (uchar_t*)0x00001569, 8, 0, { 8, 15 } },
		{ 12, 1, 4, 13, 13, (uchar_t*)0x00001590, 8, 0, { 8, 15 } },
		{ 9, 0, 8, 3, 3, (uchar_t*)0x000015C4, 8, 0, { 8, 15 } }
	}, {
		{ 19, 0, 0, 0, 0, (uchar_t*)0x00000000, 8, 0, { 8, 16 } },
		{ 13, 2, 3, 12, 12, (uchar_t*)0x00000000, 8, 0, { 8, 16 } },
		{ 13, 1, 6, 5, 5, (uchar_t*)0x00000024, 8, 0, { 8, 16 } },
		{ 12, 0, 8, 10, 10, (uchar_t*)0x00000042, 8, 0, { 8, 16 } },
		{ 13, 0, 8, 12, 12, (uchar_t*)0x00000092, 8, 0, { 8, 16 } },
		{ 13, 0, 8, 12, 12, (uchar_t*)0x000000F2, 8, 0, { 8, 16 } },
		{ 12, 0, 8, 11, 11, (uchar_t*)0x00000152, 8, 0, { 8, 16 } },
		{ 13, 3, 3, 5, 5, (uchar_t*)0x000001AA, 8, 0, { 8, 16 } },
		{ 13, 3, 4, 14, 14, (uchar_t*)0x000001B9, 8, 0, { 8, 16 } },
		{ 13, 0, 4, 14, 14, (uchar_t*)0x000001F1, 8, 0, { 8, 16 } },
		{ 11, 0, 8, 8, 8, (uchar_t*)0x00000229, 8, 0, { 8, 16 } },
		{ 11, 0, 8, 8, 8, (uchar_t*)0x00000269, 8, 0, { 8, 16 } },
		{ 4, 2, 3, 5, 5, (uchar_t*)0x000002A9, 8, 0, { 8, 16 } },
		{ 8, 0, 7, 2, 2, (uchar_t*)0x000002B8, 8, 0, { 8, 16 } },
		{ 4, 2, 3, 3, 3, (uchar_t*)0x000002C6, 8, 0, { 8, 16 } },
		{ 13, 4, 3, 12, 12, (uchar_t*)0x000002CF, 8, 0, { 8, 16 } },
		{ 12, 0, 8, 11, 11, (uchar_t*)0x000002F3, 8, 0, { 8, 16 } },
		{ 12, 1, 4, 10, 10, (uchar_t*)0x0000034B, 8, 0, { 8, 16 } },
		{ 12, 0, 7, 10, 10, (uchar_t*)0x00000373, 8, 0, { 8, 16 } },
		{ 12, 0, 7, 11, 11, (uchar_t*)0x000003B9, 8, 0, { 8, 16 } },
		{ 12, 0, 8, 10, 10, (uchar_t*)0x00000406, 8, 0, { 8, 16 } },
		{ 12, 0, 7, 11, 11, (uchar_t*)0x00000456, 8, 0, { 8, 16 } },
		{ 12, 0, 7, 11, 11, (uchar_t*)0x000004A3, 8, 0, { 8, 16 } },
		{ 12, 1, 6, 10, 10, (uchar_t*)0x000004F0, 8, 0, { 8, 16 } },
		{ 12, 0, 7, 11, 11, (uchar_t*)0x0000052C, 8, 0, { 8, 16 } },
		{ 12, 0, 7, 11, 11, (uchar_t*)0x00000579, 8, 0, { 8, 16 } },
		{ 9, 2, 3, 8, 8, (uchar_t*)0x000005C6, 8, 0, { 8, 16 } },
		{ 9, 2, 3, 10, 10, (uchar_t*)0x000005DE, 8, 0, { 8, 16 } },
		{ 11, 3, 5, 9, 9, (uchar_t*)0x000005FC, 8, 0, { 8, 16 } },
		{ 9, 0, 8, 5, 5, (uchar_t*)0x00000629, 8, 0, { 8, 16 } },
		{ 11, 0, 5, 9, 9, (uchar_t*)0x00000651, 8, 0, { 8, 16 } },
		{ 13, 0, 7, 12, 12, (uchar_t*)0x0000067E, 8, 0, { 8, 16 } },
		{ 13, 0, 8, 12, 12, (uchar_t*)0x000006D2, 8, 0, { 8, 16 } },
		{ 13, 0, 8, 11, 11, (uchar_t*)0x00000732, 8, 0, { 8, 16 } },
		{ 12, 0, 8, 10, 10, (uchar_t*)0x0000078A, 8, 0, { 8, 16 } },
		{ 12, 0, 8, 11, 11, (uchar_t*)0x000007DA, 8, 0, { 8, 16 } },
		{ 12, 0, 8, 10, 10, (uchar_t*)0x00000832, 8, 0, { 8, 16 } },
		{ 12, 0, 7, 10, 10, (uchar_t*)0x00000882, 8, 0, { 8, 16 } },
		{ 12, 0, 7, 10, 10, (uchar_t*)0x000008C8, 8, 0, { 8, 16 } },
		{ 12, 0, 8, 11, 11, (uchar_t*)0x0000090E, 8, 0, { 8, 16 } },
		{ 12, 0, 8, 10, 10, (uchar_t*)0x00000966, 8, 0, { 8, 16 } },
		{ 12, 1, 6, 10, 10, (uchar_t*)0x000009B6, 8, 0, { 8, 16 } },
		{ 12, 2, 6, 11, 11, (uchar_t*)0x000009F2, 8, 0, { 8, 16 } },
		{ 12, 0, 8, 10, 10, (uchar_t*)0x00000A34, 8, 0, { 8, 16 } },
		{ 12, 0, 7, 10, 10, (uchar_t*)0x00000A84, 8, 0, { 8, 16 } },
		{ 12, 0, 8, 10, 10, (uchar_t*)0x00000ACA, 8, 0, { 8, 16 } },
		{ 12, 0, 8, 10, 10, (uchar_t*)0x00000B1A, 8, 0, { 8, 16 } },
		{ 12, 0, 8, 11, 11, (uchar_t*)0x00000B6A, 8, 0, { 8, 16 } },
		{ 12, 0, 8, 10, 10, (uchar_t*)0x00000BC2, 8, 0, { 8, 16 } },
		{ 12, 0, 8, 13, 13, (uchar_t*)0x00000C12, 8, 0, { 8, 16 } },
		{ 12, 0, 8, 10, 10, (uchar_t*)0x00000C7A, 8, 0, { 8, 16 } },
		{ 12, 0, 8, 11, 11, (uchar_t*)0x00000CCA, 8, 0, { 8, 16 } },
		{ 12, 0, 8, 10, 10, (uchar_t*)0x00000D22, 8, 0, { 8, 16 } },
		{ 12, 0, 8, 11, 11, (uchar_t*)0x00000D72, 8, 0, { 8, 16 } },
		{ 12, 0, 8, 10, 10, (uchar_t*)0x00000DCA, 8, 0, { 8, 16 } },
		{ 12, 0, 8, 10, 10, (uchar_t*)0x00000E1A, 8, 0, { 8, 16 } },
		{ 12, 0, 8, 10, 10, (uchar_t*)0x00000E6A, 8, 0, { 8, 16 } },
		{ 12, 0, 8, 10, 10, (uchar_t*)0x00000EBA, 8, 0, { 8, 16 } },
		{ 12, 0, 8, 10, 10, (uchar_t*)0x00000F0A, 8, 0, { 8, 16 } },
		{ 13, 1, 6, 13, 13, (uchar_t*)0x00000F5A, 8, 0, { 8, 16 } },
		{ 13, 0, 3, 12, 12, (uchar_t*)0x00000FA8, 8, 0, { 8, 16 } },
		{ 13, 1, 5, 13, 13, (uchar_t*)0x00000FCC, 8, 0, { 8, 16 } },
		{ 12, 1, 6, 5, 5, (uchar_t*)0x0000100D, 8, 0, { 8, 16 } },
		{ 2, 0, 8, 2, 2, (uchar_t*)0x0000102B, 8, 0, { 8, 16 } },
		{ 13, 1, 3, 4, 4, (uchar_t*)0x0000103B, 8, 0, { 8, 16 } },
		{ 10, 0, 7, 9, 9, (uchar_t*)0x00001047, 8, 0, { 8, 16 } },
		{ 13, 0, 8, 12, 12, (uchar_t*)0x00001086, 8, 0, { 8, 16 } },
		{ 10, 0, 8, 9, 9, (uchar_t*)0x000010E6, 8, 0, { 8, 16 } },
		{ 13, 0, 7, 12, 12, (uchar_t*)0x0000112E, 8, 0, { 8, 16 } },
		{ 10, 0, 8, 9, 9, (uchar_t*)0x00001182, 8, 0, { 8, 16 } },
		{ 13, 0, 7, 11, 11, (uchar_t*)0x000011CA, 8, 0, { 8, 16 } },
		{ 10, 0, 8, 11, 11, (uchar_t*)0x00001217, 8, 0, { 8, 16 } },
		{ 13, 0, 7, 11, 11, (uchar_t*)0x0000126F, 8, 0, { 8, 16 } },
		{ 13, 1, 6, 11, 11, (uchar_t*)0x000012BC, 8, 0, { 8, 16 } },
		{ 13, 0, 6, 14, 14, (uchar_t*)0x000012FE, 8, 0, { 8, 16 } },
		{ 13, 0, 8, 11, 11, (uchar_t*)0x00001352, 8, 0, { 8, 16 } },
		{ 13, 1, 6, 11, 11, (uchar_t*)0x000013AA, 8, 0, { 8, 16 } },
		{ 10, 0, 8, 8, 8, (uchar_t*)0x000013EC, 8, 0, { 8, 16 } },
		{ 10, 0, 7, 8, 8, (uchar_t*)0x0000142C, 8, 0, { 8, 16 } },
		{ 10, 0, 8, 9, 9, (uchar_t*)0x00001464, 8, 0, { 8, 16 } },
		{ 10, 0, 8, 11, 11, (uchar_t*)0x000014AC, 8, 0, { 8, 16 } },
		{ 10, 0, 7, 11, 11, (uchar_t*)0x00001504, 8, 0, { 8, 16 } },
		{ 10, 1, 7, 8, 8, (uchar_t*)0x00001551, 8, 0, { 8, 16 } },
		{ 10, 0, 7, 9, 9, (uchar_t*)0x00001589, 8, 0, { 8, 16 } },
		{ 12, 0, 7, 11, 11, (uchar_t*)0x000015C8, 8, 0, { 8, 16 } },
		{ 10, 0, 7, 9, 9, (uchar_t*)0x00001615, 8, 0, { 8, 16 } },
		{ 10, 0, 8, 8, 8, (uchar_t*)0x00001654, 8, 0, { 8, 16 } },
		{ 10, 0, 8, 8, 8, (uchar_t*)0x00001694, 8, 0, { 8, 16 } },
		{ 10, 0, 8, 8, 8, (uchar_t*)0x000016D4, 8, 0, { 8, 16 } },
		{ 10, 0, 8, 11, 11, (uchar_t*)0x00001714, 8, 0, { 8, 16 } },
		{ 10, 0, 8, 8, 8, (uchar_t*)0x0000176C, 8, 0, { 8, 16 } },
		{ 13, 2, 5, 14, 14, (uchar_t*)0x000017AC, 8, 0, { 8, 16 } },
		{ 13, 3, 2, 14, 14, (uchar_t*)0x000017F2, 8, 0, { 8, 16 } },
		{ 13, 1, 5, 14, 14, (uchar_t*)0x0000180E, 8, 0, { 8, 16 } },
		{ 10, 0, 8, 3, 3, (uchar_t*)0x00001854, 8, 0, { 8, 16 } }
	}, {
		{ 20, 0, 0, 0, 0, (uchar_t*)0x00000000, 8, 0, { 9, 17 } },
		{ 14, 2, 3, 13, 13, (uchar_t*)0x00000000, 8, 0, { 9, 17 } },
		{ 14, 1, 6, 5, 5, (uchar_t*)0x00000027, 8, 0, { 9, 17 } },
		{ 13, 0, 9, 11, 11, (uchar_t*)0x00000045, 8, 0, { 9, 17 } },
		{ 14, 0, 8, 13, 13, (uchar_t*)0x000000A8, 8, 0, { 9, 17 } },
		{ 13, 0, 8, 12, 12, (uchar_t*)0x00000110, 8, 0, { 9, 17 } },
		{ 13, 0, 9, 12, 12, (uchar_t*)0x00000170, 8, 0, { 9, 17 } },
		{ 14, 3, 3, 5, 5, (uchar_t*)0x000001DC, 8, 0, { 9, 17 } },
		{ 14, 4, 4, 15, 15, (uchar_t*)0x000001EB, 8, 0, { 9, 17 } },
		{ 14, 1, 4, 15, 15, (uchar_t*)0x00000227, 8, 0, { 9, 17 } },
		{ 11, 0, 8, 8, 8, (uchar_t*)0x00000263, 8, 0, { 9, 17 } },
		{ 11, 0, 8, 8, 8, (uchar_t*)0x000002A3, 8, 0, { 9, 17 } },
		{ 4, 2, 4, 5, 5, (uchar_t*)0x000002E3, 8, 0, { 9, 17 } },
		{ 8, 0, 8, 2, 2, (uchar_t*)0x000002F7, 8, 0, { 9, 17 } },
		{ 4, 2, 3, 3, 3, (uchar_t*)0x00000307, 8, 0, { 9, 17 } },
		{ 14, 5, 3, 13, 13, (uchar_t*)0x00000310, 8, 0, { 9, 17 } },
		{ 13, 0, 8, 12, 12, (uchar_t*)0x00000337, 8, 0, { 9, 17 } },
		{ 13, 1, 5, 11, 11, (uchar_t*)0x00000397, 8, 0, { 9, 17 } },
		{ 13, 0, 8, 11, 11, (uchar_t*)0x000003CE, 8, 0, { 9, 17 } },
		{ 13, 0, 7, 12, 12, (uchar_t*)0x00000426, 8, 0, { 9, 17 } },
		{ 13, 0, 8, 11, 11, (uchar_t*)0x0000047A, 8, 0, { 9, 17 } },
		{ 13, 0, 8, 12, 12, (uchar_t*)0x000004D2, 8, 0, { 9, 17 } },
		{ 13, 0, 8, 12, 12, (uchar_t*)0x00000532, 8, 0, { 9, 17 } },
		{ 13, 1, 7, 11, 11, (uchar_t*)0x00000592, 8, 0, { 9, 17 } },
		{ 13, 0, 8, 12, 12, (uchar_t*)0x000005DF, 8, 0, { 9, 17 } },
		{ 13, 0, 8, 12, 12, (uchar_t*)0x0000063F, 8, 0, { 9, 17 } },
		{ 10, 2, 3, 9, 9, (uchar_t*)0x0000069F, 8, 0, { 9, 17 } },
		{ 10, 2, 4, 11, 11, (uchar_t*)0x000006BA, 8, 0, { 9, 17 } },
		{ 12, 2, 5, 10, 10, (uchar_t*)0x000006E6, 8, 0, { 9, 17 } },
		{ 10, 0, 8, 6, 6, (uchar_t*)0x00000718, 8, 0, { 9, 17 } },
		{ 12, 1, 5, 10, 10, (uchar_t*)0x00000748, 8, 0, { 9, 17 } },
		{ 14, 0, 8, 13, 13, (uchar_t*)0x0000077A, 8, 0, { 9, 17 } },
		{ 13, 0, 8, 12, 12, (uchar_t*)0x000007E2, 8, 0, { 9, 17 } },
		{ 13, 0, 9, 12, 12, (uchar_t*)0x00000842, 8, 0, { 9, 17 } },
		{ 13, 0, 8, 11, 11, (uchar_t*)0x000008AE, 8, 0, { 9, 17 } },
		{ 13, 0, 8, 12, 12, (uchar_t*)0x00000906, 8, 0, { 9, 17 } },
		{ 13, 0, 8, 11, 11, (uchar_t*)0x00000966, 8, 0, { 9, 17 } },
		{ 13, 0, 8, 11, 11, (uchar_t*)0x000009BE, 8, 0, { 9, 17 } },
		{ 13, 1, 7, 11, 11, (uchar_t*)0x00000A16, 8, 0, { 9, 17 } },
		{ 13, 0, 8, 12, 12, (uchar_t*)0x00000A63, 8, 0, { 9, 17 } },
		{ 13, 0, 8, 11, 11, (uchar_t*)0x00000AC3, 8, 0, { 9, 17 } },
		{ 13, 1, 6, 11, 11, (uchar_t*)0x00000B1B, 8, 0, { 9, 17 } },
		{ 13, 2, 6, 12, 12, (uchar_t*)0x00000B5D, 8, 0, { 9, 17 } },
		{ 13, 0, 8, 11, 11, (uchar_t*)0x00000BA5, 8, 0, { 9, 17 } },
		{ 13, 0, 8, 11, 11, (uchar_t*)0x00000BFD, 8, 0, { 9, 17 } },
		{ 13, 0, 8, 11, 11, (uchar_t*)0x00000C55, 8, 0, { 9, 17 } },
		{ 13, 0, 8, 11, 11, (uchar_t*)0x00000CAD, 8, 0, { 9, 17 } },
		{ 13, 0, 8, 12, 12, (uchar_t*)0x00000D05, 8, 0, { 9, 17 } },
		{ 13, 0, 8, 11, 11, (uchar_t*)0x00000D65, 8, 0, { 9, 17 } },
		{ 13, 0, 8, 14, 14, (uchar_t*)0x00000DBD, 8, 0, { 9, 17 } },
		{ 13, 0, 8, 11, 11, (uchar_t*)0x00000E2D, 8, 0, { 9, 17 } },
		{ 13, 0, 8, 12, 12, (uchar_t*)0x00000E85, 8, 0, { 9, 17 } },
		{ 13, 0, 8, 11, 11, (uchar_t*)0x00000EE5, 8, 0, { 9, 17 } },
		{ 13, 0, 8, 12, 12, (uchar_t*)0x00000F3D, 8, 0, { 9, 17 } },
		{ 13, 0, 9, 11, 11, (uchar_t*)0x00000F9D, 8, 0, { 9, 17 } },
		{ 13, 0, 9, 11, 11, (uchar_t*)0x00001000, 8, 0, { 9, 17 } },
		{ 13, 0, 8, 11, 11, (uchar_t*)0x00001063, 8, 0, { 9, 17 } },
		{ 13, 0, 8, 11, 11, (uchar_t*)0x000010BB, 8, 0, { 9, 17 } },
		{ 13, 0, 8, 11, 11, (uchar_t*)0x00001113, 8, 0, { 9, 17 } },
		{ 14, 1, 7, 14, 14, (uchar_t*)0x0000116B, 8, 0, { 9, 17 } },
		{ 14, 0, 3, 13, 13, (uchar_t*)0x000011CD, 8, 0, { 9, 17 } },
		{ 14, 1, 6, 14, 14, (uchar_t*)0x000011F4, 8, 0, { 9, 17 } },
		{ 13, 1, 6, 6, 6, (uchar_t*)0x00001248, 8, 0, { 9, 17 } },
		{ 2, 0, 8, 2, 2, (uchar_t*)0x0000126C, 8, 0, { 9, 17 } },
		{ 14, 2, 4, 5, 5, (uchar_t*)0x0000127C, 8, 0, { 9, 17 } },
		{ 10, 0, 8, 9, 9, (uchar_t*)0x00001290, 8, 0, { 9, 17 } },
		{ 14, 0, 8, 13, 13, (uchar_t*)0x000012D8, 8, 0, { 9, 17 } },
		{ 10, 0, 8, 9, 9, (uchar_t*)0x00001340, 8, 0, { 9, 17 } },
		{ 14, 0, 8, 13, 13, (uchar_t*)0x00001388, 8, 0, { 9, 17 } },
		{ 10, 0, 8, 9, 9, (uchar_t*)0x000013F0, 8, 0, { 9, 17 } },
		{ 14, 2, 7, 12, 12, (uchar_t*)0x00001438, 8, 0, { 9, 17 } },
		{ 10, 0, 8, 11, 11, (uchar_t*)0x0000148C, 8, 0, { 9, 17 } },
		{ 14, 0, 8, 12, 12, (uchar_t*)0x000014E4, 8, 0, { 9, 17 } },
		{ 14, 1, 6, 12, 12, (uchar_t*)0x00001544, 8, 0, { 9, 17 } },
		{ 14, 1, 6, 15, 15, (uchar_t*)0x0000158C, 8, 0, { 9, 17 } },
		{ 14, 0, 9, 12, 12, (uchar_t*)0x000015E6, 8, 0, { 9, 17 } },
		{ 14, 1, 7, 12, 12, (uchar_t*)0x00001652, 8, 0, { 9, 17 } },
		{ 10, 0, 8, 8, 8, (uchar_t*)0x000016A6, 8, 0, { 9, 17 } },
		{ 10, 0, 8, 8, 8, (uchar_t*)0x000016E6, 8, 0, { 9, 17 } },
		{ 10, 0, 8, 9, 9, (uchar_t*)0x00001726, 8, 0, { 9, 17 } },
		{ 10, 0, 8, 11, 11, (uchar_t*)0x0000176E, 8, 0, { 9, 17 } },
		{ 10, 0, 8, 11, 11, (uchar_t*)0x000017C6, 8, 0, { 9, 17 } },
		{ 10, 1, 7, 8, 8, (uchar_t*)0x0000181E, 8, 0, { 9, 17 } },
		{ 10, 0, 8, 9, 9, (uchar_t*)0x00001856, 8, 0, { 9, 17 } },
		{ 12, 0, 7, 11, 11, (uchar_t*)0x0000189E, 8, 0, { 9, 17 } },
		{ 10, 0, 8, 9, 9, (uchar_t*)0x000018EB, 8, 0, { 9, 17 } },
		{ 10, 0, 8, 8, 8, (uchar_t*)0x00001933, 8, 0, { 9, 17 } },
		{ 10, 0, 9, 8, 8, (uchar_t*)0x00001973, 8, 0, { 9, 17 } },
		{ 10, 0, 8, 8, 8, (uchar_t*)0x000019BB, 8, 0, { 9, 17 } },
		{ 10, 0, 8, 11, 11, (uchar_t*)0x000019FB, 8, 0, { 9, 17 } },
		{ 10, 0, 8, 8, 8, (uchar_t*)0x00001A53, 8, 0, { 9, 17 } },
		{ 13, 2, 5, 14, 14, (uchar_t*)0x00001A93, 8, 0, { 9, 17 } },
		{ 13, 3, 2, 14, 14, (uchar_t*)0x00001AD9, 8, 0, { 9, 17 } },
		{ 13, 1, 5, 14, 14, (uchar_t*)0x00001AF5, 8, 0, { 9, 17 } },
		{ 10, 1, 8, 3, 3, (uchar_t*)0x00001B3B, 8, 0, { 9, 17 } }
	}, {
		{ 20, 0, 0, 0, 0, (uchar_t*)0x00000000, 8, 0, { 9, 18 } },
		{ 14, 2, 4, 13, 13, (uchar_t*)0x00000000, 8, 0, { 9, 18 } },
		{ 14, 2, 6, 5, 5, (uchar_t*)0x00000034, 8, 0, { 9, 18 } },
		{ 14, 0, 9, 12, 12, (uchar_t*)0x00000052, 8, 0, { 9, 18 } },
		{ 14, 1, 8, 13, 13, (uchar_t*)0x000000BE, 8, 0, { 9, 18 } },
		{ 14, 0, 9, 13, 13, (uchar_t*)0x00000126, 8, 0, { 9, 18 } },
		{ 14, 0, 9, 13, 13, (uchar_t*)0x0000019B, 8, 0, { 9, 18 } },
		{ 14, 3, 3, 5, 5, (uchar_t*)0x00000210, 8, 0, { 9, 18 } },
		{ 14, 4, 4, 16, 16, (uchar_t*)0x0000021F, 8, 0, { 9, 18 } },
		{ 14, 1, 4, 16, 16, (uchar_t*)0x0000025F, 8, 0, { 9, 18 } },
		{ 12, 0, 9, 8, 8, (uchar_t*)0x0000029F, 8, 0, { 9, 18 } },
		{ 12, 0, 9, 9, 9, (uchar_t*)0x000002E7, 8, 0, { 9, 18 } },
		{ 4, 2, 4, 5, 5, (uchar_t*)0x00000338, 8, 0, { 9, 18 } },
		{ 9, 1, 7, 2, 2, (uchar_t*)0x0000034C, 8, 0, { 9, 18 } },
		{ 4, 2, 4, 3, 3, (uchar_t*)0x0000035A, 8, 0, { 9, 18 } },
		{ 14, 5, 3, 13, 13, (uchar_t*)0x00000366, 8, 0, { 9, 18 } },
		{ 14, 0, 9, 13, 13, (uchar_t*)0x0000038D, 8, 0, { 9, 18 } },
		{ 14, 1, 5, 12, 12, (uchar_t*)0x00000402, 8, 0, { 9, 18 } },
		{ 14, 1, 7, 12, 12, (uchar_t*)0x0000043E, 8, 0, { 9, 18 } },
		{ 14, 0, 8, 13, 13, (uchar_t*)0x00000492, 8, 0, { 9, 18 } },
		{ 14, 0, 9, 12, 12, (uchar_t*)0x000004FA, 8, 0, { 9, 18 } },
		{ 14, 0, 8, 13, 13, (uchar_t*)0x00000566, 8, 0, { 9, 18 } },
		{ 14, 0, 8, 13, 13, (uchar_t*)0x000005CE, 8, 0, { 9, 18 } },
		{ 14, 1, 7, 12, 12, (uchar_t*)0x00000636, 8, 0, { 9, 18 } },
		{ 14, 0, 8, 13, 13, (uchar_t*)0x0000068A, 8, 0, { 9, 18 } },
		{ 14, 0, 8, 13, 13, (uchar_t*)0x000006F2, 8, 0, { 9, 18 } },
		{ 10, 2, 4, 9, 9, (uchar_t*)0x0000075A, 8, 0, { 9, 18 } },
		{ 10, 2, 4, 11, 11, (uchar_t*)0x0000077E, 8, 0, { 9, 18 } },
		{ 13, 3, 6, 11, 11, (uchar_t*)0x000007AA, 8, 0, { 9, 18 } },
		{ 10, 0, 9, 5, 5, (uchar_t*)0x000007EC, 8, 0, { 9, 18 } },
		{ 13, 0, 5, 11, 11, (uchar_t*)0x00000819, 8, 0, { 9, 18 } },
		{ 14, 0, 8, 13, 13, (uchar_t*)0x00000850, 8, 0, { 9, 18 } },
		{ 14, 0, 9, 13, 13, (uchar_t*)0x000008B8, 8, 0, { 9, 18 } },
		{ 14, 0, 9, 12, 12, (uchar_t*)0x0000092D, 8, 0, { 9, 18 } },
		{ 14, 0, 9, 12, 12, (uchar_t*)0x00000999, 8, 0, { 9, 18 } },
		{ 14, 1, 8, 13, 13, (uchar_t*)0x00000A05, 8, 0, { 9, 18 } },
		{ 14, 0, 9, 12, 12, (uchar_t*)0x00000A6D, 8, 0, { 9, 18 } },
		{ 14, 0, 8, 12, 12, (uchar_t*)0x00000AD9, 8, 0, { 9, 18 } },
		{ 14, 1, 7, 12, 12, (uchar_t*)0x00000B39, 8, 0, { 9, 18 } },
		{ 14, 0, 9, 13, 13, (uchar_t*)0x00000B8D, 8, 0, { 9, 18 } },
		{ 14, 0, 8, 12, 12, (uchar_t*)0x00000C02, 8, 0, { 9, 18 } },
		{ 14, 1, 7, 12, 12, (uchar_t*)0x00000C62, 8, 0, { 9, 18 } },
		{ 14, 2, 7, 13, 13, (uchar_t*)0x00000CB6, 8, 0, { 9, 18 } },
		{ 14, 0, 9, 12, 12, (uchar_t*)0x00000D11, 8, 0, { 9, 18 } },
		{ 14, 0, 8, 12, 12, (uchar_t*)0x00000D7D, 8, 0, { 9, 18 } },
		{ 14, 0, 9, 12, 12, (uchar_t*)0x00000DDD, 8, 0, { 9, 18 } },
		{ 14, 0, 9, 12, 12, (uchar_t*)0x00000E49, 8, 0, { 9, 18 } },
		{ 14, 0, 9, 13, 13, (uchar_t*)0x00000EB5, 8, 0, { 9, 18 } },
		{ 14, 0, 9, 12, 12, (uchar_t*)0x00000F2A, 8, 0, { 9, 18 } },
		{ 14, 0, 9, 15, 15, (uchar_t*)0x00000F96, 8, 0, { 9, 18 } },
		{ 14, 0, 9, 12, 12, (uchar_t*)0x0000101D, 8, 0, { 9, 18 } },
		{ 14, 1, 8, 13, 13, (uchar_t*)0x00001089, 8, 0, { 9, 18 } },
		{ 14, 0, 9, 12, 12, (uchar_t*)0x000010F1, 8, 0, { 9, 18 } },
		{ 14, 0, 9, 13, 13, (uchar_t*)0x0000115D, 8, 0, { 9, 18 } },
		{ 14, 0, 9, 12, 12, (uchar_t*)0x000011D2, 8, 0, { 9, 18 } },
		{ 14, 0, 9, 12, 12, (uchar_t*)0x0000123E, 8, 0, { 9, 18 } },
		{ 14, 0, 9, 12, 12, (uchar_t*)0x000012AA, 8, 0, { 9, 18 } },
		{ 14, 0, 9, 12, 12, (uchar_t*)0x00001316, 8, 0, { 9, 18 } },
		{ 14, 0, 9, 12, 12, (uchar_t*)0x00001382, 8, 0, { 9, 18 } },
		{ 14, 2, 6, 14, 14, (uchar_t*)0x000013EE, 8, 0, { 9, 18 } },
		{ 14, 0, 3, 13, 13, (uchar_t*)0x00001442, 8, 0, { 9, 18 } },
		{ 14, 1, 6, 14, 14, (uchar_t*)0x00001469, 8, 0, { 9, 18 } },
		{ 14, 1, 7, 6, 6, (uchar_t*)0x000014BD, 8, 0, { 9, 18 } },
		{ 2, 0, 9, 2, 2, (uchar_t*)0x000014E7, 8, 0, { 9, 18 } },
		{ 14, 2, 4, 5, 5, (uchar_t*)0x000014F9, 8, 0, { 9, 18 } },
		{ 11, 0, 8, 10, 10, (uchar_t*)0x0000150D, 8, 0, { 9, 18 } },
		{ 14, 0, 9, 13, 13, (uchar_t*)0x0000155D, 8, 0, { 9, 18 } },
		{ 11, 1, 8, 10, 10, (uchar_t*)0x000015D2, 8, 0, { 9, 18 } },
		{ 14, 0, 8, 13, 13, (uchar_t*)0x00001622, 8, 0, { 9, 18 } },
		{ 11, 0, 8, 10, 10, (uchar_t*)0x0000168A, 8, 0, { 9, 18 } },
		{ 14, 2, 7, 12, 12, (uchar_t*)0x000016DA, 8, 0, { 9, 18 } },
		{ 11, 0, 9, 12, 12, (uchar_t*)0x0000172E, 8, 0, { 9, 18 } },
		{ 14, 1, 7, 12, 12, (uchar_t*)0x0000179A, 8, 0, { 9, 18 } },
		{ 14, 1, 7, 12, 12, (uchar_t*)0x000017EE, 8, 0, { 9, 18 } },
		{ 14, 0, 7, 16, 16, (uchar_t*)0x00001842, 8, 0, { 9, 18 } },
		{ 14, 0, 9, 12, 12, (uchar_t*)0x000018B2, 8, 0, { 9, 18 } },
		{ 14, 1, 7, 12, 12, (uchar_t*)0x0000191E, 8, 0, { 9, 18 } },
		{ 11, 0, 9, 9, 9, (uchar_t*)0x00001972, 8, 0, { 9, 18 } },
		{ 11, 0, 8, 9, 9, (uchar_t*)0x000019C3, 8, 0, { 9, 18 } },
		{ 11, 0, 9, 10, 10, (uchar_t*)0x00001A0B, 8, 0, { 9, 18 } },
		{ 11, 0, 9, 12, 12, (uchar_t*)0x00001A65, 8, 0, { 9, 18 } },
		{ 11, 0, 8, 12, 12, (uchar_t*)0x00001AD1, 8, 0, { 9, 18 } },
		{ 11, 1, 8, 9, 9, (uchar_t*)0x00001B31, 8, 0, { 9, 18 } },
		{ 11, 0, 8, 10, 10, (uchar_t*)0x00001B79, 8, 0, { 9, 18 } },
		{ 13, 1, 7, 12, 12, (uchar_t*)0x00001BC9, 8, 0, { 9, 18 } },
		{ 11, 0, 8, 10, 10, (uchar_t*)0x00001C1D, 8, 0, { 9, 18 } },
		{ 11, 0, 9, 9, 9, (uchar_t*)0x00001C6D, 8, 0, { 9, 18 } },
		{ 11, 0, 9, 9, 9, (uchar_t*)0x00001CBE, 8, 0, { 9, 18 } },
		{ 11, 0, 9, 9, 9, (uchar_t*)0x00001D0F, 8, 0, { 9, 18 } },
		{ 11, 0, 9, 13, 13, (uchar_t*)0x00001D60, 8, 0, { 9, 18 } },
		{ 11, 0, 9, 9, 9, (uchar_t*)0x00001DD5, 8, 0, { 9, 18 } },
		{ 14, 2, 6, 15, 15, (uchar_t*)0x00001E26, 8, 0, { 9, 18 } },
		{ 14, 3, 3, 15, 15, (uchar_t*)0x00001E80, 8, 0, { 9, 18 } },
		{ 14, 1, 5, 15, 15, (uchar_t*)0x00001EAD, 8, 0, { 9, 18 } },
		{ 11, 0, 9, 4, 4, (uchar_t*)0x00001EF8, 8, 0, { 9, 18 } }
	}
};

/* font_inconsolata_12px */
static const unsigned char font_bitmap_12px_bytes[] = {
	/* ch = '!' */
	0x00, 0xe5, 0x4d,
	0x00, 0xff, 0x5f,
	0x00, 0xe5, 0x3f,
	0x00, 0xb7, 0x3b,
	0x00, 0xb7, 0x32,
	0x00, 0x58, 0x1c,
	0x00, 0x15, 0x08,
	0x17, 0xff, 0x66,
	0x00, 0x0f, 0x04,
	/* ch = '"' */
	0x77, 0x77, 0x66, 0x97,
	0x7c, 0x6a, 0x54, 0x7c,
	0xc8, 0x29, 0xa7, 0x35,
	/* ch = '#' */
	0x00, 0x16, 0x58, 0x10, 0x2d, 0x00,
	0x00, 0x32, 0x90, 0x32, 0xa5, 0x00,
	0x2d, 0x82, 0xab, 0x7b, 0xbd, 0x26,
	0x12, 0x7b, 0x64, 0x6d, 0x5f, 0x00,
	0x00, 0x82, 0x3b, 0x7c, 0x3f, 0x00,
	0xa2, 0xef, 0x7c, 0xdb, 0x82, 0x39,
	0x00, 0xf7, 0x16, 0xe5, 0x22, 0x00,
	0x09, 0xcf, 0x10, 0xdd, 0x0d, 0x00,
	/* ch = '$' */
	0x00, 0x00, 0x45, 0x57, 0x00, 0x00,
	0x04, 0x94, 0xe5, 0xe5, 0xd4, 0x10,
	0x32, 0xcf, 0x50, 0x5f, 0x28, 0x0d,
	0x17, 0xef, 0xdb, 0x5f, 0x00, 0x00,
	0x00, 0x0c, 0x82, 0xf7, 0xa2, 0x04,
	0x00, 0x00, 0x50, 0x5f, 0x97, 0x5a,
	0x32, 0x5a, 0x50, 0x68, 0xb7, 0x43,
	0x10, 0x73, 0xe5, 0xe5, 0x50, 0x04,
	0x00, 0x00, 0x30, 0x39, 0x00, 0x00,
	/* ch = '%' */
	0x26, 0x74, 0x26, 0x00, 0x28, 0x28,
	0xe5, 0x3f, 0xff, 0x1c, 0xdb, 0x10,
	0xc8, 0x58, 0xdb, 0xa5, 0x47, 0x00,
	0x19, 0x5b, 0x4f, 0xb7, 0x0d, 0x00,
	0x00, 0x00, 0xb7, 0x32, 0x00, 0x00,
	0x00, 0x3b, 0xa5, 0xb1, 0xd4, 0x40,
	0x04, 0xdb, 0x3b, 0xcf, 0x32, 0xc8,
	0x54, 0x7c, 0x04, 0xd4, 0xc4, 0x5a,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0x00,
	/* ch = '&' */
	0x00, 0x22, 0x74, 0x28, 0x00, 0x00,
	0x14, 0xff, 0x31, 0xe5, 0x2f, 0x00,
	0x1a, 0xff, 0x16, 0xcf, 0x32, 0x00,
	0x00, 0x7c, 0xef, 0x8a, 0x04, 0x00,
	0x1f, 0xe5, 0xdb, 0x3f, 0x16, 0x13,
	0x99, 0x54, 0x1f, 0xf7, 0xb1, 0x6f,
	0xb7, 0x4a, 0x00, 0x74, 0xea, 0x13,
	0x40, 0xf7, 0xc4, 0xbb, 0x9e, 0x6c,
	0x00, 0x08, 0x0f, 0x00, 0x08, 0x08,
	/* ch = ''' */
	0x4d, 0xb1,
	0x50, 0x90,
	0x90, 0x3b,
	/* ch = '(' */
	0x00, 0x48, 0xd4,
	0x50, 0xb1, 0x13,
	0xf7, 0x1f, 0x00,
	0xa5, 0x00, 0x00,
	0x5f, 0x00, 0x00,
	0x64, 0x00, 0x00,
	0xb7, 0x00, 0x00,
	0xf7, 0x2c, 0x00,
	0x4d, 0xf7, 0x10,
	0x00, 0x48, 0xe5,
	/* ch = ')' */
	0x2d, 0xd4, 0x19,
	0x00, 0x3b, 0xf7,
	0x00, 0x00, 0x5f,
	0x00, 0x00, 0x0d,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x0d,
	0x00, 0x00, 0x54,
	0x00, 0x35, 0xef,
	0x33, 0xd4, 0x21,
	/* ch = '*' */
	0x00, 0x00, 0x12, 0x0c, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0x50, 0x00, 0x00,
	0x78, 0xa2, 0xa5, 0x82, 0xbb, 0x39,
	0x00, 0x12, 0xea, 0x8d, 0x0c, 0x00,
	0x00, 0x7c, 0x5f, 0xb1, 0x3b, 0x00,
	0x10, 0x8d, 0x0d, 0x24, 0x65, 0x04,
	/* ch = '+' */
	0x00, 0x00, 0x0f, 0x0c, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0x5f, 0x00, 0x00,
	0x12, 0x15, 0x88, 0x6d, 0x15, 0x0c,
	0x58, 0x74, 0xc8, 0xb1, 0x74, 0x39,
	0x00, 0x00, 0x7c, 0x5f, 0x00, 0x00,
	0x00, 0x00, 0x67, 0x51, 0x00, 0x00,
	/* ch = ',' */
	0x00, 0x12, 0x04,
	0x17, 0xff, 0x7c,
	0x00, 0x7c, 0x54,
	0x17, 0xa9, 0x10,
	/* ch = '-' */
	0x0c, 0x15, 0x15, 0x15, 0x15, 0x04,
	0x30, 0x74, 0x74, 0x74, 0x74, 0x1c,
	/* ch = '.' */
	0x00, 0x12, 0x08,
	0x17, 0xff, 0x5a,
	0x00, 0x0f, 0x04,
	/* ch = '/' */
	0x0d, 0xef, 0x17,
	0x48, 0x9e, 0x00,
	0xe5, 0x32, 0x00,
	0xb7, 0x04, 0x00,
	0x3b, 0x00, 0x00,
	0x0d, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	/* ch = '0' */
	0x00, 0x10, 0x50, 0x37, 0x04, 0x00,
	0x0d, 0xdb, 0x47, 0x8a, 0x8a, 0x00,
	0x44, 0x9e, 0x00, 0x35, 0xff, 0x1c,
	0x7c, 0x50, 0x1f, 0xd4, 0xc8, 0x3b,
	0x7c, 0x4a, 0xdb, 0x3b, 0x7c, 0x3b,
	0x6b, 0xff, 0x5f, 0x00, 0xb1, 0x39,
	0x2c, 0xff, 0x08, 0x17, 0xf7, 0x16,
	0x00, 0x77, 0xd4, 0xe5, 0x3b, 0x00,
	0x00, 0x00, 0x0c, 0x0c, 0x00, 0x00,
	/* ch = '1' */
	0x00, 0x00, 0x2a, 0x26,
	0x1a, 0xc4, 0xd4, 0x90,
	0x00, 0x00, 0x50, 0x90,
	0x00, 0x00, 0x50, 0x90,
	0x00, 0x00, 0x50, 0x90,
	0x00, 0x00, 0x50, 0x90,
	0x00, 0x00, 0x50, 0x90,
	0x00, 0x00, 0x50, 0x90,
	/* ch = '2' */
	0x00, 0x1b, 0x50, 0x47, 0x08, 0x00,
	0x25, 0xd4, 0x2a, 0x6a, 0xc8, 0x00,
	0x00, 0x0f, 0x00, 0x00, 0xff, 0x24,
	0x00, 0x00, 0x00, 0x24, 0xe5, 0x10,
	0x00, 0x00, 0x19, 0xd4, 0x3b, 0x00,
	0x00, 0x1f, 0xd4, 0x35, 0x00, 0x00,
	0x04, 0xb7, 0x3f, 0x00, 0x00, 0x00,
	0x40, 0xff, 0xd4, 0xcf, 0xcf, 0x32,
	/* ch = '3' */
	0x00, 0x1e, 0x50, 0x30, 0x04, 0x00,
	0x10, 0x9e, 0x30, 0x8a, 0x8a, 0x00,
	0x00, 0x00, 0x00, 0x21, 0xcf, 0x09,
	0x00, 0x04, 0x20, 0xb1, 0x5a, 0x00,
	0x00, 0x0d, 0x3e, 0xc4, 0x5a, 0x00,
	0x00, 0x00, 0x00, 0x17, 0xff, 0x0d,
	0x04, 0x21, 0x00, 0x24, 0xf7, 0x0d,
	0x27, 0xef, 0xab, 0xe5, 0x50, 0x00,
	0x00, 0x00, 0x12, 0x08, 0x00, 0x00,
	/* ch = '4' */
	0x00, 0x00, 0x00, 0x28, 0x1e, 0x00,
	0x00, 0x00, 0x24, 0xff, 0x5f, 0x00,
	0x00, 0x04, 0xc0, 0xb7, 0x5f, 0x00,
	0x00, 0x5f, 0x64, 0x7c, 0x5f, 0x00,
	0x24, 0xb7, 0x10, 0x7c, 0x5f, 0x00,
	0xa0, 0xef, 0xcf, 0xef, 0xef, 0x4e,
	0x00, 0x00, 0x00, 0x7c, 0x5f, 0x00,
	0x00, 0x00, 0x00, 0x7c, 0x5f, 0x00,
	/* ch = '5' */
	0x04, 0x36, 0x36, 0x36, 0x36, 0x00,
	0x1c, 0xff, 0x1a, 0x15, 0x15, 0x04,
	0x1c, 0xcf, 0x0d, 0x00, 0x00, 0x00,
	0x2a, 0xff, 0xb7, 0xcf, 0x35, 0x00,
	0x16, 0x50, 0x04, 0x21, 0xff, 0x1f,
	0x00, 0x00, 0x00, 0x00, 0xb7, 0x3b,
	0x13, 0x3d, 0x00, 0x10, 0xf7, 0x29,
	0x1f, 0xd4, 0xa4, 0xd4, 0x73, 0x04,
	0x00, 0x00, 0x0f, 0x0c, 0x00, 0x00,
	/* ch = '6' */
	0x00, 0x04, 0x47, 0x74, 0x22, 0x00,
	0x00, 0xb1, 0x6a, 0x20, 0x7e, 0x10,
	0x2a, 0xcf, 0x0d, 0x00, 0x00, 0x00,
	0x4d, 0xcf, 0xab, 0xcf, 0x2c, 0x00,
	0x50, 0xdb, 0x1b, 0x21, 0xff, 0x13,
	0x50, 0x90, 0x00, 0x00, 0xbd, 0x2f,
	0x27, 0xff, 0x04, 0x0d, 0xf7, 0x1c,
	0x00, 0x6b, 0xef, 0xd4, 0x5a, 0x00,
	0x00, 0x00, 0x08, 0x0c, 0x00, 0x00,
	/* ch = '7' */
	0x16, 0x36, 0x36, 0x36, 0x36, 0x0d,
	0x16, 0x36, 0x36, 0x67, 0xe5, 0x10,
	0x00, 0x00, 0x00, 0x7c, 0x6a, 0x00,
	0x00, 0x00, 0x0d, 0xf7, 0x1f, 0x00,
	0x00, 0x00, 0x48, 0xb7, 0x00, 0x00,
	0x00, 0x00, 0xb7, 0x47, 0x00, 0x00,
	0x00, 0x22, 0xff, 0x16, 0x00, 0x00,
	0x00, 0x5a, 0xa5, 0x00, 0x00, 0x00,
	/* ch = '8' */
	0x00, 0x19, 0x67, 0x5b, 0x08, 0x00,
	0x0d, 0xf7, 0x31, 0x54, 0xe0, 0x00,
	0x22, 0xff, 0x04, 0x1f, 0xf7, 0x0d,
	0x00, 0xa9, 0xb1, 0xb1, 0x5a, 0x00,
	0x04, 0x94, 0x85, 0xd4, 0x5a, 0x00,
	0x48, 0xa5, 0x00, 0x10, 0xf7, 0x29,
	0x5f, 0xab, 0x00, 0x0d, 0xe5, 0x2c,
	0x10, 0xbb, 0xcb, 0xe5, 0x73, 0x04,
	0x00, 0x00, 0x0f, 0x0c, 0x00, 0x00,
	/* ch = '9' */
	0x00, 0x1b, 0x67, 0x3f, 0x04, 0x00,
	0x17, 0xef, 0x31, 0x8a, 0x8a, 0x00,
	0x4d, 0x97, 0x00, 0x0d, 0xff, 0x1c,
	0x44, 0xa5, 0x00, 0x04, 0xff, 0x24,
	0x10, 0xdb, 0x84, 0xbb, 0xff, 0x24,
	0x00, 0x08, 0x15, 0x15, 0xff, 0x22,
	0x00, 0x0c, 0x00, 0x35, 0xc8, 0x0d,
	0x1e, 0xe5, 0xab, 0xdd, 0x26, 0x00,
	0x00, 0x00, 0x15, 0x00, 0x00, 0x00,
	/* ch = ':' */
	0x1a, 0xff, 0x5a,
	0x00, 0x25, 0x13,
	0x00, 0x00, 0x00,
	0x00, 0x12, 0x08,
	0x17, 0xff, 0x5a,
	0x00, 0x0f, 0x04,
	/* ch = ';' */
	0x1a, 0xff, 0x5a,
	0x00, 0x25, 0x13,
	0x00, 0x00, 0x00,
	0x00, 0x12, 0x04,
	0x17, 0xff, 0x7c,
	0x00, 0x7c, 0x54,
	0x17, 0xa9, 0x10,
	/* ch = '<' */
	0x00, 0x04, 0x3f, 0x4e,
	0x37, 0xdd, 0x66, 0x13,
	0x73, 0x16, 0x00, 0x00,
	0x1b, 0x00, 0x00, 0x00,
	0xd4, 0x84, 0x08, 0x00,
	0x04, 0x37, 0xef, 0x3e,
	0x00, 0x00, 0x08, 0x26,
	/* ch = '=' */
	0x12, 0x15, 0x15, 0x15, 0x15, 0x0c,
	0x2d, 0x36, 0x36, 0x36, 0x36, 0x26,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x95, 0xcf, 0xcf, 0xcf, 0xcf, 0x4e,
	/* ch = '>' */
	0x87, 0x28, 0x00, 0x00,
	0x1b, 0xa4, 0xcb, 0x1e,
	0x00, 0x00, 0x1e, 0xa4,
	0x00, 0x00, 0x00, 0x37,
	0x00, 0x1b, 0xbb, 0x94,
	0x7f, 0xbb, 0x25, 0x00,
	0x28, 0x04, 0x00, 0x00,
	/* ch = '?' */
	0x08, 0x8d, 0xe5, 0xef, 0x4d, 0x00,
	0x2f, 0x7e, 0x04, 0x26, 0xff, 0x1c,
	0x00, 0x00, 0x00, 0x1c, 0xff, 0x22,
	0x00, 0x00, 0x04, 0xb1, 0x84, 0x04,
	0x00, 0x00, 0x50, 0x90, 0x04, 0x00,
	0x00, 0x00, 0x67, 0x51, 0x00, 0x00,
	0x00, 0x00, 0x0c, 0x0c, 0x00, 0x00,
	0x00, 0x00, 0xb1, 0xc0, 0x00, 0x00,
	0x00, 0x00, 0x0c, 0x0c, 0x00, 0x00,
	/* ch = '@' */
	0x00, 0x13, 0x5b, 0x67, 0x1b, 0x00,
	0x1f, 0xd4, 0x25, 0x1b, 0xdb, 0x22,
	0x7c, 0x43, 0x04, 0x25, 0x87, 0x5f,
	0xcf, 0x26, 0xc4, 0x5a, 0x68, 0x5f,
	0xf7, 0x32, 0xd9, 0x00, 0x5f, 0x5f,
	0xb1, 0x35, 0x94, 0xdd, 0xcf, 0x51,
	0x44, 0xa5, 0x04, 0x00, 0x00, 0x00,
	0x00, 0x66, 0xe5, 0x74, 0xd4, 0x1a,
	0x00, 0x00, 0x04, 0x15, 0x04, 0x00,
	/* ch = 'A' */
	0x00, 0x00, 0x39, 0x04, 0x00, 0x00,
	0x00, 0x00, 0xcf, 0x3b, 0x00, 0x00,
	0x00, 0x24, 0xff, 0x9e, 0x00, 0x00,
	0x00, 0x6b, 0x64, 0xf7, 0x1c, 0x00,
	0x00, 0xe5, 0x1f, 0x7c, 0x54, 0x00,
	0x2c, 0xef, 0xa2, 0xbd, 0xe0, 0x00,
	0x70, 0x5f, 0x00, 0x04, 0xe5, 0x29,
	0xe5, 0x24, 0x00, 0x00, 0x6b, 0x82,
	/* ch = 'B' */
	0x2d, 0x36, 0x36, 0x36, 0x08, 0x00,
	0xb7, 0x46, 0x15, 0x6a, 0xf7, 0x04,
	0xb7, 0x3b, 0x00, 0x04, 0xff, 0x24,
	0xb7, 0x73, 0x36, 0x94, 0x84, 0x04,
	0xb7, 0x62, 0x36, 0x77, 0xc0, 0x04,
	0xb7, 0x3b, 0x00, 0x00, 0xb7, 0x50,
	0xb7, 0x3b, 0x00, 0x04, 0xcf, 0x43,
	0xb7, 0xe5, 0xcf, 0xdd, 0x73, 0x04,
	/* ch = 'C' */
	0x00, 0x0c, 0x47, 0x5b, 0x1b, 0x00,
	0x10, 0xdb, 0x47, 0x20, 0xdb, 0x3b,
	0x5a, 0x82, 0x00, 0x00, 0x1e, 0x13,
	0xb1, 0x3f, 0x00, 0x00, 0x00, 0x00,
	0xb7, 0x3b, 0x00, 0x00, 0x00, 0x00,
	0x90, 0x5f, 0x00, 0x00, 0x00, 0x00,
	0x39, 0xe0, 0x04, 0x00, 0x3d, 0x13,
	0x00, 0x66, 0xef, 0x9e, 0xbb, 0x19,
	0x00, 0x00, 0x08, 0x0f, 0x00, 0x00,
	/* ch = 'D' */
	0x26, 0x36, 0x36, 0x2a, 0x04, 0x00,
	0x7c, 0x68, 0x20, 0x99, 0x90, 0x00,
	0x7c, 0x5f, 0x00, 0x0d, 0xe5, 0x2c,
	0x7c, 0x5f, 0x00, 0x00, 0x90, 0x5a,
	0x7c, 0x5f, 0x00, 0x00, 0x7c, 0x5f,
	0x7c, 0x5f, 0x00, 0x00, 0xa7, 0x47,
	0x7c, 0x5f, 0x00, 0x26, 0xf7, 0x16,
	0x7c, 0xc8, 0x9e, 0xc4, 0x2e, 0x00,
	/* ch = 'E' */
	0x26, 0x36, 0x36, 0x36, 0x36, 0x16,
	0x7c, 0x68, 0x15, 0x15, 0x15, 0x0c,
	0x7c, 0x5f, 0x00, 0x00, 0x00, 0x00,
	0x7c, 0x6d, 0x15, 0x15, 0x0f, 0x00,
	0x7c, 0x82, 0x36, 0x36, 0x2d, 0x00,
	0x7c, 0x5f, 0x00, 0x00, 0x00, 0x00,
	0x7c, 0x5f, 0x00, 0x00, 0x00, 0x00,
	0x7c, 0xef, 0xcf, 0xcf, 0xcf, 0x32,
	/* ch = 'F' */
	0x16, 0x36, 0x36, 0x36, 0x36, 0x0d,
	0x32, 0xcf, 0x15, 0x15, 0x15, 0x08,
	0x32, 0xcf, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xea, 0x36, 0x36, 0x1e, 0x00,
	0x32, 0xcf, 0x36, 0x36, 0x26, 0x00,
	0x32, 0xcf, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xcf, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xcf, 0x00, 0x00, 0x00, 0x00,
	/* ch = 'G' */
	0x00, 0x13, 0x50, 0x5b, 0x1b, 0x00,
	0x1c, 0xe5, 0x3f, 0x25, 0xdb, 0x36,
	0x6b, 0x6f, 0x00, 0x00, 0x1e, 0x10,
	0xb7, 0x3b, 0x00, 0x00, 0x00, 0x00,
	0xb7, 0x3b, 0x00, 0x74, 0x74, 0x30,
	0xa0, 0x47, 0x00, 0x15, 0x88, 0x5f,
	0x44, 0xcf, 0x04, 0x00, 0x7c, 0x5f,
	0x04, 0x7e, 0xef, 0x9e, 0xe5, 0x32,
	0x00, 0x00, 0x04, 0x0f, 0x00, 0x00,
	/* ch = 'H' */
	0x26, 0x30, 0x00, 0x00, 0x2d, 0x16,
	0x7c, 0x5f, 0x00, 0x00, 0xb7, 0x3b,
	0x7c, 0x5f, 0x00, 0x00, 0xb7, 0x3b,
	0x7c, 0x6d, 0x15, 0x15, 0xbd, 0x3b,
	0x7c, 0x82, 0x36, 0x36, 0xcf, 0x3b,
	0x7c, 0x5f, 0x00, 0x00, 0xb7, 0x3b,
	0x7c, 0x5f, 0x00, 0x00, 0xb7, 0x3b,
	0x7c, 0x5f, 0x00, 0x00, 0xb7, 0x3b,
	/* ch = 'I' */
	0x16, 0x36, 0x36, 0x36, 0x2d,
	0x08, 0x15, 0xbd, 0x46, 0x15,
	0x00, 0x00, 0xb7, 0x3b, 0x00,
	0x00, 0x00, 0xb7, 0x3b, 0x00,
	0x00, 0x00, 0xb7, 0x3b, 0x00,
	0x00, 0x00, 0xb7, 0x3b, 0x00,
	0x00, 0x00, 0xb7, 0x3b, 0x00,
	0x22, 0x74, 0xe5, 0xb1, 0x58,
	/* ch = 'J' */
	0x16, 0x36, 0x36, 0x36, 0x1e,
	0x08, 0x15, 0xbd, 0x46, 0x0f,
	0x00, 0x00, 0xb7, 0x3b, 0x00,
	0x00, 0x00, 0xb7, 0x3b, 0x00,
	0x00, 0x00, 0xb7, 0x3b, 0x00,
	0x00, 0x00, 0xb7, 0x3b, 0x00,
	0x10, 0x04, 0xe5, 0x32, 0x00,
	0xef, 0xab, 0x99, 0x0d, 0x00,
	0x08, 0x12, 0x00, 0x00, 0x00,
	/* ch = 'K' */
	0x2d, 0x1c, 0x00, 0x04, 0x5b, 0x26,
	0xb7, 0x3b, 0x04, 0x7c, 0x8a, 0x04,
	0xb7, 0x3b, 0x7c, 0x8a, 0x04, 0x00,
	0xb7, 0xc8, 0xb7, 0x10, 0x00, 0x00,
	0xb7, 0xbb, 0xf7, 0x24, 0x00, 0x00,
	0xb7, 0x3b, 0x50, 0xcf, 0x04, 0x00,
	0xb7, 0x3b, 0x04, 0xb1, 0x6f, 0x00,
	0xb7, 0x3b, 0x00, 0x1c, 0xf7, 0x3b,
	/* ch = 'L' */
	0x1e, 0x39, 0x00, 0x00, 0x00, 0x00,
	0x50, 0x90, 0x00, 0x00, 0x00, 0x00,
	0x50, 0x90, 0x00, 0x00, 0x00, 0x00,
	0x50, 0x90, 0x00, 0x00, 0x00, 0x00,
	0x50, 0x90, 0x00, 0x00, 0x00, 0x00,
	0x50, 0x90, 0x00, 0x00, 0x00, 0x00,
	0x50, 0x90, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xf7, 0xcf, 0xcf, 0xcf, 0x32,
	/* ch = 'M' */
	0x2d, 0x10, 0x00, 0x00, 0x21, 0x1e,
	0xb7, 0x82, 0x00, 0x04, 0xdb, 0x5f,
	0xb7, 0xff, 0x24, 0x48, 0xff, 0x5f,
	0xb7, 0xb7, 0xa5, 0xdb, 0xb7, 0x5f,
	0xb7, 0x47, 0xe5, 0x6f, 0x7c, 0x5f,
	0xb7, 0x3b, 0x21, 0x19, 0x7c, 0x5f,
	0xb7, 0x3b, 0x00, 0x00, 0x7c, 0x5f,
	0xb7, 0x3b, 0x00, 0x00, 0x7c, 0x5f,
	/* ch = 'N' */
	0x26, 0x21, 0x00, 0x00, 0x2d, 0x28,
	0x7c, 0xf7, 0x0d, 0x00, 0xb7, 0x3b,
	0x7c, 0xf7, 0x6f, 0x00, 0xb7, 0x3b,
	0x7c, 0x5f, 0xff, 0x1c, 0xb7, 0x3b,
	0x7c, 0x3b, 0x6b, 0x90, 0xb7, 0x3b,
	0x7c, 0x3b, 0x10, 0xf7, 0xff, 0x3b,
	0x7c, 0x3b, 0x00, 0x50, 0xff, 0x3b,
	0x7c, 0x3b, 0x00, 0x04, 0xc8, 0x3b,
	/* ch = 'O' */
	0x00, 0x1b, 0x67, 0x50, 0x08, 0x00,
	0x24, 0xef, 0x37, 0x5f, 0xf7, 0x0d,
	0x8a, 0x54, 0x00, 0x00, 0xa7, 0x50,
	0xe5, 0x26, 0x00, 0x00, 0x5f, 0x8a,
	0xff, 0x24, 0x00, 0x00, 0x50, 0x90,
	0xbd, 0x3f, 0x00, 0x00, 0x6b, 0x6f,
	0x5a, 0xa5, 0x00, 0x10, 0xe5, 0x32,
	0x04, 0xa2, 0xe5, 0xef, 0x65, 0x04,
	0x00, 0x00, 0x0c, 0x08, 0x00, 0x00,
	/* ch = 'P' */
	0x26, 0x36, 0x36, 0x36, 0x13, 0x00,
	0x7c, 0x82, 0x36, 0x4f, 0xff, 0x22,
	0x7c, 0x5f, 0x00, 0x00, 0x97, 0x5a,
	0x7c, 0x5f, 0x00, 0x16, 0xe5, 0x2f,
	0x7c, 0xb1, 0x74, 0x74, 0x3f, 0x00,
	0x7c, 0x5f, 0x00, 0x00, 0x00, 0x00,
	0x7c, 0x5f, 0x00, 0x00, 0x00, 0x00,
	0x7c, 0x5f, 0x00, 0x00, 0x00, 0x00,
	/* ch = 'Q' */
	0x00, 0x1b, 0x67, 0x50, 0x08, 0x00,
	0x24, 0xe5, 0x31, 0x5a, 0xf7, 0x0d,
	0x8a, 0x54, 0x00, 0x00, 0xa7, 0x50,
	0xe5, 0x26, 0x00, 0x00, 0x54, 0x8a,
	0xff, 0x24, 0x00, 0x00, 0x50, 0x90,
	0xbd, 0x3b, 0x00, 0x00, 0x6b, 0x6f,
	0x5a, 0xa5, 0x00, 0x08, 0xe5, 0x32,
	0x04, 0x94, 0xd4, 0xe5, 0x65, 0x04,
	0x00, 0x00, 0x6b, 0x74, 0x00, 0x00,
	0x00, 0x00, 0x16, 0x8f, 0xcf, 0x36,
	/* ch = 'R' */
	0x26, 0x36, 0x36, 0x36, 0x13, 0x00,
	0x7c, 0x82, 0x36, 0x5a, 0xff, 0x13,
	0x7c, 0x5f, 0x00, 0x00, 0xbd, 0x3b,
	0x7c, 0x5f, 0x00, 0x24, 0xf7, 0x1f,
	0x7c, 0xb1, 0x9c, 0xec, 0x2e, 0x00,
	0x7c, 0x5f, 0x04, 0xe5, 0x32, 0x00,
	0x7c, 0x5f, 0x00, 0x48, 0xbd, 0x00,
	0x7c, 0x5f, 0x00, 0x04, 0xe5, 0x35,
	/* ch = 'S' */
	0x00, 0x16, 0x47, 0x47, 0x16, 0x00,
	0x1c, 0xef, 0x31, 0x2b, 0xe5, 0x17,
	0x4d, 0xc6, 0x00, 0x00, 0x0f, 0x00,
	0x10, 0xdb, 0x8a, 0x16, 0x00, 0x00,
	0x00, 0x08, 0x3f, 0xd4, 0x92, 0x04,
	0x00, 0x00, 0x00, 0x04, 0xc8, 0x43,
	0x2a, 0x21, 0x00, 0x04, 0xb7, 0x43,
	0x2c, 0xef, 0x9e, 0xcb, 0x94, 0x10,
	0x00, 0x00, 0x0f, 0x0c, 0x00, 0x00,
	/* ch = 'T' */
	0x36, 0x36, 0x36, 0x36, 0x36, 0x1e,
	0x15, 0x15, 0xbd, 0x46, 0x15, 0x0f,
	0x00, 0x00, 0xb7, 0x3b, 0x00, 0x00,
	0x00, 0x00, 0xb7, 0x3b, 0x00, 0x00,
	0x00, 0x00, 0xb7, 0x3b, 0x00, 0x00,
	0x00, 0x00, 0xb7, 0x3b, 0x00, 0x00,
	0x00, 0x00, 0xb7, 0x3b, 0x00, 0x00,
	0x00, 0x00, 0xb7, 0x3b, 0x00, 0x00,
	/* ch = 'U' */
	0x26, 0x1e, 0x00, 0x00, 0x26, 0x1e,
	0x7c, 0x5f, 0x00, 0x00, 0x7c, 0x5f,
	0x7c, 0x5f, 0x00, 0x00, 0x7c, 0x5f,
	0x7c, 0x5f, 0x00, 0x00, 0x7c, 0x5f,
	0x7c, 0x5f, 0x00, 0x00, 0x7c, 0x5f,
	0x7c, 0x5f, 0x00, 0x00, 0x7c, 0x5f,
	0x6b, 0x82, 0x00, 0x04, 0xc8, 0x39,
	0x10, 0xcb, 0xbb, 0xbb, 0x84, 0x04,
	0x00, 0x00, 0x0f, 0x0c, 0x00, 0x00,
	/* ch = 'V' */
	0x33, 0x10, 0x00, 0x00, 0x1e, 0x26,
	0x8a, 0x5f, 0x00, 0x00, 0x90, 0x47,
	0x39, 0xcf, 0x00, 0x0d, 0xff, 0x16,
	0x0d, 0xf7, 0x24, 0x39, 0xa5, 0x00,
	0x00, 0x8a, 0x5f, 0x7c, 0x47, 0x00,
	0x00, 0x32, 0xcf, 0xf7, 0x16, 0x00,
	0x00, 0x04, 0xf7, 0xa5, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0x47, 0x00, 0x00,
	/* ch = 'W' */
	0x36, 0x00, 0x00, 0x00, 0x0d, 0x2d,
	0xf7, 0x22, 0x44, 0x47, 0x32, 0x97,
	0xb1, 0x39, 0x90, 0x7c, 0x4d, 0x64,
	0x7c, 0x5f, 0xef, 0xea, 0x6b, 0x3f,
	0x50, 0xf7, 0x90, 0xe5, 0xcf, 0x2c,
	0x32, 0xff, 0x50, 0x7c, 0xff, 0x16,
	0x1c, 0xff, 0x24, 0x3b, 0xcf, 0x0d,
	0x00, 0xcf, 0x0d, 0x1a, 0xb7, 0x00,
	/* ch = 'X' */
	0x39, 0x21, 0x00, 0x00, 0x30, 0x13,
	0x2a, 0xff, 0x0d, 0x32, 0xc8, 0x0d,
	0x00, 0x90, 0x6f, 0xc8, 0x43, 0x00,
	0x00, 0x1c, 0xff, 0xb7, 0x0d, 0x00,
	0x00, 0x04, 0xe5, 0x90, 0x00, 0x00,
	0x00, 0x50, 0xb1, 0xf7, 0x2c, 0x00,
	0x10, 0xf7, 0x2c, 0x50, 0xb7, 0x00,
	0x5f, 0x90, 0x00, 0x04, 0xdb, 0x3f,
	/* ch = 'Y' */
	0x44, 0x19, 0x00, 0x00, 0x26, 0x24,
	0x50, 0xbd, 0x00, 0x0d, 0xe5, 0x29,
	0x0d, 0xe5, 0x35, 0x48, 0x9e, 0x04,
	0x00, 0x48, 0xbd, 0xc8, 0x35, 0x00,
	0x00, 0x04, 0xe5, 0xb7, 0x04, 0x00,
	0x00, 0x00, 0x7c, 0x5f, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0x5f, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0x5f, 0x00, 0x00,
	/* ch = 'Z' */
	0x26, 0x36, 0x36, 0x36, 0x36, 0x16,
	0x0f, 0x15, 0x15, 0x25, 0xf7, 0x1f,
	0x00, 0x00, 0x00, 0x90, 0x64, 0x00,
	0x00, 0x00, 0x2f, 0xdb, 0x10, 0x00,
	0x00, 0x04, 0xdb, 0x39, 0x00, 0x00,
	0x00, 0x5f, 0x9e, 0x04, 0x00, 0x00,
	0x1c, 0xf7, 0x1f, 0x00, 0x00, 0x00,
	0x77, 0xff, 0xcf, 0xcf, 0xcf, 0x4e,
	/* ch = '[' */
	0xb7, 0x9c, 0x74, 0x74, 0x0d,
	0xb7, 0x3b, 0x00, 0x00, 0x00,
	0xb7, 0x3b, 0x00, 0x00, 0x00,
	0xb7, 0x3b, 0x00, 0x00, 0x00,
	0xb7, 0x3b, 0x00, 0x00, 0x00,
	0xb7, 0x3b, 0x00, 0x00, 0x00,
	0xb7, 0x3b, 0x00, 0x00, 0x00,
	0xb7, 0x3b, 0x00, 0x00, 0x00,
	0xb7, 0xb1, 0x74, 0x74, 0x00,
	/* ch = '\' */
	0x3a, 0x9e, 0x00,
	0x0d, 0xf7, 0x24,
	0x00, 0x6b, 0x82,
	0x00, 0x17, 0xff,
	0x00, 0x00, 0x7c,
	0x00, 0x00, 0x22,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	/* ch = ']' */
	0x22, 0x74, 0x74, 0xc8, 0x5f,
	0x00, 0x00, 0x00, 0x7c, 0x5f,
	0x00, 0x00, 0x00, 0x7c, 0x5f,
	0x00, 0x00, 0x00, 0x7c, 0x5f,
	0x00, 0x00, 0x00, 0x7c, 0x5f,
	0x00, 0x00, 0x00, 0x7c, 0x5f,
	0x00, 0x00, 0x00, 0x7c, 0x5f,
	0x00, 0x00, 0x00, 0x7c, 0x5f,
	0x22, 0x74, 0x74, 0xc8, 0x5f,
	/* ch = '^' */
	0x00, 0x00, 0x21, 0x16, 0x00,
	0x00, 0x04, 0xdb, 0xa5, 0x00,
	0x00, 0x5f, 0x7c, 0xc8, 0x32,
	0x0a, 0xbd, 0x16, 0x2f, 0x82,
	/* ch = '_' */
	/* ch = '`' */
	0x55, 0x6a, 0x00,
	0x22, 0xff, 0x24,
	0x00, 0x73, 0x6c,
	/* ch = 'a' */
	0x00, 0x2a, 0x74, 0x67, 0x1b, 0x00,
	0x0d, 0x8d, 0x20, 0x31, 0xff, 0x13,
	0x00, 0x00, 0x15, 0x15, 0xff, 0x24,
	0x24, 0xdd, 0x50, 0x36, 0xd9, 0x24,
	0x7c, 0x64, 0x00, 0x10, 0xff, 0x24,
	0x32, 0xef, 0x82, 0xd4, 0xff, 0x24,
	0x00, 0x08, 0x15, 0x00, 0x00, 0x00,
	/* ch = 'b' */
	0x7c, 0x90, 0x00, 0x00, 0x00, 0x00,
	0x7c, 0x90, 0x00, 0x00, 0x00, 0x00,
	0x7c, 0xab, 0x5b, 0x67, 0x1b, 0x00,
	0x7c, 0xe5, 0x25, 0x3f, 0xff, 0x1c,
	0x7c, 0x90, 0x00, 0x00, 0xbd, 0x50,
	0x7c, 0x90, 0x00, 0x00, 0xa7, 0x5f,
	0x7c, 0xab, 0x00, 0x10, 0xe5, 0x32,
	0x7c, 0xbb, 0xbb, 0xe5, 0x84, 0x04,
	0x00, 0x00, 0x0c, 0x0f, 0x00, 0x00,
	/* ch = 'c' */
	0x00, 0x13, 0x5b, 0x74, 0x31, 0x00,
	0x17, 0xef, 0x3f, 0x1a, 0xb1, 0x33,
	0x5f, 0x97, 0x00, 0x00, 0x0c, 0x04,
	0x7c, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x39, 0xf7, 0x08, 0x00, 0x21, 0x00,
	0x00, 0x73, 0xef, 0xab, 0xd4, 0x24,
	0x00, 0x00, 0x08, 0x12, 0x00, 0x00,
	/* ch = 'd' */
	0x00, 0x00, 0x00, 0x00, 0xb7, 0x3b,
	0x00, 0x00, 0x00, 0x00, 0xb7, 0x3b,
	0x00, 0x2e, 0x74, 0x48, 0xbd, 0x3b,
	0x3b, 0xb7, 0x20, 0x54, 0xff, 0x3b,
	0x90, 0x50, 0x00, 0x00, 0xff, 0x3b,
	0xb1, 0x47, 0x00, 0x00, 0xff, 0x3b,
	0x6b, 0x97, 0x00, 0x1f, 0xff, 0x3b,
	0x10, 0xd4, 0xcb, 0xcb, 0xe5, 0x3b,
	0x00, 0x00, 0x12, 0x00, 0x00, 0x00,
	/* ch = 'e' */
	0x00, 0x21, 0x74, 0x67, 0x19, 0x00,
	0x2a, 0xdb, 0x22, 0x37, 0xf7, 0x0d,
	0x77, 0x73, 0x15, 0x15, 0xc6, 0x39,
	0x8a, 0x82, 0x36, 0x36, 0x36, 0x1e,
	0x5a, 0xa5, 0x00, 0x00, 0x0c, 0x00,
	0x04, 0xa2, 0xcb, 0x8f, 0xbb, 0x13,
	0x00, 0x00, 0x0c, 0x0f, 0x00, 0x00,
	/* ch = 'f' */
	0x00, 0x73, 0xbb, 0xd4, 0x6c,
	0x2f, 0xcf, 0x0d, 0x04, 0x28,
	0x3e, 0xd9, 0x15, 0x0c, 0x00,
	0x9c, 0xe5, 0x74, 0x39, 0x00,
	0x32, 0xcf, 0x00, 0x00, 0x00,
	0x32, 0xcf, 0x00, 0x00, 0x00,
	0x32, 0xcf, 0x00, 0x00, 0x00,
	0x32, 0xcf, 0x00, 0x00, 0x00,
	/* ch = 'g' */
	0x00, 0x37, 0x74, 0x48, 0x5b, 0x42,
	0x40, 0xb1, 0x16, 0x82, 0x7b, 0x04,
	0x5f, 0x6f, 0x00, 0x54, 0x8a, 0x00,
	0x1c, 0xec, 0x9e, 0xd4, 0x26, 0x00,
	0x32, 0xab, 0x15, 0x04, 0x00, 0x00,
	0x22, 0xef, 0xcf, 0xcf, 0xdd, 0x10,
	0xa0, 0x3f, 0x00, 0x00, 0x88, 0x5a,
	0x44, 0xdd, 0x82, 0x9e, 0xa2, 0x16,
	/* ch = 'h' */
	0x50, 0x97, 0x00, 0x00, 0x00, 0x00,
	0x50, 0x90, 0x00, 0x00, 0x00, 0x00,
	0x50, 0x90, 0x3f, 0x74, 0x26, 0x00,
	0x50, 0xff, 0x47, 0x37, 0xff, 0x13,
	0x50, 0xb7, 0x00, 0x00, 0xff, 0x24,
	0x50, 0x90, 0x00, 0x00, 0xff, 0x24,
	0x50, 0x90, 0x00, 0x00, 0xff, 0x24,
	0x50, 0x90, 0x00, 0x00, 0xff, 0x24,
	/* ch = 'i' */
	0x00, 0x00, 0x87, 0x67, 0x00,
	0x00, 0x00, 0x22, 0x21, 0x00,
	0x00, 0x36, 0x36, 0x1e, 0x00,
	0x00, 0x15, 0x88, 0x5f, 0x00,
	0x00, 0x00, 0x7c, 0x5f, 0x00,
	0x00, 0x00, 0x7c, 0x5f, 0x00,
	0x00, 0x00, 0x7c, 0x5f, 0x00,
	0x14, 0x74, 0xc8, 0xc8, 0x58,
	/* ch = 'j' */
	0x00, 0x00, 0x00, 0xab, 0x5b,
	0x00, 0x00, 0x00, 0x28, 0x21,
	0x00, 0x2d, 0x36, 0x36, 0x1e,
	0x00, 0x12, 0x15, 0xbd, 0x5f,
	0x00, 0x00, 0x00, 0xb7, 0x5f,
	0x00, 0x00, 0x00, 0xb7, 0x5f,
	0x00, 0x00, 0x00, 0xb7, 0x5f,
	0x00, 0x00, 0x00, 0xb7, 0x5a,
	0x19, 0x10, 0x00, 0xcf, 0x39,
	0x51, 0xef, 0xcb, 0x94, 0x10,
	/* ch = 'k' */
	0x50, 0x97, 0x00, 0x00, 0x00, 0x00,
	0x50, 0x90, 0x00, 0x00, 0x00, 0x00,
	0x50, 0x90, 0x00, 0x10, 0x50, 0x10,
	0x50, 0x90, 0x13, 0xd4, 0x3f, 0x00,
	0x50, 0xcf, 0xdb, 0x3f, 0x00, 0x00,
	0x50, 0xdb, 0xb1, 0x90, 0x00, 0x00,
	0x50, 0x90, 0x10, 0xdb, 0x5f, 0x00,
	0x50, 0x90, 0x00, 0x1f, 0xf7, 0x3b,
	/* ch = 'l' */
	0x2d, 0xcf, 0xf7, 0x5f, 0x00,
	0x00, 0x00, 0xb7, 0x5f, 0x00,
	0x00, 0x00, 0xb7, 0x5f, 0x00,
	0x00, 0x00, 0xb7, 0x5f, 0x00,
	0x00, 0x00, 0xb7, 0x5f, 0x00,
	0x00, 0x00, 0xb7, 0x5f, 0x00,
	0x00, 0x00, 0xb7, 0x5f, 0x00,
	0x22, 0x74, 0xe5, 0xc8, 0x74,
	/* ch = 'm' */
	0x2d, 0x50, 0x67, 0x37, 0x74, 0x19,
	0xb7, 0x64, 0x97, 0x90, 0x68, 0x8a,
	0xb7, 0x26, 0x7c, 0x5f, 0x50, 0x90,
	0xb7, 0x24, 0x7c, 0x5f, 0x50, 0x90,
	0xb7, 0x24, 0x7c, 0x5f, 0x50, 0x90,
	0xb7, 0x24, 0x7c, 0x5f, 0x50, 0x90,
	/* ch = 'n' */
	0x1e, 0x28, 0x3f, 0x74, 0x21, 0x00,
	0x50, 0xff, 0x47, 0x3a, 0xff, 0x13,
	0x50, 0xa5, 0x00, 0x00, 0xff, 0x24,
	0x50, 0x90, 0x00, 0x00, 0xff, 0x24,
	0x50, 0x90, 0x00, 0x00, 0xff, 0x24,
	0x50, 0x90, 0x00, 0x00, 0xff, 0x24,
	/* ch = 'o' */
	0x00, 0x1b, 0x67, 0x5b, 0x13, 0x00,
	0x2f, 0xdb, 0x25, 0x3f, 0xf7, 0x0d,
	0x90, 0x64, 0x00, 0x00, 0xa7, 0x50,
	0xb7, 0x50, 0x00, 0x00, 0x7c, 0x5f,
	0x6b, 0xa5, 0x00, 0x04, 0xe5, 0x35,
	0x10, 0xa9, 0xbb, 0xcb, 0x84, 0x04,
	0x00, 0x00, 0x0f, 0x0f, 0x00, 0x00,
	/* ch = 'p' */
	0x26, 0x2a, 0x5b, 0x74, 0x1b, 0x00,
	0x7c, 0xe5, 0x25, 0x3f, 0xff, 0x1c,
	0x7c, 0x90, 0x00, 0x00, 0xa0, 0x5a,
	0x7c, 0x90, 0x00, 0x00, 0x7c, 0x5f,
	0x7c, 0xab, 0x00, 0x04, 0xcf, 0x3b,
	0x7c, 0xef, 0xbb, 0xd4, 0x84, 0x04,
	0x7c, 0x90, 0x0c, 0x12, 0x00, 0x00,
	0x7c, 0x90, 0x00, 0x00, 0x00, 0x00,
	/* ch = 'q' */
	0x00, 0x28, 0x74, 0x50, 0x30, 0x16,
	0x35, 0xdb, 0x20, 0x43, 0xff, 0x3b,
	0xa0, 0x50, 0x00, 0x00, 0xff, 0x3b,
	0xb7, 0x47, 0x00, 0x00, 0xff, 0x3b,
	0x6b, 0xa5, 0x00, 0x17, 0xff, 0x3b,
	0x10, 0xd4, 0xcb, 0xdd, 0xe5, 0x3b,
	0x00, 0x00, 0x12, 0x00, 0xb7, 0x3b,
	0x00, 0x00, 0x00, 0x00, 0xb7, 0x3b,
	/* ch = 'r' */
	0x0d, 0x36, 0x26, 0x74, 0x5b, 0x10,
	0x1c, 0xff, 0xc4, 0x25, 0x50, 0x2c,
	0x1c, 0xff, 0x2e, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x10, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x0d, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x0d, 0x00, 0x00, 0x00,
	/* ch = 's' */
	0x00, 0x22, 0x74, 0x74, 0x22, 0x00,
	0x22, 0xff, 0x1e, 0x1e, 0xc4, 0x13,
	0x17, 0xf7, 0x6a, 0x18, 0x00, 0x00,
	0x00, 0x0c, 0x50, 0xcb, 0xc0, 0x04,
	0x1f, 0x24, 0x00, 0x04, 0xff, 0x2f,
	0x2f, 0xef, 0x9e, 0xbb, 0x94, 0x10,
	0x00, 0x00, 0x0f, 0x0c, 0x00, 0x00,
	/* ch = 't' */
	0x00, 0x00, 0x04, 0x08, 0x00,
	0x00, 0x1a, 0xff, 0x1c, 0x00,
	0x1e, 0x4a, 0xff, 0x40, 0x2d,
	0x0c, 0x2a, 0xff, 0x1a, 0x15,
	0x00, 0x32, 0xcf, 0x04, 0x00,
	0x00, 0x32, 0xcf, 0x00, 0x00,
	0x00, 0x32, 0xff, 0x00, 0x08,
	0x00, 0x0d, 0xd4, 0xdd, 0xdd,
	0x00, 0x00, 0x00, 0x0f, 0x00,
	/* ch = 'u' */
	0x1e, 0x26, 0x00, 0x00, 0x36, 0x0d,
	0x50, 0x90, 0x00, 0x00, 0xff, 0x24,
	0x6b, 0x90, 0x00, 0x00, 0xff, 0x24,
	0x7c, 0x90, 0x00, 0x00, 0xff, 0x24,
	0x4d, 0xa5, 0x00, 0x22, 0xff, 0x24,
	0x10, 0xd4, 0xa4, 0xc4, 0xff, 0x26,
	0x00, 0x00, 0x15, 0x04, 0x00, 0x00,
	/* ch = 'v' */
	0x2b, 0x1e, 0x00, 0x00, 0x26, 0x1c,
	0x48, 0xbd, 0x00, 0x00, 0xcf, 0x29,
	0x0d, 0xff, 0x1f, 0x2c, 0xb7, 0x04,
	0x00, 0x8a, 0x6a, 0x8a, 0x43, 0x00,
	0x00, 0x2c, 0xff, 0xe5, 0x10, 0x00,
	0x00, 0x00, 0xc8, 0x6a, 0x00, 0x00,
	/* ch = 'w' */
	0x36, 0x00, 0x00, 0x00, 0x16, 0x39,
	0xe5, 0x22, 0x7c, 0x50, 0x3b, 0x8a,
	0x90, 0x3f, 0xcf, 0xa5, 0x50, 0x5f,
	0x5f, 0xa5, 0xb7, 0xf7, 0xa5, 0x39,
	0x35, 0xff, 0x5f, 0x90, 0xff, 0x22,
	0x1a, 0xff, 0x2c, 0x44, 0xe5, 0x0d,
	/* ch = 'x' */
	0x24, 0x28, 0x00, 0x0d, 0x36, 0x09,
	0x10, 0xe5, 0x2c, 0x7c, 0x6f, 0x00,
	0x00, 0x32, 0xf7, 0xc8, 0x10, 0x00,
	0x00, 0x10, 0xec, 0x97, 0x00, 0x00,
	0x00, 0x90, 0x64, 0xc8, 0x47, 0x00,
	0x48, 0xb7, 0x10, 0x1f, 0xff, 0x24,
	/* ch = 'y' */
	0x39, 0x26, 0x00, 0x00, 0x28, 0x1e,
	0x39, 0xe0, 0x00, 0x00, 0xe5, 0x29,
	0x04, 0xe5, 0x29, 0x2c, 0xc8, 0x0d,
	0x00, 0x5a, 0x82, 0x70, 0x54, 0x00,
	0x00, 0x17, 0xff, 0xf7, 0x1f, 0x00,
	0x00, 0x00, 0xa0, 0x9e, 0x00, 0x00,
	0x0c, 0x00, 0xa7, 0x43, 0x00, 0x00,
	0xd4, 0xc4, 0xa9, 0x10, 0x00, 0x00,
	/* ch = 'z' */
	0x1e, 0x36, 0x36, 0x36, 0x36, 0x0d,
	0x0c, 0x15, 0x15, 0x67, 0xb1, 0x10,
	0x00, 0x00, 0x32, 0xdb, 0x19, 0x00,
	0x00, 0x1f, 0xef, 0x26, 0x00, 0x00,
	0x10, 0xdb, 0x3b, 0x00, 0x00, 0x00,
	0x77, 0xff, 0xcf, 0xcf, 0xcf, 0x32,
	/* ch = '{' */
	0x00, 0x28, 0x74, 0x58,
	0x22, 0xe5, 0x1b, 0x00,
	0x32, 0xcf, 0x00, 0x00,
	0x35, 0xc8, 0x00, 0x00,
	0xa9, 0x3b, 0x00, 0x00,
	0x90, 0x5a, 0x00, 0x00,
	0x35, 0xc8, 0x00, 0x00,
	0x3b, 0xcf, 0x00, 0x00,
	0x2f, 0xea, 0x04, 0x00,
	0x04, 0x8d, 0xcf, 0xa4,
	/* ch = '|' */
	0x67, 0x32,
	0x7c, 0x3b,
	0x7c, 0x3b,
	0x7c, 0x3b,
	0x7c, 0x3b,
	0x7c, 0x3b,
	0x7c, 0x3b,
	0x7c, 0x3b,
	0x7c, 0x3b,
	0x67, 0x36,
	/* ch = '}' */
	0x14, 0x74, 0x67, 0x13,
	0x00, 0x00, 0x37, 0xe0,
	0x00, 0x00, 0x1c, 0xff,
	0x00, 0x00, 0x1a, 0xff,
	0x00, 0x00, 0x00, 0x77,
	0x00, 0x00, 0x00, 0xb1,
	0x00, 0x00, 0x1a, 0xff,
	0x00, 0x00, 0x1c, 0xff,
	0x00, 0x00, 0x26, 0xf7,
	0x1a, 0xcf, 0xc6, 0x50,
	/* ch = '~' */
	0x08, 0x5b, 0x50, 0x08, 0x19, 0x19,
	0x64, 0x47, 0x5a, 0xef, 0xe5, 0x35,
	0x00, 0x00, 0x00, 0x08, 0x08, 0x00
};

/* font_inconsolata_13px */
static const unsigned char font_bitmap_13px_bytes[] = {
	/* ch = '!' */
	0x45, 0x3d,
	0xb7, 0xbd,
	0xa0, 0x88,
	0x7c, 0x82,
	0x7c, 0x64,
	0x6b, 0x54,
	0x1e, 0x21,
	0x22, 0x21,
	0xe5, 0xb7,
	0x0c, 0x0c,
	/* ch = '"' */
	0x2a, 0x4e, 0x1c, 0x74, 0x04,
	0x50, 0xbd, 0x2f, 0xff, 0x17,
	0x5f, 0x64, 0x35, 0xb7, 0x04,
	0x58, 0x1f, 0x36, 0x36, 0x00,
	/* ch = '#' */
	0x00, 0x00, 0x15, 0x00, 0x04, 0x08, 0x00,
	0x00, 0x1c, 0xf7, 0x04, 0xf7, 0x1f, 0x00,
	0x00, 0x2a, 0xbd, 0x0d, 0xff, 0x10, 0x00,
	0x77, 0xe5, 0xef, 0x95, 0xf7, 0x74, 0x17,
	0x00, 0x50, 0x70, 0x32, 0xbd, 0x00, 0x00,
	0x00, 0x77, 0x5e, 0x4f, 0x95, 0x15, 0x00,
	0x74, 0xe5, 0x9c, 0x87, 0x82, 0x30, 0x04,
	0x00, 0xb7, 0x26, 0x7c, 0x50, 0x00, 0x00,
	0x00, 0xcf, 0x1c, 0x8f, 0x2f, 0x00, 0x00,
	/* ch = '$' */
	0x00, 0x00, 0x16, 0x2d, 0x00, 0x00,
	0x00, 0x1b, 0x9c, 0xec, 0x50, 0x08,
	0x17, 0xf7, 0x59, 0xbd, 0x5f, 0x66,
	0x2a, 0xec, 0x3f, 0xbd, 0x00, 0x00,
	0x00, 0x66, 0xff, 0xd9, 0x16, 0x00,
	0x00, 0x00, 0x35, 0xe5, 0xdb, 0x50,
	0x00, 0x00, 0x32, 0xbd, 0x24, 0xff,
	0x32, 0x90, 0x37, 0xc6, 0x64, 0xa0,
	0x04, 0x48, 0xdd, 0xf7, 0x73, 0x13,
	0x00, 0x00, 0x22, 0x5c, 0x00, 0x00,
	/* ch = '%' */
	0x04, 0x15, 0x08, 0x00, 0x08, 0x15, 0x00,
	0x77, 0x94, 0xe5, 0x0d, 0x6b, 0x70, 0x00,
	0xf7, 0x1f, 0xbd, 0x44, 0xef, 0x13, 0x00,
	0x66, 0xc4, 0xd4, 0x88, 0x54, 0x00, 0x00,
	0x00, 0x12, 0x28, 0xdb, 0x08, 0x00, 0x00,
	0x00, 0x00, 0xa0, 0x43, 0x15, 0x08, 0x00,
	0x00, 0x32, 0xb7, 0x7c, 0x85, 0xe5, 0x0d,
	0x04, 0xc8, 0x2c, 0xf7, 0x1f, 0xb7, 0x2a,
	0x44, 0x90, 0x04, 0x66, 0xc4, 0xd4, 0x08,
	0x00, 0x00, 0x00, 0x00, 0x12, 0x08, 0x00,
	/* ch = '&' */
	0x00, 0x00, 0x12, 0x0c, 0x00, 0x00, 0x00,
	0x00, 0xa9, 0xab, 0xef, 0x32, 0x00, 0x00,
	0x1c, 0xff, 0x1f, 0x54, 0x82, 0x00, 0x00,
	0x00, 0xc8, 0x43, 0xb1, 0x48, 0x00, 0x00,
	0x00, 0x43, 0xff, 0x75, 0x04, 0x00, 0x00,
	0x2f, 0xf7, 0x77, 0xbd, 0x04, 0x5b, 0x04,
	0xa0, 0x64, 0x00, 0xb1, 0xdb, 0xc8, 0x08,
	0xb1, 0x68, 0x00, 0x2b, 0xff, 0x46, 0x00,
	0x32, 0xf7, 0xd4, 0xd4, 0x54, 0xf7, 0x0a,
	0x00, 0x04, 0x15, 0x00, 0x00, 0x0f, 0x00,
	/* ch = ''' */
	0x1c, 0x74, 0x04,
	0x2f, 0xff, 0x17,
	0x35, 0xa7, 0x04,
	0x36, 0x36, 0x00,
	/* ch = '(' */
	0x00, 0x04, 0x48, 0x1c,
	0x10, 0xb1, 0x84, 0x0f,
	0x77, 0x82, 0x04, 0x00,
	0xff, 0x1a, 0x00, 0x00,
	0xbd, 0x04, 0x00, 0x00,
	0x82, 0x00, 0x00, 0x00,
	0xb7, 0x00, 0x00, 0x00,
	0xff, 0x0d, 0x00, 0x00,
	0xc8, 0x54, 0x00, 0x00,
	0x2a, 0xff, 0x21, 0x00,
	0x00, 0x2c, 0xf7, 0x33,
	0x00, 0x00, 0x0c, 0x08,
	/* ch = ')' */
	0x14, 0x48, 0x04, 0x00,
	0x10, 0x99, 0xb7, 0x10,
	0x00, 0x00, 0x7c, 0xa7,
	0x00, 0x00, 0x10, 0xf7,
	0x00, 0x00, 0x00, 0x82,
	0x00, 0x00, 0x00, 0x50,
	0x00, 0x00, 0x00, 0x5f,
	0x00, 0x00, 0x00, 0xb7,
	0x00, 0x00, 0x2f, 0xf7,
	0x00, 0x19, 0xdb, 0x35,
	0x27, 0xef, 0x3f, 0x00,
	0x04, 0x0f, 0x00, 0x00,
	/* ch = '*' */
	0x00, 0x00, 0x45, 0x82, 0x00, 0x00,
	0x21, 0x13, 0x50, 0x82, 0x08, 0x21,
	0x40, 0xc4, 0xd4, 0xd1, 0xd4, 0x5b,
	0x00, 0x04, 0xb1, 0xdb, 0x10, 0x00,
	0x04, 0xb1, 0x59, 0x3b, 0xb7, 0x04,
	0x04, 0x50, 0x08, 0x00, 0x48, 0x0c,
	/* ch = '+' */
	0x00, 0x00, 0x45, 0x67, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x50, 0x82, 0x00, 0x00, 0x00,
	0x42, 0x74, 0xb1, 0xd1, 0x74, 0x74, 0x00,
	0x0f, 0x15, 0x5e, 0x88, 0x15, 0x15, 0x04,
	0x00, 0x00, 0x50, 0x82, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x30, 0x45, 0x00, 0x00, 0x00,
	/* ch = ',' */
	0x00, 0x22, 0x16,
	0x00, 0xef, 0xec,
	0x00, 0x37, 0xa7,
	0x09, 0xd4, 0x21,
	0x00, 0x0f, 0x00,
	/* ch = '-' */
	0x22, 0x74, 0x74, 0x74, 0x74, 0x42,
	0x16, 0x36, 0x36, 0x36, 0x36, 0x28,
	/* ch = '.' */
	0x22, 0x1b,
	0xf7, 0xb7,
	0x0c, 0x0c,
	/* ch = '/' */
	0x00, 0x39, 0x26,
	0x04, 0xe5, 0x35,
	0x44, 0xc8, 0x04,
	0xc8, 0x3f, 0x00,
	0xe5, 0x08, 0x00,
	0x4c, 0x00, 0x00,
	0x10, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	/* ch = '0' */
	0x00, 0x00, 0x0c, 0x0f, 0x00, 0x00,
	0x00, 0x44, 0xef, 0xcb, 0x7c, 0x00,
	0x17, 0xf7, 0x13, 0x04, 0xec, 0x35,
	0x50, 0x88, 0x00, 0x44, 0xff, 0x7c,
	0x7c, 0x54, 0x1f, 0xef, 0x54, 0xbd,
	0x7c, 0x6d, 0xdb, 0x35, 0x32, 0xbd,
	0x50, 0xff, 0x54, 0x00, 0x4d, 0x88,
	0x1c, 0xff, 0x21, 0x04, 0xb7, 0x3b,
	0x00, 0x44, 0xf7, 0xdd, 0x77, 0x04,
	0x00, 0x00, 0x08, 0x12, 0x00, 0x00,
	/* ch = '1' */
	0x00, 0x00, 0x04, 0x12,
	0x00, 0x31, 0xd4, 0xbd,
	0x04, 0x50, 0x3e, 0xbd,
	0x00, 0x00, 0x32, 0xbd,
	0x00, 0x00, 0x32, 0xbd,
	0x00, 0x00, 0x32, 0xbd,
	0x00, 0x00, 0x32, 0xbd,
	0x00, 0x00, 0x32, 0xbd,
	0x00, 0x00, 0x32, 0xbd,
	/* ch = '2' */
	0x00, 0x00, 0x0c, 0x12, 0x00, 0x00,
	0x04, 0x94, 0xcb, 0xcb, 0xc4, 0x10,
	0x10, 0x48, 0x04, 0x00, 0xb7, 0x5f,
	0x00, 0x00, 0x00, 0x00, 0x82, 0x70,
	0x00, 0x00, 0x00, 0x1f, 0xf7, 0x1f,
	0x00, 0x00, 0x1f, 0xdb, 0x37, 0x00,
	0x00, 0x1f, 0xdb, 0x35, 0x00, 0x00,
	0x00, 0xb1, 0x54, 0x00, 0x00, 0x00,
	0x2f, 0xff, 0xd4, 0xcf, 0xcf, 0x7c,
	/* ch = '3' */
	0x00, 0x00, 0x0c, 0x08, 0x00, 0x00,
	0x09, 0xa9, 0xd4, 0xe5, 0x7c, 0x00,
	0x00, 0x22, 0x00, 0x04, 0xe5, 0x2c,
	0x00, 0x00, 0x00, 0x10, 0xe5, 0x2a,
	0x00, 0x00, 0x74, 0xe5, 0x53, 0x00,
	0x00, 0x00, 0x15, 0x37, 0xf7, 0x17,
	0x00, 0x00, 0x00, 0x00, 0x82, 0x54,
	0x04, 0x3d, 0x00, 0x08, 0xc8, 0x3b,
	0x22, 0xd4, 0xdd, 0xe5, 0x94, 0x08,
	0x00, 0x00, 0x0f, 0x0f, 0x00, 0x00,
	/* ch = '4' */
	0x00, 0x00, 0x00, 0x08, 0x12, 0x00,
	0x00, 0x00, 0x00, 0x7c, 0xbd, 0x00,
	0x00, 0x00, 0x32, 0xff, 0xbd, 0x00,
	0x00, 0x10, 0xd4, 0x82, 0xbd, 0x00,
	0x00, 0x7c, 0x50, 0x50, 0xbd, 0x00,
	0x32, 0xb1, 0x08, 0x50, 0xbd, 0x00,
	0x67, 0xcf, 0xcf, 0xe5, 0xf7, 0x9c,
	0x00, 0x00, 0x00, 0x50, 0xbd, 0x00,
	0x00, 0x00, 0x00, 0x50, 0xbd, 0x00,
	/* ch = '5' */
	0x00, 0x15, 0x15, 0x15, 0x15, 0x0c,
	0x00, 0xff, 0xd4, 0xcf, 0xcf, 0x49,
	0x04, 0xff, 0x1c, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x15, 0x15, 0x04, 0x00,
	0x1c, 0xff, 0x8f, 0x8f, 0xe5, 0x1c,
	0x00, 0x15, 0x00, 0x00, 0x70, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x50, 0xbd,
	0x13, 0x73, 0x00, 0x00, 0x90, 0x70,
	0x10, 0xbb, 0xe5, 0xbb, 0xbb, 0x13,
	0x00, 0x00, 0x0c, 0x15, 0x00, 0x00,
	/* ch = '6' */
	0x00, 0x00, 0x04, 0x15, 0x08, 0x00,
	0x00, 0x2c, 0xe5, 0x8f, 0xef, 0x2b,
	0x04, 0xe5, 0x37, 0x00, 0x0c, 0x04,
	0x2a, 0xe5, 0x0f, 0x15, 0x04, 0x00,
	0x3b, 0xff, 0xd4, 0x95, 0xdb, 0x10,
	0x50, 0xe5, 0x0c, 0x00, 0x8a, 0x64,
	0x35, 0xc6, 0x00, 0x00, 0x50, 0x82,
	0x17, 0xff, 0x26, 0x00, 0x90, 0x5f,
	0x00, 0x44, 0xef, 0xd4, 0xa9, 0x10,
	0x00, 0x00, 0x04, 0x12, 0x00, 0x00,
	/* ch = '7' */
	0x08, 0x15, 0x15, 0x15, 0x15, 0x0f,
	0x2d, 0xcf, 0xcf, 0xcf, 0xf7, 0x5f,
	0x00, 0x00, 0x00, 0x17, 0xff, 0x1a,
	0x00, 0x00, 0x00, 0x5a, 0x90, 0x00,
	0x00, 0x00, 0x04, 0xe5, 0x3b, 0x00,
	0x00, 0x00, 0x32, 0xe5, 0x08, 0x00,
	0x00, 0x00, 0x8a, 0x75, 0x00, 0x00,
	0x00, 0x0d, 0xff, 0x2c, 0x00, 0x00,
	0x00, 0x3b, 0xe5, 0x04, 0x00, 0x00,
	/* ch = '8' */
	0x00, 0x00, 0x0f, 0x15, 0x00, 0x00,
	0x00, 0x77, 0xbb, 0xa4, 0xdb, 0x10,
	0x1a, 0xff, 0x1a, 0x00, 0xbd, 0x48,
	0x0d, 0xf7, 0x37, 0x10, 0xe5, 0x2a,
	0x00, 0x2b, 0xff, 0xef, 0x53, 0x00,
	0x10, 0xd4, 0x3f, 0x3f, 0xff, 0x1f,
	0x4d, 0xa7, 0x04, 0x00, 0x70, 0x7c,
	0x44, 0xcf, 0x04, 0x00, 0x90, 0x70,
	0x04, 0x94, 0xef, 0xdd, 0xbb, 0x13,
	0x00, 0x00, 0x0c, 0x12, 0x00, 0x00,
	/* ch = '9' */
	0x00, 0x00, 0x0f, 0x0f, 0x00, 0x00,
	0x00, 0x77, 0xd4, 0xcb, 0x99, 0x00,
	0x2a, 0xe5, 0x10, 0x04, 0xc8, 0x3b,
	0x49, 0xbd, 0x00, 0x00, 0x7c, 0x70,
	0x2a, 0xff, 0x10, 0x04, 0xb7, 0x82,
	0x00, 0x66, 0xf7, 0xdd, 0xdb, 0x82,
	0x00, 0x00, 0x00, 0x00, 0x82, 0x59,
	0x00, 0x21, 0x00, 0x10, 0xf7, 0x24,
	0x17, 0xe5, 0xd4, 0xe5, 0x48, 0x00,
	0x00, 0x00, 0x12, 0x04, 0x00, 0x00,
	/* ch = ':' */
	0x28, 0x28,
	0xdb, 0xa0,
	0x00, 0x00,
	0x00, 0x00,
	0x22, 0x1b,
	0xf7, 0xb7,
	0x0c, 0x0c,
	/* ch = ';' */
	0x00, 0x28, 0x28,
	0x00, 0xdb, 0xa0,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x22, 0x16,
	0x00, 0xef, 0xec,
	0x00, 0x37, 0xa7,
	0x09, 0xd4, 0x21,
	0x00, 0x0f, 0x00,
	/* ch = '<' */
	0x00, 0x00, 0x00, 0x00, 0x22,
	0x00, 0x00, 0x1e, 0xbb, 0xbb,
	0x1b, 0xa4, 0xbb, 0x2b, 0x00,
	0xc4, 0x2b, 0x00, 0x00, 0x00,
	0xef, 0x66, 0x08, 0x00, 0x00,
	0x08, 0x50, 0xef, 0x37, 0x04,
	0x00, 0x00, 0x13, 0x94, 0xdb,
	0x00, 0x00, 0x00, 0x00, 0x22,
	/* ch = '=' */
	0x42, 0x74, 0x74, 0x74, 0x74, 0x74, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x67, 0xcf, 0xcf, 0xcf, 0xcf, 0xcf, 0x04,
	/* ch = '>' */
	0x00, 0x00, 0x00, 0x00, 0x00,
	0x31, 0x00, 0x00, 0x00, 0x00,
	0xa4, 0xc4, 0x28, 0x00, 0x00,
	0x00, 0x1b, 0xab, 0xc4, 0x00,
	0x04, 0x48, 0xe5, 0x50, 0x04,
	0xd4, 0x73, 0x16, 0x00, 0x00,
	0x1e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00,
	/* ch = '?' */
	0x00, 0x1b, 0x67, 0x74, 0x2e, 0x00,
	0x2d, 0xf7, 0x37, 0x37, 0xf7, 0x35,
	0x00, 0x22, 0x00, 0x00, 0x88, 0x7c,
	0x00, 0x00, 0x00, 0x10, 0xe5, 0x48,
	0x00, 0x00, 0x04, 0xb1, 0x6b, 0x04,
	0x00, 0x00, 0x2f, 0xcf, 0x04, 0x00,
	0x00, 0x00, 0x22, 0x5c, 0x00, 0x00,
	0x00, 0x00, 0x0c, 0x25, 0x00, 0x00,
	0x00, 0x00, 0x77, 0xff, 0x1a, 0x00,
	0x00, 0x00, 0x08, 0x12, 0x00, 0x00,
	/* ch = '@' */
	0x00, 0x00, 0x0c, 0x15, 0x08, 0x00, 0x00,
	0x00, 0x66, 0xbb, 0x67, 0xe5, 0x24, 0x00,
	0x39, 0xa0, 0x08, 0x00, 0x2c, 0xcf, 0x00,
	0xa0, 0x35, 0x19, 0x8f, 0xbd, 0xff, 0x04,
	0xbd, 0x1f, 0xdb, 0x3a, 0x0d, 0xff, 0x04,
	0xb7, 0x21, 0xf7, 0x28, 0x2f, 0xff, 0x04,
	0x90, 0x43, 0x35, 0xcf, 0xab, 0xcf, 0x04,
	0x2a, 0xe5, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0xe5, 0x82, 0xbb, 0x4f, 0x00,
	0x00, 0x00, 0x00, 0x15, 0x0c, 0x00, 0x00,
	/* ch = 'A' */
	0x00, 0x00, 0x08, 0x04, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x5a, 0x4c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xc8, 0xaf, 0x00, 0x00, 0x00,
	0x00, 0x24, 0xc8, 0xf7, 0x24, 0x00, 0x00,
	0x00, 0x5f, 0x5f, 0x70, 0x64, 0x00, 0x00,
	0x00, 0xe5, 0x24, 0x2a, 0xec, 0x04, 0x00,
	0x2a, 0xe5, 0x74, 0x74, 0xe5, 0x35, 0x00,
	0x70, 0x70, 0x00, 0x00, 0x5a, 0x90, 0x00,
	0xe5, 0x2c, 0x00, 0x00, 0x22, 0xff, 0x1a,
	/* ch = 'B' */
	0x0f, 0x15, 0x15, 0x00, 0x00, 0x00,
	0x7c, 0xb1, 0x74, 0xdd, 0xc4, 0x10,
	0x7c, 0x54, 0x00, 0x00, 0x97, 0x64,
	0x7c, 0x54, 0x00, 0x04, 0xa7, 0x4c,
	0x7c, 0xef, 0xcf, 0xe5, 0x9e, 0x08,
	0x7c, 0x54, 0x00, 0x16, 0xb1, 0x50,
	0x7c, 0x54, 0x00, 0x00, 0x35, 0xcf,
	0x7c, 0x54, 0x00, 0x00, 0x7c, 0xa7,
	0x7c, 0xef, 0xcf, 0xe5, 0xb3, 0x1b,
	/* ch = 'C' */
	0x00, 0x00, 0x08, 0x15, 0x00, 0x00, 0x00,
	0x00, 0x4d, 0xe5, 0x82, 0xef, 0x3b, 0x00,
	0x2a, 0xe5, 0x13, 0x00, 0x24, 0x9e, 0x0a,
	0x6b, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xb1, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xb1, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x6b, 0x75, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x2a, 0xff, 0x1f, 0x00, 0x1f, 0x48, 0x00,
	0x00, 0x44, 0xf7, 0xab, 0xe5, 0x2f, 0x00,
	0x00, 0x00, 0x04, 0x15, 0x00, 0x00, 0x00,
	/* ch = 'D' */
	0x0f, 0x15, 0x0f, 0x00, 0x00, 0x00, 0x00,
	0x7c, 0xb1, 0x9e, 0xef, 0x6b, 0x04, 0x00,
	0x7c, 0x54, 0x00, 0x10, 0xdb, 0x48, 0x00,
	0x7c, 0x54, 0x00, 0x00, 0x50, 0xb7, 0x00,
	0x7c, 0x54, 0x00, 0x00, 0x32, 0xff, 0x00,
	0x7c, 0x54, 0x00, 0x00, 0x32, 0xf7, 0x04,
	0x7c, 0x54, 0x00, 0x00, 0x50, 0xa7, 0x00,
	0x7c, 0x54, 0x00, 0x10, 0xdb, 0x3b, 0x00,
	0x7c, 0xef, 0xcf, 0xe5, 0x48, 0x04, 0x00,
	/* ch = 'E' */
	0x0c, 0x15, 0x15, 0x15, 0x15, 0x0f,
	0x50, 0xc8, 0x74, 0x74, 0x74, 0x45,
	0x50, 0x82, 0x00, 0x00, 0x00, 0x00,
	0x50, 0x82, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xd1, 0x74, 0x74, 0x74, 0x00,
	0x50, 0x88, 0x15, 0x15, 0x15, 0x04,
	0x50, 0x82, 0x00, 0x00, 0x00, 0x00,
	0x50, 0x82, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xf7, 0xcf, 0xcf, 0xcf, 0x67,
	/* ch = 'F' */
	0x08, 0x15, 0x15, 0x15, 0x15, 0x0f,
	0x32, 0xff, 0x74, 0x74, 0x74, 0x45,
	0x32, 0xff, 0x04, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x04, 0x00, 0x00, 0x00,
	0x32, 0xff, 0xd4, 0xcf, 0xcf, 0x00,
	0x32, 0xff, 0x04, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x04, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x04, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x04, 0x00, 0x00, 0x00,
	/* ch = 'G' */
	0x00, 0x00, 0x08, 0x15, 0x04, 0x00, 0x00,
	0x00, 0x5a, 0xef, 0x82, 0xf7, 0x39, 0x00,
	0x32, 0xdb, 0x13, 0x00, 0x24, 0x73, 0x04,
	0x82, 0x59, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xb7, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xb7, 0x3f, 0x00, 0x67, 0xcf, 0xcf, 0x00,
	0x82, 0x64, 0x00, 0x00, 0x1c, 0xff, 0x04,
	0x32, 0xec, 0x13, 0x00, 0x1f, 0xff, 0x04,
	0x00, 0x50, 0xf7, 0xab, 0xe5, 0x73, 0x04,
	0x00, 0x00, 0x00, 0x15, 0x00, 0x00, 0x00,
	/* ch = 'H' */
	0x0f, 0x0f, 0x00, 0x00, 0x0c, 0x12,
	0x7c, 0x82, 0x00, 0x00, 0x50, 0x88,
	0x7c, 0x82, 0x00, 0x00, 0x50, 0x82,
	0x7c, 0x82, 0x00, 0x00, 0x50, 0x82,
	0x7c, 0xd1, 0x74, 0x74, 0xb1, 0x82,
	0x7c, 0x88, 0x15, 0x15, 0x5e, 0x82,
	0x7c, 0x82, 0x00, 0x00, 0x50, 0x82,
	0x7c, 0x82, 0x00, 0x00, 0x50, 0x82,
	0x7c, 0x82, 0x00, 0x00, 0x50, 0x82,
	/* ch = 'I' */
	0x04, 0x15, 0x15, 0x15, 0x15, 0x04,
	0x14, 0x74, 0xc8, 0xb1, 0x74, 0x17,
	0x00, 0x00, 0x7c, 0x54, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0x54, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0x54, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0x54, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0x54, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0x54, 0x00, 0x00,
	0x2d, 0xcf, 0xef, 0xef, 0xcf, 0x1a,
	/* ch = 'J' */
	0x04, 0x15, 0x15, 0x15, 0x15, 0x00,
	0x14, 0x74, 0xb1, 0xc8, 0x74, 0x04,
	0x00, 0x00, 0x50, 0x82, 0x00, 0x00,
	0x00, 0x00, 0x50, 0x82, 0x00, 0x00,
	0x00, 0x00, 0x50, 0x82, 0x00, 0x00,
	0x00, 0x00, 0x50, 0x82, 0x00, 0x00,
	0x00, 0x00, 0x50, 0x82, 0x00, 0x00,
	0x19, 0x00, 0x8a, 0x64, 0x00, 0x00,
	0xf7, 0xc4, 0xd4, 0x13, 0x00, 0x00,
	0x04, 0x15, 0x00, 0x00, 0x00, 0x00,
	/* ch = 'K' */
	0x12, 0x0f, 0x00, 0x00, 0x0c, 0x12, 0x00,
	0xb7, 0x54, 0x00, 0x10, 0xdb, 0x35, 0x00,
	0xb7, 0x54, 0x10, 0xb1, 0x54, 0x00, 0x00,
	0xb7, 0x59, 0xb1, 0x7c, 0x04, 0x00, 0x00,
	0xb7, 0xff, 0xff, 0x0c, 0x00, 0x00, 0x00,
	0xb7, 0x82, 0xb1, 0x7c, 0x00, 0x00, 0x00,
	0xb7, 0x54, 0x1c, 0xf7, 0x35, 0x00, 0x00,
	0xb7, 0x54, 0x00, 0x44, 0xec, 0x10, 0x00,
	0xb7, 0x54, 0x00, 0x00, 0x90, 0xa7, 0x04,
	/* ch = 'L' */
	0x0c, 0x15, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xbd, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xbd, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xbd, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xbd, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xbd, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xbd, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xbd, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xff, 0xcf, 0xcf, 0xcf, 0x67,
	/* ch = 'M' */
	0x12, 0x04, 0x00, 0x00, 0x00, 0x15, 0x00,
	0xb7, 0x64, 0x00, 0x00, 0x32, 0xff, 0x04,
	0xb7, 0xff, 0x10, 0x00, 0xc8, 0xff, 0x04,
	0xb7, 0xe5, 0x64, 0x3b, 0xdb, 0xff, 0x04,
	0xb7, 0x54, 0xff, 0xc8, 0x48, 0xff, 0x04,
	0xb7, 0x35, 0x70, 0x90, 0x1f, 0xff, 0x04,
	0xb7, 0x35, 0x08, 0x0c, 0x1c, 0xff, 0x04,
	0xb7, 0x35, 0x00, 0x00, 0x1c, 0xff, 0x04,
	0xb7, 0x35, 0x00, 0x00, 0x1c, 0xff, 0x04,
	/* ch = 'N' */
	0x0f, 0x0c, 0x00, 0x00, 0x08, 0x12,
	0x7c, 0xcf, 0x04, 0x00, 0x32, 0xbd,
	0x7c, 0xff, 0x48, 0x00, 0x32, 0xbd,
	0x7c, 0xb7, 0xec, 0x0d, 0x32, 0xbd,
	0x7c, 0x54, 0xa0, 0x64, 0x32, 0xbd,
	0x7c, 0x54, 0x24, 0xff, 0x50, 0xbd,
	0x7c, 0x54, 0x00, 0x7c, 0xff, 0xbd,
	0x7c, 0x54, 0x00, 0x17, 0xf7, 0xbd,
	0x7c, 0x54, 0x00, 0x00, 0x50, 0xbd,
	/* ch = 'O' */
	0x00, 0x00, 0x0f, 0x15, 0x00, 0x00, 0x00,
	0x04, 0x84, 0xe5, 0xcb, 0xc4, 0x10, 0x00,
	0x48, 0xb7, 0x08, 0x00, 0x82, 0x90, 0x00,
	0xa0, 0x48, 0x00, 0x00, 0x2a, 0xff, 0x00,
	0xe5, 0x35, 0x00, 0x00, 0x1c, 0xff, 0x1c,
	0xcf, 0x35, 0x00, 0x00, 0x1c, 0xff, 0x1c,
	0xa0, 0x54, 0x00, 0x00, 0x2a, 0xf7, 0x04,
	0x44, 0xe5, 0x10, 0x04, 0x82, 0x70, 0x00,
	0x00, 0x66, 0xf7, 0xe5, 0xa9, 0x13, 0x00,
	0x00, 0x00, 0x08, 0x0f, 0x00, 0x00, 0x00,
	/* ch = 'P' */
	0x0c, 0x15, 0x15, 0x04, 0x00, 0x00, 0x00,
	0x50, 0xef, 0xcf, 0xd4, 0xef, 0x1f, 0x00,
	0x50, 0x82, 0x00, 0x00, 0x5f, 0xa7, 0x00,
	0x50, 0x82, 0x00, 0x00, 0x3b, 0xbd, 0x04,
	0x50, 0xab, 0x36, 0x3e, 0xdb, 0x50, 0x00,
	0x50, 0xa5, 0x36, 0x36, 0x25, 0x00, 0x00,
	0x50, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x50, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x50, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00,
	/* ch = 'Q' */
	0x00, 0x00, 0x0f, 0x15, 0x00, 0x00, 0x00,
	0x04, 0x84, 0xd4, 0xb3, 0xc4, 0x10, 0x00,
	0x48, 0xb7, 0x08, 0x00, 0x82, 0x90, 0x00,
	0xa0, 0x3f, 0x00, 0x00, 0x24, 0xff, 0x00,
	0xe5, 0x35, 0x00, 0x00, 0x1c, 0xff, 0x1c,
	0xe5, 0x35, 0x00, 0x00, 0x1a, 0xff, 0x1c,
	0xa0, 0x54, 0x00, 0x00, 0x24, 0xf7, 0x04,
	0x44, 0xe5, 0x10, 0x00, 0x82, 0x75, 0x00,
	0x00, 0x66, 0xf7, 0xdd, 0xa9, 0x13, 0x00,
	0x00, 0x00, 0x32, 0xbd, 0x04, 0x00, 0x00,
	0x00, 0x00, 0x04, 0x8d, 0xcf, 0x6c, 0x00,
	/* ch = 'R' */
	0x0f, 0x15, 0x15, 0x04, 0x00, 0x00,
	0x7c, 0xef, 0xcf, 0xdd, 0xdb, 0x1f,
	0x7c, 0x82, 0x00, 0x00, 0x82, 0x90,
	0x7c, 0x82, 0x00, 0x00, 0x54, 0xa7,
	0x7c, 0xab, 0x36, 0x47, 0xf7, 0x35,
	0x7c, 0xa5, 0x36, 0xf7, 0x39, 0x00,
	0x7c, 0x82, 0x00, 0x5f, 0x97, 0x00,
	0x7c, 0x82, 0x00, 0x10, 0xf7, 0x2c,
	0x7c, 0x82, 0x00, 0x00, 0x5f, 0xa7,
	/* ch = 'S' */
	0x00, 0x00, 0x0c, 0x12, 0x00, 0x00,
	0x00, 0x84, 0xbb, 0x8f, 0xef, 0x2c,
	0x2f, 0xe5, 0x08, 0x00, 0x2c, 0x21,
	0x2a, 0xff, 0x21, 0x00, 0x00, 0x00,
	0x00, 0x50, 0xf7, 0x7f, 0x1b, 0x00,
	0x00, 0x00, 0x08, 0x50, 0xf7, 0x44,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0xcf,
	0x2f, 0x3b, 0x00, 0x00, 0x54, 0xa7,
	0x26, 0xd4, 0xdd, 0xd4, 0xd4, 0x21,
	0x00, 0x00, 0x0c, 0x12, 0x00, 0x00,
	/* ch = 'T' */
	0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x00,
	0xcf, 0xcf, 0xef, 0xef, 0xcf, 0xcf, 0x04,
	0x00, 0x00, 0x7c, 0x82, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0x82, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0x82, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0x82, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0x82, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0x82, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0x82, 0x00, 0x00, 0x00,
	/* ch = 'U' */
	0x0f, 0x0f, 0x00, 0x00, 0x08, 0x12,
	0x7c, 0x59, 0x00, 0x00, 0x32, 0xbd,
	0x7c, 0x54, 0x00, 0x00, 0x32, 0xbd,
	0x7c, 0x54, 0x00, 0x00, 0x32, 0xbd,
	0x7c, 0x54, 0x00, 0x00, 0x32, 0xbd,
	0x7c, 0x54, 0x00, 0x00, 0x32, 0xbd,
	0x7c, 0x59, 0x00, 0x00, 0x32, 0xbd,
	0x50, 0xbd, 0x04, 0x00, 0x5f, 0x90,
	0x04, 0xa2, 0xd4, 0xa4, 0xd4, 0x19,
	0x00, 0x00, 0x0c, 0x12, 0x00, 0x00,
	/* ch = 'V' */
	0x15, 0x08, 0x00, 0x00, 0x00, 0x15, 0x04,
	0xa7, 0x4c, 0x00, 0x00, 0x22, 0xf7, 0x08,
	0x48, 0xaf, 0x00, 0x00, 0x5a, 0x82, 0x00,
	0x17, 0xff, 0x1a, 0x00, 0xb7, 0x35, 0x00,
	0x00, 0xa7, 0x4c, 0x1c, 0xf7, 0x10, 0x00,
	0x00, 0x48, 0xaf, 0x48, 0x90, 0x00, 0x00,
	0x00, 0x14, 0xff, 0xd1, 0x3b, 0x00, 0x00,
	0x00, 0x00, 0xa0, 0xf7, 0x10, 0x00, 0x00,
	0x00, 0x00, 0x44, 0x90, 0x00, 0x00, 0x00,
	/* ch = 'W' */
	0x15, 0x00, 0x00, 0x00, 0x00, 0x12, 0x08,
	0xff, 0x1f, 0x14, 0x32, 0x00, 0xb7, 0x26,
	0xbd, 0x35, 0x35, 0xa7, 0x00, 0xff, 0x17,
	0x82, 0x54, 0x6b, 0xff, 0x1f, 0xe5, 0x04,
	0x54, 0x7c, 0xcf, 0xdb, 0x64, 0xa7, 0x00,
	0x35, 0xf7, 0xb7, 0x64, 0xec, 0x7c, 0x00,
	0x1f, 0xff, 0x64, 0x2a, 0xff, 0x50, 0x00,
	0x0d, 0xff, 0x32, 0x0d, 0xff, 0x32, 0x00,
	0x00, 0xcf, 0x10, 0x00, 0xa0, 0x1f, 0x00,
	/* ch = 'X' */
	0x12, 0x0c, 0x00, 0x00, 0x08, 0x12,
	0x44, 0xcf, 0x04, 0x00, 0x90, 0x54,
	0x04, 0xc8, 0x48, 0x2a, 0xe5, 0x10,
	0x00, 0x32, 0xec, 0xb7, 0x54, 0x00,
	0x00, 0x00, 0xa7, 0xe5, 0x08, 0x00,
	0x00, 0x04, 0xdb, 0xff, 0x1f, 0x00,
	0x00, 0x48, 0xc8, 0x82, 0x97, 0x00,
	0x0d, 0xe5, 0x35, 0x17, 0xf7, 0x2c,
	0x5f, 0xa0, 0x04, 0x00, 0x5f, 0xa7,
	/* ch = 'Y' */
	0x15, 0x08, 0x00, 0x00, 0x04, 0x15, 0x04,
	0x7c, 0x90, 0x00, 0x00, 0x44, 0xc8, 0x04,
	0x17, 0xff, 0x26, 0x00, 0xc8, 0x3f, 0x00,
	0x00, 0x70, 0x97, 0x32, 0xdb, 0x08, 0x00,
	0x00, 0x17, 0xff, 0xe5, 0x4c, 0x00, 0x00,
	0x00, 0x00, 0x70, 0xe5, 0x10, 0x00, 0x00,
	0x00, 0x00, 0x50, 0xbd, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x50, 0xbd, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x50, 0xbd, 0x00, 0x00, 0x00,
	/* ch = 'Z' */
	0x0c, 0x15, 0x15, 0x15, 0x15, 0x12,
	0x45, 0xcf, 0xcf, 0xcf, 0xef, 0xa7,
	0x00, 0x00, 0x00, 0x10, 0xf7, 0x26,
	0x00, 0x00, 0x00, 0x82, 0x70, 0x00,
	0x00, 0x00, 0x2f, 0xe5, 0x13, 0x00,
	0x00, 0x04, 0xdb, 0x48, 0x00, 0x00,
	0x00, 0x54, 0xb1, 0x04, 0x00, 0x00,
	0x1c, 0xf7, 0x26, 0x00, 0x00, 0x00,
	0x77, 0xff, 0xcf, 0xcf, 0xcf, 0xcf,
	/* ch = '[' */
	0x67, 0xcf, 0xcf, 0xcf, 0x45,
	0x7c, 0x54, 0x00, 0x00, 0x00,
	0x7c, 0x54, 0x00, 0x00, 0x00,
	0x7c, 0x54, 0x00, 0x00, 0x00,
	0x7c, 0x54, 0x00, 0x00, 0x00,
	0x7c, 0x54, 0x00, 0x00, 0x00,
	0x7c, 0x54, 0x00, 0x00, 0x00,
	0x7c, 0x54, 0x00, 0x00, 0x00,
	0x7c, 0x54, 0x00, 0x00, 0x00,
	0x7c, 0xb9, 0x74, 0x74, 0x30,
	0x0f, 0x15, 0x15, 0x15, 0x0f,
	/* ch = '\' */
	0x19, 0x4e, 0x00,
	0x17, 0xff, 0x1a,
	0x00, 0x8a, 0x70,
	0x00, 0x22, 0xff,
	0x00, 0x00, 0xa0,
	0x00, 0x00, 0x2c,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	/* ch = ']' */
	0x1a, 0xcf, 0xcf, 0xcf, 0x95,
	0x00, 0x00, 0x00, 0x32, 0xbd,
	0x00, 0x00, 0x00, 0x32, 0xbd,
	0x00, 0x00, 0x00, 0x32, 0xbd,
	0x00, 0x00, 0x00, 0x32, 0xbd,
	0x00, 0x00, 0x00, 0x32, 0xbd,
	0x00, 0x00, 0x00, 0x32, 0xbd,
	0x00, 0x00, 0x00, 0x32, 0xbd,
	0x00, 0x00, 0x00, 0x32, 0xbd,
	0x22, 0x74, 0x74, 0x9c, 0xbd,
	0x08, 0x15, 0x15, 0x15, 0x15,
	/* ch = '^' */
	0x00, 0x00, 0x04, 0x0c, 0x00, 0x00,
	0x00, 0x00, 0x50, 0xaf, 0x00, 0x00,
	0x00, 0x17, 0xef, 0xdb, 0x35, 0x00,
	0x00, 0x82, 0x59, 0x3b, 0xcf, 0x00,
	0x09, 0x50, 0x08, 0x00, 0x50, 0x08,
	/* ch = '_' */
	/* ch = '`' */
	0x27, 0x51, 0x00,
	0x22, 0xec, 0x10,
	0x00, 0xa0, 0xb7,
	0x00, 0x10, 0x2a,
	/* ch = 'a' */
	0x09, 0x8d, 0xdd, 0xd4, 0xc4, 0x10,
	0x00, 0x22, 0x04, 0x00, 0x90, 0x70,
	0x00, 0x0f, 0x36, 0x36, 0xa0, 0x82,
	0x2f, 0xdb, 0x31, 0x15, 0x5e, 0x82,
	0x7c, 0x82, 0x00, 0x04, 0xb7, 0x82,
	0x2a, 0xf7, 0x82, 0xcb, 0xd4, 0x82,
	0x00, 0x04, 0x15, 0x08, 0x00, 0x00,
	/* ch = 'b' */
	0x30, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x50, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x50, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xbd, 0xd4, 0xdd, 0xd4, 0x10, 0x00,
	0x50, 0xe5, 0x0c, 0x04, 0x90, 0x90, 0x00,
	0x50, 0x88, 0x00, 0x00, 0x3b, 0xd9, 0x00,
	0x50, 0x88, 0x00, 0x00, 0x35, 0xcf, 0x04,
	0x50, 0xd9, 0x04, 0x00, 0x82, 0x75, 0x00,
	0x50, 0xc4, 0xe5, 0xdd, 0xd4, 0x13, 0x00,
	0x00, 0x00, 0x08, 0x15, 0x00, 0x00, 0x00,
	/* ch = 'c' */
	0x00, 0x35, 0xdd, 0xcf, 0xf7, 0x3b, 0x00,
	0x22, 0xf7, 0x21, 0x00, 0x24, 0x50, 0x04,
	0x54, 0x97, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x54, 0x97, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x2a, 0xff, 0x21, 0x00, 0x10, 0x1b, 0x00,
	0x00, 0x44, 0xf7, 0xcf, 0xe5, 0x48, 0x00,
	0x00, 0x00, 0x04, 0x15, 0x08, 0x00, 0x00,
	/* ch = 'd' */
	0x00, 0x00, 0x00, 0x00, 0x30, 0x4a,
	0x00, 0x00, 0x00, 0x00, 0x50, 0x82,
	0x00, 0x00, 0x00, 0x00, 0x50, 0x82,
	0x04, 0x94, 0xdd, 0xdd, 0xdb, 0x82,
	0x48, 0xa7, 0x04, 0x04, 0xb7, 0x82,
	0x7c, 0x54, 0x00, 0x00, 0x7c, 0x82,
	0x7c, 0x59, 0x00, 0x00, 0x7c, 0x82,
	0x48, 0xcf, 0x04, 0x04, 0xc8, 0x82,
	0x04, 0xa9, 0xef, 0xdd, 0xc4, 0x88,
	0x00, 0x00, 0x0f, 0x08, 0x00, 0x00,
	/* ch = 'e' */
	0x00, 0x66, 0xd4, 0xb3, 0xc4, 0x10,
	0x39, 0xc8, 0x08, 0x00, 0x82, 0x5f,
	0x77, 0xd1, 0x74, 0x74, 0xb1, 0xa7,
	0x7c, 0x6d, 0x15, 0x15, 0x15, 0x15,
	0x40, 0xcf, 0x04, 0x00, 0x0c, 0x08,
	0x04, 0x7e, 0xef, 0x82, 0xdd, 0x32,
	0x00, 0x00, 0x08, 0x15, 0x00, 0x00,
	/* ch = 'f' */
	0x00, 0x19, 0x74, 0xab, 0x48, 0x00,
	0x04, 0xdb, 0x3a, 0x0f, 0xb1, 0x13,
	0x1c, 0xff, 0x04, 0x00, 0x00, 0x00,
	0x87, 0xff, 0x7b, 0x74, 0x00, 0x00,
	0x28, 0xff, 0x15, 0x15, 0x04, 0x00,
	0x1c, 0xff, 0x04, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x04, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x04, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x04, 0x00, 0x00, 0x00,
	/* ch = 'g' */
	0x00, 0x00, 0x0f, 0x08, 0x00, 0x00, 0x00,
	0x04, 0xa9, 0xa4, 0xef, 0xcb, 0x8f, 0x17,
	0x4d, 0x97, 0x04, 0x22, 0xff, 0x04, 0x00,
	0x44, 0xbd, 0x04, 0x26, 0xf7, 0x04, 0x00,
	0x04, 0xd9, 0xe5, 0xdd, 0x2f, 0x00, 0x00,
	0x2a, 0xc6, 0x08, 0x00, 0x00, 0x00, 0x00,
	0x1b, 0xe0, 0xcf, 0xcf, 0xef, 0x4d, 0x00,
	0x99, 0x43, 0x00, 0x00, 0x32, 0xd1, 0x00,
	0x4d, 0xdb, 0x5b, 0x5b, 0xd4, 0x44, 0x00,
	0x00, 0x0c, 0x15, 0x15, 0x0c, 0x00, 0x00,
	/* ch = 'h' */
	0x30, 0x64, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xbd, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xbd, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xd9, 0xa9, 0xd4, 0xdb, 0x1c,
	0x50, 0xff, 0x24, 0x00, 0x97, 0x64,
	0x50, 0xbd, 0x00, 0x00, 0x7c, 0x82,
	0x50, 0xbd, 0x00, 0x00, 0x7c, 0x82,
	0x50, 0xbd, 0x00, 0x00, 0x7c, 0x82,
	0x50, 0xbd, 0x00, 0x00, 0x7c, 0x82,
	/* ch = 'i' */
	0x00, 0x26, 0x48, 0x00, 0x00,
	0x00, 0x49, 0x9c, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00,
	0xcf, 0xe5, 0xbd, 0x00, 0x00,
	0x00, 0x50, 0xbd, 0x00, 0x00,
	0x00, 0x50, 0xbd, 0x00, 0x00,
	0x00, 0x50, 0xbd, 0x00, 0x00,
	0x00, 0x50, 0xbd, 0x00, 0x00,
	0xcf, 0xe5, 0xff, 0xcf, 0x1a,
	/* ch = 'j' */
	0x00, 0x00, 0x00, 0x26, 0x48,
	0x00, 0x00, 0x00, 0x49, 0x9c,
	0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x67, 0xcf, 0xe5, 0xbd,
	0x00, 0x00, 0x00, 0x50, 0xbd,
	0x00, 0x00, 0x00, 0x50, 0xbd,
	0x00, 0x00, 0x00, 0x50, 0xbd,
	0x00, 0x00, 0x00, 0x50, 0xbd,
	0x00, 0x00, 0x00, 0x50, 0xbd,
	0x10, 0x16, 0x00, 0x64, 0x97,
	0x5c, 0xdb, 0x82, 0xef, 0x21,
	0x00, 0x12, 0x15, 0x0c, 0x00,
	/* ch = 'k' */
	0x30, 0x7b, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xbd, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xbd, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xbd, 0x00, 0x19, 0xdb, 0x3f, 0x00,
	0x50, 0xbd, 0x1f, 0xe5, 0x35, 0x00, 0x00,
	0x50, 0xec, 0xf7, 0x52, 0x00, 0x00, 0x00,
	0x50, 0xe5, 0x47, 0xff, 0x1f, 0x00, 0x00,
	0x50, 0xbd, 0x00, 0x50, 0xe5, 0x10, 0x00,
	0x50, 0xbd, 0x00, 0x00, 0xb1, 0xb7, 0x04,
	/* ch = 'l' */
	0x14, 0x74, 0x74, 0x42, 0x00, 0x00,
	0x04, 0x15, 0x5e, 0x82, 0x00, 0x00,
	0x00, 0x00, 0x50, 0x82, 0x00, 0x00,
	0x00, 0x00, 0x50, 0x82, 0x00, 0x00,
	0x00, 0x00, 0x50, 0x82, 0x00, 0x00,
	0x00, 0x00, 0x50, 0x82, 0x00, 0x00,
	0x00, 0x00, 0x50, 0x82, 0x00, 0x00,
	0x00, 0x00, 0x50, 0x82, 0x00, 0x00,
	0x2d, 0xcf, 0xe5, 0xf7, 0xcf, 0x45,
	/* ch = 'm' */
	0xb7, 0xe5, 0xdb, 0xbb, 0xbb, 0xdb, 0x00,
	0xb7, 0x4c, 0x50, 0xbd, 0x1f, 0xff, 0x1f,
	0xb7, 0x35, 0x50, 0x82, 0x1c, 0xff, 0x1f,
	0xb7, 0x35, 0x50, 0x82, 0x1c, 0xff, 0x1f,
	0xb7, 0x35, 0x50, 0x82, 0x1c, 0xff, 0x1f,
	0xb7, 0x35, 0x50, 0x82, 0x1c, 0xff, 0x1f,
	/* ch = 'n' */
	0x50, 0xd9, 0xbb, 0xd4, 0xdb, 0x17,
	0x50, 0xff, 0x24, 0x00, 0xa7, 0x59,
	0x50, 0xbd, 0x00, 0x00, 0x7c, 0x82,
	0x50, 0xbd, 0x00, 0x00, 0x7c, 0x82,
	0x50, 0xbd, 0x00, 0x00, 0x7c, 0x82,
	0x50, 0xbd, 0x00, 0x00, 0x7c, 0x82,
	/* ch = 'o' */
	0x00, 0x66, 0xdd, 0xdd, 0xa9, 0x10, 0x00,
	0x44, 0xdb, 0x0c, 0x00, 0x90, 0x82, 0x00,
	0xa0, 0x64, 0x00, 0x00, 0x35, 0xec, 0x00,
	0xb1, 0x64, 0x00, 0x00, 0x32, 0xf7, 0x04,
	0x50, 0xcf, 0x04, 0x00, 0x82, 0x90, 0x00,
	0x04, 0x84, 0xef, 0xb3, 0xcb, 0x13, 0x00,
	0x00, 0x00, 0x0c, 0x15, 0x00, 0x00, 0x00,
	/* ch = 'p' */
	0x50, 0xbd, 0xcf, 0xdd, 0xdb, 0x19, 0x00,
	0x50, 0xe5, 0x0c, 0x00, 0x90, 0xa0, 0x00,
	0x50, 0x88, 0x00, 0x00, 0x35, 0xff, 0x04,
	0x50, 0x88, 0x00, 0x00, 0x32, 0xf7, 0x04,
	0x50, 0xd9, 0x04, 0x00, 0x75, 0x90, 0x00,
	0x50, 0xdb, 0xe5, 0xc4, 0xd4, 0x21, 0x00,
	0x50, 0x82, 0x08, 0x15, 0x04, 0x00, 0x00,
	0x50, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0c, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00,
	/* ch = 'q' */
	0x04, 0x94, 0xcb, 0xdd, 0xdb, 0x82,
	0x48, 0xb7, 0x08, 0x04, 0xa7, 0x82,
	0x90, 0x54, 0x00, 0x00, 0x54, 0x82,
	0x90, 0x64, 0x00, 0x00, 0x54, 0x82,
	0x48, 0xcf, 0x04, 0x04, 0xb7, 0x82,
	0x04, 0xa9, 0xef, 0xdd, 0xc4, 0x82,
	0x00, 0x00, 0x0f, 0x08, 0x50, 0x82,
	0x00, 0x00, 0x00, 0x00, 0x50, 0x82,
	0x00, 0x00, 0x00, 0x00, 0x0c, 0x12,
	/* ch = 'r' */
	0xff, 0xb1, 0xdd, 0xdd, 0xab,
	0xff, 0xb1, 0x08, 0x04, 0x28,
	0xff, 0x35, 0x00, 0x00, 0x00,
	0xff, 0x1f, 0x00, 0x00, 0x00,
	0xff, 0x1f, 0x00, 0x00, 0x00,
	0xff, 0x1f, 0x00, 0x00, 0x00,
	/* ch = 's' */
	0x00, 0x66, 0xcb, 0x9e, 0xdb, 0x26,
	0x1c, 0xff, 0x21, 0x00, 0x2c, 0x21,
	0x04, 0xa2, 0xef, 0x5b, 0x1e, 0x00,
	0x00, 0x00, 0x18, 0x5a, 0xf7, 0x44,
	0x24, 0x3b, 0x00, 0x00, 0x82, 0x7c,
	0x26, 0xd4, 0xcb, 0xab, 0xd4, 0x21,
	0x00, 0x00, 0x0c, 0x12, 0x00, 0x00,
	/* ch = 't' */
	0x00, 0x00, 0x5c, 0x28, 0x00, 0x00,
	0x00, 0x00, 0xff, 0x35, 0x00, 0x00,
	0x42, 0xcf, 0xff, 0xd4, 0xcf, 0x1c,
	0x00, 0x0d, 0xff, 0x1f, 0x00, 0x00,
	0x00, 0x1c, 0xff, 0x1f, 0x00, 0x00,
	0x00, 0x1c, 0xff, 0x1f, 0x00, 0x00,
	0x00, 0x1a, 0xff, 0x26, 0x04, 0x0c,
	0x00, 0x00, 0x99, 0xf7, 0xe5, 0x62,
	0x00, 0x00, 0x00, 0x0f, 0x04, 0x00,
	/* ch = 'u' */
	0x50, 0xbd, 0x00, 0x00, 0x7c, 0x82,
	0x50, 0xbd, 0x00, 0x00, 0x7c, 0x82,
	0x50, 0xbd, 0x00, 0x00, 0x7c, 0x82,
	0x50, 0xbd, 0x00, 0x00, 0x7c, 0x82,
	0x44, 0xd9, 0x04, 0x04, 0xc8, 0x82,
	0x04, 0xa9, 0xc4, 0xc4, 0xdb, 0x82,
	0x00, 0x00, 0x12, 0x08, 0x00, 0x00,
	/* ch = 'v' */
	0x70, 0x88, 0x00, 0x00, 0x35, 0xa7, 0x04,
	0x24, 0xff, 0x0d, 0x00, 0x70, 0x54, 0x00,
	0x00, 0xc8, 0x4c, 0x0d, 0xf7, 0x1a, 0x00,
	0x00, 0x48, 0xcf, 0x48, 0x90, 0x00, 0x00,
	0x00, 0x0d, 0xf7, 0xf7, 0x2f, 0x00, 0x00,
	0x00, 0x00, 0x8a, 0xb7, 0x04, 0x00, 0x00,
	/* ch = 'w' */
	0xff, 0x1f, 0x16, 0x26, 0x00, 0xff, 0x1f,
	0xbd, 0x32, 0x5f, 0xbd, 0x00, 0xff, 0x08,
	0x77, 0x59, 0xa0, 0xff, 0x2f, 0xcf, 0x04,
	0x44, 0x9e, 0xe5, 0x82, 0xa0, 0x97, 0x00,
	0x24, 0xff, 0x82, 0x3b, 0xff, 0x59, 0x00,
	0x04, 0xff, 0x3f, 0x14, 0xff, 0x37, 0x00,
	/* ch = 'x' */
	0x35, 0xe5, 0x10, 0x04, 0xdb, 0x37,
	0x00, 0x7c, 0x82, 0x6b, 0x82, 0x04,
	0x00, 0x0d, 0xdb, 0xe5, 0x13, 0x00,
	0x00, 0x10, 0xdb, 0xff, 0x1f, 0x00,
	0x00, 0x7c, 0x7c, 0x59, 0xb7, 0x04,
	0x35, 0xdb, 0x13, 0x04, 0xb1, 0x68,
	/* ch = 'y' */
	0x5a, 0x9e, 0x00, 0x00, 0x3b, 0xc8, 0x04,
	0x17, 0xff, 0x1a, 0x00, 0x8a, 0x5f, 0x00,
	0x00, 0x8a, 0x5f, 0x0d, 0xf7, 0x1a, 0x00,
	0x00, 0x39, 0xec, 0x3f, 0xa7, 0x04, 0x00,
	0x00, 0x04, 0xe5, 0xff, 0x3b, 0x00, 0x00,
	0x00, 0x00, 0x5a, 0xf7, 0x10, 0x00, 0x00,
	0x00, 0x00, 0x5f, 0x75, 0x00, 0x00, 0x00,
	0xc0, 0x82, 0xef, 0x1f, 0x00, 0x00, 0x00,
	0x0c, 0x15, 0x0c, 0x00, 0x00, 0x00, 0x00,
	/* ch = 'z' */
	0x2d, 0xcf, 0xcf, 0xcf, 0xff, 0x50,
	0x00, 0x00, 0x00, 0x50, 0xb1, 0x08,
	0x00, 0x00, 0x32, 0xf7, 0x1f, 0x00,
	0x00, 0x1f, 0xf7, 0x35, 0x00, 0x00,
	0x10, 0xdb, 0x54, 0x00, 0x00, 0x00,
	0x77, 0xff, 0xd4, 0xcf, 0xcf, 0x95,
	/* ch = '{' */
	0x00, 0x15, 0x15, 0x08,
	0xa9, 0x99, 0x36, 0x19,
	0xff, 0x10, 0x00, 0x00,
	0xff, 0x04, 0x00, 0x00,
	0xe5, 0x04, 0x00, 0x00,
	0x2d, 0x00, 0x00, 0x00,
	0xa7, 0x00, 0x00, 0x00,
	0xff, 0x04, 0x00, 0x00,
	0xff, 0x04, 0x00, 0x00,
	0xff, 0x13, 0x00, 0x00,
	0x77, 0xef, 0x74, 0x22,
	/* ch = '|' */
	0x1e, 0x26,
	0x50, 0x82,
	0x50, 0x82,
	0x50, 0x82,
	0x50, 0x82,
	0x50, 0x82,
	0x50, 0x82,
	0x50, 0x82,
	0x50, 0x82,
	0x50, 0x82,
	0x50, 0x82,
	/* ch = '}' */
	0x04, 0x15, 0x15, 0x04, 0x00,
	0x0d, 0x36, 0x77, 0xdb, 0x0d,
	0x00, 0x00, 0x00, 0xbd, 0x35,
	0x00, 0x00, 0x00, 0xb7, 0x35,
	0x00, 0x00, 0x00, 0xa0, 0x4c,
	0x00, 0x00, 0x00, 0x1b, 0xec,
	0x00, 0x00, 0x00, 0x6b, 0x68,
	0x00, 0x00, 0x00, 0xb7, 0x35,
	0x00, 0x00, 0x00, 0xb7, 0x50,
	0x00, 0x00, 0x04, 0xcf, 0x37,
	0x14, 0x74, 0xcb, 0xa9, 0x08,
	/* ch = '~' */
	0x2c, 0xe5, 0xef, 0x6b, 0x1e, 0xc8, 0x09,
	0x2f, 0x21, 0x08, 0x8d, 0xbd, 0x31, 0x00
};

/* font_inconsolata_14px */
static const unsigned char font_bitmap_14px_bytes[] = {
	/* ch = '!' */
	0x13, 0x28, 0x00,
	0x77, 0xff, 0x10,
	0x77, 0xff, 0x04,
	0x50, 0xff, 0x04,
	0x50, 0xbd, 0x04,
	0x44, 0xbd, 0x00,
	0x32, 0xa7, 0x00,
	0x08, 0x12, 0x00,
	0x21, 0x30, 0x00,
	0x99, 0xff, 0x17,
	0x08, 0x12, 0x00,
	/* ch = '"' */
	0x08, 0x2a, 0x00, 0x22, 0x08,
	0x39, 0xff, 0x1c, 0xff, 0x54,
	0x35, 0xe5, 0x04, 0xff, 0x3b,
	0x6b, 0x70, 0x1c, 0xf7, 0x10,
	0x12, 0x0c, 0x04, 0x15, 0x00,
	/* ch = '#' */
	0x00, 0x00, 0xbd, 0x1f, 0x32, 0x42, 0x00,
	0x00, 0x04, 0xff, 0x1c, 0x7c, 0x54, 0x00,
	0x28, 0x4a, 0xff, 0x39, 0xc8, 0x78, 0x26,
	0x2d, 0x62, 0xbd, 0x15, 0xd9, 0x3a, 0x12,
	0x00, 0x3b, 0xa7, 0x00, 0xff, 0x1f, 0x00,
	0x1a, 0x82, 0xab, 0x4a, 0xff, 0x39, 0x16,
	0x36, 0xa5, 0x82, 0x58, 0xcf, 0x15, 0x0c,
	0x00, 0xa0, 0x3f, 0x35, 0xb7, 0x00, 0x00,
	0x00, 0xa9, 0x2a, 0x45, 0x6c, 0x00, 0x00,
	/* ch = '$' */
	0x00, 0x00, 0x00, 0x15, 0x04, 0x00, 0x00,
	0x00, 0x00, 0x0f, 0xff, 0x28, 0x00, 0x00,
	0x00, 0x77, 0xbb, 0xff, 0xd4, 0xb1, 0x0d,
	0x1c, 0xff, 0x10, 0xff, 0x1f, 0x40, 0x04,
	0x0d, 0xf7, 0x64, 0xff, 0x1f, 0x00, 0x00,
	0x00, 0x1b, 0xab, 0xff, 0x8b, 0x1b, 0x00,
	0x00, 0x00, 0x00, 0xff, 0x77, 0xff, 0x1c,
	0x00, 0x0c, 0x00, 0xff, 0x1f, 0xb7, 0x44,
	0x2d, 0xc8, 0x1e, 0xff, 0x59, 0xf7, 0x1f,
	0x00, 0x37, 0xab, 0xff, 0xa4, 0x1e, 0x00,
	0x00, 0x00, 0x00, 0x74, 0x17, 0x00, 0x00,
	/* ch = '%' */
	0x2c, 0xc6, 0x9c, 0x0d, 0x0d, 0xbd, 0x22,
	0xb7, 0x35, 0x97, 0x50, 0x5f, 0x90, 0x04,
	0xb7, 0x43, 0xa7, 0x65, 0xf7, 0x1f, 0x00,
	0x26, 0xbd, 0x7f, 0x88, 0x70, 0x00, 0x00,
	0x00, 0x00, 0x24, 0xf7, 0x13, 0x00, 0x00,
	0x00, 0x00, 0xa0, 0x54, 0x30, 0x30, 0x04,
	0x00, 0x32, 0xdb, 0x59, 0x90, 0x82, 0x5f,
	0x04, 0xc8, 0x3f, 0x7c, 0x54, 0x50, 0x90,
	0x3b, 0xb7, 0x04, 0x2f, 0xdb, 0xdb, 0x35,
	0x00, 0x00, 0x00, 0x00, 0x0c, 0x0f, 0x00,
	/* ch = '&' */
	0x00, 0x26, 0xbd, 0xbd, 0x26, 0x00, 0x00,
	0x00, 0xe5, 0x46, 0x37, 0xff, 0x00, 0x00,
	0x00, 0xf7, 0x37, 0x24, 0xf7, 0x04, 0x00,
	0x00, 0x5f, 0xbd, 0xb1, 0x54, 0x00, 0x00,
	0x00, 0x54, 0xff, 0xa4, 0x04, 0x00, 0x00,
	0x3b, 0xf7, 0x26, 0xf7, 0x35, 0x70, 0x40,
	0xa0, 0x7c, 0x00, 0x32, 0xff, 0xf7, 0x21,
	0xa0, 0x9e, 0x00, 0x13, 0xec, 0xc6, 0x04,
	0x1f, 0xef, 0xe5, 0xef, 0x48, 0xdb, 0x52,
	0x00, 0x04, 0x15, 0x04, 0x00, 0x0c, 0x04,
	/* ch = ''' */
	0x00, 0x2a, 0x08,
	0x0a, 0xff, 0x50,
	0x04, 0xff, 0x2c,
	0x2a, 0xe5, 0x04,
	0x0c, 0x12, 0x00,
	/* ch = '(' */
	0x00, 0x08, 0x21,
	0x21, 0xdb, 0x6d,
	0xf7, 0x3f, 0x00,
	0x82, 0x00, 0x00,
	0x26, 0x00, 0x00,
	0x04, 0x00, 0x00,
	0x04, 0x00, 0x00,
	0x08, 0x00, 0x00,
	0x2f, 0x00, 0x00,
	0xa7, 0x00, 0x00,
	0xdb, 0x54, 0x00,
	0x1f, 0xdb, 0x77,
	0x00, 0x08, 0x22,
	/* ch = ')' */
	0x00, 0x21, 0x00, 0x00,
	0x14, 0xef, 0x70, 0x04,
	0x00, 0x13, 0xdb, 0x82,
	0x00, 0x00, 0x1f, 0xf7,
	0x00, 0x00, 0x00, 0x70,
	0x00, 0x00, 0x00, 0x35,
	0x00, 0x00, 0x00, 0x21,
	0x00, 0x00, 0x00, 0x32,
	0x00, 0x00, 0x00, 0x70,
	0x00, 0x00, 0x10, 0xf7,
	0x00, 0x08, 0xb1, 0x7c,
	0x1a, 0xd4, 0x84, 0x08,
	0x0d, 0x25, 0x00, 0x00,
	/* ch = '*' */
	0x00, 0x00, 0x08, 0x15, 0x04, 0x00, 0x00,
	0x00, 0x00, 0x2f, 0xff, 0x04, 0x00, 0x00,
	0x51, 0x73, 0x28, 0xbd, 0x20, 0x9e, 0x22,
	0x12, 0x47, 0xc4, 0xff, 0x95, 0x2a, 0x0c,
	0x00, 0x10, 0xdb, 0xbb, 0x82, 0x00, 0x00,
	0x04, 0xb1, 0x7c, 0x0d, 0xdb, 0x54, 0x00,
	0x00, 0x3d, 0x08, 0x00, 0x2a, 0x21, 0x00,
	/* ch = '+' */
	0x00, 0x00, 0x0d, 0x36, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x1c, 0xff, 0x04, 0x00, 0x00,
	0x00, 0x00, 0x1c, 0xff, 0x04, 0x00, 0x00,
	0x7c, 0xff, 0xff, 0xff, 0xff, 0xff, 0x35,
	0x00, 0x00, 0x1c, 0xff, 0x04, 0x00, 0x00,
	0x00, 0x00, 0x1c, 0xff, 0x04, 0x00, 0x00,
	0x00, 0x00, 0x14, 0x74, 0x04, 0x00, 0x00,
	/* ch = ',' */
	0x21, 0x2a, 0x00,
	0x99, 0xff, 0x24,
	0x1f, 0xff, 0x17,
	0x7c, 0x54, 0x00,
	0x22, 0x04, 0x00,
	/* ch = '-' */
	/* ch = '.' */
	0x21, 0x30, 0x00,
	0xa0, 0xff, 0x17,
	0x08, 0x12, 0x00,
	/* ch = '/' */
	0x0d, 0x1b, 0x00,
	0x44, 0xe5, 0x08,
	0xc8, 0x4c, 0x00,
	0xe5, 0x10, 0x00,
	0x5f, 0x00, 0x00,
	0x13, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	/* ch = '0' */
	0x00, 0x08, 0x7f, 0xcf, 0x48, 0x00, 0x00,
	0x00, 0xa0, 0x7c, 0x1a, 0xdb, 0x50, 0x00,
	0x2a, 0xe5, 0x08, 0x00, 0x82, 0xec, 0x00,
	0x50, 0x88, 0x00, 0x50, 0xdb, 0xff, 0x1f,
	0x7c, 0x82, 0x1f, 0xef, 0x21, 0xff, 0x35,
	0x5f, 0x9e, 0xdb, 0x35, 0x00, 0xff, 0x26,
	0x3b, 0xff, 0x64, 0x00, 0x1c, 0xff, 0x17,
	0x0d, 0xe5, 0x3f, 0x00, 0x64, 0x90, 0x00,
	0x00, 0x2c, 0xef, 0xdd, 0xd4, 0x13, 0x00,
	0x00, 0x00, 0x04, 0x15, 0x04, 0x00, 0x00,
	/* ch = '1' */
	0x00, 0x00, 0x37, 0xbd, 0x1a,
	0x0a, 0xbd, 0xb3, 0xff, 0x1f,
	0x00, 0x00, 0x1c, 0xff, 0x1f,
	0x00, 0x00, 0x1c, 0xff, 0x1f,
	0x00, 0x00, 0x1c, 0xff, 0x1f,
	0x00, 0x00, 0x1c, 0xff, 0x1f,
	0x00, 0x00, 0x1c, 0xff, 0x1f,
	0x00, 0x00, 0x1c, 0xff, 0x1f,
	0x00, 0x00, 0x1c, 0xff, 0x1f,
	/* ch = '2' */
	0x00, 0x1b, 0x9e, 0xcf, 0x66, 0x08, 0x00,
	0x11, 0xe5, 0x37, 0x1a, 0xb1, 0x97, 0x00,
	0x00, 0x0f, 0x00, 0x00, 0x2c, 0xff, 0x04,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0xdb, 0x04,
	0x00, 0x00, 0x00, 0x1f, 0xf7, 0x35, 0x00,
	0x00, 0x00, 0x1f, 0xef, 0x48, 0x00, 0x00,
	0x00, 0x17, 0xdb, 0x3f, 0x00, 0x00, 0x00,
	0x00, 0xa0, 0x64, 0x00, 0x00, 0x00, 0x00,
	0x2f, 0xff, 0xdd, 0xcf, 0xcf, 0xdd, 0x1f,
	/* ch = '3' */
	0x00, 0x28, 0x9e, 0xbd, 0x48, 0x00,
	0x00, 0x8d, 0x2b, 0x20, 0xdb, 0x50,
	0x00, 0x00, 0x00, 0x00, 0x50, 0x92,
	0x00, 0x00, 0x00, 0x13, 0xdb, 0x48,
	0x00, 0x00, 0x95, 0xf7, 0xa4, 0x04,
	0x00, 0x00, 0x00, 0x04, 0x82, 0x82,
	0x00, 0x00, 0x00, 0x00, 0x32, 0xf7,
	0x04, 0x73, 0x04, 0x00, 0x82, 0xa7,
	0x10, 0xbb, 0xef, 0xdd, 0xd4, 0x21,
	0x00, 0x00, 0x0c, 0x15, 0x00, 0x00,
	/* ch = '4' */
	0x00, 0x00, 0x00, 0x17, 0xcf, 0x1a, 0x00,
	0x00, 0x00, 0x00, 0xa0, 0xff, 0x1f, 0x00,
	0x00, 0x00, 0x44, 0xdb, 0xff, 0x1f, 0x00,
	0x00, 0x17, 0xef, 0x2f, 0xff, 0x1f, 0x00,
	0x00, 0xa0, 0x48, 0x1c, 0xff, 0x1f, 0x00,
	0x44, 0xc6, 0x17, 0x28, 0xff, 0x2a, 0x08,
	0x42, 0x74, 0x74, 0x87, 0xff, 0x87, 0x24,
	0x00, 0x00, 0x00, 0x1c, 0xff, 0x1f, 0x00,
	0x00, 0x00, 0x00, 0x1c, 0xff, 0x1f, 0x00,
	/* ch = '5' */
	0x00, 0x95, 0xcf, 0xcf, 0xcf, 0x95, 0x00,
	0x00, 0xf7, 0x3e, 0x15, 0x15, 0x15, 0x00,
	0x00, 0xff, 0x21, 0x00, 0x00, 0x00, 0x00,
	0x04, 0xff, 0x7e, 0x74, 0x50, 0x04, 0x00,
	0x1a, 0xe5, 0x37, 0x1a, 0xb1, 0xa7, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x24, 0xff, 0x1c,
	0x00, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x1f,
	0x19, 0x9c, 0x08, 0x00, 0x50, 0xe5, 0x08,
	0x04, 0x8d, 0xf7, 0xcf, 0xef, 0x2f, 0x00,
	0x00, 0x00, 0x08, 0x15, 0x04, 0x00, 0x00,
	/* ch = '6' */
	0x00, 0x04, 0x50, 0xcf, 0xbd, 0x37, 0x00,
	0x00, 0x6b, 0xb1, 0x18, 0x2e, 0x50, 0x00,
	0x0d, 0xf7, 0x26, 0x00, 0x00, 0x00, 0x00,
	0x2f, 0xff, 0x3a, 0x74, 0x48, 0x04, 0x00,
	0x32, 0xff, 0x99, 0x25, 0xb1, 0x7c, 0x00,
	0x32, 0xff, 0x08, 0x00, 0x24, 0xff, 0x10,
	0x2a, 0xff, 0x08, 0x00, 0x1c, 0xff, 0x1f,
	0x04, 0xe5, 0x4c, 0x00, 0x3f, 0xdb, 0x04,
	0x00, 0x2c, 0xef, 0xd4, 0xef, 0x28, 0x00,
	0x00, 0x00, 0x00, 0x15, 0x08, 0x00, 0x00,
	/* ch = '7' */
	0x1a, 0xcf, 0xcf, 0xcf, 0xcf, 0xcf, 0x00,
	0x04, 0x15, 0x15, 0x15, 0x82, 0xa7, 0x04,
	0x00, 0x00, 0x00, 0x0d, 0xf7, 0x35, 0x00,
	0x00, 0x00, 0x00, 0x48, 0xe5, 0x08, 0x00,
	0x00, 0x00, 0x00, 0xb7, 0x5f, 0x00, 0x00,
	0x00, 0x00, 0x22, 0xff, 0x1f, 0x00, 0x00,
	0x00, 0x00, 0x5f, 0xb7, 0x04, 0x00, 0x00,
	0x00, 0x00, 0xe5, 0x54, 0x00, 0x00, 0x00,
	0x00, 0x2c, 0xff, 0x1f, 0x00, 0x00, 0x00,
	/* ch = '8' */
	0x00, 0x19, 0x9e, 0xcf, 0x7f, 0x10, 0x00,
	0x00, 0xc8, 0x59, 0x08, 0x90, 0x90, 0x00,
	0x00, 0xff, 0x26, 0x00, 0x48, 0xbd, 0x00,
	0x00, 0x77, 0xc8, 0x20, 0xdb, 0x48, 0x00,
	0x00, 0x1b, 0xec, 0xef, 0xb5, 0x08, 0x00,
	0x10, 0xef, 0x35, 0x04, 0x8a, 0xb7, 0x00,
	0x4d, 0xbd, 0x04, 0x00, 0x1f, 0xff, 0x1c,
	0x39, 0xff, 0x1a, 0x00, 0x3f, 0xf7, 0x10,
	0x00, 0x66, 0xff, 0xcf, 0xef, 0x2f, 0x00,
	0x00, 0x00, 0x08, 0x15, 0x04, 0x00, 0x00,
	/* ch = '9' */
	0x00, 0x19, 0x9e, 0xcf, 0x50, 0x04, 0x00,
	0x04, 0xdb, 0x54, 0x1a, 0xb7, 0x5f, 0x00,
	0x2f, 0xff, 0x08, 0x00, 0x35, 0xec, 0x00,
	0x32, 0xff, 0x00, 0x00, 0x1c, 0xff, 0x10,
	0x0d, 0xf7, 0x46, 0x08, 0x8a, 0xff, 0x1f,
	0x00, 0x26, 0xab, 0xcf, 0x70, 0xff, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x3b, 0xe5, 0x04,
	0x00, 0x22, 0x00, 0x04, 0xb1, 0x64, 0x00,
	0x09, 0xcb, 0xe5, 0xe5, 0x94, 0x08, 0x00,
	0x00, 0x00, 0x12, 0x0f, 0x00, 0x00, 0x00,
	/* ch = ':' */
	0x73, 0xdb, 0x0d,
	0x3d, 0x67, 0x08,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x21, 0x30, 0x00,
	0xa0, 0xff, 0x17,
	0x08, 0x12, 0x00,
	/* ch = ';' */
	0x73, 0xdb, 0x0d,
	0x3d, 0x67, 0x08,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x21, 0x2a, 0x00,
	0x99, 0xff, 0x24,
	0x1f, 0xff, 0x17,
	0x7c, 0x54, 0x00,
	0x22, 0x04, 0x00,
	/* ch = '<' */
	0x00, 0x00, 0x13, 0x7f, 0x37,
	0x0c, 0x73, 0xef, 0x5a, 0x0c,
	0xef, 0x5a, 0x0c, 0x00, 0x00,
	0x0f, 0x00, 0x00, 0x00, 0x00,
	0xef, 0x37, 0x00, 0x00, 0x00,
	0x1b, 0xbb, 0xc4, 0x1e, 0x00,
	0x00, 0x00, 0x37, 0xef, 0x4d,
	0x00, 0x00, 0x00, 0x08, 0x21,
	/* ch = '=' */
	0x0f, 0x15, 0x15, 0x15, 0x15, 0x15, 0x08,
	0x67, 0xcf, 0xcf, 0xcf, 0xcf, 0xcf, 0x2f,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0f, 0x15, 0x15, 0x15, 0x15, 0x15, 0x08,
	0x42, 0x74, 0x74, 0x74, 0x74, 0x74, 0x24,
	/* ch = '>' */
	0x7c, 0x48, 0x04, 0x00, 0x00,
	0x1b, 0x8d, 0xef, 0x37, 0x04,
	0x00, 0x00, 0x1b, 0x94, 0xdb,
	0x00, 0x00, 0x00, 0x00, 0x27,
	0x00, 0x00, 0x08, 0x73, 0xe5,
	0x04, 0x37, 0xef, 0x73, 0x0c,
	0xa9, 0xbb, 0x1e, 0x00, 0x00,
	0x22, 0x04, 0x00, 0x00, 0x00,
	/* ch = '?' */
	0x00, 0x00, 0x12, 0x2a, 0x0f, 0x00,
	0x04, 0xa9, 0xe5, 0x8f, 0xff, 0x50,
	0x19, 0x8d, 0x08, 0x00, 0x50, 0xff,
	0x00, 0x00, 0x00, 0x00, 0x48, 0xff,
	0x00, 0x00, 0x00, 0x10, 0xdb, 0x7c,
	0x00, 0x00, 0x00, 0xb1, 0x7c, 0x04,
	0x00, 0x00, 0x1c, 0xff, 0x1f, 0x00,
	0x00, 0x00, 0x0d, 0x36, 0x10, 0x00,
	0x00, 0x00, 0x10, 0x36, 0x08, 0x00,
	0x00, 0x00, 0x4d, 0xff, 0x48, 0x00,
	0x00, 0x00, 0x00, 0x15, 0x04, 0x00,
	/* ch = '@' */
	0x00, 0x13, 0x7f, 0xcf, 0xab, 0x21, 0x00,
	0x10, 0xdb, 0x37, 0x00, 0x28, 0xff, 0x10,
	0x5a, 0x75, 0x00, 0x04, 0x15, 0x9e, 0x48,
	0xb1, 0x37, 0x2c, 0xe5, 0x82, 0xa5, 0x54,
	0xb7, 0x2e, 0xb1, 0x3f, 0x00, 0x7c, 0x54,
	0xb7, 0x35, 0x99, 0x82, 0x20, 0xe5, 0x54,
	0x6b, 0x75, 0x10, 0x67, 0x74, 0x5b, 0x32,
	0x1c, 0xf7, 0x28, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x26, 0xd4, 0xb3, 0xab, 0xd4, 0x0a,
	0x00, 0x00, 0x00, 0x12, 0x12, 0x00, 0x00,
	/* ch = 'A' */
	0x00, 0x00, 0x1c, 0x51, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x5a, 0xec, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xc8, 0xff, 0x2f, 0x00, 0x00,
	0x00, 0x22, 0xe5, 0x68, 0x90, 0x00, 0x00,
	0x00, 0x5f, 0x70, 0x22, 0xff, 0x0d, 0x00,
	0x00, 0xcf, 0x67, 0x36, 0xd9, 0x4c, 0x00,
	0x2a, 0xf7, 0x36, 0x36, 0x7b, 0xaf, 0x00,
	0x6b, 0x82, 0x00, 0x00, 0x17, 0xff, 0x24,
	0xe5, 0x35, 0x00, 0x00, 0x00, 0xa7, 0x68,
	/* ch = 'B' */
	0x67, 0xcf, 0xcf, 0xab, 0x5b, 0x08, 0x00,
	0x7c, 0x88, 0x15, 0x1a, 0xa0, 0xa7, 0x00,
	0x7c, 0x82, 0x00, 0x00, 0x32, 0xff, 0x04,
	0x7c, 0x8f, 0x15, 0x1a, 0xa0, 0x7c, 0x04,
	0x7c, 0xef, 0xcf, 0xcf, 0xec, 0x2b, 0x00,
	0x7c, 0x82, 0x00, 0x00, 0x32, 0xff, 0x17,
	0x7c, 0x82, 0x00, 0x00, 0x00, 0xff, 0x35,
	0x7c, 0x82, 0x00, 0x00, 0x37, 0xff, 0x24,
	0x7c, 0xf7, 0xcf, 0xdd, 0xdd, 0x37, 0x00,
	/* ch = 'C' */
	0x00, 0x10, 0x66, 0xcf, 0xab, 0x26, 0x00,
	0x04, 0xb1, 0x77, 0x0c, 0x28, 0xf7, 0x32,
	0x40, 0xcf, 0x08, 0x00, 0x00, 0x28, 0x08,
	0x77, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xa0, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7c, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xbd, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x17, 0xf7, 0x3a, 0x00, 0x08, 0x8d, 0x22,
	0x00, 0x2c, 0xef, 0xdd, 0xef, 0x7e, 0x08,
	0x00, 0x00, 0x00, 0x15, 0x08, 0x00, 0x00,
	/* ch = 'D' */
	0x67, 0xcf, 0xcf, 0x82, 0x37, 0x00, 0x00,
	0x7c, 0x88, 0x15, 0x2b, 0xdb, 0x70, 0x00,
	0x7c, 0x82, 0x00, 0x00, 0x2c, 0xff, 0x17,
	0x7c, 0x82, 0x00, 0x00, 0x04, 0xff, 0x35,
	0x7c, 0x82, 0x00, 0x00, 0x00, 0xbd, 0x48,
	0x7c, 0x82, 0x00, 0x00, 0x00, 0xe5, 0x37,
	0x7c, 0x82, 0x00, 0x00, 0x17, 0xff, 0x1f,
	0x7c, 0x82, 0x00, 0x04, 0xa0, 0x90, 0x04,
	0x7c, 0xf7, 0xcf, 0xe5, 0x8d, 0x0c, 0x00,
	/* ch = 'E' */
	0x45, 0xcf, 0xcf, 0xcf, 0xcf, 0xcf, 0x1a,
	0x50, 0xbd, 0x15, 0x15, 0x15, 0x15, 0x08,
	0x50, 0xbd, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xbd, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xf7, 0xcf, 0xcf, 0xcf, 0x2f, 0x00,
	0x50, 0xbd, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xbd, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xbd, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xff, 0xcf, 0xcf, 0xcf, 0xcf, 0x1a,
	/* ch = 'F' */
	0x1a, 0xcf, 0xcf, 0xcf, 0xcf, 0xcf, 0x1a,
	0x1c, 0xff, 0x15, 0x15, 0x15, 0x15, 0x08,
	0x1c, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x17, 0x15, 0x15, 0x08, 0x00,
	0x1c, 0xff, 0xcf, 0xcf, 0xcf, 0x2f, 0x00,
	0x1c, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00,
	/* ch = 'G' */
	0x00, 0x10, 0x73, 0xcf, 0xab, 0x28, 0x00,
	0x0d, 0xdb, 0x77, 0x12, 0x31, 0xf7, 0x27,
	0x48, 0xa7, 0x04, 0x00, 0x00, 0x22, 0x04,
	0x90, 0x59, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xb7, 0x54, 0x00, 0x08, 0x15, 0x15, 0x0c,
	0xb1, 0x59, 0x00, 0x22, 0x74, 0xe5, 0x54,
	0x6b, 0xa7, 0x00, 0x00, 0x00, 0xb7, 0x54,
	0x1c, 0xff, 0x37, 0x00, 0x00, 0xbd, 0x54,
	0x00, 0x2f, 0xef, 0xdd, 0xe5, 0xb3, 0x1b,
	0x00, 0x00, 0x00, 0x12, 0x08, 0x00, 0x00,
	/* ch = 'H' */
	0x45, 0x95, 0x00, 0x00, 0x1a, 0xcf, 0x1f,
	0x50, 0xbd, 0x00, 0x00, 0x1c, 0xff, 0x1f,
	0x50, 0xbd, 0x00, 0x00, 0x1c, 0xff, 0x1f,
	0x50, 0xbd, 0x00, 0x00, 0x1c, 0xff, 0x1f,
	0x50, 0xf7, 0xcf, 0xcf, 0xd4, 0xff, 0x1f,
	0x50, 0xbd, 0x00, 0x00, 0x1c, 0xff, 0x1f,
	0x50, 0xbd, 0x00, 0x00, 0x1c, 0xff, 0x1f,
	0x50, 0xbd, 0x00, 0x00, 0x1c, 0xff, 0x1f,
	0x50, 0xbd, 0x00, 0x00, 0x1c, 0xff, 0x1f,
	/* ch = 'I' */
	0x1a, 0xcf, 0xcf, 0xcf, 0xcf, 0x45,
	0x00, 0x00, 0x50, 0xbd, 0x00, 0x00,
	0x00, 0x00, 0x50, 0xbd, 0x00, 0x00,
	0x00, 0x00, 0x50, 0xbd, 0x00, 0x00,
	0x00, 0x00, 0x50, 0xbd, 0x00, 0x00,
	0x00, 0x00, 0x50, 0xbd, 0x00, 0x00,
	0x00, 0x00, 0x50, 0xbd, 0x00, 0x00,
	0x00, 0x00, 0x50, 0xbd, 0x00, 0x00,
	0x1a, 0xcf, 0xe5, 0xff, 0xcf, 0x67,
	/* ch = 'J' */
	0x00, 0x00, 0xcf, 0xcf, 0xcf, 0xcf,
	0x00, 0x00, 0x00, 0x1c, 0xff, 0x04,
	0x00, 0x00, 0x00, 0x1c, 0xff, 0x04,
	0x00, 0x00, 0x00, 0x1c, 0xff, 0x04,
	0x00, 0x00, 0x00, 0x1c, 0xff, 0x04,
	0x00, 0x00, 0x00, 0x1c, 0xff, 0x04,
	0x00, 0x00, 0x00, 0x2f, 0xff, 0x04,
	0x17, 0x2c, 0x00, 0x48, 0xc8, 0x04,
	0x2c, 0xef, 0xd4, 0xf7, 0x2f, 0x00,
	0x00, 0x04, 0x15, 0x08, 0x00, 0x00,
	/* ch = 'K' */
	0x67, 0x73, 0x00, 0x00, 0x32, 0xc6, 0x17,
	0x7c, 0x82, 0x00, 0x1f, 0xf7, 0x35, 0x00,
	0x7c, 0x82, 0x1f, 0xef, 0x48, 0x00, 0x00,
	0x7c, 0x9e, 0xdb, 0x54, 0x00, 0x00, 0x00,
	0x7c, 0xff, 0xf7, 0x37, 0x00, 0x00, 0x00,
	0x7c, 0x88, 0x44, 0xff, 0x17, 0x00, 0x00,
	0x7c, 0x82, 0x00, 0x90, 0xb7, 0x04, 0x00,
	0x7c, 0x82, 0x00, 0x10, 0xe5, 0x54, 0x00,
	0x7c, 0x82, 0x00, 0x00, 0x35, 0xff, 0x26,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f,
	/* ch = 'L' */
	0x2d, 0xcf, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0xd4, 0xcf, 0xcf, 0xcf, 0x1a,
	/* ch = 'M' */
	0x95, 0x40, 0x00, 0x00, 0x00, 0x8d, 0x45,
	0xb7, 0xec, 0x04, 0x00, 0x2a, 0xff, 0x54,
	0xb7, 0xff, 0x4c, 0x00, 0xa0, 0xff, 0x54,
	0xb7, 0xb7, 0xec, 0x2f, 0xdb, 0xbd, 0x54,
	0xb7, 0x54, 0xa7, 0xff, 0x3f, 0xb7, 0x54,
	0xb7, 0x54, 0x2c, 0xb7, 0x04, 0xb7, 0x54,
	0xb7, 0x54, 0x00, 0x00, 0x00, 0xb7, 0x54,
	0xb7, 0x54, 0x00, 0x00, 0x00, 0xb7, 0x54,
	0xb7, 0x54, 0x00, 0x00, 0x00, 0xb7, 0x54,
	/* ch = 'N' */
	0x67, 0x8d, 0x00, 0x00, 0x00, 0xcf, 0x2d,
	0x7c, 0xff, 0x35, 0x00, 0x00, 0xff, 0x35,
	0x7c, 0xff, 0xcf, 0x04, 0x00, 0xff, 0x35,
	0x7c, 0x88, 0xdb, 0x54, 0x00, 0xff, 0x35,
	0x7c, 0x82, 0x3b, 0xff, 0x10, 0xff, 0x35,
	0x7c, 0x82, 0x00, 0xb7, 0x70, 0xff, 0x35,
	0x7c, 0x82, 0x00, 0x2a, 0xff, 0xff, 0x35,
	0x7c, 0x82, 0x00, 0x00, 0x7c, 0xff, 0x35,
	0x7c, 0x82, 0x00, 0x00, 0x17, 0xf7, 0x35,
	/* ch = 'O' */
	0x00, 0x1b, 0x9e, 0xcf, 0x7f, 0x10, 0x00,
	0x1c, 0xf7, 0x48, 0x1a, 0x99, 0xb7, 0x04,
	0x6b, 0x90, 0x04, 0x00, 0x10, 0xff, 0x2f,
	0xb7, 0x50, 0x00, 0x00, 0x00, 0xb7, 0x54,
	0xc8, 0x35, 0x00, 0x00, 0x00, 0x7c, 0x7c,
	0xb7, 0x50, 0x00, 0x00, 0x00, 0x90, 0x59,
	0x7c, 0x82, 0x00, 0x00, 0x00, 0xe5, 0x3f,
	0x2a, 0xff, 0x24, 0x00, 0x50, 0xe5, 0x10,
	0x00, 0x44, 0xf7, 0xef, 0xe5, 0x28, 0x00,
	0x00, 0x00, 0x04, 0x15, 0x00, 0x00, 0x00,
	/* ch = 'P' */
	0x45, 0xcf, 0xcf, 0xcf, 0x74, 0x19, 0x00,
	0x50, 0xbd, 0x15, 0x15, 0x77, 0xff, 0x0d,
	0x50, 0xbd, 0x00, 0x00, 0x04, 0xff, 0x35,
	0x50, 0xbd, 0x00, 0x00, 0x1f, 0xff, 0x2c,
	0x50, 0xff, 0xcf, 0xcf, 0xef, 0x66, 0x04,
	0x50, 0xbd, 0x15, 0x15, 0x0c, 0x00, 0x00,
	0x50, 0xbd, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xbd, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xbd, 0x00, 0x00, 0x00, 0x00, 0x00,
	/* ch = 'Q' */
	0x00, 0x1b, 0x9e, 0xcf, 0x7f, 0x10, 0x00,
	0x1c, 0xf7, 0x3f, 0x15, 0x8a, 0xb7, 0x04,
	0x6b, 0x90, 0x00, 0x00, 0x0d, 0xf7, 0x2f,
	0xb7, 0x48, 0x00, 0x00, 0x00, 0xa0, 0x54,
	0xc8, 0x35, 0x00, 0x00, 0x00, 0x7c, 0x7c,
	0xb7, 0x48, 0x00, 0x00, 0x00, 0x82, 0x59,
	0x7c, 0x82, 0x00, 0x00, 0x00, 0xcf, 0x3f,
	0x2a, 0xff, 0x21, 0x00, 0x37, 0xf7, 0x10,
	0x00, 0x44, 0xf7, 0xdd, 0xef, 0x2f, 0x00,
	0x00, 0x00, 0x1a, 0xff, 0x13, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x85, 0xf7, 0xe5, 0x1f,
	/* ch = 'R' */
	0x45, 0xcf, 0xcf, 0xbd, 0x67, 0x13, 0x00,
	0x50, 0xbd, 0x15, 0x1a, 0x8a, 0xe5, 0x04,
	0x50, 0xbd, 0x00, 0x00, 0x1c, 0xff, 0x24,
	0x50, 0xbd, 0x00, 0x00, 0x2c, 0xff, 0x17,
	0x50, 0xff, 0xcf, 0xcf, 0xf7, 0x50, 0x00,
	0x50, 0xbd, 0x15, 0x90, 0x82, 0x00, 0x00,
	0x50, 0xbd, 0x00, 0x22, 0xff, 0x24, 0x00,
	0x50, 0xbd, 0x00, 0x00, 0x8a, 0x97, 0x00,
	0x50, 0xbd, 0x00, 0x00, 0x1c, 0xff, 0x26,
	/* ch = 'S' */
	0x00, 0x1b, 0x8f, 0xcf, 0x8f, 0x1b, 0x00,
	0x0d, 0xf7, 0x43, 0x0c, 0x3f, 0xdb, 0x09,
	0x32, 0xff, 0x10, 0x00, 0x00, 0x0f, 0x00,
	0x0d, 0xdb, 0x90, 0x0c, 0x00, 0x00, 0x00,
	0x00, 0x13, 0x7f, 0xff, 0x94, 0x13, 0x00,
	0x00, 0x00, 0x00, 0x0c, 0x77, 0xe5, 0x0d,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x35,
	0x32, 0x75, 0x04, 0x00, 0x26, 0xff, 0x24,
	0x1b, 0xbb, 0xf7, 0xcf, 0xf7, 0x48, 0x00,
	0x00, 0x00, 0x08, 0x15, 0x04, 0x00, 0x00,
	/* ch = 'T' */
	0x95, 0xcf, 0xcf, 0xcf, 0xcf, 0xcf, 0x45,
	0x12, 0x15, 0x5e, 0xbd, 0x15, 0x15, 0x0f,
	0x00, 0x00, 0x50, 0xbd, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x50, 0xbd, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x50, 0xbd, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x50, 0xbd, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x50, 0xbd, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x50, 0xbd, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x50, 0xbd, 0x00, 0x00, 0x00,
	/* ch = 'U' */
	0x67, 0x73, 0x00, 0x00, 0x00, 0x95, 0x2d,
	0x7c, 0x82, 0x00, 0x00, 0x00, 0xb7, 0x35,
	0x7c, 0x82, 0x00, 0x00, 0x00, 0xb7, 0x35,
	0x7c, 0x82, 0x00, 0x00, 0x00, 0xb7, 0x35,
	0x7c, 0x82, 0x00, 0x00, 0x00, 0xb7, 0x35,
	0x7c, 0x82, 0x00, 0x00, 0x00, 0xb7, 0x35,
	0x7c, 0x82, 0x00, 0x00, 0x00, 0xf7, 0x35,
	0x40, 0xec, 0x10, 0x00, 0x2c, 0xff, 0x1a,
	0x00, 0x73, 0xf7, 0xcf, 0xe5, 0x3f, 0x00,
	0x00, 0x00, 0x08, 0x15, 0x04, 0x00, 0x00,
	/* ch = 'V' */
	0xa4, 0x40, 0x00, 0x00, 0x00, 0x6c, 0x58,
	0x5f, 0xaf, 0x00, 0x00, 0x04, 0xf7, 0x2f,
	0x24, 0xff, 0x1a, 0x00, 0x2c, 0xe5, 0x08,
	0x00, 0xcf, 0x4c, 0x00, 0x70, 0x75, 0x00,
	0x00, 0x5a, 0xaf, 0x00, 0xe5, 0x2f, 0x00,
	0x00, 0x22, 0xff, 0x40, 0xe5, 0x08, 0x00,
	0x00, 0x00, 0xc8, 0xec, 0x75, 0x00, 0x00,
	0x00, 0x00, 0x5a, 0xff, 0x2f, 0x00, 0x00,
	0x00, 0x00, 0x22, 0xe5, 0x08, 0x00, 0x00,
	/* ch = 'W' */
	0xcf, 0x1a, 0x00, 0x00, 0x00, 0x2d, 0x8f,
	0xcf, 0x35, 0x04, 0xe5, 0x00, 0x50, 0x7c,
	0x90, 0x54, 0x2a, 0xff, 0x26, 0x77, 0x50,
	0x5f, 0x82, 0x5f, 0xff, 0x54, 0xa0, 0x35,
	0x44, 0xbd, 0xa0, 0x82, 0xa7, 0xcf, 0x1f,
	0x2a, 0xff, 0xf7, 0x24, 0xff, 0xff, 0x04,
	0x14, 0xff, 0x97, 0x00, 0xe5, 0xbd, 0x00,
	0x00, 0xe5, 0x48, 0x00, 0x7c, 0x88, 0x00,
	0x00, 0xa0, 0x21, 0x00, 0x3b, 0x59, 0x00,
	/* ch = 'X' */
	0x53, 0x8d, 0x00, 0x00, 0x1c, 0xcf, 0x17,
	0x10, 0xf7, 0x35, 0x00, 0x90, 0x75, 0x00,
	0x00, 0x50, 0xcf, 0x26, 0xff, 0x1a, 0x00,
	0x00, 0x04, 0xdb, 0xf7, 0x70, 0x00, 0x00,
	0x00, 0x00, 0x4a, 0xff, 0x24, 0x00, 0x00,
	0x00, 0x04, 0xc8, 0xff, 0x70, 0x00, 0x00,
	0x00, 0x44, 0xe5, 0x35, 0xff, 0x1f, 0x00,
	0x04, 0xdb, 0x48, 0x00, 0x90, 0x97, 0x00,
	0x54, 0xc8, 0x08, 0x00, 0x1c, 0xff, 0x2c,
	/* ch = 'Y' */
	0x8f, 0x60, 0x00, 0x00, 0x00, 0xab, 0x4a,
	0x2c, 0xff, 0x1a, 0x00, 0x2c, 0xf7, 0x10,
	0x00, 0xa7, 0x75, 0x00, 0xa7, 0x64, 0x00,
	0x00, 0x2c, 0xff, 0x35, 0xff, 0x1a, 0x00,
	0x00, 0x00, 0xa7, 0xff, 0x75, 0x00, 0x00,
	0x00, 0x00, 0x35, 0xff, 0x26, 0x00, 0x00,
	0x00, 0x00, 0x32, 0xff, 0x1f, 0x00, 0x00,
	0x00, 0x00, 0x32, 0xff, 0x1f, 0x00, 0x00,
	0x00, 0x00, 0x32, 0xff, 0x1f, 0x00, 0x00,
	/* ch = 'Z' */
	0x45, 0xcf, 0xcf, 0xcf, 0xcf, 0xcf, 0x2a,
	0x0c, 0x15, 0x15, 0x15, 0x58, 0xdb, 0x08,
	0x00, 0x00, 0x00, 0x10, 0xf7, 0x32, 0x00,
	0x00, 0x00, 0x00, 0x82, 0x90, 0x04, 0x00,
	0x00, 0x00, 0x2a, 0xf7, 0x1a, 0x00, 0x00,
	0x00, 0x04, 0xc8, 0x59, 0x00, 0x00, 0x00,
	0x00, 0x54, 0xdb, 0x08, 0x00, 0x00, 0x00,
	0x17, 0xf7, 0x32, 0x00, 0x00, 0x00, 0x00,
	0x77, 0xff, 0xd4, 0xcf, 0xcf, 0xd4, 0x54,
	/* ch = '[' */
	0x1e, 0x36, 0x36, 0x36, 0x2d,
	0x50, 0xa5, 0x36, 0x36, 0x30,
	0x50, 0x82, 0x00, 0x00, 0x00,
	0x50, 0x82, 0x00, 0x00, 0x00,
	0x50, 0x82, 0x00, 0x00, 0x00,
	0x50, 0x82, 0x00, 0x00, 0x00,
	0x50, 0x82, 0x00, 0x00, 0x00,
	0x50, 0x82, 0x00, 0x00, 0x00,
	0x50, 0x82, 0x00, 0x00, 0x00,
	0x50, 0x82, 0x00, 0x00, 0x00,
	0x50, 0xd1, 0x74, 0x74, 0x58,
	0x0c, 0x15, 0x15, 0x15, 0x15,
	/* ch = '\' */
	0x00, 0x22, 0x00,
	0x2a, 0xff, 0x17,
	0x00, 0xa7, 0x5f,
	0x00, 0x32, 0xff,
	0x00, 0x00, 0xc8,
	0x00, 0x00, 0x3b,
	0x00, 0x00, 0x04,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	/* ch = ']' */
	0x0d, 0x36, 0x36, 0x36, 0x36, 0x0d,
	0x0d, 0x36, 0x36, 0x36, 0xff, 0x1f,
	0x00, 0x00, 0x00, 0x00, 0xff, 0x1f,
	0x00, 0x00, 0x00, 0x00, 0xff, 0x1f,
	0x00, 0x00, 0x00, 0x00, 0xff, 0x1f,
	0x00, 0x00, 0x00, 0x00, 0xff, 0x1f,
	0x00, 0x00, 0x00, 0x00, 0xff, 0x1f,
	0x00, 0x00, 0x00, 0x00, 0xff, 0x1f,
	0x00, 0x00, 0x00, 0x00, 0xff, 0x1f,
	0x00, 0x00, 0x00, 0x00, 0xff, 0x1f,
	0x14, 0x74, 0x74, 0x74, 0xff, 0x1f,
	0x04, 0x15, 0x15, 0x15, 0x15, 0x08,
	/* ch = '^' */
	0x00, 0x10, 0x9c, 0x00, 0x00,
	0x00, 0x6b, 0xff, 0x3f, 0x00,
	0x24, 0xf7, 0x4a, 0xe5, 0x04,
	0xb1, 0x48, 0x00, 0xb7, 0x48,
	0x0c, 0x04, 0x00, 0x0c, 0x08,
	/* ch = '_' */
	0x95, 0xcf, 0xcf, 0xcf, 0xcf, 0xcf, 0x45,
	0x12, 0x15, 0x15, 0x15, 0x15, 0x15, 0x0f,
	/* ch = '`' */
	0x08, 0x22, 0x00,
	0x22, 0xff, 0x0d,
	0x00, 0xa7, 0x90,
	0x00, 0x2f, 0xef,
	/* ch = 'a' */
	0x00, 0x0c, 0x3e, 0x74, 0x30, 0x04, 0x00,
	0x00, 0xcb, 0x5a, 0x36, 0xa0, 0xa7, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x24, 0xff, 0x04,
	0x00, 0x28, 0x82, 0xcf, 0xd4, 0xff, 0x1f,
	0x36, 0xe5, 0x20, 0x00, 0x1c, 0xff, 0x1f,
	0x77, 0x9e, 0x00, 0x00, 0x59, 0xff, 0x1f,
	0x1f, 0xef, 0xab, 0xb3, 0xbb, 0xff, 0x1f,
	0x00, 0x00, 0x15, 0x0f, 0x00, 0x00, 0x00,
	/* ch = 'b' */
	0x1e, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xbd, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xbd, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xbd, 0x22, 0x67, 0x3f, 0x04, 0x00,
	0x50, 0xff, 0x94, 0x3e, 0xdb, 0xa7, 0x00,
	0x50, 0xf7, 0x08, 0x00, 0x26, 0xff, 0x26,
	0x50, 0xbd, 0x00, 0x00, 0x00, 0xff, 0x35,
	0x50, 0xbd, 0x00, 0x00, 0x04, 0xff, 0x35,
	0x50, 0xff, 0x1c, 0x00, 0x3f, 0xf7, 0x10,
	0x50, 0xb1, 0xef, 0xd4, 0xf7, 0x35, 0x00,
	0x00, 0x00, 0x00, 0x15, 0x08, 0x00, 0x00,
	/* ch = 'c' */
	0x00, 0x00, 0x25, 0x5b, 0x3e, 0x13, 0x00,
	0x00, 0x7c, 0xc4, 0x3e, 0x5a, 0xff, 0x1a,
	0x2c, 0xff, 0x1a, 0x00, 0x00, 0x22, 0x04,
	0x50, 0xbd, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x4d, 0xec, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x17, 0xf7, 0x54, 0x00, 0x04, 0x40, 0x04,
	0x00, 0x2c, 0xef, 0xe5, 0xe5, 0x94, 0x13,
	0x00, 0x00, 0x00, 0x15, 0x0f, 0x00, 0x00,
	/* ch = 'd' */
	0x00, 0x00, 0x00, 0x00, 0x0d, 0x36, 0x13,
	0x00, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x1f,
	0x00, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x1f,
	0x00, 0x13, 0x50, 0x67, 0x31, 0xff, 0x1f,
	0x10, 0xdb, 0x6a, 0x31, 0xdb, 0xff, 0x1f,
	0x5a, 0xa7, 0x04, 0x00, 0x3b, 0xff, 0x1f,
	0x7c, 0x82, 0x00, 0x00, 0x1c, 0xff, 0x1f,
	0x77, 0x88, 0x00, 0x00, 0x24, 0xff, 0x1f,
	0x39, 0xff, 0x1a, 0x00, 0x6f, 0xff, 0x1f,
	0x00, 0x84, 0xff, 0xdd, 0xa9, 0xff, 0x1f,
	0x00, 0x00, 0x0c, 0x0f, 0x00, 0x00, 0x00,
	/* ch = 'e' */
	0x00, 0x08, 0x3f, 0x74, 0x37, 0x04, 0x00,
	0x04, 0xd4, 0x77, 0x25, 0xb1, 0x7c, 0x00,
	0x44, 0xc8, 0x04, 0x00, 0x1f, 0xff, 0x17,
	0x7c, 0xf7, 0xcf, 0xcf, 0xd4, 0xff, 0x1f,
	0x6b, 0x97, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x2c, 0xff, 0x1f, 0x00, 0x04, 0x22, 0x00,
	0x00, 0x5a, 0xf7, 0xab, 0xe5, 0x66, 0x04,
	0x00, 0x00, 0x04, 0x15, 0x0c, 0x00, 0x00,
	/* ch = 'f' */
	0x00, 0x00, 0x00, 0x18, 0x36, 0x25,
	0x00, 0x00, 0x50, 0xdb, 0x3e, 0xbb,
	0x00, 0x00, 0xf7, 0x37, 0x00, 0x0d,
	0x00, 0x00, 0xff, 0x1f, 0x00, 0x00,
	0x45, 0xcf, 0xff, 0xd4, 0xcf, 0x2f,
	0x00, 0x00, 0xff, 0x1f, 0x00, 0x00,
	0x00, 0x00, 0xff, 0x1f, 0x00, 0x00,
	0x00, 0x00, 0xff, 0x1f, 0x00, 0x00,
	0x00, 0x00, 0xff, 0x1f, 0x00, 0x00,
	0x00, 0x00, 0xff, 0x1f, 0x00, 0x00,
	/* ch = 'g' */
	0x00, 0x19, 0x67, 0x67, 0x25, 0x50, 0x32,
	0x1c, 0xf7, 0x3f, 0x3f, 0xff, 0x45, 0x12,
	0x4d, 0xbd, 0x00, 0x00, 0xb7, 0x50, 0x00,
	0x2a, 0xff, 0x21, 0x21, 0xf7, 0x2c, 0x00,
	0x00, 0x9e, 0xd4, 0xbd, 0x37, 0x00, 0x00,
	0x27, 0xff, 0x1d, 0x15, 0x0f, 0x00, 0x00,
	0x0c, 0xea, 0xbd, 0xcf, 0xdd, 0xdb, 0x0d,
	0x8a, 0x59, 0x00, 0x00, 0x00, 0xd9, 0x35,
	0x66, 0xe5, 0x47, 0x36, 0x85, 0xd4, 0x10,
	0x00, 0x18, 0x36, 0x36, 0x25, 0x08, 0x00,
	/* ch = 'h' */
	0x16, 0x36, 0x09, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x16, 0x50, 0x50, 0x08, 0x00,
	0x32, 0xff, 0xdb, 0x3e, 0xb1, 0xa7, 0x00,
	0x32, 0xff, 0x21, 0x00, 0x32, 0xff, 0x04,
	0x32, 0xff, 0x04, 0x00, 0x32, 0xff, 0x04,
	0x32, 0xff, 0x04, 0x00, 0x32, 0xff, 0x04,
	0x32, 0xff, 0x04, 0x00, 0x32, 0xff, 0x04,
	0x32, 0xff, 0x04, 0x00, 0x32, 0xff, 0x04,
	/* ch = 'i' */
	0x00, 0x04, 0x12, 0x00, 0x00,
	0x00, 0x49, 0xff, 0x2a, 0x00,
	0x00, 0x04, 0x15, 0x04, 0x00,
	0x2d, 0x36, 0x36, 0x00, 0x00,
	0x2d, 0x62, 0xff, 0x04, 0x00,
	0x00, 0x32, 0xff, 0x04, 0x00,
	0x00, 0x32, 0xff, 0x04, 0x00,
	0x00, 0x32, 0xff, 0x04, 0x00,
	0x00, 0x32, 0xff, 0x04, 0x00,
	0xcf, 0xdd, 0xff, 0xd4, 0x45,
	/* ch = 'j' */
	0x00, 0x00, 0x00, 0x00, 0x15, 0x00,
	0x00, 0x00, 0x00, 0x2f, 0xff, 0x32,
	0x00, 0x00, 0x00, 0x04, 0x15, 0x08,
	0x00, 0x1e, 0x36, 0x36, 0x36, 0x0d,
	0x00, 0x1e, 0x36, 0x4a, 0xff, 0x1f,
	0x00, 0x00, 0x00, 0x1c, 0xff, 0x1f,
	0x00, 0x00, 0x00, 0x1c, 0xff, 0x1f,
	0x00, 0x00, 0x00, 0x1c, 0xff, 0x1f,
	0x00, 0x00, 0x00, 0x1c, 0xff, 0x1f,
	0x00, 0x00, 0x00, 0x1c, 0xff, 0x1f,
	0x0d, 0x19, 0x00, 0x2c, 0xff, 0x17,
	0x52, 0xe5, 0x50, 0xd4, 0x77, 0x00,
	0x00, 0x25, 0x36, 0x25, 0x04, 0x00,
	/* ch = 'k' */
	0x16, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x04, 0x00, 0x19, 0x36, 0x10,
	0x32, 0xff, 0x04, 0x21, 0xf7, 0x37, 0x00,
	0x32, 0xff, 0x2f, 0xef, 0x2f, 0x00, 0x00,
	0x32, 0xff, 0xff, 0xbd, 0x04, 0x00, 0x00,
	0x32, 0xff, 0x25, 0xdb, 0x82, 0x00, 0x00,
	0x32, 0xff, 0x04, 0x1f, 0xf7, 0x54, 0x00,
	0x32, 0xff, 0x04, 0x00, 0x32, 0xff, 0x35,
	/* ch = 'l' */
	0x0d, 0x36, 0x36, 0x36, 0x00, 0x00,
	0x14, 0x74, 0x9c, 0xff, 0x04, 0x00,
	0x00, 0x00, 0x32, 0xff, 0x04, 0x00,
	0x00, 0x00, 0x32, 0xff, 0x04, 0x00,
	0x00, 0x00, 0x32, 0xff, 0x04, 0x00,
	0x00, 0x00, 0x32, 0xff, 0x04, 0x00,
	0x00, 0x00, 0x32, 0xff, 0x04, 0x00,
	0x00, 0x00, 0x32, 0xff, 0x04, 0x00,
	0x00, 0x00, 0x32, 0xff, 0x04, 0x00,
	0x1a, 0xcf, 0xdd, 0xff, 0xd4, 0x95,
	/* ch = 'm' */
	0x2d, 0x30, 0x67, 0x22, 0x3f, 0x5b, 0x08,
	0xb7, 0xb7, 0x64, 0xff, 0x54, 0xc8, 0x50,
	0xb7, 0x54, 0x32, 0xff, 0x08, 0x7c, 0x82,
	0xb7, 0x54, 0x32, 0xff, 0x04, 0x7c, 0x82,
	0xb7, 0x54, 0x32, 0xff, 0x04, 0x7c, 0x82,
	0xb7, 0x54, 0x32, 0xff, 0x04, 0x7c, 0x82,
	0xb7, 0x54, 0x32, 0xff, 0x04, 0x7c, 0x82,
	/* ch = 'n' */
	0x16, 0x36, 0x13, 0x50, 0x50, 0x08, 0x00,
	0x32, 0xff, 0xdb, 0x3e, 0xc4, 0xa7, 0x00,
	0x32, 0xff, 0x1a, 0x00, 0x35, 0xff, 0x04,
	0x32, 0xff, 0x04, 0x00, 0x32, 0xff, 0x04,
	0x32, 0xff, 0x04, 0x00, 0x32, 0xff, 0x04,
	0x32, 0xff, 0x04, 0x00, 0x32, 0xff, 0x04,
	0x32, 0xff, 0x04, 0x00, 0x32, 0xff, 0x04,
	/* ch = 'o' */
	0x00, 0x04, 0x30, 0x74, 0x2a, 0x00, 0x00,
	0x04, 0xc4, 0x99, 0x36, 0xd4, 0x82, 0x00,
	0x50, 0xc8, 0x08, 0x00, 0x22, 0xff, 0x24,
	0x90, 0x82, 0x00, 0x00, 0x00, 0xf7, 0x3f,
	0x7c, 0x97, 0x00, 0x00, 0x00, 0xff, 0x37,
	0x39, 0xff, 0x1f, 0x00, 0x35, 0xf7, 0x10,
	0x00, 0x5a, 0xff, 0xcf, 0xef, 0x35, 0x00,
	0x00, 0x00, 0x08, 0x15, 0x08, 0x00, 0x00,
	/* ch = 'p' */
	0x1e, 0x2d, 0x22, 0x5b, 0x37, 0x04, 0x00,
	0x50, 0xff, 0x94, 0x36, 0xc4, 0xb7, 0x00,
	0x50, 0xe5, 0x08, 0x00, 0x22, 0xff, 0x32,
	0x50, 0xbd, 0x00, 0x00, 0x00, 0xf7, 0x54,
	0x50, 0xbd, 0x00, 0x00, 0x00, 0xff, 0x48,
	0x50, 0xff, 0x1c, 0x00, 0x35, 0xff, 0x1a,
	0x50, 0xe5, 0xef, 0xcf, 0xf7, 0x48, 0x00,
	0x50, 0xbd, 0x04, 0x15, 0x0c, 0x00, 0x00,
	0x50, 0xbd, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1e, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00,
	/* ch = 'q' */
	0x00, 0x0c, 0x50, 0x67, 0x28, 0x36, 0x0d,
	0x10, 0xdb, 0x6a, 0x2a, 0xdb, 0xff, 0x1f,
	0x5a, 0xa7, 0x04, 0x00, 0x32, 0xff, 0x1f,
	0x7c, 0x82, 0x00, 0x00, 0x1c, 0xff, 0x1f,
	0x7c, 0x88, 0x00, 0x00, 0x1f, 0xff, 0x1f,
	0x39, 0xff, 0x1f, 0x00, 0x5f, 0xff, 0x1f,
	0x00, 0x77, 0xff, 0xdd, 0xbb, 0xff, 0x1f,
	0x00, 0x00, 0x0c, 0x0f, 0x1c, 0xff, 0x1f,
	0x00, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x1f,
	0x00, 0x00, 0x00, 0x00, 0x0d, 0x36, 0x10,
	/* ch = 'r' */
	0x36, 0x21, 0x2a, 0x74, 0x37, 0x04,
	0xff, 0xff, 0x99, 0x36, 0xc4, 0x24,
	0xff, 0xb7, 0x04, 0x00, 0x0c, 0x04,
	0xff, 0x48, 0x00, 0x00, 0x00, 0x00,
	0xff, 0x35, 0x00, 0x00, 0x00, 0x00,
	0xff, 0x35, 0x00, 0x00, 0x00, 0x00,
	0xff, 0x35, 0x00, 0x00, 0x00, 0x00,
	/* ch = 's' */
	0x00, 0x08, 0x3e, 0x74, 0x3e, 0x08, 0x00,
	0x00, 0xc0, 0x7c, 0x1a, 0x77, 0xc8, 0x00,
	0x14, 0xff, 0x4f, 0x00, 0x00, 0x22, 0x00,
	0x00, 0x35, 0xe5, 0xef, 0x73, 0x13, 0x00,
	0x00, 0x00, 0x00, 0x1e, 0x99, 0xe5, 0x04,
	0x1c, 0x65, 0x04, 0x00, 0x26, 0xff, 0x17,
	0x19, 0xbb, 0xef, 0xcf, 0xef, 0x48, 0x00,
	0x00, 0x00, 0x08, 0x15, 0x08, 0x00, 0x00,
	/* ch = 't' */
	0x00, 0x00, 0x0f, 0x0f, 0x00, 0x00,
	0x00, 0x00, 0x90, 0x70, 0x00, 0x00,
	0x16, 0x36, 0xcf, 0x87, 0x36, 0x1e,
	0x16, 0x36, 0xcf, 0x82, 0x36, 0x21,
	0x00, 0x00, 0xe5, 0x37, 0x00, 0x00,
	0x00, 0x00, 0xff, 0x35, 0x00, 0x00,
	0x00, 0x00, 0xff, 0x35, 0x00, 0x00,
	0x00, 0x00, 0xe5, 0x5f, 0x00, 0x22,
	0x00, 0x00, 0x4d, 0xff, 0xe5, 0xcb,
	0x00, 0x00, 0x00, 0x08, 0x0c, 0x00,
	/* ch = 'u' */
	0x1e, 0x2d, 0x00, 0x00, 0x16, 0x36, 0x0d,
	0x50, 0xbd, 0x00, 0x00, 0x32, 0xff, 0x1f,
	0x50, 0xbd, 0x00, 0x00, 0x32, 0xff, 0x1f,
	0x50, 0xbd, 0x00, 0x00, 0x32, 0xff, 0x1f,
	0x50, 0xc6, 0x00, 0x00, 0x32, 0xff, 0x1f,
	0x2f, 0xff, 0x1a, 0x00, 0x70, 0xff, 0x1f,
	0x00, 0x94, 0xf7, 0xd4, 0xcb, 0xff, 0x1f,
	0x00, 0x00, 0x0f, 0x0f, 0x00, 0x00, 0x00,
	/* ch = 'v' */
	0x2b, 0x2b, 0x00, 0x00, 0x00, 0x30, 0x16,
	0x44, 0xec, 0x04, 0x00, 0x0d, 0xff, 0x17,
	0x0d, 0xf7, 0x3b, 0x00, 0x44, 0xa7, 0x04,
	0x00, 0x70, 0x97, 0x00, 0xa7, 0x3b, 0x00,
	0x00, 0x24, 0xff, 0x40, 0xe5, 0x08, 0x00,
	0x00, 0x00, 0xc8, 0xff, 0x5f, 0x00, 0x00,
	0x00, 0x00, 0x48, 0xff, 0x1a, 0x00, 0x00,
	/* ch = 'w' */
	0x36, 0x13, 0x00, 0x00, 0x00, 0x1e, 0x26,
	0xe5, 0x2c, 0x1c, 0xbd, 0x00, 0x54, 0x70,
	0x90, 0x50, 0x3b, 0xff, 0x26, 0x7c, 0x50,
	0x54, 0x88, 0x77, 0xe5, 0x64, 0xb1, 0x32,
	0x2f, 0xd9, 0xcf, 0x48, 0xbd, 0xe5, 0x1c,
	0x1a, 0xff, 0xb7, 0x10, 0xff, 0xe5, 0x04,
	0x00, 0xe5, 0x64, 0x00, 0xa0, 0xa7, 0x00,
	/* ch = 'x' */
	0x24, 0x30, 0x00, 0x00, 0x19, 0x33, 0x09,
	0x10, 0xdb, 0x48, 0x04, 0xb7, 0x54, 0x00,
	0x00, 0x2f, 0xff, 0x7c, 0xb1, 0x08, 0x00,
	0x00, 0x00, 0x70, 0xff, 0x24, 0x00, 0x00,
	0x00, 0x04, 0xdb, 0xf7, 0x70, 0x00, 0x00,
	0x00, 0x77, 0xb1, 0x21, 0xf7, 0x35, 0x00,
	0x32, 0xf7, 0x1f, 0x00, 0x4d, 0xe5, 0x10,
	/* ch = 'y' */
	0x24, 0x2d, 0x00, 0x00, 0x00, 0x36, 0x1c,
	0x2c, 0xff, 0x0d, 0x00, 0x14, 0xff, 0x1f,
	0x04, 0xe5, 0x4c, 0x00, 0x48, 0xb7, 0x04,
	0x00, 0x5a, 0xcf, 0x00, 0xa7, 0x4c, 0x00,
	0x00, 0x17, 0xff, 0x3f, 0xff, 0x10, 0x00,
	0x00, 0x00, 0x8a, 0xff, 0x90, 0x00, 0x00,
	0x00, 0x00, 0x2c, 0xff, 0x2f, 0x00, 0x00,
	0x00, 0x00, 0x32, 0xe5, 0x08, 0x00, 0x00,
	0xa0, 0x54, 0xdb, 0x50, 0x00, 0x00, 0x00,
	0x1e, 0x36, 0x25, 0x00, 0x00, 0x00, 0x00,
	/* ch = 'z' */
	0x16, 0x36, 0x36, 0x36, 0x36, 0x36, 0x00,
	0x16, 0x36, 0x36, 0x36, 0xc4, 0xb1, 0x04,
	0x00, 0x00, 0x00, 0x50, 0xdb, 0x13, 0x00,
	0x00, 0x00, 0x32, 0xf7, 0x21, 0x00, 0x00,
	0x00, 0x1f, 0xf7, 0x35, 0x00, 0x00, 0x00,
	0x10, 0xdb, 0x64, 0x00, 0x00, 0x00, 0x00,
	0x77, 0xff, 0xdd, 0xcf, 0xcf, 0xdd, 0x35,
	/* ch = '{' */
	0x1f, 0xbd, 0xd4, 0x6c,
	0xc8, 0x4f, 0x00, 0x00,
	0xff, 0x35, 0x00, 0x00,
	0xff, 0x35, 0x00, 0x00,
	0xf7, 0x10, 0x00, 0x00,
	0x36, 0x00, 0x00, 0x00,
	0xff, 0x14, 0x00, 0x00,
	0xff, 0x2a, 0x00, 0x00,
	0xff, 0x1f, 0x00, 0x00,
	0xff, 0x35, 0x00, 0x00,
	0x73, 0xf7, 0x74, 0x42,
	0x00, 0x0f, 0x15, 0x12,
	/* ch = '|' */
	0x08, 0x15, 0x00,
	0x32, 0xff, 0x04,
	0x32, 0xff, 0x04,
	0x32, 0xff, 0x04,
	0x32, 0xff, 0x04,
	0x32, 0xff, 0x04,
	0x32, 0xff, 0x04,
	0x32, 0xff, 0x04,
	0x32, 0xff, 0x04,
	0x32, 0xff, 0x04,
	0x32, 0xff, 0x04,
	0x32, 0xff, 0x04,
	0x08, 0x15, 0x04,
	/* ch = '}' */
	0xcf, 0xdd, 0x8d, 0x0d,
	0x00, 0x04, 0xa7, 0x5f,
	0x00, 0x00, 0x7c, 0x82,
	0x00, 0x00, 0x77, 0x82,
	0x00, 0x00, 0x39, 0xcf,
	0x00, 0x00, 0x00, 0x7f,
	0x00, 0x00, 0x40, 0xcf,
	0x00, 0x00, 0x5a, 0x82,
	0x00, 0x00, 0x50, 0xbd,
	0x00, 0x00, 0x7c, 0x88,
	0x74, 0x8f, 0xf7, 0x32,
	0x15, 0x15, 0x0c, 0x00,
	/* ch = '~' */
	0x00, 0x2a, 0x50, 0x1b, 0x00, 0x19, 0x10,
	0x5b, 0xc4, 0x4f, 0xf7, 0x73, 0xdb, 0x35,
	0x04, 0x0c, 0x00, 0x1b, 0x36, 0x20, 0x00
};

/* font_inconsolata_15px */
static const unsigned char font_bitmap_15px_bytes[] = {
	/* ch = '!' */
	0x39, 0xff, 0x27,
	0x50, 0xff, 0x32,
	0x32, 0xff, 0x32,
	0x32, 0xff, 0x1c,
	0x24, 0xff, 0x1c,
	0x1c, 0xff, 0x0d,
	0x1c, 0xff, 0x00,
	0x00, 0x00, 0x00,
	0x1f, 0x74, 0x10,
	0x66, 0xff, 0x40,
	0x04, 0x15, 0x00,
	/* ch = '"' */
	0x22, 0xff, 0x27, 0x66, 0xb1,
	0x1f, 0xff, 0x2a, 0x7c, 0xbd,
	0x32, 0xe5, 0x04, 0x90, 0x5f,
	0x46, 0x60, 0x00, 0xa5, 0x22,
	/* ch = '#' */
	0x00, 0x00, 0x28, 0x1e, 0x04, 0x2a, 0x00, 0x00,
	0x00, 0x00, 0xb7, 0x3b, 0x2f, 0xff, 0x00, 0x00,
	0x00, 0x00, 0xf7, 0x2f, 0x3b, 0xb7, 0x00, 0x00,
	0x6c, 0xcf, 0xff, 0xb1, 0xcf, 0xe5, 0xa2, 0x11,
	0x00, 0x1c, 0xff, 0x04, 0x7c, 0x6b, 0x00, 0x00,
	0x00, 0x32, 0xcf, 0x00, 0xa0, 0x50, 0x00, 0x00,
	0x5c, 0x9c, 0xe5, 0x74, 0xe5, 0x9c, 0x58, 0x00,
	0x15, 0x62, 0x88, 0x15, 0xff, 0x24, 0x00, 0x00,
	0x00, 0x7c, 0x54, 0x1a, 0xff, 0x1a, 0x00, 0x00,
	0x00, 0x8f, 0x3e, 0x1f, 0xcf, 0x00, 0x00, 0x00,
	/* ch = '$' */
	0x00, 0x00, 0x00, 0x95, 0x3a, 0x00, 0x00,
	0x00, 0x19, 0x9e, 0xf7, 0xdd, 0x66, 0x04,
	0x04, 0xdb, 0x54, 0xb7, 0x3a, 0xa0, 0x49,
	0x1a, 0xff, 0x26, 0xb7, 0x32, 0x00, 0x00,
	0x00, 0x7c, 0xef, 0xe5, 0x32, 0x00, 0x00,
	0x00, 0x00, 0x31, 0xe5, 0xff, 0x8d, 0x10,
	0x00, 0x00, 0x00, 0xb7, 0x37, 0xb1, 0x8a,
	0x00, 0x21, 0x00, 0xb7, 0x32, 0x50, 0xb7,
	0x2d, 0xf7, 0x37, 0xbd, 0x4f, 0xdb, 0x4d,
	0x00, 0x22, 0x8f, 0xf7, 0xbb, 0x37, 0x00,
	0x00, 0x00, 0x00, 0x58, 0x22, 0x00, 0x00,
	/* ch = '%' */
	0x08, 0x47, 0x37, 0x04, 0x00, 0x21, 0x2b,
	0x8a, 0x8a, 0xb1, 0x5a, 0x04, 0xdb, 0x3b,
	0xb7, 0x32, 0x50, 0xa9, 0x50, 0xb7, 0x00,
	0x6b, 0xa0, 0xb7, 0x5f, 0xf7, 0x2a, 0x00,
	0x04, 0x30, 0x2a, 0x6b, 0x90, 0x00, 0x00,
	0x00, 0x00, 0x1c, 0xff, 0x1c, 0x00, 0x00,
	0x00, 0x00, 0x90, 0x6b, 0x50, 0xbd, 0x35,
	0x00, 0x2a, 0xf7, 0x3f, 0xe5, 0x24, 0xff,
	0x00, 0xb7, 0x50, 0x44, 0xbd, 0x04, 0xff,
	0x3b, 0xdb, 0x04, 0x10, 0xdb, 0xc4, 0xa9,
	0x00, 0x00, 0x00, 0x00, 0x04, 0x15, 0x00,
	/* ch = '&' */
	0x00, 0x00, 0x2a, 0x36, 0x13, 0x00, 0x00, 0x00,
	0x00, 0x77, 0xdb, 0x85, 0xf7, 0x17, 0x00, 0x00,
	0x00, 0xef, 0x47, 0x00, 0xd9, 0x40, 0x00, 0x00,
	0x00, 0x8a, 0x90, 0x17, 0xff, 0x22, 0x00, 0x00,
	0x00, 0x1f, 0xff, 0xef, 0x4d, 0x00, 0x00, 0x00,
	0x04, 0x94, 0xef, 0xf7, 0x1f, 0x04, 0x0c, 0x00,
	0x48, 0xf7, 0x10, 0x7c, 0xb1, 0x2f, 0xf7, 0x0a,
	0xa0, 0x82, 0x00, 0x0d, 0xdb, 0xff, 0x54, 0x00,
	0x7c, 0xc8, 0x08, 0x08, 0xb1, 0xff, 0x35, 0x00,
	0x1f, 0xd4, 0xef, 0xf7, 0x7e, 0x59, 0xd4, 0x0a,
	0x00, 0x00, 0x15, 0x08, 0x00, 0x04, 0x08, 0x00,
	/* ch = ''' */
	0x00, 0x99, 0x84,
	0x00, 0xb7, 0x82,
	0x00, 0xcf, 0x3b,
	0x11, 0xbd, 0x0d,
	/* ch = '(' */
	0x00, 0x00, 0x35, 0xef,
	0x00, 0x50, 0xf7, 0x26,
	0x2a, 0xff, 0x2c, 0x00,
	0xa0, 0x8a, 0x00, 0x00,
	0xff, 0x32, 0x00, 0x00,
	0xff, 0x1c, 0x00, 0x00,
	0xff, 0x1c, 0x00, 0x00,
	0xff, 0x2a, 0x00, 0x00,
	0xc8, 0x64, 0x00, 0x00,
	0x44, 0xf7, 0x10, 0x00,
	0x04, 0xb1, 0xb1, 0x04,
	0x00, 0x10, 0xc4, 0xc4,
	0x00, 0x00, 0x04, 0x51,
	/* ch = ')' */
	0xe5, 0x35, 0x00, 0x00,
	0x3f, 0xf7, 0x50, 0x00,
	0x00, 0x32, 0xff, 0x2f,
	0x00, 0x00, 0x70, 0xc8,
	0x00, 0x00, 0x24, 0xff,
	0x00, 0x00, 0x00, 0xff,
	0x00, 0x00, 0x00, 0xff,
	0x00, 0x00, 0x0d, 0xff,
	0x00, 0x00, 0x39, 0xf7,
	0x00, 0x04, 0xc8, 0x6b,
	0x04, 0x7c, 0xdb, 0x10,
	0xa9, 0xd4, 0x19, 0x00,
	0x50, 0x08, 0x00, 0x00,
	/* ch = '*' */
	0x00, 0x00, 0x17, 0xcf, 0x2d, 0x00, 0x00,
	0x08, 0x08, 0x00, 0xff, 0x24, 0x04, 0x0c,
	0x58, 0xf7, 0x66, 0xff, 0x6b, 0xe5, 0x87,
	0x00, 0x0c, 0x51, 0xff, 0x6c, 0x0c, 0x00,
	0x00, 0x10, 0xdb, 0x54, 0xf7, 0x1f, 0x00,
	0x00, 0xa9, 0x7c, 0x00, 0x54, 0xdb, 0x09,
	0x00, 0x1b, 0x10, 0x00, 0x04, 0x21, 0x00,
	/* ch = '+' */
	0x00, 0x00, 0x00, 0xcf, 0x2d, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xff, 0x32, 0x00, 0x00,
	0x0f, 0x15, 0x15, 0xff, 0x3e, 0x15, 0x12,
	0x42, 0x74, 0x74, 0xff, 0x9c, 0x74, 0x58,
	0x00, 0x00, 0x00, 0xff, 0x32, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xff, 0x32, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x36, 0x16, 0x00, 0x00,
	/* ch = ',' */
	0x19, 0x5b, 0x10,
	0x66, 0xff, 0x5a,
	0x04, 0xea, 0x39,
	0x35, 0xb1, 0x04,
	0x3d, 0x10, 0x00,
	/* ch = '-' */
	0x08, 0x15, 0x15, 0x15, 0x15, 0x15, 0x0c,
	0x2d, 0xcf, 0xcf, 0xcf, 0xcf, 0xcf, 0x45,
	/* ch = '.' */
	0x19, 0x67, 0x10,
	0x66, 0xff, 0x40,
	0x04, 0x15, 0x00,
	/* ch = '/' */
	0x00, 0xc0, 0x33,
	0x39, 0xf7, 0x10,
	0xa7, 0x70, 0x00,
	0xff, 0x17, 0x00,
	0x8a, 0x00, 0x00,
	0x22, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	/* ch = '0' */
	0x00, 0x00, 0x16, 0x36, 0x1e, 0x00, 0x00,
	0x00, 0x32, 0xef, 0x82, 0xef, 0x50, 0x00,
	0x04, 0xe5, 0x3b, 0x00, 0x26, 0xff, 0x17,
	0x32, 0xe5, 0x04, 0x00, 0x7c, 0xff, 0x50,
	0x50, 0xb7, 0x00, 0x50, 0xdb, 0x97, 0x7c,
	0x50, 0x90, 0x24, 0xf7, 0x1f, 0x54, 0x7c,
	0x50, 0xcf, 0xdb, 0x3b, 0x00, 0x7c, 0x7c,
	0x2a, 0xff, 0x7c, 0x00, 0x00, 0xb7, 0x4d,
	0x00, 0xb7, 0x7c, 0x00, 0x32, 0xf7, 0x17,
	0x00, 0x1f, 0xd4, 0xdd, 0xf7, 0x32, 0x00,
	0x00, 0x00, 0x00, 0x15, 0x08, 0x00, 0x00,
	/* ch = '1' */
	0x00, 0x00, 0x2a, 0x1e,
	0x31, 0xd4, 0xff, 0x50,
	0x48, 0x20, 0xb7, 0x50,
	0x00, 0x00, 0xb7, 0x50,
	0x00, 0x00, 0xb7, 0x50,
	0x00, 0x00, 0xb7, 0x50,
	0x00, 0x00, 0xb7, 0x50,
	0x00, 0x00, 0xb7, 0x50,
	0x00, 0x00, 0xb7, 0x50,
	0x00, 0x00, 0xb7, 0x50,
	/* ch = '2' */
	0x00, 0x00, 0x1e, 0x36, 0x25, 0x00, 0x00,
	0x00, 0x77, 0xd4, 0x74, 0xdb, 0xa9, 0x04,
	0x04, 0x7e, 0x10, 0x00, 0x10, 0xff, 0x39,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0x4d,
	0x00, 0x00, 0x00, 0x00, 0x2a, 0xff, 0x1c,
	0x00, 0x00, 0x00, 0x1f, 0xef, 0x50, 0x00,
	0x00, 0x00, 0x1f, 0xf7, 0x4d, 0x00, 0x00,
	0x00, 0x10, 0xdb, 0x50, 0x00, 0x00, 0x00,
	0x00, 0xa0, 0x82, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7c,
	/* ch = '3' */
	0x00, 0x00, 0x20, 0x36, 0x18, 0x00, 0x00,
	0x00, 0x9c, 0xcb, 0x82, 0xf7, 0x50, 0x00,
	0x00, 0x0c, 0x04, 0x00, 0x2c, 0xff, 0x14,
	0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0x14,
	0x00, 0x00, 0x16, 0x3e, 0xdb, 0x4d, 0x00,
	0x00, 0x00, 0x42, 0x82, 0xe5, 0x4d, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x24, 0xff, 0x22,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x32,
	0x04, 0x8d, 0x13, 0x00, 0x37, 0xff, 0x17,
	0x08, 0x94, 0xf7, 0xd4, 0xf7, 0x3b, 0x00,
	0x00, 0x00, 0x0c, 0x15, 0x04, 0x00, 0x00,
	/* ch = '4' */
	0x00, 0x00, 0x00, 0x00, 0x28, 0x1e, 0x00,
	0x00, 0x00, 0x00, 0x1f, 0xff, 0x50, 0x00,
	0x00, 0x00, 0x04, 0xb7, 0xff, 0x50, 0x00,
	0x00, 0x00, 0x54, 0x90, 0xb7, 0x50, 0x00,
	0x00, 0x1f, 0xf7, 0x10, 0xb7, 0x50, 0x00,
	0x04, 0xb7, 0x3b, 0x00, 0xb7, 0x50, 0x00,
	0x50, 0xec, 0x74, 0x74, 0xe5, 0xb1, 0x58,
	0x26, 0x36, 0x36, 0x36, 0xcf, 0x82, 0x2d,
	0x00, 0x00, 0x00, 0x00, 0xb7, 0x50, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xb7, 0x50, 0x00,
	/* ch = '5' */
	0x00, 0x28, 0x36, 0x36, 0x36, 0x36, 0x16,
	0x00, 0xb7, 0xb1, 0x74, 0x74, 0x74, 0x22,
	0x00, 0xb7, 0x44, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xf7, 0x32, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xff, 0xf7, 0xd4, 0xf7, 0x5a, 0x00,
	0x00, 0x67, 0x21, 0x00, 0x21, 0xff, 0x39,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xb1, 0x77,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xb1, 0x77,
	0x13, 0xd4, 0x21, 0x00, 0x1f, 0xff, 0x39,
	0x00, 0x66, 0xf7, 0xcf, 0xf7, 0x66, 0x00,
	0x00, 0x00, 0x04, 0x15, 0x08, 0x00, 0x00,
	/* ch = '6' */
	0x00, 0x00, 0x08, 0x30, 0x36, 0x16, 0x00,
	0x00, 0x1f, 0xdb, 0xa4, 0x73, 0xef, 0x1e,
	0x00, 0xa0, 0x82, 0x00, 0x00, 0x0c, 0x00,
	0x14, 0xff, 0x2a, 0x00, 0x00, 0x00, 0x00,
	0x2a, 0xff, 0xa2, 0xff, 0xf7, 0x44, 0x00,
	0x32, 0xff, 0x70, 0x04, 0x21, 0xff, 0x2a,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0xb7, 0x50,
	0x1a, 0xff, 0x24, 0x00, 0x00, 0xb7, 0x54,
	0x00, 0xb7, 0x82, 0x00, 0x1f, 0xff, 0x2c,
	0x00, 0x1f, 0xd4, 0xdd, 0xf7, 0x5a, 0x00,
	0x00, 0x00, 0x00, 0x12, 0x0c, 0x00, 0x00,
	/* ch = '7' */
	0x0d, 0x36, 0x36, 0x36, 0x36, 0x36, 0x1e,
	0x14, 0x74, 0x74, 0x74, 0x8d, 0xff, 0x39,
	0x00, 0x00, 0x00, 0x00, 0x50, 0xe5, 0x04,
	0x00, 0x00, 0x00, 0x00, 0xc8, 0x5a, 0x00,
	0x00, 0x00, 0x00, 0x2c, 0xff, 0x17, 0x00,
	0x00, 0x00, 0x00, 0x8a, 0x90, 0x00, 0x00,
	0x00, 0x00, 0x0d, 0xff, 0x39, 0x00, 0x00,
	0x00, 0x00, 0x44, 0xf7, 0x0d, 0x00, 0x00,
	0x00, 0x00, 0xa7, 0x8a, 0x00, 0x00, 0x00,
	0x00, 0x17, 0xff, 0x39, 0x00, 0x00, 0x00,
	/* ch = '8' */
	0x00, 0x00, 0x1e, 0x36, 0x30, 0x04, 0x00,
	0x00, 0x50, 0xef, 0x50, 0xc4, 0xb1, 0x04,
	0x00, 0xe5, 0x3b, 0x00, 0x17, 0xff, 0x2f,
	0x00, 0xc8, 0x5f, 0x00, 0x24, 0xff, 0x17,
	0x00, 0x2c, 0xf7, 0x85, 0xdb, 0x4d, 0x00,
	0x00, 0x2c, 0xe5, 0x8f, 0xf7, 0x5a, 0x00,
	0x17, 0xf7, 0x35, 0x00, 0x1f, 0xff, 0x39,
	0x39, 0xff, 0x00, 0x00, 0x00, 0xb7, 0x77,
	0x27, 0xff, 0x37, 0x00, 0x19, 0xf7, 0x40,
	0x00, 0x44, 0xf7, 0xd4, 0xf7, 0x66, 0x00,
	0x00, 0x00, 0x04, 0x15, 0x08, 0x00, 0x00,
	/* ch = '9' */
	0x00, 0x00, 0x1e, 0x36, 0x22, 0x00, 0x00,
	0x00, 0x50, 0xef, 0x74, 0xef, 0x73, 0x00,
	0x14, 0xff, 0x2c, 0x00, 0x24, 0xff, 0x22,
	0x32, 0xff, 0x04, 0x00, 0x00, 0xcf, 0x44,
	0x24, 0xff, 0x22, 0x00, 0x04, 0xcf, 0x50,
	0x00, 0xa0, 0xc4, 0x36, 0x99, 0xff, 0x50,
	0x00, 0x04, 0x48, 0x74, 0x37, 0xbd, 0x50,
	0x00, 0x00, 0x00, 0x00, 0x0d, 0xff, 0x2a,
	0x00, 0x3d, 0x04, 0x00, 0x6f, 0xdb, 0x04,
	0x09, 0xa9, 0xef, 0xe5, 0xd4, 0x19, 0x00,
	0x00, 0x00, 0x0f, 0x12, 0x00, 0x00, 0x00,
	/* ch = ':' */
	0x08, 0x30, 0x04,
	0x73, 0xff, 0x49,
	0x10, 0x36, 0x04,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x19, 0x67, 0x10,
	0x66, 0xff, 0x40,
	0x04, 0x15, 0x00,
	/* ch = ';' */
	0x08, 0x30, 0x04,
	0x73, 0xff, 0x49,
	0x10, 0x36, 0x04,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x19, 0x5b, 0x10,
	0x66, 0xff, 0x5a,
	0x04, 0xea, 0x39,
	0x35, 0xb1, 0x04,
	0x3d, 0x10, 0x00,
	/* ch = '<' */
	0x00, 0x00, 0x00, 0x04, 0x3d,
	0x00, 0x04, 0x3f, 0xef, 0x8d,
	0x37, 0xd4, 0xb3, 0x1e, 0x00,
	0xbb, 0x22, 0x00, 0x00, 0x00,
	0x28, 0x00, 0x00, 0x00, 0x00,
	0xd4, 0xb3, 0x1b, 0x00, 0x00,
	0x04, 0x50, 0xf7, 0x73, 0x13,
	0x00, 0x00, 0x13, 0x94, 0xb7,
	0x00, 0x00, 0x00, 0x00, 0x0c,
	/* ch = '=' */
	0x42, 0x74, 0x74, 0x74, 0x74, 0x74, 0x58,
	0x26, 0x36, 0x36, 0x36, 0x36, 0x36, 0x2d,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x26, 0x36, 0x36, 0x36, 0x36, 0x36, 0x2d,
	0x26, 0x36, 0x36, 0x36, 0x36, 0x36, 0x2d,
	/* ch = '>' */
	0x08, 0x00, 0x00, 0x00, 0x00,
	0xf7, 0x5a, 0x08, 0x00, 0x00,
	0x16, 0x8d, 0xef, 0x48, 0x04,
	0x00, 0x00, 0x1b, 0x94, 0xef,
	0x00, 0x00, 0x00, 0x1b, 0xc8,
	0x00, 0x13, 0x8d, 0xef, 0x37,
	0x5a, 0xf7, 0x73, 0x08, 0x00,
	0xbb, 0x1b, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00,
	/* ch = '?' */
	0x00, 0x28, 0xc4, 0xff, 0xe5, 0x44, 0x00,
	0x22, 0xff, 0x48, 0x04, 0x54, 0xff, 0x27,
	0x00, 0x0f, 0x00, 0x00, 0x04, 0xff, 0x50,
	0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0x39,
	0x00, 0x00, 0x00, 0x19, 0xdb, 0x7c, 0x00,
	0x00, 0x00, 0x00, 0x99, 0x82, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xff, 0x32, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x15, 0x08, 0x00, 0x00,
	0x00, 0x00, 0x04, 0x50, 0x21, 0x00, 0x00,
	0x00, 0x00, 0x27, 0xff, 0x99, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x12, 0x08, 0x00, 0x00,
	/* ch = '@' */
	0x00, 0x00, 0x1b, 0x36, 0x36, 0x0c, 0x00,
	0x00, 0x4d, 0xd4, 0x3e, 0x5a, 0xef, 0x1f,
	0x2a, 0xf7, 0x10, 0x00, 0x00, 0x50, 0xa0,
	0x6b, 0x5f, 0x00, 0x22, 0x74, 0x9c, 0xf7,
	0xb7, 0x35, 0x39, 0xdb, 0x25, 0x3a, 0xff,
	0xb7, 0x32, 0x7c, 0x6f, 0x00, 0x35, 0xff,
	0xa0, 0x4d, 0x44, 0xdb, 0x3e, 0xc4, 0xff,
	0x50, 0xa7, 0x00, 0x2a, 0x50, 0x30, 0x36,
	0x0d, 0xdb, 0x54, 0x00, 0x00, 0x08, 0x04,
	0x00, 0x19, 0xbb, 0xe5, 0xcf, 0xe5, 0x2d,
	0x00, 0x00, 0x00, 0x0f, 0x15, 0x04, 0x00,
	/* ch = 'A' */
	0x00, 0x00, 0x00, 0x36, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x1c, 0xf7, 0x0d, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x50, 0xff, 0x3b, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xc8, 0xc0, 0xa7, 0x00, 0x00, 0x00,
	0x00, 0x22, 0xf7, 0x24, 0xff, 0x1c, 0x00, 0x00,
	0x00, 0x5a, 0x8a, 0x00, 0xa7, 0x5a, 0x00, 0x00,
	0x00, 0xcf, 0xb1, 0x74, 0xb1, 0xe5, 0x00, 0x00,
	0x24, 0xff, 0x21, 0x15, 0x21, 0xff, 0x2c, 0x00,
	0x6b, 0xa0, 0x00, 0x00, 0x00, 0x90, 0x8a, 0x00,
	0xe5, 0x44, 0x00, 0x00, 0x00, 0x39, 0xf7, 0x0d,
	/* ch = 'B' */
	0x26, 0x36, 0x36, 0x36, 0x20, 0x00, 0x00,
	0x7c, 0xe5, 0x74, 0x74, 0xe5, 0xb1, 0x0d,
	0x7c, 0xb7, 0x00, 0x00, 0x10, 0xff, 0x44,
	0x7c, 0xb7, 0x00, 0x00, 0x0d, 0xff, 0x39,
	0x7c, 0xcf, 0x36, 0x50, 0xd4, 0xa9, 0x04,
	0x7c, 0xcf, 0x36, 0x36, 0xa4, 0xbb, 0x10,
	0x7c, 0xb7, 0x00, 0x00, 0x00, 0xa7, 0x7c,
	0x7c, 0xb7, 0x00, 0x00, 0x00, 0x70, 0xb7,
	0x7c, 0xb7, 0x00, 0x00, 0x1b, 0xe5, 0x5f,
	0x7c, 0xff, 0xff, 0xff, 0xef, 0x73, 0x04,
	/* ch = 'C' */
	0x00, 0x00, 0x0c, 0x36, 0x36, 0x0c, 0x00,
	0x00, 0x39, 0xef, 0x66, 0x66, 0xf7, 0x32,
	0x17, 0xf7, 0x35, 0x00, 0x00, 0x3f, 0x8d,
	0x50, 0xcf, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7c, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7c, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x77, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x44, 0xf7, 0x0d, 0x00, 0x00, 0x00, 0x00,
	0x0d, 0xdb, 0x7c, 0x04, 0x00, 0x50, 0x5c,
	0x00, 0x1f, 0xcb, 0xe5, 0xdd, 0xcb, 0x19,
	0x00, 0x00, 0x00, 0x12, 0x0f, 0x00, 0x00,
	/* ch = 'D' */
	0x1e, 0x36, 0x36, 0x30, 0x0f, 0x00, 0x00,
	0x50, 0xe5, 0x74, 0x8f, 0xf7, 0x66, 0x00,
	0x50, 0xb7, 0x00, 0x00, 0x2c, 0xff, 0x2c,
	0x50, 0xb7, 0x00, 0x00, 0x00, 0xa7, 0x7c,
	0x50, 0xb7, 0x00, 0x00, 0x00, 0x5f, 0xb7,
	0x50, 0xb7, 0x00, 0x00, 0x00, 0x50, 0xb7,
	0x50, 0xb7, 0x00, 0x00, 0x00, 0x5f, 0xb1,
	0x50, 0xb7, 0x00, 0x00, 0x00, 0xc8, 0x5a,
	0x50, 0xb7, 0x00, 0x04, 0x5f, 0xf7, 0x10,
	0x50, 0xf7, 0xcf, 0xef, 0xab, 0x19, 0x00,
	/* ch = 'E' */
	0x1e, 0x36, 0x36, 0x36, 0x36, 0x36, 0x26,
	0x50, 0xe5, 0x74, 0x74, 0x74, 0x74, 0x42,
	0x50, 0xb7, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xb7, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xcf, 0x36, 0x36, 0x36, 0x2d, 0x00,
	0x50, 0xe5, 0x74, 0x74, 0x74, 0x58, 0x00,
	0x50, 0xb7, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xb7, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xb7, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50,
	/* ch = 'F' */
	0x0d, 0x36, 0x36, 0x36, 0x36, 0x36, 0x1e,
	0x1c, 0xff, 0x87, 0x74, 0x74, 0x74, 0x30,
	0x1c, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x87, 0x74, 0x74, 0x42, 0x00,
	0x1c, 0xff, 0x4a, 0x36, 0x36, 0x26, 0x00,
	0x1c, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00,
	/* ch = 'G' */
	0x00, 0x00, 0x0f, 0x36, 0x36, 0x0c, 0x00,
	0x00, 0x44, 0xf7, 0x82, 0x8f, 0xf7, 0x32,
	0x22, 0xff, 0x32, 0x00, 0x00, 0x49, 0x4d,
	0x5f, 0xa7, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x90, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xb7, 0x6b, 0x00, 0x0d, 0x36, 0x36, 0x2d,
	0x7c, 0x7c, 0x00, 0x0d, 0x36, 0x62, 0xb7,
	0x50, 0xe5, 0x04, 0x00, 0x00, 0x32, 0xb7,
	0x10, 0xe5, 0x5f, 0x04, 0x00, 0x43, 0xb7,
	0x00, 0x21, 0xd4, 0xe5, 0xdd, 0xe5, 0x35,
	0x00, 0x00, 0x00, 0x0f, 0x0f, 0x00, 0x00,
	/* ch = 'H' */
	0x1e, 0x36, 0x00, 0x00, 0x00, 0x2d, 0x26,
	0x50, 0xb7, 0x00, 0x00, 0x00, 0xb7, 0x7c,
	0x50, 0xb7, 0x00, 0x00, 0x00, 0xb7, 0x7c,
	0x50, 0xb7, 0x00, 0x00, 0x00, 0xb7, 0x7c,
	0x50, 0xcf, 0x36, 0x36, 0x36, 0xcf, 0x7c,
	0x50, 0xe5, 0x74, 0x74, 0x74, 0xe5, 0x7c,
	0x50, 0xb7, 0x00, 0x00, 0x00, 0xb7, 0x7c,
	0x50, 0xb7, 0x00, 0x00, 0x00, 0xb7, 0x7c,
	0x50, 0xb7, 0x00, 0x00, 0x00, 0xb7, 0x7c,
	0x50, 0xb7, 0x00, 0x00, 0x00, 0xb7, 0x7c,
	/* ch = 'I' */
	0x00, 0x36, 0x36, 0x36, 0x36, 0x36,
	0x00, 0x74, 0x9c, 0xff, 0x87, 0x74,
	0x00, 0x00, 0x32, 0xff, 0x1c, 0x00,
	0x00, 0x00, 0x32, 0xff, 0x1c, 0x00,
	0x00, 0x00, 0x32, 0xff, 0x1c, 0x00,
	0x00, 0x00, 0x32, 0xff, 0x1c, 0x00,
	0x00, 0x00, 0x32, 0xff, 0x1c, 0x00,
	0x00, 0x00, 0x32, 0xff, 0x1c, 0x00,
	0x00, 0x00, 0x32, 0xff, 0x1c, 0x00,
	0x1a, 0xcf, 0xdd, 0xff, 0xd4, 0xcf,
	/* ch = 'J' */
	0x00, 0x00, 0x2d, 0x36, 0x36, 0x36,
	0x00, 0x00, 0x58, 0x74, 0xff, 0x9c,
	0x00, 0x00, 0x00, 0x00, 0xff, 0x32,
	0x00, 0x00, 0x00, 0x00, 0xff, 0x32,
	0x00, 0x00, 0x00, 0x00, 0xff, 0x32,
	0x00, 0x00, 0x00, 0x00, 0xff, 0x32,
	0x00, 0x00, 0x00, 0x00, 0xff, 0x32,
	0x00, 0x00, 0x00, 0x00, 0xff, 0x32,
	0x10, 0x5a, 0x00, 0x24, 0xff, 0x22,
	0x26, 0xef, 0xdd, 0xf7, 0x66, 0x00,
	0x00, 0x00, 0x15, 0x0c, 0x00, 0x00,
	/* ch = 'K' */
	0x26, 0x2d, 0x00, 0x00, 0x00, 0x30, 0x2b,
	0x7c, 0x7c, 0x00, 0x00, 0x50, 0xdb, 0x19,
	0x7c, 0x7c, 0x00, 0x32, 0xf7, 0x1f, 0x00,
	0x7c, 0x7c, 0x32, 0xff, 0x32, 0x00, 0x00,
	0x7c, 0xb7, 0xf7, 0x59, 0x00, 0x00, 0x00,
	0x7c, 0xff, 0xd4, 0xb1, 0x04, 0x00, 0x00,
	0x7c, 0x82, 0x10, 0xe5, 0x5f, 0x00, 0x00,
	0x7c, 0x7c, 0x00, 0x35, 0xff, 0x2f, 0x00,
	0x7c, 0x7c, 0x00, 0x00, 0x7c, 0xdb, 0x10,
	0x7c, 0x7c, 0x00, 0x00, 0x10, 0xdb, 0x82,
	/* ch = 'L' */
	0x16, 0x36, 0x0d, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0xd4, 0xcf, 0xcf, 0xcf, 0x67,
	/* ch = 'M' */
	0x26, 0x1e, 0x00, 0x00, 0x00, 0x16, 0x2d,
	0x7c, 0xc8, 0x00, 0x00, 0x00, 0x7c, 0xb7,
	0x7c, 0xff, 0x39, 0x00, 0x1c, 0xff, 0xb7,
	0x7c, 0xff, 0xc8, 0x00, 0x8a, 0xf7, 0xb7,
	0x7c, 0x82, 0xe5, 0x6a, 0xf7, 0x64, 0xb7,
	0x7c, 0x7c, 0x48, 0xff, 0x5a, 0x50, 0xb7,
	0x7c, 0x7c, 0x04, 0xab, 0x0d, 0x50, 0xb7,
	0x7c, 0x7c, 0x00, 0x00, 0x00, 0x50, 0xb7,
	0x7c, 0x7c, 0x00, 0x00, 0x00, 0x50, 0xb7,
	0x7c, 0x7c, 0x00, 0x00, 0x00, 0x50, 0xb7,
	/* ch = 'N' */
	0x1e, 0x2d, 0x00, 0x00, 0x00, 0x26, 0x2b,
	0x50, 0xff, 0x2a, 0x00, 0x00, 0x7c, 0x7c,
	0x50, 0xff, 0xb7, 0x00, 0x00, 0x7c, 0x7c,
	0x50, 0xe5, 0xf7, 0x3b, 0x00, 0x7c, 0x7c,
	0x50, 0xb7, 0x5f, 0xdb, 0x04, 0x7c, 0x7c,
	0x50, 0xb7, 0x0d, 0xe5, 0x50, 0x7c, 0x7c,
	0x50, 0xb7, 0x00, 0x44, 0xf7, 0xa7, 0x7c,
	0x50, 0xb7, 0x00, 0x04, 0xb7, 0xff, 0x7c,
	0x50, 0xb7, 0x00, 0x00, 0x2a, 0xff, 0x7c,
	0x50, 0xb7, 0x00, 0x00, 0x00, 0x90, 0x7c,
	/* ch = 'O' */
	0x00, 0x00, 0x1e, 0x36, 0x2a, 0x04, 0x00,
	0x00, 0x77, 0xef, 0x74, 0xd4, 0xc4, 0x0d,
	0x32, 0xf7, 0x1f, 0x00, 0x10, 0xdb, 0x5a,
	0x82, 0x82, 0x00, 0x00, 0x00, 0x5f, 0xcf,
	0xb7, 0x50, 0x00, 0x00, 0x00, 0x32, 0xff,
	0xb7, 0x50, 0x00, 0x00, 0x00, 0x32, 0xff,
	0xb1, 0x6b, 0x00, 0x00, 0x00, 0x35, 0xff,
	0x6b, 0xc8, 0x00, 0x00, 0x00, 0x70, 0xb1,
	0x1c, 0xf7, 0x54, 0x00, 0x21, 0xf7, 0x3b,
	0x00, 0x2c, 0xef, 0xff, 0xf7, 0x66, 0x00,
	0x00, 0x00, 0x00, 0x15, 0x04, 0x00, 0x00,
	/* ch = 'P' */
	0x1e, 0x36, 0x36, 0x36, 0x2a, 0x08, 0x00,
	0x50, 0xff, 0x74, 0x74, 0xdd, 0xef, 0x1f,
	0x50, 0xff, 0x00, 0x00, 0x04, 0xb7, 0x8a,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x70, 0xb7,
	0x50, 0xff, 0x00, 0x00, 0x1e, 0xe5, 0x5a,
	0x50, 0xff, 0xcf, 0xcf, 0xcf, 0x5b, 0x04,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
	/* ch = 'Q' */
	0x00, 0x00, 0x1e, 0x36, 0x2a, 0x04, 0x00,
	0x00, 0x77, 0xef, 0x74, 0xd4, 0xc4, 0x0d,
	0x32, 0xf7, 0x1a, 0x00, 0x08, 0xdb, 0x5a,
	0x7c, 0x7c, 0x00, 0x00, 0x00, 0x50, 0xcf,
	0xb7, 0x50, 0x00, 0x00, 0x00, 0x32, 0xff,
	0xb7, 0x50, 0x00, 0x00, 0x00, 0x32, 0xff,
	0xb1, 0x5f, 0x00, 0x00, 0x00, 0x32, 0xff,
	0x6b, 0xb7, 0x00, 0x00, 0x00, 0x5f, 0xb1,
	0x1c, 0xf7, 0x50, 0x00, 0x21, 0xf7, 0x3b,
	0x00, 0x2c, 0xef, 0xdd, 0xff, 0x66, 0x00,
	0x00, 0x00, 0x00, 0xe5, 0x3b, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x50, 0xf7, 0xcf, 0x67,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0x15, 0x0f,
	/* ch = 'R' */
	0x1e, 0x36, 0x36, 0x36, 0x25, 0x04, 0x00,
	0x50, 0xe5, 0x74, 0x74, 0xe5, 0xd4, 0x10,
	0x50, 0xb7, 0x00, 0x00, 0x04, 0xcf, 0x6b,
	0x50, 0xb7, 0x00, 0x00, 0x00, 0x82, 0x7c,
	0x50, 0xb7, 0x00, 0x00, 0x2b, 0xf7, 0x39,
	0x50, 0xf7, 0xcf, 0xef, 0xf7, 0x50, 0x00,
	0x50, 0xb7, 0x00, 0x2c, 0xff, 0x1c, 0x00,
	0x50, 0xb7, 0x00, 0x00, 0xa7, 0x7c, 0x00,
	0x50, 0xb7, 0x00, 0x00, 0x2c, 0xff, 0x1c,
	0x50, 0xb7, 0x00, 0x00, 0x00, 0xa7, 0x90,
	/* ch = 'S' */
	0x00, 0x00, 0x18, 0x36, 0x2a, 0x08, 0x00,
	0x00, 0x77, 0xdb, 0x67, 0xa4, 0xef, 0x24,
	0x1a, 0xff, 0x24, 0x00, 0x00, 0x3d, 0x10,
	0x1a, 0xff, 0x3b, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x66, 0xf7, 0x73, 0x16, 0x00, 0x00,
	0x00, 0x00, 0x1e, 0x9e, 0xff, 0x7e, 0x04,
	0x00, 0x00, 0x00, 0x00, 0x13, 0xdb, 0x6b,
	0x00, 0x0c, 0x00, 0x00, 0x00, 0x59, 0xb7,
	0x2a, 0xb1, 0x10, 0x00, 0x10, 0xc8, 0x66,
	0x10, 0x94, 0xff, 0xcf, 0xf7, 0x94, 0x04,
	0x00, 0x00, 0x08, 0x15, 0x08, 0x00, 0x00,
	/* ch = 'T' */
	0x2d, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
	0x58, 0x74, 0x87, 0xff, 0x87, 0x74, 0x74,
	0x00, 0x00, 0x1c, 0xff, 0x1c, 0x00, 0x00,
	0x00, 0x00, 0x1c, 0xff, 0x1c, 0x00, 0x00,
	0x00, 0x00, 0x1c, 0xff, 0x1c, 0x00, 0x00,
	0x00, 0x00, 0x1c, 0xff, 0x1c, 0x00, 0x00,
	0x00, 0x00, 0x1c, 0xff, 0x1c, 0x00, 0x00,
	0x00, 0x00, 0x1c, 0xff, 0x1c, 0x00, 0x00,
	0x00, 0x00, 0x1c, 0xff, 0x1c, 0x00, 0x00,
	0x00, 0x00, 0x1c, 0xff, 0x1c, 0x00, 0x00,
	/* ch = 'U' */
	0x1e, 0x33, 0x00, 0x00, 0x00, 0x1e, 0x2d,
	0x50, 0xb7, 0x00, 0x00, 0x00, 0x50, 0xb7,
	0x50, 0xb7, 0x00, 0x00, 0x00, 0x50, 0xb7,
	0x50, 0xb7, 0x00, 0x00, 0x00, 0x50, 0xb7,
	0x50, 0xb7, 0x00, 0x00, 0x00, 0x50, 0xb7,
	0x50, 0xb7, 0x00, 0x00, 0x00, 0x50, 0xb7,
	0x50, 0xb7, 0x00, 0x00, 0x00, 0x50, 0xb7,
	0x50, 0xb7, 0x00, 0x00, 0x00, 0x5f, 0xb1,
	0x2a, 0xff, 0x26, 0x00, 0x10, 0xdb, 0x5a,
	0x00, 0x5a, 0xf7, 0xcf, 0xf7, 0x7e, 0x04,
	0x00, 0x00, 0x04, 0x15, 0x08, 0x00, 0x00,
	/* ch = 'V' */
	0x33, 0x1e, 0x00, 0x00, 0x00, 0x10, 0x36, 0x0d,
	0x7c, 0xa0, 0x00, 0x00, 0x00, 0x48, 0xcf, 0x00,
	0x32, 0xff, 0x14, 0x00, 0x00, 0xa0, 0x5f, 0x00,
	0x04, 0xf7, 0x44, 0x00, 0x14, 0xff, 0x24, 0x00,
	0x00, 0x7c, 0xa0, 0x00, 0x3b, 0xcf, 0x00, 0x00,
	0x00, 0x2c, 0xff, 0x14, 0x90, 0x5f, 0x00, 0x00,
	0x00, 0x04, 0xe5, 0x50, 0xff, 0x24, 0x00, 0x00,
	0x00, 0x00, 0x70, 0xf7, 0xcf, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x2c, 0xff, 0x5f, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x04, 0xe5, 0x24, 0x00, 0x00, 0x00,
	/* ch = 'W' */
	0x36, 0x10, 0x00, 0x00, 0x00, 0x00, 0x30, 0x16,
	0xe5, 0x35, 0x00, 0x42, 0x14, 0x00, 0xff, 0x1c,
	0xa0, 0x54, 0x00, 0xcf, 0x3b, 0x1c, 0xff, 0x04,
	0x77, 0x7c, 0x1c, 0xff, 0x77, 0x2f, 0xbd, 0x00,
	0x4d, 0xb7, 0x44, 0xf7, 0xcf, 0x44, 0x82, 0x00,
	0x2f, 0xff, 0x90, 0x50, 0xff, 0x82, 0x5f, 0x00,
	0x1a, 0xff, 0xff, 0x14, 0xb7, 0xff, 0x3b, 0x00,
	0x00, 0xff, 0xcf, 0x00, 0x5f, 0xff, 0x24, 0x00,
	0x00, 0xb7, 0x6b, 0x00, 0x32, 0xff, 0x0d, 0x00,
	0x00, 0x7c, 0x32, 0x00, 0x0d, 0xe5, 0x00, 0x00,
	/* ch = 'X' */
	0x24, 0x30, 0x00, 0x00, 0x00, 0x28, 0x26,
	0x24, 0xff, 0x2a, 0x00, 0x17, 0xf7, 0x2a,
	0x00, 0x7c, 0xb7, 0x00, 0x7c, 0xa0, 0x00,
	0x00, 0x17, 0xf7, 0x6a, 0xff, 0x2a, 0x00,
	0x00, 0x00, 0x5f, 0xff, 0x90, 0x00, 0x00,
	0x00, 0x00, 0x32, 0xff, 0x54, 0x00, 0x00,
	0x00, 0x00, 0xb7, 0xdb, 0xf7, 0x10, 0x00,
	0x00, 0x3b, 0xf7, 0x1a, 0xc8, 0x6b, 0x00,
	0x04, 0xdb, 0x5f, 0x00, 0x32, 0xff, 0x1c,
	0x44, 0xf7, 0x0d, 0x00, 0x00, 0xa0, 0x90,
	/* ch = 'Y' */
	0x2d, 0x26, 0x00, 0x00, 0x00, 0x19, 0x36, 0x09,
	0x48, 0xf7, 0x10, 0x00, 0x00, 0x90, 0x8a, 0x00,
	0x04, 0xe5, 0x5f, 0x00, 0x22, 0xff, 0x22, 0x00,
	0x00, 0x48, 0xf7, 0x10, 0x70, 0xa0, 0x00, 0x00,
	0x00, 0x04, 0xdb, 0x7c, 0xff, 0x2c, 0x00, 0x00,
	0x00, 0x00, 0x44, 0xff, 0xa7, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x04, 0xff, 0x50, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xff, 0x50, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xff, 0x50, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xff, 0x50, 0x00, 0x00, 0x00,
	/* ch = 'Z' */
	0x16, 0x36, 0x36, 0x36, 0x36, 0x36, 0x26,
	0x22, 0x74, 0x74, 0x74, 0x74, 0xff, 0x66,
	0x00, 0x00, 0x00, 0x00, 0x44, 0xe5, 0x10,
	0x00, 0x00, 0x00, 0x10, 0xe5, 0x44, 0x00,
	0x00, 0x00, 0x00, 0x77, 0xb7, 0x00, 0x00,
	0x00, 0x00, 0x2a, 0xff, 0x24, 0x00, 0x00,
	0x00, 0x04, 0xc8, 0x6b, 0x00, 0x00, 0x00,
	0x00, 0x4d, 0xe5, 0x10, 0x00, 0x00, 0x00,
	0x17, 0xf7, 0x44, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	/* ch = '[' */
	0x32, 0xff, 0xcf, 0xcf, 0xcf, 0x2d,
	0x32, 0xff, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x74, 0x74, 0x74, 0x22,
	0x16, 0x36, 0x36, 0x36, 0x36, 0x16,
	/* ch = '\' */
	0x20, 0xe5, 0x10,
	0x04, 0xc8, 0x5a,
	0x00, 0x48, 0xe5,
	0x00, 0x04, 0xe5,
	0x00, 0x00, 0x5a,
	0x00, 0x00, 0x0d,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	/* ch = ']' */
	0x00, 0xcf, 0xcf, 0xcf, 0xf7, 0x50,
	0x00, 0x00, 0x00, 0x00, 0xb7, 0x50,
	0x00, 0x00, 0x00, 0x00, 0xb7, 0x50,
	0x00, 0x00, 0x00, 0x00, 0xb7, 0x50,
	0x00, 0x00, 0x00, 0x00, 0xb7, 0x50,
	0x00, 0x00, 0x00, 0x00, 0xb7, 0x50,
	0x00, 0x00, 0x00, 0x00, 0xb7, 0x50,
	0x00, 0x00, 0x00, 0x00, 0xb7, 0x50,
	0x00, 0x00, 0x00, 0x00, 0xb7, 0x50,
	0x00, 0x00, 0x00, 0x00, 0xb7, 0x50,
	0x14, 0x74, 0x74, 0x74, 0xe5, 0x50,
	0x0d, 0x36, 0x36, 0x36, 0x36, 0x1e,
	/* ch = '^' */
	0x00, 0x00, 0x28, 0x04, 0x00,
	0x00, 0x1c, 0xf7, 0x44, 0x00,
	0x00, 0x90, 0xd4, 0xe5, 0x0d,
	0x32, 0xe5, 0x10, 0xb7, 0x50,
	0x82, 0x32, 0x00, 0x2a, 0xa5,
	/* ch = '_' */
	0x95, 0xcf, 0xcf, 0xcf, 0xcf, 0xcf, 0xcf,
	0x12, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15,
	/* ch = '`' */
	0x17, 0xf7, 0x17,
	0x00, 0xa7, 0x64,
	0x00, 0x39, 0xff,
	0x00, 0x00, 0x30,
	/* ch = 'a' */
	0x00, 0x37, 0xdd, 0xf7, 0xef, 0x50, 0x00,
	0x00, 0x3d, 0x1b, 0x00, 0x1f, 0xff, 0x32,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xb7, 0x50,
	0x00, 0x50, 0xdd, 0xcf, 0xcf, 0xf7, 0x50,
	0x40, 0xf7, 0x13, 0x00, 0x00, 0xb7, 0x50,
	0x5a, 0xcf, 0x04, 0x00, 0x2c, 0xff, 0x50,
	0x10, 0xd4, 0xdd, 0xbd, 0xcb, 0xe5, 0x50,
	0x00, 0x00, 0x12, 0x0f, 0x00, 0x00, 0x00,
	/* ch = 'b' */
	0x50, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xff, 0x7e, 0xff, 0xf7, 0x66, 0x00,
	0x50, 0xff, 0x54, 0x00, 0x35, 0xff, 0x44,
	0x50, 0xff, 0x04, 0x00, 0x00, 0xa0, 0xa0,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x7c, 0xb7,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x82, 0xa0,
	0x50, 0xff, 0x35, 0x00, 0x21, 0xf7, 0x44,
	0x50, 0xb7, 0xd4, 0xd4, 0xff, 0x77, 0x00,
	0x00, 0x00, 0x00, 0x12, 0x0c, 0x00, 0x00,
	/* ch = 'c' */
	0x00, 0x10, 0x8d, 0xf7, 0xff, 0xab, 0x19,
	0x04, 0xb7, 0x8a, 0x08, 0x08, 0x7c, 0x73,
	0x32, 0xff, 0x17, 0x00, 0x00, 0x08, 0x04,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x3b, 0xff, 0x17, 0x00, 0x00, 0x00, 0x00,
	0x0d, 0xdb, 0x8a, 0x04, 0x00, 0x37, 0x26,
	0x00, 0x1f, 0xd4, 0xef, 0xe5, 0xe5, 0x2c,
	0x00, 0x00, 0x00, 0x12, 0x12, 0x00, 0x00,
	/* ch = 'd' */
	0x00, 0x00, 0x00, 0x00, 0x00, 0xb7, 0x5f,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xb7, 0x50,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xb7, 0x50,
	0x00, 0x35, 0xe5, 0xe5, 0xcb, 0xcf, 0x50,
	0x22, 0xff, 0x32, 0x00, 0x35, 0xff, 0x50,
	0x5f, 0xbd, 0x00, 0x00, 0x00, 0xcf, 0x5f,
	0x7c, 0x82, 0x00, 0x00, 0x00, 0xb7, 0x7c,
	0x5f, 0xbd, 0x00, 0x00, 0x00, 0xcf, 0x7c,
	0x2a, 0xff, 0x32, 0x00, 0x37, 0xff, 0x7c,
	0x00, 0x5a, 0xff, 0xdd, 0xd4, 0xcf, 0x7c,
	0x00, 0x00, 0x0c, 0x12, 0x00, 0x00, 0x00,
	/* ch = 'e' */
	0x00, 0x26, 0xcb, 0xdd, 0xef, 0x48, 0x00,
	0x17, 0xf7, 0x37, 0x00, 0x1f, 0xf7, 0x2a,
	0x44, 0xd9, 0x15, 0x15, 0x15, 0x9e, 0x6b,
	0x6b, 0xf7, 0xcf, 0xcf, 0xcf, 0xcf, 0x67,
	0x50, 0xcf, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x22, 0xff, 0x37, 0x00, 0x00, 0x2a, 0x08,
	0x00, 0x35, 0xef, 0xd4, 0xdd, 0xbb, 0x19,
	0x00, 0x00, 0x00, 0x15, 0x0f, 0x00, 0x00,
	/* ch = 'f' */
	0x10, 0xb3, 0xe5, 0xef, 0x8d, 0x04,
	0x8a, 0xa0, 0x04, 0x04, 0x8d, 0x04,
	0xb7, 0x50, 0x00, 0x00, 0x00, 0x00,
	0xcf, 0x82, 0x36, 0x26, 0x00, 0x00,
	0xcf, 0x82, 0x36, 0x26, 0x00, 0x00,
	0xb7, 0x50, 0x00, 0x00, 0x00, 0x00,
	0xb7, 0x50, 0x00, 0x00, 0x00, 0x00,
	0xb7, 0x50, 0x00, 0x00, 0x00, 0x00,
	0xb7, 0x50, 0x00, 0x00, 0x00, 0x00,
	0xb7, 0x50, 0x00, 0x00, 0x00, 0x00,
	/* ch = 'g' */
	0x44, 0xef, 0xdd, 0xbb, 0xcb, 0xd4, 0x09,
	0xff, 0x1f, 0x00, 0x82, 0x90, 0x00, 0x00,
	0xcf, 0x00, 0x00, 0x50, 0xb7, 0x00, 0x00,
	0xf7, 0x5f, 0x2b, 0xdb, 0x4d, 0x00, 0x00,
	0x82, 0x95, 0x74, 0x37, 0x00, 0x00, 0x00,
	0xff, 0x2d, 0x15, 0x15, 0x08, 0x00, 0x00,
	0xc4, 0x9e, 0xcf, 0xcf, 0xf7, 0x49, 0x00,
	0x75, 0x00, 0x00, 0x00, 0x59, 0xb7, 0x00,
	0xdb, 0x37, 0x15, 0x37, 0xdb, 0x4d, 0x00,
	0x2a, 0x5b, 0x74, 0x5b, 0x1e, 0x00, 0x00,
	/* ch = 'h' */
	0x32, 0xff, 0x1f, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x54, 0xef, 0xff, 0x7e, 0x00,
	0x32, 0xff, 0xb1, 0x13, 0x21, 0xff, 0x32,
	0x32, 0xff, 0x24, 0x00, 0x00, 0xe5, 0x50,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0xb7, 0x50,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0xb7, 0x50,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0xb7, 0x50,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0xb7, 0x50,
	/* ch = 'i' */
	0x00, 0x17, 0xcf, 0x39, 0x00,
	0x00, 0x10, 0x9e, 0x2a, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00,
	0x67, 0xcf, 0xcf, 0x2d, 0x00,
	0x00, 0x1c, 0xff, 0x32, 0x00,
	0x00, 0x1c, 0xff, 0x32, 0x00,
	0x00, 0x1c, 0xff, 0x32, 0x00,
	0x00, 0x1c, 0xff, 0x32, 0x00,
	0x00, 0x1c, 0xff, 0x32, 0x00,
	0x95, 0xd4, 0xff, 0xdd, 0xcf,
	/* ch = 'j' */
	0x00, 0x00, 0x00, 0x04, 0xbd, 0x57,
	0x00, 0x00, 0x00, 0x00, 0x8d, 0x39,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x45, 0xcf, 0xcf, 0xcf, 0x45,
	0x00, 0x00, 0x00, 0x00, 0xb7, 0x50,
	0x00, 0x00, 0x00, 0x00, 0xb7, 0x50,
	0x00, 0x00, 0x00, 0x00, 0xb7, 0x50,
	0x00, 0x00, 0x00, 0x00, 0xb7, 0x50,
	0x00, 0x00, 0x00, 0x00, 0xb7, 0x50,
	0x00, 0x00, 0x00, 0x00, 0xb7, 0x50,
	0x00, 0x0c, 0x00, 0x04, 0xf7, 0x44,
	0x45, 0xdb, 0x3e, 0x8a, 0xdb, 0x10,
	0x04, 0x3f, 0x74, 0x5b, 0x13, 0x00,
	/* ch = 'k' */
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x26, 0xcf, 0x2d, 0x00,
	0x32, 0xff, 0x1c, 0x32, 0xef, 0x32, 0x00, 0x00,
	0x32, 0xff, 0x5f, 0xf7, 0x2c, 0x00, 0x00, 0x00,
	0x32, 0xff, 0xef, 0xff, 0x32, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x21, 0x7c, 0xf7, 0x1f, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x04, 0xb1, 0xdb, 0x10, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x10, 0xdb, 0xb1, 0x04,
	/* ch = 'l' */
	0x00, 0xff, 0xff, 0xff, 0x32, 0x00, 0x00,
	0x00, 0x00, 0x1c, 0xff, 0x32, 0x00, 0x00,
	0x00, 0x00, 0x1c, 0xff, 0x32, 0x00, 0x00,
	0x00, 0x00, 0x1c, 0xff, 0x32, 0x00, 0x00,
	0x00, 0x00, 0x1c, 0xff, 0x32, 0x00, 0x00,
	0x00, 0x00, 0x1c, 0xff, 0x32, 0x00, 0x00,
	0x00, 0x00, 0x1c, 0xff, 0x32, 0x00, 0x00,
	0x00, 0x00, 0x1c, 0xff, 0x32, 0x00, 0x00,
	0x00, 0x00, 0x1c, 0xff, 0x32, 0x00, 0x00,
	0x1a, 0xcf, 0xd4, 0xff, 0xdd, 0xcf, 0x2d,
	/* ch = 'm' */
	0x95, 0xbd, 0xef, 0xd4, 0xa2, 0xef, 0x8b,
	0xb7, 0x97, 0x0d, 0xff, 0x5f, 0x35, 0xff,
	0xb7, 0x50, 0x00, 0xff, 0x32, 0x32, 0xff,
	0xb7, 0x50, 0x00, 0xff, 0x32, 0x32, 0xff,
	0xb7, 0x50, 0x00, 0xff, 0x32, 0x32, 0xff,
	0xb7, 0x50, 0x00, 0xff, 0x32, 0x32, 0xff,
	0xb7, 0x50, 0x00, 0xff, 0x32, 0x32, 0xff,
	/* ch = 'n' */
	0x2d, 0xcf, 0x50, 0xef, 0xff, 0x7e, 0x00,
	0x32, 0xff, 0xb1, 0x0c, 0x26, 0xff, 0x32,
	0x32, 0xff, 0x1f, 0x00, 0x00, 0xff, 0x50,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0xff, 0x50,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0xff, 0x50,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0xff, 0x50,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0xff, 0x50,
	/* ch = 'o' */
	0x00, 0x21, 0xc4, 0xff, 0xe5, 0x48, 0x00,
	0x17, 0xf7, 0x54, 0x00, 0x28, 0xff, 0x39,
	0x5f, 0xcf, 0x00, 0x00, 0x00, 0x90, 0xa0,
	0x7c, 0xa5, 0x00, 0x00, 0x00, 0x50, 0xb7,
	0x6b, 0xcf, 0x00, 0x00, 0x00, 0x6b, 0xb1,
	0x2a, 0xff, 0x37, 0x00, 0x13, 0xf7, 0x44,
	0x00, 0x3b, 0xf7, 0xd4, 0xf7, 0x66, 0x00,
	0x00, 0x00, 0x04, 0x15, 0x0c, 0x00, 0x00,
	/* ch = 'p' */
	0x45, 0xcf, 0x73, 0xf7, 0xf7, 0x66, 0x04,
	0x50, 0xff, 0x54, 0x00, 0x28, 0xff, 0x4d,
	0x50, 0xff, 0x04, 0x00, 0x00, 0x7c, 0xb1,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x50, 0xef,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x6b, 0xb1,
	0x50, 0xff, 0x35, 0x00, 0x13, 0xe5, 0x5a,
	0x50, 0xff, 0xc4, 0xd4, 0xf7, 0x94, 0x04,
	0x50, 0xff, 0x00, 0x12, 0x0f, 0x00, 0x00,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1e, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00,
	/* ch = 'q' */
	0x00, 0x2f, 0xe5, 0xef, 0xcb, 0x9c, 0x67,
	0x22, 0xff, 0x35, 0x00, 0x35, 0xff, 0x7c,
	0x6b, 0xbd, 0x00, 0x00, 0x00, 0xbd, 0x7c,
	0x7c, 0x82, 0x00, 0x00, 0x00, 0xb7, 0x7c,
	0x6b, 0xcf, 0x00, 0x00, 0x00, 0xcf, 0x7c,
	0x2a, 0xff, 0x35, 0x00, 0x32, 0xff, 0x7c,
	0x00, 0x4d, 0xff, 0xdd, 0xd4, 0xcf, 0x7c,
	0x00, 0x00, 0x08, 0x12, 0x00, 0xb7, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xb7, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x2d, 0x26,
	/* ch = 'r' */
	0x95, 0x7e, 0x8d, 0xff, 0xf7, 0x60,
	0xb7, 0xff, 0x5f, 0x04, 0x21, 0x51,
	0xb7, 0xb7, 0x00, 0x00, 0x00, 0x00,
	0xb7, 0x5f, 0x00, 0x00, 0x00, 0x00,
	0xb7, 0x50, 0x00, 0x00, 0x00, 0x00,
	0xb7, 0x50, 0x00, 0x00, 0x00, 0x00,
	0xb7, 0x50, 0x00, 0x00, 0x00, 0x00,
	/* ch = 's' */
	0x00, 0x26, 0xcb, 0xd4, 0xef, 0x8d, 0x08,
	0x00, 0xe5, 0x4f, 0x00, 0x08, 0xb1, 0x1f,
	0x00, 0xc8, 0xc4, 0x25, 0x00, 0x00, 0x00,
	0x00, 0x13, 0x7f, 0xef, 0xef, 0x66, 0x04,
	0x00, 0x00, 0x00, 0x00, 0x2b, 0xf7, 0x50,
	0x1c, 0xb1, 0x08, 0x00, 0x08, 0xe5, 0x50,
	0x13, 0x94, 0xf7, 0xcf, 0xef, 0x94, 0x04,
	0x00, 0x00, 0x08, 0x15, 0x0c, 0x00, 0x00,
	/* ch = 't' */
	0x00, 0x00, 0x45, 0xb5, 0x00, 0x00,
	0x00, 0x00, 0x6b, 0xb7, 0x00, 0x00,
	0x2d, 0xcf, 0xef, 0xef, 0xcf, 0xcf,
	0x00, 0x00, 0x7c, 0x7c, 0x00, 0x00,
	0x00, 0x00, 0xb1, 0x7c, 0x00, 0x00,
	0x00, 0x00, 0xb7, 0x7c, 0x00, 0x00,
	0x00, 0x00, 0xb7, 0x7c, 0x00, 0x00,
	0x00, 0x00, 0xa0, 0xa7, 0x00, 0x1b,
	0x00, 0x00, 0x2f, 0xf7, 0xef, 0xef,
	0x00, 0x00, 0x00, 0x04, 0x12, 0x00,
	/* ch = 'u' */
	0x2d, 0xcf, 0x00, 0x00, 0x00, 0x95, 0x45,
	0x32, 0xff, 0x00, 0x00, 0x00, 0xb7, 0x50,
	0x32, 0xff, 0x00, 0x00, 0x00, 0xb7, 0x50,
	0x32, 0xff, 0x00, 0x00, 0x00, 0xb7, 0x50,
	0x32, 0xff, 0x04, 0x00, 0x00, 0xf7, 0x50,
	0x22, 0xff, 0x35, 0x00, 0x35, 0xff, 0x50,
	0x00, 0x66, 0xf7, 0xcf, 0xbb, 0xcf, 0x54,
	0x00, 0x00, 0x0c, 0x12, 0x00, 0x00, 0x00,
	/* ch = 'v' */
	0x58, 0xab, 0x00, 0x00, 0x00, 0x51, 0x82,
	0x22, 0xff, 0x24, 0x00, 0x00, 0xb7, 0x48,
	0x00, 0xa7, 0x70, 0x00, 0x22, 0xff, 0x0d,
	0x00, 0x3b, 0xf7, 0x0d, 0x70, 0x8a, 0x00,
	0x00, 0x0d, 0xf7, 0x54, 0xf7, 0x22, 0x00,
	0x00, 0x00, 0x70, 0xff, 0xa7, 0x00, 0x00,
	0x00, 0x00, 0x22, 0xff, 0x39, 0x00, 0x00,
	/* ch = 'w' */
	0xdd, 0x2d, 0x00, 0x12, 0x04, 0x1a, 0xcf, 0x1a,
	0xb1, 0x44, 0x0d, 0xff, 0x32, 0x1c, 0xff, 0x00,
	0x77, 0x77, 0x2a, 0xff, 0x70, 0x32, 0xbd, 0x00,
	0x44, 0xbd, 0x54, 0xb7, 0xe5, 0x44, 0x82, 0x00,
	0x24, 0xff, 0xb7, 0x2c, 0xf7, 0xb7, 0x54, 0x00,
	0x04, 0xff, 0xf7, 0x04, 0x90, 0xff, 0x35, 0x00,
	0x00, 0xb1, 0x90, 0x00, 0x44, 0xff, 0x1c, 0x00,
	/* ch = 'x' */
	0x28, 0xcf, 0x1f, 0x00, 0x1c, 0xcf, 0x28,
	0x00, 0x77, 0xb7, 0x08, 0xb1, 0x77, 0x00,
	0x00, 0x04, 0xdb, 0xd4, 0xdb, 0x0d, 0x00,
	0x00, 0x00, 0x31, 0xff, 0x4a, 0x00, 0x00,
	0x00, 0x04, 0xc8, 0xd4, 0xe5, 0x10, 0x00,
	0x00, 0x6b, 0xdb, 0x04, 0xb1, 0xa0, 0x00,
	0x2c, 0xff, 0x2a, 0x00, 0x10, 0xf7, 0x50,
	/* ch = 'y' */
	0x4a, 0xcf, 0x04, 0x00, 0x00, 0x5c, 0xa2,
	0x17, 0xff, 0x39, 0x00, 0x00, 0xc8, 0x48,
	0x00, 0x8a, 0xa0, 0x00, 0x22, 0xff, 0x17,
	0x00, 0x2c, 0xff, 0x17, 0x5f, 0x90, 0x00,
	0x00, 0x00, 0xc8, 0x5a, 0xe5, 0x39, 0x00,
	0x00, 0x00, 0x48, 0xff, 0xe5, 0x04, 0x00,
	0x00, 0x00, 0x0d, 0xf7, 0x70, 0x00, 0x00,
	0x00, 0x00, 0x17, 0xff, 0x22, 0x00, 0x00,
	0x82, 0x3e, 0xb1, 0xa0, 0x00, 0x00, 0x00,
	0x2e, 0x74, 0x50, 0x08, 0x00, 0x00, 0x00,
	/* ch = 'z' */
	0x2d, 0xcf, 0xcf, 0xcf, 0xcf, 0xcf, 0x2d,
	0x00, 0x00, 0x00, 0x00, 0x7c, 0xb1, 0x04,
	0x00, 0x00, 0x00, 0x50, 0xf7, 0x1c, 0x00,
	0x00, 0x00, 0x32, 0xff, 0x32, 0x00, 0x00,
	0x00, 0x1f, 0xf7, 0x50, 0x00, 0x00, 0x00,
	0x10, 0xdb, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7c,
	/* ch = '{' */
	0x00, 0x2a, 0x74, 0x74, 0x14,
	0x4d, 0xdb, 0x30, 0x30, 0x0d,
	0xb7, 0x54, 0x00, 0x00, 0x00,
	0xb7, 0x50, 0x00, 0x00, 0x00,
	0xbd, 0x4d, 0x00, 0x00, 0x00,
	0xdb, 0x10, 0x00, 0x00, 0x00,
	0x99, 0x04, 0x00, 0x00, 0x00,
	0xf7, 0x32, 0x00, 0x00, 0x00,
	0xb7, 0x50, 0x00, 0x00, 0x00,
	0xff, 0x50, 0x00, 0x00, 0x00,
	0xbd, 0x5f, 0x00, 0x00, 0x00,
	0x4d, 0xf7, 0x5b, 0x36, 0x0d,
	0x00, 0x18, 0x36, 0x36, 0x0d,
	/* ch = '|' */
	0x1a, 0xcf, 0x2d,
	0x1c, 0xff, 0x32,
	0x1c, 0xff, 0x32,
	0x1c, 0xff, 0x32,
	0x1c, 0xff, 0x32,
	0x1c, 0xff, 0x32,
	0x1c, 0xff, 0x32,
	0x1c, 0xff, 0x32,
	0x1c, 0xff, 0x32,
	0x1c, 0xff, 0x32,
	0x1c, 0xff, 0x32,
	0x1c, 0xff, 0x32,
	0x04, 0x15, 0x08,
	/* ch = '}' */
	0x74, 0x74, 0x37, 0x04,
	0x36, 0x2a, 0xb1, 0x77,
	0x00, 0x00, 0x35, 0xff,
	0x00, 0x00, 0x32, 0xff,
	0x00, 0x00, 0x2f, 0xff,
	0x00, 0x00, 0x04, 0xb1,
	0x00, 0x00, 0x00, 0x6b,
	0x00, 0x00, 0x1c, 0xff,
	0x00, 0x00, 0x32, 0xff,
	0x00, 0x00, 0x32, 0xff,
	0x00, 0x00, 0x3b, 0xff,
	0x36, 0x50, 0xdb, 0x77,
	0x36, 0x36, 0x20, 0x00,
	/* ch = '~' */
	0x10, 0xab, 0xff, 0xa2, 0x13, 0x1f, 0x8d, 0x09,
	0x3e, 0x73, 0x08, 0x6b, 0xf7, 0xef, 0x4d, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0x0c, 0x00, 0x00
};

/* font_inconsolata_16px */
static const unsigned char font_bitmap_16px_bytes[] = {
	/* ch = '!' */
	0x0d, 0x74, 0x2a,
	0x32, 0xff, 0x7c,
	0x1c, 0xff, 0x7c,
	0x1c, 0xff, 0x50,
	0x0d, 0xff, 0x50,
	0x00, 0xff, 0x35,
	0x00, 0xff, 0x32,
	0x00, 0xab, 0x2d,
	0x00, 0x00, 0x00,
	0x16, 0x9e, 0x32,
	0x39, 0xff, 0x84,
	0x00, 0x12, 0x04,
	/* ch = '"' */
	0x04, 0x67, 0x2a, 0x1c, 0x74, 0x10,
	0x1c, 0xff, 0x5a, 0x32, 0xff, 0x32,
	0x0d, 0xff, 0x32, 0x32, 0xff, 0x14,
	0x32, 0xf7, 0x04, 0x5f, 0xa0, 0x00,
	0x13, 0x28, 0x00, 0x1e, 0x1e, 0x00,
	/* ch = '#' */
	0x00, 0x00, 0x77, 0x7c, 0x00, 0xcf, 0x44, 0x00,
	0x00, 0x00, 0x90, 0x54, 0x00, 0xff, 0x32, 0x00,
	0x0f, 0x15, 0xbd, 0x53, 0x33, 0xff, 0x4a, 0x24,
	0x42, 0x5b, 0xff, 0x62, 0x62, 0xff, 0x36, 0x1e,
	0x00, 0x14, 0xff, 0x1c, 0x35, 0xe5, 0x00, 0x00,
	0x00, 0x1f, 0xff, 0x0d, 0x50, 0xb7, 0x00, 0x00,
	0x9c, 0xdd, 0xff, 0xcf, 0xe5, 0xdd, 0xa2, 0x28,
	0x00, 0x4d, 0xb7, 0x00, 0x90, 0x5f, 0x00, 0x00,
	0x00, 0x5f, 0x82, 0x00, 0xb7, 0x4d, 0x00, 0x00,
	0x00, 0x67, 0x5c, 0x00, 0xcf, 0x2d, 0x00, 0x00,
	/* ch = '$' */
	0x00, 0x00, 0x00, 0x1e, 0x2b, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x16, 0x82, 0xa5, 0x25, 0x00, 0x00,
	0x00, 0x4d, 0xef, 0xb1, 0xc8, 0xd4, 0xa9, 0x00,
	0x00, 0xf7, 0x35, 0x50, 0x7c, 0x10, 0x3d, 0x00,
	0x00, 0xe5, 0x7c, 0x54, 0x7c, 0x00, 0x00, 0x00,
	0x00, 0x26, 0xef, 0xff, 0xa5, 0x0f, 0x00, 0x00,
	0x00, 0x00, 0x04, 0x68, 0xef, 0xf7, 0x66, 0x00,
	0x00, 0x00, 0x00, 0x50, 0x7c, 0x26, 0xff, 0x2a,
	0x00, 0x22, 0x00, 0x50, 0x7c, 0x0d, 0xff, 0x2f,
	0x20, 0xff, 0x73, 0x68, 0xa5, 0xa9, 0xb1, 0x04,
	0x00, 0x1b, 0x67, 0xe5, 0xdb, 0x5b, 0x08, 0x00,
	0x00, 0x00, 0x00, 0x45, 0x67, 0x00, 0x00, 0x00,
	/* ch = '%' */
	0x00, 0x0c, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xef, 0xef, 0x4d, 0x00, 0x32, 0xf7, 0x10,
	0xb1, 0x54, 0x35, 0xf7, 0x04, 0xc8, 0x50, 0x00,
	0xb1, 0x54, 0x3b, 0xe5, 0x44, 0xdb, 0x04, 0x00,
	0x2c, 0xef, 0xef, 0x4d, 0xe5, 0x3b, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x5f, 0xb7, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x17, 0xf7, 0x2a, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0x90, 0x4d, 0xef, 0xd4, 0x16,
	0x00, 0x24, 0xff, 0x2a, 0xff, 0x24, 0x8a, 0x77,
	0x00, 0xa0, 0x6b, 0x1a, 0xff, 0x1f, 0x6b, 0x77,
	0x35, 0xf7, 0x10, 0x00, 0x7c, 0xcb, 0xef, 0x1f,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x08, 0x00,
	/* ch = '&' */
	0x00, 0x1f, 0xe5, 0xff, 0xd4, 0x1f, 0x00, 0x00,
	0x00, 0xa0, 0x97, 0x04, 0x97, 0x8a, 0x00, 0x00,
	0x00, 0xb1, 0x7c, 0x00, 0x82, 0xa0, 0x00, 0x00,
	0x00, 0x44, 0xf7, 0x37, 0xf7, 0x2f, 0x00, 0x00,
	0x00, 0x08, 0xd9, 0xff, 0x3f, 0x00, 0x00, 0x00,
	0x04, 0xc4, 0xb1, 0xdb, 0x7c, 0x00, 0x39, 0x08,
	0x5a, 0xf7, 0x10, 0x2f, 0xff, 0x3b, 0xe5, 0x4d,
	0x8a, 0xb7, 0x00, 0x00, 0x50, 0xff, 0xb1, 0x04,
	0x6b, 0xf7, 0x1a, 0x04, 0x6b, 0xff, 0xb1, 0x04,
	0x10, 0xbb, 0xff, 0xff, 0xbb, 0x28, 0xf7, 0x43,
	0x00, 0x00, 0x12, 0x0c, 0x00, 0x00, 0x0c, 0x00,
	/* ch = ''' */
	0x2c, 0x67, 0x00,
	0x77, 0xff, 0x11,
	0x54, 0xc8, 0x00,
	0xa7, 0x5a, 0x00,
	0x2a, 0x10, 0x00,
	/* ch = '(' */
	0x00, 0x00, 0x37, 0x2a,
	0x04, 0xa9, 0xd4, 0x31,
	0x82, 0xdb, 0x10, 0x00,
	0xff, 0x24, 0x00, 0x00,
	0x90, 0x00, 0x00, 0x00,
	0x4d, 0x00, 0x00, 0x00,
	0x32, 0x00, 0x00, 0x00,
	0x35, 0x00, 0x00, 0x00,
	0x5f, 0x00, 0x00, 0x00,
	0xc8, 0x00, 0x00, 0x00,
	0xff, 0x35, 0x00, 0x00,
	0x77, 0xf7, 0x1f, 0x00,
	0x04, 0x99, 0xef, 0x28,
	0x00, 0x00, 0x50, 0x40,
	/* ch = ')' */
	0x00, 0x51, 0x13, 0x00,
	0x09, 0x94, 0xf7, 0x2c,
	0x00, 0x00, 0x5f, 0xf7,
	0x00, 0x00, 0x00, 0x90,
	0x00, 0x00, 0x00, 0x22,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x17,
	0x00, 0x00, 0x00, 0x82,
	0x00, 0x00, 0x50, 0xff,
	0x04, 0x77, 0xf7, 0x35,
	0x04, 0x9e, 0x1b, 0x00,
	/* ch = '*' */
	0x00, 0x00, 0x00, 0x22, 0x0f, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xb7, 0x5f, 0x00, 0x00, 0x00,
	0x24, 0x48, 0x08, 0xa0, 0x50, 0x16, 0x5b, 0x04,
	0x29, 0x9e, 0xe5, 0xdb, 0xcb, 0xe5, 0x73, 0x13,
	0x00, 0x00, 0x21, 0xff, 0xbd, 0x04, 0x00, 0x00,
	0x00, 0x10, 0xdb, 0x44, 0xa0, 0x7c, 0x00, 0x00,
	0x00, 0xa4, 0x90, 0x00, 0x17, 0xf7, 0x43, 0x00,
	0x00, 0x10, 0x16, 0x00, 0x00, 0x0f, 0x00, 0x00,
	/* ch = '+' */
	0x00, 0x00, 0x00, 0x2d, 0x1e, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xb7, 0x50, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xb7, 0x50, 0x00, 0x00, 0x00,
	0x42, 0x74, 0x74, 0xe5, 0xb1, 0x74, 0x74, 0x22,
	0x26, 0x36, 0x36, 0xcf, 0x82, 0x36, 0x36, 0x16,
	0x00, 0x00, 0x00, 0xb7, 0x50, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xb7, 0x50, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x2d, 0x1e, 0x00, 0x00, 0x00,
	/* ch = ',' */
	0x16, 0x74, 0x2c,
	0x40, 0xff, 0xb7,
	0x00, 0x82, 0x8a,
	0x17, 0xef, 0x1f,
	0x32, 0x2c, 0x00,
	/* ch = '-' */
	0x14, 0x74, 0x74, 0x74, 0x74, 0x74, 0x58,
	0x0d, 0x36, 0x36, 0x36, 0x36, 0x36, 0x2d,
	/* ch = '.' */
	0x10, 0x74, 0x2c,
	0x39, 0xff, 0x84,
	0x00, 0x12, 0x04,
	/* ch = '/' */
	0x00, 0x2a, 0x37,
	0x00, 0xa7, 0x8a,
	0x2c, 0xff, 0x22,
	0x90, 0xa0, 0x00,
	0xff, 0x2c, 0x00,
	0xb7, 0x00, 0x00,
	0x39, 0x00, 0x00,
	0x04, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	/* ch = '0' */
	0x00, 0x04, 0x7e, 0xff, 0xef, 0x44, 0x00, 0x00,
	0x00, 0x6b, 0xc8, 0x13, 0x35, 0xff, 0x2a, 0x00,
	0x14, 0xff, 0x2c, 0x00, 0x10, 0xe5, 0xa0, 0x00,
	0x35, 0xff, 0x00, 0x00, 0x82, 0xf7, 0xff, 0x04,
	0x50, 0xb7, 0x00, 0x50, 0xdb, 0x28, 0xff, 0x1c,
	0x50, 0xb7, 0x2f, 0xff, 0x1f, 0x1c, 0xff, 0x1c,
	0x3b, 0xff, 0xdb, 0x50, 0x00, 0x2a, 0xff, 0x14,
	0x17, 0xff, 0x82, 0x00, 0x00, 0x50, 0xc8, 0x00,
	0x00, 0x90, 0xb7, 0x10, 0x13, 0xe5, 0x44, 0x00,
	0x00, 0x10, 0xa9, 0xf7, 0xf7, 0x6b, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x12, 0x0f, 0x00, 0x00, 0x00,
	/* ch = '1' */
	0x00, 0x31, 0xd4, 0xb7,
	0xab, 0xab, 0xc8, 0xb7,
	0x00, 0x00, 0x7c, 0xb7,
	0x00, 0x00, 0x7c, 0xb7,
	0x00, 0x00, 0x7c, 0xb7,
	0x00, 0x00, 0x7c, 0xb7,
	0x00, 0x00, 0x7c, 0xb7,
	0x00, 0x00, 0x7c, 0xb7,
	0x00, 0x00, 0x7c, 0xb7,
	0x00, 0x00, 0x7c, 0xb7,
	/* ch = '2' */
	0x00, 0x19, 0xb3, 0xff, 0xf7, 0x73, 0x04,
	0x0a, 0xcb, 0x5f, 0x04, 0x1b, 0xe5, 0x6b,
	0x00, 0x0c, 0x04, 0x00, 0x00, 0x5f, 0xc8,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xb1,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xf7, 0x3b,
	0x00, 0x00, 0x00, 0x21, 0xef, 0x5f, 0x00,
	0x00, 0x00, 0x1f, 0xf7, 0x54, 0x00, 0x00,
	0x00, 0x10, 0xdb, 0x54, 0x00, 0x00, 0x00,
	0x00, 0x90, 0xb1, 0x00, 0x00, 0x00, 0x0c,
	0x1a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	/* ch = '3' */
	0x00, 0x26, 0xcb, 0xff, 0xe5, 0x48, 0x00,
	0x00, 0x4d, 0x3f, 0x04, 0x35, 0xff, 0x2c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xb7, 0x50,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0x32,
	0x00, 0x00, 0x30, 0xab, 0xf7, 0x4a, 0x00,
	0x00, 0x00, 0x0c, 0x20, 0x77, 0xf7, 0x1f,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x97, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x82, 0xb1,
	0x04, 0xb1, 0x21, 0x00, 0x21, 0xf7, 0x50,
	0x04, 0x73, 0xff, 0xe5, 0xff, 0x7e, 0x04,
	0x00, 0x00, 0x08, 0x15, 0x0c, 0x00, 0x00,
	/* ch = '4' */
	0x00, 0x00, 0x00, 0x00, 0x77, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x2f, 0xff, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x0d, 0xdb, 0xb1, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x77, 0x82, 0x50, 0xff, 0x00, 0x00,
	0x00, 0x2f, 0xe5, 0x10, 0x50, 0xff, 0x00, 0x00,
	0x0d, 0xdb, 0x35, 0x00, 0x50, 0xff, 0x00, 0x00,
	0x4d, 0xff, 0xcf, 0xcf, 0xe5, 0xff, 0xcf, 0x1a,
	0x0c, 0x15, 0x15, 0x15, 0x5e, 0xff, 0x15, 0x04,
	0x00, 0x00, 0x00, 0x00, 0x50, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x50, 0xff, 0x00, 0x00,
	/* ch = '5' */
	0x00, 0x7c, 0xff, 0xff, 0xff, 0xff, 0xb7,
	0x00, 0x82, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xb7, 0x50, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xb7, 0x74, 0x36, 0x36, 0x13, 0x00,
	0x00, 0xf7, 0xdb, 0x50, 0xa4, 0xf7, 0x32,
	0x00, 0x25, 0x10, 0x00, 0x00, 0x82, 0xc8,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x35, 0xff,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0xff,
	0x1a, 0xd4, 0x37, 0x00, 0x10, 0xb7, 0xa0,
	0x00, 0x44, 0xef, 0xdd, 0xf7, 0xbb, 0x10,
	0x00, 0x00, 0x00, 0x15, 0x0f, 0x00, 0x00,
	/* ch = '6' */
	0x00, 0x00, 0x48, 0xef, 0xff, 0xe5, 0x35,
	0x00, 0x3b, 0xf7, 0x28, 0x00, 0x40, 0x1f,
	0x00, 0xc8, 0x64, 0x00, 0x00, 0x00, 0x00,
	0x14, 0xff, 0x35, 0x30, 0x36, 0x0c, 0x00,
	0x1c, 0xff, 0xef, 0xa4, 0xa4, 0xf7, 0x1f,
	0x2d, 0xff, 0x50, 0x00, 0x00, 0x90, 0xa7,
	0x1c, 0xff, 0x24, 0x00, 0x00, 0x44, 0xff,
	0x0d, 0xff, 0x3b, 0x00, 0x00, 0x4d, 0xf7,
	0x00, 0x7c, 0xdb, 0x10, 0x08, 0xb7, 0x7c,
	0x00, 0x10, 0xa9, 0xf7, 0xef, 0xbb, 0x10,
	0x00, 0x00, 0x00, 0x0f, 0x12, 0x00, 0x00,
	/* ch = '7' */
	0xff, 0xff, 0xff, 0xff, 0xff, 0xb7,
	0x00, 0x00, 0x00, 0x04, 0xe5, 0x5a,
	0x00, 0x00, 0x00, 0x39, 0xff, 0x17,
	0x00, 0x00, 0x00, 0xa7, 0x8a, 0x00,
	0x00, 0x00, 0x22, 0xff, 0x32, 0x00,
	0x00, 0x00, 0x5f, 0xe5, 0x04, 0x00,
	0x00, 0x04, 0xe5, 0x6b, 0x00, 0x00,
	0x00, 0x2c, 0xff, 0x24, 0x00, 0x00,
	0x00, 0x70, 0xcf, 0x00, 0x00, 0x00,
	0x04, 0xf7, 0x6b, 0x00, 0x00, 0x00,
	/* ch = '8' */
	0x00, 0x10, 0xbb, 0xef, 0xf7, 0x94, 0x08,
	0x00, 0x8a, 0xb1, 0x04, 0x13, 0xe5, 0x5a,
	0x00, 0xb7, 0x54, 0x00, 0x00, 0x82, 0x7c,
	0x00, 0x6b, 0xf7, 0x21, 0x1f, 0xf7, 0x2f,
	0x00, 0x04, 0x88, 0xf7, 0xf7, 0x46, 0x00,
	0x00, 0x4d, 0xef, 0x31, 0x94, 0xf7, 0x24,
	0x17, 0xff, 0x32, 0x00, 0x00, 0x82, 0xc8,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x47, 0xff,
	0x17, 0xff, 0x64, 0x04, 0x08, 0xb1, 0xa7,
	0x00, 0x2f, 0xef, 0xe5, 0xf7, 0xbb, 0x13,
	0x00, 0x00, 0x00, 0x15, 0x0f, 0x00, 0x00,
	/* ch = '9' */
	0x00, 0x13, 0xbb, 0xff, 0xf7, 0x5a, 0x00,
	0x00, 0xb1, 0x9e, 0x04, 0x26, 0xff, 0x39,
	0x1a, 0xff, 0x2a, 0x00, 0x00, 0x7c, 0xa0,
	0x1c, 0xff, 0x1f, 0x00, 0x00, 0x50, 0xe5,
	0x04, 0xf7, 0x54, 0x00, 0x04, 0x90, 0xff,
	0x00, 0x40, 0xff, 0x8f, 0xcb, 0xf7, 0xff,
	0x00, 0x00, 0x16, 0x36, 0x25, 0x54, 0xcf,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xa7, 0x7c,
	0x00, 0x2c, 0x1f, 0x00, 0x35, 0xff, 0x24,
	0x00, 0x94, 0xff, 0xef, 0xef, 0x3b, 0x00,
	0x00, 0x00, 0x0c, 0x15, 0x00, 0x00, 0x00,
	/* ch = ':' */
	0x1c, 0xbd, 0x40,
	0x36, 0xff, 0x6b,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x10, 0x74, 0x2c,
	0x39, 0xff, 0x84,
	0x00, 0x12, 0x04,
	/* ch = ';' */
	0x1c, 0xbd, 0x40,
	0x36, 0xff, 0x6b,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x16, 0x74, 0x2c,
	0x40, 0xff, 0xb7,
	0x00, 0x82, 0x8a,
	0x17, 0xef, 0x1f,
	0x32, 0x2c, 0x00,
	/* ch = '<' */
	0x00, 0x00, 0x28, 0xbb, 0x32,
	0x1e, 0xb3, 0xef, 0x48, 0x08,
	0xef, 0x50, 0x08, 0x00, 0x00,
	0x08, 0x00, 0x00, 0x00, 0x00,
	0x13, 0x00, 0x00, 0x00, 0x00,
	0xff, 0x73, 0x08, 0x00, 0x00,
	0x1b, 0xbb, 0xef, 0x3f, 0x04,
	0x00, 0x00, 0x28, 0xd4, 0x32,
	0x00, 0x00, 0x00, 0x04, 0x08,
	/* ch = '=' */
	0x7c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x32,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x67, 0xcf, 0xcf, 0xcf, 0xcf, 0xcf, 0xcf, 0x2d,
	0x0f, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x08,
	/* ch = '>' */
	0x7c, 0x7f, 0x13, 0x00, 0x00,
	0x13, 0x7f, 0xf7, 0x73, 0x0c,
	0x00, 0x00, 0x16, 0x8d, 0xf7,
	0x00, 0x00, 0x00, 0x00, 0x1b,
	0x00, 0x00, 0x00, 0x00, 0x28,
	0x00, 0x00, 0x1b, 0xbb, 0xef,
	0x13, 0x73, 0xff, 0x73, 0x08,
	0x7c, 0x94, 0x16, 0x00, 0x00,
	0x0c, 0x00, 0x00, 0x00, 0x00,
	/* ch = '?' */
	0x00, 0x04, 0x31, 0x74, 0x74, 0x22, 0x00,
	0x04, 0xa9, 0xef, 0x47, 0x94, 0xff, 0x44,
	0x08, 0x8d, 0x10, 0x00, 0x00, 0xa7, 0xbd,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0xe5,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0x6b,
	0x00, 0x00, 0x00, 0x1c, 0xef, 0x77, 0x04,
	0x00, 0x00, 0x00, 0x6b, 0xa7, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x7c, 0x7c, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x51, 0x51, 0x00, 0x00,
	0x00, 0x00, 0x09, 0xf7, 0xf7, 0x09, 0x00,
	0x00, 0x00, 0x00, 0x0c, 0x0f, 0x00, 0x00,
	/* ch = '@' */
	0x00, 0x00, 0x00, 0x04, 0x0f, 0x00, 0x00, 0x00,
	0x00, 0x10, 0x94, 0xe5, 0xd4, 0xd4, 0x21, 0x00,
	0x04, 0xb7, 0x6b, 0x04, 0x00, 0x47, 0xdb, 0x0d,
	0x39, 0xc8, 0x04, 0x00, 0x00, 0x0c, 0xff, 0x2f,
	0x82, 0x5f, 0x00, 0x66, 0xef, 0xcf, 0xe5, 0x44,
	0xb7, 0x50, 0x39, 0xe5, 0x10, 0x00, 0xb7, 0x50,
	0xb7, 0x50, 0x50, 0xbd, 0x00, 0x0d, 0xf7, 0x50,
	0x7c, 0x6b, 0x17, 0xef, 0xa4, 0xbb, 0xff, 0x50,
	0x39, 0xe5, 0x10, 0x08, 0x30, 0x18, 0x12, 0x0c,
	0x04, 0xb1, 0x99, 0x08, 0x00, 0x00, 0x0f, 0x00,
	0x00, 0x10, 0x8d, 0xf7, 0xcf, 0xe5, 0x97, 0x00,
	0x00, 0x00, 0x00, 0x08, 0x15, 0x0c, 0x00, 0x00,
	/* ch = 'A' */
	0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xa7, 0x17, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x17, 0xff, 0x50, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x50, 0xff, 0xc8, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xb7, 0x5f, 0xff, 0x2a, 0x00, 0x00,
	0x00, 0x22, 0xff, 0x14, 0xa0, 0x70, 0x00, 0x00,
	0x00, 0x5a, 0xa0, 0x00, 0x39, 0xf7, 0x0d, 0x00,
	0x00, 0xc8, 0xe5, 0xcf, 0xd4, 0xff, 0x3b, 0x00,
	0x24, 0xff, 0x1c, 0x00, 0x00, 0x8a, 0xa7, 0x00,
	0x5f, 0xb7, 0x00, 0x00, 0x00, 0x32, 0xff, 0x1c,
	0xe5, 0x50, 0x00, 0x00, 0x00, 0x04, 0xe5, 0x5a,
	/* ch = 'B' */
	0x50, 0xff, 0xff, 0xff, 0xef, 0x8d, 0x10, 0x00,
	0x50, 0xb7, 0x00, 0x00, 0x1e, 0xdb, 0x8a, 0x00,
	0x50, 0xb7, 0x00, 0x00, 0x00, 0x64, 0xc8, 0x00,
	0x50, 0xb7, 0x00, 0x00, 0x13, 0xc8, 0x6b, 0x00,
	0x50, 0xf7, 0xcf, 0xcf, 0xff, 0x9e, 0x04, 0x00,
	0x50, 0xb7, 0x00, 0x12, 0x2b, 0xdb, 0x7c, 0x00,
	0x50, 0xb7, 0x00, 0x00, 0x00, 0x32, 0xff, 0x1c,
	0x50, 0xb7, 0x00, 0x00, 0x00, 0x24, 0xff, 0x2f,
	0x50, 0xb7, 0x00, 0x00, 0x0c, 0xb1, 0xdb, 0x04,
	0x50, 0xff, 0xff, 0xff, 0xff, 0xab, 0x19, 0x00,
	/* ch = 'C' */
	0x00, 0x04, 0x73, 0xf7, 0xe5, 0xe5, 0x2c, 0x00,
	0x00, 0x90, 0xb1, 0x13, 0x00, 0x43, 0xff, 0x2a,
	0x27, 0xff, 0x24, 0x00, 0x00, 0x00, 0x2a, 0x04,
	0x5f, 0xcf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7c, 0xb1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7c, 0xb1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x5f, 0xcf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x2c, 0xff, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xb1, 0xb1, 0x13, 0x00, 0x28, 0xe5, 0x18,
	0x00, 0x10, 0x94, 0xf7, 0xd4, 0xef, 0x3b, 0x00,
	0x00, 0x00, 0x00, 0x0c, 0x15, 0x00, 0x00, 0x00,
	/* ch = 'D' */
	0x50, 0xff, 0xff, 0xff, 0xd4, 0x37, 0x00, 0x00,
	0x50, 0xff, 0x00, 0x04, 0x3f, 0xff, 0x44, 0x00,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x70, 0xe5, 0x04,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x2a, 0xff, 0x24,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x32,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x32,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x24, 0xff, 0x24,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x5f, 0xe5, 0x00,
	0x50, 0xff, 0x00, 0x00, 0x37, 0xff, 0x35, 0x00,
	0x50, 0xff, 0xcf, 0xff, 0xdd, 0x35, 0x00, 0x00,
	/* ch = 'E' */
	0x32, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x32, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0xcf, 0xcf, 0xcf, 0xcf, 0x1a,
	0x32, 0xff, 0x36, 0x36, 0x36, 0x36, 0x0d,
	0x32, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	/* ch = 'F' */
	0x1c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0xdd, 0xcf, 0xcf, 0xcf, 0x1a,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00,
	/* ch = 'G' */
	0x00, 0x08, 0x8d, 0xff, 0xff, 0xe5, 0x2f, 0x00,
	0x00, 0xb1, 0xb1, 0x13, 0x00, 0x54, 0xff, 0x1e,
	0x32, 0xff, 0x17, 0x00, 0x00, 0x00, 0x22, 0x00,
	0x6b, 0xb1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7c, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x82, 0x7c, 0x00, 0x00, 0x95, 0xcf, 0xcf, 0x2d,
	0x77, 0xbd, 0x00, 0x00, 0x12, 0x15, 0xff, 0x32,
	0x39, 0xff, 0x17, 0x00, 0x00, 0x00, 0xff, 0x32,
	0x04, 0xc8, 0xb1, 0x0c, 0x00, 0x16, 0xff, 0x32,
	0x00, 0x13, 0xb3, 0xff, 0xd4, 0xf7, 0x73, 0x08,
	0x00, 0x00, 0x00, 0x0c, 0x15, 0x00, 0x00, 0x00,
	/* ch = 'H' */
	0x50, 0xff, 0x04, 0x00, 0x00, 0x32, 0xff, 0x0d,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x32, 0xff, 0x00,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x32, 0xff, 0x00,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x32, 0xff, 0x00,
	0x50, 0xff, 0xcf, 0xcf, 0xcf, 0xdd, 0xff, 0x00,
	0x50, 0xff, 0x15, 0x15, 0x15, 0x3e, 0xff, 0x00,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x32, 0xff, 0x00,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x32, 0xff, 0x00,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x32, 0xff, 0x00,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x32, 0xff, 0x00,
	/* ch = 'I' */
	0xff, 0xff, 0xff, 0xff, 0xff, 0x32,
	0x00, 0x00, 0xff, 0x32, 0x00, 0x00,
	0x00, 0x00, 0xff, 0x32, 0x00, 0x00,
	0x00, 0x00, 0xff, 0x32, 0x00, 0x00,
	0x00, 0x00, 0xff, 0x32, 0x00, 0x00,
	0x00, 0x00, 0xff, 0x32, 0x00, 0x00,
	0x00, 0x00, 0xff, 0x32, 0x00, 0x00,
	0x00, 0x00, 0xff, 0x32, 0x00, 0x00,
	0x00, 0x00, 0xff, 0x32, 0x00, 0x00,
	0xff, 0xff, 0xff, 0xff, 0xff, 0x50,
	/* ch = 'J' */
	0x7c, 0xff, 0xff, 0xff, 0xff, 0x32,
	0x00, 0x00, 0x7c, 0xb7, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0xb7, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0xb7, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0xb7, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0xb7, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0xb7, 0x00, 0x00,
	0x00, 0x00, 0x82, 0x82, 0x00, 0x00,
	0x04, 0x10, 0xe5, 0x5a, 0x00, 0x00,
	0xef, 0xef, 0xa9, 0x04, 0x00, 0x00,
	0x12, 0x12, 0x00, 0x00, 0x00, 0x00,
	/* ch = 'K' */
	0x7c, 0xbd, 0x00, 0x00, 0x04, 0xb1, 0xb1, 0x08,
	0x7c, 0xb7, 0x00, 0x00, 0x7c, 0xdb, 0x10, 0x00,
	0x7c, 0xb7, 0x00, 0x5f, 0xf7, 0x1f, 0x00, 0x00,
	0x7c, 0xb7, 0x50, 0xf7, 0x21, 0x00, 0x00, 0x00,
	0x7c, 0xf7, 0xff, 0x82, 0x00, 0x00, 0x00, 0x00,
	0x7c, 0xf7, 0x50, 0xff, 0x32, 0x00, 0x00, 0x00,
	0x7c, 0xb7, 0x00, 0x7c, 0xe5, 0x10, 0x00, 0x00,
	0x7c, 0xb7, 0x00, 0x10, 0xdb, 0xa0, 0x00, 0x00,
	0x7c, 0xb7, 0x00, 0x00, 0x2f, 0xff, 0x4d, 0x00,
	0x7c, 0xb7, 0x00, 0x00, 0x00, 0x6b, 0xf7, 0x1f,
	/* ch = 'L' */
	0x32, 0xff, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	/* ch = 'M' */
	0x7c, 0xa0, 0x00, 0x00, 0x00, 0x10, 0xf7, 0x32,
	0x7c, 0xff, 0x2a, 0x00, 0x00, 0x5f, 0xff, 0x32,
	0x7c, 0xff, 0xa0, 0x00, 0x17, 0xf7, 0xff, 0x32,
	0x7c, 0xa7, 0xff, 0x2c, 0x6b, 0x90, 0xff, 0x32,
	0x7c, 0x7c, 0x70, 0xc8, 0xf7, 0x24, 0xff, 0x32,
	0x7c, 0x7c, 0x17, 0xff, 0x7c, 0x00, 0xff, 0x32,
	0x7c, 0x7c, 0x00, 0x28, 0x10, 0x00, 0xff, 0x32,
	0x7c, 0x7c, 0x00, 0x00, 0x00, 0x00, 0xff, 0x32,
	0x7c, 0x7c, 0x00, 0x00, 0x00, 0x00, 0xff, 0x32,
	0x7c, 0x7c, 0x00, 0x00, 0x00, 0x00, 0xff, 0x32,
	/* ch = 'N' */
	0x50, 0xff, 0x1c, 0x00, 0x00, 0x32, 0xff, 0x1f,
	0x50, 0xff, 0x90, 0x00, 0x00, 0x32, 0xff, 0x1c,
	0x50, 0xf7, 0xff, 0x2a, 0x00, 0x32, 0xff, 0x1c,
	0x50, 0xb7, 0x90, 0xb7, 0x00, 0x32, 0xff, 0x1c,
	0x50, 0xb7, 0x1c, 0xff, 0x44, 0x32, 0xff, 0x1c,
	0x50, 0xb7, 0x00, 0x6b, 0xe5, 0x3b, 0xff, 0x1c,
	0x50, 0xb7, 0x00, 0x10, 0xf7, 0xc8, 0xff, 0x1c,
	0x50, 0xb7, 0x00, 0x00, 0x44, 0xff, 0xff, 0x1c,
	0x50, 0xb7, 0x00, 0x00, 0x04, 0xc8, 0xff, 0x1c,
	0x50, 0xb7, 0x00, 0x00, 0x00, 0x32, 0xff, 0x1c,
	/* ch = 'O' */
	0x00, 0x19, 0xbb, 0xff, 0xff, 0x8d, 0x08, 0x00,
	0x0d, 0xdb, 0x8a, 0x08, 0x1b, 0xdb, 0x90, 0x00,
	0x48, 0xf7, 0x04, 0x00, 0x00, 0x39, 0xff, 0x22,
	0x90, 0x82, 0x00, 0x00, 0x00, 0x04, 0xff, 0x44,
	0xb7, 0x6b, 0x00, 0x00, 0x00, 0x00, 0xff, 0x50,
	0xb7, 0x7c, 0x00, 0x00, 0x00, 0x00, 0xe5, 0x50,
	0x90, 0x90, 0x00, 0x00, 0x00, 0x04, 0xff, 0x44,
	0x48, 0xf7, 0x10, 0x00, 0x00, 0x2c, 0xff, 0x22,
	0x0d, 0xdb, 0x8a, 0x08, 0x13, 0xc8, 0xa0, 0x00,
	0x00, 0x1f, 0xd4, 0xff, 0xff, 0xbb, 0x10, 0x00,
	0x00, 0x00, 0x00, 0x12, 0x0c, 0x00, 0x00, 0x00,
	/* ch = 'P' */
	0x32, 0xff, 0xff, 0xff, 0xff, 0xab, 0x19, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x1a, 0xb1, 0xdb, 0x04,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x24, 0xff, 0x24,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x2c, 0xff, 0x1c,
	0x32, 0xff, 0x4a, 0x36, 0x47, 0xef, 0x8a, 0x00,
	0x32, 0xff, 0x87, 0x74, 0x74, 0x37, 0x04, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00,
	/* ch = 'Q' */
	0x00, 0x19, 0xbb, 0xff, 0xff, 0x8d, 0x08, 0x00,
	0x0d, 0xdb, 0x8a, 0x08, 0x16, 0xdb, 0xa0, 0x00,
	0x48, 0xe5, 0x04, 0x00, 0x00, 0x2c, 0xff, 0x22,
	0x90, 0x82, 0x00, 0x00, 0x00, 0x04, 0xff, 0x44,
	0xb7, 0x5f, 0x00, 0x00, 0x00, 0x00, 0xbd, 0x50,
	0xb7, 0x77, 0x00, 0x00, 0x00, 0x00, 0xb7, 0x50,
	0x90, 0x90, 0x00, 0x00, 0x00, 0x00, 0xff, 0x44,
	0x48, 0xf7, 0x0d, 0x00, 0x00, 0x24, 0xff, 0x22,
	0x10, 0xdb, 0x7c, 0x04, 0x08, 0xb1, 0xa0, 0x00,
	0x00, 0x1f, 0xd4, 0xff, 0xff, 0xbb, 0x10, 0x00,
	0x00, 0x00, 0x00, 0x82, 0x82, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x36, 0xff, 0xcf, 0xcf, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0x30, 0x36, 0x00,
	/* ch = 'R' */
	0x50, 0xff, 0xff, 0xff, 0xf7, 0x9e, 0x13, 0x00,
	0x50, 0xff, 0x00, 0x04, 0x20, 0xdb, 0xb7, 0x00,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x3b, 0xff, 0x1a,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x48, 0xff, 0x0d,
	0x50, 0xff, 0x36, 0x36, 0x50, 0xf7, 0x6b, 0x00,
	0x50, 0xff, 0x74, 0x95, 0xff, 0x46, 0x00, 0x00,
	0x50, 0xff, 0x00, 0x04, 0xdb, 0x6b, 0x00, 0x00,
	0x50, 0xff, 0x00, 0x00, 0x3b, 0xff, 0x17, 0x00,
	0x50, 0xff, 0x00, 0x00, 0x04, 0xc8, 0x7c, 0x00,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x3b, 0xff, 0x1f,
	/* ch = 'S' */
	0x00, 0x19, 0xab, 0xff, 0xff, 0xb3, 0x1b, 0x00,
	0x00, 0xdb, 0x7c, 0x04, 0x04, 0x5f, 0xa9, 0x00,
	0x1c, 0xff, 0x35, 0x00, 0x00, 0x04, 0x08, 0x00,
	0x04, 0xdb, 0xb1, 0x13, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x19, 0xbb, 0xf7, 0x7f, 0x16, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x25, 0xa4, 0xff, 0x4d, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0xff, 0x17,
	0x00, 0x0c, 0x00, 0x00, 0x00, 0x1f, 0xff, 0x2a,
	0x2a, 0xdb, 0x1e, 0x00, 0x04, 0x7c, 0xe5, 0x0d,
	0x08, 0x7f, 0xff, 0xe5, 0xf7, 0xd4, 0x21, 0x00,
	0x00, 0x00, 0x04, 0x15, 0x0f, 0x00, 0x00, 0x00,
	/* ch = 'T' */
	0xb7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x32,
	0x00, 0x00, 0x00, 0xff, 0x50, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xff, 0x50, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xff, 0x50, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xff, 0x50, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xff, 0x50, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xff, 0x50, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xff, 0x50, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xff, 0x50, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xff, 0x50, 0x00, 0x00, 0x00,
	/* ch = 'U' */
	0x50, 0xcf, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x32,
	0x50, 0xb7, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x32,
	0x50, 0xb7, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x32,
	0x50, 0xb7, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x32,
	0x50, 0xb7, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x32,
	0x50, 0xb7, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x32,
	0x50, 0xbd, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x32,
	0x4d, 0xff, 0x04, 0x00, 0x00, 0x24, 0xff, 0x1c,
	0x22, 0xff, 0x50, 0x00, 0x04, 0x82, 0xc8, 0x04,
	0x00, 0x3b, 0xef, 0xdd, 0xef, 0xcb, 0x19, 0x00,
	0x00, 0x00, 0x00, 0x15, 0x0f, 0x00, 0x00, 0x00,
	/* ch = 'V' */
	0xa7, 0x90, 0x00, 0x00, 0x00, 0x00, 0xe5, 0x50,
	0x44, 0xff, 0x0d, 0x00, 0x00, 0x2a, 0xff, 0x1c,
	0x14, 0xff, 0x3b, 0x00, 0x00, 0x5f, 0xb7, 0x00,
	0x00, 0xa0, 0x90, 0x00, 0x00, 0xcf, 0x50, 0x00,
	0x00, 0x44, 0xff, 0x0d, 0x22, 0xff, 0x1c, 0x00,
	0x00, 0x0d, 0xff, 0x3b, 0x50, 0xb7, 0x00, 0x00,
	0x00, 0x00, 0x90, 0x90, 0xb7, 0x50, 0x00, 0x00,
	0x00, 0x00, 0x3b, 0xff, 0xff, 0x1c, 0x00, 0x00,
	0x00, 0x00, 0x0d, 0xff, 0xb7, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x90, 0x50, 0x00, 0x00, 0x00,
	/* ch = 'W' */
	0xff, 0x3b, 0x00, 0x08, 0x08, 0x00, 0x54, 0x90,
	0xb7, 0x54, 0x00, 0x5f, 0x5f, 0x00, 0x7c, 0x5f,
	0x7c, 0x82, 0x00, 0xb1, 0xa0, 0x00, 0xb1, 0x3b,
	0x50, 0xbd, 0x0d, 0xff, 0xff, 0x0d, 0xe5, 0x2a,
	0x32, 0xff, 0x35, 0xb7, 0xf7, 0x3b, 0xff, 0x14,
	0x1c, 0xff, 0xa0, 0x5f, 0x90, 0xa7, 0xe5, 0x00,
	0x04, 0xff, 0xff, 0x2a, 0x4d, 0xff, 0xb1, 0x00,
	0x00, 0xbd, 0xf7, 0x04, 0x24, 0xff, 0x77, 0x00,
	0x00, 0x82, 0x90, 0x00, 0x00, 0xe5, 0x4d, 0x00,
	0x00, 0x54, 0x50, 0x00, 0x00, 0x82, 0x32, 0x00,
	/* ch = 'X' */
	0x3b, 0xff, 0x1c, 0x00, 0x00, 0x5f, 0xdb, 0x04,
	0x00, 0xb7, 0x90, 0x00, 0x10, 0xf7, 0x3b, 0x00,
	0x00, 0x2a, 0xff, 0x2a, 0x6b, 0xc8, 0x04, 0x00,
	0x00, 0x00, 0x90, 0xc8, 0xff, 0x3b, 0x00, 0x00,
	0x00, 0x00, 0x1c, 0xff, 0xc8, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x2a, 0xff, 0xe5, 0x0d, 0x00, 0x00,
	0x00, 0x00, 0xa7, 0xb1, 0xf7, 0x5f, 0x00, 0x00,
	0x00, 0x32, 0xff, 0x24, 0x50, 0xf7, 0x17, 0x00,
	0x04, 0xc8, 0x7c, 0x00, 0x04, 0xdb, 0x7c, 0x00,
	0x3b, 0xff, 0x1c, 0x00, 0x00, 0x3b, 0xff, 0x24,
	/* ch = 'Y' */
	0x70, 0xe5, 0x04, 0x00, 0x00, 0x1c, 0xff, 0x39,
	0x17, 0xff, 0x48, 0x00, 0x00, 0x70, 0xc8, 0x00,
	0x00, 0x6b, 0xe5, 0x04, 0x17, 0xf7, 0x3b, 0x00,
	0x00, 0x17, 0xf7, 0x48, 0x5a, 0xe5, 0x04, 0x00,
	0x00, 0x00, 0x6b, 0xe5, 0xe5, 0x48, 0x00, 0x00,
	0x00, 0x00, 0x17, 0xf7, 0xe5, 0x0d, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xb7, 0x7c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xb7, 0x7c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xb7, 0x7c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xb7, 0x7c, 0x00, 0x00, 0x00,
	/* ch = 'Z' */
	0x32, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 0x90, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3b, 0xf7, 0x17, 0x00,
	0x00, 0x00, 0x00, 0x10, 0xe5, 0x54, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x77, 0xdb, 0x04, 0x00, 0x00,
	0x00, 0x00, 0x24, 0xff, 0x32, 0x00, 0x00, 0x00,
	0x00, 0x04, 0xb7, 0x90, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x4d, 0xf7, 0x17, 0x00, 0x00, 0x00, 0x00,
	0x17, 0xf7, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x32,
	/* ch = '[' */
	0x1a, 0xcf, 0xcf, 0xcf, 0xcf, 0x67,
	0x1c, 0xff, 0x28, 0x15, 0x15, 0x0f,
	0x1c, 0xff, 0x1c, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x1c, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x1c, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x1c, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x1c, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x1c, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x1c, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x1c, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x1c, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x4a, 0x36, 0x36, 0x26,
	0x0d, 0x36, 0x36, 0x36, 0x36, 0x26,
	/* ch = '\' */
	0x08, 0x5b, 0x0d,
	0x0d, 0xf7, 0x50,
	0x00, 0x5a, 0xe5,
	0x00, 0x10, 0xf7,
	0x00, 0x00, 0x70,
	0x00, 0x00, 0x17,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	/* ch = ']' */
	0xcf, 0xcf, 0xcf, 0xcf, 0x95,
	0x15, 0x15, 0x15, 0x5e, 0xb7,
	0x00, 0x00, 0x00, 0x50, 0xb7,
	0x00, 0x00, 0x00, 0x50, 0xb7,
	0x00, 0x00, 0x00, 0x50, 0xb7,
	0x00, 0x00, 0x00, 0x50, 0xb7,
	0x00, 0x00, 0x00, 0x50, 0xb7,
	0x00, 0x00, 0x00, 0x50, 0xb7,
	0x00, 0x00, 0x00, 0x50, 0xb7,
	0x00, 0x00, 0x00, 0x50, 0xb7,
	0x00, 0x00, 0x00, 0x50, 0xb7,
	0x36, 0x36, 0x36, 0x82, 0xb7,
	0x36, 0x36, 0x36, 0x36, 0x2d,
	/* ch = '^' */
	0x00, 0x00, 0x7c, 0x5a, 0x00, 0x00,
	0x00, 0x2a, 0xff, 0xf7, 0x10, 0x00,
	0x04, 0xc8, 0x5f, 0xb7, 0x6b, 0x00,
	0x4d, 0xdb, 0x04, 0x2a, 0xf7, 0x17,
	0x28, 0x2a, 0x00, 0x00, 0x48, 0x0c,
	/* ch = '_' */
	0x58, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x30,
	0x12, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x0c,
	/* ch = '`' */
	0x09, 0x7f, 0x1c,
	0x00, 0xa7, 0x5f,
	0x00, 0x44, 0xff,
	0x00, 0x04, 0xb1,
	/* ch = 'a' */
	0x00, 0x00, 0x20, 0x36, 0x36, 0x16, 0x00,
	0x00, 0x7f, 0xd4, 0x5b, 0x82, 0xff, 0x32,
	0x00, 0x0c, 0x04, 0x00, 0x00, 0x64, 0xbd,
	0x00, 0x00, 0x08, 0x15, 0x2a, 0x82, 0xff,
	0x04, 0x7e, 0xef, 0x82, 0x74, 0xb1, 0xff,
	0x44, 0xff, 0x1a, 0x00, 0x00, 0x54, 0xff,
	0x4d, 0xff, 0x10, 0x00, 0x13, 0xdb, 0xff,
	0x10, 0xbb, 0xef, 0xcf, 0xef, 0xc4, 0xff,
	0x00, 0x00, 0x12, 0x15, 0x00, 0x00, 0x00,
	/* ch = 'b' */
	0x22, 0x74, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x21, 0x30, 0x36, 0x1b, 0x00, 0x00,
	0x32, 0xff, 0xe5, 0x82, 0xa4, 0xff, 0x39, 0x00,
	0x32, 0xff, 0x3b, 0x00, 0x00, 0x82, 0xf7, 0x0d,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x32, 0xff, 0x2a,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x1c, 0xff, 0x32,
	0x32, 0xff, 0x1f, 0x00, 0x00, 0x35, 0xff, 0x1c,
	0x32, 0xff, 0x59, 0x00, 0x10, 0xb7, 0xa0, 0x00,
	0x32, 0xc8, 0x94, 0xe5, 0xff, 0xd4, 0x19, 0x00,
	0x00, 0x00, 0x00, 0x0f, 0x12, 0x00, 0x00, 0x00,
	/* ch = 'c' */
	0x00, 0x00, 0x08, 0x30, 0x36, 0x2a, 0x04, 0x00,
	0x00, 0x2c, 0xef, 0xb3, 0x74, 0xe5, 0xd4, 0x10,
	0x0d, 0xe5, 0x7c, 0x00, 0x00, 0x08, 0x8d, 0x04,
	0x2f, 0xff, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x40, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x2a, 0xff, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xb1, 0xdb, 0x13, 0x00, 0x1b, 0x7e, 0x04,
	0x00, 0x10, 0xb3, 0xff, 0xf7, 0xf7, 0x66, 0x04,
	0x00, 0x00, 0x00, 0x0f, 0x15, 0x08, 0x00, 0x00,
	/* ch = 'd' */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x74,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0xff,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0xff,
	0x00, 0x00, 0x2a, 0x36, 0x30, 0x35, 0xff,
	0x00, 0x7c, 0xdb, 0x47, 0xab, 0xf7, 0xff,
	0x2c, 0xff, 0x1f, 0x00, 0x00, 0x97, 0xff,
	0x54, 0xbd, 0x00, 0x00, 0x00, 0x50, 0xff,
	0x77, 0xb7, 0x00, 0x00, 0x00, 0x50, 0xff,
	0x4d, 0xff, 0x0d, 0x00, 0x00, 0x6b, 0xff,
	0x17, 0xff, 0x59, 0x00, 0x21, 0xe5, 0xff,
	0x00, 0x3b, 0xf7, 0xef, 0xef, 0x99, 0xff,
	0x00, 0x00, 0x08, 0x15, 0x00, 0x00, 0x00,
	/* ch = 'e' */
	0x00, 0x00, 0x1b, 0x36, 0x36, 0x16, 0x00, 0x00,
	0x00, 0x50, 0xf7, 0x50, 0x73, 0xff, 0x32, 0x00,
	0x22, 0xff, 0x2c, 0x00, 0x00, 0x64, 0xc8, 0x00,
	0x4d, 0xff, 0x36, 0x36, 0x36, 0x62, 0xff, 0x0d,
	0x50, 0xff, 0x74, 0x74, 0x74, 0x74, 0x74, 0x14,
	0x44, 0xff, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x10, 0xf7, 0x7c, 0x04, 0x00, 0x21, 0x2f, 0x00,
	0x00, 0x26, 0xd4, 0xe5, 0xd4, 0xef, 0x35, 0x00,
	0x00, 0x00, 0x00, 0x12, 0x15, 0x00, 0x00, 0x00,
	/* ch = 'f' */
	0x00, 0x00, 0x00, 0x21, 0x82, 0xbd, 0x5b,
	0x00, 0x00, 0x2a, 0xff, 0x47, 0x1a, 0x99,
	0x00, 0x00, 0x7c, 0xa0, 0x00, 0x00, 0x10,
	0x00, 0x00, 0x7c, 0x7c, 0x00, 0x00, 0x00,
	0x2d, 0xcf, 0xef, 0xef, 0xcf, 0xcf, 0x1a,
	0x00, 0x00, 0x7c, 0x7c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0x7c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0x7c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0x7c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0x7c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0x7c, 0x00, 0x00, 0x00,
	/* ch = 'g' */
	0x00, 0x04, 0x37, 0x74, 0x37, 0x16, 0x3e, 0x2a,
	0x00, 0xa9, 0xc4, 0x36, 0xd4, 0xff, 0x50, 0x30,
	0x2a, 0xff, 0x17, 0x00, 0x24, 0xff, 0x1c, 0x00,
	0x2f, 0xff, 0x17, 0x00, 0x24, 0xff, 0x1c, 0x00,
	0x04, 0xb1, 0xd4, 0x47, 0xd4, 0x7c, 0x00, 0x00,
	0x00, 0x7c, 0x6a, 0x50, 0x2a, 0x00, 0x00, 0x00,
	0x11, 0xff, 0x53, 0x15, 0x15, 0x15, 0x00, 0x00,
	0x04, 0xab, 0xa4, 0x8f, 0xcf, 0xe5, 0xb1, 0x04,
	0x66, 0x97, 0x00, 0x00, 0x00, 0x1f, 0xff, 0x27,
	0x66, 0xe5, 0x2b, 0x15, 0x1a, 0x8a, 0xdb, 0x0d,
	0x04, 0x3f, 0x8f, 0xcf, 0xab, 0x5b, 0x08, 0x00,
	/* ch = 'h' */
	0x14, 0x74, 0x28, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x32, 0x22, 0x36, 0x25, 0x00,
	0x1c, 0xff, 0xd4, 0xbb, 0x8f, 0xff, 0x4d,
	0x1c, 0xff, 0x82, 0x04, 0x00, 0x7c, 0xb7,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x50, 0xf7,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x50, 0xff,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x50, 0xff,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x50, 0xff,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x50, 0xff,
	/* ch = 'i' */
	0x00, 0x00, 0x30, 0x28, 0x00, 0x00,
	0x00, 0x09, 0xf7, 0xb1, 0x00, 0x00,
	0x00, 0x00, 0x0c, 0x08, 0x00, 0x00,
	0x26, 0x36, 0x36, 0x26, 0x00, 0x00,
	0x42, 0x74, 0xe5, 0x7c, 0x00, 0x00,
	0x00, 0x00, 0xb7, 0x7c, 0x00, 0x00,
	0x00, 0x00, 0xb7, 0x7c, 0x00, 0x00,
	0x00, 0x00, 0xb7, 0x7c, 0x00, 0x00,
	0x00, 0x00, 0xb7, 0x7c, 0x00, 0x00,
	0x00, 0x00, 0xb7, 0x7c, 0x00, 0x00,
	0x7c, 0xff, 0xff, 0xff, 0xff, 0x32,
	/* ch = 'j' */
	0x00, 0x00, 0x00, 0x00, 0x21, 0x30,
	0x00, 0x00, 0x00, 0x00, 0xa0, 0xff,
	0x00, 0x00, 0x00, 0x00, 0x08, 0x0c,
	0x00, 0x16, 0x36, 0x36, 0x36, 0x2d,
	0x00, 0x22, 0x74, 0x74, 0xc8, 0xb7,
	0x00, 0x00, 0x00, 0x00, 0x7c, 0xb7,
	0x00, 0x00, 0x00, 0x00, 0x7c, 0xb7,
	0x00, 0x00, 0x00, 0x00, 0x7c, 0xb7,
	0x00, 0x00, 0x00, 0x00, 0x7c, 0xb7,
	0x00, 0x00, 0x00, 0x00, 0x7c, 0xb7,
	0x00, 0x00, 0x00, 0x00, 0x7c, 0xb7,
	0x00, 0x0c, 0x00, 0x00, 0x82, 0xb1,
	0x2f, 0xdb, 0x2b, 0x37, 0xff, 0x44,
	0x04, 0x5b, 0xcf, 0xbd, 0x37, 0x00,
	/* ch = 'k' */
	0x22, 0x74, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x21, 0x25, 0x09,
	0x32, 0xff, 0x1c, 0x00, 0x35, 0xff, 0x35, 0x00,
	0x32, 0xff, 0x1c, 0x44, 0xf7, 0x2c, 0x00, 0x00,
	0x32, 0xff, 0x7c, 0xff, 0x31, 0x00, 0x00, 0x00,
	0x32, 0xff, 0xdb, 0xdb, 0xb1, 0x04, 0x00, 0x00,
	0x32, 0xff, 0x1f, 0x1f, 0xf7, 0x7c, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x44, 0xff, 0x4d, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x7c, 0xf7, 0x21,
	/* ch = 'l' */
	0x74, 0x74, 0x74, 0x42, 0x00, 0x00,
	0x15, 0x15, 0xbd, 0x7c, 0x00, 0x00,
	0x00, 0x00, 0xb7, 0x7c, 0x00, 0x00,
	0x00, 0x00, 0xb7, 0x7c, 0x00, 0x00,
	0x00, 0x00, 0xb7, 0x7c, 0x00, 0x00,
	0x00, 0x00, 0xb7, 0x7c, 0x00, 0x00,
	0x00, 0x00, 0xb7, 0x7c, 0x00, 0x00,
	0x00, 0x00, 0xb7, 0x7c, 0x00, 0x00,
	0x00, 0x00, 0xb7, 0x7c, 0x00, 0x00,
	0x00, 0x00, 0xb7, 0x7c, 0x00, 0x00,
	0xff, 0xff, 0xff, 0xff, 0xff, 0x7c,
	/* ch = 'm' */
	0x26, 0x28, 0x30, 0x30, 0x08, 0x36, 0x30, 0x00,
	0x7c, 0xff, 0x66, 0xf7, 0xef, 0x5a, 0xff, 0x39,
	0x7c, 0x90, 0x00, 0xb7, 0x90, 0x00, 0xbd, 0x50,
	0x7c, 0x7c, 0x00, 0xb7, 0x7c, 0x00, 0xb7, 0x50,
	0x7c, 0x7c, 0x00, 0xb7, 0x7c, 0x00, 0xb7, 0x50,
	0x7c, 0x7c, 0x00, 0xb7, 0x7c, 0x00, 0xb7, 0x50,
	0x7c, 0x7c, 0x00, 0xb7, 0x7c, 0x00, 0xb7, 0x50,
	0x7c, 0x7c, 0x00, 0xb7, 0x7c, 0x00, 0xb7, 0x50,
	/* ch = 'n' */
	0x0d, 0x36, 0x16, 0x25, 0x36, 0x22, 0x00,
	0x1c, 0xff, 0xd4, 0xbb, 0x8f, 0xff, 0x44,
	0x1c, 0xff, 0x7c, 0x00, 0x00, 0x90, 0xb1,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x50, 0xb7,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x50, 0xb7,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x50, 0xb7,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x50, 0xb7,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x50, 0xb7,
	/* ch = 'o' */
	0x00, 0x00, 0x16, 0x36, 0x36, 0x0c, 0x00, 0x00,
	0x00, 0x4d, 0xf7, 0x82, 0xa4, 0xf7, 0x32, 0x00,
	0x24, 0xff, 0x35, 0x00, 0x00, 0x82, 0xe5, 0x04,
	0x6b, 0xe5, 0x00, 0x00, 0x00, 0x24, 0xff, 0x2a,
	0x7c, 0xb7, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x32,
	0x5f, 0xff, 0x0d, 0x00, 0x00, 0x2c, 0xff, 0x24,
	0x17, 0xf7, 0x7c, 0x04, 0x08, 0xb1, 0xb7, 0x00,
	0x00, 0x26, 0xef, 0xe5, 0xef, 0xbb, 0x13, 0x00,
	0x00, 0x00, 0x00, 0x15, 0x12, 0x00, 0x00, 0x00,
	/* ch = 'p' */
	0x16, 0x36, 0x13, 0x30, 0x36, 0x1e, 0x00, 0x00,
	0x32, 0xff, 0xe5, 0x82, 0xa4, 0xff, 0x4d, 0x00,
	0x32, 0xff, 0x3b, 0x00, 0x00, 0x6b, 0xf7, 0x14,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x24, 0xff, 0x32,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x1c, 0xff, 0x32,
	0x32, 0xff, 0x1f, 0x00, 0x00, 0x2a, 0xff, 0x2a,
	0x32, 0xff, 0x64, 0x00, 0x08, 0xb1, 0xc8, 0x04,
	0x32, 0xff, 0xbb, 0xe5, 0xf7, 0xd4, 0x1f, 0x00,
	0x32, 0xff, 0x1c, 0x0f, 0x15, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x22, 0x74, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00,
	/* ch = 'q' */
	0x00, 0x00, 0x25, 0x36, 0x30, 0x19, 0x36,
	0x00, 0x7c, 0xef, 0x50, 0xa4, 0xf7, 0xff,
	0x2c, 0xff, 0x24, 0x00, 0x00, 0x90, 0xff,
	0x6b, 0xcf, 0x00, 0x00, 0x00, 0x50, 0xff,
	0x7c, 0xb7, 0x00, 0x00, 0x00, 0x50, 0xff,
	0x50, 0xff, 0x0d, 0x00, 0x00, 0x5f, 0xff,
	0x17, 0xf7, 0x7c, 0x00, 0x13, 0xe5, 0xff,
	0x00, 0x35, 0xf7, 0xef, 0xef, 0x7c, 0xff,
	0x00, 0x00, 0x04, 0x15, 0x04, 0x32, 0xff,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0xff,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x74,
	/* ch = 'r' */
	0x26, 0x2d, 0x0c, 0x36, 0x36, 0x1e, 0x00,
	0x7c, 0xe5, 0xef, 0x9e, 0x82, 0xff, 0x1d,
	0x7c, 0xff, 0x50, 0x00, 0x00, 0x22, 0x00,
	0x7c, 0xcf, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7c, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7c, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7c, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7c, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00,
	/* ch = 's' */
	0x00, 0x00, 0x1e, 0x36, 0x36, 0x1e, 0x00,
	0x00, 0x50, 0xf7, 0x47, 0x50, 0xef, 0x7e,
	0x00, 0xef, 0x68, 0x00, 0x00, 0x1f, 0x2c,
	0x00, 0x73, 0xff, 0x7f, 0x25, 0x04, 0x00,
	0x00, 0x00, 0x22, 0x8f, 0xf7, 0xef, 0x2c,
	0x00, 0x0c, 0x00, 0x00, 0x04, 0x82, 0xf7,
	0x17, 0xd4, 0x1b, 0x00, 0x00, 0x82, 0xc8,
	0x0c, 0x7f, 0xff, 0xd4, 0xef, 0xd4, 0x21,
	0x00, 0x00, 0x04, 0x15, 0x12, 0x00, 0x00,
	/* ch = 't' */
	0x00, 0x00, 0x10, 0x36, 0x13, 0x00, 0x00,
	0x00, 0x00, 0x32, 0xff, 0x14, 0x00, 0x00,
	0x0d, 0x36, 0x82, 0xff, 0x36, 0x36, 0x16,
	0x14, 0x74, 0xb1, 0xff, 0x74, 0x74, 0x22,
	0x00, 0x00, 0x50, 0xcf, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0xb7, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0xb7, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0xb7, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x5f, 0xff, 0x1a, 0x0c, 0x48,
	0x00, 0x00, 0x1c, 0xdb, 0xff, 0xff, 0x8d,
	0x00, 0x00, 0x00, 0x00, 0x15, 0x04, 0x00,
	/* ch = 'u' */
	0x16, 0x36, 0x0d, 0x00, 0x00, 0x1e, 0x36,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x50, 0xff,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x50, 0xff,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x50, 0xff,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x50, 0xff,
	0x32, 0xff, 0x1f, 0x00, 0x00, 0x6b, 0xff,
	0x14, 0xff, 0x54, 0x00, 0x19, 0xf7, 0xff,
	0x00, 0x44, 0xf7, 0xd4, 0xe5, 0xa0, 0xff,
	0x00, 0x00, 0x08, 0x15, 0x04, 0x00, 0x00,
	/* ch = 'v' */
	0x26, 0x36, 0x00, 0x00, 0x00, 0x04, 0x36, 0x13,
	0x39, 0xff, 0x17, 0x00, 0x00, 0x2a, 0xff, 0x14,
	0x04, 0xe5, 0x5a, 0x00, 0x00, 0x5f, 0xa0, 0x00,
	0x00, 0x6b, 0xe5, 0x04, 0x04, 0xe5, 0x39, 0x00,
	0x00, 0x22, 0xff, 0x32, 0x39, 0xe5, 0x04, 0x00,
	0x00, 0x00, 0xa7, 0x8a, 0xa7, 0x5a, 0x00, 0x00,
	0x00, 0x00, 0x3b, 0xff, 0xff, 0x17, 0x00, 0x00,
	0x00, 0x00, 0x0d, 0xf7, 0x8a, 0x00, 0x00, 0x00,
	/* ch = 'w' */
	0x36, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x26, 0x26,
	0xe5, 0x44, 0x00, 0x45, 0x30, 0x00, 0x7c, 0x5f,
	0x90, 0x77, 0x00, 0xcf, 0x90, 0x00, 0xb7, 0x44,
	0x54, 0xb1, 0x1a, 0xff, 0xff, 0x0d, 0xe5, 0x2a,
	0x2f, 0xff, 0x3f, 0x90, 0xe5, 0x3b, 0xff, 0x1a,
	0x14, 0xff, 0xc8, 0x44, 0x7c, 0xb7, 0xe5, 0x00,
	0x00, 0xcf, 0xff, 0x1c, 0x3b, 0xff, 0xa0, 0x00,
	0x00, 0x90, 0xcf, 0x00, 0x0d, 0xff, 0x5f, 0x00,
	/* ch = 'x' */
	0x1c, 0x36, 0x04, 0x00, 0x00, 0x21, 0x33, 0x00,
	0x0d, 0xdb, 0x7c, 0x00, 0x17, 0xf7, 0x44, 0x00,
	0x00, 0x2a, 0xff, 0x32, 0xa0, 0xa0, 0x00, 0x00,
	0x00, 0x00, 0x5f, 0xff, 0xf7, 0x17, 0x00, 0x00,
	0x00, 0x00, 0x21, 0xff, 0xb7, 0x00, 0x00, 0x00,
	0x00, 0x04, 0xb1, 0xb1, 0xf7, 0x50, 0x00, 0x00,
	0x00, 0x54, 0xf7, 0x10, 0x44, 0xff, 0x1f, 0x00,
	0x24, 0xff, 0x3b, 0x00, 0x00, 0x82, 0xdb, 0x08,
	/* ch = 'y' */
	0x24, 0x36, 0x0d, 0x00, 0x00, 0x0d, 0x36, 0x16,
	0x2c, 0xff, 0x2c, 0x00, 0x00, 0x32, 0xff, 0x17,
	0x00, 0xc8, 0x70, 0x00, 0x00, 0x70, 0xa7, 0x00,
	0x00, 0x48, 0xf7, 0x0d, 0x04, 0xe5, 0x3b, 0x00,
	0x00, 0x0d, 0xf7, 0x48, 0x32, 0xf7, 0x0d, 0x00,
	0x00, 0x00, 0x70, 0xc8, 0x8a, 0x7c, 0x00, 0x00,
	0x00, 0x00, 0x22, 0xff, 0xff, 0x2c, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xa7, 0xcf, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xc8, 0x5a, 0x00, 0x00, 0x00,
	0x60, 0x2b, 0x5f, 0xf7, 0x17, 0x00, 0x00, 0x00,
	0x48, 0xcf, 0x9e, 0x26, 0x00, 0x00, 0x00, 0x00,
	/* ch = 'z' */
	0x0d, 0x36, 0x36, 0x36, 0x36, 0x36, 0x2d, 0x00,
	0x14, 0x74, 0x74, 0x74, 0x7b, 0xff, 0x99, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7c, 0xdb, 0x10, 0x00,
	0x00, 0x00, 0x00, 0x50, 0xf7, 0x1f, 0x00, 0x00,
	0x00, 0x00, 0x32, 0xff, 0x32, 0x00, 0x00, 0x00,
	0x00, 0x1f, 0xf7, 0x5f, 0x00, 0x00, 0x00, 0x00,
	0x10, 0xdb, 0xb1, 0x04, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1c,
	/* ch = '{' */
	0x00, 0x00, 0x12, 0x15, 0x0c,
	0x10, 0xbb, 0xe5, 0xcf, 0x45,
	0x66, 0xcf, 0x04, 0x00, 0x00,
	0x7c, 0x7c, 0x00, 0x00, 0x00,
	0x7c, 0xa9, 0x00, 0x00, 0x00,
	0xa7, 0x6b, 0x00, 0x00, 0x00,
	0xbb, 0x10, 0x00, 0x00, 0x00,
	0xf7, 0x1f, 0x00, 0x00, 0x00,
	0xa0, 0x77, 0x00, 0x00, 0x00,
	0x82, 0x7c, 0x00, 0x00, 0x00,
	0xb7, 0x7c, 0x00, 0x00, 0x00,
	0x90, 0xa7, 0x00, 0x00, 0x00,
	0x2f, 0xff, 0x65, 0x36, 0x1e,
	0x00, 0x22, 0x67, 0x74, 0x30,
	/* ch = '|' */
	0x2d, 0x1e,
	0xb7, 0x50,
	0xb7, 0x50,
	0xb7, 0x50,
	0xb7, 0x50,
	0xb7, 0x50,
	0xb7, 0x50,
	0xb7, 0x50,
	0xb7, 0x50,
	0xb7, 0x50,
	0xb7, 0x50,
	0xb7, 0x50,
	0xb7, 0x50,
	0x2d, 0x1e,
	/* ch = '}' */
	0x12, 0x15, 0x0c, 0x00, 0x00,
	0x95, 0xcf, 0xef, 0x66, 0x00,
	0x00, 0x00, 0x26, 0xff, 0x2a,
	0x00, 0x00, 0x00, 0xff, 0x32,
	0x00, 0x00, 0x0a, 0xff, 0x32,
	0x00, 0x00, 0x00, 0xe5, 0x48,
	0x00, 0x00, 0x00, 0x2c, 0xe5,
	0x00, 0x00, 0x00, 0x50, 0xdb,
	0x00, 0x00, 0x00, 0xf7, 0x4d,
	0x00, 0x00, 0x00, 0xff, 0x3b,
	0x00, 0x00, 0x00, 0xff, 0x50,
	0x00, 0x00, 0x17, 0xff, 0x3b,
	0x2d, 0x36, 0x99, 0xef, 0x10,
	0x58, 0x74, 0x50, 0x13, 0x00,
	/* ch = '~' */
	0x00, 0x13, 0x36, 0x25, 0x00, 0x00, 0x0f, 0x00,
	0x32, 0xf7, 0x8f, 0xef, 0x94, 0x31, 0xef, 0x45,
	0x13, 0x3d, 0x00, 0x13, 0x9e, 0xcf, 0x37, 0x00
};

/* font_inconsolata_17px */
static const unsigned char font_bitmap_17px_bytes[] = {
	/* ch = '!' */
	0x00, 0x22, 0x1b,
	0x04, 0xff, 0xe5,
	0x04, 0xff, 0xf7,
	0x00, 0xff, 0xb7,
	0x00, 0xbd, 0xb7,
	0x00, 0xb7, 0x7c,
	0x00, 0xb7, 0x7c,
	0x00, 0x90, 0x5f,
	0x00, 0x42, 0x30,
	0x00, 0x00, 0x00,
	0x0d, 0xab, 0x8d,
	0x1c, 0xff, 0xe5,
	0x00, 0x0f, 0x0c,
	/* ch = '"' */
	0x00, 0x22, 0x13, 0x00, 0x22, 0x13,
	0x00, 0xf7, 0xa0, 0x00, 0xff, 0x7c,
	0x00, 0xec, 0x7c, 0x00, 0xff, 0x6b,
	0x0d, 0xff, 0x39, 0x14, 0xff, 0x2c,
	0x30, 0xef, 0x0d, 0x3a, 0xe5, 0x04,
	/* ch = '#' */
	0x00, 0x00, 0x2a, 0x6f, 0x00, 0x30, 0x58, 0x00, 0x00,
	0x00, 0x00, 0x50, 0xb7, 0x00, 0x77, 0xa0, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0x82, 0x00, 0x90, 0x77, 0x00, 0x00,
	0x67, 0xcf, 0xef, 0xef, 0xcf, 0xf7, 0xe5, 0xcf, 0x09,
	0x0f, 0x00, 0xbd, 0x50, 0x00, 0xff, 0x35, 0x00, 0x00,
	0x00, 0x00, 0xff, 0x32, 0x14, 0xff, 0x2a, 0x00, 0x00,
	0x00, 0x14, 0xff, 0x24, 0x1f, 0xff, 0x28, 0x12, 0x00,
	0x95, 0xdd, 0xff, 0xcf, 0xdd, 0xff, 0x74, 0x45, 0x00,
	0x00, 0x32, 0xff, 0x00, 0x4d, 0xcf, 0x00, 0x00, 0x00,
	0x00, 0x4d, 0xb7, 0x00, 0x6b, 0xa0, 0x00, 0x00, 0x00,
	0x00, 0x4e, 0x78, 0x00, 0x67, 0x67, 0x00, 0x00, 0x00,
	/* ch = '$' */
	0x00, 0x00, 0x00, 0x00, 0x08, 0x04, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x32, 0xff, 0x00, 0x00, 0x00,
	0x00, 0x10, 0x8d, 0xff, 0xff, 0xf7, 0x73, 0x04,
	0x00, 0x99, 0xb1, 0x37, 0xff, 0x1e, 0xdb, 0x2d,
	0x00, 0xff, 0x54, 0x32, 0xff, 0x00, 0x0c, 0x00,
	0x00, 0x77, 0xf7, 0x7c, 0xff, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x5b, 0xef, 0xff, 0x73, 0x1b, 0x00,
	0x00, 0x00, 0x00, 0x32, 0xff, 0x94, 0xf7, 0x32,
	0x00, 0x00, 0x00, 0x32, 0xff, 0x00, 0x97, 0xa0,
	0x00, 0x40, 0x00, 0x32, 0xff, 0x00, 0x97, 0x90,
	0x1a, 0xf7, 0xbb, 0x62, 0xff, 0x77, 0xf7, 0x2a,
	0x00, 0x13, 0x50, 0xbb, 0xff, 0x73, 0x1b, 0x00,
	0x00, 0x00, 0x00, 0x2d, 0xcf, 0x00, 0x00, 0x00,
	/* ch = '%' */
	0x10, 0x8d, 0xbd, 0x2f, 0x00, 0x00, 0x51, 0x47,
	0x7c, 0x90, 0x3a, 0xf7, 0x14, 0x2a, 0xff, 0x1c,
	0xb7, 0x50, 0x1c, 0xff, 0x2f, 0xb7, 0x6b, 0x00,
	0x6b, 0xb7, 0x53, 0xf7, 0x47, 0xf7, 0x10, 0x00,
	0x04, 0x5b, 0x74, 0x28, 0xdb, 0x50, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x50, 0xdb, 0x04, 0x00, 0x00,
	0x00, 0x00, 0x10, 0xf7, 0x3b, 0x0f, 0x15, 0x00,
	0x00, 0x00, 0x6b, 0xb7, 0x49, 0xef, 0xd4, 0x7c,
	0x00, 0x1c, 0xff, 0x2a, 0xbd, 0x54, 0x1f, 0xff,
	0x00, 0x90, 0x90, 0x00, 0xbd, 0x54, 0x24, 0xff,
	0x2a, 0xff, 0x1c, 0x00, 0x32, 0xf7, 0xe5, 0x77,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x12, 0x00,
	/* ch = '&' */
	0x00, 0x00, 0x3f, 0x74, 0x67, 0x13, 0x00, 0x00, 0x00,
	0x00, 0x4d, 0xf7, 0x47, 0xb1, 0xc8, 0x00, 0x00, 0x00,
	0x00, 0xa9, 0x97, 0x00, 0x32, 0xff, 0x1c, 0x00, 0x00,
	0x00, 0x5f, 0xe5, 0x0d, 0x50, 0xe5, 0x04, 0x00, 0x00,
	0x00, 0x10, 0xf7, 0xab, 0xf7, 0x32, 0x00, 0x00, 0x00,
	0x00, 0x19, 0xdb, 0xff, 0x4f, 0x00, 0x00, 0x00, 0x00,
	0x10, 0xdb, 0x8a, 0x70, 0xf7, 0x1c, 0x2f, 0x5a, 0x04,
	0x5a, 0xff, 0x17, 0x04, 0xb1, 0xb1, 0x90, 0xb7, 0x00,
	0x7c, 0xd9, 0x00, 0x00, 0x1c, 0xf7, 0xf7, 0x1f, 0x00,
	0x5a, 0xff, 0x35, 0x04, 0x50, 0xff, 0xff, 0x32, 0x00,
	0x04, 0xa9, 0xff, 0xff, 0xe5, 0x2c, 0x82, 0xbb, 0x00,
	0x00, 0x00, 0x0f, 0x12, 0x00, 0x00, 0x08, 0x04, 0x00,
	/* ch = ''' */
	0x04, 0x2a, 0x04,
	0x32, 0xff, 0x39,
	0x32, 0xff, 0x2a,
	0x44, 0xe5, 0x04,
	0x7e, 0x70, 0x00,
	/* ch = '(' */
	0x00, 0x04, 0x22, 0x00,
	0x19, 0xd4, 0xdd, 0x09,
	0xef, 0x8a, 0x04, 0x00,
	0xb1, 0x04, 0x00, 0x00,
	0x24, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x17, 0x00, 0x00, 0x00,
	0x82, 0x00, 0x00, 0x00,
	0xff, 0x35, 0x00, 0x00,
	0x6b, 0xff, 0x48, 0x00,
	0x00, 0x35, 0xd4, 0x04,
	/* ch = ')' */
	0x22, 0x00, 0x00, 0x00,
	0xdb, 0xbb, 0x19, 0x00,
	0x13, 0xb1, 0xdb, 0x1f,
	0x00, 0x08, 0xb7, 0xc8,
	0x00, 0x00, 0x24, 0xff,
	0x00, 0x00, 0x00, 0xa0,
	0x00, 0x00, 0x00, 0x4d,
	0x00, 0x00, 0x00, 0x32,
	0x00, 0x00, 0x00, 0x35,
	0x00, 0x00, 0x00, 0x5f,
	0x00, 0x00, 0x04, 0xcf,
	0x00, 0x00, 0x4d, 0xff,
	0x00, 0x26, 0xf7, 0x54,
	0x3f, 0xf7, 0x77, 0x00,
	0xd4, 0x37, 0x00, 0x00,
	/* ch = '*' */
	0x00, 0x00, 0x00, 0x67, 0xb5, 0x00, 0x00, 0x00,
	0x08, 0x04, 0x00, 0x6b, 0xb7, 0x00, 0x00, 0x00,
	0x48, 0xe5, 0x48, 0x59, 0x7c, 0x31, 0xbb, 0x5f,
	0x08, 0x2a, 0x8f, 0xef, 0xf7, 0x9e, 0x37, 0x0c,
	0x00, 0x00, 0x1f, 0xef, 0xdb, 0x32, 0x00, 0x00,
	0x00, 0x1f, 0xdb, 0x50, 0x32, 0xf7, 0x1f, 0x00,
	0x00, 0x8d, 0xb1, 0x04, 0x00, 0x82, 0xa4, 0x00,
	0x00, 0x04, 0x08, 0x00, 0x00, 0x08, 0x04, 0x00,
	/* ch = '+' */
	0x00, 0x00, 0x00, 0x45, 0x95, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x50, 0xb7, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x50, 0xb7, 0x00, 0x00, 0x00,
	0x50, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7c,
	0x00, 0x00, 0x00, 0x50, 0xb7, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x50, 0xb7, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x50, 0xb7, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x0c, 0x12, 0x00, 0x00, 0x00,
	/* ch = ',' */
	0x0d, 0x9e, 0x5b, 0x00,
	0x22, 0xf7, 0xff, 0x1c,
	0x00, 0x54, 0xf7, 0x0d,
	0x04, 0xb1, 0x50, 0x00,
	0x2d, 0x73, 0x00, 0x00,
	/* ch = '-' */
	0x1c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x32,
	0x04, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x08,
	/* ch = '.' */
	0x0d, 0x9e, 0x66,
	0x22, 0xff, 0xe5,
	0x00, 0x0f, 0x0c,
	/* ch = '/' */
	0x00, 0x12, 0x00,
	0x2c, 0xff, 0x2d,
	0xa0, 0xb7, 0x00,
	0xff, 0x39, 0x00,
	0xc8, 0x04, 0x00,
	0x44, 0x00, 0x00,
	0x04, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	/* ch = '0' */
	0x00, 0x00, 0x19, 0x67, 0x74, 0x22, 0x00, 0x00,
	0x00, 0x1f, 0xf7, 0x85, 0x5a, 0xff, 0x32, 0x00,
	0x00, 0xa0, 0x90, 0x00, 0x00, 0x64, 0xe5, 0x04,
	0x1c, 0xff, 0x2a, 0x00, 0x10, 0xdb, 0xff, 0x32,
	0x35, 0xff, 0x04, 0x00, 0xa0, 0xb1, 0xcf, 0x50,
	0x50, 0xff, 0x00, 0x50, 0xe5, 0x10, 0xb7, 0x7c,
	0x4d, 0xff, 0x32, 0xff, 0x32, 0x00, 0xb7, 0x77,
	0x2f, 0xff, 0xff, 0x50, 0x00, 0x00, 0xe5, 0x4d,
	0x0d, 0xf7, 0x97, 0x00, 0x00, 0x22, 0xff, 0x24,
	0x00, 0x5f, 0xf7, 0x21, 0x08, 0xb1, 0xa0, 0x00,
	0x00, 0x04, 0x84, 0xff, 0xff, 0xbb, 0x10, 0x00,
	0x00, 0x00, 0x00, 0x0f, 0x12, 0x00, 0x00, 0x00,
	/* ch = '1' */
	0x00, 0x00, 0x37, 0x74, 0x14,
	0x28, 0xcb, 0xff, 0xff, 0x1c,
	0x39, 0x25, 0x54, 0xff, 0x1c,
	0x00, 0x00, 0x50, 0xff, 0x1c,
	0x00, 0x00, 0x50, 0xff, 0x1c,
	0x00, 0x00, 0x50, 0xff, 0x1c,
	0x00, 0x00, 0x50, 0xff, 0x1c,
	0x00, 0x00, 0x50, 0xff, 0x1c,
	0x00, 0x00, 0x50, 0xff, 0x1c,
	0x00, 0x00, 0x50, 0xff, 0x1c,
	0x00, 0x00, 0x50, 0xff, 0x1c,
	/* ch = '2' */
	0x00, 0x00, 0x22, 0x74, 0x74, 0x37, 0x04, 0x00,
	0x00, 0x5b, 0xf7, 0x50, 0x5a, 0xf7, 0x7c, 0x00,
	0x00, 0x48, 0x2f, 0x00, 0x00, 0x3b, 0xff, 0x24,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x32,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0xff, 0x14,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xf7, 0x50, 0x00,
	0x00, 0x00, 0x00, 0x26, 0xf7, 0x77, 0x00, 0x00,
	0x00, 0x00, 0x1f, 0xf7, 0x6b, 0x00, 0x00, 0x00,
	0x00, 0x10, 0xdb, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x7c, 0xdb, 0x04, 0x00, 0x00, 0x04, 0x0c,
	0x1a, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50,
	/* ch = '3' */
	0x00, 0x00, 0x31, 0x74, 0x74, 0x22, 0x00,
	0x00, 0x6d, 0xe5, 0x50, 0x7f, 0xff, 0x40,
	0x00, 0x08, 0x08, 0x00, 0x00, 0x70, 0xe5,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xe5,
	0x00, 0x00, 0x00, 0x04, 0x2b, 0xf7, 0x4d,
	0x00, 0x00, 0x32, 0xff, 0xff, 0x9e, 0x08,
	0x00, 0x00, 0x00, 0x00, 0x16, 0xc4, 0xa0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x35, 0xff,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x35, 0xff,
	0x04, 0xb1, 0x43, 0x00, 0x13, 0xb7, 0xc8,
	0x00, 0x50, 0xf7, 0xff, 0xff, 0xcb, 0x19,
	0x00, 0x00, 0x04, 0x15, 0x0f, 0x00, 0x00,
	/* ch = '4' */
	0x00, 0x00, 0x00, 0x00, 0x10, 0x74, 0x22, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x90, 0xff, 0x32, 0x00,
	0x00, 0x00, 0x00, 0x3b, 0xf7, 0xff, 0x32, 0x00,
	0x00, 0x00, 0x10, 0xf7, 0x4d, 0xff, 0x32, 0x00,
	0x00, 0x00, 0x90, 0x77, 0x1c, 0xff, 0x32, 0x00,
	0x00, 0x3b, 0xdb, 0x10, 0x1c, 0xff, 0x32, 0x00,
	0x10, 0xf7, 0x32, 0x00, 0x1c, 0xff, 0x32, 0x00,
	0x50, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x32, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x32, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x32, 0x00,
	/* ch = '5' */
	0x00, 0x30, 0x74, 0x74, 0x74, 0x74, 0x74, 0x14,
	0x00, 0x77, 0xcf, 0x36, 0x36, 0x36, 0x36, 0x0d,
	0x00, 0x7c, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x90, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xb7, 0xc8, 0xcf, 0xcf, 0x8d, 0x13, 0x00,
	0x00, 0xb1, 0xa9, 0x20, 0x20, 0xc4, 0xdb, 0x0d,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0x3b,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x50,
	0x00, 0x08, 0x04, 0x00, 0x00, 0x14, 0xff, 0x4d,
	0x11, 0xdb, 0x5f, 0x04, 0x04, 0x7c, 0xf7, 0x17,
	0x00, 0x2f, 0xe5, 0xf7, 0xef, 0xef, 0x2c, 0x00,
	0x00, 0x00, 0x00, 0x12, 0x15, 0x00, 0x00, 0x00,
	/* ch = '6' */
	0x00, 0x00, 0x08, 0x50, 0xab, 0x74, 0x22, 0x00,
	0x00, 0x0d, 0xd4, 0xc4, 0x3e, 0x77, 0xdb, 0x09,
	0x00, 0x5a, 0xe5, 0x10, 0x00, 0x00, 0x0c, 0x00,
	0x00, 0xcf, 0x5f, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x14, 0xff, 0x52, 0x9e, 0xcf, 0x7f, 0x10, 0x00,
	0x1c, 0xff, 0xff, 0x50, 0x20, 0xc4, 0xb7, 0x04,
	0x1c, 0xff, 0x50, 0x00, 0x00, 0x24, 0xff, 0x2f,
	0x1a, 0xff, 0x3b, 0x00, 0x00, 0x00, 0xff, 0x50,
	0x00, 0xe5, 0x70, 0x00, 0x00, 0x14, 0xff, 0x35,
	0x00, 0x5a, 0xf7, 0x21, 0x00, 0x6f, 0xf7, 0x0d,
	0x00, 0x04, 0x7e, 0xff, 0xff, 0xef, 0x2c, 0x00,
	0x00, 0x00, 0x00, 0x0c, 0x15, 0x00, 0x00, 0x00,
	/* ch = '7' */
	0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x22,
	0x74, 0x74, 0x74, 0x74, 0xb9, 0xff, 0x17,
	0x00, 0x00, 0x00, 0x00, 0xc8, 0x8a, 0x00,
	0x00, 0x00, 0x00, 0x2c, 0xff, 0x2c, 0x00,
	0x00, 0x00, 0x00, 0x7c, 0xe5, 0x00, 0x00,
	0x00, 0x00, 0x0d, 0xf7, 0x5a, 0x00, 0x00,
	0x00, 0x00, 0x48, 0xff, 0x1c, 0x00, 0x00,
	0x00, 0x00, 0xa7, 0xa7, 0x00, 0x00, 0x00,
	0x00, 0x1c, 0xff, 0x48, 0x00, 0x00, 0x00,
	0x00, 0x50, 0xff, 0x17, 0x00, 0x00, 0x00,
	0x00, 0xc8, 0xa7, 0x00, 0x00, 0x00, 0x00,
	/* ch = '8' */
	0x00, 0x00, 0x28, 0x82, 0xab, 0x50, 0x04, 0x00,
	0x00, 0x32, 0xff, 0x5a, 0x31, 0xdb, 0xa0, 0x00,
	0x00, 0xa0, 0x90, 0x00, 0x00, 0x3b, 0xff, 0x1a,
	0x00, 0x90, 0xc8, 0x04, 0x00, 0x50, 0xf7, 0x0d,
	0x00, 0x1f, 0xf7, 0x99, 0x31, 0xf7, 0x50, 0x00,
	0x00, 0x00, 0x57, 0xff, 0xff, 0x9e, 0x08, 0x00,
	0x00, 0x77, 0xdb, 0x1b, 0x1b, 0xdb, 0xb1, 0x04,
	0x1c, 0xff, 0x3b, 0x00, 0x00, 0x24, 0xff, 0x39,
	0x2f, 0xff, 0x32, 0x00, 0x00, 0x0d, 0xff, 0x50,
	0x0d, 0xe5, 0xb1, 0x08, 0x04, 0x64, 0xff, 0x1c,
	0x00, 0x26, 0xd4, 0xff, 0xff, 0xef, 0x35, 0x00,
	0x00, 0x00, 0x00, 0x12, 0x15, 0x00, 0x00, 0x00,
	/* ch = '9' */
	0x00, 0x00, 0x28, 0x74, 0x74, 0x2e, 0x00, 0x00,
	0x00, 0x40, 0xff, 0x5a, 0x5a, 0xff, 0x4d, 0x00,
	0x00, 0xe5, 0x64, 0x00, 0x00, 0x5f, 0xf7, 0x0d,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x1f, 0xff, 0x2a,
	0x14, 0xff, 0x3b, 0x00, 0x00, 0x1c, 0xff, 0x35,
	0x00, 0xa0, 0xb7, 0x08, 0x08, 0x8a, 0xff, 0x50,
	0x00, 0x10, 0xcb, 0xff, 0xff, 0xbb, 0xff, 0x35,
	0x00, 0x00, 0x00, 0x12, 0x0c, 0x24, 0xff, 0x2f,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0xf7, 0x0d,
	0x00, 0x32, 0x3b, 0x00, 0x24, 0xe5, 0x5f, 0x00,
	0x00, 0x66, 0xff, 0xff, 0xff, 0x73, 0x04, 0x00,
	0x00, 0x00, 0x08, 0x15, 0x08, 0x00, 0x00, 0x00,
	/* ch = ':' */
	0x00, 0x0f, 0x0c,
	0x22, 0xff, 0xe5,
	0x0d, 0xab, 0x66,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x0d, 0x9e, 0x66,
	0x22, 0xff, 0xe5,
	0x00, 0x0f, 0x0c,
	/* ch = ';' */
	0x00, 0x0f, 0x0c, 0x00,
	0x22, 0xff, 0xe5, 0x00,
	0x0d, 0xab, 0x66, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x0d, 0x9e, 0x5b, 0x00,
	0x22, 0xf7, 0xff, 0x1c,
	0x00, 0x54, 0xf7, 0x0d,
	0x04, 0xb1, 0x50, 0x00,
	0x2d, 0x73, 0x00, 0x00,
	/* ch = '<' */
	0x00, 0x00, 0x00, 0x00, 0x13,
	0x00, 0x00, 0x13, 0x73, 0xff,
	0x08, 0x66, 0xf7, 0xa4, 0x1b,
	0xf7, 0xb3, 0x1e, 0x00, 0x00,
	0x2f, 0x00, 0x00, 0x00, 0x00,
	0xf7, 0x50, 0x08, 0x00, 0x00,
	0x28, 0xd4, 0xef, 0x37, 0x00,
	0x00, 0x04, 0x37, 0xef, 0xbb,
	0x00, 0x00, 0x00, 0x08, 0x73,
	0x00, 0x00, 0x00, 0x00, 0x00,
	/* ch = '=' */
	0x1e, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x26,
	0x30, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x42,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7c,
	0x0c, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x0f,
	/* ch = '>' */
	0x1b, 0x00, 0x00, 0x00, 0x00,
	0xff, 0x94, 0x1b, 0x00, 0x00,
	0x13, 0x7f, 0xff, 0x7f, 0x13,
	0x00, 0x00, 0x16, 0x8d, 0xff,
	0x00, 0x00, 0x00, 0x00, 0x1a,
	0x00, 0x00, 0x00, 0x37, 0xef,
	0x00, 0x28, 0xd4, 0xef, 0x37,
	0xa4, 0xf7, 0x5a, 0x08, 0x00,
	0x94, 0x13, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00,
	/* ch = '?' */
	0x00, 0x00, 0x04, 0x1a, 0x25, 0x0c, 0x00, 0x00,
	0x00, 0x35, 0xef, 0xef, 0xe5, 0xff, 0x4d, 0x00,
	0x11, 0xf7, 0x6b, 0x04, 0x04, 0x82, 0xff, 0x17,
	0x00, 0x0c, 0x00, 0x00, 0x00, 0x32, 0xff, 0x32,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xff, 0x2a,
	0x00, 0x00, 0x00, 0x00, 0x26, 0xf7, 0x7c, 0x00,
	0x00, 0x00, 0x00, 0x17, 0xf7, 0x7c, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x44, 0xff, 0x04, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x45, 0xcf, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x3d, 0xab, 0x10, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xb1, 0xff, 0x36, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x08, 0x12, 0x00, 0x00, 0x00,
	/* ch = '@' */
	0x00, 0x00, 0x1e, 0x82, 0xcf, 0x73, 0x19, 0x00,
	0x00, 0x40, 0xf7, 0x3f, 0x15, 0x6a, 0xf7, 0x1c,
	0x17, 0xf7, 0x32, 0x00, 0x00, 0x00, 0x90, 0x7c,
	0x50, 0xb7, 0x00, 0x00, 0x2a, 0x67, 0xb1, 0xb7,
	0x82, 0x6b, 0x04, 0xb1, 0xc4, 0x3e, 0x82, 0xb7,
	0xb7, 0x50, 0x2f, 0xff, 0x17, 0x00, 0x50, 0xb7,
	0xa0, 0x5f, 0x2a, 0xff, 0x24, 0x00, 0x90, 0xb7,
	0x5f, 0xa7, 0x00, 0x77, 0xf7, 0xdd, 0xef, 0xb7,
	0x2a, 0xff, 0x24, 0x00, 0x0f, 0x0f, 0x00, 0x00,
	0x00, 0x7c, 0xdb, 0x21, 0x00, 0x00, 0x22, 0x00,
	0x00, 0x04, 0x66, 0xf7, 0xdd, 0xdd, 0xe5, 0x20,
	0x00, 0x00, 0x00, 0x04, 0x15, 0x12, 0x00, 0x00,
	/* ch = 'A' */
	0x00, 0x00, 0x00, 0x3e, 0x22, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xa7, 0x70, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x17, 0xff, 0xe5, 0x04, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x48, 0xc8, 0xff, 0x39, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xb7, 0x5a, 0x8a, 0x90, 0x00, 0x00, 0x00,
	0x00, 0x1c, 0xff, 0x22, 0x32, 0xff, 0x17, 0x00, 0x00,
	0x00, 0x5a, 0xb7, 0x00, 0x04, 0xe5, 0x5a, 0x00, 0x00,
	0x00, 0xc8, 0xff, 0xff, 0xff, 0xff, 0xc8, 0x00, 0x00,
	0x22, 0xff, 0x2a, 0x00, 0x00, 0x2c, 0xff, 0x2c, 0x00,
	0x5f, 0xe5, 0x00, 0x00, 0x00, 0x00, 0xe5, 0x70, 0x00,
	0xcf, 0x6b, 0x00, 0x00, 0x00, 0x00, 0x5a, 0xf7, 0x0d,
	0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	/* ch = 'B' */
	0x30, 0x74, 0x74, 0x74, 0x74, 0x37, 0x04, 0x00,
	0x50, 0xff, 0x36, 0x36, 0x66, 0xf7, 0xb1, 0x00,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x35, 0xff, 0x2a,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x26, 0xff, 0x2a,
	0x50, 0xff, 0x15, 0x15, 0x25, 0xd4, 0xb1, 0x04,
	0x50, 0xff, 0xcf, 0xcf, 0xe5, 0xec, 0x2b, 0x00,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x43, 0xff, 0x2a,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x00, 0xcf, 0x7c,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x00, 0xcf, 0x82,
	0x50, 0xff, 0x00, 0x00, 0x0c, 0x5f, 0xff, 0x2f,
	0x50, 0xff, 0xff, 0xff, 0xff, 0xd4, 0x35, 0x00,
	/* ch = 'C' */
	0x00, 0x00, 0x13, 0x5b, 0x74, 0x67, 0x1b, 0x00,
	0x00, 0x2c, 0xf7, 0x94, 0x36, 0x77, 0xf7, 0x32,
	0x04, 0xdb, 0x82, 0x00, 0x00, 0x00, 0x82, 0x7b,
	0x39, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x54, 0xe5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7c, 0xb7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x77, 0xbd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x44, 0xff, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x22, 0xff, 0x48, 0x00, 0x00, 0x00, 0x0c, 0x00,
	0x00, 0x77, 0xf7, 0x28, 0x00, 0x13, 0xc8, 0x7b,
	0x00, 0x04, 0x73, 0xff, 0xe5, 0xff, 0x8d, 0x08,
	0x00, 0x00, 0x00, 0x08, 0x15, 0x08, 0x00, 0x00,
	/* ch = 'D' */
	0x30, 0x74, 0x74, 0x74, 0x5b, 0x1b, 0x00, 0x00,
	0x50, 0xff, 0x36, 0x36, 0xa4, 0xff, 0x4d, 0x00,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x64, 0xff, 0x1c,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x0d, 0xff, 0x5a,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x00, 0xb7, 0x90,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x00, 0x82, 0xb7,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x00, 0x90, 0xb1,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x00, 0xcf, 0x6b,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x2c, 0xff, 0x2c,
	0x50, 0xff, 0x00, 0x00, 0x28, 0xdb, 0x7c, 0x00,
	0x50, 0xff, 0xff, 0xff, 0xe5, 0x66, 0x04, 0x00,
	/* ch = 'E' */
	0x22, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x30,
	0x32, 0xff, 0x4a, 0x36, 0x36, 0x36, 0x36, 0x1e,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50,
	/* ch = 'F' */
	0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x30,
	0xff, 0x82, 0x36, 0x36, 0x36, 0x36, 0x1e,
	0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0x5e, 0x15, 0x15, 0x15, 0x0c, 0x00,
	0xff, 0xe5, 0xcf, 0xcf, 0xcf, 0x45, 0x00,
	0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,
	/* ch = 'G' */
	0x00, 0x00, 0x1b, 0x67, 0x74, 0x67, 0x1b, 0x00,
	0x00, 0x32, 0xf7, 0x94, 0x36, 0x85, 0xff, 0x32,
	0x0d, 0xf7, 0x5f, 0x00, 0x00, 0x00, 0x82, 0x35,
	0x44, 0xff, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x77, 0xb7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7c, 0xb7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7c, 0xb7, 0x00, 0x00, 0x50, 0xff, 0xff, 0xb7,
	0x5f, 0xf7, 0x04, 0x00, 0x00, 0x00, 0x7c, 0xb7,
	0x2a, 0xff, 0x32, 0x00, 0x00, 0x00, 0x7c, 0xb7,
	0x00, 0x90, 0xdb, 0x24, 0x00, 0x0c, 0xa5, 0xb7,
	0x00, 0x04, 0x7f, 0xff, 0xff, 0xff, 0xb3, 0x28,
	0x00, 0x00, 0x00, 0x08, 0x15, 0x08, 0x00, 0x00,
	/* ch = 'H' */
	0x22, 0x74, 0x1a, 0x00, 0x00, 0x00, 0x74, 0x37,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0xff, 0x50,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0xff, 0x50,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0xff, 0x50,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0xff, 0x50,
	0x32, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0xff, 0x50,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0xff, 0x50,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0xff, 0x50,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0xff, 0x50,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0xff, 0x50,
	/* ch = 'I' */
	0x58, 0x74, 0x74, 0x74, 0x74, 0x42,
	0x2d, 0x36, 0xcf, 0xa5, 0x36, 0x26,
	0x00, 0x00, 0xb7, 0x7c, 0x00, 0x00,
	0x00, 0x00, 0xb7, 0x7c, 0x00, 0x00,
	0x00, 0x00, 0xb7, 0x7c, 0x00, 0x00,
	0x00, 0x00, 0xb7, 0x7c, 0x00, 0x00,
	0x00, 0x00, 0xb7, 0x7c, 0x00, 0x00,
	0x00, 0x00, 0xb7, 0x7c, 0x00, 0x00,
	0x00, 0x00, 0xb7, 0x7c, 0x00, 0x00,
	0x00, 0x00, 0xb7, 0x7c, 0x00, 0x00,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xb7,
	/* ch = 'J' */
	0x22, 0x74, 0x74, 0x74, 0x74, 0x58,
	0x16, 0x36, 0x62, 0xff, 0x4a, 0x2d,
	0x00, 0x00, 0x32, 0xff, 0x1c, 0x00,
	0x00, 0x00, 0x32, 0xff, 0x1c, 0x00,
	0x00, 0x00, 0x32, 0xff, 0x1c, 0x00,
	0x00, 0x00, 0x32, 0xff, 0x1c, 0x00,
	0x00, 0x00, 0x32, 0xff, 0x1c, 0x00,
	0x00, 0x00, 0x32, 0xff, 0x1c, 0x00,
	0x00, 0x00, 0x44, 0xff, 0x14, 0x00,
	0x13, 0x04, 0xb1, 0xb7, 0x00, 0x00,
	0xff, 0xf7, 0xd4, 0x1f, 0x00, 0x00,
	0x12, 0x15, 0x00, 0x00, 0x00, 0x00,
	/* ch = 'K' */
	0x42, 0x74, 0x0a, 0x00, 0x00, 0x19, 0x74, 0x35,
	0x7c, 0xff, 0x00, 0x00, 0x10, 0xdb, 0xb1, 0x04,
	0x7c, 0xff, 0x00, 0x04, 0xb1, 0xb1, 0x08, 0x00,
	0x7c, 0xff, 0x04, 0x99, 0xdb, 0x10, 0x00, 0x00,
	0x7c, 0xff, 0x7c, 0xf7, 0x1f, 0x00, 0x00, 0x00,
	0x7c, 0xff, 0xff, 0xf7, 0x17, 0x00, 0x00, 0x00,
	0x7c, 0xff, 0x26, 0xdb, 0xb1, 0x04, 0x00, 0x00,
	0x7c, 0xff, 0x00, 0x2f, 0xff, 0x50, 0x00, 0x00,
	0x7c, 0xff, 0x00, 0x00, 0x6b, 0xff, 0x1f, 0x00,
	0x7c, 0xff, 0x00, 0x00, 0x04, 0xc8, 0xdb, 0x04,
	0x7c, 0xff, 0x00, 0x00, 0x00, 0x24, 0xff, 0x7c,
	/* ch = 'L' */
	0x14, 0x74, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50,
	/* ch = 'M' */
	0x42, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x32, 0x58,
	0x7c, 0xff, 0x1c, 0x00, 0x00, 0x04, 0xe5, 0xb7,
	0x7c, 0xff, 0x8a, 0x00, 0x00, 0x50, 0xff, 0xb7,
	0x7c, 0xff, 0xff, 0x22, 0x0d, 0xe5, 0xf7, 0xb7,
	0x7c, 0xb7, 0xa7, 0x8a, 0x5a, 0xc8, 0x82, 0xb7,
	0x7c, 0xb7, 0x2c, 0xff, 0xf7, 0x32, 0x7c, 0xb7,
	0x7c, 0xb7, 0x00, 0xa0, 0xb7, 0x00, 0x7c, 0xb7,
	0x7c, 0xb7, 0x00, 0x0c, 0x0c, 0x00, 0x7c, 0xb7,
	0x7c, 0xb7, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xb7,
	0x7c, 0xb7, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xb7,
	0x7c, 0xb7, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xb7,
	/* ch = 'N' */
	0x30, 0x74, 0x10, 0x00, 0x00, 0x00, 0x58, 0x42,
	0x50, 0xff, 0x6b, 0x00, 0x00, 0x00, 0xb7, 0x7c,
	0x50, 0xff, 0xff, 0x1f, 0x00, 0x00, 0xb7, 0x7c,
	0x50, 0xff, 0xc8, 0xa0, 0x00, 0x00, 0xb7, 0x7c,
	0x50, 0xff, 0x32, 0xff, 0x32, 0x00, 0xb7, 0x7c,
	0x50, 0xff, 0x00, 0xa0, 0xc8, 0x04, 0xb7, 0x7c,
	0x50, 0xff, 0x00, 0x24, 0xff, 0x44, 0xb7, 0x7c,
	0x50, 0xff, 0x00, 0x00, 0x6b, 0xe5, 0xcf, 0x7c,
	0x50, 0xff, 0x00, 0x00, 0x10, 0xf7, 0xff, 0x7c,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x50, 0xff, 0x7c,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x04, 0xdb, 0x7c,
	/* ch = 'O' */
	0x00, 0x00, 0x2b, 0x82, 0x9e, 0x48, 0x04, 0x00,
	0x00, 0x50, 0xff, 0x66, 0x50, 0xf7, 0xb1, 0x04,
	0x22, 0xff, 0x3b, 0x00, 0x00, 0x24, 0xff, 0x48,
	0x5f, 0xe5, 0x04, 0x00, 0x00, 0x00, 0xa0, 0xa0,
	0xa0, 0x90, 0x00, 0x00, 0x00, 0x00, 0x5f, 0xf7,
	0xb7, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x50, 0xff,
	0xb7, 0x82, 0x00, 0x00, 0x00, 0x00, 0x50, 0xff,
	0x77, 0xcf, 0x00, 0x00, 0x00, 0x00, 0x77, 0xbd,
	0x39, 0xff, 0x24, 0x00, 0x00, 0x04, 0xe5, 0x6b,
	0x04, 0xb7, 0xdb, 0x1b, 0x08, 0x8a, 0xf7, 0x1c,
	0x00, 0x10, 0xbb, 0xff, 0xff, 0xe5, 0x26, 0x00,
	0x00, 0x00, 0x00, 0x0f, 0x12, 0x00, 0x00, 0x00,
	/* ch = 'P' */
	0x22, 0x74, 0x74, 0x74, 0x74, 0x50, 0x08, 0x00,
	0x32, 0xff, 0x87, 0x74, 0x74, 0xef, 0xef, 0x10,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x10, 0xf7, 0x6b,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0xb7, 0x7c,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x1f, 0xff, 0x5a,
	0x32, 0xff, 0xd4, 0xcf, 0xcf, 0xf7, 0xa9, 0x04,
	0x32, 0xff, 0x4a, 0x36, 0x2a, 0x15, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00,
	/* ch = 'Q' */
	0x00, 0x00, 0x2b, 0x82, 0x9e, 0x48, 0x04, 0x00,
	0x00, 0x50, 0xf7, 0x66, 0x47, 0xef, 0xb1, 0x04,
	0x22, 0xff, 0x3b, 0x00, 0x00, 0x1f, 0xff, 0x48,
	0x5f, 0xe5, 0x00, 0x00, 0x00, 0x00, 0xa0, 0xa0,
	0xa0, 0x90, 0x00, 0x00, 0x00, 0x00, 0x54, 0xf7,
	0xb7, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x50, 0xff,
	0xb7, 0x82, 0x00, 0x00, 0x00, 0x00, 0x50, 0xff,
	0x77, 0xcf, 0x00, 0x00, 0x00, 0x00, 0x77, 0xbd,
	0x39, 0xff, 0x24, 0x00, 0x00, 0x04, 0xe5, 0x6b,
	0x04, 0xc8, 0xd4, 0x16, 0x04, 0x70, 0xf7, 0x1c,
	0x00, 0x10, 0xb3, 0xff, 0xff, 0xe5, 0x2c, 0x00,
	0x00, 0x00, 0x00, 0x54, 0xec, 0x04, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x1c, 0xf7, 0xa4, 0x74, 0x30,
	0x00, 0x00, 0x00, 0x00, 0x16, 0x36, 0x36, 0x1e,
	/* ch = 'R' */
	0x22, 0x74, 0x74, 0x74, 0x74, 0x47, 0x08, 0x00,
	0x32, 0xff, 0x87, 0x74, 0x74, 0xef, 0xd4, 0x0d,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x24, 0xff, 0x44,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0xff, 0x66,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x32, 0xff, 0x39,
	0x32, 0xff, 0xd4, 0xcf, 0xcf, 0xff, 0x7c, 0x00,
	0x32, 0xff, 0x4a, 0x36, 0xf7, 0x6d, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x5a, 0xf7, 0x10, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x0d, 0xf7, 0x6b, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x5a, 0xf7, 0x17,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x0d, 0xf7, 0x70,
	/* ch = 'S' */
	0x00, 0x00, 0x22, 0x74, 0x74, 0x50, 0x13, 0x00,
	0x00, 0x50, 0xf7, 0x5a, 0x36, 0xab, 0xf7, 0x1a,
	0x04, 0xf7, 0x54, 0x00, 0x00, 0x00, 0x51, 0x00,
	0x04, 0xff, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x6b, 0xff, 0x73, 0x0c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x37, 0xe5, 0xff, 0x7f, 0x13, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x2b, 0xc4, 0xf7, 0x1f,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xe5, 0x77,
	0x00, 0x21, 0x00, 0x00, 0x00, 0x00, 0xbd, 0x7c,
	0x2d, 0xf7, 0x37, 0x04, 0x00, 0x3f, 0xff, 0x39,
	0x04, 0x5b, 0xef, 0xff, 0xff, 0xf7, 0x50, 0x00,
	0x00, 0x00, 0x00, 0x15, 0x15, 0x04, 0x00, 0x00,
	/* ch = 'T' */
	0x58, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x58,
	0x2d, 0x36, 0x36, 0xcf, 0xa5, 0x36, 0x36, 0x2d,
	0x00, 0x00, 0x00, 0xb7, 0x7c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xb7, 0x7c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xb7, 0x7c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xb7, 0x7c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xb7, 0x7c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xb7, 0x7c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xb7, 0x7c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xb7, 0x7c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xb7, 0x7c, 0x00, 0x00, 0x00,
	/* ch = 'U' */
	0x30, 0x74, 0x11, 0x00, 0x00, 0x00, 0x42, 0x42,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x7c,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x7c,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x7c,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x7c,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x7c,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x7c,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x00, 0xa0, 0x7c,
	0x3b, 0xff, 0x1c, 0x00, 0x00, 0x00, 0xcf, 0x77,
	0x17, 0xf7, 0x8a, 0x04, 0x00, 0x4a, 0xff, 0x2a,
	0x00, 0x26, 0xe5, 0xef, 0xe5, 0xef, 0x3b, 0x00,
	0x00, 0x00, 0x00, 0x12, 0x15, 0x04, 0x00, 0x00,
	/* ch = 'V' */
	0x53, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x74, 0x0a,
	0x5a, 0xf7, 0x0d, 0x00, 0x00, 0x00, 0x90, 0xa0, 0x00,
	0x22, 0xff, 0x39, 0x00, 0x00, 0x0d, 0xf7, 0x44, 0x00,
	0x00, 0xc8, 0x8a, 0x00, 0x00, 0x39, 0xff, 0x14, 0x00,
	0x00, 0x5a, 0xf7, 0x0d, 0x00, 0x7c, 0xa0, 0x00, 0x00,
	0x00, 0x1c, 0xff, 0x39, 0x04, 0xf7, 0x44, 0x00, 0x00,
	0x00, 0x00, 0xb7, 0x8a, 0x2c, 0xff, 0x14, 0x00, 0x00,
	0x00, 0x00, 0x50, 0xf7, 0x7c, 0xa0, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x1c, 0xff, 0xff, 0x44, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xb7, 0xff, 0x14, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x50, 0xa0, 0x00, 0x00, 0x00, 0x00,
	/* ch = 'W' */
	0x74, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x04, 0x74, 0x1a,
	0xbd, 0x5f, 0x00, 0x1c, 0x6c, 0x00, 0x1c, 0xff, 0x1a,
	0x82, 0x90, 0x00, 0x44, 0xe5, 0x00, 0x32, 0xf7, 0x00,
	0x54, 0xcf, 0x00, 0x90, 0xff, 0x24, 0x4d, 0xb1, 0x00,
	0x3b, 0xff, 0x08, 0xf7, 0xff, 0x50, 0x6b, 0x7c, 0x00,
	0x24, 0xff, 0x3f, 0xe5, 0x6b, 0xa0, 0x90, 0x50, 0x00,
	0x0d, 0xff, 0xb7, 0x7c, 0x3b, 0xff, 0xcf, 0x32, 0x00,
	0x00, 0xcf, 0xff, 0x44, 0x14, 0xff, 0xff, 0x1c, 0x00,
	0x00, 0x90, 0xff, 0x1c, 0x00, 0xbd, 0xff, 0x00, 0x00,
	0x00, 0x6b, 0xcf, 0x00, 0x00, 0x6b, 0xbd, 0x00, 0x00,
	0x00, 0x44, 0x6b, 0x00, 0x00, 0x32, 0x82, 0x00, 0x00,
	/* ch = 'X' */
	0x42, 0x74, 0x17, 0x00, 0x00, 0x04, 0x74, 0x35,
	0x0d, 0xe5, 0x70, 0x00, 0x00, 0x50, 0xf7, 0x10,
	0x00, 0x44, 0xff, 0x1c, 0x10, 0xf7, 0x5a, 0x00,
	0x00, 0x04, 0xc8, 0x90, 0x5f, 0xf7, 0x0d, 0x00,
	0x00, 0x00, 0x32, 0xff, 0xf7, 0x50, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xbd, 0xff, 0x10, 0x00, 0x00,
	0x00, 0x00, 0x24, 0xff, 0xff, 0x44, 0x00, 0x00,
	0x00, 0x00, 0xa0, 0xc8, 0x82, 0xe5, 0x0d, 0x00,
	0x00, 0x2c, 0xff, 0x32, 0x17, 0xf7, 0x5f, 0x00,
	0x00, 0xb7, 0xa7, 0x00, 0x00, 0x5f, 0xf7, 0x17,
	0x3b, 0xff, 0x2a, 0x00, 0x00, 0x0d, 0xe5, 0x82,
	/* ch = 'Y' */
	0x4a, 0x67, 0x04, 0x00, 0x00, 0x00, 0x45, 0x64,
	0x2c, 0xff, 0x3b, 0x00, 0x00, 0x0d, 0xf7, 0x5a,
	0x00, 0xa0, 0xc8, 0x04, 0x00, 0x5a, 0xf7, 0x0d,
	0x00, 0x2a, 0xff, 0x3b, 0x04, 0xe5, 0x6b, 0x00,
	0x00, 0x00, 0xa0, 0xc8, 0x48, 0xff, 0x17, 0x00,
	0x00, 0x00, 0x2a, 0xff, 0xf7, 0x70, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xa7, 0xff, 0x22, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x7c, 0xff, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x7c, 0xff, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x7c, 0xff, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x7c, 0xff, 0x00, 0x00, 0x00,
	/* ch = 'Z' */
	0x22, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x42,
	0x16, 0x36, 0x36, 0x36, 0x36, 0x57, 0xff, 0x44,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 0xb7, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3b, 0xff, 0x24, 0x00,
	0x00, 0x00, 0x00, 0x0d, 0xe5, 0x6b, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x6b, 0xe5, 0x10, 0x00, 0x00,
	0x00, 0x00, 0x24, 0xff, 0x44, 0x00, 0x00, 0x00,
	0x00, 0x04, 0xb7, 0xb7, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0xff, 0x24, 0x00, 0x00, 0x00, 0x00,
	0x10, 0xf7, 0x6b, 0x00, 0x00, 0x00, 0x00, 0x0c,
	0x50, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb7,
	/* ch = '[' */
	0x0d, 0x36, 0x36, 0x36, 0x36, 0x36, 0x0d,
	0x1c, 0xff, 0x9c, 0x74, 0x74, 0x74, 0x14,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x62, 0x36, 0x36, 0x36, 0x0d,
	0x14, 0x74, 0x74, 0x74, 0x74, 0x74, 0x14,
	/* ch = '\' */
	0x00, 0x0f, 0x04,
	0x11, 0xff, 0x48,
	0x00, 0x70, 0xdb,
	0x00, 0x22, 0xff,
	0x00, 0x00, 0x8a,
	0x00, 0x00, 0x2a,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	/* ch = ']' */
	0x2d, 0x36, 0x36, 0x36, 0x36, 0x16,
	0x58, 0x74, 0x74, 0x87, 0xff, 0x32,
	0x00, 0x00, 0x00, 0x1c, 0xff, 0x32,
	0x00, 0x00, 0x00, 0x1c, 0xff, 0x32,
	0x00, 0x00, 0x00, 0x1c, 0xff, 0x32,
	0x00, 0x00, 0x00, 0x1c, 0xff, 0x32,
	0x00, 0x00, 0x00, 0x1c, 0xff, 0x32,
	0x00, 0x00, 0x00, 0x1c, 0xff, 0x32,
	0x00, 0x00, 0x00, 0x1c, 0xff, 0x32,
	0x00, 0x00, 0x00, 0x1c, 0xff, 0x32,
	0x00, 0x00, 0x00, 0x1c, 0xff, 0x32,
	0x00, 0x00, 0x00, 0x1c, 0xff, 0x32,
	0x36, 0x36, 0x36, 0x4a, 0xff, 0x32,
	0x74, 0x74, 0x74, 0x74, 0x74, 0x22,
	/* ch = '^' */
	0x00, 0x00, 0x1f, 0x45, 0x00, 0x00,
	0x00, 0x00, 0xb1, 0xf7, 0x17, 0x00,
	0x00, 0x3b, 0xf7, 0xdb, 0x7c, 0x00,
	0x0d, 0xe5, 0x4d, 0x32, 0xff, 0x1c,
	0x60, 0xb7, 0x04, 0x00, 0xa0, 0x7e,
	0x00, 0x0c, 0x00, 0x00, 0x0c, 0x04,
	/* ch = '_' */
	0x42, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74,
	0x26, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
	/* ch = '`' */
	0x1b, 0x16, 0x00, 0x00,
	0xa7, 0x70, 0x00, 0x00,
	0x44, 0xf7, 0x1f, 0x00,
	0x0d, 0xe5, 0xef, 0x14,
	0x00, 0x26, 0x74, 0x0d,
	/* ch = 'a' */
	0x00, 0x13, 0x8d, 0xe5, 0xef, 0xab, 0x21, 0x00,
	0x00, 0x54, 0x84, 0x18, 0x0f, 0x7c, 0xf7, 0x0d,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x32,
	0x00, 0x00, 0x25, 0x47, 0x74, 0x87, 0xff, 0x32,
	0x04, 0xa9, 0xdb, 0x47, 0x36, 0x36, 0xff, 0x32,
	0x44, 0xff, 0x1c, 0x00, 0x00, 0x1c, 0xff, 0x32,
	0x44, 0xff, 0x28, 0x00, 0x08, 0xa0, 0xff, 0x32,
	0x04, 0x94, 0xff, 0xcf, 0xf7, 0x94, 0xff, 0x32,
	0x00, 0x00, 0x0f, 0x15, 0x08, 0x00, 0x00, 0x00,
	/* ch = 'b' */
	0x16, 0x36, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x64, 0xbd, 0xff, 0xc4, 0x26, 0x00,
	0x32, 0xff, 0xdb, 0x20, 0x1a, 0xb1, 0xf7, 0x17,
	0x32, 0xff, 0x3b, 0x00, 0x00, 0x17, 0xff, 0x5f,
	0x32, 0xff, 0x32, 0x00, 0x00, 0x00, 0xbd, 0x90,
	0x32, 0xff, 0x32, 0x00, 0x00, 0x00, 0xb7, 0x90,
	0x32, 0xff, 0x35, 0x00, 0x00, 0x04, 0xf7, 0x5f,
	0x32, 0xff, 0xb1, 0x08, 0x04, 0x7c, 0xff, 0x1c,
	0x32, 0xf7, 0x73, 0xff, 0xff, 0xf7, 0x3b, 0x00,
	0x00, 0x00, 0x00, 0x0c, 0x15, 0x04, 0x00, 0x00,
	/* ch = 'c' */
	0x00, 0x00, 0x35, 0xbd, 0xef, 0xcf, 0x5b, 0x04,
	0x00, 0x50, 0xff, 0x50, 0x15, 0x31, 0xef, 0x6d,
	0x14, 0xf7, 0x5f, 0x00, 0x00, 0x00, 0x30, 0x10,
	0x32, 0xff, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x5f, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x77, 0xf7, 0x31, 0x00, 0x13, 0x8d, 0x2c,
	0x00, 0x04, 0x7f, 0xff, 0xff, 0xff, 0xbb, 0x19,
	0x00, 0x00, 0x00, 0x08, 0x15, 0x0f, 0x00, 0x00,
	/* ch = 'd' */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x24,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x50,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x50,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x50,
	0x00, 0x13, 0x9e, 0xff, 0xe5, 0x50, 0xff, 0x50,
	0x04, 0xdb, 0xb1, 0x16, 0x16, 0xc4, 0xff, 0x50,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x2c, 0xff, 0x50,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x50,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x50,
	0x3b, 0xff, 0x24, 0x00, 0x00, 0x2c, 0xff, 0x50,
	0x0d, 0xf7, 0xb1, 0x08, 0x0c, 0xb1, 0xff, 0x50,
	0x00, 0x2c, 0xef, 0xff, 0xff, 0x66, 0xff, 0x50,
	0x00, 0x00, 0x04, 0x15, 0x08, 0x00, 0x00, 0x00,
	/* ch = 'e' */
	0x00, 0x04, 0x73, 0xe5, 0xff, 0xab, 0x19, 0x00,
	0x00, 0xa0, 0xc8, 0x16, 0x08, 0x8a, 0xdb, 0x0d,
	0x24, 0xff, 0x2c, 0x00, 0x00, 0x0d, 0xff, 0x3b,
	0x4d, 0xff, 0x7b, 0x74, 0x74, 0x74, 0xff, 0x50,
	0x50, 0xff, 0x17, 0x15, 0x15, 0x15, 0x15, 0x0c,
	0x32, 0xff, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x04, 0xdb, 0xb1, 0x13, 0x00, 0x13, 0x5b, 0x08,
	0x00, 0x19, 0xbb, 0xff, 0xcf, 0xff, 0x8d, 0x04,
	0x00, 0x00, 0x00, 0x0f, 0x15, 0x08, 0x00, 0x00,
	/* ch = 'f' */
	0x00, 0x00, 0x1e, 0x36, 0x2a, 0x04, 0x00,
	0x04, 0x99, 0xef, 0x74, 0xd4, 0xd4, 0x0d,
	0x39, 0xff, 0x24, 0x00, 0x04, 0x73, 0x00,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x82, 0xff, 0x36, 0x36, 0x1e, 0x00, 0x00,
	0xb1, 0xff, 0x74, 0x74, 0x30, 0x00, 0x00,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
	/* ch = 'g' */
	0x00, 0x19, 0xb3, 0xff, 0xef, 0x66, 0xc4, 0xff,
	0x0d, 0xdb, 0x7c, 0x04, 0x28, 0xff, 0x4f, 0x00,
	0x2f, 0xff, 0x1c, 0x00, 0x00, 0xb7, 0x77, 0x00,
	0x1c, 0xff, 0x3b, 0x00, 0x10, 0xe5, 0x50, 0x00,
	0x00, 0x50, 0xff, 0x9e, 0xef, 0xa9, 0x04, 0x00,
	0x00, 0xa0, 0x64, 0x36, 0x20, 0x00, 0x00, 0x00,
	0x00, 0xf7, 0x7c, 0x36, 0x36, 0x36, 0x0f, 0x00,
	0x04, 0x8f, 0xab, 0x74, 0x74, 0xd4, 0xff, 0x32,
	0x5a, 0xcf, 0x00, 0x00, 0x00, 0x00, 0x97, 0x7c,
	0x66, 0xf7, 0x2b, 0x04, 0x04, 0x2b, 0xf7, 0x44,
	0x04, 0x5b, 0xcf, 0xef, 0xe5, 0xbd, 0x37, 0x00,
	/* ch = 'h' */
	0x04, 0x15, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x59, 0x7f, 0xf7, 0xdd, 0x2f, 0x00,
	0x1c, 0xff, 0xff, 0x65, 0x15, 0x8a, 0xf7, 0x14,
	0x1c, 0xff, 0x7c, 0x00, 0x00, 0x24, 0xff, 0x32,
	0x1c, 0xff, 0x50, 0x00, 0x00, 0x1c, 0xff, 0x32,
	0x1c, 0xff, 0x50, 0x00, 0x00, 0x1c, 0xff, 0x32,
	0x1c, 0xff, 0x50, 0x00, 0x00, 0x1c, 0xff, 0x32,
	0x1c, 0xff, 0x50, 0x00, 0x00, 0x1c, 0xff, 0x32,
	0x1c, 0xff, 0x50, 0x00, 0x00, 0x1c, 0xff, 0x32,
	/* ch = 'i' */
	0x00, 0x00, 0x08, 0x0c, 0x00, 0x00,
	0x00, 0x00, 0xb1, 0xff, 0x14, 0x00,
	0x00, 0x00, 0x35, 0x5b, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x45, 0xcf, 0xcf, 0x95, 0x00, 0x00,
	0x0c, 0x15, 0x88, 0xb7, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0xb7, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0xb7, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0xb7, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0xb7, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0xb7, 0x00, 0x00,
	0x7c, 0xff, 0xff, 0xff, 0xff, 0x7c,
	/* ch = 'j' */
	0x00, 0x00, 0x00, 0x00, 0x12, 0x00,
	0x00, 0x00, 0x00, 0x4d, 0xff, 0x44,
	0x00, 0x00, 0x00, 0x19, 0x74, 0x19,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1a, 0xcf, 0xcf, 0xcf, 0xcf, 0x2d,
	0x04, 0x15, 0x15, 0x3e, 0xff, 0x32,
	0x00, 0x00, 0x00, 0x32, 0xff, 0x32,
	0x00, 0x00, 0x00, 0x32, 0xff, 0x32,
	0x00, 0x00, 0x00, 0x32, 0xff, 0x32,
	0x00, 0x00, 0x00, 0x32, 0xff, 0x32,
	0x00, 0x00, 0x00, 0x32, 0xff, 0x32,
	0x00, 0x00, 0x00, 0x32, 0xff, 0x2f,
	0x0c, 0x00, 0x00, 0x3b, 0xff, 0x1c,
	0xdb, 0x2b, 0x1a, 0xc8, 0xb1, 0x00,
	0x8d, 0xf7, 0xf7, 0x8d, 0x10, 0x00,
	/* ch = 'k' */
	0x04, 0x15, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x3b, 0xcf, 0x2d, 0x00,
	0x1c, 0xff, 0x32, 0x00, 0x50, 0xf7, 0x32, 0x00, 0x00,
	0x1c, 0xff, 0x32, 0x5f, 0xf7, 0x26, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0xd4, 0xff, 0x5e, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0xd4, 0x8a, 0xff, 0x32, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x32, 0x04, 0xb1, 0xe5, 0x10, 0x00, 0x00,
	0x1c, 0xff, 0x32, 0x00, 0x10, 0xdb, 0xb1, 0x04, 0x00,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x1f, 0xf7, 0x7c, 0x04,
	/* ch = 'l' */
	0x12, 0x15, 0x15, 0x12, 0x00, 0x00, 0x00,
	0x58, 0x74, 0xc8, 0xb7, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0xb7, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0xb7, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0xb7, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0xb7, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0xb7, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0xb7, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0xb7, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0xb7, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0xb7, 0x00, 0x00, 0x00,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1c,
	/* ch = 'm' */
	0x67, 0xbd, 0xcb, 0xef, 0x47, 0xc4, 0xf7, 0x4d,
	0x7c, 0xff, 0x1f, 0x97, 0xff, 0x32, 0x64, 0xf7,
	0x7c, 0xb7, 0x00, 0x7c, 0xe5, 0x00, 0x50, 0xff,
	0x7c, 0xb7, 0x00, 0x7c, 0xb7, 0x00, 0x50, 0xff,
	0x7c, 0xb7, 0x00, 0x7c, 0xb7, 0x00, 0x50, 0xff,
	0x7c, 0xb7, 0x00, 0x7c, 0xb7, 0x00, 0x50, 0xff,
	0x7c, 0xb7, 0x00, 0x7c, 0xb7, 0x00, 0x50, 0xff,
	0x7c, 0xb7, 0x00, 0x7c, 0xb7, 0x00, 0x50, 0xff,
	/* ch = 'n' */
	0x1a, 0xcf, 0x32, 0x7f, 0xf7, 0xdd, 0x2c, 0x00,
	0x1c, 0xff, 0xf7, 0x5a, 0x15, 0x90, 0xf7, 0x0d,
	0x1c, 0xff, 0x70, 0x00, 0x00, 0x24, 0xff, 0x32,
	0x1c, 0xff, 0x3b, 0x00, 0x00, 0x1c, 0xff, 0x32,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x1c, 0xff, 0x32,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x1c, 0xff, 0x32,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x1c, 0xff, 0x32,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x1c, 0xff, 0x32,
	/* ch = 'o' */
	0x00, 0x04, 0x66, 0xdd, 0xef, 0x9e, 0x19, 0x00,
	0x00, 0x99, 0xdb, 0x2b, 0x1a, 0xb1, 0xe5, 0x10,
	0x2c, 0xff, 0x2c, 0x00, 0x00, 0x17, 0xff, 0x5a,
	0x6b, 0xff, 0x04, 0x00, 0x00, 0x00, 0xb7, 0xb1,
	0x77, 0xff, 0x00, 0x00, 0x00, 0x00, 0xb7, 0xb7,
	0x44, 0xff, 0x24, 0x00, 0x00, 0x04, 0xe5, 0x6b,
	0x0d, 0xdb, 0xb1, 0x08, 0x00, 0x5f, 0xff, 0x24,
	0x00, 0x19, 0xcb, 0xf7, 0xe5, 0xef, 0x35, 0x00,
	0x00, 0x00, 0x00, 0x12, 0x15, 0x04, 0x00, 0x00,
	/* ch = 'p' */
	0x2d, 0xcf, 0x50, 0xab, 0xf7, 0xbd, 0x26, 0x00,
	0x32, 0xff, 0xdb, 0x25, 0x1a, 0xb1, 0xff, 0x1f,
	0x32, 0xff, 0x3b, 0x00, 0x00, 0x10, 0xff, 0x77,
	0x32, 0xff, 0x32, 0x00, 0x00, 0x00, 0xb7, 0xb7,
	0x32, 0xff, 0x32, 0x00, 0x00, 0x00, 0xa7, 0xb7,
	0x32, 0xff, 0x35, 0x00, 0x00, 0x04, 0xe5, 0x7c,
	0x32, 0xff, 0xb1, 0x08, 0x04, 0x5f, 0xff, 0x2a,
	0x32, 0xff, 0xbb, 0xff, 0xf7, 0xf7, 0x44, 0x00,
	0x32, 0xff, 0x32, 0x0c, 0x15, 0x08, 0x00, 0x00,
	0x32, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x2d, 0xcf, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x00,
	/* ch = 'q' */
	0x00, 0x10, 0x8d, 0xf7, 0xef, 0x66, 0xcf, 0x45,
	0x04, 0xc8, 0xb1, 0x16, 0x16, 0xb1, 0xff, 0x50,
	0x39, 0xff, 0x22, 0x00, 0x00, 0x24, 0xff, 0x50,
	0x5f, 0xff, 0x00, 0x00, 0x00, 0x1a, 0xff, 0x50,
	0x5f, 0xff, 0x00, 0x00, 0x00, 0x14, 0xff, 0x50,
	0x44, 0xff, 0x24, 0x00, 0x00, 0x24, 0xff, 0x50,
	0x0d, 0xe5, 0xb1, 0x08, 0x08, 0xb1, 0xff, 0x50,
	0x00, 0x21, 0xef, 0xff, 0xff, 0x66, 0xff, 0x50,
	0x00, 0x00, 0x00, 0x15, 0x0c, 0x00, 0xff, 0x50,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x50,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0x45,
	/* ch = 'r' */
	0x67, 0xcf, 0x2f, 0xbd, 0xff, 0xd4, 0x2f,
	0x7c, 0xff, 0xf7, 0x37, 0x15, 0x64, 0x50,
	0x7c, 0xff, 0x44, 0x00, 0x00, 0x00, 0x00,
	0x7c, 0xff, 0x04, 0x00, 0x00, 0x00, 0x00,
	0x7c, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7c, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7c, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7c, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00,
	/* ch = 's' */
	0x00, 0x08, 0x73, 0xe5, 0xff, 0xbd, 0x37, 0x00,
	0x00, 0x8a, 0xdb, 0x16, 0x04, 0x3f, 0xff, 0x1a,
	0x00, 0xb1, 0xc8, 0x08, 0x00, 0x00, 0x21, 0x00,
	0x00, 0x2c, 0xef, 0xf7, 0x8f, 0x2a, 0x04, 0x00,
	0x00, 0x00, 0x08, 0x31, 0x9e, 0xff, 0xd4, 0x10,
	0x00, 0x0c, 0x00, 0x00, 0x00, 0x28, 0xff, 0x4d,
	0x17, 0xef, 0x31, 0x00, 0x00, 0x3a, 0xff, 0x2c,
	0x04, 0x5b, 0xef, 0xef, 0xef, 0xf7, 0x50, 0x00,
	0x00, 0x00, 0x00, 0x15, 0x15, 0x00, 0x00, 0x00,
	/* ch = 't' */
	0x00, 0x00, 0x1a, 0xf7, 0x44, 0x00, 0x00,
	0x00, 0x00, 0x1f, 0xff, 0x32, 0x00, 0x00,
	0x1a, 0xcf, 0xdd, 0xff, 0xdd, 0xcf, 0x95,
	0x04, 0x15, 0x3e, 0xff, 0x28, 0x15, 0x12,
	0x00, 0x00, 0x35, 0xff, 0x1c, 0x00, 0x00,
	0x00, 0x00, 0x50, 0xff, 0x1c, 0x00, 0x00,
	0x00, 0x00, 0x50, 0xff, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x50, 0xff, 0x1c, 0x00, 0x00,
	0x00, 0x00, 0x3b, 0xff, 0x3f, 0x08, 0x48,
	0x00, 0x00, 0x04, 0xa9, 0xff, 0xff, 0xcb,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0x0c, 0x00,
	/* ch = 'u' */
	0x2d, 0xcf, 0x2d, 0x00, 0x00, 0x1a, 0xcf, 0x2d,
	0x32, 0xff, 0x32, 0x00, 0x00, 0x1c, 0xff, 0x32,
	0x32, 0xff, 0x32, 0x00, 0x00, 0x1c, 0xff, 0x32,
	0x32, 0xff, 0x32, 0x00, 0x00, 0x1c, 0xff, 0x32,
	0x32, 0xff, 0x32, 0x00, 0x00, 0x1c, 0xff, 0x32,
	0x24, 0xff, 0x35, 0x00, 0x00, 0x2a, 0xff, 0x32,
	0x04, 0xe5, 0xa0, 0x04, 0x08, 0xb1, 0xff, 0x32,
	0x00, 0x2c, 0xef, 0xe5, 0xef, 0x84, 0xff, 0x3b,
	0x00, 0x00, 0x04, 0x15, 0x0c, 0x00, 0x00, 0x00,
	/* ch = 'v' */
	0x4a, 0xcf, 0x1a, 0x00, 0x00, 0x00, 0x78, 0x73,
	0x17, 0xff, 0x48, 0x00, 0x00, 0x04, 0xf7, 0x3b,
	0x00, 0xa7, 0xc8, 0x00, 0x00, 0x39, 0xf7, 0x0d,
	0x00, 0x39, 0xff, 0x22, 0x00, 0x97, 0x70, 0x00,
	0x00, 0x04, 0xe5, 0x70, 0x22, 0xff, 0x22, 0x00,
	0x00, 0x00, 0x6b, 0xf7, 0x82, 0xa7, 0x00, 0x00,
	0x00, 0x00, 0x22, 0xff, 0xff, 0x39, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xa7, 0xe5, 0x04, 0x00, 0x00,
	/* ch = 'w' */
	0xcf, 0x45, 0x00, 0x00, 0x00, 0x00, 0x2d, 0xcf, 0x17,
	0xb1, 0x6b, 0x00, 0x54, 0xb7, 0x00, 0x32, 0xff, 0x00,
	0x6b, 0xb1, 0x00, 0xa0, 0xff, 0x17, 0x4d, 0xb7, 0x00,
	0x3b, 0xff, 0x04, 0xff, 0xf7, 0x44, 0x5f, 0x82, 0x00,
	0x1f, 0xff, 0x48, 0xcf, 0x6b, 0x90, 0x82, 0x54, 0x00,
	0x04, 0xff, 0xc8, 0x6b, 0x32, 0xff, 0xcf, 0x35, 0x00,
	0x00, 0xb1, 0xff, 0x32, 0x0d, 0xf7, 0xff, 0x1c, 0x00,
	0x00, 0x6b, 0xff, 0x0d, 0x00, 0x90, 0xf7, 0x00, 0x00,
	/* ch = 'x' */
	0x28, 0xcf, 0x32, 0x00, 0x00, 0x32, 0xcf, 0x1d,
	0x00, 0x6b, 0xf7, 0x17, 0x10, 0xe5, 0x5f, 0x00,
	0x00, 0x04, 0xb7, 0xb1, 0x82, 0xc8, 0x04, 0x00,
	0x00, 0x00, 0x1f, 0xf7, 0xff, 0x24, 0x00, 0x00,
	0x00, 0x00, 0x17, 0xf7, 0xff, 0x24, 0x00, 0x00,
	0x00, 0x00, 0xb1, 0xb7, 0xa0, 0xdb, 0x0d, 0x00,
	0x00, 0x50, 0xff, 0x1f, 0x10, 0xe5, 0x7c, 0x00,
	0x1f, 0xf7, 0x54, 0x00, 0x00, 0x32, 0xff, 0x35,
	/* ch = 'y' */
	0x3a, 0xcf, 0x2d, 0x00, 0x00, 0x00, 0x87, 0x82,
	0x0d, 0xf7, 0x5a, 0x00, 0x00, 0x0d, 0xff, 0x44,
	0x00, 0x70, 0xe5, 0x04, 0x00, 0x3b, 0xff, 0x14,
	0x00, 0x22, 0xff, 0x39, 0x00, 0x90, 0x8a, 0x00,
	0x00, 0x00, 0xa7, 0xa0, 0x14, 0xff, 0x32, 0x00,
	0x00, 0x00, 0x39, 0xff, 0x65, 0xe5, 0x04, 0x00,
	0x00, 0x00, 0x04, 0xf7, 0xff, 0x5f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x70, 0xff, 0x22, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x70, 0xa7, 0x00, 0x00, 0x00,
	0x49, 0x28, 0x2b, 0xff, 0x44, 0x00, 0x00, 0x00,
	0x6c, 0xf7, 0xef, 0x50, 0x00, 0x00, 0x00, 0x00,
	/* ch = 'z' */
	0x1a, 0xcf, 0xcf, 0xcf, 0xcf, 0xcf, 0xcf, 0x1a,
	0x04, 0x15, 0x15, 0x15, 0x17, 0xc6, 0xb1, 0x04,
	0x00, 0x00, 0x00, 0x00, 0x7c, 0xf7, 0x1c, 0x00,
	0x00, 0x00, 0x00, 0x50, 0xff, 0x32, 0x00, 0x00,
	0x00, 0x00, 0x32, 0xff, 0x50, 0x00, 0x00, 0x00,
	0x00, 0x1f, 0xf7, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x10, 0xdb, 0xb1, 0x04, 0x00, 0x00, 0x00, 0x0f,
	0x50, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7c,
	/* ch = '{' */
	0x00, 0x28, 0xab, 0xcf, 0xcf,
	0x22, 0xff, 0x5f, 0x15, 0x15,
	0x50, 0xff, 0x00, 0x00, 0x00,
	0x50, 0xff, 0x00, 0x00, 0x00,
	0x50, 0xff, 0x00, 0x00, 0x00,
	0xa7, 0x8a, 0x00, 0x00, 0x00,
	0xc6, 0x08, 0x00, 0x00, 0x00,
	0xdb, 0x4d, 0x00, 0x00, 0x00,
	0x6b, 0xcf, 0x00, 0x00, 0x00,
	0x5f, 0xff, 0x00, 0x00, 0x00,
	0x7c, 0xcf, 0x00, 0x00, 0x00,
	0x5f, 0xff, 0x04, 0x00, 0x00,
	0x2a, 0xff, 0x84, 0x1a, 0x15,
	0x00, 0x28, 0x74, 0xbd, 0x8f,
	/* ch = '|' */
	0x7c, 0xb7,
	0x7c, 0xb7,
	0x7c, 0xb7,
	0x7c, 0xb7,
	0x7c, 0xb7,
	0x7c, 0xb7,
	0x7c, 0xb7,
	0x7c, 0xb7,
	0x7c, 0xb7,
	0x7c, 0xb7,
	0x7c, 0xb7,
	0x7c, 0xb7,
	0x7c, 0xb7,
	0x42, 0x58,
	/* ch = '}' */
	0x95, 0xcf, 0xbd, 0x37, 0x00,
	0x12, 0x15, 0x3f, 0xff, 0x39,
	0x00, 0x00, 0x00, 0xb7, 0x7c,
	0x00, 0x00, 0x00, 0xb7, 0x7c,
	0x00, 0x00, 0x00, 0xb7, 0x7c,
	0x00, 0x00, 0x00, 0x5a, 0xe5,
	0x00, 0x00, 0x00, 0x04, 0x8f,
	0x00, 0x00, 0x00, 0x2f, 0xf7,
	0x00, 0x00, 0x00, 0x90, 0xb1,
	0x00, 0x00, 0x00, 0xb7, 0xb1,
	0x00, 0x00, 0x00, 0x82, 0xb7,
	0x00, 0x00, 0x00, 0xb7, 0x90,
	0x0f, 0x15, 0x65, 0xff, 0x44,
	0x4a, 0xcf, 0x74, 0x37, 0x00,
	/* ch = '~' */
	0x50, 0xcf, 0xbd, 0x28, 0x00, 0x24, 0x5a, 0x04,
	0xf7, 0x2b, 0x5a, 0xff, 0xa4, 0xf7, 0x77, 0x00,
	0x0c, 0x00, 0x00, 0x21, 0x36, 0x22, 0x00, 0x00
};

/* font_inconsolata_18px */
static const unsigned char font_bitmap_18px_bytes[] = {
	/* ch = '!' */
	0x00, 0x94, 0xef, 0x14,
	0x00, 0xb7, 0xff, 0x27,
	0x00, 0xb7, 0xff, 0x1c,
	0x00, 0x82, 0xff, 0x1a,
	0x00, 0x7c, 0xff, 0x00,
	0x00, 0x7c, 0xff, 0x00,
	0x00, 0x54, 0xbd, 0x00,
	0x00, 0x50, 0xb7, 0x00,
	0x00, 0x30, 0x58, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0xa2, 0xe5, 0x1c,
	0x04, 0xe5, 0xff, 0x27,
	0x00, 0x0c, 0x12, 0x00,
	/* ch = '"' */
	0x99, 0xc0, 0x00, 0x6b, 0xdb, 0x04,
	0xb7, 0xf7, 0x00, 0x82, 0xff, 0x14,
	0xb7, 0x90, 0x00, 0x82, 0xb7, 0x00,
	0xff, 0x39, 0x00, 0xe5, 0x50, 0x00,
	0x5b, 0x0d, 0x0d, 0x5b, 0x17, 0x00,
	/* ch = '#' */
	0x00, 0x00, 0x04, 0x15, 0x04, 0x04, 0x15, 0x08, 0x00,
	0x00, 0x00, 0x32, 0xff, 0x1a, 0x24, 0xff, 0x1f, 0x00,
	0x00, 0x00, 0x3b, 0xff, 0x00, 0x32, 0xff, 0x0d, 0x00,
	0x0c, 0x15, 0x5e, 0xc6, 0x15, 0x5e, 0xff, 0x15, 0x0c,
	0x42, 0x74, 0xc8, 0xc8, 0x74, 0xc8, 0xe5, 0x74, 0x30,
	0x00, 0x00, 0xa0, 0x77, 0x00, 0x82, 0x82, 0x00, 0x00,
	0x00, 0x00, 0xbd, 0x50, 0x00, 0xb7, 0x6b, 0x00, 0x00,
	0x12, 0x15, 0xff, 0x42, 0x2a, 0xf7, 0x82, 0x36, 0x0d,
	0x58, 0x87, 0xff, 0x87, 0x87, 0xff, 0x6f, 0x36, 0x0d,
	0x00, 0x24, 0xff, 0x1c, 0x1c, 0xff, 0x1f, 0x00, 0x00,
	0x00, 0x32, 0xff, 0x00, 0x32, 0xff, 0x14, 0x00, 0x00,
	0x00, 0x45, 0xab, 0x00, 0x3a, 0xcf, 0x00, 0x00, 0x00,
	/* ch = '$' */
	0x00, 0x00, 0x1a, 0xcf, 0x2d, 0x00, 0x00, 0x00,
	0x00, 0x1b, 0x6b, 0xff, 0x9c, 0x25, 0x00, 0x00,
	0x32, 0xff, 0x94, 0xff, 0xab, 0xf7, 0x84, 0x00,
	0xb1, 0x82, 0x1c, 0xff, 0x32, 0x2a, 0x39, 0x00,
	0xb1, 0xb7, 0x1f, 0xff, 0x32, 0x00, 0x00, 0x00,
	0x32, 0xf7, 0xef, 0xff, 0x32, 0x00, 0x00, 0x00,
	0x00, 0x13, 0x6b, 0xff, 0xf7, 0x8d, 0x13, 0x00,
	0x00, 0x00, 0x1c, 0xff, 0x58, 0xd4, 0xdb, 0x04,
	0x00, 0x00, 0x1c, 0xff, 0x32, 0x2c, 0xff, 0x2a,
	0x73, 0x10, 0x1c, 0xff, 0x32, 0x3f, 0xff, 0x1a,
	0xdb, 0xdb, 0x5f, 0xff, 0x99, 0xf7, 0x73, 0x00,
	0x04, 0x3f, 0x95, 0xff, 0x9c, 0x31, 0x00, 0x00,
	0x00, 0x00, 0x1a, 0xcf, 0x2d, 0x00, 0x00, 0x00,
	/* ch = '%' */
	0x00, 0x22, 0x36, 0x13, 0x00, 0x00, 0x08, 0x15, 0x04,
	0x39, 0xf7, 0x95, 0xf7, 0x17, 0x00, 0x7c, 0xb7, 0x00,
	0xa0, 0x82, 0x04, 0xff, 0x4d, 0x24, 0xff, 0x2a, 0x00,
	0xa0, 0x82, 0x04, 0xff, 0x4d, 0xa0, 0x90, 0x00, 0x00,
	0x2f, 0xff, 0xdd, 0xdb, 0x3f, 0xff, 0x1c, 0x00, 0x00,
	0x00, 0x0f, 0x15, 0x0c, 0xc8, 0x6b, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x44, 0xf7, 0x10, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x0d, 0xe5, 0x50, 0x22, 0x36, 0x22, 0x00,
	0x00, 0x00, 0x5f, 0xdb, 0x2c, 0xff, 0x73, 0xff, 0x2f,
	0x00, 0x17, 0xf7, 0x3b, 0x77, 0xa0, 0x00, 0x90, 0x77,
	0x00, 0x7c, 0xb7, 0x00, 0x6b, 0xb7, 0x00, 0xb7, 0x6b,
	0x24, 0xff, 0x2a, 0x00, 0x17, 0xdb, 0xdd, 0xdb, 0x1c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x15, 0x04, 0x00,
	/* ch = '&' */
	0x00, 0x00, 0x08, 0x25, 0x20, 0x04, 0x00, 0x00, 0x00,
	0x00, 0x1c, 0xdb, 0xe5, 0xef, 0xd4, 0x0d, 0x00, 0x00,
	0x00, 0x6b, 0xf7, 0x10, 0x1c, 0xff, 0x44, 0x00, 0x00,
	0x00, 0x77, 0xe5, 0x04, 0x04, 0xff, 0x4d, 0x00, 0x00,
	0x00, 0x2a, 0xff, 0x3b, 0x50, 0xf7, 0x17, 0x00, 0x00,
	0x00, 0x00, 0x82, 0xff, 0xf7, 0x32, 0x00, 0x00, 0x00,
	0x00, 0x32, 0xf7, 0xff, 0xc8, 0x04, 0x00, 0x0c, 0x00,
	0x1c, 0xf7, 0x7c, 0x1f, 0xf7, 0x77, 0x04, 0xe5, 0x2f,
	0x5f, 0xff, 0x17, 0x00, 0x4d, 0xff, 0x94, 0xf7, 0x1c,
	0x7c, 0xff, 0x04, 0x00, 0x00, 0x88, 0xff, 0x54, 0x00,
	0x48, 0xff, 0x54, 0x00, 0x37, 0xf7, 0xf7, 0xb1, 0x04,
	0x04, 0x84, 0xff, 0xff, 0xf7, 0x50, 0x2f, 0xf7, 0x33,
	0x00, 0x00, 0x0c, 0x15, 0x04, 0x00, 0x00, 0x0f, 0x00,
	/* ch = ''' */
	0x0d, 0xef, 0x66,
	0x1a, 0xff, 0x7c,
	0x14, 0xff, 0x44,
	0x32, 0xff, 0x14,
	0x24, 0x4e, 0x00,
	/* ch = '(' */
	0x00, 0x28, 0xd4, 0x2c,
	0x4d, 0xff, 0x77, 0x0f,
	0xff, 0x50, 0x00, 0x00,
	0xa0, 0x00, 0x00, 0x00,
	0x2c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x0d, 0x00, 0x00, 0x00,
	0x48, 0x00, 0x00, 0x00,
	0xdb, 0x04, 0x00, 0x00,
	0xff, 0x7c, 0x00, 0x00,
	0x32, 0xff, 0x8a, 0x08,
	0x00, 0x26, 0xef, 0x44,
	0x00, 0x00, 0x08, 0x04,
	/* ch = ')' */
	0x8a, 0x66, 0x04, 0x00,
	0x37, 0xf7, 0xb1, 0x10,
	0x00, 0x1f, 0xf7, 0xb1,
	0x00, 0x00, 0x32, 0xff,
	0x00, 0x00, 0x00, 0x90,
	0x00, 0x00, 0x00, 0x3b,
	0x00, 0x00, 0x00, 0x1c,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x1c,
	0x00, 0x00, 0x00, 0x32,
	0x00, 0x00, 0x00, 0x8a,
	0x00, 0x00, 0x24, 0xff,
	0x00, 0x10, 0xdb, 0xb1,
	0x28, 0xdb, 0xd4, 0x10,
	0xcf, 0x8d, 0x08, 0x00,
	0x0c, 0x00, 0x00, 0x00,
	/* ch = '*' */
	0x00, 0x00, 0x00, 0x1e, 0x36, 0x13, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x44, 0xff, 0x1c, 0x00, 0x00, 0x00,
	0x17, 0x37, 0x04, 0x32, 0xff, 0x04, 0x08, 0x2a, 0x00,
	0x4a, 0xf7, 0xe5, 0x6f, 0xff, 0x66, 0xf7, 0xdd, 0x11,
	0x00, 0x04, 0x25, 0xa7, 0xff, 0x74, 0x0f, 0x00, 0x00,
	0x00, 0x00, 0x32, 0xff, 0x97, 0xdb, 0x10, 0x00, 0x00,
	0x00, 0x1f, 0xf7, 0x5f, 0x04, 0xc8, 0xb1, 0x04, 0x00,
	0x00, 0x51, 0xb7, 0x04, 0x00, 0x2a, 0xef, 0x22, 0x00,
	/* ch = '+' */
	0x00, 0x00, 0x00, 0x16, 0x36, 0x0d, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x32, 0xff, 0x1c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x32, 0xff, 0x1c, 0x00, 0x00, 0x00,
	0x1e, 0x36, 0x36, 0x62, 0xff, 0x4a, 0x36, 0x36, 0x0d,
	0x45, 0xcf, 0xcf, 0xdd, 0xff, 0xd4, 0xcf, 0xcf, 0x1a,
	0x00, 0x00, 0x00, 0x32, 0xff, 0x1c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x32, 0xff, 0x1c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x32, 0xff, 0x1c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x08, 0x15, 0x04, 0x00, 0x00, 0x00,
	/* ch = ',' */
	0x00, 0x9c, 0xbd, 0x10,
	0x0d, 0xef, 0xff, 0x4d,
	0x00, 0x26, 0xff, 0x32,
	0x00, 0x5f, 0xb1, 0x00,
	0x1e, 0xd4, 0x10, 0x00,
	/* ch = '-' */
	0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x12,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb7,
	/* ch = '.' */
	0x00, 0x8d, 0xbd, 0x17,
	0x04, 0xf7, 0xff, 0x27,
	0x00, 0x0c, 0x0f, 0x00,
	/* ch = '/' */
	0x00, 0xa0, 0x5c,
	0x22, 0xff, 0x44,
	0x8a, 0xe5, 0x04,
	0xff, 0x50, 0x00,
	0xf7, 0x0d, 0x00,
	0x5f, 0x00, 0x00,
	0x17, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	/* ch = '0' */
	0x00, 0x00, 0x00, 0x0f, 0x15, 0x08, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x6b, 0xff, 0xdd, 0xf7, 0x2c, 0x00, 0x00,
	0x00, 0x44, 0xff, 0x26, 0x00, 0x64, 0xf7, 0x17, 0x00,
	0x00, 0xcf, 0x70, 0x00, 0x00, 0x21, 0xff, 0x5f, 0x00,
	0x1f, 0xff, 0x2a, 0x00, 0x10, 0xdb, 0xf7, 0xbd, 0x00,
	0x32, 0xff, 0x1c, 0x04, 0xb1, 0xb1, 0x54, 0xff, 0x00,
	0x49, 0xff, 0x17, 0x50, 0xf7, 0x1f, 0x3b, 0xff, 0x11,
	0x32, 0xff, 0x50, 0xff, 0x32, 0x00, 0x50, 0xff, 0x00,
	0x1f, 0xff, 0xff, 0x50, 0x00, 0x00, 0x6b, 0xcf, 0x00,
	0x00, 0xc8, 0xd9, 0x00, 0x00, 0x04, 0xcf, 0x70, 0x00,
	0x00, 0x3b, 0xff, 0x54, 0x04, 0x5f, 0xf7, 0x1c, 0x00,
	0x00, 0x00, 0x5a, 0xff, 0xff, 0xef, 0x2c, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x0c, 0x15, 0x04, 0x00, 0x00, 0x00,
	/* ch = '1' */
	0x00, 0x00, 0x00, 0x15, 0x08,
	0x00, 0x31, 0xd4, 0xff, 0x32,
	0x60, 0xc4, 0x78, 0xff, 0x32,
	0x00, 0x00, 0x1c, 0xff, 0x32,
	0x00, 0x00, 0x1c, 0xff, 0x32,
	0x00, 0x00, 0x1c, 0xff, 0x32,
	0x00, 0x00, 0x1c, 0xff, 0x32,
	0x00, 0x00, 0x1c, 0xff, 0x32,
	0x00, 0x00, 0x1c, 0xff, 0x32,
	0x00, 0x00, 0x1c, 0xff, 0x32,
	0x00, 0x00, 0x1c, 0xff, 0x32,
	0x00, 0x00, 0x1c, 0xff, 0x32,
	/* ch = '2' */
	0x00, 0x00, 0x12, 0x15, 0x0f, 0x00, 0x00,
	0x19, 0xbb, 0xf7, 0xdd, 0xff, 0x77, 0x00,
	0xa4, 0xb1, 0x08, 0x00, 0x3b, 0xff, 0x44,
	0x04, 0x08, 0x00, 0x00, 0x00, 0xbd, 0xa0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0x90,
	0x00, 0x00, 0x00, 0x00, 0x32, 0xff, 0x39,
	0x00, 0x00, 0x00, 0x21, 0xf7, 0x7c, 0x00,
	0x00, 0x00, 0x26, 0xf7, 0x7c, 0x04, 0x00,
	0x00, 0x1f, 0xf7, 0x7c, 0x00, 0x00, 0x00,
	0x10, 0xdb, 0xa0, 0x04, 0x00, 0x00, 0x00,
	0x6b, 0xec, 0x1f, 0x15, 0x15, 0x15, 0x12,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb7,
	/* ch = '3' */
	0x00, 0x00, 0x00, 0x15, 0x15, 0x08, 0x00, 0x00,
	0x00, 0x26, 0xd4, 0xff, 0xef, 0xf7, 0x3b, 0x00,
	0x00, 0x24, 0x5a, 0x04, 0x04, 0x6f, 0xff, 0x17,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x32,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x3b, 0xff, 0x22,
	0x00, 0x00, 0x0d, 0x36, 0x66, 0xf7, 0x4d, 0x00,
	0x00, 0x00, 0x14, 0x74, 0xc4, 0xf7, 0x5a, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x37, 0xff, 0x2c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe5, 0x6b,
	0x00, 0x04, 0x08, 0x00, 0x00, 0x0d, 0xff, 0x6b,
	0x04, 0x7c, 0x8a, 0x08, 0x08, 0x8a, 0xff, 0x24,
	0x00, 0x35, 0xef, 0xff, 0xff, 0xef, 0x35, 0x00,
	0x00, 0x00, 0x00, 0x15, 0x15, 0x00, 0x00, 0x00,
	/* ch = '4' */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xf7, 0x7c, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x04, 0xb1, 0xff, 0x7c, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x50, 0xdb, 0xff, 0x7c, 0x00, 0x00,
	0x00, 0x00, 0x1f, 0xf7, 0x2a, 0xff, 0x7c, 0x00, 0x00,
	0x00, 0x04, 0xb1, 0x6b, 0x00, 0xff, 0x7c, 0x00, 0x00,
	0x00, 0x50, 0xdb, 0x0d, 0x00, 0xff, 0x7c, 0x00, 0x00,
	0x1f, 0xf7, 0x42, 0x15, 0x15, 0xff, 0x88, 0x15, 0x04,
	0x45, 0xcf, 0xcf, 0xcf, 0xcf, 0xff, 0xff, 0xff, 0x1c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x7c, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x7c, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x7c, 0x00, 0x00,
	/* ch = '5' */
	0x00, 0x0c, 0x15, 0x15, 0x15, 0x15, 0x15, 0x0f,
	0x00, 0x50, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7c,
	0x00, 0x50, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x77, 0xb7, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x7c, 0xb7, 0x12, 0x15, 0x0f, 0x00, 0x00,
	0x00, 0x90, 0xff, 0xef, 0xd4, 0xff, 0x94, 0x04,
	0x00, 0x6d, 0x73, 0x04, 0x00, 0x32, 0xff, 0x5f,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0xe5,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xff,
	0x00, 0x10, 0x16, 0x00, 0x00, 0x00, 0xa7, 0xcf,
	0x0a, 0xe5, 0xb1, 0x13, 0x00, 0x3f, 0xff, 0x50,
	0x00, 0x21, 0xcb, 0xff, 0xff, 0xff, 0x66, 0x04,
	0x00, 0x00, 0x00, 0x0f, 0x15, 0x08, 0x00, 0x00,
	/* ch = '6' */
	0x00, 0x00, 0x00, 0x08, 0x2a, 0x25, 0x08, 0x00,
	0x00, 0x00, 0x3b, 0xf7, 0xe5, 0xe5, 0xf7, 0x36,
	0x00, 0x1c, 0xff, 0x5f, 0x00, 0x00, 0x48, 0x08,
	0x00, 0x7c, 0xe5, 0x04, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xcf, 0x6b, 0x08, 0x15, 0x0f, 0x00, 0x00,
	0x04, 0xff, 0xb1, 0xf7, 0xf7, 0xff, 0x84, 0x04,
	0x1c, 0xff, 0xf7, 0x28, 0x00, 0x35, 0xff, 0x44,
	0x1c, 0xff, 0x54, 0x00, 0x00, 0x00, 0xa0, 0xb1,
	0x00, 0xff, 0x5f, 0x00, 0x00, 0x00, 0x7c, 0xb7,
	0x00, 0xa0, 0xc8, 0x00, 0x00, 0x00, 0xa7, 0xa0,
	0x00, 0x3b, 0xff, 0x54, 0x00, 0x35, 0xff, 0x3b,
	0x00, 0x00, 0x50, 0xf7, 0xff, 0xff, 0x66, 0x00,
	0x00, 0x00, 0x00, 0x08, 0x15, 0x08, 0x00, 0x00,
	/* ch = '7' */
	0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x12,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0,
	0x00, 0x00, 0x00, 0x00, 0x2c, 0xff, 0x39,
	0x00, 0x00, 0x00, 0x00, 0x8a, 0xe5, 0x04,
	0x00, 0x00, 0x00, 0x17, 0xff, 0x5a, 0x00,
	0x00, 0x00, 0x00, 0x5a, 0xff, 0x17, 0x00,
	0x00, 0x00, 0x04, 0xe5, 0x90, 0x00, 0x00,
	0x00, 0x00, 0x2c, 0xff, 0x39, 0x00, 0x00,
	0x00, 0x00, 0x8a, 0xf7, 0x0d, 0x00, 0x00,
	0x00, 0x0d, 0xf7, 0x7c, 0x00, 0x00, 0x00,
	0x00, 0x39, 0xff, 0x32, 0x00, 0x00, 0x00,
	0x00, 0x90, 0xf7, 0x04, 0x00, 0x00, 0x00,
	/* ch = '8' */
	0x00, 0x00, 0x00, 0x20, 0x36, 0x18, 0x00, 0x00,
	0x00, 0x04, 0xa9, 0xf7, 0xcf, 0xff, 0x99, 0x04,
	0x00, 0x5a, 0xf7, 0x13, 0x00, 0x32, 0xff, 0x40,
	0x00, 0x7c, 0xbd, 0x00, 0x00, 0x00, 0xff, 0x50,
	0x00, 0x48, 0xff, 0x32, 0x00, 0x3b, 0xff, 0x2a,
	0x00, 0x04, 0x94, 0xff, 0x9e, 0xf7, 0x44, 0x00,
	0x00, 0x04, 0x84, 0xef, 0xb3, 0xff, 0x5a, 0x00,
	0x00, 0x7c, 0xdb, 0x10, 0x00, 0x3b, 0xff, 0x4d,
	0x1a, 0xff, 0x48, 0x00, 0x00, 0x00, 0xa7, 0xbd,
	0x1c, 0xff, 0x48, 0x00, 0x00, 0x00, 0x90, 0xcf,
	0x00, 0xc8, 0xdb, 0x1b, 0x00, 0x37, 0xff, 0x5f,
	0x00, 0x19, 0xbb, 0xff, 0xff, 0xff, 0x73, 0x04,
	0x00, 0x00, 0x00, 0x0f, 0x15, 0x08, 0x00, 0x00,
	/* ch = '9' */
	0x00, 0x00, 0x00, 0x1a, 0x2a, 0x0c, 0x00, 0x00,
	0x00, 0x10, 0xbb, 0xf7, 0xdd, 0xff, 0x44, 0x00,
	0x00, 0x7c, 0xe5, 0x13, 0x00, 0x54, 0xff, 0x22,
	0x00, 0xf7, 0x5f, 0x00, 0x00, 0x04, 0xf7, 0x6b,
	0x11, 0xff, 0x50, 0x00, 0x00, 0x00, 0xb7, 0xb1,
	0x00, 0xe5, 0x7c, 0x00, 0x00, 0x04, 0xcf, 0xb7,
	0x00, 0x4d, 0xff, 0x47, 0x1a, 0x99, 0xff, 0xb7,
	0x00, 0x00, 0x50, 0xdd, 0xe5, 0x7f, 0xaf, 0xb7,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xcf, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0xff, 0x39,
	0x00, 0x32, 0x50, 0x04, 0x16, 0xc4, 0xc8, 0x04,
	0x00, 0x44, 0xf7, 0xff, 0xff, 0xbb, 0x13, 0x00,
	0x00, 0x00, 0x04, 0x15, 0x0f, 0x00, 0x00, 0x00,
	/* ch = ':' */
	0x00, 0x48, 0x67, 0x04,
	0x0a, 0xff, 0xff, 0x2f,
	0x00, 0x22, 0x30, 0x04,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x8d, 0xbd, 0x17,
	0x04, 0xf7, 0xff, 0x27,
	0x00, 0x0c, 0x0f, 0x00,
	/* ch = ';' */
	0x00, 0x48, 0x67, 0x04,
	0x0a, 0xff, 0xff, 0x2f,
	0x00, 0x22, 0x30, 0x04,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x9c, 0xbd, 0x10,
	0x0d, 0xef, 0xff, 0x4d,
	0x00, 0x26, 0xff, 0x32,
	0x00, 0x5f, 0xb1, 0x00,
	0x1e, 0xd4, 0x10, 0x00,
	/* ch = '<' */
	0x00, 0x00, 0x00, 0x00, 0x08, 0x04,
	0x00, 0x00, 0x04, 0x48, 0xef, 0x1c,
	0x04, 0x37, 0xe5, 0xef, 0x3f, 0x04,
	0xd4, 0xef, 0x48, 0x04, 0x00, 0x00,
	0x50, 0x08, 0x00, 0x00, 0x00, 0x00,
	0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xd4, 0x2b, 0x00, 0x00, 0x00, 0x00,
	0x5a, 0xf7, 0xbb, 0x1b, 0x00, 0x00,
	0x00, 0x13, 0x94, 0xff, 0x8d, 0x10,
	0x00, 0x00, 0x00, 0x28, 0xd4, 0x32,
	0x00, 0x00, 0x00, 0x00, 0x04, 0x08,
	/* ch = '=' */
	0x45, 0xcf, 0xcf, 0xcf, 0xcf, 0xcf, 0xcf, 0xcf, 0x1a,
	0x0c, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x04,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0c, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x04,
	0x50, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1c,
	/* ch = '>' */
	0x0c, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xbb, 0x28, 0x00, 0x00,
	0x13, 0x73, 0xff, 0xb3, 0x1e,
	0x00, 0x00, 0x13, 0x7f, 0xff,
	0x00, 0x00, 0x00, 0x00, 0x16,
	0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x08, 0x50,
	0x00, 0x00, 0x37, 0xef, 0xd4,
	0x26, 0xbb, 0xf7, 0x50, 0x04,
	0x7c, 0x94, 0x13, 0x00, 0x00,
	0x0c, 0x00, 0x00, 0x00, 0x00,
	/* ch = '?' */
	0x00, 0x04, 0x66, 0xe5, 0xff, 0xdd, 0x35, 0x00,
	0x04, 0xb1, 0xf7, 0x3f, 0x20, 0x99, 0xff, 0x2f,
	0x00, 0x5a, 0x2a, 0x00, 0x00, 0x0d, 0xff, 0x90,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xff, 0xb1,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0xff, 0x5a,
	0x00, 0x00, 0x00, 0x00, 0x32, 0xff, 0x8a, 0x04,
	0x00, 0x00, 0x00, 0x0d, 0xe5, 0x82, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x24, 0xff, 0x32, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x22, 0x74, 0x22, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x32, 0xcf, 0x40, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x66, 0xff, 0x84, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x04, 0x15, 0x04, 0x00, 0x00,
	/* ch = '@' */
	0x00, 0x00, 0x00, 0x18, 0x36, 0x2a, 0x08, 0x00, 0x00,
	0x00, 0x08, 0xa2, 0xef, 0x82, 0xcb, 0xdb, 0x1f, 0x00,
	0x00, 0x90, 0xb1, 0x08, 0x00, 0x00, 0x7c, 0xc8, 0x00,
	0x2a, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x1f, 0xff, 0x24,
	0x5f, 0xb7, 0x00, 0x13, 0x8d, 0xf7, 0xff, 0xff, 0x32,
	0x90, 0x7c, 0x00, 0xc8, 0xb1, 0x0c, 0x00, 0xff, 0x32,
	0xb7, 0x7c, 0x1c, 0xff, 0x32, 0x00, 0x14, 0xff, 0x32,
	0x7c, 0x82, 0x0d, 0xf7, 0x7c, 0x08, 0x64, 0xff, 0x32,
	0x50, 0xe5, 0x04, 0x2c, 0xe5, 0xff, 0xb3, 0xcf, 0x2d,
	0x17, 0xff, 0x4d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x50, 0xf7, 0x3f, 0x00, 0x00, 0x13, 0x19, 0x00,
	0x00, 0x00, 0x40, 0xef, 0xef, 0xd4, 0xff, 0x5e, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x15, 0x15, 0x04, 0x00, 0x00,
	/* ch = 'A' */
	0x00, 0x00, 0x00, 0x0d, 0x19, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x44, 0x8a, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xa0, 0xff, 0x14, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x17, 0xff, 0xff, 0x48, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x48, 0xe5, 0x7c, 0xc8, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xa7, 0x6b, 0x2c, 0xff, 0x22, 0x00, 0x00,
	0x00, 0x1c, 0xff, 0x2a, 0x00, 0xe5, 0x70, 0x00, 0x00,
	0x00, 0x50, 0xec, 0x15, 0x15, 0x6d, 0xe5, 0x04, 0x00,
	0x00, 0xc8, 0xe5, 0xcf, 0xcf, 0xd4, 0xff, 0x39, 0x00,
	0x22, 0xff, 0x32, 0x00, 0x00, 0x00, 0xc8, 0xa0, 0x00,
	0x5a, 0xf7, 0x04, 0x00, 0x00, 0x00, 0x5a, 0xff, 0x17,
	0xcf, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x17, 0xff, 0x5a,
	/* ch = 'B' */
	0x0c, 0x15, 0x15, 0x15, 0x15, 0x0c, 0x00, 0x00, 0x00,
	0x50, 0xff, 0xd4, 0xcf, 0xef, 0xff, 0x94, 0x04, 0x00,
	0x50, 0xff, 0x1c, 0x00, 0x00, 0x35, 0xff, 0x5a, 0x00,
	0x50, 0xff, 0x1c, 0x00, 0x00, 0x00, 0xbd, 0xb1, 0x00,
	0x50, 0xff, 0x1c, 0x00, 0x00, 0x13, 0xf7, 0x66, 0x00,
	0x50, 0xff, 0x87, 0x74, 0x82, 0xef, 0xa9, 0x04, 0x00,
	0x50, 0xff, 0x4a, 0x36, 0x74, 0xd4, 0xcb, 0x19, 0x00,
	0x50, 0xff, 0x1c, 0x00, 0x00, 0x04, 0xb7, 0xc8, 0x00,
	0x50, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x50, 0xff, 0x1c,
	0x50, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x5f, 0xff, 0x1a,
	0x50, 0xff, 0x28, 0x15, 0x15, 0x3f, 0xff, 0x90, 0x00,
	0x50, 0xff, 0xff, 0xff, 0xff, 0xe5, 0x66, 0x04, 0x00,
	/* ch = 'C' */
	0x00, 0x00, 0x0c, 0x25, 0x1a, 0x04, 0x00, 0x00,
	0x04, 0x66, 0xff, 0xcf, 0xe5, 0xef, 0x2f, 0x00,
	0x6b, 0xf7, 0x26, 0x00, 0x04, 0x7c, 0xff, 0x1f,
	0xff, 0x5f, 0x00, 0x00, 0x00, 0x14, 0x37, 0x00,
	0xff, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xf7, 0x82, 0x00, 0x00, 0x00, 0x04, 0x0f, 0x00,
	0x50, 0xff, 0x5f, 0x04, 0x08, 0x8a, 0xef, 0x17,
	0x00, 0x50, 0xf7, 0xff, 0xff, 0xcb, 0x21, 0x00,
	0x00, 0x00, 0x04, 0x15, 0x12, 0x00, 0x00, 0x00,
	/* ch = 'D' */
	0x08, 0x15, 0x15, 0x15, 0x15, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0xd4, 0xd4, 0xff, 0xef, 0x35, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x08, 0x8a, 0xff, 0x2f, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x04, 0xdb, 0xa7, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x5f, 0xff, 0x14,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x35, 0xff, 0x24,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x32, 0xff, 0x32,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x35, 0xff, 0x1c,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x5f, 0xf7, 0x04,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x10, 0xe5, 0x7c, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x1e, 0xb1, 0xdb, 0x10, 0x00,
	0x32, 0xff, 0xff, 0xff, 0xf7, 0x8d, 0x13, 0x00, 0x00,
	/* ch = 'E' */
	0x08, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15,
	0x32, 0xff, 0xdd, 0xcf, 0xcf, 0xcf, 0xcf, 0xcf,
	0x32, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x62, 0x36, 0x36, 0x36, 0x36, 0x00,
	0x32, 0xff, 0xdd, 0xcf, 0xcf, 0xcf, 0xcf, 0x00,
	0x32, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x3e, 0x15, 0x15, 0x15, 0x15, 0x12,
	0x32, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb7,
	/* ch = 'F' */
	0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x12,
	0xff, 0xef, 0xcf, 0xcf, 0xcf, 0xcf, 0x95,
	0xff, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0xc8, 0x74, 0x74, 0x74, 0x58, 0x00,
	0xff, 0xa5, 0x36, 0x36, 0x36, 0x2d, 0x00,
	0xff, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x00,
	/* ch = 'G' */
	0x00, 0x00, 0x00, 0x0f, 0x2a, 0x20, 0x08, 0x00, 0x00,
	0x00, 0x04, 0x84, 0xff, 0xd4, 0xef, 0xef, 0x2f, 0x00,
	0x00, 0x7c, 0xf7, 0x28, 0x00, 0x04, 0x7c, 0xf7, 0x11,
	0x22, 0xff, 0x3b, 0x00, 0x00, 0x00, 0x0d, 0x21, 0x00,
	0x4d, 0xff, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7c, 0xe5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7c, 0xbd, 0x00, 0x00, 0x16, 0x36, 0x36, 0x36, 0x16,
	0x7c, 0xff, 0x00, 0x00, 0x2d, 0xcf, 0xd4, 0xff, 0x32,
	0x4d, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x32,
	0x17, 0xff, 0x5f, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x32,
	0x00, 0x6b, 0xff, 0x3f, 0x04, 0x04, 0x43, 0xff, 0x32,
	0x00, 0x00, 0x5b, 0xf7, 0xff, 0xff, 0xe5, 0x48, 0x04,
	0x00, 0x00, 0x00, 0x04, 0x15, 0x12, 0x00, 0x00, 0x00,
	/* ch = 'H' */
	0x08, 0x15, 0x08, 0x00, 0x00, 0x00, 0x0f, 0x15,
	0x32, 0xff, 0x32, 0x00, 0x00, 0x00, 0x7c, 0xff,
	0x32, 0xff, 0x32, 0x00, 0x00, 0x00, 0x7c, 0xff,
	0x32, 0xff, 0x32, 0x00, 0x00, 0x00, 0x7c, 0xff,
	0x32, 0xff, 0x32, 0x00, 0x00, 0x00, 0x7c, 0xff,
	0x32, 0xff, 0x62, 0x36, 0x36, 0x36, 0xa5, 0xff,
	0x32, 0xff, 0x9c, 0x74, 0x74, 0x74, 0xc8, 0xff,
	0x32, 0xff, 0x32, 0x00, 0x00, 0x00, 0x7c, 0xff,
	0x32, 0xff, 0x32, 0x00, 0x00, 0x00, 0x7c, 0xff,
	0x32, 0xff, 0x32, 0x00, 0x00, 0x00, 0x7c, 0xff,
	0x32, 0xff, 0x32, 0x00, 0x00, 0x00, 0x7c, 0xff,
	0x32, 0xff, 0x32, 0x00, 0x00, 0x00, 0x7c, 0xff,
	/* ch = 'I' */
	0x0f, 0x15, 0x15, 0x15, 0x15, 0x15, 0x04,
	0x67, 0xcf, 0xef, 0xff, 0xcf, 0xcf, 0x1a,
	0x00, 0x00, 0x7c, 0xff, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0xff, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0xff, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0xff, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0xff, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0xff, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0xff, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0xff, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7c, 0xff, 0x00, 0x00, 0x00,
	0xb7, 0xff, 0xff, 0xff, 0xff, 0xff, 0x32,
	/* ch = 'J' */
	0x04, 0x15, 0x15, 0x15, 0x15, 0x15, 0x04,
	0x1a, 0xcf, 0xcf, 0xff, 0xe5, 0xcf, 0x1a,
	0x00, 0x00, 0x00, 0xff, 0x50, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xff, 0x50, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xff, 0x50, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xff, 0x50, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xff, 0x50, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xff, 0x50, 0x00, 0x00,
	0x00, 0x00, 0x14, 0xff, 0x50, 0x00, 0x00,
	0x00, 0x00, 0x1f, 0xff, 0x44, 0x00, 0x00,
	0x21, 0x00, 0x7c, 0xff, 0x17, 0x00, 0x00,
	0xff, 0xff, 0xf7, 0x3b, 0x00, 0x00, 0x00,
	0x0f, 0x15, 0x08, 0x00, 0x00, 0x00, 0x00,
	/* ch = 'K' */
	0x0c, 0x15, 0x08, 0x00, 0x00, 0x00, 0x21, 0x15, 0x04,
	0x50, 0xff, 0x1c, 0x00, 0x00, 0x32, 0xf7, 0x50, 0x00,
	0x50, 0xff, 0x1c, 0x00, 0x1f, 0xf7, 0x7c, 0x00, 0x00,
	0x50, 0xff, 0x1c, 0x10, 0xdb, 0xb1, 0x04, 0x00, 0x00,
	0x50, 0xff, 0x26, 0xd4, 0xdb, 0x10, 0x00, 0x00, 0x00,
	0x50, 0xff, 0xdb, 0xff, 0x13, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xff, 0xd4, 0xff, 0x5f, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xff, 0x1f, 0x6b, 0xff, 0x2a, 0x00, 0x00, 0x00,
	0x50, 0xff, 0x1c, 0x04, 0xc8, 0xdb, 0x10, 0x00, 0x00,
	0x50, 0xff, 0x1c, 0x00, 0x1f, 0xff, 0x7c, 0x00, 0x00,
	0x50, 0xff, 0x1c, 0x00, 0x00, 0x54, 0xff, 0x3b, 0x00,
	0x50, 0xff, 0x1c, 0x00, 0x00, 0x04, 0xb1, 0xf7, 0x1f,
	/* ch = 'L' */
	0x04, 0x15, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb7,
	/* ch = 'M' */
	0x0f, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x08,
	0x7c, 0xf7, 0x17, 0x00, 0x00, 0x00, 0x39, 0xff, 0x32,
	0x7c, 0xff, 0x6b, 0x00, 0x00, 0x04, 0xc8, 0xff, 0x32,
	0x7c, 0xff, 0xf7, 0x17, 0x00, 0x3b, 0xff, 0xff, 0x32,
	0x7c, 0xbd, 0xe5, 0x6b, 0x04, 0xdb, 0x90, 0xff, 0x32,
	0x7c, 0xb7, 0x48, 0xf7, 0x5f, 0xf7, 0x24, 0xff, 0x32,
	0x7c, 0xb7, 0x04, 0xdb, 0xff, 0x50, 0x1c, 0xff, 0x32,
	0x7c, 0xb7, 0x00, 0x44, 0xdb, 0x04, 0x1c, 0xff, 0x32,
	0x7c, 0xb7, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x32,
	0x7c, 0xb7, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x32,
	0x7c, 0xb7, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x32,
	0x7c, 0xb7, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x32,
	/* ch = 'N' */
	0x0c, 0x15, 0x04, 0x00, 0x00, 0x00, 0x0c, 0x15, 0x04,
	0x50, 0xff, 0x5f, 0x00, 0x00, 0x00, 0x50, 0xff, 0x00,
	0x50, 0xff, 0xf7, 0x17, 0x00, 0x00, 0x50, 0xff, 0x00,
	0x50, 0xff, 0xff, 0x7c, 0x00, 0x00, 0x50, 0xff, 0x00,
	0x50, 0xff, 0x7c, 0xff, 0x24, 0x00, 0x50, 0xff, 0x00,
	0x50, 0xff, 0x1f, 0xdb, 0xa0, 0x00, 0x50, 0xff, 0x00,
	0x50, 0xff, 0x1c, 0x3b, 0xff, 0x3b, 0x50, 0xff, 0x00,
	0x50, 0xff, 0x1c, 0x00, 0xa0, 0xdb, 0x54, 0xff, 0x00,
	0x50, 0xff, 0x1c, 0x00, 0x24, 0xff, 0xe5, 0xff, 0x00,
	0x50, 0xff, 0x1c, 0x00, 0x00, 0x7c, 0xff, 0xff, 0x00,
	0x50, 0xff, 0x1c, 0x00, 0x00, 0x17, 0xf7, 0xff, 0x00,
	0x50, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x5f, 0xff, 0x00,
	/* ch = 'O' */
	0x00, 0x00, 0x00, 0x1a, 0x36, 0x12, 0x00, 0x00, 0x00,
	0x00, 0x13, 0xcb, 0xff, 0xe5, 0xff, 0x94, 0x04, 0x00,
	0x04, 0xb7, 0xdb, 0x13, 0x00, 0x35, 0xff, 0x77, 0x00,
	0x39, 0xff, 0x2c, 0x00, 0x00, 0x00, 0x70, 0xff, 0x0d,
	0x77, 0xe5, 0x00, 0x00, 0x00, 0x00, 0x2f, 0xff, 0x2f,
	0xa0, 0xb7, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x4d,
	0xb7, 0xb7, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x50,
	0x90, 0xbd, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x44,
	0x6b, 0xff, 0x0d, 0x00, 0x00, 0x00, 0x32, 0xff, 0x2a,
	0x2c, 0xff, 0x48, 0x00, 0x00, 0x00, 0x7c, 0xf7, 0x04,
	0x00, 0x90, 0xf7, 0x37, 0x0f, 0x5a, 0xff, 0x50, 0x00,
	0x00, 0x04, 0x8d, 0xff, 0xff, 0xf7, 0x5a, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x0c, 0x15, 0x04, 0x00, 0x00, 0x00,
	/* ch = 'P' */
	0x08, 0x15, 0x15, 0x15, 0x15, 0x12, 0x00, 0x00, 0x00,
	0x32, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd4, 0x19, 0x00,
	0x32, 0xff, 0x32, 0x00, 0x00, 0x1e, 0xdb, 0xc8, 0x00,
	0x32, 0xff, 0x32, 0x00, 0x00, 0x00, 0x54, 0xff, 0x1c,
	0x32, 0xff, 0x32, 0x00, 0x00, 0x00, 0x54, 0xff, 0x1a,
	0x32, 0xff, 0x32, 0x00, 0x00, 0x26, 0xe5, 0xa0, 0x00,
	0x32, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8d, 0x10, 0x00,
	0x32, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	/* ch = 'Q' */
	0x00, 0x00, 0x00, 0x1a, 0x36, 0x12, 0x00, 0x00, 0x00,
	0x00, 0x13, 0xcb, 0xff, 0xd4, 0xff, 0x94, 0x04, 0x00,
	0x04, 0xb7, 0xc8, 0x13, 0x00, 0x28, 0xf7, 0x6b, 0x00,
	0x39, 0xff, 0x2c, 0x00, 0x00, 0x00, 0x64, 0xff, 0x0d,
	0x77, 0xe5, 0x00, 0x00, 0x00, 0x00, 0x2a, 0xff, 0x2f,
	0xa0, 0xb7, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xff, 0x4d,
	0xb7, 0xb7, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x50,
	0x82, 0xb7, 0x00, 0x00, 0x00, 0x00, 0x1a, 0xff, 0x44,
	0x5f, 0xff, 0x0d, 0x00, 0x00, 0x00, 0x2a, 0xff, 0x2f,
	0x2a, 0xff, 0x44, 0x00, 0x00, 0x00, 0x70, 0xf7, 0x0d,
	0x00, 0x90, 0xf7, 0x2b, 0x04, 0x3f, 0xff, 0x50, 0x00,
	0x00, 0x04, 0x8d, 0xff, 0xff, 0xf7, 0x50, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x2a, 0xff, 0x24, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x0d, 0xdb, 0xc4, 0x74, 0x74, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x13, 0x5b, 0x74, 0x74, 0x00,
	/* ch = 'R' */
	0x08, 0x15, 0x15, 0x15, 0x15, 0x0f, 0x00, 0x00, 0x00,
	0x32, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbb, 0x10, 0x00,
	0x32, 0xff, 0x32, 0x00, 0x00, 0x28, 0xf7, 0x8a, 0x00,
	0x32, 0xff, 0x32, 0x00, 0x00, 0x00, 0x82, 0xff, 0x00,
	0x32, 0xff, 0x32, 0x00, 0x00, 0x00, 0x82, 0xf7, 0x00,
	0x32, 0xff, 0x32, 0x00, 0x04, 0x31, 0xf7, 0x6b, 0x00,
	0x32, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8d, 0x04, 0x00,
	0x32, 0xff, 0x32, 0x00, 0x70, 0xf7, 0x0d, 0x00, 0x00,
	0x32, 0xff, 0x32, 0x00, 0x17, 0xff, 0x5a, 0x00, 0x00,
	0x32, 0xff, 0x32, 0x00, 0x00, 0x70, 0xf7, 0x10, 0x00,
	0x32, 0xff, 0x32, 0x00, 0x00, 0x17, 0xff, 0x5f, 0x00,
	0x32, 0xff, 0x32, 0x00, 0x00, 0x00, 0x70, 0xf7, 0x17,
	/* ch = 'S' */
	0x00, 0x00, 0x12, 0x15, 0x12, 0x00, 0x00, 0x00,
	0x10, 0xbb, 0xf7, 0xcf, 0xf7, 0xd4, 0x21, 0x00,
	0xa0, 0xc8, 0x10, 0x00, 0x08, 0xb1, 0x54, 0x00,
	0xff, 0x7c, 0x00, 0x00, 0x00, 0x08, 0x04, 0x00,
	0xb7, 0xe5, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1f, 0xef, 0xf7, 0x66, 0x16, 0x00, 0x00, 0x00,
	0x00, 0x08, 0x50, 0xe5, 0xff, 0x7e, 0x08, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x37, 0xf7, 0xa0, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0xff, 0x1a,
	0x39, 0x00, 0x00, 0x00, 0x00, 0x50, 0xff, 0x1a,
	0xff, 0x77, 0x0c, 0x00, 0x28, 0xef, 0xa0, 0x00,
	0x48, 0xe5, 0xff, 0xff, 0xff, 0x94, 0x10, 0x00,
	0x00, 0x00, 0x12, 0x15, 0x0c, 0x00, 0x00, 0x00,
	/* ch = 'T' */
	0x12, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x08,
	0xb7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x32,
	0x00, 0x00, 0x00, 0x7c, 0xff, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x7c, 0xff, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x7c, 0xff, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x7c, 0xff, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x7c, 0xff, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x7c, 0xff, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x7c, 0xff, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x7c, 0xff, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x7c, 0xff, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x7c, 0xff, 0x00, 0x00, 0x00, 0x00,
	/* ch = 'U' */
	0x0c, 0x15, 0x08, 0x00, 0x00, 0x00, 0x08, 0x15, 0x04,
	0x50, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x32, 0xff, 0x1c,
	0x50, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x32, 0xff, 0x1c,
	0x50, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x32, 0xff, 0x1c,
	0x50, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x32, 0xff, 0x1c,
	0x50, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x32, 0xff, 0x1c,
	0x50, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x32, 0xff, 0x1c,
	0x50, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x32, 0xff, 0x1c,
	0x4d, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x32, 0xff, 0x1c,
	0x2f, 0xff, 0x2c, 0x00, 0x00, 0x00, 0x5f, 0xff, 0x0d,
	0x04, 0xdb, 0xc8, 0x13, 0x00, 0x28, 0xf7, 0x7c, 0x00,
	0x00, 0x19, 0xcb, 0xff, 0xf7, 0xff, 0x7e, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x0f, 0x15, 0x0c, 0x00, 0x00, 0x00,
	/* ch = 'V' */
	0x12, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x0f,
	0x70, 0xf7, 0x04, 0x00, 0x00, 0x00, 0x22, 0xff, 0x39,
	0x2c, 0xff, 0x32, 0x00, 0x00, 0x00, 0x50, 0xf7, 0x0d,
	0x04, 0xe5, 0x7c, 0x00, 0x00, 0x00, 0xb7, 0x8a, 0x00,
	0x00, 0x70, 0xf7, 0x04, 0x00, 0x17, 0xff, 0x39, 0x00,
	0x00, 0x2c, 0xff, 0x32, 0x00, 0x48, 0xf7, 0x0d, 0x00,
	0x00, 0x00, 0xe5, 0x7c, 0x00, 0xa0, 0x8a, 0x00, 0x00,
	0x00, 0x00, 0x6b, 0xf7, 0x17, 0xff, 0x39, 0x00, 0x00,
	0x00, 0x00, 0x2a, 0xff, 0x90, 0xf7, 0x0d, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xe5, 0xff, 0x8a, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x6b, 0xff, 0x39, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x2a, 0xf7, 0x0d, 0x00, 0x00, 0x00,
	/* ch = 'W' */
	0x15, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x12,
	0xcf, 0x6b, 0x00, 0x00, 0x2a, 0x00, 0x00, 0x82, 0x7c,
	0x90, 0x90, 0x00, 0x0d, 0xff, 0x14, 0x00, 0xb7, 0x50,
	0x6b, 0xcf, 0x00, 0x32, 0xff, 0x3b, 0x00, 0xff, 0x32,
	0x44, 0xff, 0x0d, 0x6b, 0xff, 0x7c, 0x1a, 0xff, 0x1f,
	0x2a, 0xff, 0x24, 0xcf, 0xcf, 0xe5, 0x24, 0xff, 0x04,
	0x14, 0xff, 0x5f, 0xff, 0x39, 0xff, 0x54, 0xbd, 0x00,
	0x00, 0xf7, 0xcf, 0xb7, 0x04, 0xf7, 0xe5, 0x90, 0x00,
	0x00, 0xb1, 0xff, 0x5f, 0x00, 0xa0, 0xff, 0x5f, 0x00,
	0x00, 0x77, 0xff, 0x2f, 0x00, 0x50, 0xff, 0x3b, 0x00,
	0x00, 0x4d, 0xff, 0x0d, 0x00, 0x24, 0xff, 0x2a, 0x00,
	0x00, 0x2f, 0xa0, 0x00, 0x00, 0x00, 0xf7, 0x14, 0x00,
	/* ch = 'X' */
	0x0c, 0x15, 0x04, 0x00, 0x00, 0x00, 0x0f, 0x15, 0x00,
	0x1c, 0xff, 0x5f, 0x00, 0x00, 0x04, 0xc8, 0x8a, 0x00,
	0x00, 0x6b, 0xf7, 0x17, 0x00, 0x44, 0xff, 0x1c, 0x00,
	0x00, 0x10, 0xf7, 0x7c, 0x0d, 0xe5, 0x7c, 0x00, 0x00,
	0x00, 0x00, 0x50, 0xff, 0x97, 0xff, 0x17, 0x00, 0x00,
	0x00, 0x00, 0x04, 0xdb, 0xff, 0x70, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x82, 0xff, 0x3f, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x1c, 0xff, 0xff, 0xdb, 0x04, 0x00, 0x00,
	0x00, 0x00, 0x90, 0xe5, 0x32, 0xff, 0x50, 0x00, 0x00,
	0x00, 0x2a, 0xff, 0x44, 0x00, 0x90, 0xf7, 0x10, 0x00,
	0x00, 0xa7, 0xdb, 0x04, 0x00, 0x1c, 0xff, 0x6b, 0x00,
	0x35, 0xff, 0x3b, 0x00, 0x00, 0x00, 0x6b, 0xff, 0x1f,
	/* ch = 'Y' */
	0x12, 0x15, 0x00, 0x00, 0x00, 0x00, 0x04, 0x15, 0x0c,
	0x44, 0xff, 0x2c, 0x00, 0x00, 0x00, 0x48, 0xff, 0x22,
	0x04, 0xdb, 0xa7, 0x00, 0x00, 0x04, 0xe5, 0x8a, 0x00,
	0x00, 0x44, 0xff, 0x32, 0x00, 0x39, 0xff, 0x24, 0x00,
	0x00, 0x04, 0xdb, 0xb7, 0x00, 0xc8, 0xa0, 0x00, 0x00,
	0x00, 0x00, 0x44, 0xff, 0x70, 0xff, 0x2c, 0x00, 0x00,
	0x00, 0x00, 0x04, 0xc8, 0xff, 0xb7, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x3f, 0xff, 0x3b, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x32, 0xff, 0x32, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x32, 0xff, 0x32, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x32, 0xff, 0x32, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x32, 0xff, 0x32, 0x00, 0x00, 0x00,
	/* ch = 'Z' */
	0x04, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x00,
	0x1c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0xf7, 0x54, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0xdb, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x35, 0xff, 0x32, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x0d, 0xdb, 0x90, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x6b, 0xf7, 0x17, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x1f, 0xff, 0x54, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xb1, 0xdb, 0x04, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x10, 0xf7, 0xa4, 0x15, 0x15, 0x15, 0x15, 0x15, 0x08,
	0x4d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x32,
	/* ch = '[' */
	0xff, 0xff, 0xff, 0xff, 0xff, 0x50,
	0xff, 0x50, 0x00, 0x00, 0x00, 0x00,
	0xff, 0x50, 0x00, 0x00, 0x00, 0x00,
	0xff, 0x50, 0x00, 0x00, 0x00, 0x00,
	0xff, 0x50, 0x00, 0x00, 0x00, 0x00,
	0xff, 0x50, 0x00, 0x00, 0x00, 0x00,
	0xff, 0x50, 0x00, 0x00, 0x00, 0x00,
	0xff, 0x50, 0x00, 0x00, 0x00, 0x00,
	0xff, 0x50, 0x00, 0x00, 0x00, 0x00,
	0xff, 0x50, 0x00, 0x00, 0x00, 0x00,
	0xff, 0x50, 0x00, 0x00, 0x00, 0x00,
	0xff, 0x50, 0x00, 0x00, 0x00, 0x00,
	0xff, 0x82, 0x36, 0x36, 0x36, 0x1e,
	0x74, 0x74, 0x74, 0x74, 0x74, 0x30,
	/* ch = '\' */
	0x09, 0xb3, 0x48,
	0x00, 0xa0, 0xc8,
	0x00, 0x2c, 0xff,
	0x00, 0x00, 0xb7,
	0x00, 0x00, 0x39,
	0x00, 0x00, 0x04,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	0x00, 0x00, 0x00,
	/* ch = ']' */
	0xb7, 0xff, 0xff, 0xff, 0xff, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0xb7, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0xb7, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0xb7, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0xb7, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0xb7, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0xb7, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0xb7, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0xb7, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0xb7, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0xb7, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0xb7, 0x7c,
	0x2d, 0x36, 0x36, 0x36, 0xcf, 0x7c,
	0x58, 0x74, 0x74, 0x74, 0x74, 0x42,
	/* ch = '^' */
	0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x32, 0xff, 0x22, 0x00, 0x00,
	0x00, 0x04, 0xdb, 0xff, 0x90, 0x00, 0x00,
	0x00, 0x54, 0xe5, 0x3f, 0xff, 0x2a, 0x00,
	0x17, 0xf7, 0x3b, 0x00, 0xa0, 0xa0, 0x00,
	0x36, 0x8d, 0x00, 0x00, 0x24, 0x9e, 0x13,
	/* ch = '_' */
	0x42, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x22,
	0x26, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x16,
	/* ch = '`' */
	0x7f, 0x70, 0x00, 0x00,
	0x3b, 0xf7, 0x17, 0x00,
	0x0d, 0xf7, 0xc4, 0x10,
	0x00, 0x50, 0xff, 0x4d,
	0x00, 0x00, 0x12, 0x04,
	/* ch = 'a' */
	0x00, 0x00, 0x08, 0x2a, 0x36, 0x25, 0x04, 0x00,
	0x00, 0x36, 0xf7, 0xdd, 0x8f, 0xef, 0xd4, 0x10,
	0x00, 0x1f, 0x35, 0x00, 0x00, 0x10, 0xe5, 0x70,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa0, 0xb7,
	0x00, 0x08, 0x50, 0xab, 0xcf, 0xcf, 0xef, 0xb7,
	0x0d, 0xd4, 0xc4, 0x25, 0x15, 0x15, 0x88, 0xb7,
	0x3b, 0xff, 0x24, 0x00, 0x00, 0x00, 0xb7, 0xb7,
	0x32, 0xff, 0x3f, 0x00, 0x04, 0x5f, 0xff, 0xb7,
	0x00, 0x73, 0xff, 0xd4, 0xef, 0xb3, 0xa5, 0xb7,
	0x00, 0x00, 0x0c, 0x15, 0x0c, 0x00, 0x00, 0x00,
	/* ch = 'b' */
	0x32, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x32, 0x16, 0x36, 0x2a, 0x04, 0x00, 0x00,
	0x32, 0xff, 0xa9, 0xef, 0xcf, 0xff, 0xdb, 0x16, 0x00,
	0x32, 0xff, 0xb7, 0x08, 0x00, 0x21, 0xff, 0xa0, 0x00,
	0x32, 0xff, 0x4d, 0x00, 0x00, 0x00, 0x7c, 0xff, 0x14,
	0x32, 0xff, 0x32, 0x00, 0x00, 0x00, 0x50, 0xff, 0x1c,
	0x32, 0xff, 0x35, 0x00, 0x00, 0x00, 0x50, 0xff, 0x1c,
	0x32, 0xff, 0x54, 0x00, 0x00, 0x00, 0x8a, 0xf7, 0x04,
	0x32, 0xff, 0xdb, 0x1b, 0x04, 0x3f, 0xff, 0x6b, 0x00,
	0x32, 0xff, 0x5b, 0xf7, 0xff, 0xff, 0x84, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x08, 0x15, 0x0c, 0x00, 0x00, 0x00,
	/* ch = 'c' */
	0x00, 0x00, 0x0f, 0x36, 0x36, 0x0f, 0x00, 0x00,
	0x04, 0x94, 0xff, 0xd4, 0xdd, 0xff, 0x66, 0x00,
	0x77, 0xf7, 0x21, 0x00, 0x00, 0x3f, 0xb1, 0x04,
	0xff, 0x5f, 0x00, 0x00, 0x00, 0x04, 0x08, 0x00,
	0xff, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0x3b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xf7, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xff, 0x5f, 0x08, 0x08, 0x5a, 0xa0, 0x04,
	0x00, 0x50, 0xf7, 0xff, 0xff, 0xef, 0x35, 0x00,
	0x00, 0x00, 0x04, 0x15, 0x15, 0x00, 0x00, 0x00,
	/* ch = 'd' */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xcf,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xb7,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xb7,
	0x00, 0x00, 0x0c, 0x36, 0x36, 0x16, 0x7c, 0xb7,
	0x00, 0x32, 0xf7, 0xcb, 0x9e, 0xff, 0xdb, 0xb7,
	0x0d, 0xf7, 0x7c, 0x00, 0x00, 0x26, 0xff, 0xb7,
	0x3b, 0xff, 0x1f, 0x00, 0x00, 0x00, 0xbd, 0xb7,
	0x50, 0xff, 0x0d, 0x00, 0x00, 0x00, 0xb7, 0xb7,
	0x50, 0xff, 0x1c, 0x00, 0x00, 0x00, 0xb7, 0xb7,
	0x2f, 0xff, 0x3b, 0x00, 0x00, 0x04, 0xe5, 0xb7,
	0x04, 0xdb, 0xdb, 0x1b, 0x08, 0x6b, 0xff, 0xb7,
	0x00, 0x1f, 0xd4, 0xff, 0xff, 0xa9, 0x97, 0xcf,
	0x00, 0x00, 0x00, 0x12, 0x0f, 0x00, 0x00, 0x00,
	/* ch = 'e' */
	0x00, 0x00, 0x04, 0x2a, 0x36, 0x25, 0x04, 0x00,
	0x00, 0x1f, 0xdb, 0xd4, 0x74, 0xef, 0xc4, 0x10,
	0x00, 0xc8, 0xb1, 0x04, 0x00, 0x10, 0xe5, 0x70,
	0x2a, 0xff, 0x32, 0x00, 0x00, 0x00, 0x7c, 0xcf,
	0x44, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x44, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x24, 0xff, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xa0, 0xf7, 0x24, 0x00, 0x04, 0x66, 0x35,
	0x00, 0x10, 0x94, 0xff, 0xe5, 0xff, 0xcb, 0x1f,
	0x00, 0x00, 0x00, 0x08, 0x15, 0x0f, 0x00, 0x00,
	/* ch = 'f' */
	0x00, 0x1f, 0xc4, 0xff, 0xff, 0xb3, 0x19,
	0x0d, 0xdb, 0x90, 0x08, 0x0c, 0x99, 0x48,
	0x32, 0xff, 0x24, 0x00, 0x00, 0x08, 0x04,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0xdd, 0xff, 0xd4, 0xcf, 0x95, 0x00, 0x00,
	0x3e, 0xff, 0x28, 0x15, 0x12, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00,
	/* ch = 'g' */
	0x00, 0x00, 0x16, 0x36, 0x36, 0x13, 0x16, 0x36, 0x19,
	0x00, 0x44, 0xff, 0x8f, 0xa4, 0xf7, 0xf7, 0x8f, 0x30,
	0x0d, 0xf7, 0x54, 0x00, 0x00, 0x82, 0xc8, 0x00, 0x00,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x50, 0xff, 0x00, 0x00,
	0x04, 0xe5, 0x90, 0x04, 0x10, 0xb7, 0xa0, 0x00, 0x00,
	0x00, 0x31, 0xff, 0xef, 0xf7, 0xbb, 0x10, 0x00, 0x00,
	0x00, 0x99, 0x75, 0x15, 0x12, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xe5, 0xc4, 0x3e, 0x36, 0x36, 0x25, 0x04, 0x00,
	0x00, 0x6d, 0xbb, 0x74, 0x74, 0x8f, 0xf7, 0xb1, 0x00,
	0x44, 0xe5, 0x04, 0x00, 0x00, 0x00, 0x3b, 0xff, 0x1c,
	0x6b, 0xff, 0x28, 0x00, 0x00, 0x0c, 0x90, 0xdb, 0x04,
	0x08, 0x7f, 0xf7, 0xff, 0xef, 0xff, 0x9e, 0x19, 0x00,
	/* ch = 'h' */
	0xff, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0x50, 0x04, 0x30, 0x36, 0x0c, 0x00,
	0xff, 0x82, 0xdb, 0xd4, 0xef, 0xf7, 0x1f,
	0xff, 0xff, 0x35, 0x00, 0x17, 0xff, 0x77,
	0xff, 0x82, 0x00, 0x00, 0x00, 0xb7, 0xb7,
	0xff, 0x54, 0x00, 0x00, 0x00, 0xb7, 0xb7,
	0xff, 0x50, 0x00, 0x00, 0x00, 0xb7, 0xb7,
	0xff, 0x50, 0x00, 0x00, 0x00, 0xb7, 0xb7,
	0xff, 0x50, 0x00, 0x00, 0x00, 0xb7, 0xb7,
	0xff, 0x50, 0x00, 0x00, 0x00, 0xb7, 0xb7,
	/* ch = 'i' */
	0x00, 0x00, 0x39, 0xcf, 0x24, 0x00, 0x00,
	0x00, 0x00, 0x60, 0xff, 0x3e, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0c, 0x15, 0x15, 0x15, 0x04, 0x00, 0x00,
	0x45, 0xcf, 0xe5, 0xff, 0x1c, 0x00, 0x00,
	0x00, 0x00, 0x50, 0xff, 0x1c, 0x00, 0x00,
	0x00, 0x00, 0x50, 0xff, 0x1c, 0x00, 0x00,
	0x00, 0x00, 0x50, 0xff, 0x1c, 0x00, 0x00,
	0x00, 0x00, 0x50, 0xff, 0x1c, 0x00, 0x00,
	0x00, 0x00, 0x50, 0xff, 0x1c, 0x00, 0x00,
	0x00, 0x00, 0x50, 0xff, 0x1c, 0x00, 0x00,
	0x50, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1c,
	/* ch = 'j' */
	0x00, 0x00, 0x00, 0x00, 0x0d, 0xab, 0x60,
	0x00, 0x00, 0x00, 0x00, 0x17, 0xf7, 0xa0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x15, 0x15, 0x15, 0x15, 0x0f,
	0x00, 0x00, 0xcf, 0xcf, 0xcf, 0xff, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x7c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x7c,
	0x00, 0x0c, 0x00, 0x00, 0x0d, 0xff, 0x5f,
	0x1a, 0xef, 0x24, 0x04, 0x7c, 0xff, 0x2a,
	0x10, 0xb3, 0xff, 0xff, 0xef, 0x3b, 0x00,
	0x00, 0x00, 0x08, 0x0f, 0x00, 0x00, 0x00,
	/* ch = 'k' */
	0x1c, 0xff, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x50, 0x00, 0x00, 0x00, 0x12, 0x15, 0x00,
	0x1c, 0xff, 0x50, 0x00, 0x00, 0x5f, 0xf7, 0x35, 0x00,
	0x1c, 0xff, 0x50, 0x00, 0x6b, 0xf7, 0x2c, 0x00, 0x00,
	0x1c, 0xff, 0x54, 0x7c, 0xf7, 0x26, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0xf7, 0xff, 0xdb, 0x04, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0xc4, 0x35, 0xff, 0x7c, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x50, 0x00, 0x50, 0xff, 0x50, 0x00, 0x00,
	0x1c, 0xff, 0x50, 0x00, 0x00, 0x7c, 0xff, 0x32, 0x00,
	0x1c, 0xff, 0x50, 0x00, 0x00, 0x04, 0xb1, 0xf7, 0x21,
	/* ch = 'l' */
	0xb7, 0xff, 0xff, 0xff, 0x1c, 0x00, 0x00,
	0x00, 0x00, 0x50, 0xff, 0x1c, 0x00, 0x00,
	0x00, 0x00, 0x50, 0xff, 0x1c, 0x00, 0x00,
	0x00, 0x00, 0x50, 0xff, 0x1c, 0x00, 0x00,
	0x00, 0x00, 0x50, 0xff, 0x1c, 0x00, 0x00,
	0x00, 0x00, 0x50, 0xff, 0x1c, 0x00, 0x00,
	0x00, 0x00, 0x50, 0xff, 0x1c, 0x00, 0x00,
	0x00, 0x00, 0x50, 0xff, 0x1c, 0x00, 0x00,
	0x00, 0x00, 0x50, 0xff, 0x1c, 0x00, 0x00,
	0x00, 0x00, 0x50, 0xff, 0x1c, 0x00, 0x00,
	0x00, 0x00, 0x50, 0xff, 0x1c, 0x00, 0x00,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50,
	/* ch = 'm' */
	0x0f, 0x12, 0x1e, 0x36, 0x13, 0x13, 0x36, 0x22, 0x00,
	0x7c, 0xf7, 0xc4, 0xdb, 0xdb, 0xef, 0xab, 0xff, 0x27,
	0x7c, 0xff, 0x10, 0x3b, 0xff, 0x3b, 0x1c, 0xff, 0x50,
	0x7c, 0xb7, 0x00, 0x32, 0xff, 0x1c, 0x1c, 0xff, 0x50,
	0x7c, 0xb7, 0x00, 0x32, 0xff, 0x1c, 0x1c, 0xff, 0x50,
	0x7c, 0xb7, 0x00, 0x32, 0xff, 0x1c, 0x1c, 0xff, 0x50,
	0x7c, 0xb7, 0x00, 0x32, 0xff, 0x1c, 0x1c, 0xff, 0x50,
	0x7c, 0xb7, 0x00, 0x32, 0xff, 0x1c, 0x1c, 0xff, 0x50,
	0x7c, 0xb7, 0x00, 0x32, 0xff, 0x1c, 0x1c, 0xff, 0x50,
	/* ch = 'n' */
	0x04, 0x15, 0x0c, 0x08, 0x30, 0x36, 0x0c, 0x00,
	0x1c, 0xff, 0x82, 0xdb, 0xd4, 0xef, 0xef, 0x1c,
	0x1c, 0xff, 0xff, 0x35, 0x00, 0x1a, 0xff, 0x6b,
	0x1c, 0xff, 0x7c, 0x00, 0x00, 0x00, 0xb7, 0x90,
	0x1c, 0xff, 0x50, 0x00, 0x00, 0x00, 0xb7, 0xb7,
	0x1c, 0xff, 0x50, 0x00, 0x00, 0x00, 0xb7, 0xb7,
	0x1c, 0xff, 0x50, 0x00, 0x00, 0x00, 0xb7, 0xb7,
	0x1c, 0xff, 0x50, 0x00, 0x00, 0x00, 0xb7, 0xb7,
	0x1c, 0xff, 0x50, 0x00, 0x00, 0x00, 0xb7, 0xb7,
	/* ch = 'o' */
	0x00, 0x00, 0x04, 0x25, 0x36, 0x25, 0x00, 0x00, 0x00,
	0x00, 0x1f, 0xd4, 0xef, 0xcf, 0xf7, 0xbb, 0x10, 0x00,
	0x04, 0xdb, 0xb1, 0x08, 0x00, 0x1f, 0xf7, 0x8a, 0x00,
	0x39, 0xff, 0x32, 0x00, 0x00, 0x00, 0x64, 0xff, 0x14,
	0x54, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x35, 0xff, 0x24,
	0x54, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x35, 0xff, 0x24,
	0x32, 0xff, 0x48, 0x00, 0x00, 0x00, 0x70, 0xf7, 0x0d,
	0x04, 0xb1, 0xf7, 0x21, 0x00, 0x35, 0xff, 0x6b, 0x00,
	0x00, 0x10, 0xa2, 0xff, 0xff, 0xff, 0x73, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x0f, 0x15, 0x0c, 0x00, 0x00, 0x00,
	/* ch = 'p' */
	0x08, 0x15, 0x08, 0x16, 0x36, 0x2a, 0x08, 0x00, 0x00,
	0x32, 0xff, 0xa9, 0xef, 0xcf, 0xf7, 0xdb, 0x1f, 0x00,
	0x32, 0xff, 0xb7, 0x08, 0x00, 0x1f, 0xf7, 0xb7, 0x00,
	0x32, 0xff, 0x4d, 0x00, 0x00, 0x00, 0x5f, 0xff, 0x1c,
	0x32, 0xff, 0x32, 0x00, 0x00, 0x00, 0x35, 0xff, 0x32,
	0x32, 0xff, 0x32, 0x00, 0x00, 0x00, 0x35, 0xff, 0x2f,
	0x32, 0xff, 0x54, 0x00, 0x00, 0x00, 0x70, 0xff, 0x14,
	0x32, 0xff, 0xdb, 0x1b, 0x00, 0x31, 0xf7, 0x77, 0x00,
	0x32, 0xff, 0x8a, 0xf7, 0xff, 0xff, 0x94, 0x08, 0x00,
	0x1c, 0xff, 0x32, 0x08, 0x15, 0x0f, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0xff, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	/* ch = 'q' */
	0x00, 0x00, 0x0c, 0x30, 0x36, 0x16, 0x0f, 0x15,
	0x00, 0x2c, 0xf7, 0xcb, 0x8f, 0xf7, 0xdb, 0xff,
	0x0d, 0xf7, 0x82, 0x00, 0x00, 0x26, 0xff, 0xff,
	0x3b, 0xff, 0x24, 0x00, 0x00, 0x00, 0xb1, 0xff,
	0x50, 0xff, 0x0d, 0x00, 0x00, 0x00, 0x7c, 0xff,
	0x50, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x82, 0xff,
	0x32, 0xff, 0x3f, 0x00, 0x00, 0x04, 0xcf, 0xff,
	0x04, 0xc8, 0xdb, 0x21, 0x04, 0x5f, 0xff, 0xff,
	0x00, 0x19, 0xcb, 0xff, 0xff, 0xbb, 0x97, 0xff,
	0x00, 0x00, 0x00, 0x12, 0x0f, 0x00, 0x7c, 0xff,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xff,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0xff,
	/* ch = 'r' */
	0x0c, 0x15, 0x04, 0x16, 0x36, 0x30, 0x0c, 0x00,
	0x50, 0xff, 0x99, 0xff, 0xcf, 0xe5, 0xf7, 0x11,
	0x50, 0xff, 0xf7, 0x21, 0x00, 0x04, 0x73, 0x00,
	0x50, 0xff, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x50, 0xff, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00,
	/* ch = 's' */
	0x00, 0x00, 0x04, 0x2a, 0x36, 0x2a, 0x08, 0x00,
	0x00, 0x1f, 0xef, 0xcb, 0x74, 0xd4, 0xf7, 0x3b,
	0x00, 0x90, 0xcf, 0x04, 0x00, 0x04, 0x7c, 0x35,
	0x00, 0x6b, 0xff, 0x3f, 0x08, 0x00, 0x00, 0x00,
	0x00, 0x08, 0x8d, 0xff, 0xff, 0x9e, 0x2b, 0x00,
	0x00, 0x00, 0x00, 0x0c, 0x37, 0xbb, 0xff, 0x50,
	0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0xbd, 0xc8,
	0x17, 0xf7, 0x5a, 0x08, 0x00, 0x1b, 0xe5, 0x8a,
	0x00, 0x48, 0xe5, 0xff, 0xff, 0xff, 0x94, 0x10,
	0x00, 0x00, 0x00, 0x12, 0x15, 0x08, 0x00, 0x00,
	/* ch = 't' */
	0x00, 0x00, 0x50, 0x4a, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xff, 0x77, 0x00, 0x00, 0x00,
	0x15, 0x1a, 0xff, 0x5e, 0x15, 0x15, 0x04,
	0xcf, 0xd4, 0xff, 0xe5, 0xcf, 0xcf, 0x1a,
	0x00, 0x1c, 0xff, 0x44, 0x00, 0x00, 0x00,
	0x00, 0x2a, 0xff, 0x32, 0x00, 0x00, 0x00,
	0x00, 0x32, 0xff, 0x32, 0x00, 0x00, 0x00,
	0x00, 0x32, 0xff, 0x32, 0x00, 0x00, 0x00,
	0x00, 0x32, 0xff, 0x35, 0x00, 0x00, 0x00,
	0x00, 0x1c, 0xff, 0x9e, 0x0c, 0x2b, 0x6c,
	0x00, 0x00, 0x77, 0xff, 0xff, 0xf7, 0x5b,
	0x00, 0x00, 0x00, 0x0c, 0x15, 0x00, 0x00,
	/* ch = 'u' */
	0x04, 0x15, 0x0c, 0x00, 0x00, 0x00, 0x12, 0x12,
	0x1c, 0xff, 0x50, 0x00, 0x00, 0x00, 0xb7, 0xb7,
	0x1c, 0xff, 0x50, 0x00, 0x00, 0x00, 0xb7, 0xb7,
	0x1c, 0xff, 0x50, 0x00, 0x00, 0x00, 0xb7, 0xb7,
	0x1c, 0xff, 0x50, 0x00, 0x00, 0x00, 0xb7, 0xb7,
	0x1c, 0xff, 0x50, 0x00, 0x00, 0x00, 0xb7, 0xb7,
	0x1c, 0xff, 0x54, 0x00, 0x00, 0x04, 0xe5, 0xb7,
	0x00, 0xc8, 0xdb, 0x13, 0x04, 0x70, 0xff, 0xb7,
	0x00, 0x1f, 0xd4, 0xff, 0xef, 0xa2, 0xcf, 0xbd,
	0x00, 0x00, 0x00, 0x15, 0x12, 0x00, 0x00, 0x00,
	/* ch = 'v' */
	0x0f, 0x15, 0x08, 0x00, 0x00, 0x00, 0x08, 0x15, 0x04,
	0x32, 0xff, 0x39, 0x00, 0x00, 0x00, 0x44, 0xf7, 0x04,
	0x04, 0xe5, 0x8a, 0x00, 0x00, 0x00, 0x90, 0x8a, 0x00,
	0x00, 0x5a, 0xff, 0x17, 0x00, 0x17, 0xff, 0x32, 0x00,
	0x00, 0x17, 0xff, 0x5a, 0x00, 0x5a, 0xe5, 0x04, 0x00,
	0x00, 0x00, 0xa0, 0xe5, 0x04, 0xe5, 0x5a, 0x00, 0x00,
	0x00, 0x00, 0x39, 0xff, 0x7c, 0xf7, 0x10, 0x00, 0x00,
	0x00, 0x00, 0x04, 0xe5, 0xff, 0x70, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x5f, 0xff, 0x22, 0x00, 0x00, 0x00,
	/* ch = 'w' */
	0x15, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0f,
	0xcf, 0x5f, 0x00, 0x10, 0x36, 0x00, 0x00, 0xb7, 0x54,
	0x82, 0xa0, 0x00, 0x3b, 0xff, 0x24, 0x00, 0xff, 0x3b,
	0x54, 0xf7, 0x00, 0x77, 0xff, 0x5f, 0x0d, 0xff, 0x2a,
	0x2f, 0xff, 0x1c, 0xcf, 0xc8, 0xb7, 0x1f, 0xff, 0x14,
	0x14, 0xff, 0x48, 0xff, 0x32, 0xff, 0x4c, 0xe5, 0x00,
	0x00, 0xcf, 0xcf, 0xa0, 0x04, 0xf7, 0xe5, 0xa0, 0x00,
	0x00, 0x82, 0xff, 0x50, 0x00, 0x7c, 0xff, 0x5f, 0x00,
	0x00, 0x4d, 0xff, 0x24, 0x00, 0x3b, 0xff, 0x3b, 0x00,
	/* ch = 'x' */
	0x1c, 0x15, 0x08, 0x00, 0x00, 0x00, 0x12, 0x12, 0x00,
	0x04, 0xdb, 0xb1, 0x04, 0x00, 0x2f, 0xff, 0x35, 0x00,
	0x00, 0x1f, 0xff, 0x54, 0x0d, 0xdb, 0x82, 0x00, 0x00,
	0x00, 0x00, 0x50, 0xff, 0xa9, 0xe5, 0x10, 0x00, 0x00,
	0x00, 0x00, 0x04, 0xb7, 0xff, 0x37, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x10, 0xf7, 0xff, 0x7c, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xa0, 0xdb, 0x43, 0xff, 0x3b, 0x00, 0x00,
	0x00, 0x44, 0xff, 0x32, 0x00, 0x7c, 0xf7, 0x1c, 0x00,
	0x1f, 0xf7, 0x7c, 0x00, 0x00, 0x0d, 0xdb, 0xb1, 0x04,
	/* ch = 'y' */
	0x0c, 0x15, 0x0c, 0x00, 0x00, 0x00, 0x08, 0x15, 0x08,
	0x22, 0xff, 0x48, 0x00, 0x00, 0x00, 0x54, 0xff, 0x14,
	0x00, 0xa7, 0xc8, 0x00, 0x00, 0x00, 0xa7, 0xa0, 0x00,
	0x00, 0x39, 0xff, 0x2c, 0x00, 0x1c, 0xff, 0x39, 0x00,
	0x00, 0x04, 0xe5, 0x70, 0x00, 0x5a, 0xf7, 0x04, 0x00,
	0x00, 0x00, 0x6b, 0xf7, 0x0d, 0xc8, 0x70, 0x00, 0x00,
	0x00, 0x00, 0x22, 0xff, 0x7c, 0xff, 0x2a, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xa7, 0xff, 0xc8, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x39, 0xff, 0x50, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x3b, 0xff, 0x17, 0x00, 0x00, 0x00,
	0x39, 0x26, 0x13, 0xdb, 0x8a, 0x00, 0x00, 0x00, 0x00,
	0x97, 0xff, 0xff, 0xbb, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	/* ch = 'z' */
	0x00, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x0f, 0x00,
	0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x77, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x04, 0xb1, 0xdb, 0x10, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7c, 0xf7, 0x1f, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x50, 0xff, 0x32, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x32, 0xff, 0x5f, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x1f, 0xf7, 0xb1, 0x04, 0x00, 0x00, 0x00, 0x00,
	0x04, 0xdb, 0xec, 0x1f, 0x15, 0x15, 0x15, 0x15, 0x04,
	0x4d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1c,
	/* ch = '{' */
	0x00, 0x00, 0x20, 0x36, 0x36, 0x16,
	0x00, 0x7c, 0xf7, 0x82, 0x74, 0x22,
	0x2a, 0xff, 0x39, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00,
	0x32, 0xff, 0x1c, 0x00, 0x00, 0x00,
	0x3b, 0xff, 0x1a, 0x00, 0x00, 0x00,
	0xb1, 0x99, 0x00, 0x00, 0x00, 0x00,
	0xd9, 0x16, 0x00, 0x00, 0x00, 0x00,
	0x90, 0xc8, 0x00, 0x00, 0x00, 0x00,
	0x44, 0xff, 0x1a, 0x00, 0x00, 0x00,
	0x4d, 0xff, 0x1c, 0x00, 0x00, 0x00,
	0x50, 0xff, 0x1c, 0x00, 0x00, 0x00,
	0x3b, 0xff, 0x24, 0x00, 0x00, 0x00,
	0x17, 0xf7, 0xb1, 0x1a, 0x15, 0x08,
	0x00, 0x26, 0xab, 0xcf, 0xcf, 0x2d,
	/* ch = '|' */
	0x45, 0xcf, 0x1a,
	0x50, 0xff, 0x1c,
	0x50, 0xff, 0x1c,
	0x50, 0xff, 0x1c,
	0x50, 0xff, 0x1c,
	0x50, 0xff, 0x1c,
	0x50, 0xff, 0x1c,
	0x50, 0xff, 0x1c,
	0x50, 0xff, 0x1c,
	0x50, 0xff, 0x1c,
	0x50, 0xff, 0x1c,
	0x50, 0xff, 0x1c,
	0x50, 0xff, 0x1c,
	0x50, 0xff, 0x1c,
	0x45, 0xcf, 0x1a,
	/* ch = '}' */
	0x26, 0x36, 0x36, 0x16, 0x00,
	0x42, 0x74, 0xa4, 0xff, 0x39,
	0x00, 0x00, 0x00, 0x8a, 0xe5,
	0x00, 0x00, 0x00, 0x50, 0xff,
	0x00, 0x00, 0x00, 0x50, 0xff,
	0x00, 0x00, 0x00, 0x4d, 0xff,
	0x00, 0x00, 0x00, 0x10, 0xef,
	0x00, 0x00, 0x00, 0x00, 0x36,
	0x00, 0x00, 0x00, 0x1c, 0xff,
	0x00, 0x00, 0x00, 0x4d, 0xff,
	0x00, 0x00, 0x00, 0x50, 0xff,
	0x00, 0x00, 0x00, 0x50, 0xff,
	0x00, 0x00, 0x00, 0x5f, 0xff,
	0x0f, 0x15, 0x2b, 0xf7, 0xa0,
	0x67, 0xcf, 0xcf, 0x7f, 0x10,
	/* ch = '~' */
	0x00, 0x04, 0x2a, 0x2a, 0x04, 0x00, 0x00, 0x0c, 0x00,
	0x10, 0xc4, 0xe5, 0xef, 0xd4, 0x24, 0x21, 0xf7, 0x33,
	0x29, 0x9c, 0x08, 0x08, 0x94, 0xff, 0xff, 0x66, 0x04,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0c, 0x00, 0x00
};

static const unsigned char *font_bitmap[SIZE_TOTAL] = {
	font_bitmap_12px_bytes,
	font_bitmap_13px_bytes,
	font_bitmap_14px_bytes,
	font_bitmap_15px_bytes,
	font_bitmap_16px_bytes,
	font_bitmap_17px_bytes,
	font_bitmap_18px_bytes
};

int FontInconsolata_GetBitmap(LCUI_FontBitmap *bmp, wchar_t ch, int size)
{
	int i, j, *ptr;
	const uchar_t *byte_ptr;

	if (size < 12) {
		return -1;
	}
	/* 不在范围内的字符都用框框表示 */
	if (ch < ' ' || ch > '~' || size > 18) {
		bmp->advance.x = (int)(size / 2.0 + 0.5);
		bmp->advance.y = size;
		bmp->rows = size;
		bmp->width = bmp->advance.x;
		bmp->buffer = calloc(bmp->rows * bmp->width, 1);
		bmp->pitch = bmp->width;
		bmp->pixel_mode = 0;
		bmp->top = size * 4 / 5;
		bmp->left = 0;
		j = (bmp->rows - 1) * bmp->width;
		for (i = 0; i < bmp->width; ++i, ++j) {
			bmp->buffer[i] = 255;
			bmp->buffer[j] = 255;
		}
		i = 0;
		j = bmp->width - 1;
		size = bmp->width * bmp->rows;
		while (i < size) {
			bmp->buffer[i] = 255;
			bmp->buffer[j] = 255;
			i += bmp->width;
			j += bmp->width;
		}
		return -2;
	}
	/* 空格就直接填充空白 */
	if (ch == ' ') {
		bmp->advance.x = (int)(size / 2.0 + 0.5);
		bmp->advance.y = size;
		bmp->rows = size;
		bmp->width = bmp->advance.x;
		bmp->buffer = calloc(bmp->rows*bmp->width, 1);
		bmp->pitch = bmp->width;
		bmp->pixel_mode = 0;
		bmp->top = 0;
		bmp->left = 0;
		return 0;
	}
	i = size - 12;
	j = ch - ' ';
	*bmp = font_info_index[i][j];
	j = *(ptr = (int*)&bmp->buffer);
	byte_ptr = &font_bitmap[i][j];
	size = sizeof(unsigned char)*bmp->width*bmp->rows;
	bmp->buffer = (uchar_t*)malloc(size);
	memcpy(bmp->buffer, byte_ptr, size);
	return 0;
}
