/* 
 * linux_display.c -- The display support for linux.
 *
 * Copyright (c) 2018, Liu chao <lc-soft@live.cn> All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *   * Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 *   * Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *   * Neither the name of LCUI nor the names of its contributors may be used
 *     to endorse or promote products derived from this software without
 *     specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include <LCUI_Build.h>
#ifdef LCUI_BUILD_IN_LINUX
#include <LCUI/LCUI.h>
#include <LCUI/display.h>
#include <LCUI/platform.h>
#include LCUI_EVENTS_H
#include LCUI_DISPLAY_H

static enum DisplayDriver {
	NONE,
	FRAMEBUFFER,
	X11
} driver_type;

LCUI_DisplayDriver LCUI_CreateLinuxDisplayDriver(void)
{
	LCUI_DisplayDriver driver = NULL;
#ifdef LCUI_VIDEO_DRIVER_X11
	driver_type = X11;
	driver = LCUI_CreateLinuxX11DisplayDriver();
#endif
#ifdef LCUI_VIDEO_DRIVER_FRAMEBUFFER
	if (!driver) {
		driver_type = FRAMEBUFFER;
		driver = LCUI_CreateLinuxFBDisplayDriver();
	}
#endif
	return driver;
}

void LCUI_DestroyLinuxDisplayDriver(LCUI_DisplayDriver driver)
{
	switch (driver_type) {
#ifdef LCUI_VIDEO_DRIVER_X11
	case X11:
		LCUI_DestroyLinuxX11DisplayDriver(driver);
		break;
#endif
#ifdef LCUI_VIDEO_DRIVER_FRAMEBUFFER
	case FRAMEBUFFER:
		LCUI_DestroyLinuxFBDisplayDriver(driver);
		break;
#endif
	default:
		break;
	}
}
#endif
