﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;

namespace SmokeRegex.Client.Dialog
{
    /// <summary>
    /// IWindow接口
    /// </summary>
    public interface IWindow
    {
        Window Owner { get; set; }

        /// <summary>
        /// 标题
        /// </summary>
        string Title { get; set; }

        /// <summary>
        /// 打开窗口
        /// </summary>
        void Show();

        /// <summary>
        /// 打开模式窗口
        /// </summary>
        /// <returns></returns>
        bool? ShowDialog();

        /// <summary>
        /// 关闭窗口
        /// </summary>
        void Close();

        /// <summary>
        /// 激活窗口
        /// </summary>
        bool Activate();

        /// <summary>
        /// 数据上下文
        /// </summary>
        object DataContext { get; set; }
    }
}
