﻿using Microsoft.Practices.Prism.Commands;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;

namespace SmokeRegex.Client.ViewModels
{
    public class HelpViewModel : Base.WindowViewModelBase
    {
        public HelpViewModel()
            : base(Consts.WindowNames.Help)
        {

        }

        private string _content;

        /// <summary>
        /// 显示的内容
        /// </summary>
        public string Content
        {
            get
            {
                return _content;
            }
            set
            {
                if (_content != value)
                {
                    _content = value;
                    this.RaisePropertyChanged("Content");
                }
            }
        }

        private DelegateCommand<string> _openCommand;

        /// <summary>
        /// 打开窗口命令
        /// 参数表示要显示的文档
        /// </summary>
        public DelegateCommand<string> OpenCommand
        {
            get
            {
                if (_openCommand == null)
                {
                    _openCommand = new DelegateCommand<string>(this.Open);
                }
                return _openCommand;
            }
        }

        private void Open(string parameter)
        {
            try
            {
                //这里暂时采用硬编码
                switch (parameter)
                {
                    case "1":
                        this.Title = "正则基础语法";
                        break;
                    case "2":
                        this.Title = "JS中正则使用";
                        break;

                    case "3":
                        this.Title = "JS常用正则表达式";
                        break;
                }

                string filePath = string.Format(@"{1}\Content\{0}.txt", parameter, System.Environment.CurrentDirectory);
                using (var reader = new StreamReader(filePath))
                {
                    this.Content = reader.ReadToEnd();
                }

                this.ShowDialog();
            }
            catch
            {
 
            }
        }

    }
}
