﻿using Microsoft.Practices.Prism.Commands;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace SmokeRegex.Client.ViewModels
{
    public class ReplaceViewModel : Base.WindowViewModelBase
    {
        public ReplaceViewModel()
            : base(Consts.WindowNames.Replace)
        {
            this.ReplaceString = string.Empty;
        }

        private string _replaceString;

        /// <summary>
        /// 输入的要替换的文本
        /// </summary>
        public string ReplaceString
        {
            get
            {
                return _replaceString;
            }
            set
            {
                if (_replaceString != value)
                {
                    _replaceString = value;
                    this.RaisePropertyChanged("ReplaceString");
                }
            }
        }

        private DelegateCommand _submitCommand;

        public DelegateCommand SubmitCommand
        {
            get
            {
                if (_submitCommand == null)
                {
                    _submitCommand = new DelegateCommand(this.Submit);
                }
                return _submitCommand;
            }
        }

        private void Submit()
        {
            var e = new Events.ReplaceEvent(this.ReplaceString ?? string.Empty);
            this.PublishEvent(e);
            this.ReplaceString = string.Empty;
            this.Close();
        }
    }
}
