﻿/**
 * dialog - jQuery jwwUI Copyright (c) 2013-2015 www.jeeww.com. All rights reserved. 
 * Licensed under the GPL or commercial licenses 
 */
(function($) {
	function createContentPanel(target) {
		var cp = document.createElement("div");
		while (target.firstChild) {
			cp.appendChild(target.firstChild);
		}
		target.appendChild(cp);
		var contentPanel = $(cp);
		contentPanel.attr("style", $(target).attr("style"));
		$(target).removeAttr("style").css("overflow", "hidden");
		contentPanel.panel({ border : false, doSize : false, bodyCls : "dialog-content" });
		return contentPanel;
	}
	;
	function create(target) {
		var defs = $.data(target, "dialog").defs;
		var contentPanel = $.data(target, "dialog").contentPanel;
		if (defs.toolbar) {
			if (typeof defs.toolbar == "string") {
				$(defs.toolbar).addClass("dialog-toolbar").prependTo(target);
				$(defs.toolbar).show();
			} else {
				$(target).find("div.dialog-toolbar").remove();
				var newDialogHtmlObj = $(
				        "<div class=\"dialog-toolbar\"><table cellspacing=\"0\" cellpadding=\"0\"><tr></tr></table></div>")
				        .prependTo(target);
				var tr = newDialogHtmlObj.find("tr");
				for ( var i = 0; i < defs.toolbar.length; i++) {
					var toolbar = defs.toolbar[i];
					if (toolbar == "-") {
						$("<td><div class=\"dialog-tool-separator\"></div></td>").appendTo(tr);
					} else {
						var td = $("<td></td>").appendTo(tr);
						var toolbarTd = $("<a href=\"javascript:void(0)\"></a>").appendTo(td);
						toolbarTd[0].onclick = $.parser.localEval(toolbar.handler || function() {
						});
						toolbarTd.button($.extend({}, toolbar, { plain : true }));
					}
				}
			}
		} else {
			$(target).find("div.dialog-toolbar").remove();
		}
		if (defs.buttons) {
			if (typeof defs.buttons == "string") {
				$(defs.buttons).addClass("dialog-button").appendTo(target);
				$(defs.buttons).show();
			} else {
				$(target).find("div.dialog-button").remove();
				var newDialogAddedButton = $("<div class=\"dialog-button\"></div>").appendTo(target);
				for ( var i = 0; i < defs.buttons.length; i++) {
					var p = defs.buttons[i];
					var newDialogAddedButtonEvent = $("<a href=\"javascript:void(0)\"></a>").appendTo(
					        newDialogAddedButton);
					if (p.handler) {
						newDialogAddedButtonEvent[0].onclick = p.handler;
					}
					newDialogAddedButtonEvent.button(p);
				}
			}
		} else {
			$(target).find("div.dialog-button").remove();
		}
		var href = defs.href;
		var content = defs.content;
		defs.href = null;
		defs.content = null;
		contentPanel.panel({ closed : defs.closed, cache : defs.cache, href : href, content : content,
		    onLoad : function() {
			    if (defs.height == "auto") {
				    $(target).window("resize");
			    }
			    defs.onLoad.apply(target, arguments);
		    } });
		$(target).window(
		        $.extend({}, defs, {
		            onOpen : function() {
			            if (contentPanel.panel("defs").closed) {
				            contentPanel.panel("open");
			            }
			            if (defs.onOpen) {
				            defs.onOpen.call(target);
			            }
		            },
		            onResize : function(position, height) {
			            var targetObj = $(target);
			            contentPanel.panel("panel").show();
			            contentPanel.panel("resize", {
			                width : targetObj.width(),
			                height : (height == "auto") ? "auto" : targetObj.height()
			                        - targetObj.children("div.dialog-toolbar")._outerHeight()
			                        - targetObj.children("div.dialog-button")._outerHeight() });
			            if (defs.onResize) {
				            defs.onResize.call(target, position, height);
			            }
		            } }));
		defs.href = href;
		defs.content = content;
	}
	;
	function refresh(target, url) {
		var contentPanel = $.data(target, "dialog").contentPanel;
		contentPanel.panel("refresh", url);
	}
	;
	$.fn.dialog = function(defs, param) {
		if (typeof defs == "string") {
			var methodFun = $.fn.dialog.methods[defs];
			if (methodFun) {
				return methodFun(this, param);
			} else {
				return this.window(defs, param);
			}
		}
		defs = defs || {};
		return this.each(function() {
			var dialog = $.data(this, "dialog");
			if (dialog) {
				$.extend(dialog.defs, defs);
			} else {
				$.data(this, "dialog", {
				    defs : $.extend({}, $.fn.dialog.defaults, $.fn.dialog.getDefs(this), defs),
				    contentPanel : createContentPanel(this) });
			}
			create(this);
		});
	};
	$.fn.dialog.methods = {
	    defs : function(jq) {
		    var defs = $.data(jq[0], "dialog").defs;
		    var panelDefs = jq.panel("defs");
		    $.extend(defs, { closed : panelDefs.closed, collapsed : panelDefs.collapsed,
		        minimized : panelDefs.minimized, maximized : panelDefs.maximized });
		    return defs;
	    }, dialog : function(jq) {
		    return jq.window("window");
	    }, refresh : function(jq, url) {
		    return jq.each(function() {
			    refresh(this, url);
		    });
	    } };
	$.fn.dialog.getDefs = function(target) {
		return $.extend({}, $.fn.window.getDefs(target), $.parser.getDefs(target, [ "toolbar", "buttons" ]));
	};
	$.fn.dialog.defaults = $.extend({}, $.fn.window.defaults, { title : "New Dialog", collapsible : false,
	    minimizable : false, maximizable : false, resizable : false, toolbar : null, buttons : null });
})(jQuery);
