/**
 * iconvalidation - jQuery jwwUI Copyright (c) 2013-2015 www.jeeww.com. All
 * rights reserved. Licensed under the GPL or commercial licenses
 */
(function($) {
	function setSize(target, sizeValue) {
		var fileboxDefs = $.data(target, "filebox").defs;
		var fileboxObj = $.data(target, "filebox").filebox;
		if (sizeValue) {
			fileboxDefs.width = sizeValue;
		}
		var fileboxFileObj = fileboxObj.find("input.filebox-file");
		var fileboxTextObj = fileboxObj.find(".filebox-text");
		var fileboxIconObj = fileboxObj.find(".filebox-icon");
		var iconWidth = fileboxIconObj._outerWidth();
		var outerWidth = fileboxObj._outerWidth();
		var textWidth = outerWidth - iconWidth;
		fileboxTextObj._outerWidth(textWidth);
		var w = fileboxObj._outerWidth() - fileboxTextObj._outerWidth();
		fileboxFileObj._outerWidth(w);
	}
	;
	function setIconShowOrHide(target) {
		var fileboxDefs = $.data(target, "filebox").defs;
		var fileboxObj = $.data(target, "filebox").filebox;
		if (fileboxDefs.hasIcon) {
			fileboxObj.find(".filebox-icon").show();
		} else {
			fileboxObj.find(".filebox-icon").hide();
		}
	}
	;
	function createFileboxObj(target, defs) {
		$(target).addClass("filebox-f").hide();
		var fileboxObj = null;
		if (defs.cusCls) {
			fileboxObj = $("<span class=\"filebox\"></span>").addClass(defsTemp.cusCls);
		} else {
			fileboxObj = $("<span class=\"filebox\"></span>");
		}
		if (defs.border) {
			fileboxObj.addClass("filebox-border");
		}
		fileboxObj.insertAfter(target);
		var fileboxTextObj = $(
		        "<span><input type=\"text\" class=\"filebox-text\" readonly=\"readonly\"><input type=\"file\" class=\"filebox-file\"></span>")
		        .appendTo(fileboxObj);
		if (defs.iconCls) {
			$("<span class=\"filebox-icon\"></span>").addClass(defs.iconCls).appendTo(fileboxObj);
		} else {
			$("<span><span class=\"filebox-icon\"></span></span>").appendTo(fileboxObj);
		}
		var fileboxPropertyName = $(target).attr("name");
		if (fileboxPropertyName) {
			fileboxObj.find("input.filebox-file").attr("name", fileboxPropertyName);
			fileboxObj.find("input.filebox-text").attr("name", fileboxPropertyName + "_fileName");
			$(target).removeAttr("name").attr("name_ref", fileboxPropertyName).attr("name_ref_file",
			        fileboxPropertyName + "_fileName");
		}
		fileboxTextObj.attr("autocomplete", "off");
		return {
			filebox : fileboxObj
		};
	}
	;
	function destroy(target) {
		var fileboxTextObj = $.data(target, "filebox").filebox.find("input.filebox-file");
		fileboxTextObj.inputbox("destroy");
		$.data(target, "filebox").filebox.remove();
		$(target).remove();
	}
	;
	function bindEvents(target) {
		var fileboxObj = $.data(target, "filebox");
		var fileboxDefs = fileboxObj.defs;
		var fileboxObjInner = $.data(target, "filebox").filebox;
		var fileboxText = fileboxObjInner.find(".filebox-text");
		var fileboxFile = fileboxObjInner.find(".filebox-file");
		fileboxText.unbind(".filebox");
		fileboxFile.unbind(".filebox");
		if (!fileboxDefs.disabled) {
			fileboxFile.bind("click.filebox", function(e) {
			}).bind("change.filebox-file", function(e) {
				fileboxDefs.onChange.call(target, target, e, this.value);
			});
		}
	}
	;
	function validate(target, validateFlag) {
		var fileboxDefs = $.data(target, "filebox").defs;
		var fileboxObj = $.data(target, "filebox").filebox.find("input.filebox-text");
		if (fileboxDefs.border) {
			fileboxDefs.border = false;// remove inner border
		}
		fileboxObj.inputbox(fileboxDefs);
		if (validateFlag) {
			fileboxObj.inputbox("validate");
		}
	}
	;
	function setDisabled(target, flag) {
		var fileboxDefs = $.data(target, "filebox").defs;
		var fileboxObj = $.data(target, "filebox").filebox;
		if (flag) {
			fileboxDefs.disabled = true;
			$(target).attr("disabled", true);
			fileboxObj.find(".filebox-text").attr("disabled", true);
			fileboxObj.find(".filebox-file").attr("disabled", true);
		} else {
			fileboxDefs.disabled = false;
			$(target).removeAttr("disabled");
			fileboxObj.find(".filebox-text").removeAttr("disabled");
			fileboxObj.find(".filebox-file").removeAttr("disabled");
		}
	}
	;
	function clear(target) {
		var fileboxObj = $.data(target, "filebox").filebox;
		fileboxObj.find("input.filebox-text").val("");
		fileboxObj.find("input.filebox-file").val("");
	}
	;
	function getFileName(target) {
		var fileboxObj = $.data(target, "filebox").filebox;
		return fileboxObj.find("input.filebox-text").val();
	}
	;
	$.fn.filebox = function(defs, param) {
		if (typeof defs == "string") {
			return $.fn.filebox.methods[defs](this, param);
		}
		defs = defs || {};
		return this.each(function() {
			var fileboxObj = $.data(this, "filebox");
			if (fileboxObj) {
				$.extend(fileboxObj.defs, defs);
			} else {
				var newDefs = $.extend({}, $.fn.filebox.defaults, $.fn.filebox.getDefs(this),
				        defs);
				var r = createFileboxObj(this, newDefs);
				fileboxObj = $.data(this, "filebox", {
				    defs : newDefs,
				    filebox : r.filebox,
				    previousValue : null
				});
				$(this).removeAttr("disabled");
			}
			$("input.filebox-file", fileboxObj.filebox).attr("readonly", !fileboxObj.defs.editable);
			setIconShowOrHide(this);
			setDisabled(this, fileboxObj.defs.disabled);
			setSize(this);
			bindEvents(this);
			validate(this);
		});
	};
	$.fn.filebox.methods = {
	    defs : function(jq) {
		    return $.data(jq[0], "filebox").defs;
	    },
	    textbox : function(jq) {
		    return $.data(jq[0], "filebox").filebox.find("input.filebox-text");
	    },
	    destroy : function(jq) {
		    return jq.each(function() {
			    destroy(this);
		    });
	    },
	    resize : function(jq, width) {
		    return jq.each(function() {
			    setSize(this, width);
		    });
	    },
	    disable : function(jq) {
		    return jq.each(function() {
			    setDisabled(this, true);
			    bindEvents(this);
		    });
	    },
	    enable : function(jq) {
		    return jq.each(function() {
			    setDisabled(this, false);
			    bindEvents(this);
		    });
	    },
	    validate : function(jq) {
		    return jq.each(function() {
			    validate(this, true);
		    });
	    },
	    isValid : function(jq) {
		    var fileboxTextObj = $.data(jq[0], "filebox").filebox.find("input.filebox-text");
		    return fileboxTextObj.inputbox("isValid");
	    },
	    clear : function(jq) {
		    return jq.each(function() {
			    clear(this);
		    });
	    },
	    getValue : function(jq) {
		    return getFileName(jq[0]);
	    }
	};
	$.fn.filebox.getDefs = function(target) {
		var t = $(target);
		return $.extend({}, $.fn.inputbox.getDefs(target), $.parser.getDefs(target, [ "width",
		        "height", "separator", {
		            editable : "boolean",
		            hasIcon : "boolean",
		            delay : "number"
		        } ]), {
		    disabled : (t.attr("disabled") ? true : undefined),
		    value : (t.val() || undefined),
		    searcher : (t.attr("searcher") ? $.parser.localEval(t.attr("searcher")) : undefined)
		});
	};
	$.fn.filebox.defaults = $.extend({}, $.fn.inputbox.defaults, {
	    cusCls : null,
	    iconCls : null,
	    width : "auto",
	    height : 22,
	    editable : true,
	    border : false,
	    disabled : false,
	    hasIcon : true,
	    value : "",
	    delay : 200,
	    keyHandler : {
	        up : function() {
	        },
	        down : function() {
	        },
	        enter : function() {
	        },
	        query : function(q) {
	        }
	    },
	    onChange : function(target, e, v) {
		    $(target).parent().find(".filebox-text").val(v);
	    }
	});
})(jQuery);
